

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyFallenBehindCopies.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyFallenBehindCopies.sp,v $ $Id: RptSurveyFallenBehindCopies.sp,v 1.11.34.16 2020/12/17 02:52:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSurveyFallenBehindCopies')
BEGIN
	print '>>> Drop Stored Procedure: RptSurveyFallenBehindCopies <<<'
	drop procedure RptSurveyFallenBehindCopies
END
IF EXISTS (select * from GxQscripts where name='RptSurveyFallenBehindCopies')
	delete from GxQscripts where name = 'RptSurveyFallenBehindCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyFallenBehindCopies')
	delete from GXDBVersions where aliasname = 'RptSurveyFallenBehindCopies'
GO
print '... Creating Procedure: RptSurveyFallenBehindCopies'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSurveyFallenBehindCopies
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
DECLARE @i_QueryId BIGINT = 64
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
IF(@blaggregate=1)
BEGIN
	RETURN
END
ELSE
BEGIN
	DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
	DECLARE @criticalVal int
	DECLARE @warningVal int
	SELECT	@warningVal = WarningThreshold,
			@criticalVal =CriticalThreshold
	FROM	cf_SurveyHealthParam where queryId = @i_QueryId
	--get the SurveyResultId of the latest survey that ran on the given commmcell
	DECLARE @SurveyResultId BIGINT
	SELECT @SurveyResultId = SurverResultId from dbo.cf_SurveyResultFuncV1(250,@i_CommServUniqueID,1,null,null,@i_UserId,0)
	--if no data is collected, return empty table for aggregated values
	IF (ISNULL(@SurveyResultId,0) = 0 AND @blaggregate = 0 AND OBJECT_ID('tempdb..#SecurityAssociationSummary') IS NOT NULL)
	BEGIN
				RETURN
	END
	--get IP of commcell
	DECLARE @IP varchar(1024)
	SELECT TOP 1 @IP = WebConsoleURL from cf_WebConsoleURL CWU
		INNER JOIN dbo.cf_SurveyResultFuncV1(160,@i_CommServUniqueID,1,null,null,@i_UserId,0) SRF
		ON SRF.SurverResultId = CWU.SurveyResultId
	IF (@IP IS NULL OR @IP = 'N/A')
    BEGIN
		DECLARE @CsIpAddress nvarchar(50)
		SELECT @CsIpAddress = CurrCSIpAddress FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE ID = @i_CommServUniqueID
		IF ((SELECT charindex(',', @CsIpAddress)) > 0)
			SELECT @CsIpAddress = LEFT(@CsIpAddress,charindex(',', @CsIpAddress) - 1)
		SELECT @IP =  CONCAT('http://',@CsIpAddress, '/webconsole') from cf_CommcellIdNameMap WITH (NOLOCK) where ID = @i_CommServUniqueID
    END
	IF(DB_ID('commserv')IS NOT NULL)
    BEGIN
    --check if local or remote machine
    IF EXISTS (select 1 from cf_CommcellIdNameMap CCNM
        INNER JOIN commserv.dbo.APP_CommCell AC ON CCNM.CommServGUID = AC.csGUID
        WHERE AC.id = 2 AND CCNM.ID = @i_CommServUniqueID)
            SET @IP = '../..'
    END
	--check if it is private or cloud metrics reporting
	DECLARE @isPrivate  INT = 0
	SELECT  @isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NOLOCK) WHERE Name = 'isPrivate'
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.DisplayName AS 'CommCell Name',
		C.PolicyName AS 'Storage Policy',
		C.CopyName AS 'Storage Policy Copy',
		csInfo.FallenBehindDays AS 'Days Since Oldest Job',
		ISNULL(csInfo.FallenBehindJobCount, -1)  AS 'Fallen Behind Jobs<NumberNA><HIDDEN>',
		ISNULL(csInfo.FallenBehindAppSizeMB, -1) AS 'Fallen Behind App Size<SIZEMB><HIDDEN>',
		csInfo.JobsToCopyCount AS 'Total Jobs to Copy',
		csInfo.OldestJobId AS 'Oldest JobId<HIDDEN>',
		CASE WHEN csInfo.OldestJobStartTime <= '01/01/1970' THEN -50
			 ELSE datediff(second, '01/01/1970', csInfo.OldestJobStartTime) END AS 'Oldest Job Start Time<MMMDDYYYYHrMinAM><HIDDEN>',
		CAST(ISNULL(csInfo.TotalToBeCopiedJobsApplicationSizeGB*1024.0, -1) AS DECIMAL(32,2)) AS 'Total App Size To Be Copied<SIZEMB>',
		CAST(ISNULL(csInfo.EstTotalToBeCopiedJobsMediaSizeGB*1024.0, -1) AS DECIMAL(32,2)) AS 'Estimated Media Size To Be Copied<SIZEMB>',
		CASE ISNULL(csInfo.EstCompletionDateForAllData, -100) WHEN -100 THEN -50 -- -50: N/A
			WHEN -2	THEN -4 -- -4: 'History unavailable to estimate time'
			WHEN -3 THEN -5	-- -5: 'Jan 1, 2038'
			ELSE csInfo.EstCompletionDateForAllData END
		 AS 'DR Ready As Of (Estimated Completion Date)<MMMDDYYYY>',
		CASE
			WHEN ISNULL(csInfo.AuxCopyAlertGB, -1) > -1 AND ISNULL(csInfo.TotalToBeCopiedJobsApplicationSizeGB, -1) > csInfo.AuxCopyAlertGB THEN @strCritical
			WHEN ISNULL(csInfo.AuxCopyAlertDays, -1) > -1 AND csInfo.FallenBehindDays > csInfo.AuxCopyAlertDays THEN @strCritical
			WHEN ISNULL(csInfo.AuxCopyAlertDays, -1) > -1 AND csInfo.FallenBehindDays <= csInfo.AuxCopyAlertDays
				AND csInfo.CorruptedJobsCountOnSrcCopy = 0 THEN @strGood
			WHEN ISNULL(csInfo.AuxCopyAlertDays, -1) = -1 AND csInfo.FallenBehindDays > @criticalVal THEN @strCritical
			WHEN (ISNULL(csInfo.AuxCopyAlertDays, -1) = -1 AND csInfo.FallenBehindDays >= @warningVal AND csInfo.FallenBehindDays <= @criticalVal)
				OR csInfo.CorruptedJobsCountOnSrcCopy > 0 THEN @strWarning
			ELSE @strGood
		END as 'Status<HEALTH_STATUS>',
		ISNULL(CAST(csInfo.AuxCopyAlertGB/1024.0 AS DECIMAL(32,2)), -1) AS 'Copy Alert Threshold (TB)<NumberNA><HIDDEN>',
		ISNULL(csInfo.AuxCopyAlertDays, -1) AS 'Copy Alert Threshold (Days)<NumberNA><HIDDEN>',
		csInfo.ActiveJobId AS 'Active AuxCopy JobId<HIDDEN>',
		CASE ISNULL(csInfo.AuxCopyScheduled,-1) WHEN 1 THEN 'Yes' WHEN 0 THEN 'No' ELSE 'N/A' END AS 'AuxCopy Scheduled<HIDDEN>',
		CASE WHEN csInfo.ActiveJobStartTime IS NULL THEN -100 WHEN csInfo.ActiveJobStartTime <= '01/01/1970' THEN -50
			 ELSE datediff(second, '01/01/1970', csInfo.ActiveJobStartTime) END AS 'Active AuxCopy Job Start Time<MMMDDYYYYHrMinAM>',
		csInfo.ActiveJobState AS 'Active AuxCopy Job State',
		csInfo.ActiveJobProgress AS 'Active AuxCopy Job Progress (%)',
		csInfo.ActiveJobDelayReason AS 'Active AuxCopy Job Delay Reason',
		--csInfo.CorruptedJobsCountOnSrcCopy AS 'Corrupted Jobs Count On Source'
		(CASE WHEN @isPrivate = 0 OR csInfo.CorruptedJobsCountOnSrcCopy = 0 THEN CAST(csInfo.CorruptedJobsCountOnSrcCopy  AS VARCHAR(10))
			  ELSE '<a href="'+@IP+'/reportsplus/reportViewer.jsp?reportId=CorruptedJobsOnSourceCopy&input.CommCell=2&input.StoragePolicyCopy=%5B%22' + C.PolicyName + '/' + C.CopyName+ '%22%5D" target="_blank" >' + CAST(csInfo.CorruptedJobsCountOnSrcCopy  AS VARCHAR(10)) + '</a>'
		END)
			AS 'Corrupted Jobs Count On Source'
	FROM cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK)
			ON C.CommServUniqueId = resultView.CommServUniqueId AND C.CopyId = csInfo.CopyId
	WHERE csInfo.EstCompletionDateForAllData <> -1
	ORDER BY resultView.LogDate DESC, csInfo.FallenBehindDays DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSurveyFallenBehindCopies')
	delete from GxQscripts where name = 'RptSurveyFallenBehindCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyFallenBehindCopies')
	delete from GXDBVersions where aliasname = 'RptSurveyFallenBehindCopies'
GO

insert into GXDBVersions values(2, 'RptSurveyFallenBehindCopies',  '00010011003400160000', 'RptSurveyFallenBehindCopies', '00010011003400160000')
GO

