

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSurveyDDBPerformance.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSurveyDDBPerformance.sp,v $ $Id: RptSurveyDDBPerformance.sp,v 1.14.14.20 2020/12/18 10:35:21 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSurveyDDBPerformance')
BEGIN
	print '>>> Drop Stored Procedure: RptSurveyDDBPerformance <<<'
	drop procedure RptSurveyDDBPerformance
END
IF EXISTS (select * from GxQscripts where name='RptSurveyDDBPerformance')
	delete from GxQscripts where name = 'RptSurveyDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPerformance')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPerformance'
GO
print '... Creating Procedure: RptSurveyDDBPerformance'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSurveyDDBPerformance
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_blaggregate INT = 1,
  @i_bLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL,
  @i_SidbStoreId INT = 0
AS
BEGIN
-- i_blaggregate: 1 - daily, 2 - weekly, 3 - monthly
-- i_bLatestSurvey: 1 - latest, >1 for number of intervals in chart
DECLARE @i_QueryId  BIGINT	= 65
DECLARE @i_QueryId2 BIGINT	= 35    -- MT 172535  This is for getting latest SurveyId for 'cf_SurveyDeDupDeletedAFCount'
SET NOCOUNT ON
DECLARE	@bLatestSurvey INT = CASE WHEN @i_blaggregate = 0 OR @i_bLatestSurvey > 0 THEN 1 ELSE 0 END
IF object_id('tempdb.dbo.#tmpStoreInfo') IS NOT null DROP TABLE #tmpStoreInfo
create table #tmpStoreInfo
(
   CommServUniqueID int,
   LogDate date,
   sidbStoreId  int,
   sidbStoreName nvarchar(256),
   sealedStatus varchar(16)
)
IF	(@i_blaggregate >= 1)
BEGIN
	INSERT INTO #tmpStoreInfo
	SELECT	DISTINCT P.CommServUniqueId, P.LogDate, P.SidbStoreId, P.SidbStoreName, 0
	FROM	cf_SurveyDDBPerformance P
			INNER JOIN cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) R
				ON P.SurveyResultId = R.SurverResultId
	DECLARE @ChartFromDate	DATE
	DECLARE @ChartToDate	DATE = @i_LogDateEnd
	DECLARE @ChartIntervals INT  = @i_bLatestSurvey
	DECLARE @ChartInterval	TABLE (BeginDate DATE, EndDate DATE, Name VARCHAR(32))
	IF	@ChartToDate IS NULL
		SET @ChartToDate = (SELECT MAX(LogDate) FROM #tmpStoreInfo)
	SET @ChartToDate = CASE @i_blaggregate
			WHEN 1 THEN DATEADD(DD, DATEDIFF(DD, 0, @ChartToDate)+1, 0)
			WHEN 2 THEN DATEADD(WK, DATEDIFF(WK, 0, @ChartToDate)+1, 0)
			WHEN 3 THEN DATEADD(MM, DATEDIFF(MM, 0, @ChartToDate)+1, 0)
		END
	DECLARE @i INT = 0
	WHILE @i < @ChartIntervals
	BEGIN
		SET @ChartFromDate = CASE @i_blaggregate
				WHEN 1 THEN DATEADD(DD, -1, @ChartToDate)
				WHEN 2 THEN DATEADD(WK, -1, @ChartToDate)
				WHEN 3 THEN DATEADD(MM, -1, @ChartToDate)
			END
		INSERT INTO @ChartInterval
		SELECT	@ChartFromDate, @ChartToDate, ''
		SET @ChartToDate = @ChartFromDate
		SET @i += 1
	END
	SELECT	CommServUniqueId AS 'CommServ UniqueId',
			CommservName AS'CommCell Name',
			SidbStoreId AS 'DDB ID',
			SidbStoreName AS 'DDB Name',
			BeginDate AS 'Interval',
			AvgQITime AS 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
			PrimaryRecords AS 'DDB Primary Block Count<FORMATNUMBERNA>',
			SecondaryRecords AS 'DDB Secondary Block Count<FORMATNUMBERNA>',
			ZeroRefCount AS 'DDB Prunable Block Count<FORMATNUMBERNA>',
			TotalDataSizeMB AS 'Total Data Size<SIZEMB>',
			InstancedDataSizeMB AS 'Deduped Data Size<SIZEMB>',
			FrontendBackupMB AS 'Front End Backup Size<SIZEMB>',
			FrontendArchiveMB AS 'Front End Archive Size<SIZEMB>',
--      UnComment out below to add baseline/pending records
	--		BaseLineSizeMB AS 'Baseline Size<SIZEMB>',	 -- MR 1172535
	--		PendingDeletes AS 'Pending Deletes',
			DDBSizeMB AS 'Size of DDB <SIZEMB>',
			AppSizeMB AS 'App Size<SIZEMB>',
			SizeOnMediaMB AS 'Size on Media<SIZEMB>',
			DedupeSavingPct AS 'Dedupe Saving (%)'
	FROM
			(SELECT	BeginDate, S.CommServUniqueId, S.SidbStoreId, S.SidbStoreName,
					ISNULL(AvgQITime, -1) AS AvgQITime,
					ISNULL(PrimaryRecords, -1) AS PrimaryRecords,
					ISNULL(SecondaryRecords, -1) AS SecondaryRecords,
					ISNULL(ZeroRefCount, -1) AS ZeroRefCount,
					ISNULL(TotalDataSizeMB, -1) AS TotalDataSizeMB,
					ISNULL(InstancedDataSizeMB, -1) AS InstancedDataSizeMB,
					ISNULL(FrontendBackupMB, -1) AS FrontendBackupMB,
					ISNULL(FrontendArchiveMB, -1) AS FrontendArchiveMB,
					ISNULL(BaseLineSizeMB, -1) AS BaseLineSizeMB,		--- MR 1172535
--					ISNULL(DeletedAFCount, -1) As PendingDeletes,        --20180926
					ISNULL(DDBSizeMB, -1) AS DDBSizeMB,
					ISNULL(AppSizeMB, -1) AS AppSizeMB,
					ISNULL(AppSizeMB*DedupeRatio, -1) AS SizeOnMediaMB,
					CASE WHEN ISNULL(DedupeRatio, -1) > 0 THEN CAST(100.0*(1.0 - DedupeRatio) AS DECIMAL(20,2)) ELSE 0 END AS DedupeSavingPct,
					ROW_NUMBER() OVER (PARTITION BY BeginDate, S.CommServUniqueId, S.SidbStoreId, S.SidbStoreName ORDER BY P.LogDate DESC) AS rowId
			FROM
					@ChartInterval I CROSS JOIN #tmpStoreInfo S
					LEFT OUTER JOIN cf_SurveyDDBPerformance AS P WITH (NOLOCK)
						ON S.CommServUniqueID = P.CommServUniqueID AND S.SidbStoreId = P.SidbStoreId
							AND P.LogDate >= I.BeginDate AND P.LogDate < I.EndDate
--      UnComment out below to add baseline/pending records
--					LEFT OUTER JOIN cf_SurveyDeDupDeletedAFCount AF  WITH (NOLOCK)     	 -- MR 172535
--						ON S.CommServUniqueID = AF.CommServUniqueID AND S.SidbStoreId = AF.SidbStoreId
--							AND AF.LogDate >= I.BeginDate AND AF.LogDate < I.EndDate
--					INNER JOIN  dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView2
--						ON resultView2.SurverResultId = AF.SurveyResultId
			) T
			INNER JOIN cf_CommcellIdNameMap CC ON T.CommServUniqueId = CC.ID
	WHERE	rowId = 1
	ORDER BY SidbStoreName, BeginDate
	DROP TABLE #tmpStoreInfo
	RETURN
END
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strAttention VARCHAR(10) = '1a_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int=0
DECLARE @warningVal int=0
SELECT	@warningVal = WarningThreshold,
		@criticalVal =CriticalThreshold
FROM	cf_SurveyHealthParam where queryId = @i_QueryId
insert into #tmpStoreInfo
select distinct sidb.CommServUniqueId, sidb.LogDate, sidb.SIDBStoreId,SIDB.SIDBStoreAliasName , sidb.SealedStatus from cf_SurveyDeDupStoreConfig sidb
inner join  cf_SurveyResultFuncV1(61,@i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) csInfo
on sidb.SurveyResultId = csInfo.SurverResultId
IF object_id('tempdb.dbo.#thresholdTbl') IS NOT null
	DROP TABLE #thresholdTbl
create table #thresholdTbl
(
	CommServUniqueId int,
	warningThreshold int,
	criticalThreshold int
)
insert into #thresholdTbl
select A.CommServUniqueId, isnull(A.AvgQITimeWarningLimit, @warningVal), isnull(B.AvgQITimeCriticalLimit, @criticalVal)
from
(SELECT distinct tsInfo.CommServUniqueId, cast(attrval as int) as 'AvgQITimeWarningLimit'
FROM cf_SurveyCommcellThresholdInfo (NOLOCK) tsInfo
WHERE ENTITYID =1 AND attrName ='AvgQITimeWarningLimit' and attrtype =10) as A
left join
(SELECT distinct tsInfo.CommServUniqueId, cast(attrval as int) as 'AvgQITimeCriticalLimit'
FROM cf_SurveyCommcellThresholdInfo (NOLOCK) tsInfo
WHERE ENTITYID =1 AND attrName ='AvgQITimeCriticalLimit' and attrtype =10) as B
on A.CommServUniqueId = B.CommServUniqueId
IF @i_CommServUniqueID = 0 AND @i_SidbStoreId = 0
BEGIN
	IF((SELECT SUM(NeedUpgrade) FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId) = 0)
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL(copy.PolicyName, '') AS 'Storage Policy<HIDDEN>',
		ISNULL(copy.CopyName, '') AS 'Copy<HIDDEN>',
		ISNULL(copy.DefaultLibrary, '') AS 'Library<HIDDEN>',
		csInfo.SidbStoreId AS 'DDB Id<DONOTSHOW>',
		csInfo.SidbStoreName AS 'DDB Name<partitionInfo>',
		ISNULL(csInfo.MediaAgentNames, '') AS 'MediaAgent(s)<HIDDEN>',
		ISNULL(dbo.GetUnixTimeBig(csInfo.CreatedTime), 0) as 'Created Time<DATETIME><HIDDEN>',
		csInfo.AvgQITime as 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
		ISNULL(csInfo.PrimaryRecords,-1 ) as 'DDB Primary Block Count<FORMATNUMBERNA>',
		ISNULL(csInfo.SecondaryRecords,-1 ) as 'DDB Secondary Block Count<FORMATNUMBERNA><HIDDEN>',
		ISNULL(csInfo.ZeroRefCount,-1 ) as 'DDB Prunable Block Count<FORMATNUMBERNA><HIDDEN>',
		ISNULL(csInfo.TotalDataSizeMB, -1) AS 'Total Data Size<SIZEMB>',
		ISNULL(csInfo.InstancedDataSizeMB, -1) AS 'Deduped Data Size<SIZEMB><HIDDEN>',
		ISNULL(csInfo.FrontendBackupMB,-1) as 'Front End Backup Size<SIZEMB>',
		ISNULL(csInfo.FrontendArchiveMB,-1) as 'Front End Archive Size<SIZEMB><HIDDEN>',
--      UnComment out below to add baseline/pending records
--		ISNULL(csInfo.BaseLineSizeMB,-1) as 'Baseline Size<SIZEMB>',   -- MR 172535
--		ISNULL(AF.DeletedAFCount,-1) as 'Pending Deletes',
		ISNULL(csInfo.AppSizeMB,-1) as 'App Size<SIZEMB><HIDDEN>',
		CAST(ISNULL(csInfo.AppSizeMB*csInfo.DedupeRatio,-1) AS BIGINT) as 'Size on Media<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(csInfo.DedupeRatio,-1) > 0 THEN CAST(100.0*(1.0 - csInfo.DedupeRatio) AS DECIMAL(20,2)) ELSE 0 END as 'Dedupe Saving (%)',
		ISNULL(csInfo.DDBSizeMB, -1) as 'Size of DDB <SIZEMB>',
		ISNULL(dbo.GetUnixTimeBig(csInfo.LastRecordedTime), 0) as 'Last Recorded Time<DATETIME>',
		ISNULL(SInfo.sealedStatus,'') as 'DDB Status',
		csInfo.Readiness AS 'Readiness',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=100000000
					then @strWarning
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=200000000
					then @strCritical
					else @strWarning
				end
		end as 'Status<HEALTH_STATUS>',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=100000000
					then 'Average Q&I time or Partition Primary Block count reached warning threshold'
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=200000000
					then 'Average Q&I time or Partition Primary Block count reached critical threshold'
					else 'Average Q&I time or Partition Primary Block count reached warning threshold'
				end
		end as 'HealthStatusDescription<DONOTSHOW>',
		ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalVal)  AS 'Critical Threshold for Average Q&I Time <HIDDEN>',
		ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningVal)  AS 'Warning Threshold for Average Q&I Time <HIDDEN>'
	FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		LEFT OUTER JOIN cf_SurveyCopyBasicRetention copy WITH (NOLOCK)
			ON copy.CommServUniqueID = csInfo.CommServUniqueID AND copy.CopyId = csInfo.CopyId
		LEFT OUTER JOIN #tmpStoreInfo SInfo
			ON SInfo.CommServUniqueID = csInfo.CommServUniqueID
					and SInfo.sidbStoreId = csInfo.sidbStoreId
		LEFT OUTER JOIN #thresholdTbl TInfo
			ON TInfo.CommServUniqueID = csInfo.CommServUniqueID
	ORDER BY [Status<HEALTH_STATUS>] DESC, csInfo.AvgQITime DESC, 'CommCell Name' ASC
	END
	ELSE
	BEGIN
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			resultView.DisplayName AS 'CommCell Name',
			ISNULL(copy.PolicyName, '') AS 'Storage Policy<HIDDEN>',
			ISNULL(copy.CopyName, '') AS 'Copy<HIDDEN>',
			ISNULL(copy.DefaultLibrary, '') AS 'Library<HIDDEN>',
			csInfo.SidbStoreId AS 'DDB Id<DONOTSHOW>',
			csInfo.SidbStoreName AS 'DDB Name<partitionInfo>',
			ISNULL(csInfo.MediaAgentNames, '') AS 'MediaAgent(s)<HIDDEN>',
			ISNULL(dbo.GetUnixTimeBig(csInfo.CreatedTime), 0) as 'Created Time<DATETIME><HIDDEN>',
			csInfo.AvgQITime as 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
			ISNULL(csInfo.PrimaryRecords,-1 ) as 'DDB Primary Block Count<FORMATNUMBERNA>',
			ISNULL(csInfo.SecondaryRecords,-1 ) as 'DDB Secondary Block Count<FORMATNUMBERNA><HIDDEN>',
			ISNULL(csInfo.ZeroRefCount,-1 ) as 'DDB Prunable Block Count<FORMATNUMBERNA><HIDDEN>',
			ISNULL(csInfo.TotalDataSizeMB, -1) AS 'Total Data Size<SIZEMB>',
			ISNULL(csInfo.InstancedDataSizeMB, -1) AS 'Deduped Data Size<SIZEMB><HIDDEN>',
			ISNULL(csInfo.FrontendBackupMB,-1) as 'Front End Backup Size<SIZEMB>',
			ISNULL(csInfo.FrontendArchiveMB,-1) as 'Front End Archive Size<SIZEMB><HIDDEN>',
	--      UnComment out below to add baseline/pending records
	--		ISNULL(csInfo.BaseLineSizeMB,-1) as 'Baseline Size<SIZEMB>',   -- MR 172535
	--		ISNULL(AF.DeletedAFCount,-1) as 'Pending Deletes',
			ISNULL(csInfo.AppSizeMB,-1) as 'App Size<SIZEMB><HIDDEN>',
			CAST(ISNULL(csInfo.AppSizeMB*csInfo.DedupeRatio,-1) AS BIGINT) as 'Size on Media<SIZEMB><HIDDEN>',
			CASE WHEN ISNULL(csInfo.DedupeRatio,-1) > 0 THEN CAST(100.0*(1.0 - csInfo.DedupeRatio) AS DECIMAL(20,2)) ELSE 0 END as 'Dedupe Saving (%)',
			ISNULL(csInfo.DDBSizeMB, -1) as 'Size of DDB <SIZEMB>',
			ISNULL(dbo.GetUnixTimeBig(csInfo.LastRecordedTime), 0) as 'Last Recorded Time<DATETIME>',
			ISNULL(SInfo.sealedStatus,'') as 'DDB Status',
			csInfo.Readiness AS 'Readiness',
			case when NeedUpgrade = 1 THEN @strwarning
				when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
				then @strGood
				when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
				then
					case
						when csInfo.PrimaryRecords>=100000000
						then @strWarning
						else @strGood
					end
				else
					case
						when csInfo.PrimaryRecords>=200000000
						then @strCritical
						else @strWarning
					end
			end as 'Status<HEALTH_STATUS>',
			case
				when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
				then @strGood
				when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
				then
					case
						when csInfo.PrimaryRecords>=100000000
						then 'Average Q&I time or Partition Primary Block count reached warning threshold'
						else @strGood
					end
				else
					case
						when csInfo.PrimaryRecords>=200000000
						then 'Average Q&I time or Partition Primary Block count reached critical threshold'
						else 'Average Q&I time or Partition Primary Block count reached warning threshold'
					end
			end as 'HealthStatusDescription<DONOTSHOW>',
			ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalVal)  AS 'Critical Threshold for Average Q&I Time <HIDDEN>',
			ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningVal)  AS 'Warning Threshold for Average Q&I Time <HIDDEN>',
			CASE WHEN NeedUpgrade = 1 THEN '<a class="linkClass" target="_blank" href="https://cloud.commvault.com/webconsole/softwarestore/#!/136/672/15280">Yes</a>' ELSE 'No' END AS 'Need Upgrade'
		FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN cf_SurveyCopyBasicRetention copy WITH (NOLOCK)
				ON copy.CommServUniqueID = csInfo.CommServUniqueID AND copy.CopyId = csInfo.CopyId
			LEFT OUTER JOIN #tmpStoreInfo SInfo
				ON SInfo.CommServUniqueID = csInfo.CommServUniqueID
						and SInfo.sidbStoreId = csInfo.sidbStoreId
			LEFT OUTER JOIN #thresholdTbl TInfo
				ON TInfo.CommServUniqueID = csInfo.CommServUniqueID
		ORDER BY [Status<HEALTH_STATUS>] DESC, csInfo.AvgQITime DESC, 'CommCell Name' ASC
	END
END
-- Changes for MR 172535 Go Here!  _SKatz 20180416
ELSE IF @i_CommServUniqueID <> 0 AND @i_SidbStoreId = 0
BEGIN
	IF((SELECT SUM(NeedUpgrade) FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId) = 0)
	BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
		resultView.CommCellID AS 'CommCell ID<DONOTSHOW>',
		resultView.DisplayName AS 'CommCell Name<DONOTSHOW>',
		ISNULL(copy.PolicyName, '') AS 'Storage Policy<HIDDEN>',
		ISNULL(copy.CopyName, '') AS 'Copy<HIDDEN>',
		ISNULL(copy.DefaultLibrary, '') AS 'Library<HIDDEN>',
		csInfo.SidbStoreId AS 'DDB Id<HIDDEN>',
		csInfo.SidbStoreName AS 'DDB Name<partitionInfo>',
		ISNULL(csInfo.MediaAgentNames, '') AS 'MediaAgent(s)', -- 'MediaAgent(s)<HIDDEN>', (SK Test)
		ISNULL(dbo.GetUnixTimeBig(csInfo.CreatedTime), 0) as 'Created Time<DATETIME><HIDDEN>',
		csInfo.AvgQITime as 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
		ISNULL(csInfo.PrimaryRecords,-1 ) as 'DDB Primary Block Count<FORMATNUMBERNA>',
		ISNULL(csInfo.SecondaryRecords,-1 ) as 'DDB Secondary Block Count<FORMATNUMBERNA><HIDDEN>',
		ISNULL(csInfo.ZeroRefCount,-1 ) as 'DDB Prunable Block Count<FORMATNUMBERNA><HIDDEN>',
		ISNULL(csInfo.TotalDataSizeMB, -1) AS 'Total Data Size<SIZEMB>',
		ISNULL(csInfo.InstancedDataSizeMB, -1) AS 'Deduped Data Size<SIZEMB><HIDDEN>',
		ISNULL(csInfo.FrontendBackupMB,-1) as 'Front End Backup Size<SIZEMB>',
		ISNULL(csInfo.FrontendArchiveMB,-1) as 'Front End Archive Size<SIZEMB>',
		ISNULL(csInfo.BaseLineSizeMB,-1) as 'Baseline Size<SIZEMB>',   -- mr 172535
		ISNULL(AF2.DeletedAFCount,-1) as 'Pending Record Deletes',     --MR 261100
		ISNULL(csInfo.AppSizeMB,-1) as 'App Size<SIZEMB><HIDDEN>',
		CAST(ISNULL(csInfo.AppSizeMB*csInfo.DedupeRatio,-1) AS BIGINT) as 'Size on Media<SIZEMB><HIDDEN>',
		CASE WHEN ISNULL(csInfo.DedupeRatio,-1) > 0 THEN CAST(100.0*(1.0 - csInfo.DedupeRatio) AS DECIMAL(20,2)) ELSE 0 END as 'Dedupe Saving (%)',
		ISNULL(csInfo.DDBSizeMB, -1) as 'Size of DDB <SIZEMB>',
		ISNULL(dbo.GetUnixTimeBig(csInfo.LastRecordedTime), 0) as 'Last Recorded Time<DATETIME>',
		ISNULL(SInfo.sealedStatus,'') as 'DDB Status',
		csInfo.Readiness AS 'Readiness',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=100000000
					then @strWarning
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=200000000
					then @strCritical
					else @strWarning
				end
		end as 'Status<HEALTH_STATUS>',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=100000000
					then 'Average Q&I time or Partition Primary Block count reached warning threshold'
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=200000000
					then 'Average Q&I time or Partition Primary Block count reached critical threshold'
					else 'Average Q&I time or Partition Primary Block count reached warning threshold'
				end
		end as 'HealthStatusDescription<DONOTSHOW>',
		ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalVal)  AS 'Critical Threshold for Average Q&I Time <HIDDEN>',
		ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningVal)  AS 'Warning Threshold for Average Q&I Time <HIDDEN>',
		case
			when csInfo.ExtendedFlags & 4 != 0
			then 'Enabled'
			else 'Disabled'
		end as 'Garbage Collection'
	FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
		LEFT OUTER JOIN cf_SurveyCopyBasicRetention copy WITH (NOLOCK)
			ON copy.CommServUniqueID = csInfo.CommServUniqueID AND copy.CopyId = csInfo.CopyId
		LEFT OUTER JOIN #tmpStoreInfo SInfo
			ON SInfo.CommServUniqueID = csInfo.CommServUniqueID
				and SInfo.sidbStoreId = csInfo.sidbStoreId
		LEFT OUTER JOIN (   -- MR : 261100
                            select AF.CommServUniqueID as  CommServUniqueID,
                                   AF.sidbStoreId as sidbStoreId,
                                   AF.DeletedAFCount as DeletedAFCount
                            from  cf_SurveyDeDupDeletedAFCount AS AF WITH (NOLOCK)   -- MR 172535            xxxx
                            inner join  dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView2
                            ON resultView2.SurverResultId = AF.SurveyResultId )AF2
		ON AF2.CommServUniqueID = csInfo.CommServUniqueID
		AND csInfo.sidbStoreId = AF2.sidbStoreId
		LEFT OUTER JOIN #thresholdTbl TInfo
			ON TInfo.CommServUniqueID = csInfo.CommServUniqueID
	ORDER BY [Status<HEALTH_STATUS>] DESC, csInfo.AvgQITime DESC
	END
	ELSE
	BEGIN
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId<DONOTSHOW>',
			resultView.CommCellID AS 'CommCell ID<DONOTSHOW>',
			resultView.DisplayName AS 'CommCell Name<DONOTSHOW>',
			ISNULL(copy.PolicyName, '') AS 'Storage Policy<HIDDEN>',
			ISNULL(copy.CopyName, '') AS 'Copy<HIDDEN>',
			ISNULL(copy.DefaultLibrary, '') AS 'Library<HIDDEN>',
			csInfo.SidbStoreId AS 'DDB Id<HIDDEN>',
			csInfo.SidbStoreName AS 'DDB Name<partitionInfo>',
			ISNULL(csInfo.MediaAgentNames, '') AS 'MediaAgent(s)', -- 'MediaAgent(s)<HIDDEN>', (SK Test)
			ISNULL(dbo.GetUnixTimeBig(csInfo.CreatedTime), 0) as 'Created Time<DATETIME><HIDDEN>',
			csInfo.AvgQITime as 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
			ISNULL(csInfo.PrimaryRecords,-1 ) as 'DDB Primary Block Count<FORMATNUMBERNA>',
			ISNULL(csInfo.SecondaryRecords,-1 ) as 'DDB Secondary Block Count<FORMATNUMBERNA><HIDDEN>',
			ISNULL(csInfo.ZeroRefCount,-1 ) as 'DDB Prunable Block Count<FORMATNUMBERNA><HIDDEN>',
			ISNULL(csInfo.TotalDataSizeMB, -1) AS 'Total Data Size<SIZEMB>',
			ISNULL(csInfo.InstancedDataSizeMB, -1) AS 'Deduped Data Size<SIZEMB><HIDDEN>',
			ISNULL(csInfo.FrontendBackupMB,-1) as 'Front End Backup Size<SIZEMB>',
			ISNULL(csInfo.FrontendArchiveMB,-1) as 'Front End Archive Size<SIZEMB>',
			ISNULL(csInfo.BaseLineSizeMB,-1) as 'Baseline Size<SIZEMB>',   -- mr 172535
			ISNULL(AF2.DeletedAFCount,-1) as 'Pending Record Deletes',     --MR 261100
			ISNULL(csInfo.AppSizeMB,-1) as 'App Size<SIZEMB><HIDDEN>',
			CAST(ISNULL(csInfo.AppSizeMB*csInfo.DedupeRatio,-1) AS BIGINT) as 'Size on Media<SIZEMB><HIDDEN>',
			CASE WHEN ISNULL(csInfo.DedupeRatio,-1) > 0 THEN CAST(100.0*(1.0 - csInfo.DedupeRatio) AS DECIMAL(20,2)) ELSE 0 END as 'Dedupe Saving (%)',
			ISNULL(csInfo.DDBSizeMB, -1) as 'Size of DDB <SIZEMB>',
			ISNULL(dbo.GetUnixTimeBig(csInfo.LastRecordedTime), 0) as 'Last Recorded Time<DATETIME>',
			ISNULL(SInfo.sealedStatus,'') as 'DDB Status',
			csInfo.Readiness AS 'Readiness',
			case when NeedUpgrade = 1 THEN @strwarning
				when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
				then @strGood
				when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
				then
					case
						when csInfo.PrimaryRecords>=100000000
						then @strWarning
						else @strGood
					end
				else
					case
						when csInfo.PrimaryRecords>=200000000
						then @strCritical
						else @strWarning
					end
			end as 'Status<HEALTH_STATUS>',
			case
				when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
				then @strGood
				when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
				then
					case
						when csInfo.PrimaryRecords>=100000000
						then 'Average Q&I time or Partition Primary Block count reached warning threshold'
						else @strGood
					end
				else
					case
						when csInfo.PrimaryRecords>=200000000
						then 'Average Q&I time or Partition Primary Block count reached critical threshold'
						else 'Average Q&I time or Partition Primary Block count reached warning threshold'
					end
			end as 'HealthStatusDescription<DONOTSHOW>',
			ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalVal)  AS 'Critical Threshold for Average Q&I Time <HIDDEN>',
			ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId =csInfo.CommServUniqueID  AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningVal)  AS 'Warning Threshold for Average Q&I Time <HIDDEN>',
			case
				when csInfo.ExtendedFlags & 4 != 0
				then 'Enabled'
				else 'Disabled'
			end as 'Garbage Collection',
			CASE WHEN NeedUpgrade = 1 THEN '<a class="linkClass" target="_blank" href="https://cloud.commvault.com/webconsole/softwarestore/#!/136/672/15280">Yes</a>' ELSE 'No' END AS 'Need Upgrade'
		FROM cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			LEFT OUTER JOIN cf_SurveyCopyBasicRetention copy WITH (NOLOCK)
				ON copy.CommServUniqueID = csInfo.CommServUniqueID AND copy.CopyId = csInfo.CopyId
			LEFT OUTER JOIN #tmpStoreInfo SInfo
				ON SInfo.CommServUniqueID = csInfo.CommServUniqueID
					and SInfo.sidbStoreId = csInfo.sidbStoreId
			LEFT OUTER JOIN (   -- MR : 261100
	                            select AF.CommServUniqueID as  CommServUniqueID,
	                                   AF.sidbStoreId as sidbStoreId,
	                                   AF.DeletedAFCount as DeletedAFCount
	                            from  cf_SurveyDeDupDeletedAFCount AS AF WITH (NOLOCK)   -- MR 172535            xxxx
	                            inner join  dbo.cf_SurveyResultFuncV1(@i_QueryId2, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView2
	                            ON resultView2.SurverResultId = AF.SurveyResultId )AF2
			ON AF2.CommServUniqueID = csInfo.CommServUniqueID
			AND csInfo.sidbStoreId = AF2.sidbStoreId
			LEFT OUTER JOIN #thresholdTbl TInfo
				ON TInfo.CommServUniqueID = csInfo.CommServUniqueID
		ORDER BY [Status<HEALTH_STATUS>] DESC, csInfo.AvgQITime DESC
	END
END
ELSE
BEGIN
	DECLARE @numberOfPartitions INT
	SELECT @numberOfPartitions = COUNT(SubStoreId)
	FROM cf_SurveyPartitionPerformance AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND csInfo.SidbStoreId = @i_SidbStoreId
	DECLARE @criticalRecordLimit INT = 200000000/@numberOfPartitions
	DECLARE @warningRecordLimit INT = 100000000/@numberOfPartitions
	SELECT
		csInfo.SidbStoreId as 'Store Id<DONOTSHOW>',
		P.SidbStoreName as 'DDB Name<HIDDEN>',
		csInfo.SubStoreId as 'Sub Store Id<DONOTSHOW>',
		csInfo.AccessPath as 'Access Path',
		csInfo.AvgQITime as 'Average Q&I Time (&mu;s)<FORMATNUMBERNA>',
		csInfo.PrimaryRecords as 'Partition Primary Block Count<FORMATNUMBERNA>',
		csInfo.SecondaryRecords as 'Partition Secondary Block Count<FORMATNUMBERNA><HIDDEN>',
		csInfo.ZeroRefCount as 'Partition Prunable Block Count<FORMATNUMBERNA><HIDDEN>',
		dbo.GetUnixTimeBig(csInfo.LastRecordedTime) as 'Last Recorded Time<DATETIME><HIDDEN>',
		csInfo.PartitionSizeMB as 'Size of Partition <SIZEMB>',
		copy.PolicyName AS 'Storage Policy<HIDDEN>',
		copy.CopyName AS 'Copy<HIDDEN>',
		copy.DefaultLibrary AS 'Library<HIDDEN>',
		csInfo.MediaAgentName AS 'MediaAgent<HIDDEN>',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=@warningRecordLimit
					then @strWarning
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=@criticalRecordLimit
					then @strCritical
					else @strWarning
				end
		end as 'Status<HEALTH_STATUS>',
		case
			when csInfo.AvgQITime < ISNULL(TInfo.warningThreshold,@warningVal)
			then @strGood
			when csInfo.AvgQITime >= ISNULL(TInfo.warningThreshold,@warningVal) and csInfo.AvgQITime < ISNULL(TInfo.criticalThreshold,@criticalVal)
			then
				case
					when csInfo.PrimaryRecords>=@warningRecordLimit
					then 'Average Q&I time or Partition Primary Block count reached warning threshold'
					else @strGood
				end
			else
				case
					when csInfo.PrimaryRecords>=@criticalRecordLimit
					then 'Average Q&I time or Partition Primary Block count reached critical threshold'
					else 'Average Q&I time or Partition Primary Block count reached warning threshold'
				end
		end as 'HealthStatusDescription<DONOTSHOW>'
	FROM cf_SurveyPartitionPerformance AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @bLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.SidbStoreId = @i_SidbStoreId
		INNER JOIN dbo.cf_SurveyDDBPerformance AS P
			ON csInfo.SurveyResultId = P.SurveyResultId
			AND csInfo.SidbStoreId = P.SidbStoreId
		LEFT OUTER JOIN cf_SurveyCopyBasicRetention copy WITH (NOLOCK) ON copy.CommServUniqueID = resultView.CommServUniqueID AND copy.CopyId = csInfo.CopyId
		LEFT OUTER JOIN #thresholdTbl TInfo
			ON TInfo.CommServUniqueID = resultView.CommServUniqueID
	ORDER BY  csInfo.AvgQITime DESC
END
DROP TABLE #tmpStoreInfo
IF object_id('tempdb.dbo.#thresholdTbl') IS NOT null
	DROP TABLE #thresholdTbl
SET NOCOUNT OFF
END
GO
----USE TO STANDALONE TEST Query for HEALTH-->DDB Performance and Status Details:
--DECLARE @i_userId 			INT = 1
--DECLARE @i_groupId			INT = NULL
--DECLARE @i_blaggregate		INT = 0
--DECLARE @i_bLatestSurvey		INT = 1
--DECLARE @i_CommServUniqueID	INT = 10066
--DECLARE @logStart				DATETIME = NULL
--DECLARE @logEnd				DATETIME = NULL
----select * from cf_CommcellIdNameMap where CommServName = 'mmdedupeesx'
--exec RptSurveyDDBPerformance @i_userId, 0, @i_blaggregate, @i_bLatestSurvey, @i_CommServUniqueID, @logStart, @logEnd, 0
--SET @i_blaggregate		= 2
--SET @i_bLatestSurvey	= 52
--exec RptSurveyDDBPerformance @i_userId, @i_groupId, @i_blaggregate, @i_bLatestSurvey, @i_CommServUniqueID, @logStart, @logEnd, 0

IF EXISTS (select * from GxQscripts where name = 'RptSurveyDDBPerformance')
	delete from GxQscripts where name = 'RptSurveyDDBPerformance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSurveyDDBPerformance')
	delete from GXDBVersions where aliasname = 'RptSurveyDDBPerformance'
GO

insert into GXDBVersions values(2, 'RptSurveyDDBPerformance',  '00010014001400200000', 'RptSurveyDDBPerformance', '00010014001400200000')
GO

