

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptStoragePolicyAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptStoragePolicyAudit.sp,v $ $Id: RptStoragePolicyAudit.sp,v 1.11.2.3 2020/12/17 02:53:41 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptStoragePolicyAudit')
BEGIN
	print '>>> Drop Stored Procedure: RptStoragePolicyAudit <<<'
	drop procedure RptStoragePolicyAudit
END
IF EXISTS (select * from GxQscripts where name='RptStoragePolicyAudit')
	delete from GxQscripts where name = 'RptStoragePolicyAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptStoragePolicyAudit')
	delete from GXDBVersions where aliasname = 'RptStoragePolicyAudit'
GO
print '... Creating Procedure: RptStoragePolicyAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptStoragePolicyAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdStoragePolicyID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 63
DECLARE @i_PropertyGroupId INT = 0
IF	@i_PropertyGroup = 'Passed Audit'
	SET @i_PropertyGroupId = -1
ELSE IF	@i_PropertyGroup = 'Basic'
	SET @i_PropertyGroupId = 1
ELSE IF	@i_PropertyGroup = 'Dedupe'
	SET @i_PropertyGroupId = 2
ELSE IF	@i_PropertyGroup = 'Retention'
	SET @i_PropertyGroupId = 3
ELSE IF	@i_PropertyGroup = 'Snap'
	SET @i_PropertyGroupId = 4
ELSE IF	@i_PropertyGroup = 'Content Indexing'
	SET @i_PropertyGroupId = 5
/* Storage Policy Types:
1	- DR
2	- TAPE
3	- DISK
4	- DEDUP
5	- GDSP
6	- SNAP
*/
/* Property Groups:
1	- Basic
2	- Dedupe
3	- Retention
4	- Snap
5	- Content Indexing
*/
CREATE	TABLE #LatestResult (
		CommServId INT,
		SurveyResultId BIGINT,
		LogDate	DATETIME)
CREATE	TABLE #StoragePolicy (
		CommServId INT,
		PolicyName NVARCHAR(256),
		PolicyId INT,
		CopyId INT,
		Type INT,
		PolicyFlags INT,
		NumberOfCopies INT,
		NumberOfSnapCopies INT,
		NumberOfStreams INT,
		IncPolicySelected INT,
		SIBlockSizeKB INT,
		AuxCopyAlertGB INT,
		AuxCopyAlertDays INT,
		TimeZoneType INT,
		MaxMultiplex INT,
		CopyFlags INT,
		DedupeFlags INT,
		SWCompressionOnClient INT,
		WaitForIfOffline INT,
		WaitForIfBusy INT,
		SilosInCache INT,
		NewStoreDays INT,
		NewStoreMonths INT,
		NewStoreSizeTB INT,
		MinPartitionsToRun INT,
		DDBPartitions INT,
		SWCompressionWithDedupe INT,
		MROnRetirementThreshold INT,
		MRMonthsAfterWritten INT,
		MRMonthsBeforeAged INT,
		MRPercentage INT,
		RetentionDays INT,
		RetentionCycles INT,
		ArchiverRetentionDays INT,
		RetentionJobCounts INT,
		AgingFlags INT,
		EnableExtRetention INT,
		ExtRetentionDiff INT,
		EnableBackupCopy INT,
		BackupCopyDiff INT,
		EnableContentIndexing INT,
		ContentIndexingDiff INT)
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
IF	@i_stdCommServUniqueID > 0 AND @i_stdStoragePolicyID = 0
BEGIN
	INSERT	INTO #StoragePolicy
	SELECT	AGC.CommServUniqueId,
			AG.StoragePolicyName,
			AG.ID,
			AGC.ID,
			(CASE WHEN AG.StoragePolicyType = 2 THEN 1 WHEN AG.NumberOfSnapCopies > 0 THEN 6 WHEN (AG.StoragePolicyFlags & 256) <> 0 THEN 5
			WHEN AGC.dedupeFlags <> 0 THEN 4 WHEN AGC.DrivePoolType = 10001 THEN 3 ELSE 2 END),
			0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0, 0, 0, 0,  0, 0
	FROM	#LatestResult LD
			INNER JOIN cf_SurveyArchiveGroupInfo AG
				ON AG.CommServUniqueId = LD.CommServId AND AG.SurveyResultId = LD.SurveyResultId
			INNER JOIN cf_SurveyArchiveGroupCopyInfo AGC
				ON AGC.CommServUniqueId = LD.CommServId AND AGC.SurveyResultId = LD.SurveyResultId AND AGC.ArchGroupId = AG.ID
	WHERE	AGC.CommServUniqueId = @i_stdCommServUniqueID
		AND (AG.NumberOfSnapCopies = 0 AND AGC.IsSnapCopy = 0 OR AG.NumberOfSnapCopies > 0 AND AGC.IsSnapCopy = 1)
	SELECT	CommServId	AS 'CommServ UniqueId',
			PolicyName	AS 'Storage Policy',
			PolicyId	AS 'Storage Policy ID',
			CASE Type	WHEN 1 THEN 'DR'
						WHEN 2 THEN 'Tape'
						WHEN 3 THEN 'Disk'
						WHEN 4 THEN 'Dedup'
						WHEN 5 THEN 'Global Dedup'
						WHEN 6 THEN 'Snap'
			END			AS 'Storage Policy Type'
	FROM #StoragePolicy
	ORDER BY PolicyName
	DROP TABLE #LatestResult
	DROP TABLE #StoragePolicy
	RETURN
END
DECLARE @TblPolicyFlags		TABLE (flag INT, name VARCHAR(128), propertyGroup INT)
DECLARE @TblCopyFlags		TABLE (flag INT, name VARCHAR(128))
DECLARE @TblCopyDedupeFlags	TABLE (flag INT, name VARCHAR(128))
DECLARE @TblCopyAgingFlags	TABLE (flag INT, name VARCHAR(128))
DECLARE @TblCIFlags			TABLE (flag INT, name VARCHAR(128))
DECLARE @PolicyFlags	INT
DECLARE @CopyFlags		INT
DECLARE @DedupeFlags	INT
DECLARE @AgingFlags		INT
DECLARE @CIFlags		INT
INSERT INTO @TblPolicyFlags
          SELECT 1,			'Enable Storage Policy for Legal Hold', 1
UNION ALL SELECT 2,			'Allow Erase Data', 1
UNION ALL SELECT 4,			'Enable Stream Randomization for Backup/Archive Jobs', 1
UNION ALL SELECT 8,			'Enable Auxiliary Copy Fallen Behind Alert', 1
UNION ALL SELECT 16,		'Enable Storage Policy Level Media Password', 1
UNION ALL SELECT 64,		'Hide Storage Policy', 1
UNION ALL SELECT 32768,		'Selection Rule for Snap Jobs: Full, Incremental, Differential Intellisnap Jobs', 4
UNION ALL SELECT 131072,	'Distribute data evenly among multiple streams for offline read operations', 1
INSERT INTO @TblCopyFlags
          SELECT 8,			'Use Alternate Data Paths When Resource are Offline'
UNION ALL SELECT 16,		'Use Alternate Data Paths When Resource are Busy'
UNION ALL SELECT 64,		'Mark Media to be Erased After Recycling'
UNION ALL SELECT 128,		'Verify All Jobs'
UNION ALL SELECT 256,		'Verify Full Jobs'
UNION ALL SELECT 512,		'Round-Robin between Data Paths'
UNION ALL SELECT 16384,		'Automatically add new data path'
UNION ALL SELECT 131072,	'Store Key On Media'
UNION ALL SELECT 16777216,	'WORM Copy'
UNION ALL SELECT 33554432,	'Enable Media Refresh'
UNION ALL SELECT 67108864,	'Use Hardware Snapshot'
UNION ALL SELECT 134217728,	'Enable LanFree Reservation Only'
UNION ALL SELECT 268435456,	'Use device streams rather than multiplexing if possible'
UNION ALL SELECT 536870912,	'Use Direct Attached NAS DrivePool'
INSERT INTO @TblCopyDedupeFlags
          SELECT 2,			'Use Store Priming Option with Source-Side Deduplication'
UNION ALL SELECT 8,			'Allow jobs to run to this copy while at least some partition(s) are available'
UNION ALL SELECT 131072,	'Remove DDB when the Silo store is sealed'
UNION ALL SELECT 262144,	'Enable Deduplication'
UNION ALL SELECT 524288,	'Enable Deduplication on Clients'
UNION ALL SELECT 1048576,	'Temporarily Disable Deduplication'
UNION ALL SELECT 2097152,	'Enable Backup of Deduplicated Data (SILO)'
--UNION ALL SELECT 4194304,	'Keep Active SILO In Cache'
UNION ALL SELECT 8388608,	'Enable DASH Full (Read Optimized Synthetic Full)'
UNION ALL SELECT 16777216,	'Enable SILO Disk Space Management'
UNION ALL SELECT 33554432,	'Pause and Recover Current Store'
UNION ALL SELECT 67108864,	'Pause and Recover Current Store Automatically'
UNION ALL SELECT 134217728,	'Use Global Dedup Store'
UNION ALL SELECT 268435456,	'Host Global Dedup Store'
INSERT INTO @TblCopyAgingFlags
          SELECT 1,			'Extended Retain First Job'
UNION ALL SELECT 4,			'Enable Data Aging'
UNION ALL SELECT 8,			'Enable Managed Disk Space'
UNION ALL SELECT 16,		'Ignore Job Dependency in Data Aging'
UNION ALL SELECT 32,		'Extended Retain Jobs From Lower Rule'
UNION ALL SELECT 64,		'Do Not Retain Intermediate Incrementals and Differentials Before New Differential'
UNION ALL SELECT 128,		'Retain Jobs On Job Counts'
INSERT INTO @TblCIFlags
          SELECT 4,			'Sync up Active Directory information'
UNION ALL SELECT 16,		'Use Global Filters'
SELECT @PolicyFlags	= SUM(Flag) FROM @TblPolicyFlags
SELECT @CopyFlags	= SUM(Flag) FROM @TblCopyFlags
SELECT @DedupeFlags	= SUM(Flag) FROM @TblCopyDedupeFlags
SELECT @AgingFlags	= SUM(Flag) FROM @TblCopyAgingFlags
SELECT @CIFlags		= SUM(Flag) FROM @TblCIFlags
CREATE	TABLE #ExtendedRetention (
		CommServId INT,
		PolicyId INT,
		CopyId INT,
		RetentionRule INT,
		RetentionDays INT,
		GraceDays INT,
		stdRetentionDays INT,
		stdGraceDays INT)
CREATE TABLE #BackupCopyInfo (
		CommServId INT,
		PolicyId INT,
		Type INT,
		Flags INT,
		SpecifiedSourceCopy INT,
		DeferredDays INT,
		NumberPeriod INT,
		DayNumber INT,
		JobSelection NVARCHAR(256))
CREATE TABLE #ContentIndexing (
		CommServId INT,
		PolicyId INT,
		Type INT,
		Flags INT,
		SelectedSubclients INT,
		SpecifiedSourceCopy INT,
		DeferredDays INT,
		RetentionDays INT,
		NumberPeriod INT,
		DayNumber INT,
		JobSelection NVARCHAR(256),
		MinDocSizeKB INT,
		MaxDocSizeKB INT,
		IncludeDocTypes NVARCHAR(MAX),
		ExcludeDocTypes NVARCHAR(MAX),
		EntityIds NVARCHAR(MAX),
		FilterSelected INT)
DECLARE @tempStr1				VARCHAR(1024)
DECLARE @tempStr2				VARCHAR(1024)
DECLARE @tempStr3				VARCHAR(1024)
DECLARE @stdCopyID					INT
DECLARE	@stdPolicyType				INT
DECLARE	@stdPolicyFlags				INT
DECLARE	@stdNumberOfCopies			INT
DECLARE	@stdNumberOfSnapCopies		INT
DECLARE	@stdNumberOfStreams			INT
DECLARE	@stdIncPolicySelected		INT
DECLARE	@stdSIBlockSizeKB			INT
DECLARE	@stdAuxCopyAlertGB			INT
DECLARE	@stdAuxCopyAlertDays		INT
DECLARE	@stdTimeZoneType			INT
DECLARE	@stdMaxMultiplex			INT
DECLARE	@stdCopyFlags				INT
DECLARE	@stdDedupeFlags				INT
DECLARE	@stdWaitForIfOffline		INT
DECLARE	@stdWaitForIfBusy			INT
DECLARE	@stdSWCompressionOnClient	INT
DECLARE	@stdSilosInCache			INT
DECLARE	@stdMinPartitionsToRun		INT
DECLARE	@stdDDBPartitions			INT
DECLARE	@stdSWCompressionWithDedupe	INT
DECLARE	@stdMROnRetirementThreshold	INT
DECLARE	@stdMRMonthsAfterWritten	INT
DECLARE	@stdMRMonthsBeforeAged		INT
DECLARE	@stdMRPercentage			INT
DECLARE	@stdRetentionDays			INT
DECLARE	@stdRetentionCycles			INT
DECLARE	@stdArchiverRetentionDays	INT
DECLARE	@stdRetentionJobCounts		INT
DECLARE	@stdAgingFlags				INT
DECLARE	@stdNewStoreDays			INT
DECLARE	@stdNewStoreMonths			INT
DECLARE	@stdNewStoreSizeTB			INT
DECLARE	@stdEnableBackupCopy		INT = 0
DECLARE	@stdEnableContentIndexing	INT = 0
DECLARE	@stdEnableExtRetention		INT = 0
DECLARE	@stdDeferredDays			INT
DECLARE	@stdBackupCopyFlags			INT
DECLARE	@stdCIFlags					INT
DECLARE	@stdFilterSelected			INT
INSERT	INTO #StoragePolicy
SELECT	AGC.CommServUniqueId,
		AG.StoragePolicyName,
		AG.ID,
		AGC.ID,
		(CASE WHEN AG.StoragePolicyType = 2 THEN 1 WHEN AG.NumberOfSnapCopies > 0 THEN 6 WHEN (AG.StoragePolicyFlags & 256) <> 0 THEN 5
		WHEN AGC.dedupeFlags <> 0 THEN 4 WHEN AGC.DrivePoolType = 10001 THEN 3 ELSE 2 END),
		AG.StoragePolicyFlags & @PolicyFlags,
		AG.NumberOfCopies,
		AG.NumberOfSnapCopies,
		AG.NumberOfStreams,
		CASE WHEN AG.IncrementalPolicyId > 0 THEN 1 ELSE 0 END,
		AG.SIBlockSizeKB,
		AG.AuxCopyAlertGB,
		AG.AuxCopyAlertDays,
		AG.TimeZoneType,
		AGC.MaxMultiplex,
		AGC.Flags & @CopyFlags,
		AGC.DedupeFlags & @DedupeFlags,
		CASE WHEN (AGC.DedupeFlags & 262144) = 0 THEN (AGC.ExtendedFlags & 16) ELSE 0 END,
		AGC.WaitForIfOffline/60,
		AGC.WaitForIfBusy/60,
		CASE WHEN (AGC.DedupeFlags & 2097152) = 0 THEN 0 ELSE AGC.SilosInCache END,
		CASE WHEN AGC.NewStorePeriodType = 3 THEN NewStoreNumPeriod ELSE 0 END,
		CASE WHEN AGC.NewStorePeriodType = 4 THEN NewStoreNumPeriod ELSE 0 END,
		AGC.NewStoreSizeTB,
		CASE WHEN (AGC.DedupeFlags & 8) = 0 THEN 0 ELSE (AGC.DDBPartitions - AGC.MaxCorruptPartitions) END,
		AGC.DDBPartitions,
		(AGC.SIDBStoreFlags & 2),
		(AGC.MRFlags & 1),
		AGC.MRDaysAfterWritten/30,
		AGC.MRDaysBeforeAged/30,
		AGC.MRPercentage,
		AGC.RetentionDays,
		AGC.RetentionCycles,
		AGC.ArchiverRetentionDays,
		CASE WHEN (AGC.AgingFlags & 128) = 0 THEN 0 ELSE AGC.RetentionJobs END,
		AGC.AgingFlags & @AgingFlags,
		0, 0, 0, 0, 0, 0
FROM	#LatestResult LD
		INNER JOIN cf_SurveyArchiveGroupInfo AG
			ON AG.CommServUniqueId = LD.CommServId AND AG.SurveyResultId = LD.SurveyResultId
		INNER JOIN cf_SurveyArchiveGroupCopyInfo AGC
			ON AGC.CommServUniqueId = LD.CommServId AND AGC.SurveyResultId = LD.SurveyResultId AND AGC.ArchGroupId = AG.ID
WHERE	(AG.CommServUniqueId = @i_stdCommServUniqueID AND AG.ID = @i_stdStoragePolicyID
		OR  @i_CommServUniqueID = 0 OR AG.CommServUniqueId = @i_CommServUniqueID)
	AND (AG.NumberOfSnapCopies = 0 AND AGC.IsSnapCopy = 0 OR AG.NumberOfSnapCopies > 0 AND AGC.IsSnapCopy = 1)
SELECT	@stdPolicyFlags				= PolicyFlags,
		@stdNumberOfCopies			= NumberOfCopies,
		@stdNumberOfSnapCopies		= NumberOfSnapCopies,
		@stdNumberOfStreams			= NumberOfStreams,
		@stdIncPolicySelected		= IncPolicySelected,
		@stdSIBlockSizeKB			= SIBlockSizeKB,
		@stdAuxCopyAlertGB			= AuxCopyAlertGB,
		@stdAuxCopyAlertDays		= AuxCopyAlertDays,
		@stdTimeZoneType			= TimeZoneType,
		@stdPolicyType				= Type,
		@stdCopyID					= CopyId,
		@stdMaxMultiplex			= MaxMultiplex,
		@stdCopyFlags				= CopyFlags,
		@stdDedupeFlags				= DedupeFlags,
		@stdSWCompressionOnClient	= SWCompressionOnClient,
		@stdWaitForIfOffline		= WaitForIfOffline,
		@stdWaitForIfBusy			= WaitForIfBusy,
		@stdSilosInCache			= SilosInCache,
		@stdRetentionDays			= RetentionDays,
		@stdRetentionCycles			= RetentionCycles,
		@stdArchiverRetentionDays	= ArchiverRetentionDays,
		@stdRetentionJobCounts		= RetentionJobCounts,
		@stdAgingFlags				= AgingFlags,
		@stdNewStoreDays			= NewStoreDays,
		@stdNewStoreMonths			= NewStoreMonths,
		@stdNewStoreSizeTB			= NewStoreSizeTB,
		@stdMinPartitionsToRun		= MinPartitionsToRun,
		@stdDDBPartitions			= DDBPartitions,
		@stdSWCompressionWithDedupe	= SWCompressionWithDedupe,
		@stdMROnRetirementThreshold	= MROnRetirementThreshold,
		@stdMRMonthsAfterWritten	= MRMonthsAfterWritten,
		@stdMRMonthsBeforeAged		= MRMonthsBeforeAged,
		@stdMRPercentage			= MRPercentage
FROM	#StoragePolicy
WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
DELETE	#StoragePolicy
WHERE	Type <> @stdPolicyType
-- Global Deduplication Policy
IF	@stdPolicyType = 5
BEGIN
	DELETE	@TblPolicyFlags WHERE flag = 4
	UPDATE	#StoragePolicy SET PolicyFlags = (PolicyFlags & ~4)
	SET		@stdPolicyFlags = (@stdPolicyFlags & ~4)
END
-- Snapshot Enabled
IF	@stdPolicyType <> 6
BEGIN
	DELETE	@TblPolicyFlags WHERE flag = 32768
	UPDATE	#StoragePolicy SET PolicyFlags = (PolicyFlags & ~32768)
	SET		@stdPolicyFlags = (@stdPolicyFlags & ~32768)
END
DECLARE	@TblPolicyCount TABLE (CommServId INT, Count INT)
INSERT	INTO @TblPolicyCount
SELECT	CommServId, COUNT(PolicyId)
FROM	#StoragePolicy
WHERE	CommServId <> @i_stdCommServUniqueID OR PolicyId <> @i_stdStoragePolicyID
GROUP BY CommServId
INSERT	INTO #ExtendedRetention
SELECT	ER.CommServUniqueId, SP.PolicyId, ER.CopyID, ER.RetentionRule, ER.RetentionDays, ER.GraceDays, 0, 0
FROM	#LatestResult LD
		INNER JOIN cf_SurveyExtendedRetention ER
			ON ER.CommServUniqueId = LD.CommServId AND ER.SurveyResultId = LD.SurveyResultId AND ER.RetentionRule > 0
		INNER JOIN #StoragePolicy SP
			ON ER.CommServUniqueId = SP.CommServId AND ER.CopyID = SP.CopyId
IF	@i_PropertyGroupId IN (0, 3)
BEGIN
	UPDATE	#StoragePolicy
	SET		EnableExtRetention = 1
	FROM	#StoragePolicy SP
			INNER JOIN (SELECT DISTINCT CommServId, CopyId FROM #ExtendedRetention) T
				ON SP.CommServId = T.CommServId AND SP.CopyId = T.CopyId
	SELECT	@stdEnableExtRetention = EnableExtRetention
	FROM	#StoragePolicy
	WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID
	IF	@stdEnableExtRetention = 1
	BEGIN
		DECLARE	@stdExtRetRuleCounts INT = 0
		SELECT	@stdExtRetRuleCounts = COUNT(*)
		FROM	#ExtendedRetention
		WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID
		UPDATE	#ExtendedRetention
		SET		stdRetentionDays = STD.RetentionDays, stdGraceDays = STD.GraceDays
		FROM	(SELECT	RetentionRule, RetentionDays, GraceDays
				FROM	#ExtendedRetention
				WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID) AS STD
		WHERE	#ExtendedRetention.RetentionRule = STD.RetentionRule
		UPDATE	#StoragePolicy
		SET		ExtRetentionDiff = 1
		FROM	#StoragePolicy SP
				LEFT OUTER JOIN (
					SELECT	CommServId, CopyId, COUNT(RetentionRule) AS ExtRetRuleCounts
					FROM	#ExtendedRetention
					WHERE	RetentionDays = stdRetentionDays AND GraceDays = stdGraceDays
					GROUP BY CommServId, CopyId
					HAVING COUNT(RetentionRule) = @stdExtRetRuleCounts) T
					ON SP.CommServId = T.CommServId AND SP.CopyId = T.CopyId
		WHERE	T.CopyId IS NULL
	END
	ELSE
		UPDATE	#StoragePolicy
		SET		ExtRetentionDiff = 1
		WHERE	EnableExtRetention = 1
END
IF	@i_PropertyGroupId IN (0, 4)
BEGIN
	INSERT	INTO #BackupCopyInfo
	SELECT	SP.CommServId, SP.PolicyId, BC.Type, BC.Flags, CASE WHEN BC.SourceCopyId > 0 THEN 1 ELSE 0 END,
			BC.DeferredDays, BC.NumberPeriod, BC.DayNumber,
			dbo.JobSelectionPatternFunc(BC.Type, BC.Flags, BC.NumberPeriod, BC.DayNumber)
	FROM	#LatestResult LD
			INNER JOIN cf_SurveyBackupCopyInfo BC
				ON BC.CommServUniqueId = LD.CommServId AND BC.SurveyResultId = LD.SurveyResultId AND BC.Enabled = 1
			INNER JOIN #StoragePolicy SP
				ON BC.CommServUniqueId = SP.CommServId AND BC.ArchGroupID = SP.PolicyId
	UPDATE	#StoragePolicy
	SET		EnableBackupCopy = 1
	FROM	#StoragePolicy SP
			INNER JOIN (SELECT DISTINCT CommServId, PolicyId FROM #BackupCopyInfo) T
				ON SP.CommServId = T.CommServId AND SP.PolicyId = T.PolicyId
	SELECT	@stdEnableBackupCopy = EnableBackupCopy
	FROM	#StoragePolicy
	WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID
	IF	@stdEnableBackupCopy = 1
		UPDATE	#StoragePolicy
		SET		BackupCopyDiff = 1
		FROM	#StoragePolicy SP
				LEFT OUTER JOIN (
					SELECT	BC.CommServId, BC.PolicyId
					FROM	#BackupCopyInfo BC,
							(SELECT * FROM #BackupCopyInfo
							WHERE CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID) S
					WHERE	BC.Type = S.Type AND BC.Flags = S.Flags AND BC.DeferredDays = S.DeferredDays
						AND BC.NumberPeriod = S.NumberPeriod AND BC.DayNumber = S.DayNumber
					) T
					ON SP.CommServId = T.CommServId AND SP.PolicyId = T.PolicyId
		WHERE	T.PolicyId IS NULL
	ELSE
		UPDATE	#StoragePolicy
		SET		BackupCopyDiff = 1
		WHERE	EnableBackupCopy = 1
END
IF	@i_PropertyGroupId IN (0, 5)
BEGIN
	INSERT	INTO #ContentIndexing
	SELECT	SP.CommServId, SP.PolicyId, CI.Type, CI.Flags & @CIFlags,
			CASE WHEN CI.SubclientAssoc > 0 THEN 1 ELSE 0 END,
			CASE WHEN CI.SourceCopyId > 0 THEN 1 ELSE 0 END,
			CI.DeferredDays, CI.RetentionDays, CI.NumberPeriod, CI.DayNumber,
			dbo.JobSelectionPatternFunc(CI.Type, CI.Flags, CI.NumberPeriod, CI.DayNumber),
			CI.MinDocSizeKB, CI.MaxDocSizeKB, CI.IncludeDocTypes, CI.ExcludeDocTypes, CI.EntityIds, CI.FilterSelected
	FROM	#LatestResult LD
			INNER JOIN cf_SurveyContentIndexing CI
				ON CI.CommServUniqueId = LD.CommServId AND CI.SurveyResultId = LD.SurveyResultId AND CI.Enabled = 1
			INNER JOIN #StoragePolicy SP
				ON CI.CommServUniqueId = SP.CommServId AND CI.ArchGroupID = SP.PolicyId
	UPDATE	#StoragePolicy
	SET		EnableContentIndexing = 1
	FROM	#StoragePolicy SP
			INNER JOIN (SELECT DISTINCT CommServId, PolicyId FROM #ContentIndexing) T
				ON SP.CommServId = T.CommServId AND SP.PolicyId = T.PolicyId
	SELECT	@stdEnableContentIndexing = EnableContentIndexing
	FROM	#StoragePolicy
	WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
	IF	@stdEnableContentIndexing = 1
		UPDATE	#StoragePolicy
		SET		ContentIndexingDiff = 1
		FROM	#StoragePolicy SP
				LEFT OUTER JOIN (
					SELECT	CI.CommServId, CI.PolicyId
					FROM	#ContentIndexing CI,
							(SELECT * FROM #ContentIndexing
							WHERE CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID) S
					WHERE	CI.Type = S.Type AND CI.Flags = S.Flags AND CI.SelectedSubclients = S.SelectedSubclients
						AND CI.SpecifiedSourceCopy = S.SpecifiedSourceCopy AND CI.DeferredDays = S.DeferredDays
						AND CI.RetentionDays = S.RetentionDays AND CI.NumberPeriod = S.NumberPeriod AND CI.DayNumber = S.DayNumber
						AND CI.MinDocSizeKB = S.MinDocSizeKB AND CI.MaxDocSizeKB = S.MaxDocSizeKB
						AND CI.IncludeDocTypes = S.IncludeDocTypes AND CI.ExcludeDocTypes = S.ExcludeDocTypes
						AND CI.EntityIds = S.EntityIds AND CI.FilterSelected = S.FilterSelected
					) T
					ON SP.CommServId = T.CommServId AND SP.PolicyId = T.PolicyId
		WHERE	T.PolicyId IS NULL
	ELSE
		UPDATE	#StoragePolicy
		SET		ContentIndexingDiff = 1
		WHERE	EnableContentIndexing = 1
END
DECLARE	@TblPassedPolicy TABLE (CommServId INT, PolicyId INT, PolicyName NVARCHAR(256))
INSERT	INTO @TblPassedPolicy
SELECT	CommServId, PolicyId, PolicyName
FROM	#StoragePolicy
WHERE	(CommServId <> @i_stdCommServUniqueID OR PolicyId <> @i_stdStoragePolicyID)
	AND PolicyFlags = @stdPolicyFlags
	AND NumberOfCopies = @stdNumberOfCopies
	AND NumberOfSnapCopies = @stdNumberOfSnapCopies
	AND NumberOfStreams = @stdNumberOfStreams
	AND IncPolicySelected = @stdIncPolicySelected
	AND	SIBlockSizeKB = @stdSIBlockSizeKB
	AND AuxCopyAlertGB = @stdAuxCopyAlertGB
	AND AuxCopyAlertDays = @stdAuxCopyAlertDays
	AND TimeZoneType = @stdTimeZoneType
	AND MaxMultiplex = @stdMaxMultiplex
	AND	CopyFlags = @stdCopyFlags
	AND DedupeFlags = @stdDedupeFlags
	AND WaitForIfOffline = @stdWaitForIfOffline
	AND WaitForIfBusy = @stdWaitForIfBusy
	AND SWCompressionOnClient = @stdSWCompressionOnClient
	AND SilosInCache = @stdSilosInCache
	AND NewStoreDays = @stdNewStoreDays
	AND NewStoreMonths = @stdNewStoreMonths
	AND NewStoreSizeTB = @stdNewStoreSizeTB
	AND MinPartitionsToRun = @stdMinPartitionsToRun
	AND DDBPartitions = @stdDDBPartitions
	AND SWCompressionWithDedupe = @stdSWCompressionWithDedupe
	AND MROnRetirementThreshold = @stdMROnRetirementThreshold
	AND MRMonthsAfterWritten = @stdMRMonthsAfterWritten
	AND MRMonthsBeforeAged = @stdMRMonthsBeforeAged
	AND MRPercentage = @stdMRPercentage
	AND RetentionDays = @stdRetentionDays
	AND RetentionCycles = @stdRetentionCycles
	AND ArchiverRetentionDays = @stdArchiverRetentionDays
	AND RetentionJobCounts = @stdRetentionJobCounts
	AND AgingFlags = @stdAgingFlags
	AND ExtRetentionDiff = 0
	AND ContentIndexingDiff = 0
	AND BackupCopyDiff = 0
IF	@i_PropertyGroupId = -1
BEGIN
	IF	@i_CommServUniqueID = 0
		SELECT	CS.CommServName	AS 'CommCell',
				P.PolicyName AS 'Storage Policy'
		FROM	@TblPassedPolicy P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.PolicyName
	ELSE
		SELECT	PolicyName AS 'Storage Policy'
		FROM	@TblPassedPolicy
		ORDER BY PolicyName
	DROP TABLE #LatestResult
	DROP TABLE #StoragePolicy
	DROP TABLE #ExtendedRetention
	DROP TABLE #BackupCopyInfo
	DROP TABLE #ContentIndexing
	RETURN
END
DELETE	#StoragePolicy
FROM	@TblPassedPolicy P
WHERE	#StoragePolicy.CommServId = P.CommServId AND #StoragePolicy.PolicyId = P.PolicyId
CREATE	TABLE #PolicyProperty (CommServId INT, PolicyId INT, PropertyGroup INT, Property VARCHAR(128), Value NVARCHAR(MAX), stdValue NVARCHAR(MAX))
;WITH PolicyCopyProperty (CommServId, PolicyId, Property, Value) AS
(
	SELECT	P.CommServId, P.PolicyId, P.Property, P.Value
	FROM	#StoragePolicy
			UNPIVOT (Value FOR Property IN (
				NumberOfCopies, NumberOfSnapCopies, NumberOfStreams, IncPolicySelected, SIBlockSizeKB, MaxMultiplex, WaitForIfOffline, WaitForIfBusy,
				SWCompressionOnClient, AuxCopyAlertGB, AuxCopyAlertDays, TimeZoneType, NewStoreDays, NewStoreMonths, NewStoreSizeTB,
				MinPartitionsToRun, DDBPartitions, SWCompressionWithDedupe, MROnRetirementThreshold, MRMonthsAfterWritten, MRMonthsBeforeAged, MRPercentage,
				RetentionDays, RetentionCycles, ArchiverRetentionDays, RetentionJobCounts, EnableExtRetention, EnableBackupCopy, EnableContentIndexing)
			) P
)
INSERT	INTO #PolicyProperty
SELECT	P.CommServId, P.PolicyId,
		CASE WHEN P.Property IN ('NumberOfCopies', 'NumberOfSnapCopies', 'NumberOfStreams', 'IncPolicySelected', 'MaxMultiplex',
								'WaitForIfOffline', 'WaitForIfBusy', 'SWCompressionOnClient', 'AuxCopyAlertGB', 'AuxCopyAlertDays',
								'TimeZoneType', 'MROnRetirementThreshold', 'MRMonthsAfterWritten', 'MRMonthsBeforeAged', 'MRPercentage') THEN 1
			WHEN P.Property IN ('SIBlockSizeKB', 'SilosInCache', 'NewStoreDays', 'NewStoreMonths', 'NewStoreSizeTB',
								'MinPartitionsToRun', 'DDBPartitions', 'SWCompressionWithDedupe') THEN 2
			WHEN P.Property IN ('RetentionDays', 'RetentionCycles', 'ArchiverRetentionDays', 'RetentionJobCounts', 'EnableExtRetention') THEN 3
			WHEN P.Property IN ('EnableBackupCopy') THEN 4
			WHEN P.Property IN ('EnableContentIndexing') THEN 5
		END,
		CASE WHEN P.Property = 'NumberOfCopies' THEN 'No. Of Active Copies'
			WHEN P.Property = 'NumberOfSnapCopies' THEN 'No. Of Active Snap Copies'
			WHEN P.Property = 'NumberOfStreams' THEN 'Device Streams'
			WHEN P.Property = 'IncPolicySelected' THEN 'Incremental Storage Policy'
			WHEN P.Property = 'MaxMultiplex' THEN (CASE WHEN P.Value > 1 AND S.Value > 1 THEN 'Multiplexing Factor' ELSE 'Enable Multiplexing' END)
			WHEN P.Property = 'WaitForIfOffline' THEN 'Use Alternate Data Path When Resources are Offline'
			WHEN P.Property = 'WaitForIfBusy' THEN 'Use Alternate Data Path When Resources are Busy'
			WHEN P.Property = 'SilosInCache' THEN 'Number of silos to be kept in cache'
			WHEN P.Property = 'SIBlockSizeKB' THEN 'Block Level Deduplication Factor (KB)'
			WHEN P.Property = 'SWCompressionOnClient' THEN 'Software Compression On Client'
			WHEN P.Property = 'AuxCopyAlertGB' THEN 'Enable Auxiliary Copy Fallen Behind Alert - To Be Copied Data Size GB'
			WHEN P.Property = 'AuxCopyAlertDays' THEN 'Enable Auxiliary Copy Fallen Behind Alert - Days Behind'
			WHEN P.Property = 'TimeZoneType' THEN 'Time Zone Settings'
			WHEN P.Property = 'NewStoreDays' THEN 'Create new store every N days'
			WHEN P.Property = 'NewStoreMonths' THEN 'Create new store every N months'
			WHEN P.Property = 'NewStoreSizeTB' THEN 'Create new store every N (TB)'
			WHEN P.Property = 'MinPartitionsToRun' THEN 'Allow jobs to run to this copy while at least N partition(s) are available'
			WHEN P.Property = 'DDBPartitions' THEN 'Number of Partition(s) of DDB'
			WHEN P.Property = 'SWCompressionWithDedupe' THEN 'Enable Software Compression with Deduplication'
			WHEN P.Property = 'MROnRetirementThreshold' THEN 'Media Refresh: Media retirement threshold is exceeded'
			WHEN P.Property = 'MRMonthsAfterWritten' THEN 'Media Refresh: Months after media were written'
			WHEN P.Property = 'MRMonthsBeforeAged' THEN 'Media Refresh: Months before media is aged'
			WHEN P.Property = 'MRPercentage' THEN 'Media Refresh: % or less of media capacity is used'
			WHEN P.Property = 'RetentionDays' THEN 'Retention Days'
			WHEN P.Property = 'RetentionCycles' THEN 'Retention Cycles'
			WHEN P.Property = 'ArchiverRetentionDays' THEN 'Archiver Data Retention Days'
			WHEN P.Property = 'RetentionJobCounts' THEN 'Retention Job Counts'
			WHEN P.Property = 'EnableExtRetention' THEN 'Enable Extended Retention'
			WHEN P.Property = 'EnableBackupCopy' THEN 'Enable Backup Copy'
			WHEN P.Property = 'EnableContentIndexing' THEN 'Enable Content Indexing'
		END,
		CASE WHEN P.Property = 'TimeZoneType' THEN (CASE P.Value WHEN 0 THEN 'CommServer Time Zone' WHEN 1 THEN 'Client Time Zone' ELSE 'User Selected Time Zone' END)
			WHEN P.Property = 'MaxMultiplex' AND P.Value > 1 AND S.Value > 1 THEN CAST (P.Value AS VARCHAR(3))
			WHEN P.Property = 'MaxMultiplex' THEN (CASE WHEN P.Value > 1 THEN 'Yes' ELSE 'No' END)
			WHEN P.Property IN ('SWCompressionOnClient', 'SWCompressionWithDedupe', 'MROnRetirementThreshold',
								'EnableExtRetention', 'EnableBackupCopy', 'EnableContentIndexing')
				THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN P.Property IN ('WaitForIfOffline', 'WaitForIfBusy')
				THEN (CASE P.Value WHEN 0 THEN 'Immediately' ELSE 'After ' + CAST (P.Value/60 AS VARCHAR(10)) + ' hour(s) ' + CAST (P.Value%60 AS VARCHAR(2)) + ' minute(s)' END)
			WHEN P.Value = -1 THEN 'Infinite' ELSE CAST (P.Value AS VARCHAR(32)) END,
		CASE WHEN S.Property = 'TimeZoneType' THEN (CASE S.Value WHEN 0 THEN 'CommServer Time Zone' WHEN 1 THEN 'Client Time Zone' ELSE 'User Selected Time Zone' END)
			WHEN S.Property = 'MaxMultiplex' AND P.Value > 1 AND S.Value > 1 THEN CAST (P.Value AS VARCHAR(3))
			WHEN S.Property = 'MaxMultiplex' THEN (CASE WHEN S.Value > 1 THEN 'Yes' ELSE 'No' END)
			WHEN S.Property IN ('SWCompressionOnClient', 'SWCompressionWithDedupe', 'MROnRetirementThreshold',
								'EnableExtRetention', 'EnableBackupCopy', 'EnableContentIndexing')
				THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN S.Property IN ('WaitForIfOffline', 'WaitForIfBusy')
				THEN (CASE S.Value WHEN 0 THEN 'Immediately' ELSE 'After ' + CAST (S.Value/60 AS VARCHAR(10)) + ' hour(s) ' + CAST (S.Value%60 AS VARCHAR(2)) + ' minute(s)' END)
			WHEN S.Value = -1 THEN 'Infinite' ELSE CAST (S.Value AS VARCHAR(32)) END
FROM	PolicyCopyProperty P
		INNER JOIN
		(
			SELECT	Property, Value
			FROM	PolicyCopyProperty
			WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
		) S
		ON P.Property = S.Property AND P.Value <> S.Value
INSERT	INTO #PolicyProperty
SELECT	P.CommServId, P.PolicyId, F.propertyGroup, F.name,
		CASE WHEN (P.PolicyFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
		CASE WHEN (@stdPolicyFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END
FROM	(SELECT CommServId, PolicyId, PolicyFlags FROM #StoragePolicy WHERE PolicyFlags <> @stdPolicyFlags) P
		CROSS JOIN @TblPolicyFlags F
WHERE	(P.PolicyFlags & F.flag) <> (@stdPolicyFlags & F.flag)
	AND (@i_PropertyGroupId = 0 OR F.propertyGroup = @i_PropertyGroupId)
IF	@i_PropertyGroupId IN (0, 1)
BEGIN
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 1, F.name,
			CASE WHEN (P.CopyFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdCopyFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, PolicyId, CopyFlags FROM #StoragePolicy WHERE CopyFlags <> @stdCopyFlags) P
			CROSS JOIN @TblCopyFlags F
	WHERE	(P.CopyFlags & F.flag) <> (@stdCopyFlags & F.flag)
END
IF	@i_PropertyGroupId IN (0, 2)
BEGIN
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 2, F.name,
			CASE WHEN (P.DedupeFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdDedupeFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, PolicyId, DedupeFlags FROM #StoragePolicy WHERE DedupeFlags <> @stdDedupeFlags) P
			CROSS JOIN @TblCopyDedupeFlags F
	WHERE	(P.DedupeFlags & F.flag) <> (@stdDedupeFlags & F.flag)
END
IF	@i_PropertyGroupId IN (0, 3)
BEGIN
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 3, F.name,
			CASE WHEN (P.AgingFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdAgingFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, PolicyId, (AgingFlags & ~4) AS AgingFlags FROM #StoragePolicy WHERE AgingFlags <> @stdAgingFlags) P
			CROSS JOIN @TblCopyAgingFlags F
	WHERE	(P.AgingFlags & F.flag) <> (@stdAgingFlags & F.flag)
	INSERT	INTO #PolicyProperty
	SELECT	ER.CommServId, ER.PolicyId, 3,
			CASE STD.RetentionRule
				WHEN  2 THEN 'Extended Retention Days (All Full)'
				WHEN  4 THEN 'Extended Retention Days (Weekly Full)'
				WHEN  8 THEN 'Extended Retention Days (Monthly Full)'
				WHEN 16 THEN 'Extended Retention Days (Quarterly Full)'
				WHEN 32 THEN 'Extended Retention Days (Half Year Full)'
				WHEN 64 THEN 'Extended Retention Days (Yearly Full)'
			END,
			CASE WHEN ER.RetentionDays IS NULL THEN 'N/A' WHEN ER.RetentionDays = -1 THEN 'Infinite' ELSE CAST(ER.RetentionDays AS VARCHAR(32)) END,
			CASE WHEN STD.RetentionDays = -1 THEN 'Infinite' ELSE CAST(STD.RetentionDays AS VARCHAR(32)) END
	FROM	(SELECT	RetentionRule, RetentionDays, GraceDays
			FROM	#ExtendedRetention
			WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID) AS STD
			LEFT OUTER JOIN #ExtendedRetention ER
				ON ER.RetentionRule = STD.RetentionRule
	WHERE	ER.RetentionRule IS NULL OR ER.RetentionDays <> ER.stdRetentionDays
	INSERT	INTO #PolicyProperty
	SELECT	ER.CommServId, ER.PolicyId, 3,
			CASE STD.RetentionRule
				WHEN  4 THEN 'Extended Retention Grace Days (Weekly Full)'
				WHEN  8 THEN 'Extended Retention Grace Days (Monthly Full)'
				WHEN 16 THEN 'Extended Retention Grace Days (Quarterly Full)'
				WHEN 32 THEN 'Extended Retention Grace Days (Half Year Full)'
				WHEN 64 THEN 'Extended Retention Grace Days (Yearly Full)'
			END,
			ISNULL(CAST(ER.GraceDays AS VARCHAR(32)), 'N/A'),
			CAST(STD.GraceDays AS VARCHAR(32))
	FROM	(SELECT	RetentionRule, RetentionDays, GraceDays
			FROM	#ExtendedRetention
			WHERE	CommServId = @i_stdCommServUniqueID AND CopyId = @stdCopyID AND RetentionRule <> 2) AS STD
			LEFT OUTER JOIN #ExtendedRetention ER
				ON ER.RetentionRule = STD.RetentionRule
	WHERE	ER.RetentionRule IS NULL OR ER.GraceDays <> ER.stdGraceDays
END
IF	@i_PropertyGroupId IN (0, 4) AND @stdEnableBackupCopy = 1
BEGIN
	;WITH BackupCopyProperty (CommServId, PolicyId, Property, Value) AS
	(
		SELECT	P.CommServId, P.PolicyId, P.Property, P.Value
		FROM	#BackupCopyInfo
				UNPIVOT (Value FOR Property IN (SpecifiedSourceCopy, DeferredDays)) P
	)
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 4,
			CASE WHEN P.Property = 'SpecifiedSourceCopy' THEN 'Backup Copy: Specified Source Copy'
				WHEN P.Property = 'DeferredDays' THEN 'Backup Copy: Defer Backup Copy for N day(s)'
			END,
			CASE WHEN P.Property = 'DeferredDays' THEN CAST (P.Value AS VARCHAR(32)) WHEN P.Value = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN S.Property = 'DeferredDays' THEN CAST (S.Value AS VARCHAR(32)) WHEN S.Value = 0 THEN 'No' ELSE 'Yes' END
	FROM	BackupCopyProperty P
			INNER JOIN
			(
				SELECT	Property, Value
				FROM	BackupCopyProperty
				WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
			) S
			ON P.Property = S.Property AND P.Value <> S.Value
	SELECT	@stdBackupCopyFlags = Flags, @tempStr1 = JobSelection
	FROM	#BackupCopyInfo
	WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
	INSERT	INTO #PolicyProperty
	SELECT	CommServId, PolicyId, 4, 'Backup Copy: Catalog Snapshots',
			CASE WHEN (Flags & 2) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdBackupCopyFlags & 2) = 0 THEN 'No' ELSE 'Yes' END
	FROM	#BackupCopyInfo
	WHERE	(Flags & 2) <> (@stdBackupCopyFlags & 2)
	INSERT	INTO #PolicyProperty
	SELECT	CommServId, PolicyId, 4, 'Backup Copy: Job Selection Rules', JobSelection, @tempStr1
	FROM	#BackupCopyInfo
	WHERE	JobSelection <> @tempStr1
END
IF	@i_PropertyGroupId IN (0, 5) AND @stdEnableContentIndexing = 1
BEGIN
	;WITH ContentIndexingProperty (CommServId, PolicyId, Property, Value) AS
	(
		SELECT	P.CommServId, P.PolicyId, P.Property, P.Value
		FROM	#ContentIndexing
				UNPIVOT (Value FOR Property IN (SelectedSubclients, SpecifiedSourceCopy, DeferredDays, RetentionDays,
						MinDocSizeKB, MaxDocSizeKB, FilterSelected)) P
	)
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 5,
			CASE WHEN P.Property = 'SelectedSubclients' THEN 'Content Indexing: Selected Subclient Association'
				WHEN P.Property = 'SpecifiedSourceCopy' THEN 'Content Indexing: Specified Source Copy'
				WHEN P.Property = 'DeferredDays' THEN 'Content Indexing: Defer Indexing for N Day(s)'
				WHEN P.Property = 'RetentionDays' THEN 'Content Indexing: Retention Days'
				WHEN P.Property = 'MinDocSizeKB' THEN 'Content Indexing: Minimum Document Size (KB)'
				WHEN P.Property = 'MaxDocSizeKB' THEN 'Content Indexin:g Maximum Document Size (KB)'
				WHEN P.Property = 'FilterSelected' THEN 'Content Indexing: File Type Filter'
			END,
			CASE WHEN P.Property IN ('SelectedSubclients', 'SpecifiedSourceCopy') THEN (CASE WHEN P.Value = 0 THEN 'No' ELSE 'Yes' END)
				WHEN P.Property = 'FilterSelected' THEN (CASE P.Value WHEN 0 THEN 'Not Set' WHEN 1 THEN 'Including' ELSE 'Excluding' END)
				WHEN P.Value = -1 THEN 'Infinite' ELSE CAST (P.Value AS VARCHAR(32)) END,
			CASE WHEN S.Property IN ('SelectedSubclients', 'SpecifiedSourceCopy') THEN (CASE WHEN S.Value = 0 THEN 'No' ELSE 'Yes' END)
				WHEN S.Property = 'FilterSelected' THEN (CASE S.Value WHEN 0 THEN 'Not Set' WHEN 1 THEN 'Including' ELSE 'Excluding' END)
				WHEN S.Value = -1 THEN 'Infinite' ELSE CAST (S.Value AS VARCHAR(32)) END
	FROM	ContentIndexingProperty P
			INNER JOIN
			(
				SELECT	Property, Value
				FROM	ContentIndexingProperty
				WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
			) S
			ON P.Property = S.Property AND P.Value <> S.Value
	SELECT	@stdCIFlags = Flags, @tempStr1 = JobSelection, @tempStr2 = IncludeDocTypes, @tempStr3 = ExcludeDocTypes, @stdFilterSelected = FilterSelected
	FROM	#ContentIndexing
	WHERE	CommServId = @i_stdCommServUniqueID AND PolicyId = @i_stdStoragePolicyID
	INSERT	INTO #PolicyProperty
	SELECT	P.CommServId, P.PolicyId, 5, F.name,
			CASE WHEN (P.Flags & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdCIFlags & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, PolicyId, Flags FROM #ContentIndexing WHERE Flags <> @stdCIFlags) P
			CROSS JOIN @TblCIFlags F
	WHERE	(P.Flags & F.flag) <> (@stdCIFlags & F.flag)
	INSERT	INTO #PolicyProperty
	SELECT	CommServId, PolicyId, 5, 'Content Indexing: Job Selection', JobSelection, @tempStr1
	FROM	#ContentIndexing
	WHERE	JobSelection <> @tempStr1
	IF @stdFilterSelected = 1
		INSERT	INTO #PolicyProperty
		SELECT	CommServId, PolicyId, 5, 'Content Indexing: Include Document Types', IncludeDocTypes, @tempStr2
		FROM	#ContentIndexing
		WHERE	FilterSelected = 1 AND IncludeDocTypes <> @tempStr2
	IF @stdFilterSelected = 2
		INSERT	INTO #PolicyProperty
		SELECT	CommServId, PolicyId, 5, 'Content Indexing: Exclude Document Types', ExcludeDocTypes, @tempStr3
		FROM	#ContentIndexing
		WHERE	FilterSelected = 2 AND ExcludeDocTypes <> @tempStr3
END
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, PolicyCount INT, AllProp INT, Basic INT, Dedupe INT, Retention INT, Snap INT, ContentIndex INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, 0, 0, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0), ISNULL([5], 0)
	FROM	(SELECT	CommServId, PropertyGroup, COUNT(DISTINCT PolicyId) AS Counts
			FROM	#PolicyProperty
			GROUP BY CommServId, PropertyGroup) AS S
			PIVOT (MAX(Counts) FOR S.PropertyGroup IN ([1], [2], [3], [4], [5])) AS P
	UPDATE	@TblSummary
	SET		PolicyCount = C.Count
	FROM	@TblSummary T
			INNER JOIN @TblPolicyCount C ON T.CommServId = C.CommServId
	UPDATE	@TblSummary
	SET		AllProp = S.Counts
	FROM	@TblSummary T
			INNER JOIN
			(SELECT	CommServId, COUNT(DISTINCT PolicyId) AS Counts
			FROM	#PolicyProperty
			GROUP BY CommServId) AS S
			ON T.CommServId = S.CommServId
	IF	NOT EXISTS (SELECT * FROM @TblSummary)
	INSERT	INTO @TblSummary
	SELECT	CommServId, Count, 0, 0,
			CASE WHEN @stdDedupeFlags > 0 THEN 0 ELSE -1 END, 0,
			CASE WHEN @stdPolicyType = 6 THEN 0 ELSE -1 END,
			CASE WHEN @stdEnableContentIndexing > 0 THEN 0 ELSE -1 END
	FROM	@TblPolicyCount
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			D.PolicyCount	AS 'All Policies',
			(SELECT COUNT(*) FROM @TblPassedPolicy)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			CASE WHEN @stdDedupeFlags > 0 THEN D.Dedupe	ELSE -1 END	AS 'Dedupe',
			D.Retention		AS 'Retention',
			CASE WHEN @stdPolicyType = 6 THEN D.Snap	ELSE -1 END	AS 'Snap',
			CASE WHEN @stdEnableContentIndexing > 0 THEN D.ContentIndex ELSE -1 END AS 'Content Indexing',
			D.AllProp		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1				AS 'FirstOrder<DONOTSHOW>'
	FROM	(SELECT SUM(PolicyCount) AS PolicyCount, SUM(AllProp) AS AllProp, SUM(Basic) AS Basic, SUM(Dedupe) AS Dedupe,
					SUM(Retention) AS Retention, SUM(Snap) AS Snap, SUM(ContentIndex) AS ContentIndex
			FROM	@TblSummary) D
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.PolicyCount	AS 'All Policies',
			(SELECT COUNT(*) FROM @TblPassedPolicy WHERE CommServId = D.CommServId)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			D.Dedupe		AS 'Dedupe',
			D.Retention		AS 'Retention',
			D.Snap			AS 'Snap',
			D.ContentIndex	AS 'Content Indexing',
			D.AllProp		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder<DONOTSHOW>'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder<DONOTSHOW>', 'CommCell'
END
ELSE
BEGIN
	IF	@i_PropertyGroupId <> 0
		DELETE #PolicyProperty WHERE PropertyGroup <> @i_PropertyGroupId
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END AS 'CommCell',
				S.PolicyName	AS 'Storage Policy',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#PolicyProperty P
				INNER JOIN #StoragePolicy S ON P.CommServId = S.CommServId AND P.PolicyId = S.PolicyId
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, S.PolicyName, P.PropertyGroup, P.Property
	ELSE
		SELECT	S.PolicyName	AS 'Storage Policy',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#PolicyProperty P
				INNER JOIN #StoragePolicy S ON P.CommServId = S.CommServId AND P.PolicyId = S.PolicyId
		ORDER BY S.PolicyName, P.PropertyGroup, P.Property
END
DROP TABLE #LatestResult
DROP TABLE #StoragePolicy
DROP TABLE #ExtendedRetention
DROP TABLE #BackupCopyInfo
DROP TABLE #ContentIndexing
DROP TABLE #PolicyProperty
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptStoragePolicyAudit')
	delete from GxQscripts where name = 'RptStoragePolicyAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptStoragePolicyAudit')
	delete from GXDBVersions where aliasname = 'RptStoragePolicyAudit'
GO

insert into GXDBVersions values(2, 'RptStoragePolicyAudit',  '00010011000200030000', 'RptStoragePolicyAudit', '00010011000200030000')
GO

