

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSourceDeDupEfficiency.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSourceDeDupEfficiency.sp,v $ $Id: RptSourceDeDupEfficiency.sp,v 1.8.2.5 2020/12/17 02:48:02 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptSourceDeDupEfficiency')
BEGIN
	print '>>> Drop Stored Procedure: RptSourceDeDupEfficiency <<<'
	drop procedure RptSourceDeDupEfficiency
END
IF EXISTS (select * from GxQscripts where name='RptSourceDeDupEfficiency')
	delete from GxQscripts where name = 'RptSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'RptSourceDeDupEfficiency'
GO
print '... Creating Procedure: RptSourceDeDupEfficiency'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptSourceDeDupEfficiency
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 97
SET @blLatestSurvey = 1 --Always pickup the latest
CREATE	TABLE #LatestResult (
		CommServUniqueId INT,
		CommCellId INT,
		CommServIP VARCHAR(256),
		CommServGUID VARCHAR(256),
		DisplayName NVARCHAR(256),
		CommServTZ VARCHAR(256),
		SurveyResultId BIGINT,
		RunningTime INT,
		LogDate	DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, CommCellId, CommServIP, CommServGUID,
		DisplayName, CommServTimeZone, SurverResultId, RunningTime, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId,@i_GroupId)
IF @i_CommServUniqueID = 0
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID<HIDDEN>',
		resultView.CommServIP AS 'CommServe IP<HIDDEN>',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL(CL.clientDisplayName, csInfo.ClientName) AS 'Client',
		csInfo.AgentName AS 'Agent',
		csInfo.InstanceName AS 'Instance<HIDDEN>',
		csInfo.BackupsetName AS 'Backupset<HIDDEN>',
		csInfo.SubclientName AS 'Subclient',
		CASE WHEN csInfo.SubclientDedupProp > 0 THEN 'Yes' ELSE 'No' END AS 'Deduplication Enabled',
		CASE csInfo.ClientDedupProp
			WHEN 0 THEN 'Use Storage Policy Settings'
			WHEN 1 THEN 'Perform Client Side Deduplication'
			WHEN 2 THEN 'Disable Client Side Deduplication'
			ELSE ''
		END AS 'Client Property',
		csInfo.ProtectedBytes/1024/1024 AS 'Protected App Size<SIZEMB>',
		csInfo.NwTransBytes/1024/1024 AS 'Network Transferred Size<SIZEMB>',
		csInfo.StoragePolicyName AS 'Storage Policy',
		csInfo.PrimaryCopyName AS 'Primary Copy',
		CASE WHEN csInfo.DedupOnSource > 0 THEN 'Yes' ELSE 'No' END AS 'Deduplication On Source'
	FROM cf_SurveySubclientsNoSourceDedup AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS resultView
			ON resultView.SurveyResultId = csInfo.SurveyResultId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = resultView.CommServUniqueId AND CL.ClientName = csInfo.ClientName
	ORDER BY 'CommCell Name' ASC, csInfo.ClientName, csInfo.AgentName, csInfo.InstanceName, csInfo.BackupsetName, csInfo.SubclientName
ELSE
	SELECT
		ISNULL(CL.clientDisplayName, csInfo.ClientName) AS 'Client',
		csInfo.AgentName AS 'Agent',
		csInfo.InstanceName AS 'Instance<HIDDEN>',
		csInfo.BackupsetName AS 'Backupset<HIDDEN>',
		csInfo.SubclientName AS 'Subclient',
		CASE WHEN csInfo.SubclientDedupProp > 0 THEN 'Yes' ELSE 'No' END AS 'Deduplication Enabled',
		CASE csInfo.ClientDedupProp
			WHEN 0 THEN 'Use Storage Policy Settings'
			WHEN 1 THEN 'Perform Client Side Deduplication'
			WHEN 2 THEN 'Disable Client Side Deduplication'
			ELSE ''
		END AS 'Client Property',
		csInfo.ProtectedBytes/1024/1024 AS 'Protected App Size<SIZEMB>',
		csInfo.NwTransBytes/1024/1024 AS 'Network Transferred Size<SIZEMB>',
		csInfo.StoragePolicyName AS 'Storage Policy',
		csInfo.PrimaryCopyName AS 'Primary Copy',
		CASE WHEN csInfo.DedupOnSource > 0 THEN 'Yes' ELSE 'No' END AS 'Deduplication On Source'
	FROM cf_SurveySubclientsNoSourceDedup AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS resultView
			ON resultView.SurveyResultId = csInfo.SurveyResultId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = resultView.CommServUniqueId AND CL.ClientName = csInfo.ClientName
	ORDER BY csInfo.ClientName, csInfo.AgentName, csInfo.InstanceName, csInfo.BackupsetName, csInfo.SubclientName
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptSourceDeDupEfficiency @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptSourceDeDupEfficiency')
	delete from GxQscripts where name = 'RptSourceDeDupEfficiency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSourceDeDupEfficiency')
	delete from GXDBVersions where aliasname = 'RptSourceDeDupEfficiency'
GO

insert into GXDBVersions values(2, 'RptSourceDeDupEfficiency',  '00010008000200050000', 'RptSourceDeDupEfficiency', '00010008000200050000')
GO

