

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptSLAExclusion.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptSLAExclusion.sp,v $ $Id: RptSLAExclusion.sp,v 1.1.2.1 2019/10/31 18:03:00 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptSLAExclusion')
BEGIN
	print '>>> Drop Stored Procedure: RptSLAExclusion <<<'
	drop procedure RptSLAExclusion
END
IF EXISTS (select * from GxQscripts where name='RptSLAExclusion')
	delete from GxQscripts where name = 'RptSLAExclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSLAExclusion')
	delete from GXDBVersions where aliasname = 'RptSLAExclusion'
GO
print '... Creating Procedure: RptSLAExclusion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptSLAExclusion
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 0,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 253
IF OBJECT_ID('tempdb..#SLAExclusion') IS NOT NULL DROP TABLE #SLAExclusion
CREATE TABLE #SLAExclusion
(
	CommServUniqueId INT,
	CommServName	NVARCHAR(512),
	ClientId		INT,
	ClientGroupId	INT,
	AppTypeId		INT,
	InstanceId		INT,
	BackupsetId		INT,
	AppId			INT,
	Category		INT,
	LastSeenTime	BIGINT
)
IF OBJECT_ID('tempdb..#BackupsetName') IS NOT NULL DROP TABLE #BackupsetName
CREATE TABLE #BackupsetName (CommServUniqueId INT, ClientId INT, AppTypeId INT,
		InstanceId INT, InstanceName NVARCHAR(512), BackupsetId INT, BackupsetName NVARCHAR(128))
INSERT	INTO #SLAExclusion
SELECT	CommServUniqueId, DisplayName, ClientId, ClientGroupId, AppTypeId, InstanceId, BackupsetId, AppId, Category,
		CASE WHEN LastSeenTime > 0 THEN LastSeenTime + DATEDIFF(SS, LogDateUTC, LogDate) ELSE 0 END
FROM	cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) R
		INNER JOIN cf_SurveySLAExclusion E WITH (NOLOCK) ON R.SurverResultId = E.SurveyResultId
SELECT	E.CommServUniqueId, E.ClientId, E.AppTypeId, E.InstanceId, SA.InstanceName, 0, ''
FROM	#SLAExclusion E
		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
			ON E.CommServUniqueId = SA.CommServUniqueId AND E.ClientId = SA.ClientId AND E.AppTypeId = SA.AppTypeId
			AND E.InstanceId = SA.InstanceId AND E.BackupsetId = 0 AND E.AppId = 0
WHERE	E.appTypeId <> 106
GROUP BY E.CommServUniqueId, E.ClientId, E.AppTypeId, E.InstanceId, SA.InstanceName
SELECT	E.CommServUniqueId, E.ClientId, E.AppTypeId, E.InstanceId, SA.InstanceName, E.BackupsetId, SA.BackupsetName
FROM	#SLAExclusion E
		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
			ON E.CommServUniqueId = SA.CommServUniqueId AND E.ClientId = SA.ClientId AND E.AppTypeId = SA.AppTypeId
			AND E.InstanceId = SA.InstanceId AND E.BackupsetId = SA.BackupsetId AND E.AppId = 0
WHERE	E.appTypeId <> 106
GROUP BY E.CommServUniqueId, E.ClientId, E.AppTypeId, E.InstanceId, SA.InstanceName, E.BackupsetId, SA.BackupsetName
IF @i_CommServUniqueID = 0
BEGIN
	SELECT 	E.CommServUniqueId AS 'CommServ UniqueId',
			E.CommServName AS 'CommCell Name',
			CL.ClientName  AS 'Client',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN 'Virtual Server in ' + ISNULL(SA.ClientName, '')
				 ELSE ISNULL(AT.name, '') END  AS 'Agent Type',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN ISNULL(SA.InstanceName, '')
				 ELSE ISNULL(BS.InstanceName, '') END AS 'Instance',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN ISNULL(SA.BackupsetName,'')
				 ELSE ISNULL(BS.BackupsetName,'') END AS 'Backup Set',
			ISNULL(SA.SubclientName, '') AS 'Subclient',
			CASE Category
				WHEN  5 THEN 'Backup activity disabled'
				WHEN  6 THEN 'Longtime offline'
				WHEN  8 THEN 'Excluded from SLA and strike count'
				WHEN 10 THEN 'Recently installed with no finished job'
				ELSE '' END AS 'Reason',
			CASE WHEN E.LastSeenTime <= 0 THEN -50 ELSE E.LastSeenTime END AS 'Last Seen<MMMDDYYYY>'
	FROM	#SLAExclusion E
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON E.CommServUniqueId = CL.CommServUniqueId AND E.clientId = CL.ClientId
			LEFT OUTER JOIN cf_SurveyClientGroup CG WITH (NOLOCK) ON E.CommServUniqueId = CG.CommServUniqueId AND E.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN cf_SurveyAgentType AT WITH (NOLOCK) ON E.appTypeId = AT.id
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON E.CommServUniqueId = SA.CommServUniqueId AND E.AppId = SA.AppId
			LEFT OUTER JOIN #BackupsetName BS ON E.CommServUniqueId = SA.CommServUniqueId AND E.ClientId = SA.ClientId AND E.AppTypeId = SA.AppTypeId
				AND E.InstanceId = SA.InstanceId AND E.BackupsetId = SA.BackupsetId AND E.AppId = 0
		ORDER BY 'CommCell Name', 'Client', 'Agent Type', 'Instance', 'Backup Set', 'Subclient'
END
ELSE
BEGIN
	SELECT	E.CommServUniqueId AS 'CommServ UniqueId',
			E.ClientId    AS 'ClientId<DONOTSHOW>',
			E.AppTypeId   AS 'AppTypeId<DONOTSHOW>',
			E.InstanceId  AS 'InstanceId<DONOTSHOW>',
			E.BackupsetId AS 'BackupsetId<DONOTSHOW>',
			E.AppId       AS 'AppId<DONOTSHOW>',
			CL.ClientName AS 'Client',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN 'Virtual Server in ' + ISNULL(SA.ClientName, '')
				 ELSE ISNULL(AT.name, '') END  AS 'Agent Type',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN ISNULL(SA.InstanceName, '')
				 ELSE ISNULL(BS.InstanceName, '') END AS 'Instance',
			CASE WHEN E.AppTypeId = 106 AND E.AppId > 0 THEN ISNULL(SA.BackupsetName,'')
				 ELSE ISNULL(BS.BackupsetName,'') END AS 'Backup Set',
			ISNULL(SA.SubclientName, '') AS 'Subclient',
			CASE Category
				WHEN  5 THEN 'Backup activity disabled'
				WHEN  6 THEN 'Longtime offline'
				WHEN  8 THEN 'Excluded from SLA and strike count'
				WHEN 10 THEN 'Recently installed with no finished job'
				ELSE '' END AS 'Reason',
			CASE WHEN E.LastSeenTime <= 0 THEN -50 ELSE E.LastSeenTime END AS 'Last Seen<MMMDDYYYY>'
	FROM	#SLAExclusion E
			INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON E.CommServUniqueId = CL.CommServUniqueId AND E.clientId = CL.ClientId
			LEFT OUTER JOIN cf_SurveyClientGroup CG WITH (NOLOCK) ON E.CommServUniqueId = CG.CommServUniqueId AND E.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN cf_SurveyAgentType AT WITH (NOLOCK) ON E.appTypeId = AT.id
			LEFT OUTER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON E.CommServUniqueId = SA.CommServUniqueId AND E.AppId = SA.AppId
			LEFT OUTER JOIN #BackupsetName BS ON E.CommServUniqueId = SA.CommServUniqueId AND E.ClientId = SA.ClientId AND E.AppTypeId = SA.AppTypeId
				AND E.InstanceId = SA.InstanceId AND E.BackupsetId = SA.BackupsetId AND E.AppId = 0
	ORDER BY 'Client', 'Agent Type', 'Instance', 'Backup Set', 'Subclient'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptSLAExclusion')
	delete from GxQscripts where name = 'RptSLAExclusion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptSLAExclusion')
	delete from GXDBVersions where aliasname = 'RptSLAExclusion'
GO

insert into GXDBVersions values(2, 'RptSLAExclusion',  '00010001000200010000', 'RptSLAExclusion', '00010001000200010000')
GO

