

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptQAStatistics.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptQAStatistics.sp,v $ $Id: RptQAStatistics.sp,v 1.5 2015/07/06 20:31:48 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptQAStatistics <<<'

IF EXISTS (select * from sysobjects where name='RptQAStatistics')
	drop procedure RptQAStatistics
IF EXISTS (select * from GxQscripts where name='RptQAStatistics')
	delete from GxQscripts where name = 'RptQAStatistics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQAStatistics')
	delete from GXDBVersions where aliasname = 'RptQAStatistics'
GO
print '... Creating Procedure: RptQAStatistics'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptQAStatistics
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 15
IF (OBJECT_ID('tempdb.dbo.#tmpSurveyQAStatInfo') IS NOT NULL)
	DROP TABLE #tmpSurveyQAStatInfo
CREATE TABLE #tmpSurveyQAStatInfo(
	CommServUniqueId INTEGER NOT NULL,
	CommCellID VARCHAR(32) NOT NULL,
	CommServIP VARCHAR(256) NOT NULL,
	CommServGUID VARCHAR(256) NOT NULL,
	CustomerName NVARCHAR(256) NOT NULL,
	LogDate DATETIME NOT NULL,
	RunningTime INT NOT NULL,
	CommServTZ NVARCHAR(MAX) NOT NULL,
	CommServerName NVARCHAR(MAX),
	spCount INTEGER,
	secSPCount INTEGER,
	totalRstJobs  INTEGER,
	totalRstSJobs INTEGER,
	totalRstFJobs INTEGER,
	totalRstKJobs INTEGER,
	totalRstOJobs INTEGER,
	totalsc INTEGER,
	totSchedulessc INTEGER
)
INSERT INTO #tmpSurveyQAStatInfo
SELECT
	tmpsurveyxml.CommServUniqueId,
	tmpsurveyxml.CommCellID,
	tmpsurveyxml.CommServIP,
	tmpsurveyxml.CommServGUID,
	tmpsurveyxml.CustomerName,
	tmpsurveyxml.LogDate,
	tmpsurveyxml.RunningTime,
	tmpsurveyxml.CommServTZ,
	csInfo.n.value('@CommServerName','NVARCHAR(MAX)') AS CommServerName,
	csInfo.n.value('@StoagePolicy','INTEGER') AS spCount
    ,csInfo.n.value('@StoagePolicyHavingSecondaryCopy','INTEGER') AS secSPCount
	,csInfo.n.value('@TotalRestoreJobs','INTEGER') AS totalRstJobs
	,csInfo.n.value('@SucceedRestoreJobs','INTEGER') AS totalRstSJobs
	,csInfo.n.value('@FailedRestoreJobs','INTEGER') AS totalRstFJobs
	,csInfo.n.value('@KilledRestoreJobs','INTEGER') AS totalRstKJobs
	,csInfo.n.value('@OtherRestoreJobs','INTEGER') AS totalRstOJobs
	,csInfo.n.value('@TotalSubclient','INTEGER') AS totalsc
	,csInfo.n.value('@SubclientsWithSchedules','INTEGER') AS totSchedulessc
FROM
	dbo.RptGetSurveyResultsFunc(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId) AS tmpsurveyxml
	CROSS apply tmpsurveyxml.surveyxml.nodes('/QAStatisticsXML') AS csInfo(n)
IF(@blaggregate=1)
SELECT DISTINCT
	SUM (spCount) AS 'Total Storage Policy',
	SUM (secSPCount) as 'Total StoragePolicy Having Secondary Copy',
	SUM (totalRstJobs) AS 'Total Restore Jobs',
	SUM (totalRstSJobs) AS 'Succeed Restore Jobs',
	SUM (totalRstFJobs) AS 'Failed Restore Jobs',
	SUM (totalRstKJobs) AS 'Killed Restore Jobs',
	SUM (totalRstOJobs) AS 'Other Restore Jobs',
	SUM (totalsc) AS 'Total Subclients',
	SUM (totSchedulessc) AS 'Total Subclients Having Schedules',
	COUNT (CommCellID) AS 'CommCell Count'
FROM #tmpSurveyQAStatInfo AS info
ELSE
BEGIN
IF @i_CommServUniqueID = 0
SELECT
	ccMap.CommServUniqueId AS 'CommServ UniqueId',
	ccMap.CommCellID AS 'CommCell ID',
	ccMap.CommServIP AS 'CommServe IP<HIDDEN>',
	ccMap.CommServGUID AS 'CommServer GUID',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	ISNULL(info.CommServTZ, '')  AS 'TimeZone',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	CommServerName AS 'CommServ Name',
	spCount AS 'Total Storage Policy',
	secSPCount as 'Total StoragePolicy Having Secondary Copy',
	totalRstJobs AS 'Total Restore Jobs',
	totalRstSJobs AS 'Succeed Restore Jobs',
	totalRstFJobs AS 'Failed Restore Jobs',
	totalRstKJobs AS 'Killed Restore Jobs',
	totalRstOJobs AS 'Other Restore Jobs',
	totalsc AS 'Total Subclients',
	totSchedulessc AS 'Total Subclients Having Schedules'
FROM #tmpSurveyQAStatInfo AS info
RIGHT OUTER JOIN  dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS ccMap
	ON info.CommServUniqueId = ccMap.CommServUniqueId
ORDER BY info.LogDate DESC, info.CustomerName ASC
ELSE
SELECT
	info.CommServUniqueId AS 'CommServ UniqueId',
	DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
	CASE
		WHEN info.RunningTime = -1 THEN 'N/A'
		ELSE CAST(info.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	CommServerName AS 'CommServ Name',
	spCount AS 'Total Storage Policy',
	secSPCount as 'Total StoragePolicy Having Secondary Copy',
	totalRstJobs AS 'Total Restore Jobs',
	totalRstSJobs AS 'Succeed Restore Jobs',
	totalRstFJobs AS 'Failed Restore Jobs',
	totalRstKJobs AS 'Killed Restore Jobs',
	totalRstOJobs AS 'Other Restore Jobs',
	totalsc AS 'Total Subclients',
	totSchedulessc AS 'Total Subclients Having Schedules'
FROM #tmpSurveyQAStatInfo AS info
ORDER BY info.LogDate DESC, info.CustomerName ASC
END
IF (OBJECT_ID('tempdb.dbo.#tmpSurveyQAStatInfo') IS NOT NULL)
	DROP TABLE #tmpSurveyQAStatInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptQAStatistics')
	delete from GxQscripts where name = 'RptQAStatistics'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptQAStatistics')
	delete from GXDBVersions where aliasname = 'RptQAStatistics'
GO

insert into GXDBVersions values(2, 'RptQAStatistics',  '00010005000000000000', 'RptQAStatistics', '00010005000000000000')
GO

