

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptMediaAgentAudit.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptMediaAgentAudit.sp,v $ $Id: RptMediaAgentAudit.sp,v 1.7.2.6 2020/12/17 02:53:20 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptMediaAgentAudit')
BEGIN
	print '>>> Drop Stored Procedure: RptMediaAgentAudit <<<'
	drop procedure RptMediaAgentAudit
END
IF EXISTS (select * from GxQscripts where name='RptMediaAgentAudit')
	delete from GxQscripts where name = 'RptMediaAgentAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaAgentAudit')
	delete from GXDBVersions where aliasname = 'RptMediaAgentAudit'
GO
print '... Creating Procedure: RptMediaAgentAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptMediaAgentAudit
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @bAggregate INT = 1,
  @i_stdCommServUniqueID INT = 0,
  @i_stdMAClientID INT = 0,
  @i_CommServUniqueID INT = 0,
  @i_PropertyGroup VARCHAR(32) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 88
-- default is for all properties
DECLARE @i_PropertyGroupId INT = 0
IF	@i_PropertyGroup = 'Passed Audit'
	SET @i_PropertyGroupId = -1
ELSE IF	@i_PropertyGroup = 'Basic'
	SET @i_PropertyGroupId = 1
ELSE IF	@i_PropertyGroup = 'Index Cache'
	SET @i_PropertyGroupId = 2
ELSE IF	@i_PropertyGroup = 'Firewall'
	SET @i_PropertyGroupId = 3
ELSE IF	@i_PropertyGroup = 'Network Throttle'
	SET @i_PropertyGroupId = 4
DECLARE @stdCustomerName	VARCHAR(256) = ''
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isPrivate'
IF	@isPrivate = 0
	SELECT @stdCustomerName = CustomerName FROM cf_CommcellIdNameMap WHERE ID = @i_stdCommServUniqueID
CREATE	TABLE #LatestResult (CommServId INT, SurveyResultId BIGINT, LogDate DATETIME)
INSERT	INTO #LatestResult
SELECT	CommServUniqueId, SurverResultId, LogDate
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, 0, 1, NULL, NULL, @i_UserId,@i_GroupId)
WHERE	(@stdCustomerName = '' OR CustomerName = @stdCustomerName)
IF	@i_stdCommServUniqueID > 0 AND @i_stdMAClientID = 0
BEGIN
	SELECT	MA.CommServUniqueId	AS 'CommServ UniqueId',
			ISNULL(CL.clientDisplayName, MA.MediaAgentName) AS 'MediaAgent',
			MA.MAClientID AS 'MediaAgent ID'
	FROM	#LatestResult LD
			INNER JOIN cf_SurveyMediaAgentProp MA
				ON MA.CommServUniqueId = LD.CommServId AND MA.SurveyResultId = LD.SurveyResultId
			LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = MA.CommServUniqueId AND CL.ClientId = MA.MAClientID
	WHERE	MA.CommServUniqueId = @i_stdCommServUniqueID
	ORDER BY MA.MediaAgentName
	DROP TABLE #LatestResult
	RETURN
END
DECLARE @TblMediaAgentFlags	TABLE (flag INT, name VARCHAR(128))
DECLARE @MediaAgentFlags	INT
INSERT INTO @TblMediaAgentFlags
SELECT 1, 'Auto Update SCSI ID during live operation'
UNION ALL SELECT 2, 'Use Native device driver for data transfer for tape media'
UNION ALL SELECT 4, 'Mark drive inaccessible on error'
UNION ALL SELECT 8, 'Automatically detect WORM Tape Media'
UNION ALL SELECT 16, 'Mark MediaAgent For Maintenance'
UNION ALL SELECT 32, 'Optimize for concurrent LAN backups'
UNION ALL SELECT 64, 'Enable Error Recovery During Backup'
UNION ALL SELECT 128, 'Use MediaAgent Local Drive'
UNION ALL SELECT 256, 'Data Integrity Validation on Network'
UNION ALL SELECT 512, 'Data Integrity Validation on Media'
UNION ALL SELECT 1024, 'Send pass-thru commands to Atape'
--UNION ALL SELECT MMS2_MA_DDB_SUBCLIENT_BACKUP_ENABLED, 'DDB Subclient Backup Enabled'
--UNION ALL SELECT MMS2_MA_HOST_IS_LIBRARY_SERVER, 'Host is Library Server'
--UNION ALL SELECT MMS2_MA_HOST_PUSHED_FROM_ANOTHER_CS, 'Host Pushed from Another CommServ'
SELECT @MediaAgentFlags	= SUM(Flag) FROM @TblMediaAgentFlags
CREATE TABLE #MediaAgentProp
(
	CommServId				int,
	MAClientID				int NOT NULL,
	MediaAgentName			nvarchar(256) NOT NULL,
	MAReleaseVersion		varchar(8) NOT NULL,
	MAEnabled				int NOT NULL,
	MAAttribute				int NOT NULL,
	ScanIntervalInHour		int NOT NULL,
	MaxReservations			int NOT NULL,
	NwErrorRetryEnabled		int NOT NULL,
	NwErrorRetryFrequency	int NOT NULL,
	NwErrorRetryCount		int NOT NULL,
	AccessPathEnabled		int NOT NULL,
	UseNetworkShare			int NOT NULL,
	IntermediateIndexCache	int NOT NULL,
	IdxCleanupPct			int NOT NULL,
	IdxCacheServerEnabled	int NOT NULL,
	IdxMinFreeSpaceMB		int NOT NULL,
	IdxFreeSpaceWarningMB	int NOT NULL,
	IdxPoolIsShared			int NOT NULL,
	IdxRetentionDays		int NOT NULL,
	FirewallSettings		int NOT NULL,
	FwNetworkWithCS			int NOT NULL,
	FwConnectionWithCS		int NOT NULL,
	FwNetworkWithMA			int NOT NULL,
	FwConnectionWithMA		int NOT NULL,
	FwKeepAliveSeconds		int NOT NULL,
	FwTunnelInitSeconds		int NOT NULL,
	FwForeceSSL				int NOT NULL,
	FwLockDown				int NOT NULL,
	FwBindOpenPortsOnly		int NOT NULL,
	FwIsDMZ					int NOT NULL,
	FwIsRoamingClient		int NOT NULL,
	FwDefOutgoingProtocol	int NOT NULL,
	NwThrottlingEnabled		int NOT NULL,
	NwShareBandwidth		int NOT NULL,
	NwDaysOfWeek			varchar(256) NOT NULL,
	NwStartTime				int NOT NULL,
	NwEndTime				int NOT NULL,
	NwIsAbsolute			int NOT NULL,
	NwSendEnabled			int NOT NULL,
	NwSendRate				int NOT NULL,
	NwSendRatePct			int NOT NULL,
	NwRecvEnabled			int NOT NULL,
	NwRecvRate				int NOT NULL,
	NwRecvRatePct			int NOT NULL
)
INSERT	INTO #MediaAgentProp
SELECT	MA.CommServUniqueId,
		MAClientID,
		ISNULL(CL.clientDisplayName, MA.MediaAgentName),
		MAReleaseVersion,
		MAEnabled,
		(MAAttribute & @MediaAgentFlags),
		ScanIntervalInSec/3600,
		MaxReservations,
		(NwErrorRetryFlag & 1),
		NwErrorRetryFrequency,
		NwErrorRetryCount,
		AccessPathEnabled,
		UseNetworkShare,
		(AccessPathFlags & 1),
		IdxCleanupPct,
		CASE WHEN IdxPoolIsShared = 1 AND IdxCacheServerClientId > 0 THEN 1 ELSE 0 END,
		IdxMinFreeSpaceMB,
		IdxFreeSpaceWarningMB,
		IdxPoolIsShared,
		IdxRetentionDays,
		FirewallSettings,
		FwNetworkWithCS,
		CASE WHEN FwNetworkWithCS = 1 THEN 1 ELSE FwConnectionWithCS END,
		FwNetworkWithMA,
		CASE WHEN FwNetworkWithMA = 1 THEN 1 ELSE FwConnectionWithMA END,
		FwKeepAliveSeconds,
		FwTunnelInitSeconds,
		FwForeceSSL,
		FwLockDown,
		FwBindOpenPortsOnly,
		FwIsDMZ,
		FwIsRoamingClient,
		FwDefOutgoingProtocol,
		NwThrottlingEnabled,
		NwShareBandwidth,
		CASE WHEN NwDaysOfWeek&1 > 0 THEN 'Sunday ' ELSE '' END + CASE WHEN NwDaysOfWeek&2 > 0 THEN 'Monday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&4 > 0 THEN 'Tuesday ' ELSE '' END + CASE WHEN NwDaysOfWeek&8 > 0 THEN 'Wednesday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&16> 0 THEN 'Thursday ' ELSE '' END + CASE WHEN NwDaysOfWeek&32> 0 THEN 'Friday ' ELSE '' END +
		CASE WHEN NwDaysOfWeek&64> 0 THEN 'Saturday' ELSE '' END,
		NwStartTime,
		NwEndTime,
		NwIsAbsolute,
		NwSendEnabled,
		NwSendRate,
		NwSendRatePct,
		NwRecvEnabled,
		NwRecvRate,
		NwRecvRatePct
FROM	#LatestResult LD
		INNER JOIN cf_SurveyMediaAgentProp MA
			ON MA.CommServUniqueId = LD.CommServId AND MA.SurveyResultId = LD.SurveyResultId
		LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = MA.CommServUniqueId AND CL.ClientId = MA.MAClientID
WHERE	(MA.CommServUniqueId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID
		OR  @i_CommServUniqueID = 0 OR MA.CommServUniqueId = @i_CommServUniqueID)
IF EXISTS (SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID AND UseNetworkShare = -1 AND IdxPoolIsShared = -1)
	UPDATE	#MediaAgentProp
	SET		UseNetworkShare = -1, IntermediateIndexCache = -1, IdxCacheServerEnabled = -1, IdxPoolIsShared = -1
BEGIN
	UPDATE	#MediaAgentProp
	SET		UseNetworkShare = ISNULL((SELECT UseNetworkShare FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID), -1)
	WHERE	UseNetworkShare = -1
	UPDATE	#MediaAgentProp
	SET		IntermediateIndexCache = ISNULL((SELECT IntermediateIndexCache FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID), -1)
	WHERE	IntermediateIndexCache = -1
	UPDATE	#MediaAgentProp
	SET		IdxCacheServerEnabled = ISNULL((SELECT IdxCacheServerEnabled FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID), -1)
	WHERE	IdxCacheServerEnabled = -1
	UPDATE	#MediaAgentProp
	SET		IdxPoolIsShared = ISNULL((SELECT IdxPoolIsShared FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientID = @i_stdMAClientID), -1)
	WHERE	IdxPoolIsShared = -1
END
DECLARE	@TblPassedMA TABLE (CommServId INT, MAClientId INT, MediaAgentName NVARCHAR(256))
INSERT	INTO @TblPassedMA
SELECT	P.CommServId, P.MAClientId, P.MediaAgentName
FROM	#MediaAgentProp P INNER JOIN
		(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
	ON	(P.CommServId <> S.CommServId OR P.MAClientId <> S.MAClientId)
	AND P.MAReleaseVersion		= S.MAReleaseVersion
	AND P.MAEnabled				= S.MAEnabled
	AND P.MAAttribute			= S.MAAttribute
	AND P.ScanIntervalInHour	= S.ScanIntervalInHour
	AND P.MaxReservations		= S.MaxReservations
	AND P.NwErrorRetryEnabled	= S.NwErrorRetryEnabled
	AND P.NwErrorRetryFrequency	= S.NwErrorRetryFrequency
	AND P.NwErrorRetryCount		= S.NwErrorRetryCount
	AND P.AccessPathEnabled		= S.AccessPathEnabled
	AND P.UseNetworkShare		= S.UseNetworkShare
	AND P.IntermediateIndexCache= S.IntermediateIndexCache
	AND P.IdxCleanupPct			= S.IdxCleanupPct
	AND P.IdxCacheServerEnabled	= S.IdxCacheServerEnabled
	AND P.IdxMinFreeSpaceMB		= S.IdxMinFreeSpaceMB
	AND P.IdxFreeSpaceWarningMB	= S.IdxFreeSpaceWarningMB
	AND P.IdxPoolIsShared		= S.IdxPoolIsShared
	AND P.IdxRetentionDays		= S.IdxRetentionDays
	AND P.FirewallSettings		= S.FirewallSettings
	AND (P.FirewallSettings		= 0
		OR	P.FirewallSettings	= 1
			AND P.FwNetworkWithCS		= S.FwNetworkWithCS
			AND P.FwConnectionWithCS	= S.FwConnectionWithCS
			AND P.FwNetworkWithMA		= S.FwNetworkWithMA
			AND P.FwConnectionWithMA	= S.FwConnectionWithMA
		OR	P.FirewallSettings	= 2
			AND P.FwKeepAliveSeconds	= S.FwKeepAliveSeconds
			AND P.FwTunnelInitSeconds	= S.FwTunnelInitSeconds
			AND P.FwForeceSSL			= S.FwForeceSSL
			AND P.FwLockDown			= S.FwLockDown
			AND P.FwBindOpenPortsOnly	= S.FwBindOpenPortsOnly
			AND P.FwIsDMZ				= S.FwIsDMZ
			AND P.FwIsRoamingClient		= S.FwIsRoamingClient
			AND P.FwDefOutgoingProtocol	= S.FwDefOutgoingProtocol
		)
	AND P.NwThrottlingEnabled	= S.NwThrottlingEnabled
	AND (P.NwThrottlingEnabled	= 0
		OR	P.NwShareBandwidth	= S.NwShareBandwidth
			AND P.NwDaysOfWeek	= S.NwDaysOfWeek
			AND P.NwStartTime	= S.NwStartTime
			AND P.NwEndTime		= S.NwEndTime
			AND P.NwIsAbsolute	= S.NwIsAbsolute
			AND P.NwSendEnabled	= S.NwSendEnabled
			AND P.NwSendRate	= S.NwSendRate
			AND P.NwSendRatePct	= S.NwSendRatePct
			AND P.NwRecvEnabled	= S.NwRecvEnabled
			AND P.NwRecvRate	= S.NwRecvRate
			AND P.NwRecvRatePct	= S.NwRecvRatePct
		)
IF	@i_PropertyGroupId = -1
BEGIN
	IF	@i_CommServUniqueID = 0
		SELECT	CS.CommServName	AS 'CommCell',
				P.MediaAgentName AS 'MediaAgent'
		FROM	@TblPassedMA P
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
		ORDER BY CS.CommServName, P.MediaAgentName
	ELSE
		SELECT	MediaAgentName AS 'MediaAgent'
		FROM	@TblPassedMA
		ORDER BY MediaAgentName
	DROP TABLE #LatestResult
	DROP TABLE #MediaAgentProp
	RETURN
END
DECLARE	@TblMACount TABLE (CommServId INT, Count INT)
INSERT	INTO @TblMACount
SELECT	CommServId, COUNT(MAClientId)
FROM	#MediaAgentProp
WHERE	CommServId <> @i_stdCommServUniqueID OR MAClientId <> @i_stdMAClientID
GROUP BY CommServId
DELETE	#MediaAgentProp
FROM	@TblPassedMA P
WHERE	#MediaAgentProp.CommServId = P.CommServId AND #MediaAgentProp.MAClientId = P.MAClientId
DECLARE	@stdMAReleaseVersion	VARCHAR(8)
DECLARE	@stdMAAttribute			INT
DECLARE	@stdNwDaysOfWeek		VARCHAR(256)
SELECT	@stdMAReleaseVersion	= MAReleaseVersion,
		@stdMAAttribute			= MAAttribute,
		@stdNwDaysOfWeek		= NwDaysOfWeek
FROM	#MediaAgentProp
WHERE	CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID
UPDATE	#MediaAgentProp SET ScanIntervalInHour = S.ScanIntervalInHour
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
AND ((#MediaAgentProp.MAAttribute & 1) = 0
OR (S.MAAttribute & 1) = 0)
UPDATE	#MediaAgentProp SET NwErrorRetryFrequency = S.NwErrorRetryFrequency, NwErrorRetryCount = S.NwErrorRetryCount
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.NwErrorRetryEnabled = 0 OR S.NwErrorRetryEnabled = 0)
UPDATE	#MediaAgentProp
SET		FwKeepAliveSeconds = S.FwKeepAliveSeconds, FwTunnelInitSeconds = S.FwTunnelInitSeconds, FwForeceSSL = S.FwForeceSSL, FwLockDown = S.FwLockDown,
		FwBindOpenPortsOnly = S.FwBindOpenPortsOnly, FwIsDMZ = S.FwIsDMZ, FwIsRoamingClient = S.FwIsRoamingClient, FwDefOutgoingProtocol = S.FwDefOutgoingProtocol
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.FirewallSettings IN (0, 1) OR S.FirewallSettings IN (0, 1))
UPDATE	#MediaAgentProp
SET		FwNetworkWithCS = S.FwNetworkWithCS, FwConnectionWithCS = S.FwConnectionWithCS,
		FwNetworkWithMA = S.FwNetworkWithMA, FwConnectionWithMA = S.FwConnectionWithMA
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.FirewallSettings IN (0, 2) OR S.FirewallSettings IN (0, 2))
UPDATE	#MediaAgentProp
SET		NwShareBandwidth = S.NwShareBandwidth, NwDaysOfWeek = S.NwDaysOfWeek,
		NwStartTime = S.NwStartTime, NwEndTime = S.NwEndTime, NwIsAbsolute = S.NwIsAbsolute,
		NwSendEnabled = S.NwSendEnabled, NwSendRate = S.NwSendRate, NwSendRatePct = S.NwSendRatePct,
		NwRecvEnabled = S.NwRecvEnabled, NwRecvRate = S.NwRecvRate, NwRecvRatePct = S.NwRecvRatePct
FROM	(SELECT * FROM #MediaAgentProp WHERE CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID) S
WHERE	(#MediaAgentProp.CommServId <> @i_stdCommServUniqueID OR #MediaAgentProp.MAClientId <> @i_stdMAClientID)
	AND (#MediaAgentProp.NwThrottlingEnabled = 0 OR S.NwThrottlingEnabled = 0)
CREATE	TABLE #MediaAgentProperty (CommServId INT, MAClientId INT, PropertyGroup INT, Property VARCHAR(128), Value NVARCHAR(MAX), stdValue NVARCHAR(MAX))
;WITH MediaAgentProperty (CommServId, MAClientId, Property, Value) AS
(
	SELECT	P.CommServId, P.MAClientId, P.Property, P.Value
	FROM	#MediaAgentProp
			UNPIVOT (Value FOR Property IN (
				MAEnabled, ScanIntervalInHour, MaxReservations,
				NwErrorRetryEnabled, NwErrorRetryFrequency, NwErrorRetryCount,
				AccessPathEnabled, UseNetworkShare, IntermediateIndexCache, IdxCleanupPct, IdxCacheServerEnabled,
				IdxMinFreeSpaceMB, IdxFreeSpaceWarningMB, IdxPoolIsShared, IdxRetentionDays,
				FirewallSettings, FwNetworkWithCS, FwConnectionWithCS, FwNetworkWithMA, FwConnectionWithMA,
				FwKeepAliveSeconds, FwTunnelInitSeconds, FwForeceSSL, FwLockDown,
				FwBindOpenPortsOnly, FwIsDMZ, FwIsRoamingClient, FwDefOutgoingProtocol,
				NwThrottlingEnabled, NwShareBandwidth, NwStartTime, NwEndTime, NwIsAbsolute,
				NwSendEnabled, NwSendRate, NwSendRatePct, NwRecvEnabled, NwRecvRate, NwRecvRatePct)
			) P
)
INSERT	INTO #MediaAgentProperty
SELECT	P.CommServId, P.MAClientId,
		CASE WHEN P.Property IN ('MAEnabled', 'ScanIntervalInHour', 'MaxReservations',
								'NwErrorRetryEnabled', 'NwErrorRetryFrequency', 'NwErrorRetryCount') THEN 1
			WHEN P.Property IN ('AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache', 'IdxCleanupPct', 'IdxCacheServerEnabled',
								'IdxMinFreeSpaceMB', 'IdxFreeSpaceWarningMB', 'IdxPoolIsShared', 'IdxRetentionDays') THEN 2
			WHEN P.Property IN ('FirewallSettings',  'FwNetworkWithCS', 'FwConnectionWithCS', 'FwNetworkWithMA', 'FwConnectionWithMA',
								'FwKeepAliveSeconds', 'FwTunnelInitSeconds', 'FwForeceSSL', 'FwLockDown',
								'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient', 'FwDefOutgoingProtocol') THEN 3
			WHEN P.Property IN ('NwThrottlingEnabled', 'NwShareBandwidth', 'NwStartTime', 'NwEndTime', 'NwIsAbsolute', 'NwSendEnabled',
								'NwSendRate', 'NwSendRatePct', 'NwRecvEnabled', 'NwRecvRate', 'NwRecvRatePct') THEN 4
		END,
		CASE WHEN P.Property = 'MAEnabled' THEN 'Enable MediaAgent'
			WHEN P.Property = 'ScanIntervalInHour' THEN 'SCSI/SAN device scan interval N Hour(s)'
			WHEN P.Property = 'MaxReservations' THEN 'Maximum number of parallel data transfer operations'
			WHEN P.Property = 'NwErrorRetryEnabled' THEN 'Enable retry on network errors'
			WHEN P.Property = 'NwErrorRetryFrequency' THEN 'Retry Frequency (seconds) on network errors'
			WHEN P.Property = 'NwErrorRetryCount' THEN 'Retry Count on network errors'
			WHEN P.Property = 'AccessPathEnabled' THEN 'Access Path Enabled'
			WHEN P.Property = 'UseNetworkShare' THEN 'Cache Directory Folder Type: Use Network Share'
			WHEN P.Property = 'IntermediateIndexCache' THEN 'Enable Intermediate Index Cache Directory'
			WHEN P.Property = 'IdxCleanupPct' THEN 'Index Cleanup Percent'
			WHEN P.Property = 'IdxCacheServerEnabled' THEN 'Index Cache Server'
			WHEN P.Property = 'IdxMinFreeSpaceMB' THEN 'Index Cache: Minimum Free Space (MB)'
			WHEN P.Property = 'IdxFreeSpaceWarningMB' THEN 'Index Cache: Free Space Warning (MB)'
			WHEN P.Property = 'IdxPoolIsShared' THEN 'Catalog Profile'
			WHEN P.Property = 'IdxRetentionDays' THEN 'Index retention time in days'
			WHEN P.Property = 'FirewallSettings' THEN 'Configure Firewall Settings'
			WHEN P.Property = 'FwNetworkWithCS' THEN 'CommServe Connectivity'
			WHEN P.Property = 'FwConnectionWithCS' THEN 'CommServe Connectivity: When connecting from outside'
			WHEN P.Property = 'FwNetworkWithMA' THEN 'MediaAgent Connectivity'
			WHEN P.Property = 'FwConnectionWithMA' THEN 'MediaAgent Connectivity: When connecting from outside'
			WHEN P.Property = 'FwKeepAliveSeconds' THEN 'Firewall Options: Keep-alive Interval (seconds)'
			WHEN P.Property = 'FwTunnelInitSeconds' THEN 'Firewall Options: Tunnel Init Interval (seconds)'
			WHEN P.Property = 'FwForeceSSL' THEN 'Firewall Options: Force SSL authentication in incoming tunnel connections'
			WHEN P.Property = 'FwLockDown' THEN 'Firewall Options: Force per-client certificate based authentication'
			WHEN P.Property = 'FwBindOpenPortsOnly' THEN 'Firewall Options: Bind all services to open ports only'
			WHEN P.Property = 'FwIsDMZ' THEN 'Firewall Options: This computer is in DMZ and will work as a proxy'
			WHEN P.Property = 'FwIsRoamingClient' THEN 'Firewall Options: Roaming client'
			WHEN P.Property = 'FwDefOutgoingProtocol' THEN 'Firewall Default Outgoing Tunnel Protocol'
			WHEN P.Property = 'NwThrottlingEnabled' THEN 'Enable Network Throttling'
			WHEN P.Property = 'NwShareBandwidth' THEN 'All clients share allocation bandwidth'
			WHEN P.Property = 'NwStartTime' THEN 'Throttling Rule: Time interval start'
			WHEN P.Property = 'NwEndTime' THEN 'Throttling Rule: Time interval end'
			WHEN P.Property = 'NwIsAbsolute' THEN 'Use Absolute Throttling'
			WHEN P.Property = 'NwSendEnabled' THEN 'Enable Throttle Send'
			WHEN P.Property = 'NwSendRate' THEN 'Throttle Send (Kbps)'
			WHEN P.Property = 'NwSendRatePct' THEN 'If send bandwidth is less than (Kbps) throttle at (%)'
			WHEN P.Property = 'NwRecvEnabled' THEN 'Enable Throttle Receive'
			WHEN P.Property = 'NwRecvRate' THEN 'Throttle Receive (Kbps)'
			WHEN P.Property = 'NwRecvRatePct' THEN 'If receive bandwidth is less than (Kbps) throttle at (%)'
		END,
		CASE WHEN P.Property IN ('MAEnabled', 'NwErrorRetryEnabled', 'AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache',
								'IdxCacheServerEnabled', 'IdxPoolIsShared', 'FwConnectionWithCS', 'FwConnectionWithMA',
								'FwForeceSSL', 'FwLockDown', 'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient',
								'NwThrottlingEnabled', 'NwShareBandwidth', 'NwIsAbsolute', 'NwSendEnabled', 'NwRecvEnabled')
				THEN (CASE P.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN P.Property IN ('NwStartTime', 'NwEndTime') THEN RIGHT(CONVERT(VARCHAR, DATEADD(s, P.value, 0), 100), 7)
			WHEN P.Property = 'FirewallSettings' THEN (CASE P.value WHEN 1 THEN 'Basic' WHEN 2 THEN 'Advanced' ELSE 'No' END)
			WHEN P.Property = 'FwNetworkWithCS'  THEN (CASE P.value WHEN 1 THEN 'Always in the same network as CommServe'
																	WHEN 2 THEN 'Always outside of CommServe network'
																	WHEN 3 THEN 'May travel outside of CommServe network'
																	ELSE 'No' END)
			WHEN P.Property = 'FwNetworkWithMA'  THEN (CASE P.value WHEN 1 THEN 'Always in the same network as MediaAgent'
																	WHEN 2 THEN 'Always outside of MediaAgent network'
																	WHEN 3 THEN 'May travel outside of MediaAgent network'
																	ELSE 'No' END)
			WHEN P.Property = 'FwConnectionWithCS' THEN (CASE P.value WHEN 1 THEN 'Open tunnel directly to CommServe'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN P.Property = 'FwConnectionWithMA' THEN (CASE P.value WHEN 1 THEN 'Open tunnel directly to MediaAgent'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN P.Property = 'FwDefOutgoingProtocol' THEN (CASE P.Value WHEN 0 THEN 'HTTP' WHEN 1 THEN 'HTTPS' ELSE 'HTTP Auth Only' END)
			WHEN P.Value = -1 THEN 'Infinite' ELSE CAST (P.Value AS VARCHAR(32))
		END,
		CASE WHEN S.Property IN ('MAEnabled', 'NwErrorRetryEnabled', 'AccessPathEnabled', 'UseNetworkShare', 'IntermediateIndexCache',
								'IdxCacheServerEnabled', 'IdxPoolIsShared', 'FwConnectionWithCS', 'FwConnectionWithMA',
								'FwForeceSSL', 'FwLockDown', 'FwBindOpenPortsOnly', 'FwIsDMZ', 'FwIsRoamingClient',
								'NwThrottlingEnabled', 'NwShareBandwidth', 'NwIsAbsolute', 'NwSendEnabled', 'NwRecvEnabled')
				THEN (CASE S.Value WHEN 0 THEN 'No' ELSE 'Yes' END)
			WHEN S.Property IN ('NwStartTime', 'NwEndTime') THEN RIGHT(CONVERT(VARCHAR, DATEADD(s, S.value, 0), 100), 7)
			WHEN S.Property = 'FirewallSettings' THEN (CASE S.value WHEN 1 THEN 'Basic' WHEN 2 THEN 'Advanced' ELSE 'No' END)
			WHEN S.Property = 'FwNetworkWithCS'  THEN (CASE S.value WHEN 1 THEN 'Always in the same network as CommServe'
																	WHEN 2 THEN 'Always outside of CommServe network'
																	WHEN 3 THEN 'May travel outside of CommServe network'
																	ELSE 'No' END)
			WHEN S.Property = 'FwNetworkWithMA'  THEN (CASE S.value WHEN 1 THEN 'Always in the same network as MediaAgent'
																	WHEN 2 THEN 'Always outside of MediaAgent network'
																	WHEN 3 THEN 'May travel outside of MediaAgent network'
																	ELSE 'No' END)
			WHEN S.Property = 'FwConnectionWithCS' THEN (CASE S.value WHEN 1 THEN 'Open tunnel directly to CommServe'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN S.Property = 'FwConnectionWithMA' THEN (CASE S.value WHEN 1 THEN 'Open tunnel directly to MediaAgent'
																	WHEN 2 THEN 'Use remote proxy'
																	ELSE 'No' END)
			WHEN S.Property = 'FwDefOutgoingProtocol' THEN (CASE S.Value WHEN 0 THEN 'HTTP' WHEN 1 THEN 'HTTPS' ELSE 'HTTP Auth Only' END)
			WHEN S.Value = -1 THEN 'Infinite' ELSE CAST (S.Value AS VARCHAR(32))
		END
FROM	MediaAgentProperty P
		INNER JOIN
		(
			SELECT	Property, Value
			FROM	MediaAgentProperty
			WHERE	CommServId = @i_stdCommServUniqueID AND MAClientId = @i_stdMAClientID
		) S
		ON P.Property = S.Property AND P.Value <> S.Value
IF	@i_PropertyGroupId IN (0, 1)
BEGIN
	INSERT	INTO #MediaAgentProperty
	SELECT	CommServId, MAClientId, 1, 'MediaAgent Version', MAReleaseVersion, @stdMAReleaseVersion
	FROM	#MediaAgentProp
	WHERE	MAReleaseVersion <> @stdMAReleaseVersion
	INSERT	INTO #MediaAgentProperty
	SELECT	P.CommServId, P.MAClientId, 1, F.name,
			CASE WHEN (P.MAAttribute & F.flag) = 0 THEN 'No' ELSE 'Yes' END,
			CASE WHEN (@stdMAAttribute & F.flag) = 0 THEN 'No' ELSE 'Yes' END
	FROM	(SELECT CommServId, MAClientId, MAAttribute FROM #MediaAgentProp WHERE MAAttribute <> @stdMAAttribute) P
			CROSS JOIN @TblMediaAgentFlags F
	WHERE	(P.MAAttribute & F.flag) <> (@stdMAAttribute & F.flag)
END
IF	@i_PropertyGroupId IN (0, 4)
BEGIN
	INSERT	INTO #MediaAgentProperty
	SELECT	CommServId, MAClientId, 4, 'Throttling Rule: Weekdays', NwDaysOfWeek, @stdNwDaysOfWeek
	FROM	#MediaAgentProp
	WHERE	NwDaysOfWeek <> @stdNwDaysOfWeek
END
IF @bAggregate = 1
BEGIN
	DECLARE	@TblSummary TABLE (CommServId INT, MACount INT, AllProp INT, Basic INT, IndexCache INT, Firewall INT, Throttle INT)
	INSERT	INTO @TblSummary
	SELECT	P.CommServId, 0, 0, ISNULL([1], 0), ISNULL([2], 0), ISNULL([3], 0), ISNULL([4], 0)
	FROM	(SELECT	CommServId, PropertyGroup, COUNT(DISTINCT MAClientId) AS Counts
			FROM	#MediaAgentProperty
			GROUP BY CommServId, PropertyGroup) AS S
			PIVOT (MAX(Counts) FOR S.PropertyGroup IN ([1], [2], [3], [4])) AS P
	UPDATE	@TblSummary
	SET		MACount = C.Count
	FROM	@TblSummary T
			INNER JOIN @TblMACount C ON T.CommServId = C.CommServId
	UPDATE	@TblSummary
	SET		AllProp = S.Counts
	FROM	@TblSummary T
			INNER JOIN
			(SELECT	CommServId, COUNT(DISTINCT MAClientId) AS Counts
			FROM	#MediaAgentProperty
			GROUP BY CommServId) AS S
			ON T.CommServId = S.CommServId
	IF	NOT EXISTS (SELECT * FROM @TblSummary)
	INSERT	INTO @TblSummary
	SELECT	CommServId, Count, 0, 0, 0, 0, 0
	FROM	@TblMACount
	SELECT	'All CommCells' AS 'CommCell',
			'' AS 'CommServ UniqueId',
			'' AS 'CommCell ID',
			D.MACount		AS 'All MediaAgents',
			(SELECT COUNT(*) FROM @TblPassedMA)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			D.IndexCache	AS 'Index Cache',
			D.Firewall		AS 'Firewall',
			D.Throttle		AS 'Network Throttle',
			D.AllProp		AS 'Any',
			'' AS 'Collection Time (Time Zone)',
			-1				AS 'FirstOrder<DONOTSHOW>'
	FROM	(SELECT SUM(MACount) AS MACount, SUM(AllProp) AS AllProp, SUM(Basic) AS Basic,
					SUM(IndexCache) AS IndexCache, SUM(Firewall) AS Firewall, SUM(Throttle) AS Throttle
			FROM	@TblSummary) D
	UNION ALL
	SELECT	CASE
				WHEN @isPrivate = 1 THEN CS.CommServName
				ELSE CS.CustomerName + ' - ' + CS.CommServName
			END AS 'CommCell',
			CS.ID			AS 'CommServ UniqueId',
			CS.CommCellID	AS 'CommCell ID',
			D.MACount		AS 'All Policies',
			(SELECT COUNT(*) FROM @TblPassedMA WHERE CommServId = D.CommServId)	AS 'Passed Audit',
			D.Basic			AS 'Basic',
			D.IndexCache	AS 'Index Cache',
			D.Firewall		AS 'Firewall',
			D.Throttle		AS 'Network Throttle',
			D.AllProp		AS 'Any',
			CONVERT(VARCHAR(20), LR.LogDate, 100) + ' (' + CS.CommServTZ + ')' AS 'Collection Time (Time Zone)',
			0				AS 'FirstOrder<DONOTSHOW>'
	FROM	@TblSummary D
			INNER JOIN cf_CommcellIdNameMap CS ON D.CommServId = CS.ID
			INNER JOIN #LatestResult LR ON D.CommServId = LR.CommServId
	ORDER BY 'FirstOrder<DONOTSHOW>', 'CommCell'
END
ELSE
BEGIN
	IF	@i_PropertyGroupId <> 0
		DELETE #MediaAgentProperty WHERE PropertyGroup <> @i_PropertyGroupId
	IF @i_CommServUniqueID = 0
		SELECT	CASE
					WHEN @isPrivate = 1 THEN CS.CommServName
					ELSE CS.CustomerName + ' - ' + CS.CommServName
				END AS 'CommCell',
				ISNULL(CL.clientDisplayName, S.MediaAgentName) AS 'MediaAgent',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#MediaAgentProperty P
				INNER JOIN #MediaAgentProp S ON P.CommServId = S.CommServId AND P.MAClientId = S.MAClientId
				INNER JOIN cf_CommcellIdNameMap CS ON P.CommServId = CS.ID
				LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = S.CommServId AND CL.ClientId = S.MAClientId
				ORDER BY CS.CommServName, ISNULL(CL.clientDisplayName, S.MediaAgentName), P.PropertyGroup, P.Property
	ELSE
		SELECT	ISNULL(CL.clientDisplayName, S.MediaAgentName) AS 'MediaAgent',
				P.Property		AS 'Property',
				P.Value			AS 'Value',
				P.stdValue		AS 'Template Value'
		FROM	#MediaAgentProperty P
				INNER JOIN #MediaAgentProp S ON P.CommServId = S.CommServId AND P.MAClientId = S.MAClientId
				LEFT  JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = S.CommServId AND CL.ClientId = S.MAClientId
		ORDER BY ISNULL(CL.clientDisplayName, S.MediaAgentName), P.PropertyGroup, P.Property
END
DROP TABLE #LatestResult
DROP TABLE #MediaAgentProp
DROP TABLE #MediaAgentProperty
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @i_stdCommServUniqueID INT		= 11065
  DECLARE @i_stdMAClientID INT			= 0
  DECLARE @i_CommServUniqueID INT		= 0
  DECLARE @i_PropertyGroup VARCHAR(32)	= 'Basic'	--''(0), 'Passed Audit'(-1), 'Basic'(1), 'Index Cache(2)', 'Firewall'(3), 'Network Throttle'(4)
exec RptMediaAgentAudit @i_UserId, @i_GroupId, @blaggregate, @i_stdCommServUniqueID, @i_stdMAClientID, @i_CommServUniqueID, @i_PropertyGroup
SET @i_stdCommServUniqueID = 0
exec RptMediaAgentAudit @i_UserId, @i_GroupId, @blaggregate, @i_stdCommServUniqueID, @i_stdMAClientID, @i_CommServUniqueID, @i_PropertyGroup
*/

IF EXISTS (select * from GxQscripts where name = 'RptMediaAgentAudit')
	delete from GxQscripts where name = 'RptMediaAgentAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptMediaAgentAudit')
	delete from GXDBVersions where aliasname = 'RptMediaAgentAudit'
GO

insert into GXDBVersions values(2, 'RptMediaAgentAudit',  '00010007000200060000', 'RptMediaAgentAudit', '00010007000200060000')
GO

