

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLicGetLicenseDetailsV2.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLicGetLicenseDetailsV2.sp,v $ $Id: RptLicGetLicenseDetailsV2.sp,v 1.1.2.4 2018/08/30 22:23:54 lgeorge Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLicGetLicenseDetailsV2 <<<'

IF EXISTS (select * from sysobjects where name='RptLicGetLicenseDetailsV2')
	drop procedure RptLicGetLicenseDetailsV2
IF EXISTS (select * from GxQscripts where name='RptLicGetLicenseDetailsV2')
	delete from GxQscripts where name = 'RptLicGetLicenseDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLicGetLicenseDetailsV2')
	delete from GXDBVersions where aliasname = 'RptLicGetLicenseDetailsV2'
GO
print '... Creating Procedure: RptLicGetLicenseDetailsV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLicGetLicenseDetailsV2
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueId INT = 0, 
  @i_Option INT = 0,
  @i_TimeZone VARCHAR(25) = '-04:00',
  @i_NoOfMonths INT = 12,
  @i_MonthString VARCHAR(20) = ''
AS
SET NOCOUNT ON
DECLARE @i_QueryId_CurrSummary INT = 227 --Current summary
DECLARE @i_QueryId_PeakSummary INT = 228 --Peak CCL summary
DECLARE @i_QueryId_CurrDetails INT = 229 --Current details
DECLARE @i_QueryId_PeakDetails INT = 230 --Peak CCL details
DECLARE @i_QueryId_SCLPeakDetails INT = 231 --Peak SCL details
--@i_Option=0 - current usage summary for the landing page of the report with dials
--@i_Option=1 - backup dial summary
--@i_Option=2 - archive dial summary
--@i_Option=3 - snap dial summary
--@i_Option=4 - replication dial summary
--@i_Option=5 - details of capacity jobs
--@i_Option=6 - list of vm sockets
--@i_Option=7 - list of protected vms
--@i_Option=8 - list of appClassVirtual VMs
--@i_Option=9 - list of archived vms
--@i_Option=10 - list of end point users
--@i_Option=11 - list of end point sharing users
--@i_Option=12 - list of end point ediscovery users
--@i_Option=13 - list of mbArchiveSolutions
--@i_Option=14 - all jobs excluded from capacity when vmSockets license is purchased
--@i_Option=15 - all jobs excluded from capacity when protected vm license is purchased
--@i_Option=16 - all jobs excluded from capacity when ACV license is purchased
--@i_Option=17 - all jobs excluded from capacity when archivedVM license is purchased
--@i_Option=18 - all DLP jobs excluded from capacity
--@i_Option=19 - all edge drive jobs excluded from capacity
--@i_Option=20 - all mSim jobs excluded from capacity
--@i_Option=21 - list of vm only
--@i_Option=22 - list of advanced vms
--@i_Option=23 - list of appServers without usages
--@i_Option=24 - list of DLOs without usages
--@i_Option=25 - list of FSOs without usages
--@i_Option=26 - list of jobs on appServers
--@i_Option=27 - list of jobs on DLO
--@i_Option=28 - list of jobs on FSO server
--@i_Option=29 - list of all other licenses and usages (rest of the licenses that are purchased but not displayed anywhere)
--@i_Option=30 - list of remaining usage based licenses
--------following options are to draw peak license graphs
--@i_Option=31 - data to draw capacity peak usage graphs for past N months
--@i_Option=32 - data to draw CAL peak usage graphs for past N months
--------following options will give CCL peak usage details
--@i_Option=33 - CCL peak capacity details for the given month
--@i_Option=34 - CCL peak vmsocket details for the given month
--@i_Option=35 - CCL peak protected vm details for the given month
--@i_Option=36 - CCL peak acv vm details for the given month
--@i_Option=37 - CCL peak archived vm details for the given month
--@i_Option=38 - CCL peak endpoint user details for the given month
--@i_Option=39 - CCL peak ep sharing user details for the given month
--@i_Option=40 - CCL peak ep ediscovery user details for the given month
--@i_Option=41 - CCL peak msim user details for the given month
--@i_Option=42 - CCL peak usages excluded from capacity when vm sockets license is purchased
--@i_Option=43 - CCL peak usages excluded from capacity when protected vm license is purchased
--@i_Option=44 - CCL peak usages excluded from capacity when ACV license is purchased
--@i_Option=45 - CCL peak usages excluded from capacity when archived vm license is purchased
--@i_Option=46 - CCL peak DLP jobs excluded from capacity
--@i_Option=47 - CCL peak edge drive jobs excluded from capacity
--@i_Option=48 - CCL peak mSim jobs excluded from capacity
--@i_Option=49 - CCL peak VM only details for the given month
--@i_Option=50 - CCL peak advanced vms details for the given month
--@i_Option=51 - CCL peak appServers without usages
--@i_Option=52 - CCL peak DLOs without usages
--@i_Option=53 - CCL peak FSOs without usages
--@i_Option=54 - CCL peak appServer jobs for the given month
--@i_Option=55 - CCL peak DLO jobs for the given month
--@i_Option=56 - CCL peak FSO jobs for the given month
--------get misc details
--@i_Option=57 - get list of CommCells
--@i_Option=58 - get details of selected CommCell
--@i_Option=59 - get list of past N months for peak usages
--------following options are to draw SCL peak license graphs
--@i_Option=60 - data to draw SCL capacity peak usage graphs for past N months
--@i_Option=61 - data to draw SCL CAL peak usage graphs for past N months
--------following options will give SCL peak usage details
--@i_Option=62 - SCL peak capacity details for the given month
--@i_Option=63 - SCL peak vmsocket details for the given month
--@i_Option=64 - SCL peak protected vm details for the given month
--@i_Option=65 - SCL peak acv vm details for the given month
--@i_Option=66 - SCL peak archived vm details for the given month
--@i_Option=67 - SCL peak endpoint user details for the given month
--@i_Option=68 - SCL peak ep sharing user details for the given month
--@i_Option=69 - SCL peak ep ediscovery user details for the given month
--@i_Option=70 - SCL peak msim user details for the given month
--@i_Option=71 - SCL peak usages excluded from capacity when vm sockets license is purchased
--@i_Option=72 - SCL peak usages excluded from capacity when protected vm license is purchased
--@i_Option=73 - SCL peak usages excluded from capacity when ACV license is purchased
--@i_Option=74 - SCL peak usages excluded from capacity when archived vm license is purchased
--@i_Option=75 - SCL peak DLP jobs excluded from capacity
--@i_Option=76 - SCL peak edge drive jobs excluded from capacity
--@i_Option=77 - SCL peak mSim jobs excluded from capacity
--@i_Option=78 - SCL peak VM only details for the given month
--@i_Option=79 - SCL peak advanced vms details for the given month
--@i_Option=80 - SCL peak appServers without usages
--@i_Option=81 - SCL peak DLOs without usages
--@i_Option=82 - SCL peak FSOs without usages
--@i_Option=83 - SCL peak appServer jobs for the given month
--@i_Option=84 - SCL peak DLO jobs for the given month
--@i_Option=85 - SCL peak FSO jobs for the given month
--------royalty report details
--@i_Option=86 - Generate Royalty Report details from SCL peak usage
DECLARE @month DATETIME = NULL
SET @month=CONVERT(DATE,@i_MonthString)
IF @month=NULL OR @month > GETDATE()
BEGIN
    SET @month=DATEADD(DAY,-DAY(GETDATE())+1, CAST(GETDATE() AS DATE))
END
DECLARE @isActivityEnabled INT = 0
SELECT @isActivityEnabled=CASE WHEN (CommCellSurveyServices & 4)=4 THEN 1 ELSE 0 END
FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE ID=@i_CommServUniqueId
IF @i_Option=0 OR @i_Option=30
BEGIN
	DECLARE @dials TABLE(dialName VARCHAR(20),licType INT, purchased INT, permTotal INT, evalTotal INT, termEndDate VARCHAR(128), usage FLOAT)
	INSERT @dials VALUES('backup',100002,0,0,0,'N/A',0)
    INSERT @dials VALUES('archive',100004,0,0,0,'N/A',0)
    INSERT @dials VALUES('snapshot',100005,0,0,0,'N/A',0)
    INSERT @dials VALUES('replication',100006,0,0,0,'N/A',0)
    INSERT @dials VALUES('vmSockets',100018,0,0,0,'N/A',0)
    INSERT @dials VALUES('protectedVMs',100019,0,0,0,'N/A',0)
    INSERT @dials VALUES('appClassVirtual',100027,0,0,0,'N/A',0)
    INSERT @dials VALUES('archivedVMs',100021,0,0,0,'N/A',0)
    INSERT @dials VALUES('epUser',100024,0,0,0,'N/A',0)
    INSERT @dials VALUES('epSharingUser',100025,0,0,0,'N/A',0)
    INSERT @dials VALUES('epEDiscoveryUser',100026,0,0,0,'N/A',0)
    INSERT @dials VALUES('mbArchivedSolution',100028,0,0,0,'N/A',0)
    INSERT @dials VALUES('FSO',100029,0,0,0,'N/A',0)
    INSERT @dials VALUES('DLO',200002,0,0,0,'N/A',0)
    INSERT @dials VALUES('appServer',100030,0,0,0,'N/A',0)
    INSERT @dials VALUES('vmOnly',200001,0,0,0,'N/A',0)
    INSERT @dials VALUES('advancedVM',200003,0,0,0,'N/A',0)
	INSERT @dials VALUES('diskLibrary',100015,0,0,0,'N/A',0)
	INSERT @dials VALUES('dedupStore',100016,0,0,0,'N/A',0)
	INSERT @dials VALUES('applicanceStore',100031,0,0,0,'N/A',0)
	--get capacity license quantities purchased
    UPDATE D SET
        D.permTotal=CASE WHEN ISNULL(PermanentTotal,0)=-2 THEN 0 ELSE ISNULL(PermanentTotal,0)/1024 END,
        D.evalTotal=CASE WHEN ISNULL(EvaluationTotal,0)=-2 THEN 0 ELSE ISNULL(EvaluationTotal,0)/1024 END,
        D.purchased=CASE WHEN (ISNULL(PermanentTotal,0)>=0 AND ISNULL(EvaluationTotal,0)>=0) THEN (ISNULL(PermanentTotal,0)/1024+ISNULL(EvaluationTotal,0)/1024)
                         ELSE CASE WHEN (ISNULL(PermanentTotal,0)=-1 OR ISNULL(EvaluationTotal,0)=-1) THEN -1
                                   ELSE 0
                              END
                    END,
		D.usage=ISNULL(PermanentUsed,0),
        D.termEndDate=CASE WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN L.TermEndDate
                           ELSE 'N/A'
                      END
    FROM @dials D
	INNER JOIN cf_SurveyLicCurrentLicenseInfo L WITH(NOLOCK) ON L.LicType=D.licType
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON L.CommServUniqueId=SR.CommServUniqueId
    WHERE D.licType IN (100002,100004,100005,100006,100015,100016,100031)
	--get usage based license quantities purchased
    UPDATE D SET
        D.permTotal=CASE WHEN ISNULL(PermanentTotal,0)=-2 THEN 0 ELSE ISNULL(PermanentTotal,0) END,
        D.evalTotal=CASE WHEN ISNULL(EvaluationTotal,0)=-2 THEN 0 ELSE ISNULL(EvaluationTotal,0) END,
        D.purchased=CASE WHEN (ISNULL(PermanentTotal,0)>0 OR ISNULL(PermanentTotal,0)=-1) THEN ISNULL(PermanentTotal,0)
                         WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN ISNULL(EvaluationTotal,0)
                         ELSE 0
                    END,
		D.usage=ISNULL(PermanentUsed,0),
        D.termEndDate=CASE WHEN (ISNULL(EvaluationTotal,0)>0 OR ISNULL(EvaluationTotal,0)=-1) THEN L.TermEndDate
                           ELSE 'N/A'
                      END
    FROM @dials D
	INNER JOIN cf_SurveyLicCurrentLicenseInfo L WITH(NOLOCK) ON L.LicType=D.licType
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON L.CommServUniqueId=SR.CommServUniqueId
    WHERE D.LicType IN (100018,100019,100021,100024,100025,100026,100027,100028,100029,100030,200001,200002,200003)
	IF @i_Option=0--dial licenses
	BEGIN
		SELECT dialName AS 'Dial', licType AS 'License ID', purchased AS 'Purchased', permTotal AS 'Permanent Total', evalTotal AS 'evaluationTotal',
		usage AS 'Used', termEndDate AS 'Term End Date' FROM @dials
		WHERE licType NOT IN (100015,100016,100031)
	END
	ELSE IF @i_Option=30--list of remaining usage based licenses
	BEGIN
		SELECT licType AS 'License ID', L.name AS 'License', purchased AS 'Purchased',
		usage AS 'Used', termEndDate AS 'Term End Date' FROM @dials D
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=D.licType
		WHERE D.licType IN (100015,100016,100031)
	END
END
ELSE IF @i_Option BETWEEN 1 AND 4--summary of capacity jobs
BEGIN
	DECLARE @jobType INT = 1
	IF @i_Option=1 SET @jobType=0--backup
	ELSE IF @i_Option=2 SET @jobType=1--archive
	ELSE IF @i_Option=3 SET @jobType=2--snap
	ELSE IF @i_Option=4 SET @jobType=3--replicate
	SELECT
    LicType AS 'License ID',ISNULL(L.name,'') AS 'License',AppTypeId AS 'Agent ID',A.name AS 'Agent',
    CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
    AppSizeMB AS 'Usage'
    FROM cf_SurveyLicCurrentUsageSummary C WITH (NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
	LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
	LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
    WHERE njobtype=@jobType AND CapacityFlag=0
END
ELSE IF @i_Option=5--details of capacity jobs
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=0
	END
END
ELSE IF @i_Option=6--list of vm sockets
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'Hypervisor Host', ISNULL(AppSizeMB,0) AS 'Sockets', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=19 ORDER BY ObjectName
	END
END
ELSE IF @i_Option=7--list of protected vms
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20
		UNION
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 AND JobId>0
	END
END
ELSE IF @i_Option=8--list of appClassVirtual VMs
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @vms TABLE(vmId INT, vmName NVARCHAR(1024),isProtected VARCHAR(5), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @vms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), CASE WHEN JobId>0 THEN 'Yes' ELSE 'No' END, A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @vms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		isProtected AS 'Is VM Protected', jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @vms V
		GROUP BY vmId,vmName,isProtected,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option=9--list of archived vms
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Archived Job', ISNULL(AppSizeMB,0) AS 'Archived VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=21 ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
	END
END
ELSE IF @i_Option=10--list of end point users
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=22 ORDER BY ObjectName
	END
END
ELSE IF @i_Option=11--list of end point sharing users
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=23 ORDER BY ObjectName
	END
END
ELSE IF @i_Option=12--list of end point ediscovery users
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=24 ORDER BY ObjectName
	END
END
ELSE IF @i_Option=13--list of mbArchiveSolutions
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'SMTP', A.name AS 'Name', C.ClientId AS 'Client ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', C.AppId AS 'Subclient ID', SCL.SubclientName AS 'Subclient', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=17 ORDER BY ObjectName
	END
END
ELSE IF @i_Option BETWEEN 14 AND 20--all jobs exclusions
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @capacityFlag INT = -1
		IF @i_Option=14 OR @i_Option=15 SET @capacityFlag=1--all jobs excluded from capacity when vmSockets/protectedVM license is purchased
		ELSE IF @i_Option=16 SET @capacityFlag=4--all jobs excluded from capacity when ACV license is purchased
		ELSE IF @i_Option=17 SET @capacityFlag=32--all jobs excluded from capacity when archivedVM license is purchased
		ELSE IF @i_Option=18 SET @capacityFlag=16--all DLP jobs excluded from capacity
		ELSE IF @i_Option=19 SET @capacityFlag=8--all edge drive jobs excluded from capacity
		ELSE IF @i_Option=20 SET @capacityFlag=2--all mSim jobs excluded from capacity
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=@capacityFlag
	END
END
ELSE IF @i_Option=21--list of vm only
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20
	END
END
ELSE IF @i_Option=22--list of advanced vms
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @advVms TABLE(vmId INT, vmName NVARCHAR(1024), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @advVms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=26 ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @advVms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @advVms V
		GROUP BY vmId,vmName,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option BETWEEN 23 AND 25--list of appServers, DLOs & FSOs without usages
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objType INT = -1
		IF @i_Option=23 SET @objType=1--list of appServers without usages
		ELSE IF @i_Option=24 SET @objType=2--list of DLOs without usages
		ELSE IF @i_Option=25 SET @objType=3--list of FSOs without usages
		SELECT DISTINCT C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=@objType
		AND C.ClientId NOT IN (SELECT DISTINCT ClientId FROM cf_SurveyLicCurrentUsageDetails WITH (NOLOCK))
		ORDER BY [Client]
	END
END
ELSE IF @i_Option BETWEEN 26 AND 28--list of jobs on appServers, DLOs & FSOs
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objectType INT = -1
		IF @i_Option=26 SET @objectType=1--list of appServers without usages
		ELSE IF @i_Option=27 SET @objectType=2--list of DLOs without usages
		ELSE IF @i_Option=28 SET @objectType=3--list of FSOs without usages
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicCurrentUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE C.ClientId IN (SELECT DISTINCT ClientId FROM cf_SurveyLicCurrentCALDetails WITH (NOLOCK) WHERE ObjectType=@objectType)
	END
END
ELSE IF @i_Option=29--list of all other licenses and usages (rest of the licenses that are purchased but not displayed anywhere)
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT LicType AS 'License ID', L.name AS 'License', PermanentTotal AS 'Permanent Total', PermanentUsed AS 'Permanent Used',
		EvaluationTotal AS 'Evaluation Total', EvaluationUsed AS 'Evaluation Used', TermEndDate AS 'Term End Date',
		C.ClientId AS 'Client ID', CASE WHEN C.ClientId<=0 THEN 'N/A' ELSE ISNULL(CL.ClientDisplayName, CL.ClientName) END AS 'Used By', C.AppTypeId AS 'Agent ID',
		CASE WHEN C.AppTypeId<=0 THEN 'N/A' ELSE A.name END AS 'Agent', C.InstallDate AS 'Install Date', ExpirationDate AS 'Expiration Date'
		FROM cf_SurveyLicCurrentLicenseInfo C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE LicType < 1000
		AND L.name IS NOT NULL--few licenses like LicType=122 are not in cf_SurveyLicType table. Hence not displaying this. Will show it in future if requried
		ORDER BY L.name, ISNULL(CL.ClientDisplayName, CL.ClientName), A.name
	END
	ELSE
	BEGIN
		SELECT DISTINCT LicType AS 'License ID', L.name AS 'License', PermanentTotal AS 'Permanent Total', PermanentUsed AS 'Permanent Used',
		EvaluationTotal AS 'Evaluation Total', EvaluationUsed AS 'Evaluation Used', TermEndDate AS 'Term End Date',
		0 AS 'Client ID', 'N/A' AS 'Used By', 0 AS 'Agent ID','N/A' AS 'Agent', 'N/A' AS 'Install Date', ExpirationDate AS 'Expiration Date'
		FROM cf_SurveyLicCurrentLicenseInfo C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_CurrDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		WHERE LicType < 1000
		AND L.name IS NOT NULL--few licenses like LicType=122 are not in cf_SurveyLicType table. Hence not displaying this. Will show it in future if requried
		ORDER BY L.name
	END
END
ELSE IF @i_Option=31--data to draw capacity peak usage graphs for past N months
BEGIN
	DECLARE @monthStart DATETIME = GETDATE()
	DECLARE @monthTable TABLE (MonthStart DATETIME)
    DECLARE @cnt INT = @i_NoOfMonths
    WHILE @cnt > 0
    BEGIN
        INSERT @monthTable
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStart), 0)
        SET @monthStart=DATEADD(month, -1, @monthStart)
        SET @cnt=@cnt-1
    END
    SELECT MonthStart AS Month, ISNULL(CCLBackup,0.000) AS 'CCLBackup', ISNULL(CCLArchive,0.000) AS 'CCLArchive', ISNULL(CCLSnapshot,0.000) AS 'CCLSnapshot', ISNULL(CCLReplication,0.000) AS 'CCLReplication'
	FROM @monthTable M
	LEFT JOIN
	(
		SELECT TOP (@i_NoOfMonths) Month AS 'Month',
		CAST(MAX(BackupSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'CCLBackup', CAST(MAX(ArchiveSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'CCLArchive',
		CAST(MAX(SnapSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'CCLSnapshot',CAST(MAX(ReplicationSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'CCLReplication' FROM
		(
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(CCLPeakEnterpriseBackupSize,0)) AS 'BackupSize' ,
			MAX(ISNULL(CCLPeakEnterpriseArchiveSize,0)) AS 'ArchiveSize',MAX(ISNULL(CCLPeakSnapSize,0)) AS 'SnapSize',MAX(ISNULL(CCLPeakReplicationSize,0)) AS 'ReplicationSize'
			FROM cf_SurveyLicPeakUsageHistory C WITH (NOLOCK)
			INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
			GROUP BY date
		)[CCLCapacityUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @i_Option=32--data to draw CAL peak usage graphs for past N months
BEGIN
	DECLARE @monthStartCAL DATETIME = GETDATE()
	DECLARE @monthTableCAL TABLE (MonthStart DATETIME)
    DECLARE @cntCAL INT = @i_NoOfMonths
    WHILE @cntCAL > 0
    BEGIN
        INSERT @monthTableCAL
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStartCAL), 0)
        SET @monthStartCAL=DATEADD(month, -1, @monthStartCAL)
        SET @cntCAL=@cntCAL-1
    END
    SELECT MonthStart AS Month, ISNULL(VMSockets,0) AS 'VMSockets', ISNULL(ProtectedVMs,0) AS 'ProtectedVMs', ISNULL(AcvVMs,0) AS 'AcvVMs', ISNULL(ArchivedVMs,0) AS 'ArchivedVMs',
	ISNULL(MSimUsers,0) AS 'MSimUsers',	ISNULL(EpUsers,0) AS 'EpUsers', ISNULL(EpSharingUsers,0) AS 'EpSharingUsers', ISNULL(EpEdiscoveryUsers,0) AS 'EpEdiscoveryUsers',
	ISNULL(FSOnlyServer,0) AS 'FSOnlyServer', ISNULL(DLO,0) AS 'DLO', ISNULL(AppServer,0) AS 'AppServer', ISNULL(VMOnly,0) AS 'VMOnly', ISNULL(AdvancedVM,0) AS 'AdvancedVM'
	FROM @monthTableCAL M
	LEFT JOIN
	(
		SELECT TOP (@i_NoOfMonths) Month AS 'Month', MAX(VMSockets) AS 'VMSockets', (MAX(VMOnly)+MAX(AdvancedVM)) AS 'ProtectedVMs', MAX(AcvVMs) AS 'AcvVMs', MAX(ArchivedVMs) AS 'ArchivedVMs',
		MAX(MSimUsers) AS 'MSimUsers', MAX(EpUsers) AS 'EpUsers', MAX(EpSharingUsers) AS 'EpSharingUsers', MAX(EpEdiscoveryUsers) AS 'EpEdiscoveryUsers', MAX(FSOnlyServer) AS 'FSOnlyServer',
		MAX(DLO) AS 'DLO', MAX(AppServer) AS 'AppServer', MAX(VMOnly) AS 'VMOnly', MAX(AdvancedVM) AS 'AdvancedVM'
		FROM (
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(CCLVMSocket,0)) AS 'VMSockets', MAX(ISNULL(CCLVMOnly,0)) AS 'ProtectedVMs', MAX(ISNULL(CCLACV,0)) AS 'AcvVMs', MAX(ISNULL(CCLArchivedVM,0)) AS 'ArchivedVMs',
			MAX(ISNULL(CCLMSimUsers,0)) AS 'MSimUsers', MAX(ISNULL(CCLEpUsers,0)) AS 'EpUsers', MAX(ISNULL(CCLEpSharingUsers,0)) AS 'EpSharingUsers', MAX(ISNULL(CCLEpEdiscoveryUsers,0)) AS 'EpEdiscoveryUsers',
			MAX(ISNULL(CCLFSOnlyServer,0)) AS 'FSOnlyServer',MAX(ISNULL(CCLDLO,0)) AS 'DLO',MAX(ISNULL(CCLApplicationServer,0)) AS 'AppServer',MAX(ISNULL(CCLVMOnly,0)) AS 'VMOnly',MAX(ISNULL(CCLVMWithApp,0)) AS 'AdvancedVM'
			FROM cf_SurveyLicPeakCALClientCountHistory C WITH (NOLOCK)
			INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
			GROUP BY date
		)[CCLCALUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @i_Option=33--CCL peak capacity details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=0 AND MonthStart=@month
	END
END
ELSE IF @i_Option=34--CCL peak vmsocket details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'Hypervisor Host', ISNULL(AppSizeMB,0) AS 'Sockets', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=19 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=35--CCL peak protected vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20 AND MonthStart=@month
		UNION
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 AND JobId>0 AND MonthStart=@month
	END
END
ELSE IF @i_Option=36--CCL peak acv vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @cclvms TABLE(vmId INT, vmName NVARCHAR(1024),isProtected VARCHAR(5), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @cclvms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), CASE WHEN JobId>0 THEN 'Yes' ELSE 'No' END, A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @cclvms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		isProtected AS 'Is VM Protected', jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @cclvms V
		GROUP BY vmId,vmName,isProtected,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option=37--CCL peak archived vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Archived Job', ISNULL(AppSizeMB,0) AS 'Archived VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=21 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
	END
END
ELSE IF @i_Option=38--CCL peak endpoint user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=22 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=39--CCL peak ep sharing user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=23 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=40--CCL peak ep ediscovery user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=24 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=41--CCL peak msim user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'SMTP', A.name AS 'Name', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', SCL.SubclientName AS 'Subclient', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=17 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option BETWEEN 42 AND 48--CCL peak job exclusions
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @capacityFlg INT = -1
		IF @i_Option=42 OR @i_Option=43 SET @capacityFlg=1--CCL peak usages excluded from capacity when vmSockets/protectedVM license is purchased
		ELSE IF @i_Option=44 SET @capacityFlg=4--CCL peak usages excluded from capacity when ACV license is purchased
		ELSE IF @i_Option=45 SET @capacityFlg=32--CCL peak usages excluded from capacity when archivedVM license is purchased
		ELSE IF @i_Option=46 SET @capacityFlg=16--CCL peak DLP jobs excluded from capacity
		ELSE IF @i_Option=47 SET @capacityFlg=8--CCL peak edge drive jobs excluded from capacity
		ELSE IF @i_Option=48 SET @capacityFlg=2--CCL peak mSim jobs excluded from capacity
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=@capacityFlg AND MonthStart=@month
	END
END
ELSE IF @i_Option=49--CCL peak VM only details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20 AND MonthStart=@month
	END
END
ELSE IF @i_Option=50--CCL peak advanced vms details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @cclAdvVms TABLE(vmId INT, vmName NVARCHAR(1024), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @cclAdvVms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=26 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @cclAdvVms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @cclAdvVms V
		GROUP BY vmId,vmName,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option BETWEEN 51 AND 53--CCL peak of appServers, DLOs & FSOs without usages for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objTypeCCL INT = -1
		IF @i_Option=51 SET @objTypeCCL=1--CCL peak appServers without usages
		ELSE IF @i_Option=52 SET @objTypeCCL=2--CCL peak DLOs without usages
		ELSE IF @i_Option=53 SET @objTypeCCL=3--CCL peak FSOs without usages
		SELECT DISTINCT C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=@objTypeCCL AND MonthStart=@month
		AND C.ClientId NOT IN (SELECT DISTINCT ClientId FROM cf_SurveyLicCCLPeakUsageDetails WITH (NOLOCK) WHERE MonthStart=@month)
		ORDER BY [Client]
	END
END
ELSE IF @i_Option BETWEEN 54 AND 56--CCL peak jobs on appServers, DLOs & FSOs for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objectTypeCCL INT = -1
		IF @i_Option=54 SET @objectTypeCCL=1--CCL peak jobs on appServers
		ELSE IF @i_Option=55 SET @objectTypeCCL=2--CCL peak jobs on DLOs
		ELSE IF @i_Option=56 SET @objectTypeCCL=3--CCL peak jobs on FSOs
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicCCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE MonthStart=@month
		AND C.ClientId IN (SELECT DISTINCT ClientId FROM cf_SurveyLicCCLPeakCALDetails WITH (NOLOCK) WHERE ObjectType=@objectTypeCCL AND MonthStart=@month)
	END
END
ELSE IF @i_Option=57--get list of CommCells
BEGIN
	SELECT CommServUniqueId AS 'CommServUniqueId', dbo.ConvertBigIntToHexStr(CommCellID) AS 'CommCell ID in Hex'
	FROM cf_SurveyResultFuncV1(@i_QueryId_CurrSummary, 0, 1, NULL, NULL, @i_UserId, @i_GroupId)
	UNION
	SELECT -1 AS 'CommServUniqueId', 'Select' AS 'CommCell ID in Hex'
END
ELSE IF @i_Option=58--get details of selected CommCell
BEGIN
	DECLARE @commcell TABLE (csUniqueId INT, ccId VARCHAR(32), csGuid VARCHAR(256), customerName NVARCHAR(256), csName NVARCHAR(256), csVersion VARCHAR(256), csTZ VARCHAR(256), modifiedTime DATETIME)
	INSERT @commcell
	SELECT TOP 1 ID, CommCellID, CommServGUID, CustomerName, CommServName, CommServVersion, CommServTZ, SWITCHOFFSET(CONVERT(DATETIMEOFFSET,ModifiedTime), @i_TimeZone)
	FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE ID=@i_CommServUniqueId
	SELECT csUniqueId AS 'CommServUniqueId', dbo.ConvertBigIntToHexStr(ccId) AS 'CommCell ID', ccId AS 'CommCell ID in Decimal',
	(customerName+' - '+csName) AS 'CommCell', STUFF(STUFF(RIGHT(csGuid,10),4,0,'-'),8,0,'-') AS 'Registration Code', csVersion AS 'Version',
	modifiedTime AS 'Collection Time', csTZ AS 'Time Zone', @isActivityEnabled AS 'isActivityEnabled'
	FROM @commcell
END
ELSE IF @i_Option=59--get list of past N months for peak usages
BEGIN
	DECLARE @dateTable TABLE (monthValue VARCHAR(20), monthLabel VARCHAR(20))
	DECLARE @date DATETIME = GETDATE()
    DECLARE @counter INT = @i_NoOfMonths
    --default month to be displayed in list
    INSERT INTO @dateTable VALUES('9999-01-01','Current Month')
    WHILE @counter > 0
    BEGIN
        INSERT @dateTable
        SELECT CAST(DATEADD(DAY,-DAY(@date)+1, CAST(@date AS DATE)) AS DATE), CONVERT(VARCHAR(10),DATENAME(month, @date))+', '+CONVERT(VARCHAR(4),YEAR(@date))
        SET @date=DATEADD(month, -1, @date)
        SET @counter=@counter-1
    END
    SELECT monthValue, monthLabel FROM @dateTable
END
ELSE IF @i_Option=60--data to draw SCL capacity peak usage graphs for past N months
BEGIN
	DECLARE @monthStartScl DATETIME = GETDATE()
	DECLARE @monthTableScl TABLE (MonthStart DATETIME)
    DECLARE @cntScl INT = @i_NoOfMonths
    WHILE @cntScl > 0
    BEGIN
        INSERT @monthTableScl
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStartScl), 0)
        SET @monthStartScl=DATEADD(month, -1, @monthStartScl)
        SET @cntScl=@cntScl-1
    END
    SELECT MonthStart AS Month, ISNULL(SCLBackup,0.000) AS 'SCLBackup', ISNULL(SCLArchive,0.000) AS 'SCLArchive', ISNULL(SCLSnapshot,0.000) AS 'SCLSnapshot', ISNULL(SCLReplication,0.000) AS 'SCLReplication'
	FROM @monthTableScl M
	LEFT JOIN
	(
		SELECT TOP (@i_NoOfMonths) Month AS 'Month',
		CAST(MAX(BackupSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'SCLBackup', CAST(MAX(ArchiveSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'SCLArchive',
		CAST(MAX(SnapSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'SCLSnapshot',CAST(MAX(ReplicationSize)*1.0/1024/1024 AS DECIMAL(18,3)) AS 'SCLReplication' FROM
		(
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(SCLPeakEnterpriseBackupSize,0)) AS 'BackupSize' ,
			MAX(ISNULL(SCLPeakEnterpriseArchiveSize,0)) AS 'ArchiveSize',MAX(ISNULL(SCLPeakSnapSize,0)) AS 'SnapSize',MAX(ISNULL(SCLPeakReplicationSize,0)) AS 'ReplicationSize'
			FROM cf_SurveyLicPeakUsageHistory C WITH (NOLOCK)
			INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
			GROUP BY date
		)[SCLCapacityUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @i_Option=61--data to draw SCL CAL peak usage graphs for past N months
BEGIN
	DECLARE @monthStartSclCAL DATETIME = GETDATE()
	DECLARE @monthTableSclCAL TABLE (MonthStart DATETIME)
    DECLARE @cntSclCAL INT = @i_NoOfMonths
    WHILE @cntSclCAL > 0
    BEGIN
        INSERT @monthTableSclCAL
        SELECT DATEADD(month, DATEDIFF(month, 0, @monthStartSclCAL), 0)
        SET @monthStartSclCAL=DATEADD(month, -1, @monthStartSclCAL)
        SET @cntSclCAL=@cntSclCAL-1
    END
    SELECT MonthStart AS Month, ISNULL(VMSockets,0) AS 'VMSockets', ISNULL(ProtectedVMs,0) AS 'ProtectedVMs', ISNULL(AcvVMs,0) AS 'AcvVMs', ISNULL(ArchivedVMs,0) AS 'ArchivedVMs',
	ISNULL(MSimUsers,0) AS 'MSimUsers',	ISNULL(EpUsers,0) AS 'EpUsers', ISNULL(EpSharingUsers,0) AS 'EpSharingUsers', ISNULL(EpEdiscoveryUsers,0) AS 'EpEdiscoveryUsers',
	ISNULL(FSOnlyServer,0) AS 'FSOnlyServer', ISNULL(DLO,0) AS 'DLO', ISNULL(AppServer,0) AS 'AppServer', ISNULL(VMOnly,0) AS 'VMOnly', ISNULL(AdvancedVM,0) AS 'AdvancedVM'
	FROM @monthTableSclCAL M
	LEFT JOIN
	(
		SELECT TOP (@i_NoOfMonths) Month AS 'Month', MAX(VMSockets) AS 'VMSockets', (MAX(VMOnly)+MAX(AdvancedVM)) AS 'ProtectedVMs', MAX(AcvVMs) AS 'AcvVMs', MAX(ArchivedVMs) AS 'ArchivedVMs',
		MAX(MSimUsers) AS 'MSimUsers', MAX(EpUsers) AS 'EpUsers', MAX(EpSharingUsers) AS 'EpSharingUsers', MAX(EpEdiscoveryUsers) AS 'EpEdiscoveryUsers', MAX(FSOnlyServer) AS 'FSOnlyServer',
		MAX(DLO) AS 'DLO', MAX(AppServer) AS 'AppServer', MAX(VMOnly) AS 'VMOnly', MAX(AdvancedVM) AS 'AdvancedVM'
		FROM (
			SELECT DATEADD(M, DATEDIFF(M, 0, dbo.GetDateTime(date)),0) AS 'Month', MAX(ISNULL(SCLVMSocket,0)) AS 'VMSockets', MAX(ISNULL(SCLVMOnly,0)) AS 'ProtectedVMs', MAX(ISNULL(SCLACV,0)) AS 'AcvVMs', MAX(ISNULL(SCLArchivedVM,0)) AS 'ArchivedVMs',
			MAX(ISNULL(SCLMSimUsers,0)) AS 'MSimUsers', MAX(ISNULL(SCLEpUsers,0)) AS 'EpUsers', MAX(ISNULL(SCLEpSharingUsers,0)) AS 'EpSharingUsers', MAX(ISNULL(SCLEpEdiscoveryUsers,0)) AS 'EpEdiscoveryUsers',
			MAX(ISNULL(SCLFSOnlyServer,0)) AS 'FSOnlyServer',MAX(ISNULL(SCLDLO,0)) AS 'DLO',MAX(ISNULL(SCLApplicationServer,0)) AS 'AppServer',MAX(ISNULL(SCLVMOnly,0)) AS 'VMOnly',MAX(ISNULL(SCLVMWithApp,0)) AS 'AdvancedVM'
			FROM cf_SurveyLicPeakCALClientCountHistory C WITH (NOLOCK)
			INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_PeakSummary, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
			GROUP BY date
		)[SCLCALUsage] GROUP BY [Month] ORDER BY [Month] DESC
	) U ON U.Month=M.MonthStart
END
ELSE IF @i_Option=62--SCL peak capacity details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=0 AND MonthStart=@month
	END
END
ELSE IF @i_Option=63--SCL peak vmsocket details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'Hypervisor Host', ISNULL(AppSizeMB,0) AS 'Sockets', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=19 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=64--SCL peak protected vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20 AND MonthStart=@month
		UNION
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 AND JobId>0 AND MonthStart=@month
	END
END
ELSE IF @i_Option=65--SCL peak acv vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @sclvms TABLE(vmId INT, vmName NVARCHAR(1024),isProtected VARCHAR(5), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @sclvms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), CASE WHEN JobId>0 THEN 'Yes' ELSE 'No' END, A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=18 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @sclvms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		isProtected AS 'Is VM Protected', jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @sclvms V
		GROUP BY vmId,vmName,isProtected,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option=66--SCL peak archived vm details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Archived Job', ISNULL(AppSizeMB,0) AS 'Archived VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=21 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
	END
END
ELSE IF @i_Option=67--SCL peak endpoint user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=22 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=68--SCL peak ep sharing user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=23 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=69--SCL peak ep ediscovery user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'User ID', ObjectName AS 'User Name', Associations AS 'Associations', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=24 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option=70--SCL peak msim user details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectName AS 'SMTP', A.name AS 'Name', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', SCL.SubclientName AS 'Subclient', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=17 AND MonthStart=@month ORDER BY ObjectName
	END
END
ELSE IF @i_Option BETWEEN 71 AND 77--SCL peak job exclusions
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @capacityFlgScl INT = -1
		IF @i_Option=71 OR @i_Option=72 SET @capacityFlgScl=1--SCL peak usages excluded from capacity when vmSockets/protectedVM license is purchased
		ELSE IF @i_Option=73 SET @capacityFlgScl=4--SCL peak usages excluded from capacity when ACV license is purchased
		ELSE IF @i_Option=74 SET @capacityFlgScl=32--SCL peak usages excluded from capacity when archivedVM license is purchased
		ELSE IF @i_Option=75 SET @capacityFlgScl=16--SCL peak DLP jobs excluded from capacity
		ELSE IF @i_Option=76 SET @capacityFlgScl=8--SCL peak edge drive jobs excluded from capacity
		ELSE IF @i_Option=77 SET @capacityFlgScl=2--SCL peak mSim jobs excluded from capacity
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE CapacityFlag=@capacityFlgScl AND MonthStart=@month
	END
END
ELSE IF @i_Option=78--SCL peak VM only details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		SELECT ObjectId AS 'VM ID', ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Virtual Machine', JobId AS 'VM Protection Job', ISNULL(AppSizeMB,0) AS 'Protected VM Size', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=20 AND MonthStart=@month
	END
END
ELSE IF @i_Option=79--SCL peak advanced vms details for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @sclAdvVms TABLE(vmId INT, vmName NVARCHAR(1024), package NVARCHAR(1024), jobId INT, size BIGINT, orgId VARCHAR(40), org NVARCHAR(1024), planName NVARCHAR(1024))
		INSERT @sclAdvVms
		SELECT ObjectId, ISNULL(CL.ClientDisplayName, CL.ClientName), A.name AS AppTypeName, JobId, ISNULL(AppSizeMB,0), OrgGUID, Organization, PlanName
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ObjectId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=26 AND MonthStart=@month ORDER BY ISNULL(CL.ClientDisplayName, CL.ClientName)
		SELECT vmId AS 'VM ID', vmName AS 'Virtual Machine',
		STUFF(
			(SELECT ', ' + CONVERT(VARCHAR(1024),package)
			FROM @sclAdvVms
			WHERE vmId=V.vmId-- AND vmName=V.vmName
			FOR XML PATH (''))
			, 1, 1, '')  AS 'Package',
		jobId AS 'VM Protection Job', MAX(size) AS 'Protected VM Size', orgId AS 'Organization ID', org AS 'Organization', planName AS 'Plan'
		FROM @sclAdvVms V
		GROUP BY vmId,vmName,jobId,orgId,org,planName
		ORDER BY vmName
	END
END
ELSE IF @i_Option BETWEEN 80 AND 82--SCL peak of appServers, DLOs & FSOs without usages for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objTypeSCL INT = -1
		IF @i_Option=80 SET @objTypeSCL=1--SCL peak appServers without usages
		ELSE IF @i_Option=81 SET @objTypeSCL=2--SCL peak DLOs without usages
		ELSE IF @i_Option=82 SET @objTypeSCL=3--SCL peak FSOs without usages
		SELECT DISTINCT C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client', OrgGUID AS 'Organization ID', Organization AS 'Organization', PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakCALDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		WHERE ObjectType=@objTypeSCL AND MonthStart=@month
		AND C.ClientId NOT IN (SELECT DISTINCT ClientId FROM cf_SurveyLicSCLPeakUsageDetails WITH (NOLOCK) WHERE MonthStart=@month)
		ORDER BY [Client]
	END
END
ELSE IF @i_Option BETWEEN 83 AND 85--SCL peak jobs on appServers, DLOs & FSOs for the given month
BEGIN
	IF @isActivityEnabled=1
	BEGIN
		DECLARE @objectTypeSCL INT = -1
		IF @i_Option=83 SET @objectTypeSCL=1--SCL peak jobs on appServers
		ELSE IF @i_Option=84 SET @objectTypeSCL=2--SCL peak jobs on DLOs
		ELSE IF @i_Option=85 SET @objectTypeSCL=3--SCL peak jobs on FSOs
		SELECT
		LicType AS 'License ID',ISNULL(L.name,'') AS 'License',C.ClientId AS 'Client ID',ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',C.AppTypeId AS 'Agent ID',A.name AS 'Agent',C.AppId AS 'Subclient ID',
		SCL.SubclientName AS 'Subclient',C.SPId AS 'Storage Policy ID',SP.PolicyName AS 'Storage Policy',
		CASE WHEN nJobType=0 THEN 'Backup' WHEN nJobType=1 THEN 'Archive' WHEN nJobType=2 THEN 'Snap' WHEN nJobType=3 THEN 'Replication' ELSE 'NA' END AS 'Job Type',
		JobId AS 'Job ID',AppSizeMB AS 'Usage',OrgGUID AS 'Organization ID',Organization AS 'Organization',PlanName AS 'Plan'
		FROM cf_SurveyLicSCLPeakUsageDetails C WITH (NOLOCK)
		INNER JOIN cf_SurveyResultFuncV1(@i_QueryId_SCLPeakDetails, @i_CommServUniqueId, 1, NULL, NULL, @i_UserId, @i_GroupId) SR ON C.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=C.LicType
		LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=C.AppTypeId
		LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=C.ClientId AND CL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=C.AppId AND SCL.ClientId=C.ClientId AND SCL.CommServUniqueId=SR.CommServUniqueId
		LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=C.SPId AND SP.CommServUniqueId=SR.CommServUniqueId
		WHERE MonthStart=@month
		AND C.ClientId IN (SELECT DISTINCT ClientId FROM cf_SurveyLicSCLPeakCALDetails WITH (NOLOCK) WHERE ObjectType=@objectTypeSCL AND MonthStart=@month)
	END
END
ELSE IF @i_Option=86--Generate Royalty Report details from SCL peak usage
BEGIN
	--input values for this option are expected as follows:
	--@i_GroupId - 0 (commcell groups Id), 1 (service provider Id), 2 (partner Id)
	--@i_CommServUniqueId - 0 (monthly), 1 (quarterly)
    --@i_NoOfMonths - 0 (commcell groups), 1 (service providers), 2 (partners)
	--@i_MonthString - details is collected for this month
	DECLARE @secondDay DATETIME = NULL
	DECLARE @lastMonth DATETIME = NULL
	DECLARE @endMonth NVARCHAR(10) = ''
	SET @secondDay=(CONVERT (DATETIME,@month)+1)
	SET @endMonth=CONVERT(NVARCHAR(10),@secondDay,101)
	DECLARE @ccGrpId INT = 0
	IF object_id('tempdb.dbo.#tempDetailsTableV3') IS NOT null DROP TABLE #tempDetailsTableV3
    CREATE TABLE #tempDetailsTableV3(month DATETIME, bgId INT, countingType INT, jobType INT, jobId INT, licType INT, clientId INT, appTypeId INT, appId INT, spId INT, appSizeMB BIGINT, vmId INT, userId INT, userName NVARCHAR(1024), mailboxName NVARCHAR(1024), hypervisorHost NVARCHAR(1024), sockets INT, csid INT, tenantId VARCHAR(40), tenant NVARCHAR(1024), billVersion INT, planName NVARCHAR(1024))
	IF @i_NoOfMonths=0--CommCell Group
	BEGIN
		IF @i_CommServUniqueId=0--monthly
		BEGIN
			EXEC CM_GenerateInvoice @i_UserId, @i_GroupId, @endMonth, 0, 0, 1, 2
		END
		ELSE--quarterly
		BEGIN
			EXEC CM_GenerateInvoice @i_UserId, @i_GroupId, @endMonth, 0, 0, 1, 2
			SET @lastMonth=CONVERT(DATETIME, @endMonth)
			SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
			SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
			EXEC CM_GenerateInvoice @i_UserId, @i_GroupId, @endMonth, 0, 0, 1, 2
			SET @lastMonth=CONVERT(DATETIME, @endMonth)
			SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
			SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
			EXEC CM_GenerateInvoice @i_UserId, @i_GroupId, @endMonth, 0, 0, 1, 2
		END
	END
	ELSE IF @i_NoOfMonths=1--Service Provider
	BEGIN
		SET @ccGrpId=0
		DECLARE @spCursor AS CURSOR;
        SET @spCursor = CURSOR FAST_FORWARD FOR
        SELECT commCellGroupId FROM cm_AggregatorAssoc WITH (NOLOCK) WHERE aggregatorId=@i_GroupId;
        OPEN @spCursor;
        FETCH NEXT FROM @spCursor INTO @ccGrpId
        WHILE @@FETCH_STATUS = 0
        BEGIN
			IF @i_CommServUniqueId=0--monthly
			BEGIN
				EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_GroupId, 1, 2
			END
			ELSE--quarterly
			BEGIN
				EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_GroupId, 1, 2
				SET @lastMonth=CONVERT(DATETIME, @endMonth)
				SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
				SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
				EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_GroupId, 1, 2
				SET @lastMonth=CONVERT(DATETIME, @endMonth)
				SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
				SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
				EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @i_GroupId, 1, 2
			END
			--Now loop back to the next commcell
            FETCH NEXT FROM @spCursor INTO @ccGrpId;
        END
        CLOSE @spCursor;
        DEALLOCATE @spCursor;
	END
	ELSE IF @i_NoOfMonths=2--Partner
	BEGIN
		DECLARE @spId INT = 0
		DECLARE @partnerCursor AS CURSOR;
        SET @partnerCursor = CURSOR FAST_FORWARD FOR
        SELECT aggregatorId FROM cm_PartnerAssoc WITH (NOLOCK) WHERE partnerId=@i_GroupId;
        OPEN @partnerCursor;
        FETCH NEXT FROM @partnerCursor INTO @spId
        WHILE @@FETCH_STATUS = 0
        BEGIN
			SET @ccGrpId=0
			DECLARE @aggCursor AS CURSOR;
			SET @aggCursor = CURSOR FAST_FORWARD FOR
			SELECT commCellGroupId FROM cm_AggregatorAssoc WITH (NOLOCK) WHERE aggregatorId=@spId;
			OPEN @aggCursor;
			FETCH NEXT FROM @aggCursor INTO @ccGrpId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF @i_CommServUniqueId=0--monthly
				BEGIN
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 2
				END
				ELSE--quarterly
				BEGIN
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 2
					SET @lastMonth=CONVERT(DATETIME, @endMonth)
					SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
					SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 2
					SET @lastMonth=CONVERT(DATETIME, @endMonth)
					SET @lastMonth=DATEADD(MONTH,-1,CONVERT(DATETIME, @endMonth))
					SET @endMonth=CONVERT(NVARCHAR(10),@lastMonth,101)
					EXEC CM_GenerateInvoice @i_UserId, @ccGrpId, @endMonth, 0, @spId, 1, 2
				END
				--Now loop back to the next commcell
				FETCH NEXT FROM @aggCursor INTO @ccGrpId;
			END
			CLOSE @aggCursor;
			DEALLOCATE @aggCursor;
			--Now loop back to the next service provider
			FETCH NEXT FROM @partnerCursor INTO @spId;
		END
		CLOSE @partnerCursor;
		DEALLOCATE @partnerCursor;
	END
	SELECT T.month AS 'Month Start', T.bgId AS 'SKU ID', B.billingGroupName AS 'SKU',
	CASE WHEN T.countingType=0 THEN 'CAL Usage' WHEN T.countingType=1 THEN 'Capacity Usage' ELSE 'N/A' END AS 'Counting Type',
	CASE WHEN T.jobType=0 THEN 'Backup' WHEN T.jobType=1 THEN 'Archive' WHEN T.jobType=2 THEN 'Snapshot' WHEN T.jobType=3 THEN 'Replication' WHEN T.jobType=-1 THEN 'NA' ELSE CONVERT(VARCHAR(10),T.jobType) END AS 'Job Type',
	CASE WHEN T.jobId=-1 THEN 'NA' ELSE CONVERT(VARCHAR(20),T.jobId) END AS 'Job ID', T.licType AS 'License ID', L.name AS 'License',
	T.clientId AS 'Client ID', ISNULL(ISNULL(CL.ClientDisplayName, CL.ClientName),'N/A') AS 'Client', T.appTypeId AS 'Agent ID', A.name AS 'Agent',
	T.appId AS 'Subclient ID', ISNULL(SCL.SubclientName, 'N/A') AS 'Subclient', T.spId AS 'Storage Policy ID', ISNULL(SP.PolicyName, 'N/A') AS 'Storage Policy',
	CASE WHEN T.appSizeMB=-1 THEN -1 ELSE T.appSizeMB END AS 'Usage (MB)',
	CASE WHEN T.appSizeMB=-1 THEN -1 ELSE CAST(T.appSizeMB*1.0/1024 AS DECIMAL(18,3)) END AS 'Usage (GB)',
	CASE WHEN T.appSizeMB=-1 THEN -1 ELSE CAST(T.appSizeMB*1.0/1024/1024 AS DECIMAL(18,3)) END AS 'Usage (TB)',
	T.vmId AS 'VM ID', ISNULL(ISNULL(VMCL.ClientDisplayName, VMCL.ClientName),'N/A') AS 'Virtual Machine',
	userId AS 'User ID', userName AS 'User',mailboxName AS 'Mailbox', hypervisorHost AS 'Hypervisor Host', sockets AS 'Sockets',
	dbo.ConvertBigIntToHexStr(CC.CommCellID) AS 'CommCell ID', T.csid AS 'CommServUniqueID', CC.CustomerName+' - '+CC.CommServName AS 'CommCell',
	T.tenantId AS 'Tenant ID', T.tenant AS 'Tenant', T.planName AS 'Plan', CASE WHEN billVersion=3 THEN 'V3' WHEN billVersion=2 THEN 'V2' ELSE 'V1' END AS 'Billing Version', GETUTCDATE() AS 'Run Time (UTC)'
	FROM #tempDetailsTableV3 T
	INNER JOIN cf_CommcellIdNameMap CC WITH (NOLOCK) ON CC.ID=T.csid
	INNER JOIN cm_BillingGroup B WITH (NOLOCK) ON B.billingGroupId = T.bgid
	LEFT JOIN cf_SurveyLicType L WITH (NOLOCK) ON L.id=T.licType
	LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.ClientId=T.ClientId AND CL.CommServUniqueId=T.csid
	LEFT JOIN cf_SurveyAgentType A WITH (NOLOCK) ON A.id=T.appTypeId
	LEFT JOIN cf_SurveySubclientAssociation SCL WITH (NOLOCK) ON SCL.AppId=T.appId AND SCL.ClientId=T.ClientId AND SCL.CommServUniqueId=T.csid
	LEFT JOIN (SELECT DISTINCT CommServUniqueId,PolicyId,PolicyName FROM cf_SurveyCopyBasicRetention WITH (NOLOCK))SP ON SP.PolicyId=T.spId AND SP.CommServUniqueId=T.csid
	LEFT JOIN cf_SurveyClient VMCL WITH (NOLOCK) ON VMCL.ClientId=T.vmId AND VMCL.CommServUniqueId=T.csid
	IF object_id('tempdb.dbo.#tempDetailsTableV3') IS NOT null DROP TABLE #tempDetailsTableV3
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_Option		INT				= 0
  DECLARE @i_TimeZone VARCHAR(25) 		= '-04:00'
  DECLARE @i_NoOfMonths	INT 			= 12
  DECLARE @i_MonthString VARCHAR(20) 	= ''
exec RptLicGetLicenseDetailsV2 @i_UserId, @i_GroupId, @i_CommServUniqueID, @i_Option, @i_TimeZone, @i_NoOfMonths, @i_MonthString
*/

IF EXISTS (select * from GxQscripts where name = 'RptLicGetLicenseDetailsV2')
	delete from GxQscripts where name = 'RptLicGetLicenseDetailsV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLicGetLicenseDetailsV2')
	delete from GXDBVersions where aliasname = 'RptLicGetLicenseDetailsV2'
GO

insert into GXDBVersions values(2, 'RptLicGetLicenseDetailsV2',  '00010001000200040000', 'RptLicGetLicenseDetailsV2', '00010001000200040000')
GO

