

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptLibraryChartData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptLibraryChartData.sp,v $ $Id: RptLibraryChartData.sp,v 1.1.2.2 2018/03/31 19:01:54 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptLibraryChartData <<<'

IF EXISTS (select * from sysobjects where name='RptLibraryChartData')
	drop procedure RptLibraryChartData
IF EXISTS (select * from GxQscripts where name='RptLibraryChartData')
	delete from GxQscripts where name = 'RptLibraryChartData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryChartData')
	delete from GXDBVersions where aliasname = 'RptLibraryChartData'
GO
print '... Creating Procedure: RptLibraryChartData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptLibraryChartData
  @i_userId INT = 0
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb..#FilteredLibraries') IS NOT NULL DROP TABLE #FilteredLibraries
IF OBJECT_ID('tempdb..#Results') IS NOT NULL DROP TABLE #Results
CREATE TABLE #FilteredLibraries(CommServUniqueId INT, LibraryId INT, MaxLogDateUTC DATE)
CREATE TABLE #Results(CommservUniqueId INT, LibraryId INT, MonthDate DATE, DataWritten FLOAT)
DECLARE @currMonth DATE
INSERT INTO #FilteredLibraries
SELECT P.CommServUniqueId, P.LibraryId, L.MaxLogDateUTC
FROM  DiskLibraryPrediction P WITH(NOLOCK)
	INNER JOIN cf_SurveyResultFuncV1(96,0,1,NULL,NULL,@i_userId,-1) R
		ON P.CommServUniqueId = R.CommServUniqueId
	INNER JOIN (SELECT CommServUniqueId, LibraryId, MAX(LogdateUTC) AS MaxLogDateUTC
			FROM DiskLibraryPrediction WITH(NOLOCK)
			GROUP BY CommServUniqueId, LibraryId ) L
		ON P.CommServUniqueId = L.CommServUniqueId AND P.LibraryId = L.LibraryId AND P.LogDateUTC = L.MaxLogDateUTC
WHERE P.DateToBeFull IS NOT NULL
ORDER BY P.DateToBeFull
DECLARE @currWeek DATETIME, @currDate DATETIME
SET @currDate = (SELECT MAX(MaxLogDateUTC) FROM #FilteredLibraries)
SET @currWeek = DATEADD(WEEK, datediff(week, 0, @currDate), 0)
-- Delete stale entries which are a month old. Such entries mean that no prediction has been done for that disk library lately.
DELETE FROM #FilteredLibraries
WHERE MaxLogDateUTC < @currWeek
-- Get last 12 months data from cf_survey96disklibdetails table
DECLARE @minLogUTCDate DATETIME = (SELECT MIN(LogDateUTC) FROM cf_Survey96DiskLibDetails L WITH(NOLOCK)
																	INNER JOIN #FilteredLibraries T
																		ON L.CommServUniqueId = T.CommServUniqueId AND L.LibraryId = T.LibraryId)
SET @minLogUTCDate = DATEADD(Month, DATEDIFF(MONTH, 0, @minLogUTCDate), 0)
SET @minLogUTCDate = CASE WHEN @minLogUTCDate < DATEADD(Month, -12, @currMonth) THEN DATEADD(Month, -12, @currMonth) ELSE @minLogUTCDate END
--SELECT @minLogUTCDate
;WITH Weeks(mDateStart, mDateEnd) AS
(
SELECT @currWeek , DATEADD(Week, 1, @currWeek)
UNION ALL
SELECT DATEADD(Week, -1, mDateStart), DATEADD(Week, -1, mDateEnd)
FROM Weeks WHERE mDateStart > @minLogUTCDate
)
INSERT INTO #Results(CommservUniqueId, LibraryId, MonthDate, DataWritten)
select T.CommServUniqueId, T.LibraryId, T.mDateStart, MAX(totalDataWrittenGB)
from cf_Survey96DiskLibDetails L WITH(NOLOCK)
	 RIGHT JOIN (SELECT * FROM #FilteredLibraries, Weeks) T
		ON L.CommServUniqueId = T.CommServUniqueId AND L.LibraryId = T.LibraryId
			AND L.LogDateUTC >= T.mDateStart AND L.LogDateUTC < T.mDateEnd
group by T.CommServUniqueId, T.LibraryId, T.mDateStart
order by CommServUniqueId, LibraryId, T.mDateStart
-- Get future prediction values
--select * from #FilteredLibraries T inner join DiskLibraryPrediction L
--			ON T.CommServUniqueId = L.CommServUniqueId AND T.LibraryId = L.LibraryId AND L.LogDateUTC = T.MaxLogDateUTC
;WITH Weeks(mDateStart, mDateEnd) AS
(
SELECT @currWeek, DATEADD(WEEK, 1, @currWeek)
UNION ALL
SELECT DATEADD(WEEK, 1, mDateStart), DATEADD(WEEK, 1, mDateEnd)
FROM Weeks WHERE mDateStart < DATEADD(WEEK, 53, @currWeek)
)
INSERT INTO #Results(CommservUniqueId, LibraryId, MonthDate, DataWritten)
SELECT S.CommServUniqueId, S.LibraryId, S.mDateStart AS WeekDate,
	(CASE
			WHEN (DATEADD(DAY, 7, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(DAY, 7, S.LatestPredictionDate) < S.mDateEnd) THEN L.[1WeekGrowth]
			WHEN (DATEADD(MONTH, 1, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(MONTH, 1, S.LatestPredictionDate) < S.mDateEnd) THEN L.OneMonthGrowth
			WHEN (DATEADD(MONTH, 3, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(MONTH, 3, S.LatestPredictionDate) < S.mDateEnd) THEN L.[3MonthsGrowth]
			WHEN (DATEADD(MONTH, 6, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(MONTH, 6, S.LatestPredictionDate) < S.mDateEnd) THEN L.[6MonthsGrowth]
			WHEN (DATEADD(MONTH, 12, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(MONTH, 12, S.LatestPredictionDate) < S.mDateEnd) THEN L.[12MonthsGrowth]
			WHEN (DATEADD(MONTH, 18, S.LatestPredictionDate) >= S.mDateStart AND DATEADD(MONTH, 18, S.LatestPredictionDate) < S.mDateEnd) THEN L.[18MonthsGrowth]
		END) AS PredictedGrowth
FROM DiskLibraryPrediction L WITH(NOLOCK)
	INNER JOIN
		(SELECT P.CommServUniqueId, P.LibraryId, W.mDateStart, W.mDateEnd,
			MAX(P.LogDateUTC) AS LatestPredictionDate
		FROM #FilteredLibraries T
				INNER JOIN DiskLibraryPrediction P WITH(NOLOCK)
					ON T.CommServUniqueId = P.CommServUniqueId AND T.LibraryId = P.LibraryId
				INNER JOIN Weeks W
					ON (DATEADD(DAY, 7, P.LogDateUTC) >= W.mDateStart AND DATEADD(DAY, 7, P.LogDateUTC) < W.mDateEnd AND P.[1WeekGrowth] IS NOT NULL)
					 OR (DATEADD(MONTH, 1, P.LogDateUTC) >= W.mDateStart AND DATEADD(MONTH, 1, P.LogDateUTC) < W.mDateEnd AND P.OneMonthGrowth IS NOT NULL)
					 OR (DATEADD(MONTH, 3, P.LogDateUTC) >= W.mDateStart AND DATEADD(MONTH, 3, P.LogDateUTC) < W.mDateEnd AND P.[3MonthsGrowth] IS NOT NULL)
					 OR (DATEADD(MONTH, 6, P.LogDateUTC) >= W.mDateStart AND DATEADD(MONTH, 6, P.LogDateUTC) < W.mDateEnd AND P.[6MonthsGrowth] IS NOT NULL)
					 OR (DATEADD(MONTH, 12, P.LogDateUTC) >= W.mDateStart AND DATEADD(MONTH, 12, P.LogDateUTC) < W.mDateEnd AND P.[12MonthsGrowth] IS NOT NULL)
					 OR (DATEADD(MONTH, 18, P.LogDateUTC) >= W.mDateStart AND DATEADD(MONTH, 18, P.LogDateUTC) < W.mDateEnd AND P.[18MonthsGrowth] IS NOT NULL)
		--WHERE CAST(W.mDateStart AS DATE) IN (@currMonth, DATEADD(Month, 1, @currMonth), DATEADD(Month,3, @currMonth),
					--DATEADD(Month, 6, @currMonth), DATEADD(Month, 12, @currMonth), DATEADD(Month, 18, @currMonth))
		GROUP BY P.CommServUniqueId, P.LibraryId, W.mDateStart,W.mDateEnd) S
	ON L.CommServUniqueId = S.CommServUniqueId AND L.LibraryId = S.LibraryId AND L.LogDateUTC = S.LatestPredictionDate
SELECT R.CommServUniqueId, R.LibraryId ,CC.CustomerName+' - '+CC.CommServName AS CommCell, LIB.LibraryName AS Library,
		CAST(R.MonthDate AS DATETIME) AS [Weekly Date],
		CAST(R.DataWritten/1024.0 AS DECIMAL(10,2)) AS [DataWritten (TB)]
FROM (SELECT CommservUniqueId, LibraryId, MonthDate, MAX(DataWritten) AS DataWritten
		FROM #Results
		GROUP BY CommservUniqueId, LibraryId, MonthDate) R
INNER JOIN (SELECT DISTINCT CommservuniqueID, LibraryId, LibraryName FROM cf_Survey96DiskLibDetails WITH(NOLOCK)) LIB
			ON LIB.CommservuniqueID = R.CommservuniqueID AND LIB.LibraryId = R.LibraryId
	INNER JOIN cf_CommcellIdNameMap CC WITH(NOLOCK)
			ON R.CommservuniqueID = CC.ID
WHERE R.DataWritten IS NOT NULL
ORDER BY CC.CustomerName, LIB.LibraryName, MonthDate
IF OBJECT_ID('tempdb..#FilteredLibraries') IS NOT NULL DROP TABLE #FilteredLibraries
IF OBJECT_ID('tempdb..#Results') IS NOT NULL DROP TABLE #Results
SET ANSI_WARNINGS OFF
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptLibraryChartData')
	delete from GxQscripts where name = 'RptLibraryChartData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptLibraryChartData')
	delete from GXDBVersions where aliasname = 'RptLibraryChartData'
GO

insert into GXDBVersions values(2, 'RptLibraryChartData',  '00010001000200020000', 'RptLibraryChartData', '00010001000200020000')
GO

