

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptJobDetails.sp] ---------- 

--#define  DEBUG_TRACKING  1          -- REMOVE ALL TRACES OF DEBUG_TRACKNG BEFORE CHECK-IN
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptJobDetails.sp,v $ $Id: RptJobDetails.sp,v 1.9.2.12 2020/05/14 08:15:24 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: RptJobDetails <<<'
	drop procedure RptJobDetails
END
IF EXISTS (select * from GxQscripts where name='RptJobDetails')
	delete from GxQscripts where name = 'RptJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptJobDetails')
	delete from GXDBVersions where aliasname = 'RptJobDetails'
GO
print '... Creating Procedure: RptJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptJobDetails
  @i_UserId INT = -1,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_TimeRangeBegin DATETIME = NULL,
  @i_TimeRangeEnd DATETIME = NUll,
  @i_JobStatus INT = 0,
  @blaggregate INT = 0,
  @i_ClientId INT = 0,
  @i_AppTypeId INT = 0,
  @i_InstanceId INT = 0,
  @i_BackupsetId INT = 0,
  @i_AppId INT = 0,
  @i_Options INT = 0,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
IF @i_TimeRangeBegin IS NULL
	RETURN
DECLARE @FromTime	INT = DATEDIFF(SECOND, '01/01/1970', @i_TimeRangeBegin)
DECLARE @ToTime		INT = 0x7FFFFFFF
DECLARE @ExcludeTransactionLogs	INT = CASE WHEN (@i_Options & 1) > 0 THEN 1 ELSE 0 END
IF @i_TimeRangeEnd IS NOT NULL
	SET @ToTime = DATEDIFF(SECOND, '01/01/1970', @i_TimeRangeEnd)
DECLARE @i_QueryId BIGINT = 173
DECLARE @i_LatestSurvey INT = 1
DECLARE @FTSASFailedJobs INT = 0
select @FTSASFailedJobs =  ISNULL(value,0) from cf_surveyConfig WITH (NOLOCK) where name like 'considerFailedToStartAsFailedJobsInActivity'
CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
	CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
	exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, 1, @i_CommServUniqueID, NULL, NULL, @i_TenantName
IF @blaggregate = 0
BEGIN
	IF	@i_CommServUniqueID > 0 AND @i_ClientId > 0
		EXEC GetClientGroupsString @i_CommServUniqueID, @i_ClientId
	ELSE
	IF	@i_CommServUniqueID > 0
		EXEC GetClientGroupsString @i_CommServUniqueID
END
IF(@blaggregate=1)
BEGIN
	DECLARE @Day_table TABLE
	(
	servEndDate					DATE
	)
	DECLARE @DailyJobs TABLE
	(
	Completed					BIGINT ,
	CWEOrCWW					BIGINT ,
	Failed                      BIGINT ,
	Killed                      BIGINT ,
	Skipped                      BIGINT ,
	CommittedJ					BIGINT,
	servEndDate					DATE
	)
	;WITH R(N) AS
	(
	SELECT 0
	UNION ALL
	SELECT N+1
	FROM R
	WHERE N < DATEDIFF(DAY, @i_TimeRangeBegin, @i_TimeRangeEnd)
	)
	INSERT INTO @Day_table
	SELECT  DATEADD(DAY,-N,CAST(@i_TimeRangeEnd AS DATE))
	FROM R
	INSERT INTO @DailyJobs
		SELECT
			SUM(case when Status = 1 then 1 else 0 end) AS Completed,
			SUM(case when Status IN (3, 14) then 1 else 0 end) AS CWEOrCWW,
			SUM(CASE WHEN Status IN (2) THEN 1
			WHEN Status IN (9) AND @FTSASFailedJobs = 1  AND failureErrorCode  IN (8)  THEN 1
					 ELSE 0 END ) AS Failed,
			SUM(case when Status =4 then 1 else 0 end) AS Killed,
			SUM(CASE WHEN Status IN (9) AND (failureErrorCode NOT IN (8) OR @FTSASFailedJobs = 0) THEN 1 ELSE 0 END ) AS Skipped,
			SUM(CASE WHEN Status IN (16) then 1 else 0 end) AS CommittedJ,
			CAST(dbo.GetDateTime(EndDate) AS DATE) AS EndDate
	FROM	cf_SurveyJobStats J WITH (NOLOCK)
			INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK)
				ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
			AND J.EndDate BETWEEN @FromTime AND @ToTime
		   LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                    ON S.CommServUniqueId = TC.CommServUniqueId AND S.ClientId = TC.ClientId
		   INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) AS resultView
		   ON resultView.CommservUniqueId = J.CommservUniqueId
		   	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND (@ExcludeTransactionLogs = 0
				OR (NOT (BkpLevel = 2 AND AppTypeId  IN (4,16,70,81))))     -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
	GROUP BY CAST(dbo.GetDateTime(EndDate) AS DATE)
	SELECT
		dbo.GetUnixTimeBig(d.servEndDate) AS 'Date<MMMDDYYYY>',
		ISNULL(Completed,0) AS 'Completed',
		ISNULL(CWEOrCWW,0) AS 'Completed with Errors or Warnings',
		ISNULL(Failed,0) AS 'Failed',
		ISNULL(Killed,0) AS 'Killed',
		ISNULL(Skipped,0) AS 'Skipped',
		ISNULL(CommittedJ,0) AS 'Committed'
	FROM @Day_table  D
	LEFT OUTER JOIN @DailyJobs J
	ON J.servEndDate = D.servEndDate
	 ORDER BY D.servEndDate
END
ELSE
IF @i_commservUniqueId > 0 AND @i_ClientId > 0
BEGIN
	CREATE TABLE #Subclient (CommservUniqueId INT, AppId INT, AppTypeId INT,
		ClientName NVARCHAR(256), AgentName VARCHAR(256), InstanceName NVARCHAR(512), BackupsetName NVARCHAR(128), SubclientName NVARCHAR(128))
	IF @i_AppId > 0
		INSERT INTO #Subclient
		SELECT	CommservUniqueId, AppId, AppTypeId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName
		FROM	cf_SurveySubclientAssociation WITH (NOLOCK)
		WHERE	CommservUniqueId = @i_commservUniqueId AND ClientId = @i_ClientId AND AppId = @i_AppId
	ELSE
		INSERT INTO #Subclient
		SELECT	CommservUniqueId, AppId, AppTypeId, ClientName, AgentName, InstanceName, BackupsetName, SubclientName
		FROM	cf_SurveySubclientAssociation WITH (NOLOCK)
		WHERE	CommservUniqueId = @i_commservUniqueId AND ClientId = @i_ClientId
			AND (@i_AppTypeId = 0 OR AppTypeId = @i_AppTypeId)
			AND (@i_InstanceId = 0 OR InstanceId = @i_InstanceId)
			AND (@i_BackupsetId = 0 OR BackupsetId = @i_BackupsetId)
	SELECT
		(SELECT ISNULL(ClientDisplayName, ClientName) FROM cf_SurveyClient WITH (NOLOCK) WHERE CommservUniqueId = @i_CommServUniqueID AND ClientId = @i_ClientId) AS 'Client',
		AgentName AS 'Agent',
		InstanceName AS 'Instance<HIDDEN>',
		BackupsetName AS 'Backupset<HIDDEN>',
		SubclientName AS 'Subclient',
		JobId AS 'Job ID',
		0 AS 'Parent Job ID<HIDDEN>',
		StartDate AS 'Start Time<DATETIME>',
		EndDate AS 'End Time<DATETIME>',
		CASE Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN (CASE WHEN failureErrorCode NOT IN (8) THEN 'Skipped'
			WHEN failureErrorCode = 8 AND  @FTSASFailedJobs = 0 THEN 'Skipped' ELSE 'Failed To Start' END)
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE OpType
			WHEN 4 THEN (CASE WHEN AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE BkpLevel
			WHEN 1 THEN (CASE WHEN AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
		  	WHEN 0x8000  THEN N'Online Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
		CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
		CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		J.StoragePolicy AS 'Storage Policy<HIDDEN>',
		ISNULL((SELECT TOP 1 ClientGroups FROM #ClientGroupsString), '') AS 'Client Groups<HIDDEN>',
		ErrorCode AS 'Error Code<HIDDEN>',
		FailureReason AS 'Failure Reason<HIDDEN>'
	FROM
		cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN #Subclient S ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId AND S.AppTypeId <> 106
	WHERE
		J.StartDate BETWEEN @FromTime AND @ToTime
		AND (@i_JobStatus = 0
		  OR @i_JobStatus = 1 AND J.Status = 1
		  OR @i_JobStatus = 2 AND (J.Status = 2	OR (J.Status IN (9) AND failureErrorCode IN (8) AND @FTSASFailedJobs = 1))
		  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
		  OR @i_JobStatus = 4 AND J.Status = 4
		  OR @i_JobStatus = 5 AND (J.Status = 9 AND (failureErrorCode NOT IN (8) OR @FTSASFailedJobs = 0))
		  OR @i_JobStatus = 6 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
		AND (@ExcludeTransactionLogs = 0
				OR (NOT (BkpLevel = 2 AND AppTypeId  IN (4,16,70,81))))     -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
--	ORDER BY 'Client', AgentName, JobId DESC
	UNION
	SELECT
		(SELECT ISNULL(ClientDisplayName, ClientName) FROM cf_SurveyClient WITH (NOLOCK) WHERE CommservUniqueId = @i_CommServUniqueID AND ClientId = @i_ClientId) AS 'Client',
		S.AgentName AS 'Agent',
		S.InstanceName AS 'Instance<HIDDEN>',
		S.BackupsetName AS 'Backupset<HIDDEN>',
		S.SubclientName AS 'Subclient',
		J.JobId AS 'Job ID',
		ISNULL(V.ParentJobId, 0) AS 'Parent Job ID<HIDDEN>',
		J.StartDate AS 'Start Time<DATETIME>',
		J.EndDate AS 'End Time<DATETIME>',
		CASE J.Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN CASE WHEN failureErrorCode NOT IN (8) THEN 'Skipped'
			WHEN failureErrorCode = 8 AND  @FTSASFailedJobs = 0 THEN 'Skipped' ELSE 'Failed To Start' END
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE J.OpType
			WHEN  4 THEN (CASE WHEN S.AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE J.BkpLevel
			WHEN 1 THEN (CASE WHEN S.AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN S.AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN S.AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN S.AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN S.AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
		  	WHEN 0x8000  THEN N'Online Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE J.ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
--		CAST(J.DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN vmIsGuestSizeValid = 1 THEN ISNULL(vmGuestSize, vmUsedSpace) ELSE ISNULL(vmUsedSpace, 0) END)/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN J.DataProtected > 0 AND J.DataProtected > J.DataCompressed THEN 100.0*(J.DataProtected - J.DataCompressed)/J.DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(J.DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
--		CAST(J.DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN J.DataProtected = 0 THEN 0
			ELSE (1.0*J.DataWritten/J.DataProtected)*(CASE WHEN vmIsGuestSizeValid = 1 THEN ISNULL(vmGuestSize, vmUsedSpace) ELSE ISNULL(vmUsedSpace, 0) END)
			END)/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN J.DataProtected > 0 AND J.DataProtected > J.DataWritten THEN 100.0*(J.DataProtected - J.DataWritten)/J.DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		J.SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		J.TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN J.TransferTime > 0 THEN 3600.0*J.DataProtected/1024.0/1024.0/1024.0/J.TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		J.StoragePolicy AS 'Storage Policy<HIDDEN>',
		ISNULL((SELECT TOP 1 ClientGroups FROM #ClientGroupsString), '') AS 'Client Groups<HIDDEN>',
		J.ErrorCode AS 'Error Code<HIDDEN>',
		ISNULL(V.vmFailureReason, J.FailureReason) AS 'Failure Reason<HIDDEN>'
	FROM
		cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN cf_SurveyJobVMStats V WITH (NOLOCK) ON J.CommservUniqueId = V.CommservUniqueId AND J.JobId = V.JobId
		INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
		INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON V.CommservUniqueId = C.CommservUniqueId AND V.vmClientId = C.ClientId
	WHERE
		V.CommservUniqueId = @i_commservUniqueId AND V.vmClientId = @i_ClientId
		AND V.vmBackupStart BETWEEN @FromTime AND @ToTime
		AND (@i_JobStatus = 0
		  OR @i_JobStatus = 1 AND J.Status = 1
		  OR @i_JobStatus = 2 AND (J.Status = 2	OR (J.Status IN (9) AND failureErrorCode IN (8) AND @FTSASFailedJobs = 1))
		  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
		  OR @i_JobStatus = 4 AND J.Status = 4
		  OR @i_JobStatus = 5 AND (J.Status = 9 AND (failureErrorCode NOT IN (8) OR @FTSASFailedJobs = 0))
		  OR @i_JobStatus = 6 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
  	    AND (@ExcludeTransactionLogs = 0
				OR (NOT (BkpLevel = 2 AND AppTypeId  IN (4,16,70,81))))     -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
	ORDER BY 'Client', AgentName, JobId DESC
	DROP TABLE #Subclient
END
ELSE
IF @i_commservUniqueId = 0
BEGIN
	SELECT
		J.CommServUniqueId AS 'CommServ UniqueId',
		R.DisplayName AS 'CommCell Name',
		ISNULL(C.ClientDisplayName, C.ClientName) AS 'Client',
		AgentName AS 'Agent',
		InstanceName AS 'Instance<HIDDEN>',
		BackupsetName AS 'Backupset<HIDDEN>',
		SubclientName AS 'Subclient',
		JobId AS 'Job ID',
		StartDate AS 'Start Time<DATETIME>',
		EndDate AS 'End Time<DATETIME>',
		CASE Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN CASE WHEN failureErrorCode NOT IN (8) THEN 'Skipped'
			WHEN failureErrorCode = 8 AND  @FTSASFailedJobs = 0 THEN 'Skipped' ELSE 'Failed To Start' END
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE OpType
			WHEN 4 THEN (CASE WHEN AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE BkpLevel
			WHEN 1 THEN (CASE WHEN AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
		  	WHEN 0x8000  THEN N'Online Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
		CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
		CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		J.StoragePolicy AS 'Storage Policy<HIDDEN>',
		ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>',
		ErrorCode AS 'Error Code<HIDDEN>',
		FailureReason AS 'Failure Reason<HIDDEN>'
	FROM
		cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
		INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON J.CommservUniqueId = C.CommservUniqueId AND S.ClientId = C.ClientId
  	    INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) R ON R.CommservUniqueId = J.CommservUniqueId
		LEFT OUTER JOIN #ClientGroupsString CGS ON S.CommservUniqueId = CGS.CommServUniqueId AND S.ClientId = CGS.ClientId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                    ON S.CommServUniqueId = TC.CommServUniqueId AND S.ClientId = TC.ClientId
	WHERE
		(J.EndDate BETWEEN @FromTime AND @ToTime
		AND (@i_JobStatus = 0
		  OR @i_JobStatus = 1 AND J.Status = 1
		  OR @i_JobStatus = 2 AND (J.Status = 2	OR (J.Status IN (9) AND failureErrorCode IN (8) AND @FTSASFailedJobs = 1))
		  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
		  OR @i_JobStatus = 4 AND J.Status = 4
		  OR @i_JobStatus = 5 AND (J.Status = 9 AND (failureErrorCode NOT IN (8) OR @FTSASFailedJobs = 0))
		  OR @i_JobStatus = 6 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
	    AND (@ExcludeTransactionLogs = 0
				OR (NOT (BkpLevel = 2 AND AppTypeId  IN (4,16,70,81))))) AND ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)    -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
	ORDER BY 'Client', AgentName, JobId DESC
END
ELSE
BEGIN
	SELECT
		ISNULL(C.ClientDisplayName, C.ClientName) AS 'Client',
		AgentName AS 'Agent',
		InstanceName AS 'Instance<HIDDEN>',
		BackupsetName AS 'Backupset<HIDDEN>',
		SubclientName AS 'Subclient',
		JobId AS 'Job ID',
		StartDate AS 'Start Time<DATETIME>',
		EndDate AS 'End Time<DATETIME>',
		CASE Status
			WHEN 0 THEN 'Running'
			WHEN 1 THEN 'Completed'
			WHEN 2 THEN 'Failed'
			WHEN 3 THEN 'Completed with errors'
			WHEN 4 THEN 'Killed'
			WHEN 5 THEN 'Suspended'
			WHEN 6 THEN 'Interrupted'
			WHEN 7 THEN 'Any Status'
			WHEN 8 THEN 'Skipped'
			WHEN 9 THEN CASE WHEN failureErrorCode NOT IN (8) THEN 'Skipped'
			WHEN failureErrorCode = 8 AND  @FTSASFailedJobs = 0 THEN 'Skipped' ELSE 'Failed To Start' END
			WHEN 10 THEN 'Synchronized'
			WHEN 11 THEN 'Not Synchronized'
			WHEN 12 THEN 'Not Attempted'
			WHEN 13 THEN 'Started'
			WHEN 14 THEN 'Completed with warnings'
			WHEN 15 THEN 'System Failed'
			WHEN 16 THEN 'Committed'
			ELSE 'Unknown'
		END AS 'Job Status',
		CASE OpType
			WHEN 4 THEN (CASE WHEN AppTypeId = 67 THEN N'Compliance Archive' ELSE N'Backup' END)
			WHEN 14 THEN N'Synthetic Full'
			WHEN 18 THEN N'Backup 3RD'
			WHEN 59 THEN N'Snap Backup'
			WHEN 60 THEN N'Backup Copy'
			WHEN 65 THEN N'Snap Backup3RD'
			ELSE N'Unknown'
		END AS 'Operation',
		CASE BkpLevel
			WHEN 1 THEN (CASE WHEN AppTypeId IN (45,56,57,58,67,73) THEN N'New Index' ELSE N'Full' END)
			WHEN 2 THEN (CASE WHEN AppTypeId IN (4,5,16,70,81) THEN N'Transaction Log' WHEN AppTypeId = 125 THEN N'Log Only' ELSE N'Incremental' END)
			WHEN 4 THEN (CASE WHEN AppTypeId IN (37,62) THEN N'Delta' ELSE N'Differential' END)
			WHEN 0x40    THEN N'Synthetic Full' WHEN 0x80 THEN N'Synthetic Full' WHEN 0x4000 THEN N'Synthetic Full'
			WHEN 0x100   THEN (CASE WHEN AppTypeId = 104 THEN N'Incremental' ELSE N'Transaction Log' END)
			WHEN 0x200   THEN N'ASR'
			WHEN 0x800   THEN N'Snapshot'
			WHEN 0x1000  THEN N'New Volume Creation'
			WHEN 0x2000  THEN N'Incremental Volume Update'
			WHEN 0x400   THEN N'Offline Full'
		  	WHEN 0x8000  THEN N'Online Full'
			WHEN 0x20000 THEN N'Analysis'
			WHEN 0x40000 THEN N'Discovery'
			ELSE N'Unknown'
		END AS 'Job Type',
		CASE ScanType
			WHEN 1 THEN 'Change Journal'
			WHEN 2 THEN 'Classic'
			WHEN 3 THEN 'Mixed'
			WHEN 4 THEN 'Optimized Scan'
			ELSE 'N/A'
		END AS 'Scan Type<HIDDEN>',
		CAST(DataProtected/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Application Size<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataCompressed THEN 100.0*(DataProtected - DataCompressed)/DataProtected ELSE 0 END)
			AS DECIMAL(20,2)) AS 'Compression Rate (%)<HIDDEN>',
		CAST(DataTransferred/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Transferred<SIZEMB><HIDDEN>',
		CAST(DataWritten/1024.0/1024.0 AS DECIMAL(30,3)) AS 'Data Written<SIZEMB>',
		CAST((CASE WHEN DataProtected > 0 AND DataProtected > DataWritten THEN 100.0*(DataProtected - DataWritten)/DataProtected ELSE 0 END)
			AS DECIMAL(10,2)) AS 'Space Saving (%)<HIDDEN>',
		SizeChangePct AS 'Data Size Change (%)<HIDDEN>',
		TransferTime AS 'Transfer Time<HIDDEN><HHMMSS>',
		CAST((CASE WHEN TransferTime > 0 THEN 3600.0*DataProtected/1024.0/1024.0/1024.0/TransferTime ELSE 0.0 END)
			AS DECIMAL(10,3)) AS 'Throughput (GB/Hour)<HIDDEN>',
		J.StoragePolicy AS 'Storage Policy<HIDDEN>',
		ISNULL(CGS.ClientGroups, '') AS 'Client Groups<HIDDEN>',
		ErrorCode AS 'Error Code<HIDDEN>',
		FailureReason AS 'Failure Reason<HIDDEN>'
	FROM
		cf_SurveyJobStats J WITH (NOLOCK)
		INNER JOIN cf_SurveySubclientAssociation S WITH (NOLOCK) ON J.CommservUniqueId = S.CommservUniqueId AND J.AppId = S.AppId
		INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON J.CommservUniqueId = C.CommservUniqueId AND S.ClientId = C.ClientId
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, NULL, NULL,@i_UserId,@i_GroupId) R ON R.CommservUniqueId = J.CommservUniqueId
		LEFT OUTER JOIN #ClientGroupsString CGS ON S.CommservUniqueId = CGS.CommServUniqueId AND S.ClientId = CGS.ClientId
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                    ON S.CommServUniqueId = TC.CommServUniqueId AND S.ClientId = TC.ClientId
	WHERE
		(J.EndDate BETWEEN @FromTime AND @ToTime
		AND (@i_JobStatus = 0
		  OR @i_JobStatus = 1 AND J.Status = 1
		  OR @i_JobStatus = 2 AND (J.Status = 2	OR (J.Status IN (9) AND failureErrorCode IN (8) AND @FTSASFailedJobs = 1))
		  OR @i_JobStatus = 3 AND J.Status IN (3, 14)
		  OR @i_JobStatus = 4 AND J.Status = 4
		  OR @i_JobStatus = 5 AND (J.Status = 9 AND (failureErrorCode NOT IN (8) OR @FTSASFailedJobs = 0))
		  OR @i_JobStatus = 6 AND J.Status NOT IN (1, 2, 3, 4, 9, 14))
		AND (@ExcludeTransactionLogs = 0
				OR (NOT (BkpLevel = 2 AND AppTypeId  IN (4,16,70,81))))) AND ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL)     -- 5, 125 ARE OTHER DBs w/Transaction Logs but we are excluding from this option
	ORDER BY 'Client', AgentName, JobId DESC
END
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
DROP TABLE #ClientGroupsString
SET NOCOUNT OFF
/*
DECLARE @i_UserId			INT =1
DECLARE @i_GroupId			INT =-1
DECLARE @i_CommServUniqueID	INT = 10000
DECLARE @i_TimeRangeBegin	DATETIME ='Dec  5 2018 12:00AM'
DECLARE @i_TimeRangeEnd		DATETIME ='Dec  5 2018 11:59PM'
DECLARE @i_JobStatus		INT =1
DECLARE @blaggregate		INT =0
DECLARE @i_ClientId			INT =0
DECLARE @i_AppTypeId		INT =0
DECLARE @i_InstanceId		INT =0
DECLARE @i_BackupsetId		INT =0
DECLARE @i_AppId			INT =0
DECLARE @i_Options			INT =0
exec RptJobDetails @i_UserId, @i_GroupId, @i_CommServUniqueID, @i_TimeRangeBegin, @i_TimeRangeEnd, @i_JobStatus, @blaggregate, @i_ClientId, @i_AppTypeId ,@i_InstanceId ,@i_BackupsetId ,@i_AppId ,@i_Options
*/
GO

IF EXISTS (select * from GxQscripts where name = 'RptJobDetails')
	delete from GxQscripts where name = 'RptJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptJobDetails')
	delete from GXDBVersions where aliasname = 'RptJobDetails'
GO

insert into GXDBVersions values(2, 'RptJobDetails',  '00010009000200120000', 'RptJobDetails', '00010009000200120000')
GO

