

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIndexStateStatus.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIndexStateStatus.sp,v $ $Id: RptIndexStateStatus.sp,v 1.1.2.12 2020/09/30 12:21:44 skushwaha Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptIndexStateStatus')
BEGIN
	print '>>> Drop Stored Procedure: RptIndexStateStatus <<<'
	drop procedure RptIndexStateStatus
END
IF EXISTS (select * from GxQscripts where name='RptIndexStateStatus')
	delete from GxQscripts where name = 'RptIndexStateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexStateStatus')
	delete from GXDBVersions where aliasname = 'RptIndexStateStatus'
GO
print '... Creating Procedure: RptIndexStateStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptIndexStateStatus
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 200
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalDaysIdxState INT = (SELECT CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 201 AND ThresholdName = 'Index State')
IF object_id('tempdb.dbo.#tmpIdxStateReportResults') IS NOT NULL DROP TABLE #tmpIdxStateReportResults
SELECT
	resultView.CommServUniqueId AS [CommServ UniqueId],
	resultView.DisplayName AS [CommCell Name],
	ISNULL(CL.clientDisplayName, csInfo.Client) AS [Client],
	csInfo.apptype AS [Agent],
	csInfo.Backupset AS [Backup Set],
	csInfo.subclientName as [Subclient],
	csInfo.IndexType AS [Index Type],
	csInfo.IndexServer AS [Index Server],
	CASE WHEN csInfo.lastTimeDbUptodate != -1 THEN dbo.GetUnixTimeBig(dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(csInfo.lastTimeDbUptodate), CM.CommServTZ)) ELSE -1 END  AS [Last Backup Time<DATETIME>],
	CASE WHEN csInfo.lastPlayedJobTime != -1 THEN dbo.GetUnixTimeBig(dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(csInfo.lastPlayedJobTime), CM.CommServTZ)) ELSE -1 END  AS [Last Index Update<DATETIME>],
	CASE WHEN csInfo.lastCompactionTime != 0 THEN dbo.GetUnixTimeBig(dbo.UTCToLocalDateTimeConversion(dbo.GetDateTime(csInfo.lastCompactionTime), CM.CommServTZ)) ELSE -1 END AS [Last Compaction Time<DATETIME>],
	CASE
		WHEN ((csInfo.errorLevel BETWEEN 1 AND 5) AND (csInfo.LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState))) OR
			 ((csInfo.errorLevel > 5 AND csInfo.LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState)) OR csInfo.dbuptodate = 0)
		THEN csInfo.errorDesc ELSE '' END AS [Error],
	CASE
		WHEN (csInfo.errorLevel BETWEEN 1 AND 5) AND (csInfo.LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState)) THEN @strCritical
		WHEN (csInfo.errorLevel > 5 AND csInfo.LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState)) OR csInfo.dbuptodate = 0 THEN @strwarning
		ELSE @strGood
	END AS [Status<HEALTH_STATUS>],
	dbName AS [DBName <HIDDEN>]
INTO #tmpIdxStateReportResults
FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView ON resultView.SurverResultId = csInfo.SurveyResultId
LEFT JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = resultView.CommServUniqueId AND CL.ClientId = csInfo.ClientId
JOIN cf_CommcellIdNameMap CM WITH (NOLOCK) ON CM.ID = resultView.CommServUniqueId
IF(@blaggregate=1)
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT
			[CommServ UniqueId] AS [CommServ UniqueId],
			[CommCell Name] AS [CommCell],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical) THEN 1 ELSE 0 END) AS [Critical Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strWarning) THEN 1 ELSE 0 END) AS [Warning Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical OR [Status<HEALTH_STATUS>] = @strWarning) THEN 1 ELSE 0 END) AS [Total Affected]
		FROM #tmpIdxStateReportResults
		GROUP BY [CommServ UniqueId], [CommCell Name]
		ORDER BY [Total Affected] DESC
	END
	ELSE
	BEGIN
		SELECT
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical) THEN 1 ELSE 0 END) AS [Critical Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strWarning) THEN 1 ELSE 0 END) AS [Warning Count],
			SUM(CASE WHEN ([Status<HEALTH_STATUS>] = @strCritical OR [Status<HEALTH_STATUS>] = @strWarning) THEN 1 ELSE 0 END) AS [Total Affected]
		FROM #tmpIdxStateReportResults
	END
END
ELSE
BEGIN
	IF @i_CommServUniqueID = 0
	BEGIN
		SELECT
			[CommServ UniqueId],
			[CommCell Name],
			[Client],
			[Agent],
			[Backup Set],
			[Subclient],
			[Index Type],
			[Index Server],
			[Last Backup Time<DATETIME>],
			[Last Index Update<DATETIME>],
			[Last Compaction Time<DATETIME>],
			[Error],
			[Status<HEALTH_STATUS>],
			[DBName <HIDDEN>]
		FROM #tmpIdxStateReportResults
		ORDER BY  [Status<HEALTH_STATUS>] DESC, [CommCell Name] ASC
	END
	ELSE
	BEGIN
		SELECT
			[Client],
			[Agent],
			[Backup Set],
			[Subclient],
			[Index Type],
			[Index Server],
			[Last Backup Time<DATETIME>],
			[Last Index Update<DATETIME>],
			[Last Compaction Time<DATETIME>],
			[Error],
			[Status<HEALTH_STATUS>],
			[DBName <HIDDEN>]
		FROM #tmpIdxStateReportResults
		ORDER BY [Status<HEALTH_STATUS>] DESC
	END
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= NULL   -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptIndexStateStatus @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptIndexStateStatus')
	delete from GxQscripts where name = 'RptIndexStateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIndexStateStatus')
	delete from GXDBVersions where aliasname = 'RptIndexStateStatus'
GO

insert into GXDBVersions values(2, 'RptIndexStateStatus',  '00010001000200120000', 'RptIndexStateStatus', '00010001000200120000')
GO

