

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptIncrBkpChangeRate.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptIncrBkpChangeRate.sp,v $ $Id: RptIncrBkpChangeRate.sp,v 1.9.2.1 2016/06/06 23:37:52 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptIncrBkpChangeRate <<<'

IF EXISTS (select * from sysobjects where name='RptIncrBkpChangeRate')
	drop procedure RptIncrBkpChangeRate
IF EXISTS (select * from GxQscripts where name='RptIncrBkpChangeRate')
	delete from GxQscripts where name = 'RptIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'RptIncrBkpChangeRate'
GO
print '... Creating Procedure: RptIncrBkpChangeRate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptIncrBkpChangeRate
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
BEGIN
IF(@blaggregate=1)
	RETURN
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 28
IF @i_CommServUniqueID = 0
BEGIN
SELECT
	resultView.CommServUniqueId  AS 'CommServ UniqueId',
	resultView.CommCellID AS 'CommCell ID',
	resultView.CommServIP AS 'CommServe IP<HIDDEN>',
	resultView.CommServGUID AS 'CommServer GUID',
	resultView.DisplayName AS 'CommCell Name',
	--ISNULL((CONVERT(VARCHAR(20), csInfo.LogDate, 100) + ' (' + resultView.CommServTimeZone + ')'), 'N/A') AS 'Collection Time',
	CASE
		WHEN resultView.RunningTime = -1 THEN 'N/A'
		ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
	END AS 'Running Time in Seconds',
	--dbo.FormatBytes(csInfo.TotalBkpSize, 'GB') AS 'Total Backup Size',
	--csInfo.TotalJobs AS 'Total Jobs',
	CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101) AS 'Date',
	csInfo.ChangePercent AS 'Percentage Change',
	CAST((csInfo.TotalChangeInGB*1024.00) AS DECIMAL(32,2)) AS 'Size Change<SIZEMB_NEG>',
	CAST((csInfo.BackupSize*1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY csInfo.LogDate DESC, resultView.DisplayName ASC
END
ELSE
SELECT
	csInfo.CommServUniqueId AS 'CommServ UniqueId',
	--CONVERT(VARCHAR(20), csInfo.LogDate, 100) AS 'Collection Time',
	--dbo.FormatBytes(csInfo.TotalBkpSize, 'GB') AS 'Total Backup Size',
	--csInfo.TotalJobs AS 'Total Jobs',
	CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101) AS 'Date',
	csInfo.ChangePercent AS 'Percentage Change',
	CAST((csInfo.TotalChangeInGB*1024.00) AS DECIMAL(32,2)) AS 'Size Change<SIZEMB_NEG>',
	CAST((csInfo.BackupSize*1024.00) AS DECIMAL(32,2)) AS 'Application Size<SIZEMB>'
FROM cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
	INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		AND resultView.LogDateUTC = csInfo.LogDateUTC
		AND resultView.CommServUniqueId = csInfo.CommServUniqueId
		AND ((resultView.SureyResultFlags = @blLatestSurvey) OR @blLatestSurvey = 0)
		AND (csInfo.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
ORDER BY CONVERT(VARCHAR(10),DATEADD(second, csInfo.UxDate, {d '1970-01-01'}),101)
SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'RptIncrBkpChangeRate')
	delete from GxQscripts where name = 'RptIncrBkpChangeRate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptIncrBkpChangeRate')
	delete from GXDBVersions where aliasname = 'RptIncrBkpChangeRate'
GO

insert into GXDBVersions values(2, 'RptIncrBkpChangeRate',  '00010009000200010000', 'RptIncrBkpChangeRate', '00010009000200010000')
GO

