

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetServerHealthAlrm.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetServerHealthAlrm.sp,v $ $Id: RptGetServerHealthAlrm.sp,v 1.15.2.93.4.3 2021/06/02 19:03:07 mmansano Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetServerHealthAlrm')
BEGIN
	print '>>> Drop Stored Procedure: RptGetServerHealthAlrm <<<'
	drop procedure RptGetServerHealthAlrm
END
IF EXISTS (select * from GxQscripts where name='RptGetServerHealthAlrm')
	delete from GxQscripts where name = 'RptGetServerHealthAlrm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServerHealthAlrm')
	delete from GXDBVersions where aliasname = 'RptGetServerHealthAlrm'
GO
print '... Creating Procedure: RptGetServerHealthAlrm'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetServerHealthAlrm
  @i_userId INTEGER,
  @i_CommServUniqueId INTEGER,
  @i_ParamId INTEGER,
  @i_ParamValue NVARCHAR(1024) = '',
  @i_Operator INTEGER = 0,
  @i_Status NVARCHAR(1024) = ''
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@i_ParamName		NVARCHAR(1024)
    DECLARE @CSVersion VARCHAR(128) = ''
	-- Operator 0 - <, 1 - >, 2 - =, , 8 - <>
	DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
	DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
	DECLARE @warningThreshold	INT
	DECLARE @criticalThreshold	INT
	DECLARE @goodMessage		NVARCHAR(MAX)
	DECLARE @warningMessage		NVARCHAR(MAX)
	DECLARE @criticalMessage	NVARCHAR(MAX)
	DECLARE @infoMessage		NVARCHAR(MAX)
	DECLARE @query				NVARCHAR(MAX) = N''
    DECLARE @csGUID             VARCHAR(256)
	DECLARE @CurrWeek DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
	DECLARE @MaxNumOfWeeksforGrowthRate INT = 12
	DECLARE @FirstWeek DATE = DATEADD(WEEK, -@MaxNumOfWeeksforGrowthRate, @CurrWeek)
	DECLARE @showHiddenLibraries INT = 0
	IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
		SET @showHiddenLibraries = 1
	DECLARE @TblSurveyResult TABLE
	(
		CommServUniqueId INTEGER NULL,
		GroupId INTEGER NULL,
		GroupName NVARCHAR(MAX) NULL,
		MonitorId INTEGER NULL,
		Monitor NVARCHAR(MAX) NULL,
		Status VARCHAR(10) NULL,
		LogDate DATETIME,
		Result NVARCHAR(MAX),
		ExpectedResult NVARCHAR(MAX),
		Recommendation NVARCHAR(MAX),
		GroupSortOrder INT,
		MonitorSortOrder INT
	)
	SELECT @i_ParamName = ParameterName FROM cf_SurveyHealthParam WHERE ParamId = @i_ParamId
    SELECT @csGUID = CommservGUID FROM cf_CommcellIdNameMap WHERE ID = @i_CommServUniqueId
	DECLARE @TblLatestResult TABLE (QueryId INT, SurveyResultId BIGINT, LogDateUTC DATETIME)
	DECLARE @MaxNumOfMonthsforGrowthRate INT = 6
	DECLARE @CurrMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
	DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
	IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	INSERT INTO @tblSurveyResult
	SELECT	@i_CommServUniqueId, sGroup.SurveyGroupId, sGroup.Name, survey.QueryId, CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END, 'Unknown', '', '', '', '' , map.GroupSortOrder, map.SurveySortOrder
	FROM	cf_CommservSurveyQueries AS survey
			INNER JOIN dbo.RptGetMetricsQueryFlags(0) qflags ON survey.QueryId = qFlags.QueryId
			INNER JOIN cf_CommservSurveyGroupMap AS map
				ON map.SurveyId = survey.QueryId
				AND qFlags.QueryFlags & 4 = 4
			INNER JOIN cf_CommservSurveyGroups as sGroup
				ON sGroup.SurveyGroupId = map.GroupId
	INSERT	INTO @TblLatestResult
	SELECT	DISTINCT R.QueryId, R.CommservSurveyResults_ID, LogDateUTC
	FROM	cf_CommservSurveyResults R WITH (NOLOCK)
			INNER JOIN @TblSurveyResult S ON R.QueryId = S.MonitorId
	WHERE	R.CommcellIdNameMap_ID = @i_CommServUniqueId AND R.Flags = 1
	IF object_id('tempdb.dbo.#resultTbl') is not null DROP TABLE #resultTbl
	CREATE TABLE #resultTbl (Result NVARCHAR(MAX), CommServeName NVARCHAR(256), Reason NVARCHAR(MAX), Remarks NVARCHAR(MAX))
	DECLARE @tmpStatus NVARCHAR(MAX)
	DECLARE @tmpReason NVARCHAR(MAX)
	DECLARE @tmpRemarks NVARCHAR(MAX)
	DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
	-- Create tmp predict table to store calculated predicted data
	IF object_id('tempdb.dbo.#PredictionData') is not null DROP TABLE #PredictionData
	CREATE TABLE #PredictionData (
		CommServUniqueId INT,
		EntityId INT,
		EntityName NVARCHAR(max),
		DaysToBeFull BIGINT
	)
	IF @i_ParamId = 17
	BEGIN
		DECLARE @slaPercent FLOAT = -1
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 27
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 27
		SELECT	@slaPercent = CASE
				WHEN (sub.NotProtectedClients+sub.ProtectedClients)>0
				THEN sub.ProtectedClients*100.0/(sub.NotProtectedClients+sub.ProtectedClients)
				ELSE -1 END
		FROM	(SELECT TOP 1
						csInfo.ProtectedClients,
						csInfo.NotProtectedClients
				FROM	cf_SurveySLASummary AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 27 AND (csInfo.Days = 30 OR csInfo.Days < 0)
				) AS sub
		IF @slaPercent < 0
		BEGIN
			SELECT	@slaPercent = CASE
					WHEN (NotProtectedClients+ProtectedClients)>0
					THEN ProtectedClients*100.0/(NotProtectedClients+ProtectedClients)
					ELSE -1 END
		FROM	cf_CommcellSummary WITH (NOLOCK)
		WHERE	SurveyResultId IN (
				SELECT CommservSurveyResults_ID FROM cf_CommservSurveyResults WITH (NOLOCK)
				WHERE QueryId = 146 and CommcellIdNameMap_ID = @i_CommServUniqueId AND Flags = 1)
		END
	  IF @slaPercent < 0
	  BEGIN
	  		SET @tmpStatus = 'Info'
			INSERT INTO #resultTbl(Result) VALUES ('No data available')
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'No data available'
			UPDATE #resultTbl SET Reason = 'No data available'
	  END
	  ELSE
	  BEGIN
		SET @slaPercent = CAST (@slaPercent AS INT)
		if (@slaPercent < @criticalThreshold)
			SET @tmpStatus = 'Critical'
		else if (@slaPercent <= @warningThreshold)
			SET @tmpStatus = 'Warning'
		else
			SET @tmpStatus = 'Good'
		IF @i_status = ''
		BEGIN
			IF ((@i_operator = 0 AND @slaPercent < @i_ParamValue) OR
						(@i_operator = 1 AND @slaPercent > @i_ParamValue) OR
						(@i_operator = 2 AND @slaPercent = @i_ParamValue) OR
						(@i_operator = 8 AND @slaPercent <> @i_ParamValue) )
			BEGIN
				INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
				UPDATE	#resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> has reached <b>' + Result + '</b>'
				UPDATE #resultTbl SET Reason = 'SLA is ' + CAST(@slaPercent AS NVARCHAR(32))+'%'
			END
		END
		ELSE
		BEGIN
			IF (@i_status = 'Critical' AND @slaPercent < @criticalThreshold)
			BEGIN
				INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
			END
			ELSE IF (@i_status = 'Warning' AND @slaPercent < @warningThreshold)
			BEGIN
				INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
			END
			ELSE IF (@i_status = 'Good')
			BEGIN
				INSERT INTO #resultTbl(Result) VALUES (CAST(@slaPercent AS NVARCHAR(32))+'%')
			END
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> is at <b>'+ @tmpStatus +'</b> status.'
			UPDATE #resultTbl SET Reason = 'SLA is ' + CAST(@slaPercent AS NVARCHAR(32))+'%'
		END
	  END
		UPDATE	#resultTbl
		SET		Remarks = (CASE WHEN @tmpStatus = 'Critical' THEN 'Look at the failing clients'
								WHEN @tmpStatus = 'Warning'  THEN 'Look at the failing clients'
								ELSE 'Meets SLA' END) + '<br><br>' +
								'For suggestions on how to improve SLA, visit documentation: <a class="hc-cell-a" href="http://documentation.commvault.com/commvault/v11/article?p=features/reports/metrics/health_check_settings.htm#improving_sla">How to Improve SLA?</a>'
		--SET		Remarks = (CASE WHEN @slaPercent < P.CriticalThreshold THEN P.CriticalMessage WHEN @slaPercent < P.WarningThreshold THEN P.WarningMessage ELSE P.GoodMessage END)
		--FROM	#resultTbl S, cf_SurveyHealthParam P
		--WHERE	P.QueryId = 27
	END
	ELSE IF @i_ParamId = 1
	BEGIN
				DECLARE @warningSPForCS INT = 5, @criticalSPForCS INT = 6
				--CommServer  :      Compared with currently available Feature Release for customers
				--1. good	:	Current OR (Last 5 non-LTS)
				--3. critical	:	(6 or more non-LTS SP older)
				DECLARE @warningLTSForCS INT = 8, @criticalLTSForCS INT = 16
				--CommServer  :      Compared with currently available LTS Feature Release for customers
				--1. good	:	Current OR (Last 2 LTS)
				--2. warning	:      (Last 3rd-4th LTS)
				--3. critical	:	(older than last 4 LTS)
				DECLARE @warningMRForCS INT = 13, @criticalMRForCS INT = 20
				--CommServer  :      Compared with currently available Maintenance Release for customers
				--1. good	:	Current OR (Last 12 Maintenance Releases)
				--2. warning	:      (Last 13-20 Maintenance Releases)
				--3. critical	:	(older than last 20 Maintenance Releases)
				DECLARE @warningSPForMA INT = 2, @criticalSPForMA INT = 3
				--Media Agent :      Compared with Feature Release of CommServer
				--1. good     :      Current OR (Last 2 non-LTS) with a grace period of 30 days
				--2. warning  :      (Last 2 non-LTS) with a grace period within 30 days - 60 days
				--3. critical :      (more than 2 non-LTS SP older) or more than 60 days of CommServer upgrade
				DECLARE @warningLTSForMA INT = 8, @criticalLTSForMA INT = 16
				--Media Agent :      Compared with LTS Feature Release of CommServer
				--1. good     :      Current OR (Last 2 LTS) with a grace period of 30 days
				--2. warning  :      (Last 2 LTS) with a grace period within 30 days - 60 days
				--3. critical :      (more than 2 LTS SP older) or more than 60 days of CommServer upgrade
				DECLARE @warningMRForMA INT = 6, @criticalMRForMA INT = 10
				--MediaAgent  :      Compared with Maintenance Release of CommServer
				--1. good     :      Current OR (Last 5 Maintenance Releases) with grace period of 30 days
				--2. warning  :      (Last 6-10 Maintenance Releases) with grace period within 30 - 60 days
				--3. critical :      (older than last 10 Maintenance Releases) with grace period ovre 60 days
				DECLARE @warningSPForServers INT = 2, @criticalSPForServers INT = 4
				--Servers     :      Compared with Feature Release of CommServer
				--1. good     :      Current OR (Last 2 non-LTS) with a grace period of 60 days
				--2. warning  :      (Last 2-4 non-LTS) with a grace period within 60 - 120 days
				--3. critical :      (more than 4 non-LTS SP older) or more than 120 days of CommServer upgrade
				DECLARE @warningLTSForServers INT = 8, @criticalLTSForServers INT = 8
				--Servers     :      Compared with LTS Feature Release of CommServer
				--1. good     :      Current OR (Last 2 LTS) with a grace period of 60 days
				--2. warning  :      (Last 2 LTS) with a grace period within 60 days - 120 days
				--3. critical :      (more than 2 LTS SP older) or more than 120 days of CommServer upgrade
				DECLARE @warningMRForServer INT = 24
				--Servers     :      Compared with Maintenance Release of CommServer
				--1. good     :      Current OR (Last 10 Maintenance Releases) with grace period of 60 days
				--2. warning  :      (Last 24 Maintenance Releases) with grace period more than 60 days
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 12
		IF object_id('tempdb.dbo.#CSVersionData') is not null DROP TABLE #CSVersionData
		CREATE TABLE #CSVersionData(CCUID INT, CSVersion VARCHAR(128), ReleaseNo INT, SPMajorNo INT, LatestSP INT, CSNeedUpdate INT DEFAULT 0, ServerNeedUpdate INT DEFAULT 0, LaptopNeedUpdate INT DEFAULT 0, MANeedUpdate INT DEFAULT 0, TotalClientNeedsUpdate INT DEFAULT 0, DeprecatedOS INT DEFAULT 0, MaintenancePack INT DEFAULT 0, FRUpgradeDays INT DEFAULT -1, MRUpgradeDays INT DEFAULT -1)
		INSERT INTO #CSVersionData(CCUID, CSVersion, ReleaseNo, SPMajorNo, MaintenancePack, LatestSP)
			SELECT
				@i_CommServUniqueId,
				C.CommServVersion, --Version String
				R.Release,
				R.ServicePack,
				R.MaintenanceRelease,
				CASE
					WHEN R.Release = 9 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '9_0_LatestSPMajorNo')
					WHEN R.Release = 10 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '10_0_LatestSPMajorNo')
					WHEN R.Release = 11 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '11_0_LatestSPMajorNo')
				END
			FROM cf_CommcellIdNameMap C
				CROSS APPLY dbo.SplitVersionString(C.CommServVersion) R
			WHERE C.ID = @i_CommServUniqueId
		UPDATE CSV
		SET FRUpgradeDays = Sub.FRUPDays
		FROM #CSVersionData CSV
		INNER JOIN (SELECT CCUID, ISNULL(DATEDIFF(Day, CAST(MIN(His.InstallTime) AS DATE), getdate()),-1) AS FRUPDays
					from #CSVersionData CSV
					INNER JOIN cf_SurveyResultFuncV1(38, 0, 1, null, null, @i_UserId, -1) Res ON Res.SurverResultId > 0 AND CSV.CCUID = Res.CommServUniqueId
					INNER JOIN cf_SurveyServicePackUpgradeHistory His WITH (NOLOCK) ON His.SurveyResultId = Res.SurverResultId
					WHERE His.Version = CSV.ReleaseNo AND His.servicePack = CSV.SPMajorNo GROUP BY CCUID) Sub ON Sub.CCUID = CSV.CCUID
		UPDATE CSV
		SET MRUpgradeDays = Sub.MRUPDays
		FROM #CSVersionData CSV
		INNER JOIN (SELECT CCUID, ISNULL(DATEDIFF(Day, CAST(MAX(His.InstallTime) AS DATE), getdate()),-1) AS MRUPDays
		      		from #CSVersionData CSV
					INNER JOIN cf_SurveyResultFuncV1(38, 0, 1, null, null, @i_UserId, -1) Res ON Res.SurverResultId > 0 AND CSV.CCUID = Res.CommServUniqueId
					INNER JOIN cf_SurveyServicePackUpgradeHistory His WITH (NOLOCK) ON His.SurveyResultId = Res.SurverResultId
					WHERE His.Version = CSV.ReleaseNo AND His.servicePack = CSV.SPMajorNo AND His.MaintenancePack = CSV.MaintenancePack GROUP BY CCUID) Sub ON Sub.CCUID = CSV.CCUID
		IF EXISTS(SELECT * FROM #CSVersionData CSV WHERE CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5)) --V11 SP5 and below
		BEGIN
			UPDATE CSV
			SET
				CSV.CSNeedUpdate = CASE WHEN csInfo.ClientTypeId = 0 THEN csInfo.Total ELSE 0 END,
				CSV.ServerNeedUpdate = CASE WHEN csInfo.ClientTypeId = 1 THEN csInfo.Total ELSE 0 END,
				CSV.LaptopNeedUpdate = CASE WHEN csInfo.ClientTypeId = 2 THEN csInfo.Total ELSE 0 END,
				CSV.MANeedUpdate = CASE WHEN csInfo.ClientTypeId = 4 THEN csInfo.Total ELSE 0 END
			FROM @TblLatestResult result
				INNER JOIN cf_SurveyUpdateStatus AS csInfo
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryId = 12
				INNER JOIN #CSVersionData CSV
					ON CSV.CCUID = @i_CommServUniqueId
			WHERE CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5) --V11 SP5 and below
			UPDATE CSV SET TotalClientNeedsUpdate = CSNeedUpdate + ServerNeedUpdate + LaptopNeedUpdate + MANeedUpdate
			FROM #CSVersionData CSV
			WHERE CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5) --V11 SP5 and below
			--Get final health status
			SELECT @tmpStatus =
			CASE
				WHEN (CSV.LatestSP - CSV.SPMajorNo) >= @criticalSPForCS or CSV.TotalClientNeedsUpdate > 0 THEN 'Critical'
				WHEN (CSV.LatestSP - CSV.SPMajorNo) >= @warningSPForCS AND (CSV.LatestSP - CSV.SPMajorNo) < @criticalSPForCS THEN 'Warning'
				ELSE 'Good'
			END
			FROM #CSVersionData CSV
			WHERE CSV.CCUID = @i_CommServUniqueId AND CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5) --V11 SP5 and below
			--Get final health recommendation
			SELECT @tmpRemarks = CASE
				WHEN @tmpStatus = 'Critical' THEN @criticalMessage
				WHEN @tmpStatus = 'Warning' THEN @warningMessage
				ELSE @goodMessage
			END
		END
		ELSE --V11 SP6 and above
		BEGIN
			IF object_id('tempdb.dbo.#VersionAndServicePackTable') is not null DROP TABLE #VersionAndServicePackTable
			CREATE TABLE #VersionAndServicePackTable (CCUID INT, ClientId INT, CType INT, VersionInt INT, ServicePack INT, LatestServicePack INT, UPNumber INT, LatestUPNumber INT, IsMissingUpdates INT, StatusInt INT DEFAULT 2, IsLTS INT DEFAULT 0, IsDeprecatedOS INT DEFAULT 0)
			INSERT INTO #VersionAndServicePackTable(CCUID, ClientId, CType, VersionInt, ServicePack, LatestServicePack, UPNumber, LatestUPNumber, IsMissingUpdates, IsLTS, IsDeprecatedOS)
			SELECT CSV.CCUID, T.ClientId,
				CASE
					WHEN (C.type & 256)  = 256	THEN 1 --CS
					WHEN (C.type & (512|1024|2048|4096|8192)) > 0 THEN 5 --Infrastructure (512: Metrics Reporting, 1024: Web Server, 2048: Command Center, 4096: CommCell Console, 8192: WorkFlow Engine)
					WHEN (C.type & 2)    = 2	THEN 3 --MediaAgent
					WHEN (C.type & 1)    = 1	THEN 2 --Laptop
					ELSE 4 --Servers
				END,
				T.Version, T.ServicePack,
				(CASE
					WHEN T.Version = 11 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '11_0_LatestSPMajorNo' )
					WHEN T.Version = 10 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '10_0_LatestSPMajorNo' )
					WHEN T.Version = 9 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '9_0_LatestSPMajorNo' )
					ELSE 0
				END),
				ISNULL(T.UPNumber, 0),
				ISNULL(R.LatestAvailableUPNumber, 0),
				CASE WHEN LEN(T.MissingUpdates) > 0 THEN 1 ELSE 0 END,
				ISNULL(R.IsLTS, 0),
				CASE WHEN C.ExceptionType & 1024 = 1024 THEN 1 ELSE 0 END AS IsDeprecatedOS --Deprecated Operation System
			FROM #CSVersionData CSV
			INNER JOIN cf_SurveyVersionAndServicePack T
				ON CSV.CCUID = T.CommServUniqueId
				AND CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
			INNER JOIN cf_SurveyClient C
				ON C.CommServUniqueId = T.CommServUniqueId
				AND C.ClientId = T.ClientId
				AND C.CommServUniqueId = CSV.CCUID
			LEFT OUTER JOIN cf_ReleaseUpdatePackInfo R
				ON (R.ReleaseId - 5) = T.Version
				AND R.ServicePack = T.ServicePack
			WHERE C.UninstallTime IS NULL AND C.Deleted=0 AND C.InstallStatus = 0
			--Delete all VM discovered clients which are not to be considered for this report
			DELETE T
			FROM #VersionAndServicePackTable T
				INNER JOIN cf_surveyclient C WITH (NOLOCK)
					ON T.CCUID = C.CommServUniqueId
					AND C.ClientId = T.ClientId
					AND C.type & 1 <> 1  --laptop bit is not set
					AND C.type & 4 = 4 --No pacakges bit is set
					AND C.type & 8 = 8 --VM discovered bit is set
			--CS
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < 11)
					THEN 4 --Critical: CommServ below Version 11 is not supported
				WHEN (IsLTS = 0 AND (LatestServicePack - A.ServicePack) >= @criticalSPForCS)
					OR (IsLTS = 1 AND (LatestServicePack - A.ServicePack) >= @criticalLTSForCS)
					THEN 4	--Critical: CommServ Feature Release is more than critical threshold
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - UPNumber >= @criticalMRForCS))
					THEN 4	--Critical: CommServ Maintenance Release is more than critical threshold for CS greater than V11 Sp14
				WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0)
					THEN 4	--Critical: For CommServ below V11 Sp14 if IsMissingUpdates set then it is considered critical
				WHEN (IsLTS = 0 AND (LatestServicePack - A.ServicePack) >= @warningSPForCS)
					OR (IsLTS = 1 AND (LatestServicePack - A.ServicePack) >= @warningLTSForCS)
					THEN 3  --Warning: CommServ Feature Release greater than the warning threshold
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - UPNumber >= @warningMRForCS))
					THEN 3	--Warning: CommServ Maintenance Release is more than warning threshold for CS greater than V11 Sp14
				ELSE 2  --All good
			END)
			FROM #CSVersionData CSV
			INNER JOIN #VersionAndServicePackTable A
				ON CSV.CCUID = A.CCUID
			WHERE CType = 1
			--Infrastructure
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < CSV.ReleaseNo)
					THEN 4 --Critical: Infrastructure Client Version less than CommServ Version
				WHEN CSV.SPMajorNo > A.ServicePack
					THEN 4	--Critical: Infrastructure Client Feature Release not same as Commserv Feature Release
				WHEN ((VersionInt = 11 AND A.ServicePack >= 14 AND CSV.MaintenancePack - UPNumber > @warningMRForServer) OR ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0))
              		THEN 4 --Critical: Infrastructure Client for greater than V11 Sp14 exceeding the warning threshold and less than V11 SP14 having the is missing updates
				WHEN CSV.MRUpgradeDays > 30 AND CSV.MaintenancePack != UPNumber
					THEN 4 --Critical: CommServ Maintenance Release upgraded 60 days earlier and still Infrastructure client Maintenance Release is not in sync with CommServ
				ELSE 2  --All good
			END)
			FROM #CSVersionData CSV
			INNER JOIN #VersionAndServicePackTable A
				ON CSV.CCUID = A.CCUID
			WHERE CType = 5 AND IsDeprecatedOS = 0
			--Servers and Laptops
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < CSV.ReleaseNo)
					THEN 4 --Release is not supported. Critical
				WHEN (IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalSPForServers)
					OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalLTSForServers)
					THEN 4	--Critical : Server Feature Release is more than the critical thresholds
				WHEN CSV.FRUpgradeDays > 120 AND (CSV.SPMajorNo != A.ServicePack)
					THEN 4	--Critical : Feature Release on CommServ is upgraded 120 days before but Server is still not in sync with the CommServ
				WHEN ((IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @warningSPForServers)
					OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @warningLTSForServers)) AND CSV.FRUpgradeDays > 60 AND CSV.FRUpgradeDays <= 120
					THEN 3	--Warning : CommServ Feature Release upgraded in last 60 to 120 days and still Server Feature Release greater than the warning threshold but not same as CommServ
				WHEN (CSV.FRUpgradeDays > 60 AND CSV.FRUpgradeDays <= 120) AND (CSV.SPMajorNo != A.ServicePack)
					THEN 3 --Warning : CommServ Feature Release upgraded in last 60 to 120 days and still Server Feature Release is not in sync with CommServ
				WHEN ((VersionInt = 11 AND A.ServicePack >= 14 AND CSV.MaintenancePack - UPNumber >= @warningMRForServer) OR ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0))
					THEN 3 --Warning : For Server greater than V11 SP14 Maintenance Release is greater than warning threshold. For Server less than V11 SP14 we consider warning if the IsMissingUpdates is set.
				WHEN CSV.MRUpgradeDays > 60 AND (CSV.MaintenancePack != UPNumber)
					THEN 3 --Warning : Commserv Maintenance Release is not in sync with the Server even after the 60 days of CommServ Maintenance Release upgraded
				ELSE 2  --All good
			END)
			FROM #CSVersionData CSV
			INNER JOIN #VersionAndServicePackTable A
				ON CSV.CCUID = A.CCUID
			WHERE (CType = 4 OR CType = 2) AND IsDeprecatedOS = 0
			--MA
			UPDATE A SET
			StatusInt =
			(CASE
				WHEN (VersionInt < CSV.ReleaseNo)
					THEN 4 --Critical: Media Agent Version is less than the Commserv Version
				WHEN (IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalSPForMA)
					OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalLTSForMA)
					THEN 4	--Critical: Media Agent Feature Release is more than the critical thresholds
				WHEN CSV.FRUpgradeDays > 60 AND (CSV.SPMajorNo != A.ServicePack)
					THEN 4	--Critical: Feature Release on CommServ is upgraded 60 days before but Media Agent is still not in sync with the CommServ
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (CSV.MaintenancePack - UPNumber >= @criticalMRForMA))
					THEN 4	--Critical : Media Agent Maintenance Release is more than critical threshold for CS greater than V11 Sp14
				WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0)
					THEN 4	--Critical : For Media Agent below V11 Sp14 if IsMissingUpdates set then it is considered critical
				WHEN CSV.MRUpgradeDays > 60 AND (CSV.MaintenancePack != UPNumber)
					THEN 4 --Critical : CommServ Feature Release upgraded 60 days earlier and still Media Agent Feature Release is not in sync with CommServ
				WHEN ((IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) <= @warningSPForMA)
					OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) <= @warningLTSForMA)) AND CSV.FRUpgradeDays > 30 AND CSV.FRUpgradeDays <= 60
					THEN 3	--Warning : CommServ Feature Release upgraded in last 30 to 60 days and still Media Agent Feature Release less than the warning threshold but not same as CommServ
				WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (CSV.MaintenancePack - UPNumber) >= @warningMRForMA)
					THEN 3  --Warning : Media Agent Maintenance Release is more than warning threshold for CS greater than V11 Sp14
				WHEN (CSV.FRUpgradeDays > 30 AND CSV.FRUpgradeDays <= 60) AND (CSV.SPMajorNo != A.ServicePack)
					THEN 3	--Warning : CommServ Feature Release upgraded in last 30 to 60 days and still Media Agent Feature Release is not in sync with CommServ
				ELSE 2 --All good
			END)
			FROM #CSVersionData CSV
			INNER JOIN #VersionAndServicePackTable A
				ON CSV.CCUID = A.CCUID
			WHERE CType = 3 AND IsDeprecatedOS = 0
			--Make the laptops which are offline for 7 days as info
			DECLARE @LastCollectionTime DATETIME = NULL
			SET @LastCollectionTime = (select ISNULL(ModifiedTime,getutcdate()-7) from cf_CommCellIdNameMap WITH (NOLOCK) WHERE ID = @i_CommServUniqueId)
			DECLARE @OfflineThreshold DATETIME = (SELECT DATEADD(DAY,-7,@LastCollectionTime))
			UPDATE A SET
			StatusInt = 1
			FROM #VersionAndServicePackTable A
			INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON A.CCUID = C.CommservUniqueId AND A.ClientId = C.ClientId
			WHERE CType = 2 AND StatusInt>2 AND IsDeprecatedOS = 0 AND ((C.LastOfflineTime > C.LastOnlineTime AND C.LastOfflineTime <= @OfflineThreshold)
				OR (C.LastOfflineTime is NOT NULL AND C.LastOnlineTime is NULL AND C.LastOfflineTime <= @OfflineThreshold))
			UPDATE CSV SET
				CSV.CSNeedUpdate = sub.CSNeedUpdate,
				CSV.LaptopNeedUpdate = sub.LaptopNeedUpdate,
				CSV.MANeedUpdate = sub.MANeedUpdate,
				CSV.ServerNeedUpdate = sub.ServerNeedUpdate
			FROM #CSVersionData CSV
				INNER JOIN
				(SELECT
					V.CCUID,
					SUM(CASE WHEN CType = 1 THEN 1 ELSE 0 END) AS CSNeedUpdate,
					SUM(CASE WHEN CType = 2 THEN 1 ELSE 0 END) AS LaptopNeedUpdate,
					SUM(CASE WHEN CType = 3 THEN 1 ELSE 0 END) AS MANeedUpdate,
					SUM(CASE WHEN CType in (4, 5) THEN 1 ELSE 0 END) AS ServerNeedUpdate
				FROM #VersionAndServicePackTable V
				WHERE V.StatusInt IN (3, 4)
				GROUP BY V.CCUID) sub
					ON CSV.CCUID = sub.CCUID
			UPDATE CSV SET DeprecatedOS = sub.DeprecatedOS
			FROM #CSVersionData CSV
				INNER JOIN (SELECT V.CCUID, COUNT(*) AS DeprecatedOS  FROM #VersionAndServicePackTable V WHERE V.IsDeprecatedOS = 1 GROUP BY V.CCUID) sub
					ON CSV.CCUID = sub.CCUID
			UPDATE CSV SET TotalClientNeedsUpdate = CSNeedUpdate + ServerNeedUpdate + LaptopNeedUpdate + MANeedUpdate
			FROM #CSVersionData CSV
			WHERE CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
			--Get final health status
			SELECT @tmpStatus = CASE sub.HealthStatus WHEN 4 THEN 'Critical' WHEN 3 THEN 'Warning' ELSE 'Good' END
			FROM #CSVersionData CSV
				INNER JOIN
					(SELECT
						V.CCUID,
						MAX(StatusInt) AS HealthStatus
					FROM #VersionAndServicePackTable V
					GROUP BY V.CCUID) sub
						ON CSV.CCUID = sub.CCUID
						AND CSV.CCUID = @i_CommServUniqueId
			WHERE CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
			--Get final health recommendation
			SELECT @tmpRemarks = CASE WHEN @tmpStatus IN ('Critical', 'Warning') THEN 'Install latest available feature release/maintenance release.<BR/>' ELSE @goodMessage END
			IF object_id('tempdb.dbo.#VersionAndServicePackTable') is not null DROP TABLE #VersionAndServicePackTable
		END
		DECLARE @CSVersionToRpt VARCHAR(128)
		DECLARE @CSNeedUpdate INT = 0, @ServerNeedUpdate INT = 0, @LaptopNeedUpdate INT = 0, @MANeedUpdate INT = 0, @TotalClientNeedsUpdate INT = 0, @DeprecatedOS INT = 0
		DECLARE @SPMajorNo INT, @LatestSP INT
		SELECT
			@CSNeedUpdate = CSNeedUpdate,
			@ServerNeedUpdate = ServerNeedUpdate,
			@LaptopNeedUpdate = LaptopNeedUpdate,
			@MANeedUpdate = MANeedUpdate,
			@TotalClientNeedsUpdate = TotalClientNeedsUpdate,
			@CSVersionToRpt = CSVersion,
			@SPMajorNo = SPMajorNo,
			@LatestSP = LatestSP,
			@DeprecatedOS = DeprecatedOS
		FROM #CSVersionData
		SELECT @tmpReason = 'CommServe is on <b>version ' + @CSVersionToRpt + '</b><BR/>'
		IF (@i_status <> '')
		BEGIN
			IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@CSVersionToRpt)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = @i_ParamName + ' of <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status.'
				IF (@TotalClientNeedsUpdate > 0)
				BEGIN
					SET	@tmpReason += 'Entities that need updates: '
					IF (@CSNeedUpdate > 0)
						SET	@tmpReason += 'CommServe, '
					SET	@tmpReason += 'Servers <b>' + CAST(@ServerNeedUpdate AS VARCHAR(10)) + '</b>, '
					SET	@tmpReason += 'Laptops <b>' + CAST(@LaptopNeedUpdate AS VARCHAR(10)) + '</b>, '
					SET	@tmpReason += 'MediaAgents <b>' + CAST(@MANeedUpdate AS VARCHAR(10)) + '</b>'
					SET @tmpReason += CASE WHEN @DeprecatedOS>0 THEN '<BR/>Servers with deprecated Operating System: <b>' + CAST(ISNULL(@DeprecatedOS, 0) AS VARCHAR(10)) + '</b><BR/>' ELSE '' END
				END
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE
		BEGIN
			IF ((@LatestSP - @SPMajorNo) >= @i_ParamValue)
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES(@CSVersionToRpt)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'Installed Feature Release of CommCell <b>' + CommServeName + '</b> is lagging by <b>'+ CAST((@LatestSP - @SPMajorNo) AS NVARCHAR(64)) +'</b> Feature Releases.'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF object_id('tempdb.dbo.#CSVersionData') IS NOT null DROP TABLE  #CSVersionData
	END
	ELSE IF @i_ParamId = 19
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 31
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 31
		IF object_id('tempdb.dbo.#CCDRDetails') is not null DROP TABLE #CCDRDetails
		create table #CCDRDetails(
			ccuid int,
			LogDate datetime,
			FullJobsToRetain int default  NULL,
			ISUNC NVARCHAR(20) default NULL,
			UseCommvaultCloud INT default NULL,
			UseThirdpartyCloud INT default NULL,
			CloudDeviceTypeId INT default NULL,
			LastDRBkpTime int default 0,
			LastFailedDRBkpTime int default 0,
			LastCweDRBkpTime int default 0,
			LastDRCollTime datetime default null,
			Status varchar(20) default null,
			Recommendation varchar(max),
			Result varchar(max))
		INSERT INTO #CCDRDetails
			(ccuid,
			LogDate,
			FullJobsToRetain,
			ISUNC,
			UseCommvaultCloud,
			UseThirdpartyCloud,
			CloudDeviceTypeId,
			LastDRBkpTime,
			LastFailedDRBkpTime,
			LastCweDRBkpTime,
			LastDRCollTime)
		SELECT
			csInfo.CommServUniqueId,
			CONVERT(VARCHAR(20), MAX(csInfo.LogDateUTC), 100),
			MAX(csInfo.FullJobsToRetain),
			MAX(csInfo.IsUingNetworkPath),
			MAX(ISNULL(csInfo.UseCommvaultCloud, 0)),
			MAX(ISNULL(csInfo.UseThirdpartyCloud, 0)),
			MAX(ISNULL(csInfo.CloudDeviceTypeId, 0)),
			MAX(sub.LastSuccessfulDRTime),
			MAX(sub.LastFailedDRTime) ,
			MAX(ISNULL(sub.LastCweDRTime, 0)),
			MAX(csInfo.LogDate)
		FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = 31
			INNER JOIN (
				SELECT R.CommServUniqueId, csInfo1.LastSuccessfulDRTime, csInfo1.LastFailedDRTime, csInfo1.LastCweDRTime
				FROM cf_SurveyResultFuncV1(19, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, -1) R
					INNER JOIN cf_SurveyDRStats AS csInfo1 WITH (NOLOCK)
						ON csInfo1.SurveyResultId = R.SurverResultId
			)sub
				ON sub.CommServUniqueId = csInfo.CommServUniqueId
		GROUP BY csInfo.CommServUniqueId
		update DR set
			Status = 'Critical',
			Recommendation = @criticalMessage
		from #CCDRDetails DR
		WHERE (ISUNC = 'false' AND UseCommvaultCloud = 0 AND UseThirdpartyCloud = 0)
			OR FullJobsToRetain = 0 OR ISNULL(LastDRBkpTime, 0) = 0
			OR DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) > @criticalThreshold
			OR LastFailedDRBkpTime > LastDRBkpTime
		update DR set
			Status = 'Warning',
			Recommendation = @warningMessage
		from #CCDRDetails DR
		WHERE (FullJobsToRetain = 1) OR DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) = @warningThreshold
			AND ISNULL(Status, '') = ''
		update DR set
			Status = 'Good',
			Recommendation = @goodMessage
		from #CCDRDetails DR
		WHERE (ISUNC = 'true' OR UseCommvaultCloud = 1 OR UseThirdpartyCloud = 1) AND FullJobsToRetain >= 2 AND DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) < @warningThreshold
			AND ISNULL(Status, '') = ''
		IF EXISTS(SELECT * FROM #CCDRDetails WHERE Status = 'Critical')
		BEGIN
			SET @tmpStatus = 'Critical'
			SET @tmpRemarks = @criticalMessage
		END
		ELSE IF EXISTS(SELECT * FROM #CCDRDetails WHERE Status = 'Warning')
		BEGIN
			SET @tmpStatus = 'Warning'
			SET @tmpRemarks = @warningMessage
		END
		ELSE IF EXISTS(SELECT * FROM #CCDRDetails WHERE Status = 'Good')
		BEGIN
			SET @tmpStatus = 'Good'
			SET @tmpRemarks = @goodMessage
		END
		update #CCDRDetails
		SET Result =
		CASE
			WHEN ISNULL(LastDRBkpTime, 0) = 0 THEN 'There is no successful DR job so far.<BR/>'
			WHEN LastFailedDRBkpTime > LastDRBkpTime AND LastFailedDRBkpTime > LastCweDRBkpTime THEN 'DR Backup job failed on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, LastFailedDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<BR/>'
			WHEN LastCweDRBkpTime > LastDRBkpTime THEN 'DR Backup job completed with errors on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, LastCweDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<BR/>'
			ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<BR/>'
		END
		update #CCDRDetails SET Result = Result + 'DR Backup destinations [<b>'
		update #CCDRDetails SET
			Result = Result
				+ CASE WHEN (UseCommvaultCloud = 1 OR UseThirdpartyCloud = 1) THEN 'Cloud and ' ELSE '' END
				+ CASE WHEN ISUNC = 'true' THEN 'UNC path' ELSE 'local path' END
		update #CCDRDetails SET Result = Result + '</b>].<BR/>'
		update #CCDRDetails
		SET Result = Result + 'It is currently configured to retain <b>' + CAST(FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<BR/>'
		SELECT @tmpReason = Result FROM #CCDRDetails WHERE ccuid = @i_CommServUniqueId
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
			(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
			(@i_status = 'Good' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical' OR @tmpStatus = 'Good')))
		BEGIN
			INSERT INTO #resultTbl (Result, CommServeName, Reason, Remarks)
			SELECT	@i_ParamName + ' for CommCell <b>' + CommServName + '</b> is at <b>' + @tmpStatus + '</b> status.', CommServName, @tmpReason, @tmpRemarks
			FROM	cf_CommCellIdNameMap
			WHERE	ID = @i_CommServUniqueId
		END
		IF object_id('tempdb.dbo.#CCDRDetails') is not null DROP TABLE #CCDRDetails
	END
	ELSE IF @i_ParamId = 8
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 19
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 19
		DECLARE @daysSinceLastDR INT
		DECLARE @lastSuccessfulDRTime INT
		SELECT 	@tmpStatus =
							CASE
								WHEN DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) > @criticalThreshold THEN 'Critical'
								WHEN DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) > @warningThreshold THEN 'Warning'
								ELSE 'Good'
							END,
						@tmpReason =
						CASE
							WHEN ISNULL(csInfo.LastSuccessfulDRTime, 0) = 0 THEN 'There is no successful DR job so far.'
							ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), 107) + '</b>.'
						END,
						@tmpRemarks =
							CASE
								WHEN ISNULL(csInfo.LastSuccessfulDRTime, 0) = 0
									THEN 'There is no successful DR job so far. ' + @criticalMessage
								WHEN DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) > @criticalThreshold
									THEN 'There is no successful DR in last <b>' + CAST(DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) AS VARCHAR(10)) + '</b> days. ' + @criticalMessage
								WHEN DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) > @warningThreshold
									THEN 'There is no successful DR in last <b>' + CAST(DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC) AS VARCHAR(10)) + '</b> days. ' + @warningMessage
								ELSE @goodMessage
							END,
						@daysSinceLastDR = DATEDIFF(DAY, DATEADD(second, csInfo.LastSuccessfulDRTime, {d '1970-01-01'}), csInfo.LogDateUTC),
						@lastSuccessfulDRTime = ISNULL(csInfo.LastSuccessfulDRTime, 0)
				FROM	cf_SurveyDRStats AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 19
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
			(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
			(@i_status = 'Good' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical' OR @tmpStatus = 'Good')))
		BEGIN
			INSERT INTO #resultTbl (Result, CommServeName, Reason, Remarks)
			SELECT	'DR Backup Statistics of CommCell <b>' + CommServName + '</b> is at <b>' + @tmpStatus + '</b> status', CommServName, @tmpReason, @tmpRemarks
			FROM	cf_CommCellIdNameMap
			WHERE	ID = @i_CommServUniqueId
			--UPDATE #resultTbl SET Reason = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> has reached <b>'+ @tmpStatus +'</b> status.<br/>' + Reason
		END
		ELSE IF ( @i_status = '' AND ((@i_Operator = 0 AND @daysSinceLastDR < @i_paramValue) OR
										(@i_Operator = 1 AND @daysSinceLastDR > @i_paramValue) OR
										(@i_Operator = 2 AND @daysSinceLastDR = @i_paramValue) OR
										(@i_operator = 8 AND @daysSinceLastDR <> @i_ParamValue)) OR @lastSuccessfulDRTime = 0)
		BEGIN
			IF @lastSuccessfulDRTime > 0
				SET @tmpStatus = 'There is no successful DR backup in last <b>' + CAST(@daysSinceLastDR AS NVARCHAR(16)) + '</b> days '
			ELSE
				SET @tmpStatus = 'There is no successful DR backup so far '
			INSERT INTO #resultTbl (Result, CommServeName, Reason, Remarks)
			SELECT @tmpStatus + 'for CommCell <b>' + CommServName + '</b>',
					CommServName, @tmpReason, @tmpRemarks
			FROM	cf_CommCellIdNameMap
			WHERE	ID = @i_CommServUniqueId
		END
	END
	ELSE IF @i_ParamId = 12
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 25
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 25
		IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
        CREATE TABLE #StrikeEntities (clientId INT, appId INT, isVM INT, strikeCount INT)
		INSERT INTO #StrikeEntities
		SELECT  csInfo.ClientId, csInfo.AppId, 0, MAX(csInfo.StrikeCounts)
		FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = 25
				AND csInfo.StrikeCounts > 0
 			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
				ON SA.CommServUniqueId = @i_CommServUniqueId AND csInfo.ClientId = SA.ClientId
				AND csInfo.AppId = SA.AppId AND SA.AppTypeId <> 106 AND SA.Deleted = 0
		GROUP BY csInfo.ClientId, csInfo.AppId
		INSERT INTO #StrikeEntities
		SELECT  csInfo.ClientId, csInfo.AppId, 1, MAX(csInfo.StrikeCounts)
		FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = 25
				AND csInfo.StrikeCounts > 0
 			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
				ON SA.CommServUniqueId = @i_CommServUniqueId
				AND csInfo.AppId = SA.AppId AND SA.AppTypeId = 106 AND SA.Deleted = 0
		GROUP BY csInfo.ClientId, csInfo.AppId
        DECLARE @scStrikes TABLE (strikeCount INT, scCount INT)
        DECLARE @clStrikes TABLE (strikeCount INT, clCount INT)
        DECLARE @vmStrikes TABLE (strikeCount INT, vmCount INT)
        INSERT INTO @scStrikes
		SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT appId)
		FROM	#StrikeEntities
		WHERE	isVM = 0
		GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
        INSERT INTO @clStrikes
		SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
		FROM	(
			SELECT	clientId, MAX(strikeCount) AS strikeCount
			FROM	#StrikeEntities
			WHERE	isVM = 0
			GROUP BY clientId
			) S
		GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
        INSERT INTO @vmStrikes
		SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
		FROM	#StrikeEntities
		WHERE	isVM = 1
		GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
		IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
		DECLARE @totalClients INT = 0
		DECLARE @totalClientsWithStrike INT = 0
		DECLARE @strikeClientsPercent FLOAT = 0
		SELECT	@totalClientsWithStrike = ISNULL((SELECT SUM(clCount) FROM @clStrikes), 0) + ISNULL((SELECT SUM(vmCount) FROM @vmStrikes), 0)
		SET @totalClients = (
			SELECT	ISNULL(TotalActiveClients,0)
			FROM	cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
					INNER JOIN cf_CommservSurveyResults G WITH (NOLOCK)
				 ON csInfo.SurveyResultId = G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID = @i_CommServUniqueId and G.Flags=1)
		DECLARE @strike3Count VARCHAR(MAX) = ''
		DECLARE @strike2Count VARCHAR(MAX) = ''
		DECLARE @strike1Count VARCHAR(MAX) = ''
		SELECT	@strike3Count = 'Strike 3 :'
					+ CASE WHEN sc3 > 0 THEN ' <b>' + CAST(sc3 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl3 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					+ CASE WHEN vm3 > 0 THEN ' <b>' + CAST(vm3 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END
		FROM	(SELECT	ISNULL((SELECT scCount FROM @scStrikes WHERE strikeCount = 3), 0) AS sc3,
						ISNULL((SELECT clCount FROM @clStrikes WHERE strikeCount = 3), 0) AS cl3,
						ISNULL((SELECT vmCount FROM @vmStrikes WHERE strikeCount = 3), 0) AS vm3) S
		SELECT	@strike2Count = 'Strike 2 :'
					+ CASE WHEN sc2 > 0 THEN ' <b>' + CAST(sc2 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl2 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					+ CASE WHEN vm2 > 0 THEN ' <b>' + CAST(vm2 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END
		FROM	(SELECT	ISNULL((SELECT scCount FROM @scStrikes WHERE strikeCount = 2), 0) AS sc2,
						ISNULL((SELECT clCount FROM @clStrikes WHERE strikeCount = 2), 0) AS cl2,
						ISNULL((SELECT vmCount FROM @vmStrikes WHERE strikeCount = 2), 0) AS vm2) S
		SELECT	@strike1Count = 'Strike 1 :'
					+ CASE WHEN sc1 > 0 THEN ' <b>' + CAST(sc1 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl1 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					+ CASE WHEN vm1 > 0 THEN ' <b>' + CAST(vm1 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END
		FROM	(SELECT	ISNULL((SELECT scCount FROM @scStrikes WHERE strikeCount = 1), 0) AS sc1,
						ISNULL((SELECT clCount FROM @clStrikes WHERE strikeCount = 1), 0) AS cl1,
						ISNULL((SELECT vmCount FROM @vmStrikes WHERE strikeCount = 1), 0) AS vm1) S
		IF @totalClientsWithStrike <> 0 AND @totalClients = 0
			SET @tmpStatus = 'Critical'
		ELSE IF @totalClients = 0 OR @totalClientsWithStrike = 0
			SET @tmpStatus	    = 'Good'
		ELSE IF ((@totalClientsWithStrike*100.0)/@totalClients) < @warningThreshold
			SET @tmpStatus	    = 'Good'
		ELSE IF ((@totalClientsWithStrike*100.0)/@totalClients) <= @criticalThreshold AND ((@totalClientsWithStrike*100.0)/@totalClients) >= @warningThreshold
			SET @tmpStatus = 'Warning'
		ELSE
			SET @tmpStatus = 'Critical'
		IF @totalClients = 0
			SET @strikeClientsPercent = 0
		ELSE
			SET @strikeClientsPercent = ((@totalClientsWithStrike*100.0)/@totalClients)
		IF @i_status = ''
		BEGIN
			IF ((@i_Operator = 0 AND @strikeClientsPercent < @i_paramValue) OR
				(@i_Operator = 1 AND @strikeClientsPercent > @i_paramValue) OR
				(@i_Operator = 2 AND @strikeClientsPercent = @i_paramValue) OR
				(@i_Operator = 8 AND @strikeClientsPercent <> @i_paramValue))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (CAST(CAST(@strikeClientsPercent AS DECIMAL(32,2)) AS NVARCHAR(32)) + '%')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'Percentage of clients having strike for the CommCell <b>' + CommServeName + '</b> is <b>' + CAST(CAST(@strikeClientsPercent AS DECIMAL(32,2)) AS NVARCHAR(32)) + '%</b>'
				if (@strikeClientsPercent <= 0)
				BEGIN
					UPDATE #resultTbl SET Reason = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.'
					UPDATE #resultTbl SET Remarks = 'Good'
				END
				ELSE
				BEGIN
					UPDATE #resultTbl SET Reason = @strike3Count + '<br/>' + @strike2Count + '<br/>' + @strike1Count
					UPDATE #resultTbl SET Remarks = 'Please look at the failing clients'
				END
			END
		END
		ELSE IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
			(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
			(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES ('Critical')
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			IF (@tmpStatus = 'Good')
			BEGIN
				UPDATE #resultTbl SET Reason = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.'
				UPDATE #resultTbl SET Remarks = 'Good'
			END
			ELSE
			BEGIN
				UPDATE #resultTbl SET Reason = @strike3Count + '<br/>' + @strike2Count + '<br/>' + @strike1Count
				UPDATE #resultTbl SET Remarks = 'Please look at the failing clients'
			END
			UPDATE #resultTbl SET Result = 'Client Strike Count of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
		END
	END
	ELSE IF @i_ParamId = 20
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 37
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 37
		DECLARE @totalCWEClients INT = 0
		DECLARE @totalCWEClientsPercent FLOAT = 0
		SET @totalClients = 0
		SET @tmpReason = 'There are no clients with Jobs completed with errors.'
		SET @tmpStatus = 'Good'
		SET @totalClients = (SELECT ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
							INNER JOIN cf_CommservSurveyResults G WITH (NOLOCK)
							ON csInfo.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1)
		SELECT	@tmpStatus = (CASE	WHEN @totalClients = 0 AND ISNULL(sub.ClientCount, 0) <> 0
										THEN 'Critical'
									WHEN @totalClients = 0 OR ISNULL(sub.ClientCount, 0) = 0
										THEN 'Good'
									WHEN ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) < @warningThreshold
										THEN 'Good'
									WHEN ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) <= @criticalThreshold AND ((ISNULL(sub.ClientCount, 0)*100)/@totalClients) >= @warningThreshold
										THEN 'Warning'
									ELSE 'Critical'
								END),
				@tmpReason = '<b>' + CAST(sub.ClientCount AS VARCHAR(10)) + '</b> client(s) with one or more jobs completed with error.',
				@totalCWEClients = ISNULL(sub.ClientCount, 0)
		FROM	(SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.ClientName) AS ClientCount
				FROM	cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 37
				GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
				) AS sub
		IF @totalClients = 0
			SET @totalCWEClientsPercent = 0
		ELSE
			SET @totalCWEClientsPercent = CAST(((@totalCWEClients*100.0)/@totalClients) AS DECIMAL(20,2))
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND @totalCWEClientsPercent < @i_paramValue) OR
				(@i_Operator = 1 AND @totalCWEClientsPercent > @i_paramValue) OR
				(@i_Operator = 2 AND @totalCWEClientsPercent = @i_paramValue) OR
				(@i_Operator = 8 AND @totalCWEClientsPercent <> @i_paramValue))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (CAST(@totalCWEClientsPercent AS NVARCHAR(32)) + '%')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'Total number of clients with jobs completing with errors for CommCell <b>' + CommServeName + '</b> is <b>' +
										CAST(@totalCWEClientsPercent AS NVARCHAR(32)) + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = CASE WHEN @tmpStatus = 'Good' THEN 'Good' ELSE 'Please look at the clients completing with errors' END
			END
		END
		ELSE IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Clients completing with errors in last 30 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = CASE WHEN @tmpStatus = 'Good' THEN 'Good' ELSE 'Please look at the clients completing with errors' END
		END
	END
	ELSE IF @i_ParamId = 9
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 20
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 20
		SET @tmpStatus = 'Good'
		SET @tmpReason = 'No subclient is without storage policy association.'
		SET @tmpRemarks = 'None.'
		SELECT 	@tmpStatus = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN 'Warning' ELSE 'Good' END,
				@tmpReason = CASE
					WHEN sub.ClientsWithoutSP > 0 THEN '<b>' +
						CAST(sub.SubclientCount AS NVARCHAR(100)) + '</b> Subclient(s) from <b>'
						+ CAST(sub.ClientsWithoutSP AS NVARCHAR(100)) + '</b> Client(s) ' +
						+ ' <b>(' + CAST(sub.ClientsWithoutSPPercent AS NVARCHAR(100)) + '%)</b> are not associated with Storage Policy.'
					ELSE 'All Subclients are associated with Storage Policy.' END,
				@tmpRemarks = CASE WHEN sub.ClientsWithoutSP > @warningThreshold THEN @warningMessage ELSE @goodMessage END
		FROM	(SELECT TOP 1
						csInfo.CommServUniqueId,
						csInfo.LogDate,
						csInfo.ClientGroups,
						csInfo.ClientsWithoutSP,
						csInfo.ClientsWithoutSPPercent,
						csInfo.TotalClients,
						COUNT(csInfo.Subclient) AS 'SubclientCount'
				FROM	cf_SurveyClientsWithoutSPInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 20
				GROUP BY csInfo.CommServUniqueId,
						csInfo.LogDate,
						csInfo.ClientGroups,
						csInfo.ClientsWithoutSP,
						csInfo.ClientsWithoutSPPercent,
						csInfo.TotalClients
				) AS sub
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
			(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
			(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Subclients without Storage Policy Association for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 7
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 18
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage FROM cf_SurveyHealthParam WHERE QueryId = 18
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = 'All Clients are at supported version.'
		SELECT 	@tmpStatus = CASE WHEN sub.ClientCount <= @warningThreshold THEN 'Good' ELSE 'Critical' END,
				@tmpReason = 'There are <b>' + CAST(sub.ClientCount AS NVARCHAR(100)) + '</b> older clients.',
				@tmpRemarks = CASE WHEN sub.ClientCount <= @warningThreshold THEN @goodMessage ELSE @criticalMessage END
		FROM	(SELECT csInfo.CommServUniqueId,
						csInfo.LogDate,
						COUNT(csInfo.ClientId) AS ClientCount
				FROM	cf_SurveyUnsupportedClientInfo AS csInfo WITH (NOLOCK)
						INNER JOIN @TblLatestResult AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 18
				GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
				) AS sub
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
		(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
		(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = '<b>' + @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 3
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 16
		SELECT @goodMessage = GoodMessage, @warningMessage = REPLACE(REPLACE(HP.WarningMessage, '#1', HP.WarningThreshold), '#2', HP.CriticalThreshold), @criticalMessage = REPLACE(HP.CriticalMessage, '#2', HP.CriticalThreshold), @infoMessage = InfoMessage FROM cf_SurveyHealthParam hp(NOLOCK) WHERE QueryId = 16
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @successRatePct FLOAT
		SELECT
			@tmpStatus =
				CASE
					WHEN sub.SuccessRatePercent >= @warningThreshold THEN 'Good'
					WHEN sub.SuccessRatePercent >= @criticalThreshold AND sub.SuccessRatePercent < @warningThreshold THEN 'Warning'
					WHEN sub.SuccessRatePercent < @criticalThreshold THEN 'Critical'
				END,
			@successRatePct = sub.SuccessRatePercent,
			@tmpReason = 'Success Rate : <b>' + CAST(sub.SuccessRatePercent AS NVARCHAR(MAX))
				+ ' %</b><br/>Total : <b>' + CAST(sub.TotalJobs AS NVARCHAR(100))
				+ '</b>, Successful : <b>' + CAST(sub.SuccessfulJobs AS NVARCHAR(100))
				+ '</b>, Failed : <b>' + CAST(sub.FailedJobs AS NVARCHAR(100))
				+ '</b>, Killed : <b>' + CAST(sub.KilledJobs AS NVARCHAR(100))
				+ '</b><br/>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(20))
				+ '</b>, Completed with Warning : <b>' + CAST(sub.CompletedWithWarningJobs AS NVARCHAR(20)) + '</b>',
			@tmpRemarks =
				CASE
					WHEN sub.SuccessRatePercent >= @warningThreshold THEN @goodMessage
					WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @warningMessage
					ELSE  @criticalMessage
				END
		FROM
		(
			SELECT
				csInfo.CommServUniqueId,
				csInfo.LogDate,
				csInfo.ClientGroups,
				csInfo.TotalJobs,
				csInfo.SuccessfulJobs,
				ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
				ISNULL(csInfo.CompletedWithWarningJobs, 0) AS CompletedWithWarningJobs,
				ISNULL(csInfo.FailedJobs, 0) FailedJobs,
				ISNULL(csInfo.KilledJobs, 0) KilledJobs,
				CASE
					WHEN csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0) = 0 THEN 0
					ELSE CAST(((ISNULL(csInfo.CompletedWithErrorJobs, 0) + ISNULL(csInfo.CompletedWithWarningJobs, 0)+ ISNULL(csInfo.SuccessfulJobs, 0)) * 100.0)/(csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0)) AS DECIMAL(7, 0))
				END AS SuccessRatePercent
			FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 16
		) AS sub
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND @successRatePct < @i_paramValue) OR
				(@i_Operator = 1 AND @successRatePct > @i_paramValue) OR
				(@i_Operator = 2 AND @successRatePct = @i_paramValue) OR
				(@i_Operator = 8 AND @successRatePct <> @i_paramValue))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (CAST(@successRatePct AS NVARCHAR(32)) + '%')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'Backup Success Rate for last 60 days for CommCell <b>' + CommServeName + '</b> is <b>' +
										CAST(@successRatePct AS NVARCHAR(32)) + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Backup Success Rate for last 60 days for CommCell <b>' + CommServeName + '</b> is at <b>' +
										@tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 6
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 17
		SELECT @goodMessage = GoodMessage, @warningMessage = REPLACE(REPLACE(HP.WarningMessage, '#1', HP.WarningThreshold), '#2', HP.CriticalThreshold), @criticalMessage = REPLACE(HP.CriticalMessage, '#2', HP.CriticalThreshold), @infoMessage = InfoMessage FROM cf_SurveyHealthParam hp(NOLOCK) WHERE QueryId = 17
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @rstSuccessRatePct FLOAT
		SELECT
			@rstSuccessRatePct = sub.TotalSuccPct,
			@tmpStatus = CASE
				WHEN sub.TotalRestoreClients = 0 OR sub.TotalSuccPct > @warningThreshold THEN 'Good' --No Restores Jobs or All Restore Jobs success
				WHEN sub.TotalSuccPct >= @criticalThreshold THEN 'Warning'
				ELSE 'Critical' END,
			@tmpReason = 'Client Count with Restore jobs : '
				+ CASE WHEN sub.TotalRestoreClients = 0 THEN 'None' ELSE '<BR/>Successful : <b>'
				+ CAST(SuccessfulClients AS VARCHAR(7)) + '(' + CAST(sub.SuccessPct AS VARCHAR(7))
				+ '%)</b>, Successful after failed jobs : <b>'
				+ CAST(sub.SuccAfterFailClients AS VARCHAR(7)) + '(' + CAST(sub.SuccAfterFailPct AS VARCHAR(7))
				+ '%)</b>, <BR/>Failed or Killed : <b>'
				+ CAST(sub.FailedClients AS VARCHAR(7)) + '(' + CAST(sub.FailurePct AS VARCHAR(7)) + '%)</b>' END,
			@tmpRemarks = CASE
				WHEN sub.TotalRestoreClients = 0 THEN @infoMessage
				WHEN sub.TotalSuccPct >= @warningThreshold THEN @goodMessage
				WHEN sub.TotalSuccPct >= @criticalThreshold THEN @warningMessage
				ELSE @criticalMessage END
		FROM
			(SELECT
				 TotalRestoreClients,
				SuccessfulClients,
				CASE WHEN TotalRestoreClients>0
				THEN (100*SuccessfulClients)/TotalRestoreClients ELSE 0 END AS SuccessPct,
				SuccAfterFailClients,
				CASE WHEN TotalRestoreClients>0
				THEN (100*SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS SuccAfterFailPct,
				CASE WHEN TotalRestoreClients>0
				THEN 100*(SuccessfulClients + SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS TotalSuccPct,
				FailedClients,
				CASE WHEN TotalRestoreClients>0
				THEN (100*FailedClients)/TotalRestoreClients ELSE 0 END  AS FailurePct
			FROM
			(
				SELECT (SuccessfulClients + SuccAfterFailClients + FailedClients) AS TotalRestoreClients,
				SuccessfulClients,
				SuccAfterFailClients,
				FailedClients
				FROM cf_SurveyRestoreClientStats AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result ON result.SurveyResultId = csInfo.SurveyResultId AND result.QueryID = 17
			) SUB
			) AS sub
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND @rstSuccessRatePct < @i_paramValue) OR
				(@i_Operator = 1 AND @rstSuccessRatePct > @i_paramValue) OR
				(@i_Operator = 2 AND @rstSuccessRatePct = @i_paramValue) OR
				(@i_Operator = 8 AND @rstSuccessRatePct <> @i_paramValue))
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (CAST(@rstSuccessRatePct AS NVARCHAR(32)) + '%')
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'Restore success rate for last 90 days for CommCell <b>' + CommServeName + '</b> is <b>' + CAST(@rstSuccessRatePct AS NVARCHAR(32)) + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		ELSE IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
					(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
					(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Restore success rate for last 90 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 11
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 24
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 24
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @jobCount INT
		SELECT	TOP 1 @jobCount = csInfo.LongRunningJobs
		FROM	cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 24
		SET @tmpStatus = CASE WHEN @jobCount > 0 THEN 'Warning' ELSE 'Good'	END
		SET @tmpReason = CASE
			WHEN @jobCount > 0 THEN 'There are <b>' + CAST(@jobCount AS VARCHAR(MAX)) + '</b> jobs running for more than <b>12 hours</b> in last 1 day.'
			ELSE 'No jobs are found running more than 12 hours in last 1 day.' END
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
		(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
		(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Long Running Backup Jobs for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 18
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 30
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 30
		SET @tmpStatus = 'Good'
		SET @tmpReason = 'No errors are found'
		SET @tmpRemarks = 'None'
		DECLARE @errorCount INT
		SELECT	@tmpStatus = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN 'Good' ELSE 'Warning' END,
						@tmpReason = CASE WHEN ISNULL(sub.TotalErrors, 0) = 0 THEN 'No errors are found.' ELSE CAST(ISNULL(sub.TotalErrors, 0) AS NVARCHAR(16)) + ' errors found in last 24 hours.' END,
						@errorCount = ISNULL(sub.TotalErrors, 0)
				FROM	(
							SELECT COUNT (errorcode) AS TotalErrors
							FROM
							(
								SELECT TOP (10)
								csInfo.ErrorCode ,
								sum(csInfo.NumberOfJobsAffected)  jobs
								FROM cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
								INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = csInfo.SurveyResultId
								AND result.QueryID = 30
								GROUP BY csInfo.ErrorCode
								ORDER BY SUM(csInfo.NumberOfJobsAffected) DESC
							)JobCountPerError
						) AS sub
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
		(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
		(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Top 10 errors for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 2
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 61
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 61
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @MAStoreConfigResults TABLE
		(
			MediaAgentId INT,
			LogDate DATETIME,
			ValidSIDBCount INT,
			Status INT
		)
		declare @criticalMANum int = 0
		declare @warningMANum int = 0
		declare @totalMANum int = 0
		INSERT INTO @MAStoreConfigResults
		SELECT
			sub.MediaAgentId,
			sub.LogDate,
			SUM(sub.IsValid),
			CASE
				WHEN SUM(sub.IsValid) > @criticalThreshold THEN 3
				WHEN SUM(sub.IsValid) >= @warningThreshold and SUM(sub.IsValid) <= @criticalThreshold THEN 2
				ELSE 1
			END
		FROM
		(
		SELECT
			csInfo.MediaAgentId,
			csInfo.LogDate,
			CASE
				WHEN csInfo.SealedStatus = 'Active' OR (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
				ELSE 0
			END AS 'IsValid'
		FROM	cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 61
					AND	csInfo.MediaAgentId > 1
		) AS sub
		GROUP BY sub.MediaAgentId, sub.LogDate
		select @criticalMANum = ISNULL(COUNT(MediaAgentId), 0) from @MAStoreConfigResults where ValidSIDBCount > @criticalThreshold
		select @warningMANum = ISNULL(COUNT(MediaAgentId), 0) from @MAStoreConfigResults where ValidSIDBCount >= @warningThreshold and ValidSIDBCount <= @criticalThreshold
		select @totalMANum = ISNULL(COUNT(*), 0) from @MAStoreConfigResults
		SET @tmpStatus =
			CASE
				WHEN @totalMANum = 0 THEN 'Warning'
				WHEN @criticalMANum > 0 THEN 'Critical'
				WHEN @warningMANum > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalMANum > 0)
			BEGIN
				SET @tmpReason = 'Media Agents with DDB Partitions: <br/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@totalMANum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Good: <B>' + CAST((@totalMANum-@warningMANum-@criticalMANum) AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Warning: <B>' + CAST(@warningMANum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalMANum AS NVARCHAR(5)) + '</B>  '
			END
		ELSE
			SET @tmpReason =  'There are no Media Agents hosting DDB store.'
		SET @tmpRemarks =
			CASE
				WHEN @totalMANum = 0 THEN @infoMessage
				WHEN @totalMANum > 0 AND @criticalMANum = 0 AND @warningMANum = 0 THEN @goodMessage
				ELSE @warningMessage
			END
		IF (@i_status = '')
		BEGIN
			IF EXISTS (select * from @MAStoreConfigResults where ValidSIDBCount > @i_paramValue)
			BEGIN
				SET @totalMANum = (SELECT COUNT(*) FROM @MAStoreConfigResults where ValidSIDBCount > @i_paramValue)
				INSERT INTO #resultTbl (Result) VALUES (@totalMANum)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@totalMANum AS NVARCHAR(16)) + '</b> MediaAgents with more than <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '</b> Dedupe Stores on CommCell <b>' + CommServeName + '</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'DDB Partitions on MediaAgents for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 5
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 65
		SET @criticalThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND CommServUniqueId=@i_CommServUniqueId AND attrName ='AvgQITimeCriticalLimit' and attrtype =10),@criticalThreshold)
		SET @warningThreshold =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 AND  CommServUniqueId	=@i_CommServUniqueId AND attrName ='AvgQITimeWarningLimit' and attrtype =10),@warningThreshold)
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 65
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		declare @criticalNum int = 0
		declare @warningNum int = 0
		declare @goodNum int = 0
		declare @totalNum int = 0
		declare @qiTime table
		(
			SidbStoreId int,
			AvgQITime	bigint,
			PrimaryRecords	bigint,
			NeedUpgrade int
		)
		INSERT INTO @qiTime
		SELECT	csInfo.SidbStoreId,
				csInfo.AvgQITime,
				csInfo.PrimaryRecords,
				csInfo.NeedUpgrade
		FROM	cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 65
		SET @goodNum    = (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE (AvgQITime <  @warningThreshold OR (AvgQITime >= @warningThreshold and AvgQITime < @criticalThreshold and PrimaryRecords<100000000)) AND NeedUpgrade = 0)
		SET @criticalNum= (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime >= @criticalThreshold AND PrimaryRecords>=200000000)
		SET @totalNum	= (SELECT COUNT(SidbStoreId) FROM @qiTime)
		SET @warningNum = (@totalNum - @goodNum - @criticalNum)
		SET @tmpStatus = CASE
			WHEN @criticalNum > 0 THEN 'Critical'
			WHEN @warningNum > 0 THEN 'Warning'
			ELSE 'Good' END
		IF (@totalNum > 0)
		BEGIN
			SET @tmpReason = 'DDBs: <br/>'
			SET @tmpReason += 'Total: <B>'+ CAST(@totalNum AS NVARCHAR(5)) + '</B>  '
			SET @tmpReason += 'Good: <B>' + CAST(@goodNum  AS NVARCHAR(5)) + '</B>  '
			SET @tmpReason += 'Warning: <B>' + CAST(@warningNum AS NVARCHAR(5)) + '</B>  '
			SET @tmpReason += 'Critical: <B>' + CAST(@criticalNum AS NVARCHAR(5)) + '</B>  '
		END
		ELSE
			SET @tmpReason =  'There are no Media Agents hosting DDB store.'
		SET @tmpRemarks = CASE
			WHEN @totalNum = 0 THEN @infoMessage
			WHEN @totalNum > 0 AND @criticalNum = 0 AND @warningNum = 0 THEN @goodMessage
			ELSE @warningMessage END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime = @i_paramValue) > 0) OR
				(@i_Operator = 8 AND (SELECT COUNT(SidbStoreId) FROM @qiTime WHERE AvgQITime <> @i_paramValue) > 0))
			BEGIN
				DECLARE @noOfDDBsWithQITime INT
				SELECT @noOfDDBsWithQITime = COUNT(SidbStoreId) FROM @qiTime WHERE ((@i_Operator = 0 AND AvgQITime < @i_paramValue) OR (@i_Operator = 1 AND AvgQITime > @i_paramValue) OR (@i_Operator = 2 AND AvgQITime = @i_paramValue) OR (@i_Operator = 8 AND AvgQITime <> @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@noOfDDBsWithQITime)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@noOfDDBsWithQITime AS NVARCHAR(16)) + '</b> DDB Stores on CommCell <b>' + CommServeName + '</b> that have Average Q&I time ' +
					CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to' END + ' <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'DDB Performance of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 4
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 64
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 64
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		declare @criticalCopyNum int = 0
		declare @warningCopyNum int = 0
		declare @totalCopyNum int = 0
		declare @dashCoppySummary table
		(
			spName nvarchar(255),
			copyName nvarchar(255),
			FallenBehindDays int,
			ToBeCopiedAppSizeGB bigint,
			AuxCopyAlertDays int,
			AuxCopyAlertGB bigint
		)
		INSERT INTO @dashCoppySummary
		SELECT 	C.PolicyName,
				C.CopyName,
				csInfo.FallenBehindDays,
				ISNULL(csInfo.TotalToBeCopiedJobsApplicationSizeGB, 0),
				ISNULL(csInfo.AuxCopyAlertDays, -1),
				ISNULL(csInfo.AuxCopyAlertGB, -1)
		FROM	cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 64
				INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK)
					ON C.CommServUniqueId = @i_CommServUniqueId AND C.CopyId = csInfo.CopyId
		WHERE csInfo.JobsToCopyCount > 0 AND csInfo.EstCompletionDateForAllData <> -1
		SET @warningCopyNum = (SELECT COUNT(copyName) FROM @dashCoppySummary
				WHERE	(AuxCopyAlertGB <= 0 OR ToBeCopiedAppSizeGB <= AuxCopyAlertGB)
					AND AuxCopyAlertDays <= 0 AND FallenBehindDays >= @warningThreshold AND FallenBehindDays <= @criticalThreshold)
		SET @criticalCopyNum =(SELECT COUNT(copyName) FROM @dashCoppySummary
				WHERE	AuxCopyAlertGB > 0 AND ToBeCopiedAppSizeGB > AuxCopyAlertGB
					 OR AuxCopyAlertDays > 0 AND FallenBehindDays > AuxCopyAlertDays
					 OR AuxCopyAlertDays < 0 AND FallenBehindDays > @criticalThreshold)
		SET @totalCopyNum = (SELECT COUNT(copyName) FROM @dashCoppySummary)
		SET @tmpStatus =
			CASE
				WHEN @criticalCopyNum > 0 THEN 'Critical'
				WHEN @warningCopyNum > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalCopyNum > 0)
			BEGIN
				SET @tmpReason = 'Secondary Copies: <br/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@totalCopyNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Good: <B>' + CAST((@totalCopyNum-@warningCopyNum-@criticalCopyNum) AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Warning: <B>' + CAST(@warningCopyNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalCopyNum AS NVARCHAR(5)) + '</B>  '
			END
		ELSE
			SET @tmpReason =  'There are no Fallen Behind Secondary Copies.<br/>'
		SET @tmpRemarks =
			CASE
				WHEN @totalCopyNum = 0 THEN @infoMessage
				WHEN @totalCopyNum > 0 AND @criticalCopyNum = 0 AND @warningCopyNum = 0 THEN  @goodMessage
				ELSE @warningMessage
			END
		IF (@i_status = '')
		BEGIN
			DECLARE @noOfDashCopies INT
			SELECT @noOfDashCopies = COUNT( copyName) FROM @dashCoppySummary where FallenBehindDays >= @i_ParamValue
			IF (@noOfDashCopies > 0)
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@noOfDashCopies)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> secondary copies on CommCell <b>' + CommServeName + '</b> that have fallend behind <b>' + CAST(@i_ParamValue AS VARCHAR(32)) + '</b> or more days'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 14
	BEGIN
		SELECT @warningThreshold = WarningThreshold*24, @criticalThreshold = CriticalThreshold*24 FROM cf_SurveyHealthParam WHERE QueryId = 66
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 66
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @TotalDDBs int
		declare @WarningDDBs int
		declare @CriticalDDBs int
		DECLARE @DDBsWithNoRecentBackup INT
		DECLARE @criticalValForTrasDDB int = 360	--15 Days
		DECLARE @warningValTrasDDB int = 192		--8 Days
		SELECT 	@totalDDBs = COUNT(csInfo.SidbStoreName),
				@CriticalDDBs = SUM(CASE
										WHEN csInfo.LastDDBBackupJobId =0 THEN 1
										WHEN ISNULL(csInfo.HoursSinceNoBackup,-1) = -1 THEN 1
										WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalThreshold THEN 1
										WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalValForTrasDDB THEN 1
												ELSE 0
									END),
				@WarningDDBs = SUM(CASE
										WHEN csInfo.LastDDBBackupJobId = 0 THEN 0
										WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalThreshold AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningThreshold THEN 1
										WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalValForTrasDDB AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningValTrasDDB THEN 1
										ELSE 0
									END),
				@DDBsWithNoRecentBackup = SUM( case when csInfo.LastDDBBackupJobId =0 THEN 1
											ELSE case when ISNULL(csInfo.HoursSinceNoBackup,-1) <> -1  AND ISNULL(csInfo.HoursSinceNoBackup,-1) > ISNULL(@i_ParamValue, 0) THEN 1
													ELSE 0
													END
										END)
		FROM	cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 66
		SET @tmpStatus = CASE WHEN @CriticalDDBs > 0 THEN 'Critical'
								WHEN @WarningDDBs >0 THEN 'Warning'
								ELSE 'Good' END
		IF ( @TotalDDBs >0 )
		BEGIN
			set @tmpReason = ' DDB Partitions: <BR>'
			SET @tmpReason += 'Total: <B>'+ CAST(@TotalDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Good: <B>' + CAST((@TotalDDBs-@WarningDDBs-@CriticalDDBs) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Warning: <B>' + CAST(@WarningDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Critical: <B>' + CAST(@CriticalDDBs AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
		END
		ELSE
		BEGIN
			SET @tmpReason =  'There are no Media Agents hosting DDB store'
		END
		SET @tmpRemarks = CASE WHEN @TotalDDBs = 0 THEN @infoMessage
										WHEN @CriticalDDBs > 0 or @WarningDDBs > 0 THEN @warningMessage ELSE @goodMessage END
		IF (@i_status = '' AND @DDBsWithNoRecentBackup > 0)
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@DDBsWithNoRecentBackup)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@DDBsWithNoRecentBackup AS NVARCHAR(16)) + '</b> Dedupe stores that are not protected in last ' + CAST(@i_ParamValue AS NVARCHAR(MAX)) + ' hours'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 16
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 26
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 26
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @TotalCopies INT = 0
		DECLARE @Count1 INT = 0	-->= 80
		DECLARE @Count1Percent INT = 0	-->= 80
		DECLARE @Count2 INT = 0	-->= 60 < 80
		DECLARE @Count2Percent INT = 0	-->= 60 < 80
		DECLARE @Count3 INT = 0	--< 60
		DECLARE @Count3Percent INT = 0	-->= 60 < 80
		DECLARE @DeDupRatioSPCount TABLE(Copy NVARCHAR(256), DeDupRatio DECIMAL(20, 2))
		INSERT INTO @DeDupRatioSPCount
		SELECT 	csInfo.Copy, csInfo.DedupeRatio
		FROM	cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 26
		AND csInfo.Jobs > 0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
		AND csInfo.DedupeRatio > -1
		SELECT @TotalCopies = COUNT(*) FROM @DeDupRatioSPCount
		IF @TotalCopies > 0
		BEGIN
			SELECT @Count1 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio > @warningThreshold
			SET @Count1Percent = (@Count1*100)/@TotalCopies
			SELECT @Count2 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio >= @criticalThreshold AND DeDupRatio <= @warningThreshold
			SET @Count2Percent = (@Count2*100)/@TotalCopies
			SELECT @Count3 = COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio < @criticalThreshold
			SET @Count3Percent = (@Count3*100)/@TotalCopies
		END
		SET	@tmpStatus = CASE
			WHEN @TotalCopies = 0 THEN 'Info'
			WHEN @Count3Percent <> 0 THEN 'Critical'
			WHEN @Count2Percent <> 0  THEN 'Warning'
			ELSE 'Good' END
		IF (@TotalCopies > 0)
		BEGIN
			SET @tmpReason = 'Deduplication Copies: <BR/>'
			SET @tmpReason += 'Total: <B>'+ CAST(@TotalCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Good: <B>' + CAST(@Count1 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Warning: <B>' + CAST(@Count2 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Critical: <B>' + CAST(@Count3 AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
		END
		ELSE
			SET @tmpReason =  'There are no storage policy copies with Deduplication enabled.<BR/>'
		SET @tmpRemarks = CASE
						WHEN @tmpStatus = 'Good' THEN @goodMessage
						ELSE @criticalMessage
			END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio = @i_paramValue) > 0) OR
				(@i_Operator = 8 AND (SELECT COUNT(*) FROM @DeDupRatioSPCount WHERE DeDupRatio <> @i_paramValue) > 0))
			BEGIN
				DECLARE @noOfLowDedupe INT
				SELECT @noOfLowDedupe = COUNT(*) FROM @DeDupRatioSPCount where ((@i_Operator = 0 AND DeDupRatio < @i_paramValue) OR (@i_Operator = 1 AND DeDupRatio > @i_paramValue) OR (@i_Operator = 2 AND DeDupRatio = @i_paramValue) OR (@i_Operator = 8 AND DeDupRatio <> @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@noOfLowDedupe)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> storage policy copies on CommCell <b>' + CommServeName + '</b> that have deduplicaton ratio ' +
					CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to' END + ' <b>' + @i_paramValue + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + '</b> of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 21
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 70
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 70
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		declare @criticalCopies int = 0
		declare @warningCopies int = 0
		declare @totalNCopies int = 0
		declare @copiesSize table
		(
			copyId int,
			percentFree decimal(10,2)
		)
		INSERT INTO @copiesSize
		SELECT	csInfo.CopyId,
				case when SUM(ISNULL(csInfo.CapacityMB, 0)) > 0 THEN cast ((SUM(ISNULL(csInfo.FreeSpaceMB, 0)) *100.0 /SUM(ISNULL(csInfo.CapacityMB, 0)) ) AS decimal(10,2)) else '0' END AS percentFree
		FROM	cf_SurveyCopyFreeSpace AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 70
				GROUP BY csInfo.CopyId
		SET @warningCopies	= (select COUNT(CopyId) FROM @copiesSize where percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
		SET @criticalCopies = (select COUNT(CopyId) FROM @copiesSize where percentFree < @criticalThreshold)
		SET @totalNCopies	= (select COUNT(CopyId) FROM @copiesSize)
		SET @tmpStatus = CASE
			WHEN @criticalCopies > 0 THEN 'Critical'
			WHEN @warningCopies > 0 THEN 'Warning'
			ELSE 'Good' END
		IF (@totalNCopies > 0)
		BEGIN
			SET @tmpReason = 'Storage Policy Copies: <BR/>'
			SET @tmpReason += 'Total: <B>'+ CAST(@totalNCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Good: <B>' + CAST((@totalNCopies-@warningCopies-@criticalCopies) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Warning: <B>' + CAST(@warningCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Critical: <B>' + CAST(@criticalCopies AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
		END
		ELSE
			SET @tmpReason =  'All Copies have sufficient space.<BR/>'
		SET @tmpRemarks = CASE
			WHEN @totalNCopies = 0 THEN @infoMessage
			WHEN @totalNCopies > 0 AND @criticalCopies = 0 AND @warningCopies = 0 THEN @goodMessage
			ELSE @warningMessage END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (select COUNT(CopyId) FROM @copiesSize where percentFree < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (select COUNT(CopyId) FROM @copiesSize where percentFree > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (select COUNT(CopyId) FROM @copiesSize where percentFree = @i_paramValue) > 0) OR
				(@i_Operator = 8 AND (select COUNT(CopyId) FROM @copiesSize where percentFree <> @i_paramValue) > 0))
			BEGIN
				DECLARE @noOfLowSpace INT
				SELECT @noOfLowSpace = COUNT(CopyId) FROM @copiesSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue) OR (@i_Operator = 8 AND percentFree <> @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@noOfLowSpace)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> copies on CommCell <b>' + CommServeName + '</b> that have free space ' +
					CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'more than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to' END + ' <b>' + @i_paramValue + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	--Deduplication Stores with pending archive files for pruning
	ELSE IF @i_ParamId = 44
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 35
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 35
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @tmpDeletedAFCount TABLE(DeletedAFCount BIGINT)
		INSERT INTO @tmpDeletedAFCount
		SELECT
			csInfo.DeletedAFCount
		FROM cf_SurveyDeDupDeletedAFCount AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND result.QueryID = 35
		DECLARE @TotalDDBCount INT = 0
		DECLARE @goodDDBCount INT = 0
		DECLARE @warningDDBCount INT = 0
		DECLARE @criticalDDBCount INT = 0
		SELECT @TotalDDBCount = COUNT(*) FROM @tmpDeletedAFCount
		SELECT @goodDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount < @warningThreshold
		SELECT @warningDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount >= @warningThreshold AND DeletedAFCount <= @criticalThreshold
		SELECT @criticalDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount > @criticalThreshold
		SET @tmpStatus =
		CASE
			WHEN @TotalDDBCount = 0 THEN 'Info'
			WHEN @criticalDDBCount > 0 THEN 'Critical'
			WHEN @warningDDBCount > 0 THEN 'Warning'
			ELSE 'Good'
		END
		SET @tmpStatus = 'Critical'
		IF (@TotalDDBCount > 0)
		BEGIN
			SET @tmpReason = 'Deduplication Stores: <BR>'
			SET @tmpReason += 'Total: <B>'+ CAST(@TotalDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Good: <B>' + CAST(@goodDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Warning: <B>' + CAST(@warningDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
			SET @tmpReason += 'Critical: <B>' + CAST(@criticalDDBCount AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
		END
		ELSE
			SET @tmpReason =  'There are no DDB stores with pending archive files for pruning'
		SET @tmpRemarks =
		CASE
			WHEN @tmpStatus = 'Critical' THEN @criticalMessage
			WHEN @tmpStatus = 'Warning' THEN @warningMessage
			WHEN @tmpStatus = 'Good' THEN @goodMessage
			ELSE @infoMessage
		END
		IF (@i_status = '')
		BEGIN
			IF EXISTS (SELECT * FROM @tmpDeletedAFCount WHERE DeletedAFCount > @i_paramValue)
			BEGIN
				SELECT @TotalDDBCount = COUNT(*) FROM @tmpDeletedAFCount WHERE DeletedAFCount > @i_paramValue
				INSERT INTO #resultTbl (Result) VALUES (@TotalDDBCount)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Dedupe stores on CommCell <b>' + CommServeName + '</b> that have more than <b>' + CAST(@i_ParamValue AS NVARCHAR(16))
					+ '</b> thousand archive files pending to be pruned'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + Result +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 22
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 39
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 39
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalIdxCache int = 0
		DECLARE @warningIdxCache int = 0
		DECLARE @criticalIdxCache int = 0
		DECLARE @unknownIdxCache int = 0
		DECLARE @idxCacheSize TABLE
		(
			MAId INT,
			percentFree DECIMAL(10,2),
			FreeDiskSpaceMB BIGINT,
			warningSpaceMB	BIGINT,
			criticalSpaceMB	BIGINT,
			Days bigint,
			status int,
			indexCount INT DEFAULT 0,
			warningCount INT DEFAULT 0,
			criticalCount INT DEFAULT 0,
			errorCount INT DEFAULT 0,
			operationalStatus INT DEFAULT 0,
			cacheType INT DEFAULT 0
		)
		IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
		CREATE	TABLE #LatestThreshold (
				CommServUniqueId INT,
				clientId INT,
				warningSpaceMB BIGINT,
				criticalSpaceMB BIGINT
		)
		INSERT INTO #LatestThreshold
			SELECT  CommServUniqueId ,entityId  AS clientId,
					CASE ISNUMERIC([warningSpaceMB]) WHEN 1 THEN CAST(CAST([warningSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END AS warningSpaceMB,
					CASE ISNUMERIC([criticalSpaceMB]) WHEN 1 THEN CAST(CAST([criticalSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END  AS criticalSpaceMB
			FROM (
				SELECT csInfo.CommServUniqueId,entityId, attrName ,attrVal
				FROM cf_SurveyCommcellThresholdInfo csInfo (NOLOCK)
				WHERE csInfo.CommServUniqueId =@i_CommServUniqueId
					AND attrName IN ( 'warningSpaceMB', 'criticalSpaceMB')
			) AS clients
			PIVOT (
				MAX(attrVal) FOR attrName IN ( warningSpaceMB, [criticalSpaceMB])
			) AS P
		DECLARE @IdxCriticalDays  bigINT =30
		DECLARE @IdxWarningDays  bigINT= 90
		-- Get prediction data
		IF @useStoredPrediction = 0 -- Use default linear regression model
		BEGIN
			-- Delete any data in Growth data tables
			delete #GrowthData
			delete #GrowthRate
			-- Fill input data
			INSERT INTO #GrowthData
				select B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks, max(B.SpaceMB),
				ROW_NUMBER() OVER (PARTITION BY B.CommServUniqueId, B.MAId, B.IndexCachePath ORDER BY B.Weeks desc)
				from
				(SELECT S.CommServUniqueId, S.MAId, S.IndexCachePath, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DiskUsageMB, -1) as SpaceMB
				FROM cf_SurveyIndexCacheUsagePeakSize S
							INNER JOIN (
									select A.CommServUniqueId, A.MAId, A.IndexCachePath, isnull(max(A.TotalCapacityMB),0) as TotalCapacityMBMax
									from cf_SurveyIndexCacheUsage as A
									INNER JOIN @TblLatestResult AS result
									ON result.SurveyResultId = A.SurveyResultId AND A.TotalCapacityMB > 0 AND A.IndexAccessPathEnabled = 1
									group by A.CommServUniqueId, A.MAId, A.IndexCachePath
							) T ON S.CommservUniqueId = T.CommServUniqueId AND S.MAId = T.MAId AND S.IndexCachePath = T.IndexCachePath
				WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DiskUsageMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
				group by B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks
			-- Run Growh rate calculation
			EXEC GetLinearGrowthRate 0
			-- Insert tmp prediction data
			DELETE FROM #PredictionData;
			INSERT INTO #PredictionData
				select F.CommservUniqueId, F.EntityId, F.EntityName,
					cast(dbo.CalculateDaysToBeFull (S.FreeDiskSpaceMB, F.GrowthRate/7.0, S.LogDateUTC) as bigint) as DaysToBeFull
                FROM cf_SurveyIndexCacheUsage AS S
                INNER JOIN @TblLatestResult AS U
                ON U.SurveyResultId = S.SurveyResultId
                left join #GrowthRate F
                on S.CommServUniqueId = F.CommServUniqueId
                and S.MAId = F.EntityId
                and S.IndexCachePath = F.EntityName
                where (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		END
		ELSE -- Use prediction data from CvStatAnalysis
		BEGIN
			DELETE FROM #PredictionData;
			INSERT INTO #PredictionData
				SELECT DISTINCT
					I.CommServUniqueId, I.MediaAgentId, I.IndexCachePath,
					I.DaysToBeFull
				FROM cf_SurveyIndexCacheUsage AS S
				INNER JOIN @TblLatestResult AS U
				ON U.SurveyResultId = S.SurveyResultId
				LEFT JOIN (
					SELECT CommServUniqueId, MediaAgentId, IndexCachePath, MAX(LogDateUTC) AS LogDate
					FROM IndexCacheUsagePrediction
					GROUP BY CommServUniqueId, MediaAgentId, IndexCachePath
				) R
				ON S.CommServUniqueId = R.CommServUniqueId AND S.MAId = R.MediaAgentId AND S.IndexCachePath = R.IndexCachePath
				LEFT JOIN IndexCacheUsagePrediction I
				ON R.CommServUniqueId = I.CommServUniqueId AND R.MediaAgentId = I.MediaAgentId AND R.IndexCachePath = I.IndexCachePath AND R.LogDate = I.LogDateUTC
				WHERE (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
		END
		INSERT INTO @idxCacheSize (CCUID, MAId,percentFree,FreeDiskSpaceMB,warningSpaceMB,criticalSpaceMB, Days, status, indexCount, warningCount, criticalCount, errorCount, operationalStatus, cacheType)
			SELECT
				csInfo.CommServUniqueId,
				csInfo.MAId,
				CASE
					WHEN csInfo.TotalCapacityMB <= 0 THEN -1
					ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
				END AS percentFree,
				CASE WHEN csInfo.TotalCapacityMB <= 0 THEN -1 ELSE csInfo.FreeDiskSpaceMB END,
				CASE WHEN T.clientId IS NOT NULL THEN T.warningSpaceMB ELSE csInfo.TotalCapacityMB*@warningThreshold/100 END,
				CASE WHEN T.clientId IS NOT NULL THEN T.criticalSpaceMB ELSE csInfo.TotalCapacityMB*@criticalThreshold/100 END,
				LSF.DaysToBeFull,
				0,
				csInfo.NumberOfHostedIndices,
				csInfo.NumberOfHostedIndices * @warningThreshold / 100,
				csInfo.NumberOfHostedIndices * @criticalThreshold / 100,
				csInfo.NumberOfErrorIndices,
				CASE WHEN csInfo.IndexAccessPathEnabled = 0 THEN 3 ELSE csInfo.ServerStatus END,
				csInfo.CacheType
			FROM cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result ON result.SurveyResultId = csInfo.SurveyResultId AND csInfo.TotalCapacityMB > 0
				LEFT OUTER JOIN #LatestThreshold T ON T.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.MAId =T.clientId
				LEFT OUTER JOIN #PredictionData LSF ON LSF.EntityId = csInfo.MAId and LSF.CommServUniqueId = csInfo.CommservUniqueId
		SET @totalIdxCache = (SELECT COUNT(MAId) FROM @idxCacheSize)
		SET @unknownIdxCache = (select COUNT(MAId) FROM @idxCacheSize where percentFree = -1)
		SET @criticalIdxCache = (
			SELECT COUNT(MAId)
			FROM @idxCacheSize
			WHERE (FreeDiskSpaceMB < criticalSpaceMB)
				OR (Days != @NA and Days != @Never and Days<@IdxCriticalDays)
				OR (errorCount > criticalCount) -- Critical count of indices in error
				OR (operationalStatus = 3) -- Cache disabled
				OR (percentFree < (100 - @criticalThreshold)) -- overloaded
		)
		SET @warningIdxCache = (
			SELECT COUNT(MAId)
			FROM @idxCacheSize as A
			WHERE ((FreeDiskSpaceMB>=criticalSpaceMB AND FreeDiskSpaceMB<=warningSpaceMB )
				OR ( Days != @NA and Days != @Never and Days>=@IdxCriticalDays and Days <= @IdxWarningDays ))
				OR (errorCount > warningCount) -- Indices in error is bigger than warning threshold
				OR (operationalStatus BETWEEN 1 AND 2) -- Media agent is offline
				OR (percentFree < (100 - @warningThreshold)) -- overloaded
		)
		IF object_id('tempdb.dbo.#LatestThreshold') is not null DROP TABLE #LatestThreshold
		SELECT
			@tmpStatus =
			CASE
				WHEN @totalIdxCache = 0 THEN 'Info'
				WHEN @criticalIdxCache > 0 THEN 'Critical'
				WHEN @warningIdxCache > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalIdxCache > 0)
			BEGIN
				SET @tmpReason = 'Index cache distribution by status: <BR/>'
				SET @tmpReason += 'Total : <B>'+ CAST(@totalIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good : <B>' + CAST((@totalIdxCache-@warningIdxCache-@criticalIdxCache-@unknownIdxCache) AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning : <B>' + CAST(@warningIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical : <B>' + CAST(@criticalIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += CASE WHEN @unknownIdxCache > 0 THEN '<BR/>Excluded : <B>' + CAST(@unknownIdxCache AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;' ELSE '' END
			END
		ELSE
			SET @tmpReason =  'There is no index cache configured.<BR/>'
		SELECT @tmpRemarks =
		CASE
			WHEN @totalIdxCache = 0 THEN @infoMessage
			WHEN @totalIdxCache > 0 AND @criticalIdxCache = 0 AND @warningIdxCache = 0 THEN @goodMessage
			ELSE @warningMessage
		END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree < CONVERT(float,@i_paramValue)) > 0) OR
				(@i_Operator = 1 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree > CONVERT(float,@i_paramValue)) > 0) OR
				(@i_Operator = 2 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree = CONVERT(float,@i_paramValue)) > 0) OR
				(@i_Operator = 8 AND (select COUNT(MAId) FROM @idxCacheSize where percentFree <> CONVERT(float,@i_paramValue)) > 0))
			BEGIN
				DECLARE @noOfIdxCache INT
				SELECT @noOfIdxCache = COUNT(MAId) FROM @idxCacheSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue) OR (@i_Operator = 8 AND percentFree <> @i_paramValue)) AND percentFree > -1
				INSERT INTO #resultTbl (Result) VALUES (@noOfIdxCache)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Index Caches on CommCell <b>' + CommServeName + '</b> that have free disk space ' +
					CASE @i_operator WHEN 0 THEN 'less than ' WHEN 1 THEN 'more than ' WHEN 2 THEN 'equal to ' WHEN 8 THEN 'not equal to ' END + '<b>' + @i_paramValue + '%</b>.<br/>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Index Cache Space Utilization of CommCell <b>' + CommServeName + '</b> is at <b>'+ @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 15
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 22
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 22
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalSchCount INT = 0
		DECLARE @unusedSchCount INT = 0
		DECLARE @tmpSchPolicy TABLE(IsUsed INT, SPCount INT)
		INSERT INTO @tmpSchPolicy
		SELECT 	csInfo.IsUsed, COUNT(*)
		FROM	cf_SurveySchedulePolicyUsage AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 22
		GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.IsUsed
		SELECT @totalSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy
		SELECT @unusedSchCount = COALESCE(SUM(SPCount), 0) FROM @tmpSchPolicy WHERE IsUsed = 0
		IF @unusedSchCount > 0
		BEGIN
			SET @tmpReason = '<b>' + CAST(@unusedSchCount AS NVARCHAR(100)) + '</b> out of <b>'
				+ CAST(@totalSchCount AS NVARCHAR(100))
				+ '</b> Schedule Policies are not used.<BR/>'
			SET @tmpStatus = 'Warning'
			SET @tmpRemarks = @warningMessage
		END
		ELSE
		BEGIN
			SET @tmpReason =
				CASE
					WHEN @totalSchCount = 0 THEN 'There is no Schedule Policy.<BR/>'
					WHEN @totalSchCount > 0 THEN 'All <b>' + CAST(@totalSchCount AS NVARCHAR(100)) + '</b> Schedule Policies are in use.<BR/>'
				END
			SET @tmpStatus = 'Warning'
			SET @tmpRemarks = CASE WHEN @totalSchCount > 0 THEN @goodMessage ELSE '' END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Schedule Policy Usage in last 7 days for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 24
	BEGIN
		SELECT @goodMessage = GoodMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 95
		SET @tmpStatus = 'Info'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalMountPaths     int = 0
		--Disk space free: good:   > 25%   warning: 10 � 25%, critical < 10%
		DECLARE @MountPathsSize TABLE
		(
			MountPathName NVARCHAR(256),
			percentFree DECIMAL(20,2)
		)
		INSERT INTO @MountPathsSize
		SELECT
			MP.MountPathName,
            CASE WHEN MP.TotalSpaceMB > 0 THEN CAST(100.0*MP.FreeSpaceMB/MP.TotalSpaceMB AS DECIMAL(20, 2)) ELSE 0.0 END
        FROM
            cf_SurveyMountPathSummary AS MP WITH (NOLOCK)
            INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK)
                ON MP.SurveyResultId = R.CommservSurveyResults_ID AND R.QueryId = 117 AND R.Flags = 1 AND R.CommcellIdNameMap_ID = @i_CommServUniqueId
            INNER JOIN cf_SurveyLibrary L WITH(NOLOCK)
				ON R.CommcellIdNameMap_ID = L.CommservUniqueId AND MP.LibraryId = L.LibraryId AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
		SET @totalMountPaths     = (SELECT COUNT(MountPathName) FROM @MountPathsSize)
		IF (@totalMountPaths > 0)
			BEGIN
				SET @tmpReason = 'Total configured Mounpaths: '
				SET @tmpReason += '<B>'+ CAST(@totalMountPaths AS NVARCHAR(5)) + '</B><BR/>'
			END
		ELSE
			SET @tmpReason =  'There is no mount path configured.<BR/>'
		SELECT @tmpRemarks =
		CASE
			WHEN @totalMountPaths = 0 THEN @infoMessage
			ELSE @goodMessage
		END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree = @i_paramValue) > 0) OR
				(@i_Operator = 8 AND (SELECT COUNT(MountPathName) FROM @MountPathsSize where percentFree <> @i_paramValue) > 0))
			BEGIN
				DECLARE @noOfMP INT
				SELECT @noOfMP = COUNT(MountPathName) FROM @MountPathsSize where ((@i_Operator = 0 AND percentFree < @i_paramValue) OR (@i_Operator = 1 AND percentFree > @i_paramValue) OR (@i_Operator = 2 AND percentFree = @i_paramValue) OR (@i_Operator = 8 AND percentFree <> @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@noOfMP)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + CAST(@noOfMP AS NVARCHAR(16)) +'</b> Mount Paths on CommCell <b>' + CommServeName + '</b> that have free disk space ' +
					CASE @i_operator WHEN 0 THEN 'less than ' WHEN 1 THEN 'more than ' WHEN 2 THEN 'equal to ' WHEN 8 THEN 'not equal to ' END + '<b>'+ CAST (@i_paramValue AS NVARCHAR(16)) + '%</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
	END
	ELSE IF @i_ParamId = 29
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 96
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 96
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalDiskLib     int = 0
		DECLARE @goodDiskLib      int = 0
		DECLARE @warningDiskLib   int = 0
		DECLARE @criticalDiskLib  int = 0
		DECLARE @unknownDiskLib   int = 0
		DECLARE @InfoDiskLib      int = 0
		--Disk space free: good:   > 25%   warning: 10 � 25%, critical < 10%
		DECLARE @DiskLibDays TABLE
		(
			DiskLibId BIGINT,
			MonthlyGrowthMB	FLOAT,
			DaysToBeFull BIGINT,
			totalFreeSpaceGB FLOAT,
			totalReserveSpaceGB FLOAT,
			totalSpaceGB FLOAT,
			LogDateUTC					DATETIME
		)
		INSERT INTO @DiskLibDays
		SELECT
			csInfo.LibraryId, 0,
			-1,
			ISNULL(csInfo.totalFreeSpaceGB, -2), -- here -1 is used for cloud libraries
			ISNULL(1.0*csInfo.totalReserveSpaceMB/1024, -2),
			ISNULL(csInfo.totalSpaceGB, -2),
				csInfo.LogDateUTC
		FROM
			cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
				INNER JOIN cf_SurveyLibrary L WITH (NOLOCK)
					ON csInfo.commservUniqueId = L.commservUniqueId AND csInfo.LibraryId = L.LibraryId AND L.LibraryTypeId = 3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 96
		IF @useStoredPrediction = 0
		BEGIN
			DELETE FROM #GrowthData
			DELETE FROM #GrowthRate
			INSERT INTO #GrowthData
			SELECT	S.CommservUniqueId, S.LibraryId, '', DATEDIFF(MONTH, S.MonthStart, @CurrMonth), ISNULL(S.UsedSpaceMB, -1),
					ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
			FROM	cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
					INNER JOIN @DiskLibDays T ON S.CommservUniqueId = @i_CommServUniqueId AND S.LibraryId = T.DiskLibId AND S.MonthStart >= @FirstMonth
			WHERE	S.MonthStart < @CurrMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.totalSpaceGB > 0
			EXEC GetLinearGrowthRate 0
			UPDATE	S SET MonthlyGrowthMB = T.GrowthRate
			FROM	@DiskLibDays S
					INNER JOIN #GrowthRate T ON @i_CommServUniqueId = T.CommservUniqueId AND S.DiskLibId = T.EntityId
			UPDATE	@DiskLibDays
			SET		DaysToBeFull = CASE
						WHEN 30.0*1024.0*(totalFreeSpaceGB-totalReserveSpaceGB)> MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
						ELSE 30.0*1024.0*(totalFreeSpaceGB-totalReserveSpaceGB)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
			WHERE	ABS(ISNULL(MonthlyGrowthMB, -1)) > 0.001 AND totalFreeSpaceGB > 0
		END
		ELSE
		BEGIN
			-- Use stored prediction from DiskLibraryPrediction
			UPDATE S
			SET S.DaysToBeFull = P.DaysToBeFull,
				S.MonthlyGrowthMB = P.MonthlyGrowthRate
			FROM @DiskLibDays S
			INNER JOIN (
				SELECT CommServUniqueId, LibraryId, MAX(LogDateUTC) AS LogDate
				FROM DiskLibraryPrediction
				GROUP BY CommServUniqueId, LibraryId) AS P0
				ON @i_CommServUniqueId = P0.CommServUniqueId AND S.DiskLibId = P0.LibraryId
			INNER JOIN DiskLibraryPrediction P
			ON P.CommServUniqueId = P0.CommServUniqueId AND P.LibraryId = P0.LibraryId AND P.LogDateUTC = P0.LogDate
		END
		SET @totalDiskLib    = (SELECT COUNT(DiskLibId) FROM @DiskLibDays)
		SET @goodDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB > 0 AND (DaysToBeFull > @warningThreshold OR DaysToBeFull = -1))
		SET @warningDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB > 0 AND DaysToBeFull BETWEEN @criticalThreshold AND @warningThreshold)
		SET @criticalDiskLib = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB > 0 AND DaysToBeFull < @criticalThreshold AND DaysToBeFull <> -1)
		SET @InfoDiskLib	 = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB = -1 AND totalFreeSpaceGB = -1)
		SET @unknownDiskLib  = (SELECT COUNT(DiskLibId) FROM @DiskLibDays WHERE totalSpaceGB <= 0 AND totalFreeSpaceGB <> -1)
		SELECT
			@tmpStatus =
			CASE
				WHEN @totalDiskLib = 0 THEN 'Info'
				WHEN @totalDiskLib = @InfoDiskLib THEN 'Info'
				WHEN @totalDiskLib = @unknownDiskLib THEN 'Unknown'
				WHEN @criticalDiskLib > 0 THEN 'Critical'
				WHEN @warningDiskLib > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalDiskLib > 0)
			BEGIN
				SET @tmpReason = 'Disk Library distribution by estimated days to be full: <BR/>'
				SET @tmpReason += 'Total : <B>'+ CAST(@totalDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Good : <B>' + CAST(@goodDiskLib  AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Warning : <B>' + CAST(@warningDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Critical : <B>' + CAST(@criticalDiskLib AS NVARCHAR(5)) + '</B>&nbsp;&nbsp;'
				SET @tmpReason += 'Info : <B>' + CAST(@InfoDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += CASE WHEN (@unknownDiskLib = 0)
		                            THEN ''
								    ELSE 'Not Ready : <B>' + CAST(@unknownDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
								  END
			END
		ELSE
			SET @tmpReason =  'There is no disk library configured.<BR/>'
		SELECT @tmpRemarks =
		CASE
			WHEN @totalDiskLib = 0 OR  @totalDiskLib = @unknownDiskLib THEN @infoMessage
			WHEN @totalDiskLib > 0 AND @criticalDiskLib = 0 AND @warningDiskLib = 0 THEN @goodMessage
			ELSE @warningMessage
		END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where DaysToBeFull != -1 AND DaysToBeFull < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where DaysToBeFull  = -1  OR DaysToBeFull > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where DaysToBeFull  = @i_paramValue) > 0) OR
				(@i_operator = 8 AND (SELECT COUNT(DiskLibId) FROM @DiskLibDays where DaysToBeFull  <> @i_ParamValue) > 0) )
			BEGIN
				DECLARE @daysToBeFull INT
				SELECT @daysToBeFull = COUNT(DiskLibId) FROM @DiskLibDays where ((@i_Operator = 0 AND DaysToBeFull != -1 AND DaysToBeFull < @i_paramValue) OR (@i_Operator = 1 AND (DaysToBeFull > @i_paramValue OR DaysToBeFull = -1)) OR (@i_Operator = 2 AND DaysToBeFull = @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@daysToBeFull)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Disk Libraries on CommCell <b>' + CommServeName + '</b> that are estimated to be full in ' +
					CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'greater than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to'  END + ' <b>' + @i_paramValue + ' days</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Disk Library Growth of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 43
	BEGIN
        SELECT	@CSVersion = LEFT(CommServVersion,2)
		FROM	cf_CommCellIdNameMap WITH (NOLOCK)
		WHERE	ID = @i_CommServUniqueId
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 144
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 144
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
			DECLARE @Flag INT = 0
 					DECLARE @csInstallDate DATETIME
 					SELECT @csInstallDate = sub.InstallDate from
 								(SELECT
 									resultView.CommServUniqueId AS CommServUniqueId,
 									csInfo.InstallTime  AS InstallDate,
 									ROW_NUMBER() OVER (PARTITION BY resultView.CommServUniqueId ORDER BY csInfo.ReleaseId ) AS RowId
 									FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
 									INNER JOIN dbo.cf_SurveyResultFuncV1(38, @i_CommServUniqueId, 1, NULL, NULL, 1, 0) AS resultView
 										ON resultView.SurverResultId = csInfo.SurveyResultId
 										AND csInfo.ReleaseId > 0
 									)sub
 						where  sub.RowId = 1
 					IF (@csInstallDate+21 > GETDATE())
 					BEGIN
 						SET @tmpStatus = 'Good'
						SET @tmpRemarks = @warningMessage
 						SET @Flag = 1
 					END
 	IF (@Flag = 0)
 	BEGIN
		DECLARE @TblFragmentation TABLE (DatabaseName VARCHAR(32), OperationalIndexCount INT, WarningIndexCount INT, CriticalIndexCount INT, Percentage DECIMAL(5,2),LastFullReindexOperation INT)
		INSERT INTO @TblFragmentation (DatabaseName, OperationalIndexCount, WarningIndexCount, CriticalIndexCount,LastFullReindexOperation)
		SELECT  csInfo.DatabaseName,
			ISNULL(SUM(CASE WHEN csInfo.FragmentationPct = 102 THEN IndexCount ELSE 0 END), 0), --102: Total operational indexes
			ISNULL(SUM(CASE WHEN csInfo.FragmentationPct >= @warningThreshold AND csInfo.FragmentationPct < @criticalThreshold THEN IndexCount ELSE 0 END), 0),
			ISNULL(SUM(CASE WHEN csInfo.FragmentationPct >= @criticalThreshold AND csInfo.FragmentationPct < 100 THEN IndexCount ELSE 0 END), 0),MAX(LastFullReindexOperation)
		FROM    cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
		GROUP BY DatabaseName
		UPDATE @TblFragmentation SET Percentage = CASE WHEN OperationalIndexCount = 0 THEN 0 ELSE (WarningIndexCount + CriticalIndexCount)*100.0 / OperationalIndexCount END
        IF  @CSVersion like '11%'
        BEGIN
			IF EXISTS (SELECT * FROM @TblFragmentation WHERE (DATEDIFF(day,dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),getdate()) > 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ))
			BEGIN
				SET @tmpStatus = 'Critical'
				SET @tmpRemarks = @criticalMessage
			END
			ELSE IF EXISTS (SELECT * FROM @TblFragmentation WHERE (DATEDIFF(day,dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),getdate()) BETWEEN  7 AND 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ))
			BEGIN
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = @warningMessage
			END
			ELSE IF EXISTS (SELECT * FROM @TblFragmentation WHERE (DATEDIFF(day,dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),getdate()) <= 7) OR (CriticalIndexCount=0 and WarningIndexCount=0))
			BEGIN
				SET @tmpStatus = 'Good'
				SET @tmpRemarks = @goodMessage
			END
			ELSE
			BEGIN
				SET @tmpStatus = 'Info'
				SET @tmpRemarks = ''
				SET @tmpReason = 'No data available'
			END
         END
         ELSE
         BEGIN
	        IF EXISTS (SELECT * FROM @TblFragmentation WHERE CriticalIndexCount > 0.25*OperationalIndexCount)
			BEGIN
				SET @tmpStatus = 'Critical'
				SET @tmpRemarks = @criticalMessage
			END
			ELSE IF EXISTS (SELECT * FROM @TblFragmentation WHERE WarningIndexCount > 0.25*OperationalIndexCount)
			BEGIN
				SET @tmpStatus = 'Warning'
				SET @tmpRemarks = @warningMessage
			END
			ELSE IF EXISTS (SELECT * FROM @TblFragmentation)
			BEGIN
				SET @tmpStatus = 'Good'
				SET @tmpRemarks = @goodMessage
			END
			ELSE
			BEGIN
				SET @tmpStatus = 'Info'
				SET @tmpRemarks = ''
				SET @tmpReason = 'No data available'
			END
        END
		IF EXISTS (SELECT * FROM @TblFragmentation)
        BEGIN
            IF  @CSVersion like '11%'
            BEGIN
				SELECT @tmpReason +=' Last DB DBMaintenance Time: ' + CASE WHEN LastFullReindexOperation >0 THEN CONVERT(nvarchar(30), dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),107) END +'<BR/><b>'
				+ (DatabaseName
					+ CASE WHEN(DATEDIFF(day,dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),getdate()) > 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN ': Critical, <b>'
						WHEN (DATEDIFF(day,dbo.GetDateTime(ISNULL(LastFullReindexOperation,0)),getdate()) BETWEEN  7 AND 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN ': Warning, <b>' ELSE ': Good, <b>' END
					+ CASE	WHEN CriticalIndexCount > 0 THEN CAST(CriticalIndexCount AS NVARCHAR(MAX))
							WHEN WarningIndexCount > 0 THEN CAST(WarningIndexCount AS NVARCHAR(MAX))
							ELSE CAST((OperationalIndexCount - WarningIndexCount - CriticalIndexCount) AS NVARCHAR(MAX)) END + ' indexes out of ' + CAST(OperationalIndexCount AS NVARCHAR(MAX)) + ' operational indexes are '
					+ CASE	WHEN CriticalIndexCount > 0 THEN 'critically fragmented.'
							WHEN WarningIndexCount >  0 THEN 'majorly fragmented.'
							ELSE 'minorly fragmented <BR/>' END)
				FROM   @TblFragmentation
				ORDER BY DatabaseName
            END
            ELSE
			BEGIN
            	SELECT @tmpReason += (DatabaseName
				+ CASE WHEN CriticalIndexCount > 0.25*OperationalIndexCount THEN ': Critical, <b>'
					WHEN WarningIndexCount > 0.25*OperationalIndexCount THEN ': Warning, <b>' ELSE ': Good, <b>' END
				+ CASE	WHEN CriticalIndexCount > 0.25*OperationalIndexCount THEN CAST(CriticalIndexCount AS NVARCHAR(MAX))
						WHEN WarningIndexCount > 0.25*OperationalIndexCount THEN CAST(WarningIndexCount AS NVARCHAR(MAX))
						ELSE CAST((OperationalIndexCount - WarningIndexCount - CriticalIndexCount) AS NVARCHAR(MAX)) END + ' indexes out of ' + CAST(OperationalIndexCount AS NVARCHAR(MAX)) + ' operational indexes are '
				+ CASE	WHEN CriticalIndexCount > 0.25*OperationalIndexCount THEN 'critically fragmented.'
						WHEN WarningIndexCount > 0.25*OperationalIndexCount THEN 'majorly fragmented.'
						ELSE 'minorly fragmented <BR/>' END)
			FROM   @TblFragmentation
			ORDER BY DatabaseName
            END
         END
		IF (@i_status = '')
		BEGIN
			IF EXISTS (SELECT * FROM @TblFragmentation WHERE Percentage > @i_paramValue)
			BEGIN
				DECLARE @databases NVARCHAR(258) = 'Database(s) <b>'
				SET @databases += STUFF((SELECT ', ' + DatabaseName
				FROM @tblFragmentation
				WHERE Percentage > @i_paramValue
				FOR XML PATH('')), 1, 1, '')
				SET @databases += '</b> have more than <b>' + CAST(@i_paramValue AS NVARCHAR(16)) + '%</b> of indexes fragmented over 30%'
				INSERT INTO #resultTbl (Result) VALUES (@databases)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
	END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Database Index Fragmentation for CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 42
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 124
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 124
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @settingValue INT = 0
		DECLARE @settingValueString NVARCHAR(MAX) = ''
		SELECT @settingValue = csInfo.Value, @settingValueString = csInfo.ValueString
			FROM cf_surveyHighRiskSettings AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 124
					AND	csInfo.Name = 'Prune All Database Agent Logs Only By Days Retention Rule'
		SET @tmpStatus = CASE WHEN @settingValue = 0 THEN 'Good' ELSE 'Critical' END
		SET @tmpReason =
			CASE
				WHEN @settingValue = 0 THEN 'Prune all database agent logs only by days retention rule option: Disabled'
				ELSE 'Prune all database agent logs only by days retention rule option: Enabled'
			END
		SET @tmpRemarks = CASE WHEN @settingValue = 0 THEN @goodMessage ELSE @CriticalMessage END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Prune All Database Agent Logs Only By Days Retention Rule property for CommCell <b>' + CommServeName + '</b> is <b>' + LOWER(@settingValueString) + '</b>'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 45
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 156
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 156
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		declare @criticalNo int = 0
		declare @warningNo int = 0
		declare @totalNo int = 0
		declare @DDBTable table
		(
			PrimaryRecords int,
			ZeroRefCount	bigint,
			SevenDaysOldMMDeletedAFtable bigint
		)
		DECLARE @criticalAFVal int = 0
		DECLARE @warningAFVal int  = 0
		SET @criticalAFVal =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='DDBPendingDeleteCriticalLimit' and attrtype =10 AND CommServUniqueId=@i_CommServUniqueId),10000)
		SET @warningAFVal =ISNULL((SELECT cast(attrval as int) FROM cf_SurveyCommcellThresholdInfo (NOLOCK) WHERE ENTITYID =1 and attrName ='DDBPendingDeleteWarningLimit' and attrtype =10 AND CommServUniqueId=@i_CommServUniqueId),5000)
		INSERT INTO @DDBTable
		SELECT PrimaryRecords, ZeroRefCount, AF.SevenDaysOldMMDeletedAFtable FROM cf_SurveyDDBPerformance csInfo INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 65 AND ISNULL(PrimaryRecords,-1) > -1 AND ISNULL(ZeroRefCount,-1) > -1
					INNER JOIN (SELECT DD.SIDBStoreId,DD.SevenDaysOldMMDeletedAFtable  FROM cf_SurveyDeDupDeletedAFCount AS DD WITH (NOLOCK)
								INNER JOIN cf_CommservSurveyResults G
								ON DD.SurveyResultId=G.CommservSurveyResults_ID and G.CommcellIdNameMap_ID=@i_CommServUniqueId and G.Flags=1) AS AF
								ON csInfo.SidbStoreId = AF.SIDBStoreId
		SET @totalNo = (SELECT COUNT(*) FROM @DDBTable)
		SET @warningNo = (SELECT COUNT(*) FROM @DDBTable WHERE PrimaryRecords > 0 AND ZeroRefCount >= (@warningThreshold * PrimaryRecords /100.0) AND ZeroRefCount < (@criticalThreshold * PrimaryRecords /100.0) OR SevenDaysOldMMDeletedAFtable BETWEEN @warningAFVal AND @criticalAFVal)
		SET @criticalNo= (SELECT COUNT(*) FROM @DDBTable WHERE PrimaryRecords > 0 AND ZeroRefCount >= (@criticalThreshold * PrimaryRecords /100.0) OR SevenDaysOldMMDeletedAFtable > @criticalAFVal )
		SET @tmpStatus = CASE
			WHEN @totalNo = 0 THEN 'Info'
			WHEN @criticalNo > 0 THEN 'Critical'
			WHEN @warningNo > 0 THEN 'Warning'
			ELSE 'Good' END
		IF (@totalNo > 0)
		BEGIN
			SET @tmpReason = 'Dedupe Stores: <BR/>'
			SET @tmpReason += 'Total: <B>'+ CAST(@totalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Good: <B>' + CAST((@totalNo-@warningNo-@criticalNo) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Warning: <B>' + CAST(@warningNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Critical: <B>' + CAST(@criticalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
		END
		ELSE
			SET @tmpReason =  'There are no Media Agents hosting DDB store.<BR/>'
		SET @tmpRemarks = CASE
			WHEN @totalNo = 0 THEN @infoMessage
			WHEN @totalNo > 0 AND @criticalNo = 0 AND @warningNo = 0 THEN @goodMessage
			ELSE @warningMessage END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Disk Pruning for CommCell <b>' + CommServeName + '</b> is <b>' + @tmpStatus + '</b> status.'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
		ELSE IF ((@i_Operator = 0 AND (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount < (@i_paramValue * PrimaryRecords /100.0)) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount > (@i_paramValue * PrimaryRecords /100.0)) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount = (@i_paramValue * PrimaryRecords /100.0)) > 0) OR
				(@i_Operator = 8 AND (SELECT COUNT(*) FROM @DDBTable WHERE ZeroRefCount <> (@i_paramValue * PrimaryRecords /100.0)) > 0))
		BEGIN
			DECLARE @zeroRefCnt INT
			SELECT @zeroRefCnt = COUNT(*) FROM @DDBTable where ((@i_Operator = 0 AND ZeroRefCount < (@i_paramValue * PrimaryRecords /100.0)) OR (@i_Operator = 1 AND ZeroRefCount > (@i_paramValue * PrimaryRecords /100.0)) OR (@i_Operator = 2 AND ZeroRefCount = (@i_paramValue * PrimaryRecords /100.0)) OR (@i_Operator = 8 AND ZeroRefCount <> (@i_paramValue * PrimaryRecords /100.0)))
			INSERT INTO #resultTbl (Result) VALUES (@zeroRefCnt)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> DDB Store(s) on CommCell <b>' + CommServeName + '</b> that has Prunable block count ' +
				CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'greater than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to' END + ' <b>' + @i_paramValue + '%</b> of the Primary block count.'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
    --Live Sync
    ELSE IF @i_ParamId = 48
    BEGIN
        DECLARE @totVms INT = 0
        DECLARE @WarningVms INT = 0
        DECLARE @CriticalVms INT = 0
        DECLARE @GoodVms INT = 0
        SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 181
        declare @liveSyncVmDetails table
        (
                SourceVMClientName          NVARCHAR(256),
                Status						INT
        )
        INSERT INTO @liveSyncVmDetails
        SELECT vmInfo.SourceVMClientName,
        CASE
            WHEN (vmInfo.Status = 5 OR DATEDIFF(d, dbo.GetDateTime(vmInfo.LastRestoreTime), SYSDATETIME()) > 7) THEN  4
            WHEN vmInfo.Status = 6 THEN 3
            ELSE 1
        END
        FROM cf_SurveyLiveSyncVMDetails AS vmInfo with (NOLOCK)
        INNER JOIN @TblLatestResult AS result
            ON result.SurveyResultId = vmInfo.SurveyResultId
        --get total number of vms being synced.
        SELECT @totVms = COUNT(*) from @liveSyncVmDetails
        --get number of good VMs
        SELECT @GoodVms = COUNT(*) from @liveSyncVmDetails where Status = 1
        --get number of warning VMs
        SELECT @WarningVms = COUNT(*) from @liveSyncVmDetails where Status = 3
        --get number of sync failures
        SELECT @CriticalVms = COUNT(*) from @liveSyncVmDetails where Status = 4
        SET @tmpReason = 'Total VM(s): <B>'+ CAST(@totVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
        SET @tmpReason += 'Good: <B>' + CAST((@GoodVms) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
        SET @tmpReason += 'Warning: <B>' + CAST(@WarningVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
        SET @tmpReason += 'Critical: <B>' + CAST(@CriticalVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
        IF @CriticalVms > 0
        BEGIN
            SET @tmpStatus = 'Critical'
            SET @tmpRemarks = @criticalMessage
        END
        ELSE IF @WarningVms > 0
        BEGIN
            SET @tmpStatus = 'Warning'
            SET @tmpRemarks = @warningMessage
        END
        ELSE
        BEGIN
            SET @tmpStatus = 'Good'
            SET @tmpRemarks = @goodMessage
        END
        IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
		(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
		(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE	CommServGUID = @csGUID)
			UPDATE #resultTbl SET Result = 'Live Sync Replication status for CommCell <b>' + CommServeName + '</b> is at <b>' +
											@tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
    END
	ELSE IF @i_ParamId = 49
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE ParamId = @i_ParamId
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE ParamId = @i_ParamId
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalIdx int = 0
		DECLARE @warningIdx int = 0
		DECLARE @criticalIdx int = 0
		-- CRITICAL : No Index Backup in last 30 days and no backup in last 30 days
		-- WARNING : No Index Backup in last 15 days and no backup in last 30 days
		DECLARE @idxLastBackupTime TABLE
		(
			ClientId INT,
			LastBackupTime BIGINT,
			lastTimeDbUptodate BIGINT,
			LastBackupForDb BIGINT,
			FirstBackupForDb BIGINT,
			ScIdxConversionTime BIGINT,
			IndexType NVARCHAR (255)
		)
		-- Get timestamps based on threshold values
		DECLARE @lastReportCollectionTime DATETIME = (SELECT ModifiedTime FROM cf_CommcellIdNameMap CM WITH (NOLOCK) WHERE CM.Id = @i_CommServUniqueId)
		DECLARE @criticalDaysIdxBkp BIGINT = DBO.GetUnixTimeBig(@lastReportCollectionTime - @criticalThreshold)
		DECLARE @warningDaysIdxBkp BIGINT = DBO.GetUnixTimeBig(@lastReportCollectionTime - @warningThreshold)
		DECLARE @bufferDaysVal INT = 2
		DECLARE @bufferTimeIdxBkp BIGINT = DBO.GetUnixTimeBig(@lastReportCollectionTime - @bufferDaysVal)
		INSERT INTO @idxLastBackupTime
		SELECT
			csInfo.ClientId,
			csInfo.LastBackupTime,
			csInfo.lastTimeDbUptodate,
			csInfo.LastBackupForDb,
			csInfo.FirstBackupForDb,
			csInfo.ScIdxConversionTime,
			csInfo.IndexType
			FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
		SET @totalIdx = (SELECT COUNT(ClientId) FROM @idxLastBackupTime)
		-- threshold values are in number of days, we need to compare timestamps
		SET @warningIdx = (SELECT COUNT(ClientId) FROM @idxLastBackupTime WHERE (LastBackupTime != -1 AND LastBackupTime >= @criticalDaysIdxBkp AND LastBackupTime < @warningDaysIdxBkp AND (LastBackupForDb = -1 OR LastBackupForDb > @warningDaysIdxBkp) AND FirstBackupForDb < @bufferTimeIdxBkp))
		SET @criticalIdx = (SELECT COUNT(ClientId) FROM @idxLastBackupTime WHERE (LastBackupTime = -1 AND IndexType = 'Classic' AND LastBackupForDb > @criticalDaysIdxBkp AND FirstBackupForDb < @bufferTimeIdxBkp AND FirstBackupForDb != -1 AND ScIdxConversionTime < @bufferTimeIdxBkp) -- Apply this only when new data comes in
		                                                                         OR (LastBackupTime != -1 AND LastBackupTime < @criticalDaysIdxBkp AND (LastBackupForDb = -1 OR LastBackupForDb > @criticalDaysIdxBkp) AND FirstBackupForDb < @bufferTimeIdxBkp))
		SET @tmpStatus = CASE
			WHEN @totalIdx = 0 THEN 'Info'
			WHEN @criticalIdx > 0 THEN 'Critical'
			WHEN @warningIdx > 0 THEN 'Warning'
			ELSE 'Good' END
		IF (@totalNo > 0)
		BEGIN
			SET @tmpReason = 'Index Backup Status: <BR/>'
			SET @tmpReason += 'Total: <B>'+ CAST(@totalIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Good: <B>' + CAST((@totalIdx-@warningIdx-@criticalIdx) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Warning: <B>' + CAST(@warningIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			SET @tmpReason += 'Critical: <B>' + CAST(@criticalIdx AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
		END
		ELSE
			SET @tmpReason =  'There is no index backup status.<BR/>'
		SET @tmpRemarks = CASE
			WHEN @totalIdx = 0 THEN @infoMessage
			WHEN @totalIdx > 0 AND @criticalIdx = 0 AND @warningIdx = 0 THEN @goodMessage
			ELSE @warningMessage END
		declare @lastndays DATETIME= CAST(GETDATE() AS DATE)
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Index Backup for CommCell <b>' + CommServeName + '</b> is <b>' + @tmpStatus + '</b> status.'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
		ELSE IF (@i_paramValue>0 AND ((SELECT COUNT(ClientId) FROM @idxLastBackupTime where LastBackupTime < DBO.GetUnixTimeBig(GETDATE()-cast(@i_paramValue as int )))>0 ))
		BEGIN
			DECLARE @LastBackupTime INT
			SELECT @LastBackupTime = COUNT(ClientId) FROM @idxLastBackupTime where LastBackupTime < DBO.GetUnixTimeBig(GETDATE()-cast(@i_paramValue as int ))
			INSERT INTO #resultTbl (Result) VALUES (@LastBackupTime)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Index Backup(s) on CommCell <b>' + CommServeName + '</b> that has Index Last Backup is not taken in last '
				+ @i_paramValue + ' days</b> .'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 50
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE ParamId = @i_ParamId
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE ParamId = @i_ParamId
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalIdxState int = 0
		DECLARE @goodIdxState int = 0
		DECLARE @criticalIdxState int = 0
		DECLARE @warningIdxState int = 0
		-- CRITICAL: Error level between 1 and 5 and error is older than 3 days
		-- WARNING: Error level greater than 5 and error is older than 3 days OR db is not upto date
		DECLARE @idxStateStatus TABLE
		(
			ClientId INT,
			errorLevel INT,
			dbUptoDate INT,
			LastIdxErrorTime BIGINT
		)
		INSERT INTO @idxStateStatus
		SELECT
			csInfo.ClientId,
			csInfo.errorLevel,
			csInfo.dbUptoDate,
			csInfo.LastIdxErrorTime
			FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
			INNER JOIN @TblLatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
		DECLARE @criticalDaysIdxState INT = (SELECT CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 201 AND ThresholdName = 'Index State')
		DECLARE @transientIdxErrorBufferTime BIGINT = DBO.GetUnixTimeBig((SELECT ModifiedTime FROM cf_CommcellIdNameMap WITH (NOLOCK) WHERE ID = @i_CommServUniqueId) - @criticalDaysIdxState)
		SET @totalIdxState = (SELECT COUNT(ClientId) FROM @idxStateStatus)
		SET @criticalIdxState = (SELECT COUNT(ClientId) FROM @idxStateStatus WHERE errorLevel BETWEEN 1 AND 5 AND LastIdxErrorTime < @transientIdxErrorBufferTime)
		SET @warningIdxState = (SELECT COUNT(ClientId) FROM @idxStateStatus WHERE (errorLevel > 5 AND LastIdxErrorTime < @transientIdxErrorBufferTime) OR dbUptoDate = 0)
		SET @goodIdxState = @totalIdxState - (@criticalIdxState + @warningIdxState)
		SELECT
			@tmpStatus =
			CASE
				WHEN @totalIdxState = 0 THEN 'Info'
				WHEN @criticalIdxState > 0 THEN 'Critical'
				WHEN @warningIdxState > 0 THEN 'Warning'
			ELSE 'Good' END
		IF (@totalIdxState > 0)
			BEGIN
				SET @tmpReason = 'Index State Status: <BR/>'
				SET @tmpReason += 'Total : <B>'+ CAST(@totalIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Good : <B>' + CAST(@goodIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Warning : <B>' + CAST((@warningIdxState) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Critical : <B>' + CAST(@criticalIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			END
		ELSE
			SET @tmpReason =  'There is no index state status.<BR/>'
		SET @tmpRemarks = CASE
					WHEN @totalIdxState = 0 THEN @infoMessage
					WHEN @totalIdxState > 0 AND @criticalIdxState = 0 AND @warningIdxState = 0 THEN @goodMessage
					ELSE @warningMessage
				END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Index Backup for CommCell <b>' + CommServeName + '</b> is <b>' + @tmpStatus + '</b> status.'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 54
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 206
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 206
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalDDBPath int = 0
		DECLARE @warningDDBPath int = 0
		DECLARE @criticalDDBPath int = 0
		DECLARE @unknownDDBPath int = 0
		DECLARE @i_percentFree DECIMAL(20,2) = CASE WHEN ISNUMERIC(@i_paramValue) = 1 THEN CAST(@i_paramValue AS DECIMAL(20,2)) ELSE 0 END
		--Disk space free: good:   > 25%   warning: 10 � 25%, critical < 10%
		DECLARE @DDBPathUsage TABLE
		(
			idxAccessPathId INT,
			percentFree DECIMAL(10,2),
			Days BIGINT
		)
				DECLARE @DDBCriticalDays  bigINT =30
				DECLARE @DDBWarningDays  bigINT= 90
	-- Get prediction data
	IF @useStoredPrediction = 0 -- Use default linear regression model
	BEGIN
		-- Delete any data in Growth data tables
		delete #GrowthData
		delete #GrowthRate
		-- Fill input data
		INSERT INTO #GrowthData
			select B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks, max(B.SpaceMB),
			ROW_NUMBER() OVER (PARTITION BY B.CommServUniqueId, B.SubstoreId, B.EntityName ORDER BY B.Weeks desc)
			from
			(SELECT S.CommServUniqueId, S.SubstoreId, '' as EntityName, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DDBUsedDiskSpaceMB, -1) as SpaceMB
			FROM cf_SurveyDeDupStoreConfigPeakSize S
						INNER JOIN (
								select A.CommServUniqueId, A.SubstoreId, isnull(max(A.DDBDiskTotalSpaceMB),0) as TotalCapacityMBMax
								from cf_SurveyDeDupStoreConfig as A
								INNER JOIN @TblLatestResult AS result
								ON result.SurveyResultId = A.SurveyResultId
								group by A.CommServUniqueId, A.SubstoreId
						) T ON S.CommservUniqueId = T.CommServUniqueId AND S.SubstoreId = T.SubstoreId
			WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DDBUsedDiskSpaceMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
			group by B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks
		-- Run Growh rate calculation
		EXEC GetLinearGrowthRate 0
		-- Insert tmp prediction data
		DELETE FROM #PredictionData;
		INSERT INTO #PredictionData
			SELECT 	S.CommServUniqueId, S.SubstoreId, '',
					CAST(dbo.CalculateDaysToBeFull (S.DDBDiskFreeSpaceMB, R.GrowthRate/7.0, S.LogDateUTC) AS BIGINT) -- DaysToBeFull
			FROM cf_SurveyDeDupStoreConfig AS S
			INNER JOIN @TblLatestResult AS U
			on U.SurveyResultId = S.SurveyResultId
			left join #GrowthRate R
			on S.CommServUniqueId = R.CommServUniqueId
			and S.SubstoreId = R.EntityId
			where (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	END
	ELSE -- Use prediction data from CvStatAnalysis
	BEGIN
		DELETE FROM #PredictionData;
		INSERT INTO #PredictionData
			SELECT DISTINCT
				I.CommServUniqueId, I.SubstoreId, '',
				I.DaysToBeFull
			FROM cf_SurveyDeDupStoreConfig AS S
			INNER JOIN @TblLatestResult AS U
			ON U.SurveyResultId = S.SurveyResultId
			LEFT JOIN (
				SELECT CommServUniqueId, SubstoreId, MAX(LogDateUTC) AS LogDate
				FROM DeDupDiskPrediction
				GROUP BY CommServUniqueId, SubstoreId
			) R
			ON S.CommServUniqueId = R.CommServUniqueId AND S.SubstoreId = R.SubstoreId
			LEFT JOIN DeDupDiskPrediction I
			ON R.CommServUniqueId = I.CommServUniqueId AND R.SubstoreId = I.SubstoreId AND R.LogDate = I.LogDateUTC
			WHERE (S.CommServUniqueId = @i_CommServUniqueID OR @i_CommServUniqueID = 0)
	END
		INSERT INTO @DDBPathUsage
		SELECT
			csInfo.idxAccessPathId,
			CASE
				WHEN csInfo.DDBDiskTotalSpaceMB <= 0 THEN -1
				ELSE CAST((1.0*csInfo.DDBDiskFreeSpaceMB)/(0.01*csInfo.DDBDiskTotalSpaceMB) AS DECIMAL(10,2))
			END AS percentFree,
			LSF.DaysToBeFull
		FROM
			cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = 61
		LEFT OUTER JOIN #PredictionData LSF
		ON LSF.EntityId = csInfo.SubstoreId
		SET @totalDDBPath = (SELECT COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage)
		SET @unknownDDBPath = (select COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage where percentFree = -1)
		SET @criticalDDBPath = (select COUNT(DISTINCT idxAccessPathId) FROM @DDBPathUsage where (percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays ))
		SET @warningDDBPath = (
			SELECT COUNT(DISTINCT idxAccessPathId)
			FROM @DDBPathUsage as A
			where (
					(percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
					or
					( Days != @NA and Days != @Never and Days>=@DDBCriticalDays and Days <= @DDBWarningDays )
				)
				and A.idxAccessPathId not in (
					(select DISTINCT idxAccessPathId FROM @DDBPathUsage where (percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays ))
					union all
					(select DISTINCT idxAccessPathId FROM @DDBPathUsage where percentFree = -1)
				)
		)
		SELECT
			@tmpStatus =
			CASE
				WHEN @totalDDBPath = 0 THEN 'Info'
				WHEN @criticalDDBPath > 0 THEN 'Critical'
				WHEN @warningDDBPath > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalDDBPath > 0)
			BEGIN
				SET @tmpReason = 'DDB path distribution by available space: <BR/>'
				SET @tmpReason += 'Total : <B>'+ CAST(@totalDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Good : <B>' + CAST((@totalDDBPath-@warningDDBPath-@criticalDDBPath-@unknownDDBPath) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Warning : <B>' + CAST(@warningDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Critical : <B>' + CAST(@criticalDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += CASE WHEN @unknownDDBPath > 0 THEN '<BR/>Excluded : <B>' + CAST(@unknownDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp' ELSE '' END
			END
		ELSE
			SET @tmpReason =  'There is no DDB path configured.<BR/>'
		SELECT @tmpRemarks =
		CASE
			WHEN @totalDDBPath = 0 THEN @infoMessage
			WHEN @totalDDBPath > 0 AND @criticalDDBPath = 0 AND @warningDDBPath = 0 THEN @goodMessage
			ELSE @warningMessage
		END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (select COUNT(*) FROM @DDBPathUsage where percentFree < @i_percentFree) > 0) OR
				(@i_Operator = 1 AND (select COUNT(*) FROM @DDBPathUsage where percentFree > @i_percentFree) > 0) OR
				(@i_Operator = 2 AND (select COUNT(*) FROM @DDBPathUsage where percentFree = @i_percentFree) > 0) OR
				(@i_Operator = 8 AND (select COUNT(*) FROM @DDBPathUsage where percentFree <>@i_percentFree) > 0))
			BEGIN
				DECLARE @noOfDDBPath INT
				SELECT @noOfDDBPath = COUNT(*) FROM @DDBPathUsage
				WHERE  ((@i_Operator = 0 AND percentFree < @i_percentFree) OR (@i_Operator = 1 AND percentFree > @i_percentFree)
					 OR (@i_Operator = 2 AND percentFree = @i_percentFree) OR (@i_Operator = 8 AND percentFree <>@i_percentFree)) AND percentFree > -1
				INSERT INTO #resultTbl (Result) VALUES (@noOfDDBPath)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> DDB path on CommCell <b>' + CommServeName + '</b> that have free disk space ' +
					CASE @i_operator WHEN 0 THEN 'less than ' WHEN 1 THEN 'more than ' WHEN 2 THEN 'equal to ' WHEN 8 THEN 'not equal to ' END + '<b>' + @i_paramValue + '%</b>.<br/>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (@i_status = 'Critical' AND @tmpStatus = 'Critical' OR
			@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical') OR
			@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical'))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'DDB Disk Space Utilization of CommCell <b>' + CommServeName + '</b> is at <b>'+ @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 60
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WITH(NOLOCK) WHERE QueryId = 209
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WITH(NOLOCK) WHERE QueryId = 209
		SET @tmpStatus = 'Info'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		declare @criticalBkpCopyNum int = 0
		declare @warningBkpCopyNum int = 0
		declare @totalBkpCopyNum int = 0
		DECLARE @utcTimeNow BIGINT = (SELECT dbo.getUnixTimeBig(GETUTCDATE()))
		SELECT
			@totalBkpCopyNum = COUNT(*),
			@warningBkpCopyNum = SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= @warningThreshold AND ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) <= @criticalThreshold THEN 1 ELSE 0 END),
			@criticalBkpCopyNum = SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) > @criticalThreshold THEN 1 ELSE 0 END)
		FROM cf_SurveyFallenBehindBackupCopies AS csInfo WITH (NOLOCK)
		WHERE CommservUniqueId = @i_CommServUniqueId
		SET @tmpStatus =
			CASE
				WHEN @criticalBkpCopyNum > 0 THEN 'Critical'
				WHEN @warningBkpCopyNum > 0 THEN 'Warning'
				WHEN @totalBkpCopyNum > 0 THEN 'Info'
				ELSE 'Good'
			END
		IF (@totalBkpCopyNum > 0)
			BEGIN
				SET @tmpReason = 'Backup Copies: <br/>'
				SET @tmpReason += 'Total: <B>'+ CAST(@totalBkpCopyNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Info: <B>' + CAST((@totalBkpCopyNum-@warningBkpCopyNum-@criticalBkpCopyNum) AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Warning: <B>' + CAST(@warningBkpCopyNum AS NVARCHAR(5)) + '</B>  '
				SET @tmpReason += 'Critical: <B>' + CAST(@criticalBkpCopyNum AS NVARCHAR(5)) + '</B>  '
			END
		ELSE
			SET @tmpReason =  'There are no Fallen Behind Backup Copy Jobs.<br/>'
		SET @tmpRemarks =
			CASE
				WHEN @totalBkpCopyNum = 0 THEN @goodMessage
				WHEN @criticalBkpCopyNum = 0 AND @warningBkpCopyNum = 0 THEN  @infoMessage
				WHEN @criticalBkpCopyNum = 0 THEN @warningMessage
				ELSE @criticalMessage
			END
		IF (@i_status = '')
		BEGIN
			DECLARE @noOfCopies INT
			SELECT
				@noOfCopies = COUNT(*)
			FROM cf_SurveyFallenBehindBackupCopies AS csInfo WITH (NOLOCK)
			WHERE CommservUniqueId = @i_CommServUniqueId
					AND ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= CAST(@i_ParamValue AS INT)
			IF (@noOfCopies > 0)
			BEGIN
				INSERT INTO #resultTbl (Result) VALUES (@noOfCopies)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WITH(NOLOCK) WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> backup copies on CommCell <b>' + CommServeName + '</b> that have fallen behind <b>' + CAST(@i_ParamValue AS VARCHAR(32)) + '</b> or more days'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Info' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WITH(NOLOCK) WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = @i_ParamName + ' of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 57
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 186
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 186
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalTapeLib     int = 0
		DECLARE @goodTapeLib      int = 0
		DECLARE @warningTapeLib   int = 0
		DECLARE @criticalTapeLib  int = 0
		DECLARE @unknownTapeLib   int = 0
		DECLARE @InfoTapeLib      int = 0
		DECLARE @LibraryInfo TABLE
		(
			LibraryId		INT,
			MonthlyGrowth	FLOAT,
			DaysToBeFull	BIGINT,
            UsedTapeCount	FLOAT,
            SpareTapeCount	FLOAT,
            TotalTapeCount	FLOAT,
            LogDateUTC		DATETIME
		)
		INSERT INTO @LibraryInfo
		SELECT	L.LibraryId, 0, -1, L.UsedTapeCount, L.SpareTapeCount, (L.UsedTapeCount + L.SpareTapeCount), R.LogDateUTC
		FROM	cf_SurveyTapeUsageByLibrary AS L WITH (NOLOCK)
				INNER JOIN @TblLatestResult AS R ON R.SurveyResultId = L.SurveyResultId AND R.QueryID = 186
				INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK) ON @i_CommServUniqueId = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
		DELETE FROM #GrowthData
		DELETE FROM #GrowthRate
		INSERT INTO #GrowthData
        SELECT  S.CommServUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), S.UsedTapeCount,
				ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
        FROM    cf_SurveyMonthlyTapeUsageByLibrary S WITH (NOLOCK)
                INNER JOIN @LibraryInfo T ON S.CommservUniqueId = @i_CommServUniqueId AND S.LibraryId = T.LibraryId
        WHERE   S.MonthStart >= @FirstMonth AND S.UsedTapeCount > 0 AND T.TotalTapeCount > 0
		EXEC GetLinearGrowthRate 0
		UPDATE	S SET MonthlyGrowth = T.GrowthRate
		FROM	@LibraryInfo S
				INNER JOIN #GrowthRate T ON @i_CommServUniqueId = T.CommservUniqueId AND S.LibraryId = T.EntityId
		UPDATE	@LibraryInfo
        SET     DaysToBeFull = CASE
					WHEN 30.0*SpareTapeCount > MonthlyGrowth*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
					ELSE 30.0*SpareTapeCount/MonthlyGrowth - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
		WHERE	ABS(ISNULL(MonthlyGrowth, -1)) > 0.001 AND SpareTapeCount > 0
		SET @totalTapeLib    = (SELECT COUNT(LibraryId) FROM @LibraryInfo)
		SET @goodTapeLib	 = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount > 0 AND (DaysToBeFull > @warningThreshold OR DaysToBeFull = -1))
		SET @warningTapeLib	 = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount > 0 AND DaysToBeFull BETWEEN @criticalThreshold AND @warningThreshold)
		SET @criticalTapeLib = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount > 0 AND DaysToBeFull < @criticalThreshold AND DaysToBeFull <> -1)
		SET @InfoTapeLib	 = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount = -1 AND SpareTapeCount = -1)
		SET @unknownTapeLib  = (SELECT COUNT(LibraryId) FROM @LibraryInfo WHERE TotalTapeCount <= 0 AND SpareTapeCount <> -1)
		SELECT
			@tmpStatus =
			CASE
				WHEN @totalTapeLib = 0 THEN 'Info'
				WHEN @totalTapeLib = @InfoTapeLib THEN 'Info'
				WHEN @totalTapeLib = @unknownTapeLib THEN 'Unknown'
				WHEN @criticalTapeLib > 0 THEN 'Critical'
				WHEN @warningTapeLib > 0 THEN 'Warning'
				ELSE 'Good'
			END
		IF (@totalTapeLib > 0)
			BEGIN
				SET @tmpReason = 'Tape Library distribution by estimated days to be full: <BR/>'
				SET @tmpReason += 'Total : <B>'+ CAST(@totalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Good : <B>' + CAST(@goodTapeLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Warning : <B>' + CAST(@warningTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Critical : <B>' + CAST(@criticalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += '<BR/>Info : <B>' + CAST(@InfoTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
				SET @tmpReason += 'Unknown : <B>' + CAST(@unknownTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
			END
		ELSE
			SET @tmpReason =  'There is no tape library configured.<BR/>'
		SELECT @tmpRemarks =
		CASE
			WHEN @totalTapeLib = 0 THEN @infoMessage
			WHEN @totalTapeLib > 0 AND @totalTapeLib = @unknownTapeLib THEN @infoMessage+'<VDL>'
			WHEN @totalTapeLib > 0 AND @criticalTapeLib = 0 AND @warningTapeLib = 0 THEN @goodMessage
			ELSE @warningMessage
		END
		IF (@i_status = '')
		BEGIN
			IF ((@i_Operator = 0 AND (SELECT COUNT(LibraryId) FROM @LibraryInfo where DaysToBeFull != -1 AND DaysToBeFull < @i_paramValue) > 0) OR
				(@i_Operator = 1 AND (SELECT COUNT(LibraryId) FROM @LibraryInfo where DaysToBeFull  = -1  OR DaysToBeFull > @i_paramValue) > 0) OR
				(@i_Operator = 2 AND (SELECT COUNT(LibraryId) FROM @LibraryInfo where DaysToBeFull  = @i_paramValue) > 0) OR
				(@i_operator = 8 AND (SELECT COUNT(LibraryId) FROM @LibraryInfo where DaysToBeFull  <> @i_ParamValue) > 0) )
			BEGIN
				SELECT @daysToBeFull = COUNT(LibraryId) FROM @LibraryInfo where ((@i_Operator = 0 AND DaysToBeFull != -1 AND DaysToBeFull < @i_paramValue) OR (@i_Operator = 1 AND (DaysToBeFull > @i_paramValue OR DaysToBeFull = -1)) OR (@i_Operator = 2 AND DaysToBeFull = @i_paramValue))
				INSERT INTO #resultTbl (Result) VALUES (@daysToBeFull)
				UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
				UPDATE #resultTbl SET Result = 'There are <b>' + Result +'</b> Tape Libraries on CommCell <b>' + CommServeName + '</b> that are estimated to be full in ' +
					CASE @i_operator WHEN 0 THEN 'less than' WHEN 1 THEN 'greater than' WHEN 2 THEN 'equal to' WHEN 8 THEN 'not equal to'  END + ' <b>' + @i_paramValue + ' days</b>'
				UPDATE #resultTbl SET Reason = @tmpReason
				UPDATE #resultTbl SET Remarks = @tmpRemarks
			END
		END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Tape Library Growth of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 46
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 161
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 161
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @totalSearchEngine      int = 0
        DECLARE @warningSearchEngine    int = 0
        DECLARE @criticalSearchEngine   int = 0
        DECLARE @goodSearchEngine       int = 0
        --DECLARE @infoSearchEngine     int = 0
        DECLARE @segCountCritical INT  =75
        DECLARE @segCountWarning INT  = 50
        DECLARE @tiiFileSizeCritical INT  = 600
        DECLARE @tiiFileSizeWarning INT  = 500
        DECLARE @docCountCritical INT  = 30000000
        DECLARE @docCountWarning  INT  = 20000000
        DECLARE @driveFreeSpaceCritical INT  = 35
        DECLARE @driveFreeSpaceWarning INT  = 50
        --Disk space free: good:   > 25%   warning: 10 � 25%, critical < 10%
        DECLARE @SearchEngineHealthNodeStatus TABLE
        (
        status NVARCHAR(MAX)
        )
        INSERT INTO @SearchEngineHealthNodeStatus
        SELECT
            CASE WHEN (  csInfo.SegmentCount                             >   @segCountCritical
                        OR  csInfo.TermIndexFileSizeMB                      >   @tiiFileSizeCritical
                        OR  csInfo.DocumentCount                            >   ISNULL(csInfo.DocMaxCriticalLimit,@docCountCritical)
                        OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >     csInfo.FreeSpaceMB
                        OR  csInfo.FreeSpaceMB = 0
                    )
                THEN 'Critical'
                WHEN (  csInfo.SegmentCount                                 >=  @segCountWarning
                        OR  csInfo.TermIndexFileSizeMB                      >=  @tiiFileSizeWarning
                        OR  csInfo.DocumentCount                            >=  ISNULL(csInfo.DocMaxWarningLimit,@docCountWarning)
                        OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    > csInfo.FreeSpaceMB
                    )
                THEN 'Warning'
            ELSE 'Good'
            END
        FROM
            cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
                INNER JOIN @TblLatestResult AS result
                    ON result.SurveyResultId = csInfo.SurveyResultId
                    AND result.QueryID = 161
        SET @totalSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus)
        SET @criticalSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status ='Critical')
        SET @warningSearchEngine = (SELECT COUNT(*) FROM @SearchEngineHealthNodeStatus where status ='Warning')
        SET @goodSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status ='Good')
        --SET @infoSearchEngine = (select COUNT(*) FROM @SearchEngineHealthNodeStatus where status =@strInfo)
        SELECT
            @tmpStatus =
            CASE
            --  WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine THEN @strInfo
                        WHEN @totalSearchEngine = 0 THEN 'Info'
                WHEN @criticalSearchEngine > 0 THEN 'Critical'
                WHEN @warningSearchEngine > 0 THEN 'Warning'
                ELSE 'Good'
            END
        --IF (@totalSearchEngine > 0 AND @totalSearchEngine>@infoSearchEngine)
        IF (@totalSearchEngine > 0 )
            BEGIN
                SET @tmpReason = 'Search Clouds: <BR/>'
                SET @tmpReason += 'Total : <B>'+ CAST(@totalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                SET @tmpReason += 'Good : <B>' + CAST(@goodSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                SET @tmpReason += 'Warning : <B>' + CAST(@warningSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                SET @tmpReason += 'Critical : <B>' + CAST(@criticalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
            END
        ELSE
            SET @tmpReason =  'No Search Clouds are configured.<BR/>'
        SELECT @tmpRemarks =
        CASE
            WHEN @criticalSearchEngine > 0 THEN @criticalMessage
            WHEN @warningSearchEngine  > 0 THEN @warningMessage
        --  WHEN @totalSearchEngine = 0 OR @totalSearchEngine =@infoSearchEngine  THEN @infoMessage
            WHEN @totalSearchEngine = 0 THEN @infoMessage
            ELSE @goodMessage
        END
		IF ((@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
			(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
			(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Search Engine of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus +'</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	ELSE IF @i_ParamId = 64
	BEGIN
		SELECT @warningThreshold = WarningThreshold, @criticalThreshold = CriticalThreshold FROM cf_SurveyHealthParam WHERE QueryId = 39
		SELECT @goodMessage = GoodMessage, @warningMessage = WarningMessage, @criticalMessage = CriticalMessage, @infoMessage = InfoMessage FROM cf_SurveyHealthParam WHERE QueryId = 39
		SET @tmpStatus = 'Good'
		SET @tmpReason = ''
		SET @tmpRemarks = ''
		DECLARE @InfoCounts INT = 0
		DECLARE @WarningCounts INT = 0
		DECLARE @CriticalCounts INT = 0
		SELECT	@InfoCounts = ISNULL(P.[1], 0), @WarningCounts = ISNULL(P.[2], 0), @CriticalCounts = ISNULL(P.[3], 0)
		FROM	(SELECT Info.Severity, COUNT(*) AS Counts
				FROM	@TblLatestResult R
					INNER JOIN cf_SurveyDATroubleshootingInfo Info ON R.SurveyResultId = Info.SurveyResultId
				GROUP BY Info.Severity) S
				PIVOT (
					MAX(Counts) FOR Severity IN ([1], [2], [3])
				) P
		SELECT
			@tmpStatus =
			CASE
				WHEN @CriticalCounts > 0 THEN 'Critical'
				WHEN @WarningCounts > 0 THEN 'Warning'
				WHEN @InfoCounts > 0 THEN 'Info'
				ELSE 'Good'
			END,
			@tmpReason =
			CASE WHEN (@InfoCounts + @WarningCounts + @CriticalCounts) = 0 THEN 'There are no Data Aging troubleshooting information.<DELIM>'
				 ELSE 'Mount paths: <DELIM>'
					+ 'Total: <B>'+ CAST((@InfoCounts + @WarningCounts + @CriticalCounts) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Info: <B>' + CAST(@InfoCounts AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Warning: <B>' + CAST(@WarningCounts AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Critical: <B>' + CAST(@CriticalCounts AS NVARCHAR(5)) + '</B>'
			END,
			@tmpRemarks =
			CASE
				WHEN @CriticalCounts > 0 THEN @criticalMessage
				WHEN @WarningCounts > 0 THEN @warningMessage
				WHEN @InfoCounts > 0 THEN @infoMessage
				ELSE @goodMessage
			END
		IF (	(@i_status = 'Critical' AND @tmpStatus = 'Critical') OR
				(@i_status = 'Warning' AND (@tmpStatus = 'Warning' OR @tmpStatus = 'Critical')) OR
				(@i_status = 'Good' AND (@tmpStatus = 'Good' OR @tmpStatus = 'Warning' OR @tmpStatus = 'Critical')))
		BEGIN
			INSERT INTO #resultTbl (Result) VALUES (@tmpStatus)
			UPDATE #resultTbl SET CommServeName = (SELECT TOP 1 CommServName FROM cf_CommCellIdNameMap WHERE ID = @i_CommServUniqueId)
			UPDATE #resultTbl SET Result = 'Index Cache Location of CommCell <b>' + CommServeName + '</b> is at <b>' + @tmpStatus + '</b> status'
			UPDATE #resultTbl SET Reason = @tmpReason
			UPDATE #resultTbl SET Remarks = @tmpRemarks
		END
	END
	SET @query = 'SELECT Result,
					ISNULL(CommServeName, '''') AS "CommServeName",
					CASE WHEN ISNULL(Reason, '''') = '''' THEN ''None'' ELSE Reason END AS "Reason",
					CASE WHEN ISNULL(Remarks, '''') = '''' THEN ''None'' ELSE Remarks END AS "Remarks"
					FROM #resultTbl'
	EXEC sp_executesql @query
	IF object_id('tempdb.dbo.#resultTbl') is not null DROP TABLE #resultTbl
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'RptGetServerHealthAlrm')
	delete from GxQscripts where name = 'RptGetServerHealthAlrm'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServerHealthAlrm')
	delete from GXDBVersions where aliasname = 'RptGetServerHealthAlrm'
GO

insert into GXDBVersions values(2, 'RptGetServerHealthAlrm',  'v1.15.2.93.4.3', 'RptGetServerHealthAlrm', 'v1.15.2.93.4.3')
GO

