

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetServerHealth.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Parveen Kumar
--	Date:   10/31/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetServerHealth.sp,v $ $Id: RptGetServerHealth.sp,v 1.1.2.75.4.3 2021/06/02 19:03:11 mmansano Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetServerHealth')
BEGIN
	print '>>> Drop Stored Procedure: RptGetServerHealth <<<'
	drop procedure RptGetServerHealth
END
IF EXISTS (select * from GxQscripts where name='RptGetServerHealth')
	delete from GxQscripts where name = 'RptGetServerHealth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServerHealth')
	delete from GXDBVersions where aliasname = 'RptGetServerHealth'
GO
print '... Creating Procedure: RptGetServerHealth'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetServerHealth
  @i_CommServUniqueId INTEGER = 0,
  @i_userId INTEGER = NULL,
  @i_GroupId INTEGER = NULL,
  @i_IsLocal INTEGER = 0,
  @i_aggregate INTEGER = 0
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
		DECLARE @strGood		VARCHAR(10) = '1_Good'
		DECLARE @strInfo		VARCHAR(10) = '2_Info'
		DECLARE @strwarning		VARCHAR(10) = '3_Warning'
		DECLARE @strCritical	VARCHAR(10) = '4_Critical'
		DECLARE @strUnknown		VARCHAR(10) = '0_Unknown'
		DECLARE @NA  BIGINT =CAST(0x7FFFFFFFFF AS bigint)
		DECLARE @Never  BIGINT= CAST(0x7FFFFFFFFF AS bigint)-1
		--Set Deafult to Backup Job Statistics
		DECLARE @queryId			INT = 12
		DECLARE @parameterName		NVARCHAR(256)
		DECLARE @warningThreshold	INT
		DECLARE @criticalThreshold	INT
		DECLARE @infoMessage		NVARCHAR(MAX)
		DECLARE @goodMessage		NVARCHAR(MAX)
		DECLARE @warningMessage		NVARCHAR(MAX)
		DECLARE @criticalMessage	NVARCHAR(MAX)
		DECLARE @showHiddenLibraries INT = 0
		DECLARE @useStoredPrediction BIT = ISNULL((SELECT Value from cf_SurveyConfig WHERE Name = 'useStoredPrediction'), 0)
		-- Create tmp predict table to store calculated predicted data
		IF object_id('tempdb.dbo.#PredictionData') is not null DROP TABLE #PredictionData
		CREATE TABLE #PredictionData (
			CommServUniqueId INT,
			EntityId INT,
			EntityName NVARCHAR(max),
			DaysToBeFull BIGINT
		)
	DECLARE @CurrWeek DATE = DATEADD(WEEK, DATEDIFF(WEEK, 0, GETDATE()), 0)
	DECLARE @MaxNumOfWeeksforGrowthRate INT = 12
	DECLARE @FirstWeek DATE = DATEADD(WEEK, -@MaxNumOfWeeksforGrowthRate, @CurrWeek)
		IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
			SET @showHiddenLibraries = 1
		DECLARE @MaxNumOfMonthsforGrowthRate INT = 6
		DECLARE @CurrMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
		DECLARE @FirstMonth DATE = DATEADD(MONTH, -@MaxNumOfMonthsforGrowthRate, @CurrMonth)
		IF object_id('tempdb.dbo.#GrowthData') IS NOT null DROP TABLE #GrowthData
		CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
		IF object_id('tempdb.dbo.#GrowthRate') IS NOT null DROP TABLE #GrowthRate
		CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
		IF object_id('tempdb.dbo.#TblSurveyResult') is not null DROP TABLE #TblSurveyResult
		CREATE TABLE #TblSurveyResult
		(
			CommServUniqueId INTEGER NOT NULL,
			GroupId INTEGER NOT NULL,
			GroupName NVARCHAR(MAX) NOT NULL,
			MonitorId INTEGER NOT NULL,
			Monitor NVARCHAR(MAX) NOT NULL,
			Status VARCHAR(10) NOT NULL,
			LogDate DATETIME DEFAULT NULL,
			Result NVARCHAR(MAX) DEFAULT '',
			ExpectedResult NVARCHAR(MAX) DEFAULT '',
			Recommendation NVARCHAR(MAX) DEFAULT '',
			GroupSortOrder INT,
			MonitorSortOrder INT,
			ParamId INT DEFAULT 0
		)
		IF object_id('tempdb.dbo.#commcells') is not null DROP TABLE #commcells
		CREATE TABLE #commcells (CCUID INT, CommServVersion VARCHAR(100), LogDate datetime,Version int)
		IF @i_GroupId IS NULL
			SET @i_GroupId = 0
		INSERT INTO #commcells(CCUID, CommServVersion, LogDate,Version)
		SELECT CommServUniqueId, ISNULL(R.CommServVersion, ''), R.LogDate, CASE WHEN LEFT(R.CommServVersion,2) LIKE '11%' THEN 11
																				WHEN LEFT(R.CommServVersion,2) LIKE '9.%' THEN 9
																				WHEN LEFT(R.CommServVersion,2) LIKE '10%' THEN 10
																				ELSE 0 END
  FROM cf_SurveyResultFuncV1(@QueryId, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) R
			INNER JOIN cf_CommcellIdNameMap CC
				ON R.CommServUniqueId = CC.ID AND CC.CommCellSurveyServices & 1 = 1
		IF object_id('tempdb.dbo.#latestResults') IS NOT null DROP TABLE #latestResults
		CREATE TABLE #latestResults (CCUID INT, QueryId INT, SurveyResultId BIGINT, LogDateUTC DATETIME)
		INSERT INTO #TblSurveyResult(CommServUniqueId, GroupId, GroupName, MonitorId, Monitor, Status, GroupSortOrder, MonitorSortOrder)
		SELECT 	CC.CCUID, RS.GroupId, RS.GroupName, RS.QueryId, RS.Name, @strUnknown, RS.GroupSortOrder, RS.SurveySortOrder
		FROM
		(
			SELECT
				sGroup.SurveyGroupId AS GroupId,
				sGroup.Name AS GroupName,
				survey.QueryId,
				CASE WHEN LEN(map.ParameterName) > 0 THEN map.ParameterName ELSE survey.Name END AS Name,
				sGroup.SortOrder AS GroupSortOrder,
				map.SurveySortOrder AS SurveySortOrder
			FROM	cf_CommservSurveyQueries AS survey
			INNER JOIN dbo.RptGetMetricsQueryFlags(0) qflags
				ON survey.QueryId = qFlags.QueryId
			INNER JOIN cf_CommservSurveyGroupMap AS map
				ON map.SurveyId = survey.QueryId
				AND qflags.QueryFlags & 4 = 4
				AND map.GroupId <> 15 --Skip value assessment
			INNER JOIN cf_CommservSurveyGroups as sGroup
				ON sGroup.SurveyGroupId = map.GroupId
			WHERE (@i_aggregate <> 11 OR (@i_aggregate = 11 AND survey.QueryId IN (27, 31, 64, 96))) --pickup only important criteria
		) AS RS
		CROSS JOIN #commcells CC
		DELETE SR
		FROM #TblSurveyResult SR INNER JOIN #commcells CC
		ON SR.CommServUniqueId = CC.CCUID
		WHERE	(SR.MonitorId IN (211,212) AND (CC.CommServVersion LIKE '9%' OR CC.CommServVersion IN ('10', '10 SP1', '10 SP2', '10 SP3', '10 SP4', '10 SP5', '10 SP6')))
		IF @i_IsLocal <> 0
			DELETE FROM #TblSurveyResult where MonitorId in (12, 31) -- Skip Comcell version and DR tiles for local commcell
		DECLARE @tmpStatus VARCHAR(10) = @strInfo
		DECLARE @tmpLogDate VARCHAR(20)
		DECLARE @tmpResult NVARCHAR(MAX) = ''
		DECLARE @tmpRecommendation NVARCHAR(MAX) = ''
		DECLARE	HealthQueryCur CURSOR FAST_FORWARD FOR
		SELECT	QueryId,
				ParameterName,
				WarningThreshold,
				CriticalThreshold,
				InfoMessage,
				GoodMessage,
				WarningMessage,
				CriticalMessage
		FROM cf_ReportParameterView where ParamId < 700	-- Excluding scale statistics sub params from 700 to 714
			AND QueryId NOT IN (SELECT SurveyId FROM cf_CommservSurveyGroupMap WHERE GroupId = 15)	--Excluding Value Assessment
			AND (@i_aggregate <> 11 OR (@i_aggregate = 11 AND QueryId IN (27, 31, 64, 96))) --pickup only important criteria
		OPEN HealthQueryCur
		FETCH NEXT FROM HealthQueryCur
		INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @tmpStatus = @strInfo
			SET @tmpResult = ''
			SET @tmpRecommendation = @infoMessage
			INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
			SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(@queryId, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
				INNER JOIN #commcells CC
					ON CC.CCUID = Res.CommServUniqueId
			--Simpana Service Pack Stats
			IF @queryId = 12 AND @i_IsLocal = 0
			BEGIN
				DECLARE @warningSPForCS INT = 5, @criticalSPForCS INT = 6
				--CommServer  :      Compared with currently available Feature Release for customers
				--1. good	:	Current OR (Last 5 non-LTS)
				--3. critical	:	(6 or more non-LTS SP older)
				DECLARE @warningLTSForCS INT = 8, @criticalLTSForCS INT = 16
				--CommServer  :      Compared with currently available LTS Feature Release for customers
				--1. good	:	Current OR (Last 2 LTS)
				--2. warning	:      (Last 3rd-4th LTS)
				--3. critical	:	(older than last 4 LTS)
				DECLARE @warningMRForCS INT = 13, @criticalMRForCS INT = 20
				--CommServer  :      Compared with currently available Maintenance Release for customers
				--1. good	:	Current OR (Last 12 Maintenance Releases)
				--2. warning	:      (Last 13-20 Maintenance Releases)
				--3. critical	:	(older than last 20 Maintenance Releases)
				DECLARE @warningSPForMA INT = 2, @criticalSPForMA INT = 3
				--Media Agent :      Compared with Feature Release of CommServer
				--1. good     :      Current OR (Last 2 non-LTS) with a grace period of 30 days
				--2. warning  :      (Last 2 non-LTS) with a grace period within 30 days - 60 days
				--3. critical :      (more than 2 non-LTS SP older) or more than 60 days of CommServer upgrade
				DECLARE @warningLTSForMA INT = 8, @criticalLTSForMA INT = 16
				--Media Agent :      Compared with LTS Feature Release of CommServer
				--1. good     :      Current OR (Last 2 LTS) with a grace period of 30 days
				--2. warning  :      (Last 2 LTS) with a grace period within 30 days - 60 days
				--3. critical :      (more than 2 LTS SP older) or more than 60 days of CommServer upgrade
				DECLARE @warningMRForMA INT = 6, @criticalMRForMA INT = 10
				--MediaAgent  :      Compared with Maintenance Release of CommServer
				--1. good     :      Current OR (Last 5 Maintenance Releases) with grace period of 30 days
				--2. warning  :      (Last 6-10 Maintenance Releases) with grace period within 30 - 60 days
				--3. critical :      (older than last 10 Maintenance Releases) with grace period ovre 60 days
				DECLARE @warningSPForServers INT = 2, @criticalSPForServers INT = 4
				--Servers     :      Compared with Feature Release of CommServer
				--1. good     :      Current OR (Last 2 non-LTS) with a grace period of 60 days
				--2. warning  :      (Last 2-4 non-LTS) with a grace period within 60 - 120 days
				--3. critical :      (more than 4 non-LTS SP older) or more than 120 days of CommServer upgrade
				DECLARE @warningLTSForServers INT = 8, @criticalLTSForServers INT = 8
				--Servers     :      Compared with LTS Feature Release of CommServer
				--1. good     :      Current OR (Last 2 LTS) with a grace period of 60 days
				--2. warning  :      (Last 2 LTS) with a grace period within 60 days - 120 days
				--3. critical :      (more than 2 LTS SP older) or more than 120 days of CommServer upgrade
				DECLARE @warningMRForServer INT = 24
				--Servers     :      Compared with Maintenance Release of CommServer
				--1. good     :      Current OR (Last 10 Maintenance Releases) with grace period of 60 days
				--2. warning  :      (Last 24 Maintenance Releases) with grace period more than 60 days
				IF object_id('tempdb.dbo.#CSVersionData') is not null DROP TABLE #CSVersionData
				CREATE TABLE #CSVersionData(CCUID INT, CSVersion VARCHAR(128), ReleaseNo INT, SPMajorNo INT, LatestSP INT, CSNeedUpdate INT DEFAULT 0, ServerNeedUpdate INT DEFAULT 0, LaptopNeedUpdate INT DEFAULT 0, MANeedUpdate INT DEFAULT 0, TotalClientNeedsUpdate INT DEFAULT 0, DeprecatedOS INT DEFAULT 0, MaintenancePack INT DEFAULT 0, FRUpgradeDays INT DEFAULT -1, MRUpgradeDays INT DEFAULT -1, SevenDaysAheadModifiedTime DATETIME)
				INSERT INTO #CSVersionData(CCUID, CSVersion, ReleaseNo, SPMajorNo, MaintenancePack, LatestSP, SevenDaysAheadModifiedTime)
					SELECT
						CCUID,
						C.CommServVersion, --Version String
						R.Release,
						R.ServicePack,
						R.MaintenanceRelease,
						CASE
							WHEN R.Release = 9 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '9_0_LatestSPMajorNo')
							WHEN R.Release = 10 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '10_0_LatestSPMajorNo')
							WHEN R.Release = 11 THEN (SELECT CAST(value AS INT) FROM cf_SurveyConfig WHERE name = '11_0_LatestSPMajorNo')
						END,
						DATEADD(Day, -7, C.ModifiedTime)
					FROM #commcells CC
						INNER JOIN cf_CommcellIdNameMap C
							ON CC.CCUID = C.ID
						CROSS APPLY dbo.SplitVersionString(C.CommServVersion) R
				UPDATE CSV
				SET FRUpgradeDays = Sub.FRUPDays
				FROM #CSVersionData CSV
				INNER JOIN (SELECT CCUID, ISNULL(DATEDIFF(Day, CAST(MIN(His.InstallTime) AS DATE), getdate()),-1) AS FRUPDays
							from #CSVersionData CSV
							INNER JOIN cf_SurveyResultFuncV1(38, 0, 1, null, null, @i_UserId, -1) Res ON Res.SurverResultId > 0 AND CSV.CCUID = Res.CommServUniqueId
							INNER JOIN cf_SurveyServicePackUpgradeHistory His WITH (NOLOCK) ON His.SurveyResultId = Res.SurverResultId
							WHERE His.Version = CSV.ReleaseNo AND His.servicePack = CSV.SPMajorNo
							GROUP BY CCUID) Sub ON Sub.CCUID = CSV.CCUID
				UPDATE CSV
				SET MRUpgradeDays = Sub.MRUPDays
				FROM #CSVersionData CSV
				INNER JOIN (SELECT CCUID, ISNULL(DATEDIFF(Day, CAST(MAX(His.InstallTime) AS DATE), getdate()),-1) AS MRUPDays
							from #CSVersionData CSV
							INNER JOIN cf_SurveyResultFuncV1(38, 0, 1, null, null, @i_UserId, -1) Res ON Res.SurverResultId > 0 AND CSV.CCUID = Res.CommServUniqueId
							INNER JOIN cf_SurveyServicePackUpgradeHistory His WITH (NOLOCK) ON His.SurveyResultId = Res.SurverResultId
							WHERE His.Version = CSV.ReleaseNo AND His.servicePack = CSV.SPMajorNo AND His.MaintenancePack = CSV.MaintenancePack
							GROUP BY CCUID) Sub ON Sub.CCUID = CSV.CCUID
				BEGIN --V11 SP5 and below
					UPDATE CSV
					SET
						CSV.CSNeedUpdate = CASE WHEN csInfo.ClientTypeId = 0 THEN csInfo.Total ELSE 0 END,
						CSV.ServerNeedUpdate = CASE WHEN csInfo.ClientTypeId = 1 THEN csInfo.Total ELSE 0 END,
						CSV.LaptopNeedUpdate = CASE WHEN csInfo.ClientTypeId = 2 THEN csInfo.Total ELSE 0 END,
						CSV.MANeedUpdate = CASE WHEN csInfo.ClientTypeId = 4 THEN csInfo.Total ELSE 0 END
					FROM #latestResults result
						INNER JOIN cf_SurveyUpdateStatus AS csInfo
							ON result.SurveyResultId = csInfo.SurveyResultId
						INNER JOIN #CSVersionData CSV
							ON CSV.CCUID = result.CCUID
					WHERE CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5) --V11 SP5 and below
					UPDATE CSV SET TotalClientNeedsUpdate = CSNeedUpdate + ServerNeedUpdate + LaptopNeedUpdate + MANeedUpdate
					FROM #CSVersionData CSV
					WHERE CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5) --V11 SP5 and below
					--Get final health status
					UPDATE CC SET CC.Status =
					CASE
						WHEN (CSV.LatestSP - CSV.SPMajorNo) >= @criticalSPForServers or CSV.TotalClientNeedsUpdate > 0 THEN @strCritical
						WHEN (CSV.LatestSP - CSV.SPMajorNo) >= @warningSPForServers AND (CSV.LatestSP - CSV.SPMajorNo) < @criticalSPForServers THEN @strwarning
						ELSE @strGood
					END
					FROM #TblSurveyResult CC
						INNER JOIN #CSVersionData CSV
							ON CSV.CCUID = CC.CommServUniqueId
					WHERE (CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5)) --V11 SP5 and below
					AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					--Get final health recommendation
					UPDATE CC SET CC.Recommendation =
					CASE
						WHEN (CSV.LatestSP - CSV.SPMajorNo) >= @criticalSPForCS THEN 'Lags behind by <b>' + CAST((CSV.LatestSP - CSV.SPMajorNo) AS VARCHAR(2)) + '</b> Feature Releases. ' + @warningMessage
						WHEN CSV.TotalClientNeedsUpdate > 0 THEN @criticalMessage
						WHEN ((CSV.LatestSP - CSV.SPMajorNo) >= @warningSPForCS) AND (CSV.LatestSP - CSV.SPMajorNo) < @criticalSPForCS THEN 'Lags behind by <b>' + CAST((CSV.LatestSP - CSV.SPMajorNo) AS VARCHAR(2)) + '</b> Feature Releases. ' + @warningMessage
						ELSE @goodMessage
					END
					FROM #TblSurveyResult CC
					INNER JOIN #CSVersionData CSV
						ON CC.CommServUniqueId = CSV.CCUID
					WHERE (CSV.ReleaseNo <= 10 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo <= 5)) --V11 SP5 and below
					AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				END
				BEGIN --V11 SP6 and above
					IF object_id('tempdb.dbo.#VersionAndServicePackTable') is not null DROP TABLE #VersionAndServicePackTable
					CREATE TABLE #VersionAndServicePackTable (CCUID INT, ClientId INT, CType INT, VersionInt INT, ServicePack INT, LatestServicePack INT, UPNumber INT, LatestUPNumber INT, IsMissingUpdates INT, StatusInt INT DEFAULT 2, IsLTS INT DEFAULT 0, IsDeprecatedOS INT DEFAULT 0)
					INSERT INTO #VersionAndServicePackTable(CCUID, ClientId, CType, VersionInt, ServicePack, LatestServicePack, UPNumber, LatestUPNumber, IsMissingUpdates, IsLTS, IsDeprecatedOS)
					SELECT CSV.CCUID, T.ClientId,
						CASE
							WHEN (C.type & 256)  = 256	THEN 1 --CS
							WHEN (C.type & (512|1024|2048|4096|8192)) > 0 THEN 5 --Infrastructure (512: Metrics Reporting, 1024: Web Server, 2048: Command Center, 4096: CommCell Console, 8192: WorkFlow Engine)
							WHEN (C.type & 2)    = 2	THEN 3 --MediaAgent
							WHEN (C.type & 1)    = 1	THEN 2 --Laptop
							ELSE 4 --Servers
						END,
						T.Version, T.ServicePack,
						(CASE
							WHEN T.Version = 11 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '11_0_LatestSPMajorNo' )
							WHEN T.Version = 10 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '10_0_LatestSPMajorNo' )
							WHEN T.Version = 9 THEN ( SELECT CAST(Value AS INT) FROM cf_SurveyConfig WHERE name LIKE '9_0_LatestSPMajorNo' )
							ELSE 0
						END),
						ISNULL(T.UPNumber, 0),
						ISNULL(R.LatestAvailableUPNumber, 0),
						CASE WHEN LEN(T.MissingUpdates) > 0 THEN 1 ELSE 0 END,
						ISNULL(R.IsLTS, 0),
						CASE WHEN C.ExceptionType & 1024 = 1024 THEN 1 ELSE 0 END AS IsDeprecatedOS --Deprecated Operation System
					FROM #CSVersionData CSV
					INNER JOIN cf_SurveyVersionAndServicePack T
						ON CSV.CCUID = T.CommServUniqueId
						AND CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
					INNER JOIN cf_SurveyClient C
						ON C.CommServUniqueId = T.CommServUniqueId
						AND C.ClientId = T.ClientId
						AND C.CommServUniqueId = CSV.CCUID
					LEFT OUTER JOIN cf_ReleaseUpdatePackInfo R
						ON (R.ReleaseId - 5) = T.Version
						AND R.ServicePack = T.ServicePack
					WHERE C.UninstallTime IS NULL AND C.Deleted=0 AND C.InstallStatus = 0
					--Delete all VM discovered clients which are not to be considered for this report
					DELETE T
					FROM #VersionAndServicePackTable T
						INNER JOIN cf_surveyclient C WITH (NOLOCK)
							ON T.CCUID = C.CommServUniqueId
							AND C.ClientId = T.ClientId
							AND C.type & 1 <> 1  --laptop bit is not set
							AND C.type & 4 = 4 --No pacakges bit is set
							AND C.type & 8 = 8 --VM discovered bit is set
					--CS
					UPDATE A SET
					StatusInt =
					(CASE
						WHEN (VersionInt < 11)
							THEN 4 --Critical: CommServ below Version 11 is not supported
						WHEN (IsLTS = 0 AND (LatestServicePack - A.ServicePack) >= @criticalSPForCS)
							OR (IsLTS = 1 AND (LatestServicePack - A.ServicePack) >= @criticalLTSForCS)
							THEN 4	--Critical: CommServ Feature Release is more than critical threshold
						WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - UPNumber >= @criticalMRForCS))
							THEN 4	--Critical: CommServ Maintenance Release is more than critical threshold for CS greater than V11 Sp14
						WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0)
							THEN 4	--Critical: For CommServ below V11 Sp14 if IsMissingUpdates set then it is considered critical
						WHEN (IsLTS = 0 AND (LatestServicePack - A.ServicePack) >= @warningSPForCS)
							OR (IsLTS = 1 AND (LatestServicePack - A.ServicePack) >= @warningLTSForCS)
							THEN 3  --Warning: CommServ Feature Release greater than the warning threshold
						WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (LatestUPNumber - UPNumber >= @warningMRForCS))
							THEN 3	--Warning: CommServ Maintenance Release is more than warning threshold for CS greater than V11 Sp14
						ELSE 2  --All good
					END)
					FROM #CSVersionData CSV
					INNER JOIN #VersionAndServicePackTable A
						ON CSV.CCUID = A.CCUID
					WHERE CType = 1
					--Infrastructure
					UPDATE A SET
					StatusInt =
					(CASE
						WHEN (VersionInt < CSV.ReleaseNo)
							THEN 4 --Critical: Infrastructure Client Version less than CommServ Version
						WHEN CSV.SPMajorNo > A.ServicePack
							THEN 4	--Critical: Infrastructure Client Feature Release not same as Commserv Feature Release
						WHEN ((VersionInt = 11 AND A.ServicePack >= 14 AND CSV.MaintenancePack - UPNumber > @warningMRForServer) OR ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0))
              				THEN 4 --Critical: Infrastructure Client for greater than V11 Sp14 exceeding the warning threshold and less than V11 SP14 having the is missing updates
						WHEN CSV.MRUpgradeDays > 30 AND CSV.MaintenancePack != UPNumber
							THEN 4 --Critical: CommServ Maintenance Release upgraded 60 days earlier and still Infrastructure client Maintenance Release is not in sync with CommServ
						ELSE 2  --All good
					END)
					FROM #CSVersionData CSV
					INNER JOIN #VersionAndServicePackTable A
						ON CSV.CCUID = A.CCUID
					WHERE CType = 5 AND IsDeprecatedOS = 0
					--Servers and Laptops
					UPDATE A SET
					StatusInt =
					(CASE
						WHEN (VersionInt < CSV.ReleaseNo)
							THEN 4 --Release is not supported. Critical
						WHEN (IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalSPForServers)
							OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalLTSForServers)
							THEN 4	--Critical : Server Feature Release is more than the critical thresholds
						WHEN CSV.FRUpgradeDays > 120 AND (CSV.SPMajorNo != A.ServicePack)
							THEN 4	--Critical : Feature Release on CommServ is upgraded 120 days before but Server is still not in sync with the CommServ
						WHEN ((IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @warningSPForServers)
							OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @warningLTSForServers)) AND CSV.FRUpgradeDays > 60 AND CSV.FRUpgradeDays <= 120
							THEN 3	--Warning : CommServ Feature Release upgraded in last 60 to 120 days and still Server Feature Release greater than the warning threshold but not same as CommServ
						WHEN (CSV.FRUpgradeDays > 60 AND CSV.FRUpgradeDays <= 120) AND (CSV.SPMajorNo != A.ServicePack)
							THEN 3 --Warning : CommServ Feature Release upgraded in last 60 to 120 days and still Server Feature Release is not in sync with CommServ
						WHEN ((VersionInt = 11 AND A.ServicePack >= 14 AND CSV.MaintenancePack - UPNumber >= @warningMRForServer) OR ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0))
							THEN 3 --Warning : For Server greater than V11 SP14 Maintenance Release is greater than warning threshold. For Server less than V11 SP14 we consider warning if the IsMissingUpdates is set.
						WHEN CSV.MRUpgradeDays > 60 AND (CSV.MaintenancePack != UPNumber)
							THEN 3 --Warning : Commserv Maintenance Release is not in sync with the Server even after the 60 days of CommServ Maintenance Release upgraded
						ELSE 2  --All good
					END)
					FROM #CSVersionData CSV
					INNER JOIN #VersionAndServicePackTable A
						ON CSV.CCUID = A.CCUID
					WHERE (CType = 4 OR CType = 2) AND IsDeprecatedOS = 0
					--MA
					UPDATE A SET
					StatusInt =
					(CASE
						WHEN (VersionInt < CSV.ReleaseNo)
							THEN 4 --Critical: Media Agent Version is less than the Commserv Version
						WHEN (IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalSPForMA)
							OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) >= @criticalLTSForMA)
							THEN 4	--Critical: Media Agent Feature Release is more than the critical thresholds
						WHEN CSV.FRUpgradeDays > 60 AND (CSV.SPMajorNo != A.ServicePack)
							THEN 4	--Critical: Feature Release on CommServ is upgraded 60 days before but Media Agent is still not in sync with the CommServ
						WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (CSV.MaintenancePack - UPNumber >= @criticalMRForMA))
							THEN 4	--Critical : Media Agent Maintenance Release is more than critical threshold for CS greater than V11 Sp14
						WHEN ((VersionInt < 11 OR (VersionInt = 11 AND A.ServicePack < 14)) AND IsMissingUpdates > 0)
							THEN 4	--Critical : For Media Agent below V11 Sp14 if IsMissingUpdates set then it is considered critical
						WHEN CSV.MRUpgradeDays > 60 AND (CSV.MaintenancePack != UPNumber)
							THEN 4 --Critical : CommServ Feature Release upgraded 60 days earlier and still Media Agent Feature Release is not in sync with CommServ
						WHEN ((IsLTS = 0 AND (CSV.SPMajorNo - A.ServicePack) <= @warningSPForMA)
							OR (IsLTS = 1 AND (CSV.SPMajorNo - A.ServicePack) <= @warningLTSForMA)) AND (CSV.SPMajorNo != A.ServicePack) AND CSV.FRUpgradeDays > 30 AND CSV.FRUpgradeDays <= 60
							THEN 3	--Warning : CommServ Feature Release upgraded in last 30 to 60 days and still Media Agent Feature Release less than the warning threshold but not same as CommServ
						WHEN (VersionInt = 11 AND A.ServicePack >= 14 AND (CSV.MaintenancePack - UPNumber) >= @warningMRForMA)
							THEN 3  --Warning : Media Agent Maintenance Release is more than warning threshold for CS greater than V11 Sp14
						WHEN (CSV.FRUpgradeDays > 30 AND CSV.FRUpgradeDays <= 60) AND (CSV.SPMajorNo != A.ServicePack)
							THEN 3	--Warning : CommServ Feature Release upgraded in last 30 to 60 days and still Media Agent Feature Release is not in sync with CommServ
						ELSE 2 --All good
					END)
					FROM #CSVersionData CSV
					INNER JOIN #VersionAndServicePackTable A
						ON CSV.CCUID = A.CCUID
					WHERE CType = 3 AND IsDeprecatedOS = 0
					--Make the laptops which are offline for 7 days as info
					UPDATE A SET
					StatusInt = 1
					FROM #VersionAndServicePackTable A
					INNER JOIN #CSVersionData CSV ON A.CCUID = CSV.CCUID
					INNER JOIN cf_SurveyClient C WITH (NOLOCK) ON CSV.CCUID = C.CommservUniqueId AND A.ClientId = C.ClientId
					WHERE CType = 2 AND StatusInt>2 AND IsDeprecatedOS = 0 AND ((C.LastOfflineTime > C.LastOnlineTime AND C.LastOfflineTime <= DATEADD(Day, -7, CSV.SevenDaysAheadModifiedTime))
		 				OR (C.LastOfflineTime is NOT NULL AND C.LastOnlineTime is NULL AND C.LastOfflineTime <= DATEADD(Day, -7, CSV.SevenDaysAheadModifiedTime)))
					UPDATE CSV SET
						CSV.CSNeedUpdate = sub.CSNeedUpdate,
						CSV.LaptopNeedUpdate = sub.LaptopNeedUpdate,
						CSV.MANeedUpdate = sub.MANeedUpdate,
						CSV.ServerNeedUpdate = sub.ServerNeedUpdate
					FROM #CSVersionData CSV
						INNER JOIN
						(SELECT
							V.CCUID,
							SUM(CASE WHEN CType = 1 THEN 1 ELSE 0 END) AS CSNeedUpdate,
							SUM(CASE WHEN CType = 2 THEN 1 ELSE 0 END) AS LaptopNeedUpdate,
							SUM(CASE WHEN CType = 3 THEN 1 ELSE 0 END) AS MANeedUpdate,
							SUM(CASE WHEN CType in (4, 5) THEN 1 ELSE 0 END) AS ServerNeedUpdate
						FROM #VersionAndServicePackTable V
						WHERE V.StatusInt IN (3, 4)
						GROUP BY V.CCUID) sub
							ON CSV.CCUID = sub.CCUID
					UPDATE CSV SET DeprecatedOS = sub.DeprecatedOS
					FROM #CSVersionData CSV
						INNER JOIN (SELECT V.CCUID, COUNT(*) AS DeprecatedOS  FROM #VersionAndServicePackTable V WHERE V.IsDeprecatedOS = 1 GROUP BY V.CCUID) sub
							ON CSV.CCUID = sub.CCUID
					UPDATE CSV SET TotalClientNeedsUpdate = CSNeedUpdate + ServerNeedUpdate + LaptopNeedUpdate + MANeedUpdate
					FROM #CSVersionData CSV
					WHERE CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
					--Get final health status
					UPDATE CC SET CC.Status = CASE sub.HealthStatus WHEN 4 THEN @strCritical WHEN 3 THEN @strwarning ELSE @strGood END
					FROM #TblSurveyResult CC
						INNER JOIN #CSVersionData CSV
							ON CSV.CCUID = CC.CommServUniqueId
						INNER JOIN
							(SELECT
								V.CCUID,
								MAX(StatusInt) AS HealthStatus
							FROM #VersionAndServicePackTable V
							GROUP BY V.CCUID) sub
								ON CSV.CCUID = sub.CCUID
					WHERE (CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6)) --V11 SP6 and above
					AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					--Get final health recommendation
					UPDATE CC SET CC.Recommendation =
					CASE
						WHEN Status IN (@strCritical, @strwarning) THEN 'View detailed report and install necessary updates.<BR/>'
						ELSE @goodMessage
					END
					FROM #TblSurveyResult CC
					INNER JOIN #CSVersionData CSV
						ON CC.CommServUniqueId = CSV.CCUID
					WHERE (CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6)) --V11 SP6 and above
					AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET CC.Recommendation = Recommendation + '<VDL><VDL_CR>VersionAndServicePackMetrics&input.CommservUniqueId='+ CAST(CC.CommServUniqueId AS NVARCHAR(10)) + '</VDL_CR>'
					FROM #TblSurveyResult CC
					INNER JOIN #CSVersionData CSV
						ON CC.CommServUniqueId = CSV.CCUID
					WHERE CSV.ReleaseNo > 11 OR (CSV.ReleaseNo = 11 AND CSV.SPMajorNo >= 6) --V11 SP6 and above
					AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					IF object_id('tempdb.dbo.#VersionAndServicePackTable') is not null DROP TABLE #VersionAndServicePackTable
				END
				--Final health outcome 1 all versions
				UPDATE CC
				SET Result = 'CommServe is on <b>version ' + C.CSVersion + '</b><DELIM>', LogDate = T.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #CSVersionData C
					ON C.CCUID = CC.CommServUniqueId
				INNER JOIN #commcells T
					ON C.CCUID = T.CCUID
					AND T.CCUID = CC.CommServUniqueId
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				--Final health outcome 2 all versions
				UPDATE CC
				SET Result = Result + 'Entities that need updates: ' + (CASE WHEN C.CSNeedUpdate > 0 THEN 'Commserv, <BR/>' ELSE '<BR/>' END)
				                    + 'Servers <b>' + CAST(ISNULL(C.ServerNeedUpdate, 0) AS VARCHAR(10)) + ' </b><BR/>'
				                    + 'Laptops <b>' + CAST(ISNULL(C.LaptopNeedUpdate, 0) AS VARCHAR(10)) + ' </b><BR/>'
				                    + 'MediaAgents <b>' + CAST(ISNULL(C.MANeedUpdate, 0) AS VARCHAR(10)) + ' </b><BR/>'
									+ CASE WHEN C.DeprecatedOS>0 THEN '<DELIM>Servers with deprecated Operating System: <b>' + CAST(ISNULL(C.DeprecatedOS, 0) AS VARCHAR(10)) + '</b><BR/>' ELSE '' END
				FROM #TblSurveyResult CC
				INNER JOIN #CSVersionData C
					ON C.CCUID = CC.CommServUniqueId
					AND C.TotalClientNeedsUpdate > 0
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CSVersionData') IS NOT null DROP TABLE  #CSVersionData
			END
			ELSE IF @queryId = 61
			BEGIN
				declare @MAStoreConfigResults table
				(
					CCUID INT,
					MediaAgentId int,
					LogDate dateTime,
					ValidSIDBCount int,
					Status int
				)
				INSERT INTO @MAStoreConfigResults
				SELECT
					sub.CommServUniqueId,
					sub.MediaAgentId,
					sub.LogDate,
					SUM(sub.IsValid),
					CASE
						WHEN SUM(sub.IsValid) > @criticalThreshold THEN 3
						WHEN SUM(sub.IsValid) >= @warningThreshold and SUM(sub.IsValid) <= @criticalThreshold THEN 2
						ELSE 1
					END
				FROM
				(
				SELECT
					csInfo.CommServUniqueId,
					csInfo.MediaAgentId,
					csInfo.LogDate,
					CASE
						WHEN csInfo.SealedStatus = 'Active' OR (csInfo.SIDBStoreStatus <> 1 AND csInfo.TotalRecords >= 100000000) THEN 1
						ELSE 0
					END AS 'IsValid'
				FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND	csInfo.MediaAgentId > 1
				) AS sub
				GROUP BY sub.CommServUniqueId,sub.MediaAgentId, sub.LogDate
				IF object_id('tempdb.dbo.#CCMaNum') is not null DROP TABLE #CCMaNum
				CREATE TABLE #CCMaNum(CCUID INT, totalMANum INT, logDate varchar(20))
				INSERT INTO #CCMaNum
				select CR.CCUID, ISNULL(COUNT(*), 0),ISNULL(MAX(CR.LogDate), ISNULL(MAX(CR.LogDate), MAX(cc.LogDate))) from @MAStoreConfigResults  cr inner join #commcells cc on cr.CCUID = cc.CCUID group by cr.CCUID
				UPDATE CC
					SET Status = @strInfo,
					Result =
						CASE WHEN (MA.totalMANum > 0) THEN 'MediaAgent(s) with DDB Partitions: <b>'+ CAST(MA.totalMANum AS NVARCHAR(5)) + '</b>'
							ELSE 'There are no MediaAgents hosting Deduplication Database.<DELIM>'
						END,
					Recommendation = CASE WHEN  (MA.totalMANum > 0) THEN @goodMessage
							ELSE @infoMessage
							END,
					logDate = MA.logDate
				FROM #TblSurveyResult CC INNER JOIN #CCMaNum MA ON CC.CommServUniqueId = MA.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strInfo,
				Result = 'There are no MediaAgents hosting Deduplication Database.<DELIM>',
				Recommendation = '',
				logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCMaNum') is not null DROP TABLE #CCMaNum
			END
			ELSE IF @queryId = 16
			BEGIN
				--Excluded from health tile. If reconsidered to bring it back, make it information tile.
				IF object_id('tempdb.dbo.#CCIdJobDetails') is not null DROP TABLE #CCIdJobDetails
				CREATE TABLE #CCIdJobDetails(CCUID INT, Status VARCHAR(10), logDate varchar(20), Result nvarchar(max), Recommendation nvarchar(max))
				insert INTO #CCIdJobDetails
				SELECT
					sub.CommServUniqueId,
						CASE
							WHEN sub.TotalJobs = 0 OR sub.SuccessRatePercent >= @warningThreshold THEN @strGood
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @strwarning
							ELSE @strCritical
						END,
						sub.LogDate,
						'Success Rate : <b>' + CASE WHEN sub.TotalJobs = 0 THEN 'N/A' ELSE CAST(sub.SuccessRatePercent AS NVARCHAR(MAX)) + ' %' END
						+ ' </b><DELIM>Total : <b>' + CAST(sub.TotalJobs AS NVARCHAR(100))
						+ '</b>, Successful : <b>' + CAST(sub.SuccessfulJobs AS NVARCHAR(100))
                        			+ '</b>, Failed : <b>' + CAST(sub.FailedJobs AS NVARCHAR(100))
                        			+ '</b>, Killed : <b>' + CAST(sub.KilledJobs AS NVARCHAR(100))
						+ '</b><DELIM>Completed with Errors : <b>' + CAST(sub.CompletedWithErrorJobs AS NVARCHAR(20))
						+ '</b>, Completed with Warning : <b>' + CAST(sub.CompletedWithWarningJobs AS NVARCHAR(20)) + '</b><DELIM>',
						CASE
							WHEN sub.TotalJobs = 0 OR sub.SuccessRatePercent >= @warningThreshold THEN @goodMessage
							WHEN sub.SuccessRatePercent >= @criticalThreshold THEN @warningMessage
							ELSE @criticalMessage
						END
				FROM
				(
					SELECT
						csInfo.CommServUniqueId,
						csInfo.LogDate,
						csInfo.ClientGroups,
						csInfo.TotalJobs,
						csInfo.SuccessfulJobs,
						ISNULL(csInfo.CompletedWithErrorJobs, 0) AS CompletedWithErrorJobs,
						ISNULL(csInfo.CompletedWithWarningJobs, 0) AS CompletedWithWarningJobs,
						ISNULL(csInfo.FailedJobs, 0) FailedJobs,
						ISNULL(csInfo.KilledJobs, 0) AS KilledJobs,
						CASE
                            			WHEN csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0) = 0 THEN 0
                            			ELSE CAST(((ISNULL(csInfo.CompletedWithErrorJobs, 0) + ISNULL(csInfo.CompletedWithWarningJobs, 0)+ ISNULL(csInfo.SuccessfulJobs, 0)) * 100.0)/(csInfo.TotalJobs - ISNULL(csInfo.KilledJobs, 0)) AS DECIMAL(7, 0))
						END AS SuccessRatePercent
					FROM cf_SurveyBkpJobStats AS csInfo WITH (NOLOCK)
						INNER JOIN #latestResults AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
				) AS sub
				UPDATE CC
					SET Status = JJ.Status,
						Result = JJ.Result,
						Recommendation = JJ.Recommendation,
						logDate = JJ.logDate
						FROM #TblSurveyResult CC
						INNER JOIN #CCIdJobDetails JJ
							ON CC.CommServUniqueId = JJ.CCUID
							WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CCIdJobDetails') is not null DROP TABLE #CCIdJobDetails
			END
			--Fallen Behind Storage policy copies
			ELSE IF @queryId = 64
			BEGIN
				IF object_id('tempdb.dbo.#dashCopySummary') is not null DROP TABLE #dashCopySummary
				CREATE TABLE #dashCopySummary
				(
					CCUID INT,
					spName nvarchar(255),
					copyName nvarchar(255),
					FallenBehindDays int,
					ToBeCopiedAppSizeGB bigint,
					AuxCopyAlertDays int,
					AuxCopyAlertGB bigint
				)
				INSERT INTO #dashCopySummary
				SELECT result.CCUID,
						C.PolicyName,
						C.CopyName,
						csInfo.FallenBehindDays,
						ISNULL(csInfo.TotalToBeCopiedJobsApplicationSizeGB, 0),
						ISNULL(csInfo.AuxCopyAlertDays, -1),
						ISNULL(csInfo.AuxCopyAlertGB, -1)
				FROM	cf_SurveyFallenBehindCopies AS csInfo WITH (NOLOCK)
						INNER JOIN #latestResults AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK)
							ON C.CommServUniqueId = result.CCUID AND C.CopyId = csInfo.CopyId
				WHERE csInfo.EstCompletionDateForAllData <> -1
				IF object_id('tempdb.dbo.#CCCopyNum') is not null DROP TABLE #CCCopyNum
				CREATE TABLE #CCCopyNum(CCUID INT, TotalCopyNum INT DEFAULT 0, GoodCopyNum INT DEFAULT 0, WarningCopyNum INT DEFAULT 0, CriticalCopyNum INT DEFAULT 0)
				INSERT INTO #CCCopyNum(CCUID, TotalCopyNum, WarningCopyNum, CriticalCopyNum)
					SELECT
						csInfo.CCUID,
						COUNT(csInfo.copyName) AS TotalCopyNum,
							SUM(CASE WHEN (csInfo.AuxCopyAlertGB <= 0 OR csInfo.ToBeCopiedAppSizeGB <= AuxCopyAlertGB)
							AND csInfo.AuxCopyAlertDays <= 0 AND csInfo.FallenBehindDays >= @warningThreshold AND csInfo.FallenBehindDays <= @criticalThreshold then 1 ELSE 0
						END) as WarningCopyNum,
						SUM(CASE WHEN AuxCopyAlertGB > 0 AND ToBeCopiedAppSizeGB > AuxCopyAlertGB
						 OR AuxCopyAlertDays > 0 AND FallenBehindDays > AuxCopyAlertDays
						 OR AuxCopyAlertDays < 0 AND FallenBehindDays > @criticalThreshold THEN 1 ELSE 0
						END) as CriticalCopyNum
					FROM #dashCopySummary AS csInfo
					GROUP BY csInfo.CCUID
				UPDATE #CCCopyNum SET GoodCopyNum = TotalCopyNum - (WarningCopyNum + CriticalCopyNum)
				UPDATE CC
					SET Status =
					CASE
						WHEN P.CriticalCopyNum > 0 THEN @strCritical
						WHEN P.WarningCopyNum > 0 THEN @strwarning
						ELSE @strGood
					END,
					Result =
					CASE
					WHEN (P.TotalCopyNum > 0)
						THEN  'Secondary Copies: <DELIM>' + 'Total: <B>'+ CAST(P.TotalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp' + 'Good: <B>' + CAST((P.GoodCopyNum) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(P.WarningCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(P.CriticalCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'There are no Fallen Behind Secondary Copies.<DELIM>'
					END,
					Recommendation =
					CASE
						WHEN P.TotalCopyNum= 0 THEN @infoMessage
						WHEN P.TotalCopyNum > 0 AND P.CriticalCopyNum = 0 AND P.WarningCopyNum = 0 THEN @goodMessage
					ELSE @warningMessage
					END,
					logDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCopyNum P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strGood,
				Result = 'There are no Fallen Behind Secondary Copies.<DELIM>',
				Recommendation = 'Up-To-Date.<DELIM>',
				logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#dashCopySummary') is not null DROP TABLE #dashCopySummary
				IF object_id('tempdb.dbo.#CCCopyNum') is not null DROP TABLE #CCCopyNum
			END
			--DDB Performance
			ELSE IF @queryId = 65
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'There are no Media Agents hosting DDB store.<DELIM>'
				SET @tmpRecommendation = @infoMessage
				declare @qiTime table
				(
					CCUID INT,
					SidbStoreId int,
					AvgQITime	bigint,
					PrimaryRecords	bigint,
					NeedUpgrade int
				)
				INSERT INTO @qiTime
				SELECT
						result.CCUID,
						csInfo.SidbStoreId,
						csInfo.AvgQITime,
						csInfo.PrimaryRecords,
						csInfo.NeedUpgrade
				FROM	cf_SurveyDDBPerformance AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId
				SET @criticalThreshold = 1800
				SET @warningThreshold = 1400
				IF object_id('tempdb.dbo.#CCDDBPerformance') is not null DROP TABLE #CCDDBPerformance
				CREATE TABLE #CCDDBPerformance(CCUID INT, totalNum INT, criticalNum INT, warningNum INT, goodNum INT )
				INSERT INTO #CCDDBPerformance(CCUID,totalNum,criticalNum,goodNum)
				SELECT csInfo.CCUID,
					COUNT(csInfo.SidbStoreId) as totalNum,
					sum(case when AvgQITime >= @criticalThreshold AND PrimaryRecords>=200000000 then 1 else 0 end) as criticalNum,
					sum(case when (AvgQITime <  @warningThreshold OR (AvgQITime >= @warningThreshold and AvgQITime < @criticalThreshold and PrimaryRecords<100000000)) AND NeedUpgrade = 0  THEN 1 ELSE 0 END) AS goodNum
				from @qiTime csInfo
				group by CCUID
				UPDATE #CCDDBPerformance SET warningNum = totalNum - (goodNum + criticalNum)
				UPDATE CC
					SET Status =
					CASE
						WHEN P.totalNum = 0 THEN @strInfo
						WHEN P.criticalNum > 0 THEN @strCritical
						WHEN P.warningNum > 0 THEN @strwarning
						ELSE @strGood
					END,
					Result =
					CASE
					WHEN (P.totalNum > 0)
						THEN  'DDBs: <DELIM>' + 'Total: <B>'+ CAST(P.totalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp' + 'Good: <B>' + CAST(P.goodNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>'  + CAST(P.warningNum  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(P.criticalNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'There are no Media Agents hosting DDB store.<DELIM>'
					END,
					Recommendation =
					CASE
						WHEN P.totalNum = 0 THEN @infoMessage
						WHEN P.totalNum > 0 AND P.criticalNum = 0 AND P.warningNum = 0 THEN @goodMessage
						ELSE @warningMessage
					END,
					logDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCDDBPerformance P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strGood,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCDDBPerformance') is not null DROP TABLE #CCDDBPerformance
			END
			--Low Disk Space
			ELSE IF @queryId = 70
			BEGIN
				declare @copiesSize table
				(
					CCUID INT,
					copyId int,
					percentFree decimal(10,2)
				)
				INSERT INTO @copiesSize
				SELECT	result.CCUID,
						csInfo.CopyId,
						case when SUM(ISNULL(csInfo.CapacityMB, 0)) > 0 THEN cast ((SUM(ISNULL(csInfo.FreeSpaceMB, 0)) *100.0 / SUM(ISNULL(csInfo.CapacityMB, 0)) ) AS decimal(10,2)) else '0' END AS percentFree
				FROM	cf_SurveyCopyFreeSpace AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId
				GROUP BY result.CCUID, csInfo.CopyId
				IF object_id('tempdb.dbo.#CCCopies') is not null DROP TABLE #CCCopies
				CREATE TABLE #CCCopies(CCUID INT, totalNCopies INT, warningCopies INT, criticalCopies INT, goodCopies INT )
				INSERT INTO #CCCopies(CCUID,totalNCopies,warningCopies,criticalCopies)
				SELECT csInfo.CCUID,
					COUNT(csInfo.CopyId) as totalNum,
					sum(case when percentFree >= @criticalThreshold and percentFree <= @warningThreshold then 1 else 0 end) as warningCopies,
					sum(case when percentFree < @criticalThreshold THEN 1 ELSE 0 END) AS criticalCopies
				from @copiesSize csInfo
				group by CCUID
				UPDATE #CCCopies SET goodCopies = totalNCopies - (warningCopies + criticalCopies)
				UPDATE CC
					SET Status =
					CASE
						WHEN P.criticalCopies > 0 THEN @strCritical
						WHEN P.warningCopies > 0 THEN @strwarning
						ELSE @strGood
					END,
					Result =
					CASE
					WHEN (P.totalNCopies > 0)
						THEN  'Storage Policy Copies: <DELIM>' + 'Total: <B>'+ CAST(P.totalNCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Good: <B>' + CAST((P.goodCopies) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(P.warningCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(P.criticalCopies AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'All Copies have sufficient space.<DELIM>'
					END,
					Recommendation =
					CASE
						WHEN P.totalNCopies = 0 THEN @infoMessage
						WHEN P.totalNCopies > 0 AND P.criticalCopies = 0 AND P.warningCopies = 0 THEN @goodMessage
						ELSE @warningMessage
					END,
					logDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCopies P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strGood,
				Result = 'All Copies have sufficient space.<DELIM>',
				Recommendation = 'Up-To-Date.<DELIM>',
				logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCCopies') is not null DROP TABLE #CCCopies
			END
			--RestoreStatistics
			ELSE IF @queryId = 17
			BEGIN
				--Excluded from health tile. If reconsidered to bring it back, make it information tile.
				IF object_id('tempdb.dbo.#CCRestoreSt') is not null DROP TABLE #CCRestoreSt
				CREATE TABLE #CCRestoreSt(CCUID INT, Status VARCHAR(10), Result nvarchar(max), Recommendation nvarchar(max))
				INSERT INTO #CCRestoreSt
				SELECT 	sub.CCUID,
							CASE
								WHEN sub.TotalRestoreClients = 0 OR sub.TotalSuccPct > @warningThreshold THEN @strGood --No Restores Jobs or All Restore Jobs success
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @strwarning
								ELSE @strCritical
							END,
							'Client Count with Restore jobs : '
							+ CASE WHEN sub.TotalRestoreClients = 0 THEN 'None' ELSE '<DELIM>Successful : <b>'
							+ CAST(SuccessfulClients AS VARCHAR(7)) + '(' + CAST(sub.SuccessPct AS VARCHAR(7))
							+ '%)</b>, Successful after failed jobs : <b>'
							+ CAST(sub.SuccAfterFailClients AS VARCHAR(7)) + '(' + CAST(sub.SuccAfterFailPct AS VARCHAR(7))
							+ '%)</b>, <DELIM>Failed or Killed : <b>'
							+ CAST(sub.FailedClients AS VARCHAR(7)) + '(' + CAST(sub.FailurePct AS VARCHAR(7)) + '%)</b>' END,
							CASE WHEN sub.TotalRestoreClients = 0 THEN @infoMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								WHEN sub.TotalSuccPct >= @warningThreshold THEN @goodMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								WHEN sub.TotalSuccPct >= @criticalThreshold THEN @warningMessage + '<VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
								ELSE @criticalMessage + ' <VDL><VDL_CR>Restore Statistics in the Last 90 Days Details&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
							END
				FROM	(SELECT
							CCUID,
							TotalRestoreClients,
							SuccessfulClients,
							CASE WHEN TotalRestoreClients>0
							THEN (100*SuccessfulClients)/TotalRestoreClients ELSE 0 END AS SuccessPct,
							SuccAfterFailClients,
							CASE WHEN TotalRestoreClients>0
							THEN (100*SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS SuccAfterFailPct,
							CASE WHEN TotalRestoreClients>0
							THEN 100*(SuccessfulClients + SuccAfterFailClients)/TotalRestoreClients ELSE 0 END AS TotalSuccPct,
							FailedClients,
							CASE WHEN TotalRestoreClients>0
							THEN (100*FailedClients)/TotalRestoreClients ELSE 0 END  AS FailurePct
						FROM
						(
							SELECT result.CCUID,(SuccessfulClients + SuccAfterFailClients + FailedClients) AS TotalRestoreClients,
							SuccessfulClients,
							SuccAfterFailClients,
							FailedClients
							FROM cf_SurveyRestoreClientStats AS csInfo WITH (NOLOCK)
							INNER JOIN #latestResults AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
						) SUB
						) AS sub
				UPDATE CC
					SET Status = JJ.Status,
						Result = JJ.Result,
						Recommendation = JJ.Recommendation,
						logDate = COM.LogDate
						FROM #TblSurveyResult CC
						inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
						INNER JOIN #CCRestoreSt JJ
							ON CC.CommServUniqueId = JJ.CCUID
						WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CCRestoreSt') is not null DROP TABLE #CCRestoreSt
			END
			--DeDup Backup Configuration
			ELSE IF @queryId = 66
			BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'There are no Media Agents hosting DDB store.<DELIM>'
				SET @tmpRecommendation = @infoMessage
				set @criticalThreshold = @criticalThreshold*24
				set @warningThreshold = @warningThreshold*24
				DECLARE @criticalValForTrasDDB int = 360	--15 Days
				DECLARE @warningValTrasDDB int = 192		--8 Days
				IF object_id('tempdb.dbo.#CCDeDupBackupConfig') is not null DROP TABLE #CCDeDupBackupConfig
				CREATE TABLE #CCDeDupBackupConfig(CCUID INT, totalDDBs INT, WarningDDBs INT, CriticalDDBs INT, GoodDDBs INT )
				INSERT INTO #CCDeDupBackupConfig(CCUID,totalDDBs,CriticalDDBs,WarningDDBs)
				SELECT csInfo.CommServUniqueId, COUNT(csInfo.SidbStoreName),
				 SUM(CASE
									WHEN csInfo.LastDDBBackupJobId =0 THEN 1
									WHEN ISNULL(csInfo.HoursSinceNoBackup,-1) = -1 THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalThreshold THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @criticalValForTrasDDB THEN 1
											ELSE 0
									END),
				SUM(CASE
									WHEN csInfo.LastDDBBackupJobId = 0 THEN 0
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 0 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalThreshold AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningThreshold THEN 1
									WHEN ISNULL(csInfo.IsTransactionBased, 0) = 1 AND ISNULL(csInfo.HoursSinceNoBackup,-1) <= @criticalValForTrasDDB AND ISNULL(csInfo.HoursSinceNoBackup,-1) > @warningValTrasDDB THEN 1
									ELSE 0
								END)
				FROM	cf_SurveyDDBProtection AS csInfo WITH (NOLOCK)
						INNER JOIN #latestResults AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = @queryId
							GROUP BY  csInfo.CommServUniqueId
				UPDATE #CCDeDupBackupConfig SET GoodDDBs = totalDDBs - (CriticalDDBs +WarningDDBs)
				UPDATE CC
						SET Status =
					CASE
						WHEN P.CriticalDDBs > 0 THEN @strCritical
						WHEN P.WarningDDBs >0 THEN @strWarning
						ELSE @strGood
					END,
					Result =
					CASE
						WHEN (P.TotalDDBs >0)
						THEN  ' DDB Partitions: <DELIM>' + 'Total: <B>'+ CAST(P.TotalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp' + 'Good: <B>' + CAST((P.GoodDDBs) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(P.WarningDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(P.CriticalDDBs AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'There are no Media Agents hosting DDB store.<DELIM>'
					END,
					Recommendation =
					CASE
							WHEN P.TotalDDBs = 0 THEN @infoMessage
							WHEN P.CriticalDDBs > 0 or P.WarningDDBs > 0 THEN @warningMessage ELSE @goodMessage
					END,
					logDate = CC.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #CCDeDupBackupConfig P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCDeDupBackupConfig') is not null DROP TABLE #CCDeDupBackupConfig
			END
			ELSE IF @queryId = 22
			BEGIN
				SET @tmpStatus = @strGood
				DECLARE @totalSchCount INT = 0
				DECLARE @unusedSchCount INT = 0
				DECLARE @tmpSchPolicy TABLE(ccuid int, IsUsed INT, SPCount INT)
				IF object_id('tempdb.dbo.#ccSchPolicy') is not null DROP TABLE #ccSchPolicy
				CREATE TABLE #ccSchPolicy(ccuid int, totalSchCount INT, unusedSchCount INT)
				INSERT INTO @tmpSchPolicy
				SELECT  csInfo.CommServUniqueId,
						csInfo.IsUsed, COUNT(*)
				FROM    cf_SurveySchedulePolicyUsage AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId
				GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.IsUsed
				INSERT INTO #ccSchPolicy(ccuid,totalSchCount,unusedSchCount)
				SELECT ccuid,
					COALESCE(SUM(SPCount), 0),
					case when IsUsed = 0 then COALESCE(SUM(SPCount), 0) end FROM @tmpSchPolicy GROUP BY ccuid, IsUsed
				UPDATE CC
					SET Status = @strwarning,
					Result = '<b>' + CAST(P.unusedSchCount AS NVARCHAR(100)) + '</b> out of <b>'
								+ CAST(P.totalSchCount AS NVARCHAR(100))
								+ '</b> Schedule Policies are not used.<DELIM>',
					Recommendation = @warningMessage,
					LogDate= COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #ccSchPolicy P
					ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND P.unusedSchCount > 0
				UPDATE CC
					SET Status = @tmpStatus,
					Result = CASE WHEN P.totalSchCount = 0 THEN 'There is no Schedule Policy.<DELIM>'
							WHEN P.totalSchCount > 0 THEN 'All <b>' + CAST(P.totalSchCount AS NVARCHAR(100)) + '</b> Schedule Policies are in use.<DELIM>' END,
					Recommendation = CASE WHEN @totalSchCount > 0 THEN @goodMessage ELSE '' END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #ccSchPolicy P
					ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND P.unusedSchCount IS null
				UPDATE CC
					SET Status = @tmpStatus,
					Result = 'There is no Schedule Policy.<DELIM>',
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#ccSchPolicy') is not null DROP TABLE #ccSchPolicy
			END
           --Largest Clients by backup Size
           ELSE IF @queryId = 23
           BEGIN
               SET @tmpStatus = @strInfo
               SET @tmpResult = 'There may not be any backup jobs in last 30 days.'
			   SET @tmpRecommendation = '<VDL>'
			   IF object_id('tempdb.dbo.#LargestClients') is not null DROP TABLE #LargestClients
			   CREATE TABLE #LargestClients(CCUID INT, Status VARCHAR(10), LogDate varchar(20),  Result nvarchar(max), Recommendation nvarchar(max))
			   INSERT INTO #LargestClients
               SELECT  sub.CommServUniqueId,
					   @strInfo,
                       CONVERT(VARCHAR(20), sub.LogDate, 100),
                       '<b>' + CAST(sub.ClientCount AS NVARCHAR(MAX)) + '</b> client(s) contribute(s) <b>'
                           + CAST(CAST(sub.SharePercent AS DECIMAL(6,2)) AS NVARCHAR(MAX)) + ' %</b> of the total application size <b>'
                           + dbo.FormatBytes(sub.TotalSize, 'GB') + '</b>  (last full backups).<DELIM>',
                       CASE WHEN ISNULL(sub.ClientCount, 0) = 0 THEN '' ELSE '<VDL>' END
               FROM    (SELECT csInfo.CommServUniqueId,
                               csInfo.LogDate,
                               csInfo.ClientGroups,
                               COUNT(DISTINCT csInfo.ClientId) AS ClientCount,
                               MAX(csInfo.TotalSizeGB) AS TotalSize,
                               CASE
                                   WHEN SUM(csInfo.ShareOfTotal) > 100 THEN 100
                                   ELSE SUM(csInfo.ShareOfTotal)
                               END AS SharePercent
                       FROM    cf_SurveyLargestClientsByBKPSize AS csInfo WITH (NOLOCK)
                               INNER JOIN #latestResults AS result
                                   ON result.SurveyResultId = csInfo.SurveyResultId
                                   AND result.QueryID = @queryId
                       GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate, csInfo.ClientGroups
                       ) AS sub
				UPDATE CC
				SET Status = JJ.Status,
					Result = JJ.Result,
					Recommendation = JJ.Recommendation,
					logDate = jj.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #LargestClients JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#LargestClients') is not null DROP TABLE #LargestClients
           END
           --Slowest Clients by long running jobs
           ELSE IF @queryId = 24
           BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'No jobs were found running longer than <b>12 hours</b>.<DELIM>'
				SET @tmpRecommendation = ''
				IF object_id('tempdb.dbo.#SlowestClients') is not null DROP TABLE #SlowestClients
				CREATE TABLE #SlowestClients(CCUID INT, Status VARCHAR(10), LogDate varchar(20),  Result nvarchar(max), Recommendation nvarchar(max), jobCount INT)
				INSERT INTO #SlowestClients (CCUID,jobCount,LogDate)
				SELECT  csInfo.CommServUniqueId, LongRunningJobs, CONVERT(VARCHAR(20), csInfo.LogDate, 100)
				FROM    cf_SurveyLongRunningJobs AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId
				update #SlowestClients
				SET Status = CASE WHEN jobCount > 0 THEN @strwarning ELSE @strGood END,
					Result = CASE
						WHEN jobCount > 0 THEN '<b>' + CAST(jobCount AS VARCHAR(MAX)) + '</b> jobs were found running longer than <b>12 hours</b>.<DELIM>'
						ELSE 'No jobs were found running longer than <b>12 hours</b>.<DELIM>' END,
					Recommendation = CASE WHEN jobCount > 0 THEN 'View top 25 backup jobs running for more than 12 hours.<VDL>' ELSE '' END
				UPDATE CC
				SET Status = JJ.Status,
				Result = JJ.Result,
				Recommendation = JJ.Recommendation,
				logDate = jj.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #SlowestClients JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @tmpStatus,
				Result = @tmpResult,
				Recommendation = @tmpRecommendation,
				logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#SlowestClients') is not null DROP TABLE #SlowestClients
           END
            --Continuous Failed Clients
            ELSE IF @queryId = 25
            BEGIN
				IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
                CREATE TABLE #StrikeEntities (ccuid INT, clientId INT, appId INT, isVM INT, strikeCount INT)
				IF object_id('tempdb.dbo.#CCTotalClients') is not null DROP TABLE #CCTotalClients
				IF object_id('tempdb.dbo.#CCTotalClientsWithSt') is not null DROP TABLE #CCTotalClientsWithSt
                create table #CCTotalClients(ccuid int, totalClients INT default 0)
                create table #CCTotalClientsWithSt(ccuid int, totalClientsWithStrike INT default 0)
				INSERT INTO #StrikeEntities
				SELECT  result.CCUID, csInfo.ClientId, csInfo.AppId, 0, MAX(csInfo.StrikeCounts)
				FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.StrikeCounts > 0
 					INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
						ON result.CCUID = SA.CommServUniqueId AND csInfo.ClientId = SA.ClientId
						AND csInfo.AppId = SA.AppId AND SA.AppTypeId <> 106 AND SA.Deleted = 0
				GROUP BY result.CCUID, csInfo.ClientId, csInfo.AppId
				INSERT INTO #StrikeEntities
				SELECT  result.CCUID, csInfo.ClientId, csInfo.AppId, 1, MAX(csInfo.StrikeCounts)
				FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
						AND csInfo.StrikeCounts > 0
 					INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
						ON result.CCUID = SA.CommServUniqueId
						AND csInfo.AppId = SA.AppId AND SA.AppTypeId = 106 AND SA.Deleted = 0
				GROUP BY result.CCUID, csInfo.ClientId, csInfo.AppId
                DECLARE @scStrikes TABLE (ccuid INT, strikeCount INT, scCount INT)
                DECLARE @clStrikes TABLE (ccuid INT, strikeCount INT, clCount INT)
                DECLARE @vmStrikes TABLE (ccuid INT, strikeCount INT, vmCount INT)
                INSERT INTO @scStrikes
				SELECT	ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT appId)
				FROM	#StrikeEntities
				WHERE	isVM = 0
				GROUP BY ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
                INSERT INTO @clStrikes
				SELECT	ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
				FROM	(
					SELECT	ccuid, clientId, MAX(strikeCount) AS strikeCount
					FROM	#StrikeEntities
					WHERE	isVM = 0
					GROUP BY ccuid, clientId
					) S
				GROUP BY ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
                INSERT INTO @vmStrikes
				SELECT	ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
				FROM	#StrikeEntities
				WHERE	isVM = 1
				GROUP BY ccuid, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
				IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
  				INSERT INTO #CCTotalClientsWithSt
				SELECT	ccuid, SUM(clCount)
				FROM	(SELECT ccuid, SUM(clCount) AS clCount FROM @clStrikes GROUP BY ccuid
						UNION ALL
						SELECT ccuid, SUM(vmCount) AS clCount FROM @vmStrikes GROUP BY ccuid) S
				GROUP BY ccuid
				INSERT INTO #CCTotalClients
                SELECT	CC.CCUID, ISNULL(TotalActiveClients,0)
				FROM	cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
						INNER JOIN cf_SurveyResultFuncV1(8, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) R
							ON csInfo.SurveyResultId = R.SurverResultId
						INNER JOIN #commcells cc ON CC.CCUID = R.CommServUniqueId
				IF object_id('tempdb.dbo.#CCStrikeDetails') is not null DROP TABLE #CCStrikeDetails
				CREATE TABLE #CCStrikeDetails(ccuid int, strike nvarchar(max))
				INSERT INTO #CCStrikeDetails
				SELECT
					ccuid,
					 'Strike 3 :' + CASE WHEN sc3 > 0 THEN ' <b>' + CAST(sc3 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl3 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					              + CASE WHEN vm3 > 0 THEN ' <b>' + CAST(vm3 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END + '<DELIM>' +
					' Strike 2 :' + CASE WHEN sc2 > 0 THEN ' <b>' + CAST(sc2 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl2 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					              + CASE WHEN vm2 > 0 THEN ' <b>' + CAST(vm2 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END + '<DELIM>' +
					' Strike 1 :' + CASE WHEN sc1 > 0 THEN ' <b>' + CAST(sc1 AS VARCHAR(10)) + '</b> Subclient(s) <b>' + CAST(cl1 AS VARCHAR(10)) + '</b> Server(s)' ELSE '' END
					              + CASE WHEN vm1 > 0 THEN ' <b>' + CAST(vm1 AS VARCHAR(10)) + '</b> VM(s)' ELSE '' END + '<DELIM>'
				FROM
					(SELECT	T.ccuid,
							ISNULL((SELECT scCount FROM @scStrikes WHERE ccuid = T.ccuid AND strikeCount = 3), 0) AS sc3,
							ISNULL((SELECT clCount FROM @clStrikes WHERE ccuid = T.ccuid AND strikeCount = 3), 0) AS cl3,
							ISNULL((SELECT vmCount FROM @vmStrikes WHERE ccuid = T.ccuid AND strikeCount = 3), 0) AS vm3,
							ISNULL((SELECT scCount FROM @scStrikes WHERE ccuid = T.ccuid AND strikeCount = 2), 0) AS sc2,
							ISNULL((SELECT clCount FROM @clStrikes WHERE ccuid = T.ccuid AND strikeCount = 2), 0) AS cl2,
							ISNULL((SELECT vmCount FROM @vmStrikes WHERE ccuid = T.ccuid AND strikeCount = 2), 0) AS vm2,
							ISNULL((SELECT scCount FROM @scStrikes WHERE ccuid = T.ccuid AND strikeCount = 1), 0) AS sc1,
							ISNULL((SELECT clCount FROM @clStrikes WHERE ccuid = T.ccuid AND strikeCount = 1), 0) AS cl1,
							ISNULL((SELECT vmCount FROM @vmStrikes WHERE ccuid = T.ccuid AND strikeCount = 1), 0) AS vm1
					FROM	#CCTotalClientsWithSt T) S
				update cc
				SET Status =  case when SWT.totalClientsWithStrike <> 0 AND ST.totalClients = 0 THEN @strCritical
								when ST.totalClients = 0 OR swt.totalClientsWithStrike = 0 OR ((swt.totalClientsWithStrike*100.0)/st.totalClients) < @warningThreshold then @strGood
								when (swt.totalClientsWithStrike*100.0)/st.totalClients <= @criticalThreshold AND ((SWT.totalClientsWithStrike*100.0)/ST.totalClients) >= @warningThreshold then @strWarning
								else @strCritical end,
					Result=  P.strike,
					Recommendation = case when SWT.totalClientsWithStrike = 0 THEN '<DELIM>'
					else '<VDL>' END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #CCStrikeDetails P
					ON CC.CommServUniqueId = P.CCUID
					inner join #CCTotalClients ST
					on ST.CCUID =  P.CCUID
					inner join #CCTotalClientsWithSt SWT
					on swt.ccuid = ST.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strGood,
					Result = 'There are no clients having any consecutive failed/killed jobs hence there is no strike.<DELIM>',
					Recommendation = '<DELIM>',
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCStrikeDetails') is not null DROP TABLE #CCStrikeDetails
				IF object_id('tempdb.dbo.#CCTotalClients') is not null DROP TABLE #CCTotalClients
				IF object_id('tempdb.dbo.#CCTotalClientsWithSt') is not null DROP TABLE #CCTotalClientsWithSt
            END
            --Dedupe Ratio by Storage Policy Copy
            ELSE IF @queryId = 26
            BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = 'There are no storage policy copies with Deduplication enabled.<DELIM>'
				SET @tmpRecommendation = @infoMessage
                DECLARE @TotalCopies INT = 0
                DECLARE @DeDupRatioSPCount TABLE(ccuid int, Copy NVARCHAR(256), DeDupRatio DECIMAL(20, 2))
                INSERT INTO @DeDupRatioSPCount
                SELECT  csinfo.CommServUniqueId,csInfo.Copy, csInfo.DedupeRatio
                FROM    cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
                        INNER JOIN #latestResults AS result
                            ON result.SurveyResultId = csInfo.SurveyResultId
                            AND result.QueryID = @queryId
                AND csInfo.Jobs > 0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
                AND csInfo.DedupeRatio > -1
				IF object_id('tempdb.dbo.#CCtotalCopies') is not null DROP TABLE #CCtotalCopies
				create table #CCtotalCopies(ccuid int,TotalCopies int)
				insert into #CCtotalCopies
				SELECT ccuid, COUNT(*) FROM @DeDupRatioSPCount group by ccuid
				IF object_id('tempdb.dbo.#CCDdbDetails') is not null DROP TABLE #CCDdbDetails
				create table #CCDdbDetails(ccuid int, DDBappSize DECIMAL(20,2) default 0, DDBSizeOnMedia DECIMAL(20,2) default 0, DDBRatio VARCHAR(MAX) default '', TotalCopies int, Result varchar(max))
                DECLARE @DDBappSize DECIMAL(20,2) = 0
                DECLARE @DDBSizeOnMedia DECIMAL(20,2) = 0
                DECLARE @DDBRatio VARCHAR(MAX) = ''
				insert into #CCDdbDetails(ccuid,DDBappSize,DDBSizeOnMedia,DDBRatio)
                SELECT
					csInfo.CommServUniqueId,
                    CAST(SUM(csInfo.appSizeGB)/1024.0 AS Decimal(20,2)),
                    CAST(SUM(csInfo.SizeOnMediaGB)/1024.0 AS Decimal(20,2)),
                    CASE
                        WHEN SUM(csInfo.SizeOnMediaGB)<=0 THEN 'N/A'
                        ELSE CAST(CAST((100.0*(SUM(csInfo.appSizeGB)-SUM(csInfo.SizeOnMediaGB))/SUM(csInfo.appSizeGB))AS Decimal(20,2)) AS VARCHAR(MAX))
                    END
                FROM cf_SurveyDDBRatioBySPCopy AS csInfo WITH (NOLOCK)
                    INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryId = @queryId
						AND csInfo.Jobs>0 and ( csInfo.DedupeRatio <>0 or  csInfo.SizeOnMediaGB <>0)
						AND csInfo.DedupeRatio>-1
				group by csInfo.CommServUniqueId
				update cc
					set TotalCopies= ctp.TotalCopies
					from #CCDdbDetails cc
					inner join #CCtotalCopies ctp
					on cc.ccuid = ctp.ccuid
				update cc
					set Result=
					case when cc.TotalCopies > 0
					then 'Deduplication Copies: <DELIM>' + 'Total: <B>'+ CAST(CC.TotalCopies AS NVARCHAR(5)) + '</B>' + ', Application Size: <B>'+ CAST(CC.DDBappSize AS NVARCHAR(20)) + ' TB</B>'
						+ ', Size on Media: <B>'+ CAST(CC.DDBSizeOnMedia AS NVARCHAR(20)) + ' TB</B>' + ', Deduplication Ratio: <B>'+ CC.DDBRatio + '</B>'
						else 'There are no storage policy copies with Deduplication enabled.<DELIM>'
					end
					from #CCDdbDetails cc
				UPDATE CC
					SET Status = @tmpStatus,
					Result = JJ.Result,
					Recommendation = @tmpRecommendation,
					logDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCDdbDetails JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCDdbDetails') is not null DROP TABLE #CCDdbDetails
				IF object_id('tempdb.dbo.#CCtotalCopies') is not null DROP TABLE #CCtotalCopies
            END
            ELSE IF @queryId = 27
            BEGIN
				SET @tmpResult = 'No data available<DELIM>'
				SET @tmpStatus = @strInfo
				SET @tmpRecommendation = @infoMessage
                DECLARE @slaPercent FLOAT = -1
                DECLARE @MetSLA INT, @MissedSLA INT
				IF object_id('tempdb.dbo.#CCSlaDetails') is not null DROP TABLE #CCSlaDetails
				CREATE TABLE #CCSlaDetails(CCUID int, slaPercent Decimal(20,2), MetSLA INT, MissedSLA INT)
				INSERT INTO #CCSlaDetails
                SELECT  sub.CCUID,
						CASE
                        WHEN (sub.NotProtectedClients+sub.ProtectedClients)>0
                        THEN sub.ProtectedClients*100.0/(sub.NotProtectedClients+sub.ProtectedClients)
                        ELSE -1 END,
                        sub.ProtectedClients,
                        sub.NotProtectedClients
                FROM    (SELECT result.CCUID,
                                csInfo.ProtectedClients,
                                csInfo.NotProtectedClients
                        FROM    cf_SurveySLASummary AS csInfo WITH (NOLOCK)
                                INNER JOIN #latestResults AS result
                                    ON result.SurveyResultId = csInfo.SurveyResultId
                                    AND result.QueryID = @queryId AND (csInfo.Days = 30 OR csInfo.Days < 0)
                        ) AS sub
				UPDATE CC
				SET Status = CASE
                        WHEN JJ.slaPercent < @criticalThreshold THEN @strCritical
                        WHEN JJ.slaPercent <= @warningThreshold THEN @strwarning
                        ELSE @strGood END,
				Result = 'SLA is <b>'+ CAST (JJ.slaPercent AS NVARCHAR(MAX)) + ' %.</b><DELIM>' + 'Met SLA : <b>' + CAST (JJ.MetSLA AS NVARCHAR(MAX)) + '</b>, Missed SLA : <b>' + CAST (JJ.MissedSLA AS NVARCHAR(MAX)) + '</b>',
				Recommendation = CASE
                        WHEN JJ.slaPercent < @criticalThreshold THEN @criticalMessage
                        WHEN JJ.slaPercent <= @warningThreshold THEN @warningMessage
						WHEN JJ.slaPercent < 100 THEN @warningMessage
                        WHEN JJ.slaPercent = 100 THEN @goodMessage END,
				logDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #CCSlaDetails JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND JJ.slaPercent >= 0
				UPDATE CC
				SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
					FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCSlaDetails') is not null DROP TABLE #CCSlaDetails
            END
           --Incremental Backup Change Rate
           ELSE IF @queryId = 28
           BEGIN
               DECLARE @WeeklySizeChange TABLE
               (
				   CCUID INT,
                   LogDate DATE,
                   BkpSize FLOAT,
                   TotalJobs BIGINT
               )
               INSERT INTO @WeeklySizeChange
               SELECT
					   result.CCUID,
					   CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE),
                       SUM(csInfo.BackupSize) AS BkpSize, --AS '',
                       SUM(csInfo.TotalJobs)  AS TotalJobs --AS 'Number of Incremental Backups'
               FROM    cf_SurveyIncrBkpChangeRate AS csInfo WITH (NOLOCK)
                       INNER JOIN #latestResults AS result
                           ON result.SurveyResultId = csInfo.SurveyResultId
                           AND result.QueryID = @queryId
               GROUP BY result.CCUID, CAST (DATEADD(SS,csInfo.UxDate,'1970-01-01')AS DATE)
			   IF object_id('tempdb.dbo.#CCSizeDetails') is not null DROP TABLE #CCSizeDetails
			   CREATE TABLE #CCSizeDetails(CCUID INT, LastTotalBkpSize FLOAT, FirstTotalBkpSize FLOAT, WeekBkpSizeChg FLOAT default 0, WeekBkpSizeChgPercent FLOAT, increased INT DEFAULT 0, Result nvarchar(max), WeekBkpSizeChgStr VARCHAR(MAX) DEFAULT 'NOT APPLICABLE'
			   ,WeekBkpSizeChgPercentStr VARCHAR(MAX) DEFAULT 'NOT APPLICABLE', WeekStr VARCHAR(MAX)DEFAULT '' )
               DECLARE @LastTotalBkpSize FLOAT, @FirstTotalBkpSize FLOAT, @WeekBkpSizeChg FLOAT = 0, @WeekBkpSizeChgPercent FLOAT, @increased INT = 0
			   IF object_id('tempdb.dbo.#Sizetemp') is not null DROP TABLE #Sizetemp
			   CREATE TABLE #Sizetemp(ccuid int, MaxLogDate date, MinLogDate date)
			   insert into #Sizetemp
			   select CCUID, MAX(LogDate), Min(LogDate) from @WeeklySizeChange group by CCUID
			   INSERT INTO #CCSizeDetails(CCUID, LastTotalBkpSize)
               SELECT  rs.CCUID, SUM(ISNULL(BkpSize,0))  FROM @WeeklySizeChange rs inner join #Sizetemp sc on sc.ccuid = rs.CCUID
               and    sc.MaxLogDate = rs.LogDate
			   GROUP BY rs.CCUID
			   UPDATE cc
			   SET FirstTotalBkpSize =ISNULL(BkpSize,0)  FROM #CCSizeDetails cc inner join
			    @WeeklySizeChange SC on CC.CCUID = SC.CCUID
               inner join #Sizetemp st on st.ccuid = cc.CCUID
               and    st.MinLogDate = sc.LogDate
			   UPDATE #CCSizeDetails
					  SET WeekBkpSizeChg         = CASE WHEN (LastTotalBkpSize - FirstTotalBkpSize) < 0 THEN 0 ELSE (LastTotalBkpSize - FirstTotalBkpSize) END
			   UPDATE #CCSizeDetails
					  SET increased =			 CASE WHEN WeekBkpSizeChg > 0 THEN 1 WHEN WeekBkpSizeChg < 0 THEN -1 ELSE 0 END,
					  WeekBkpSizeChgPercent      = WeekBkpSizeChg*100.0/FirstTotalBkpSize,
					  WeekBkpSizeChgStr          = dbo.formatBytes(WeekBkpSizeChg ,'GB')
					  WHERE FirstTotalBkpSize <>0
			   UPDATE #CCSizeDetails
					  SET WeekBkpSizeChgPercentStr   = CAST(CAST (WeekBkpSizeChgPercent AS DECIMAL (16,2)) AS VARCHAR(MAX))
			   UPDATE #CCSizeDetails
					  SET WeekStr                    =' ( <b>' + WeekBkpSizeChgPercentStr + '</b> %)'
			   UPDATE CC
					SET Result =  CASE WHEN increased = 1 THEN 'Total data size increased by <b>' + WeekBkpSizeChgStr + '</b>' + WeekStr + '<DELIM>'
                                   WHEN increased = -1 THEN 'Total data size decreased by <b>' + WeekBkpSizeChgStr + '</b>' + WeekStr + '<DELIM>'
                                   ELSE 'Total data size remained unchanged' END
					FROM #CCSizeDetails CC
				UPDATE CC
					SET Status = @strInfo,
					Result = JJ.Result,
					Recommendation = '<VDL>',
					logDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCSizeDetails JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @strInfo,
					Result = 'Total data size remained unchanged',
					Recommendation = '',
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCSizeDetails') is not null DROP TABLE #CCSizeDetails
				IF object_id('tempdb.dbo.#Sizetemp') is not null DROP TABLE #Sizetemp
           END
            --Most Frequent Errors
            ELSE IF @queryId = 30
            BEGIN
				SET @tmpStatus = @strGood
				SET @tmpResult = 'No errors are found.<DELIM>'
				SET @tmpRecommendation = ''
                DECLARE @errorList TABLE(ccuid int, ErrorCode NVARCHAR(512), JobsAffected INT)
                INSERT INTO @errorList
                SELECT  sub.CommServUniqueId, sub.ErrorCode, sub.NumberOfJobsAffected FROM
                (
                SELECT csInfo.CommServUniqueId, csInfo.ErrorCode, SUM(csInfo.NumberOfJobsAffected) AS NumberOfJobsAffected
                FROM    cf_SurveyMostFrequentErrors AS csInfo WITH (NOLOCK)
                        INNER JOIN #latestResults AS result
                            ON result.SurveyResultId = csInfo.SurveyResultId
                            AND result.QueryID = @queryId
                        GROUP BY csInfo.ErrorCode,csInfo.CommServUniqueId
                ) AS sub
                ORDER BY sub.NumberOfJobsAffected DESC
				IF object_id('tempdb.dbo.#ccerrorListTop5') is not null DROP TABLE #ccerrorListTop5
				create table #ccerrorListTop5(ccuid int, ErrorCode NVARCHAR(512), JobsAffected INT)
				insert #ccerrorListTop5
				select T.ccuid,
				   T.ErrorCode,
				   T.JobsAffected
				from (
					 select T.ccuid,
							T.ErrorCode,
							T.JobsAffected,
							row_number() over(partition by T.ccuid order by T.JobsAffected desc) as rn
					 from @errorList as T
					 ) as T
				where T.rn <= 5;
                DECLARE @totalErrors INT = 0
				IF object_id('tempdb.dbo.#totalErrors') is not null DROP TABLE #totalErrors
				create table #totalErrors (ccuid int, totalErrors int, Result nvarchar(max))
				insert into #totalErrors(ccuid, totalErrors)
                SELECT ccuid, ISNULL(SUM(JobsAffected), 0) FROM #ccerrorListTop5 group by ccuid
				IF object_id('tempdb.dbo.#ccResultMostErrors') is not null DROP TABLE #ccResultMostErrors
				create table #ccResultMostErrors(ccuid int, Result nvarchar(max))
				insert into #ccResultMostErrors
				select distinct ccuid, 'Top 5 Error Code (Jobs Affected) <DELIM>' + STUFF((SELECT ', ' + dbo.cf_surveyKBLink(ErrorCode) + ' (' + CAST(JobsAffected AS VARCHAR(50)) + ')' AS Error FROM #ccerrorListTop5 T1 where T1.ccuid = T2.ccuid FOR XML PATH(''), TYPE).value('.[1]', 'nvarchar(max)'), 1, 2, '') FROM #ccerrorListTop5 T2
				update cc
				set cc.Result = tt.Result
				from #totalErrors cc inner join #ccResultMostErrors tt on cc.ccuid = tt.ccuid
				where totalErrors > 0
				UPDATE CC
					SET Status = @strwarning,
					Result = JJ.Result,
					Recommendation = '<VDL>',
					logDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #totalErrors JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) and jj.totalErrors > 0
				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#ccResultMostErrors') is not null DROP TABLE #ccResultMostErrors
				IF object_id('tempdb.dbo.#totalErrors') is not null DROP TABLE #totalErrors
				IF object_id('tempdb.dbo.#ccerrorListTop5') is not null DROP TABLE #ccerrorListTop5
            END
			--DR Backup Configuration
			ELSE IF @queryId = 31 AND @i_IsLocal = 0
			BEGIN
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(19, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				SET @tmpStatus = @strCritical
				SET @tmpResult = ''
				SET @tmpRecommendation = @criticalMessage
				IF object_id('tempdb.dbo.#CCDRDetails') is not null DROP TABLE #CCDRDetails
				create table #CCDRDetails(
					ccuid int,
					LogDate datetime,
					FullJobsToRetain int default  NULL,
					ISUNC NVARCHAR(20) default NULL,
					UseCommvaultCloud INT default NULL,
					UseThirdpartyCloud INT default NULL,
					CloudDeviceTypeId INT default NULL,
					LastDRBkpTime int default 0,
					LastFailedDRBkpTime int default 0,
					LastCweDRBkpTime int default 0,
					LastDRCollTime datetime default null,
					Status varchar(20) default null,
					Recommendation varchar(max),
					Result varchar(max))
				INSERT INTO #CCDRDetails
					(ccuid,
					LogDate,
					FullJobsToRetain,
					ISUNC,
					UseCommvaultCloud,
					UseThirdpartyCloud,
					CloudDeviceTypeId,
					LastDRBkpTime,
					LastFailedDRBkpTime,
					LastCweDRBkpTime,
					LastDRCollTime)
				SELECT
					csInfo.CommServUniqueId,
					CONVERT(VARCHAR(20), MAX(csInfo.LogDateUTC), 100),
					MAX(csInfo.FullJobsToRetain),
					MAX(csInfo.IsUingNetworkPath),
					MAX(ISNULL(csInfo.UseCommvaultCloud, 0)),
					MAX(ISNULL(csInfo.UseThirdpartyCloud, 0)),
					MAX(ISNULL(csInfo.CloudDeviceTypeId, 0)),
					MAX(csInfo1.LastSuccessfulDRTime),
					MAX(csInfo1.LastFailedDRTime),
					MAX(ISNULL(csInfo1.LastCweDRTime, 0)),
					MAX(csInfo.LogDate)
				FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
					INNER JOIN #commcells CC
						ON result.CCUID = CC.CCUID
					INNER JOIN #latestResults AS result1	--Use Query id 19(DR Backup Statistics)
						ON CC.CCUID = result1.CCUID
						AND result1.QueryId = 19
					INNER JOIN cf_SurveyDRStats AS csInfo1 WITH (NOLOCK)
						ON csInfo1.SurveyResultId = result1.SurveyResultId
				GROUP BY csInfo.CommServUniqueId
				update DR set
					Status = @strCritical,
					Recommendation = @criticalMessage
				from #CCDRDetails DR
					inner join #commcells JJ
						ON DR.CCUID = JJ.CCUID
				WHERE (ISUNC = 'false' AND UseCommvaultCloud = 0 AND UseThirdpartyCloud = 0)
					OR FullJobsToRetain = 0 OR ISNULL(LastDRBkpTime, 0) = 0
					OR DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) > @criticalThreshold
					OR LastFailedDRBkpTime > LastDRBkpTime
				update DR set
					Status = @strwarning,
					Recommendation = @warningMessage
				from #CCDRDetails DR
					inner join #commcells JJ
						ON DR.CCUID = JJ.CCUID
				WHERE (FullJobsToRetain = 1) OR DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) = @warningThreshold
					AND ISNULL(Status, '') = ''
				update DR set
					Status = @strGood,
					Recommendation = @goodMessage
				from #CCDRDetails DR
					inner join #commcells JJ
						ON DR.CCUID = JJ.CCUID
				WHERE (ISUNC = 'true' OR UseCommvaultCloud = 1 OR UseThirdpartyCloud = 1) AND FullJobsToRetain >= 2 AND DATEDIFF(HOUR, DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), LastDRCollTime) < @warningThreshold
					AND ISNULL(Status, '') = ''
				update #CCDRDetails
				SET Result =
				CASE
					WHEN ISNULL(LastDRBkpTime, 0) = 0 THEN 'There is no successful DR job so far.<DELIM>'
					WHEN LastFailedDRBkpTime > LastDRBkpTime AND LastFailedDRBkpTime > LastCweDRBkpTime THEN 'DR Backup job failed on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, LastFailedDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
					WHEN LastCweDRBkpTime > LastDRBkpTime THEN 'DR Backup job completed with errors on <b>'  + CONVERT(VARCHAR(12), DATEADD(second, LastCweDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
					ELSE 'Last successful DR backup ran on <b>' + CONVERT(VARCHAR(12), DATEADD(second, LastDRBkpTime, {d '1970-01-01'}), 107) + '</b>.<DELIM>'
				END
				update #CCDRDetails SET Result = Result + 'DR Backup destinations [<b>'
				update #CCDRDetails SET
					Result = Result
						+ CASE WHEN (UseCommvaultCloud = 1 OR UseThirdpartyCloud = 1) THEN 'Cloud and ' ELSE '' END
						+ CASE WHEN ISUNC = 'true' THEN 'UNC path' ELSE 'local path' END
				update #CCDRDetails SET Result = Result + '</b>]<DELIM>'
				update #CCDRDetails
				SET Result = Result + 'It is currently configured to retain <b>' + CAST(FullJobsToRetain AS VARCHAR(MAX)) + '</b> metadata backupset(s).<DELIM>'
				UPDATE CC
					SET Status = ISNULL(jj.Status, @tmpStatus),
					Result = JJ.Result,
					Recommendation = jj.Recommendation,
					logDate = jj.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #CCDRDetails JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCDRDetails') is not null DROP TABLE #CCDRDetails
			END
            --Clients completing with error
            ELSE IF @queryId = 37
            BEGIN
                SET @tmpStatus = @strGood
                SET @tmpResult = 'There are no clients with Jobs completed with errors.<DELIM>'
				SET @tmpRecommendation = '<VDL>'
				IF object_id('tempdb.dbo.#CCClientserror') is not null DROP TABLE #CCClientserror
				CREATE TABLE #CCClientserror(CCUID INT, totalClients INT)
				insert into #CCClientserror(CCUID,totalClients)
				SELECT CC.CCUID, ISNULL(TotalClients,0) FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
					INNER JOIN cf_SurveyResultFuncV1(8, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) R
						ON csInfo.SurveyResultId = R.SurverResultId
					INNER JOIN #commcells cc ON CC.CCUID = R.CommServUniqueId
				IF object_id('tempdb.dbo.#CCClientcountTemp') is not null DROP TABLE #CCClientcountTemp
				create table #CCClientcountTemp(ccuid int, LogDate datetime, ClientCount int)
				insert into   #CCClientcountTemp
				SELECT csInfo.CommServUniqueId, csInfo.LogDate, COUNT(csInfo.ClientName) AS ClientCount
                        FROM    cf_SurveyClientJobsCompletingWithError AS csInfo WITH (NOLOCK)
                                INNER JOIN #latestResults AS result
                                    ON result.SurveyResultId = csInfo.SurveyResultId
                                    AND result.QueryID = @queryId
									inner join #CCClientserror cc on cc.CCUID = csInfo.CommServUniqueId
                        GROUP BY csInfo.CommServUniqueId, csInfo.SurveyResultId, csInfo.LogDate
				update SR
                Set Status = (CASE WHEN totalClients = 0 AND ISNULL(sub.ClientCount, 0) <> 0
                                                THEN @strCritical
                                           WHEN totalClients = 0 OR ISNULL(sub.ClientCount, 0) = 0 OR ((ISNULL(sub.ClientCount, 0)*100)/totalClients) < @warningThreshold
                                                THEN @strGood
                                           WHEN ((ISNULL(sub.ClientCount, 0)*100)/totalClients) <= @criticalThreshold AND ((ISNULL(sub.ClientCount, 0)*100)/totalClients) >= @warningThreshold
                                                THEN @strWarning
                                           ELSE @strCritical
                                     END),
                        Result = '<b>' + CAST(sub.ClientCount AS VARCHAR(10)) + '</b> client(s) with one or more jobs completed with error.<DELIM>',
                        Recommendation = (CASE WHEN ISNULL(sub.ClientCount, 0) = 0 OR (totalClients = 0 AND ISNULL(sub.ClientCount, 0) = 0) OR ((ISNULL(sub.ClientCount, 0)*100.0)/totalClients)<= @warningThreshold
                                                    THEN ''
                                                  ELSE '<VDL>'
                                                  END),
												  LogDate = COM.LogDate
				from  #CCClientserror cc
				inner JOIN #commcells COM ON CC.CCUID = COM.CCUID
				inner join #CCClientcountTemp sub on cc.CCUID = sub.ccuid
				inner join #TblSurveyResult SR on SR.CommServUniqueId = cc.CCUID
				WHERE SR.MonitorId = @queryId AND (@parameterName = '' OR SR.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCClientserror') is not null DROP TABLE #CCClientserror
				IF object_id('tempdb.dbo.#CCClientcountTemp') is not null DROP TABLE #CCClientcountTemp
            END
            --Index Cache location
            ELSE IF @queryId = 39 AND @parameterName = 'Index Cache Location'
            BEGIN
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(39, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				IF object_id('tempdb.dbo.#TblIndexCacheSpace') is not null
					DROP TABLE #TblIndexCacheSpace
				CREATE TABLE #TblIndexCacheSpace
				(
					CCUID INT,
					Status varchar(1024) default '',
					Result varchar(1024) default '',
					Recommendation varchar(1024) default '',
					totalIdxCache int default 0,
					warningIdxCache int default 0,
					criticalIdxCache int default 0,
					unknownIdxCache int default 0
				)
				insert into #TblIndexCacheSpace
				select distinct CCUID, '', '', '', 0,0,0,0 from #commcells
				DECLARE @idxCacheSize TABLE
				(
					CCUID INT,
					MAId INT,
					percentFree DECIMAL(10,2),
					FreeDiskSpaceMB BIGINT,
					warningSpaceMB	BIGINT,
					criticalSpaceMB	BIGINT,
					Days bigint,
					status int,
					indexCount INT DEFAULT 0,
					warningCount INT DEFAULT 0,
					criticalCount INT DEFAULT 0,
					errorCount INT DEFAULT 0,
					operationalStatus INT DEFAULT 0,
					cacheType INT DEFAULT 0
				)
				DECLARE @LatestThreshold TABLE  (
				CommServUniqueId INT,
				clientId INT,
				warningSpaceMB BIGINT,  criticalSpaceMB BIGINT)
				INSERT INTO @LatestThreshold
				SELECT  CommServUniqueId ,entityId  AS clientId,
				CASE ISNUMERIC([warningSpaceMB]) WHEN 1 THEN CAST(CAST([warningSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END AS warningSpaceMB,
				CASE ISNUMERIC([criticalSpaceMB]) WHEN 1 THEN CAST(CAST([criticalSpaceMB] AS FLOAT) AS BIGINT) ELSE 0 END  AS criticalSpaceMB
				FROM    (SELECT csInfo.CommServUniqueId,entityId, attrName ,attrVal
							FROM cf_SurveyCommcellThresholdInfo csInfo (NOLOCK)
							INNER JOIN #commcells JJ
								ON csInfo.CommServUniqueId = JJ.CCUID
									and attrName IN ( 'warningSpaceMB', 'criticalSpaceMB')
				     	 ) AS clients
				PIVOT
				(
					MAX(attrVal) FOR attrName IN ( warningSpaceMB, [criticalSpaceMB])
				) AS P
				DECLARE @IdxCriticalDays  bigINT =30
				DECLARE @IdxWarningDays  bigINT= 90
                DECLARE @PctFreeSpaceCritical INT = 10
                DECLARE @PctFreeSpaceWarning INT = 30
                SELECT  @PctFreeSpaceWarning = (100 - WarningThreshold), @PctFreeSpaceCritical = (100 - CriticalThreshold)
				FROM cf_SurveyHealthParam where queryId = 39
				-- Get prediction data
				IF @useStoredPrediction = 0 -- Use default linear regression model
				BEGIN
					-- Delete any data in Growth data tables
					delete #GrowthData
					delete #GrowthRate
					-- Fill input data
					INSERT INTO #GrowthData
						select B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks, max(B.SpaceMB),
						ROW_NUMBER() OVER (PARTITION BY B.CommServUniqueId, B.MAId, B.IndexCachePath ORDER BY B.Weeks desc)
						from
						(SELECT S.CommServUniqueId, S.MAId, S.IndexCachePath, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DiskUsageMB, -1) as SpaceMB
						FROM cf_SurveyIndexCacheUsagePeakSize S
									INNER JOIN (
											select A.CommServUniqueId, A.MAId, A.IndexCachePath, isnull(max(A.TotalCapacityMB),0) as TotalCapacityMBMax
											from cf_SurveyIndexCacheUsage as A
											INNER JOIN #latestResults AS result
											ON result.SurveyResultId = A.SurveyResultId and  A.IndexAccessPathEnabled = 1 AND A.TotalCapacityMB > 0
											group by A.CommServUniqueId, A.MAId, A.IndexCachePath
									) T ON S.CommservUniqueId = T.CommServUniqueId AND S.MAId = T.MAId AND S.IndexCachePath = T.IndexCachePath
						WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DiskUsageMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
						group by B.CommServUniqueId, B.MAId, B.IndexCachePath, B.Weeks
					-- Run Growh rate calculation
					EXEC GetLinearGrowthRate 0
					-- Insert tmp prediction data
					DELETE FROM #PredictionData;
					INSERT INTO #PredictionData
						SELECT 	S.CommServUniqueId, S.MAId, S.IndexCachePath,
								CAST(dbo.CalculateDaysToBeFull (S.FreeDiskSpaceMB, R.GrowthRate/7.0, S.LogDateUTC) AS BIGINT) -- DaysToBeFull
						FROM cf_SurveyIndexCacheUsage AS S
						INNER JOIN #latestResults AS U
						on U.SurveyResultId = S.SurveyResultId
						left join #GrowthRate R
						on S.CommServUniqueId = R.CommServUniqueId
						and S.MAId = R.EntityId
						and S.IndexCachePath = R.EntityName
				END
				ELSE -- Use prediction data from CvStatAnalysis
				BEGIN
					DELETE FROM #PredictionData;
					INSERT INTO #PredictionData
						SELECT DISTINCT
							I.CommServUniqueId, I.MediaAgentId, I.IndexCachePath,
							I.DaysToBeFull
						FROM cf_SurveyIndexCacheUsage AS S
						INNER JOIN #latestResults AS U
						ON U.SurveyResultId = S.SurveyResultId
						LEFT JOIN (
							SELECT CommServUniqueId, MediaAgentId, IndexCachePath, MAX(LogDateUTC) AS LogDate
							FROM IndexCacheUsagePrediction
							GROUP BY CommServUniqueId, MediaAgentId, IndexCachePath
						) R
						ON S.CommServUniqueId = R.CommServUniqueId AND S.MAId = R.MediaAgentId AND S.IndexCachePath = R.IndexCachePath
						LEFT JOIN IndexCacheUsagePrediction I
						ON R.CommServUniqueId = I.CommServUniqueId AND R.MediaAgentId = I.MediaAgentId AND R.IndexCachePath = I.IndexCachePath AND R.LogDate = I.LogDateUTC
				END
				INSERT INTO @idxCacheSize (CCUID, MAId,percentFree,FreeDiskSpaceMB,warningSpaceMB,criticalSpaceMB, Days, status, indexCount, warningCount, criticalCount, errorCount, operationalStatus, cacheType)
				SELECT
				csInfo.CommServUniqueId,
				csInfo.MAId,
				CASE
					WHEN csInfo.TotalCapacityMB <= 0 THEN -1
					ELSE CAST((csInfo.FreeDiskSpaceMB * 100.0 / csInfo.TotalCapacityMB) AS DECIMAL(10,2))
				END AS percentFree,
				CASE WHEN csInfo.TotalCapacityMB <= 0 THEN -1 ELSE csInfo.FreeDiskSpaceMB END,
				CASE WHEN T.clientId IS NOT NULL THEN T.warningSpaceMB ELSE csInfo.TotalCapacityMB*@warningThreshold/100 END,
				CASE WHEN T.clientId IS NOT NULL THEN T.criticalSpaceMB ELSE csInfo.TotalCapacityMB*@criticalThreshold/100 END,
				LSF.DaysToBeFull,
				0,
				csInfo.NumberOfHostedIndices,
				csInfo.NumberOfHostedIndices * @warningThreshold / 100,
				csInfo.NumberOfHostedIndices * @criticalThreshold / 100,
				csInfo.NumberOfErrorIndices,
				CASE WHEN csInfo.IndexAccessPathEnabled = 0 THEN 3 ELSE csInfo.ServerStatus END,
				csInfo.CacheType
				FROM
				cf_SurveyIndexCacheUsage AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND csInfo.TotalCapacityMB > 0
					LEFT OUTER JOIN @LatestThreshold T
						ON T.CommServUniqueId = csInfo.CommServUniqueId AND csInfo.MAId =T.clientId
				LEFT OUTER JOIN #PredictionData LSF
					ON LSF.EntityId = csInfo.MAId and LSF.CommServUniqueId = csInfo.CommservUniqueId
				update A
				set status =
				(
				case
				when percentFree = -1
				then 0 -- unknown
				when ( FreeDiskSpaceMB<criticalSpaceMB )
					or  ( errorCount > criticalCount ) -- Critical count of indices in error
					or  ( operationalStatus = 3 ) -- Cache disabled
                    or  ( percentFree <  @PctFreeSpaceCritical) -- Free space is below 10%
					or  ( Days != @NA and Days != @Never and Days<@IdxCriticalDays )
				then 1 -- critical
				when (FreeDiskSpaceMB>=criticalSpaceMB AND FreeDiskSpaceMB<=warningSpaceMB )
					or (errorCount > warningCount) -- Indices in error is bigger than warning threshold
					or (operationalStatus BETWEEN 1 AND 2) -- Media agent is offline
                    or  (percentFree <  @PctFreeSpaceWarning) -- Free space is below 30%
					or ( Days != @NA and Days != @Never and Days>=@IdxCriticalDays and Days <= @IdxWarningDays )
				then 2 --warning
				else 3 --good
				end
				)
				from @idxCacheSize as A
				update DD
				set unknownIdxCache = isnull(UnknownTbl.CNT, 0),
				criticalIdxCache = isnull(CriticalTbl.CNT, 0),
				warningIdxCache = isnull(WarningTbl.CNT, 0),
				totalIdxCache = isnull(TotalTbl.CNT, 0)
				FROM #TblIndexCacheSpace DD
					left join (
						select CCUID, status, count(DISTINCT CHECKSUM(MAId, cacheType)) as CNT
						from @idxCacheSize
						where status = 0
						group by CCUID, status
					) UnknownTbl
					on UnknownTbl.CCUID = DD.CCUID
					left join (
						select CCUID, status, count(DISTINCT CHECKSUM(MAId, cacheType)) as CNT
						from @idxCacheSize
						where status = 1
						group by CCUID, status
					) CriticalTbl
					on CriticalTbl.CCUID = DD.CCUID
					left join (
						select CCUID, status, count(DISTINCT CHECKSUM(MAId, cacheType)) as CNT
						from @idxCacheSize
						where status = 2
						group by CCUID, status
					) WarningTbl
					on WarningTbl.CCUID = DD.CCUID
					left join (
						select CCUID, count(DISTINCT CHECKSUM(MAId, cacheType)) as CNT
						from @idxCacheSize
						group by CCUID
					) TotalTbl
					on TotalTbl.CCUID = DD.CCUID
				UPDATE DD
				set Status =
					CASE
						WHEN totalIdxCache = 0 THEN @strInfo
						WHEN criticalIdxCache > 0 THEN @strCritical
						WHEN warningIdxCache > 0 THEN @strwarning
						ELSE @strGood
					END,
				Result =
				case
				when (totalIdxCache > 0)
				then
					'Index cache distribution by available space: <DELIM>'
					+'Total : <B>'+ CAST(totalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+'Good : <B>' + CAST((totalIdxCache-warningIdxCache-criticalIdxCache-unknownIdxCache) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+'Warning : <B>' + CAST(warningIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+'Critical : <B>' + CAST(criticalIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ CASE WHEN unknownIdxCache > 0 THEN '<DELIM>Excluded : <B>' + CAST(unknownIdxCache AS NVARCHAR(5)) + '</B>&nbsp&nbsp' ELSE '' END
				ELSE
					'There is no index cache configured.<DELIM>'
				end,
				Recommendation =
				CASE
					WHEN totalIdxCache = 0 THEN @infoMessage
					WHEN totalIdxCache > 0 AND criticalIdxCache = 0 AND warningIdxCache = 0 THEN @goodMessage
					ELSE @warningMessage
				END
				FROM #TblIndexCacheSpace DD
				UPDATE CC
				SET Status = DD.Status,
					Result = DD.Result,
					Recommendation = DD.Recommendation + '<VDL><VDL_CR>IndexCacheLocation&input.CommServUniqueId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'&input.GroupId=' + CAST(@i_GroupId AS VARCHAR(128)) + '</VDL_CR>',
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #TblIndexCacheSpace DD
						ON CC.CommServUniqueId = DD.CCUID
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				drop table #TblIndexCacheSpace
            END
            --Index State
			ELSE IF @queryId = 201 AND @parameterName = 'Index State'
			BEGIN
				--Using query 200 for this
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(200, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				SET @tmpStatus = @strUnknown
				SET @tmpResult = ''
				IF object_id('tempdb.dbo.#CCIdxStateStatus') is not null DROP TABLE #CCIdxStateStatus
				IF object_id('tempdb.dbo.#CCIdxState') is not null DROP TABLE #CCIdxState
				CREATE TABLE #CCIdxStateStatus(
						CCUID INT,
						ClientId INT,
						ErrorLevel INT,
						DbUptoDate INT,
						LastIdxErrorTime BIGINT,
						LastBackupTime BIGINT,
						LastBackupForDb BIGINT,
						FirstBackupForDb BIGINT,
						ScIdxConversionTime BIGINT,
						IndexType NVARCHAR(10))
				CREATE TABLE #CCIdxState(CCUID INT, TotalIdxState INT DEFAULT 0, GoodIdxState INT DEFAULT 0, WarningIdxState INT DEFAULT 0, CriticalIdxState INT DEFAULT 0)
				INSERT INTO #CCIdxStateStatus
				SELECT
					result.CCUID,
					csInfo.ClientId,
					csInfo.errorLevel,
					csInfo.dbUptoDate,
					csInfo.LastIdxErrorTime,
					csInfo.LastBackupTime,
					csInfo.LastBackupForDb,
					csInfo.FirstBackupForDb,
					csInfo.ScIdxConversionTime,
					csInfo.IndexType
				FROM cf_SurveyIndexBackupStatus AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryId = 200  -- Use "Index Backup Status" query
				DECLARE @criticalDaysIdxState INT = 3
				DECLARE @criticalVal INT = 30
				DECLARE @warningVal INT = 15
				DECLARE @bufferDaysVal INT = 2
				SELECT  @warningVal = WarningThreshold, @criticalVal = CriticalThreshold, @criticalDaysIdxState = ThresholdMin
				FROM cf_SurveyHealthParam where queryId = 201
				INSERT INTO #CCIdxState(CCUID, TotalIdxState, WarningIdxState, CriticalIdxState)
				SELECT
					csInfo.CCUID,
					COUNT(csInfo.ClientId) AS TotalIdxState,
					SUM(
						CASE
							WHEN (ErrorLevel > 5 AND LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState)) -- Index has moderate error for more than @criticalDaysIdxState days
								OR DbUptoDate = 0 -- Index is not up-to-date
								OR (csInfo.LastBackupTime != -1 AND csInfo.LastBackupTime >= CM.CriticalTimestamp AND csInfo.LastBackupTime < CM.WarningTimestamp AND (csInfo.LastBackupForDb = -1 OR csInfo.LastBackupForDb > CM.WarningTimestamp) AND csInfo.FirstBackupForDb < CM.BufferTimestamp) -- Index backup is getting old
								THEN 1
							ELSE 0
						END
					) AS WarningIdxState,
					SUM(
						CASE
							WHEN (ErrorLevel BETWEEN 1 AND 5) AND (LastIdxErrorTime < dbo.GetUnixTimeBig(CM.ModifiedTime - @criticalDaysIdxState)) -- Index has critical error for more than @criticalDaysIdxState days
								OR (csInfo.LastBackupTime = -1 AND csInfo.IndexType = 'Classic' AND csInfo.LastBackupForDb > CM.CriticalTimestamp AND csInfo.FirstBackupForDb < CM.BufferTimestamp AND csInfo.FirstBackupForDb != -1 AND csInfo.ScIdxConversionTime < CM.BufferTimestamp) -- Apply this only when new data comes in: index was never backed up
								OR (csInfo.LastBackupTime != -1 AND csInfo.LastBackupTime < CM.CriticalTimestamp AND (csInfo.LastBackupForDb = -1 OR csInfo.LastBackupForDb > CM.CriticalTimestamp) AND csInfo.FirstBackupForDb < CM.BufferTimestamp) -- Index backup is old
								THEN 1
							ELSE 0
						END
					) AS CriticalIdxState
				FROM #CCIdxStateStatus AS csInfo WITH (NOLOCK)
				JOIN (
					SELECT
						ID,
						CommservTZ,
						dbo.GetUnixTimeBig(ModifiedTime - @criticalVal) AS CriticalTimestamp,
						dbo.GetUnixTimeBig(ModifiedTime - @warningVal) AS WarningTimestamp,
						dbo.GetUnixTimeBig(ModifiedTime - @bufferDaysVal) AS BufferTimestamp,
						ModifiedTime
					FROM cf_CommcellIdNameMap WITH (NOLOCK)
				) AS CM ON CM.ID = csInfo.CCUID
				GROUP BY csInfo.CCUID
				UPDATE #CCIdxState SET GoodIdxState = TotalIdxState - (CriticalIdxState + WarningIdxState)
				UPDATE CC
						SET Status =
					CASE
						WHEN P.TotalIdxState = 0 THEN @strInfo
						WHEN P.CriticalIdxState > 0 THEN @strCritical
						WHEN P.WarningIdxState > 0 THEN @strwarning
						ELSE @strGood
					END,
					Result =
					CASE
					WHEN (P.TotalIdxState > 0)
						THEN  'Index Status: <DELIM>' + 'Total : <B>'+ CAST((P.TotalIdxState) AS NVARCHAR(5)) + '</B>&nbsp&nbsp' + 'Good : <B>' + CAST((P.GoodIdxState) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning : <B>' + CAST((P.WarningIdxState) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical : <B>' + CAST(P.CriticalIdxState AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'There is no index status.<DELIM>'
					END,
					Recommendation =
					CASE
						WHEN P.TotalIdxState = 0 THEN @infoMessage
						WHEN P.TotalIdxState > 0 AND P.CriticalIdxState = 0 AND P.WarningIdxState = 0 THEN @goodMessage
					ELSE @warningMessage
					END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCIdxState P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @strInfo,
					Result = 'There is no index status.<DELIM>',
					Recommendation = 'There is no index status.<DELIM>',
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				UPDATE CC
				SET Recommendation += '<VDL><VDL_CR>IndexState&input.CommServUniqueId='+CAST(@i_CommServUniqueId AS VARCHAR(128)) + '</VDL_CR>'
				FROM #TblSurveyResult CC
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CCIdxStateStatus') is not null DROP TABLE #CCIdxStateStatus
				IF object_id('tempdb.dbo.#CCIdxState') is not null DROP TABLE #CCIdxState
			END
           --Index Cache Space
           ELSE IF @queryId = 161
           BEGIN
               SET @tmpStatus = @strGood
               SET @tmpResult = 'No Search Clouds are configured.<DELIM>'
			   SET @tmpRecommendation = 'No Search Clouds are configured.<DELIM>'
               DECLARE @totalSearchEngine      int = 0
               DECLARE @warningSearchEngine    int = 0
               DECLARE @criticalSearchEngine   int = 0
               DECLARE @goodSearchEngine       int = 0
               --DECLARE @infoSearchEngine     int = 0
               DECLARE @segCountCritical INT  =512
               DECLARE @segCountWarning INT  = 256
               DECLARE @tiiFileSizeLimit INT  = 600
               DECLARE @successfulObjectCritical INT  = 40
               DECLARE @successfulObjectWarning INT  = 20
               DECLARE @driveFreeSpaceCritical INT  = 35
               DECLARE @driveFreeSpaceWarning INT  = 50
               DECLARE @isSearchOnly INT  = 1
               --Disk space free: good:   > 25%   warning: 10 â€“ 25%, critical < 10%
               DECLARE @SearchEngineHealthNodeStatus TABLE
               (
				  ccuid int,
                  status NVARCHAR(MAX)
               )
               INSERT INTO @SearchEngineHealthNodeStatus
               SELECT
				   result.CCUID,
                   CASE WHEN ( ISNULL(csInfo.isSearchOnly, 0)  = @isSearchOnly
                               )
                       THEN @strGood
                       WHEN (   csInfo.SegmentCount                             >   @segCountCritical
                                OR  (csInfo.TermIndexFileSizeMB             >   @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) > @successfulObjectCritical )
                                OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >     csInfo.FreeSpaceMB
                                OR  csInfo.FreeSpaceMB = 0
                            )
                       THEN @strCritical
                        WHEN (  csInfo.SegmentCount                                 >=  @segCountWarning
                                OR  (csInfo.TermIndexFileSizeMB                     >=  @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) >= @successfulObjectWarning)
                                OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    > csInfo.FreeSpaceMB
                            )
                       THEN @strwarning
                   ELSE @strGood
                   END
               FROM
                   cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
                       INNER JOIN #latestResults AS result
                           ON result.SurveyResultId = csInfo.SurveyResultId
                           AND result.QueryID = @queryId
			  IF object_id('tempdb.dbo.#CCSearchEngine') is not null DROP TABLE #CCSearchEngine
			  CREATE TABLE #CCSearchEngine(CCUID INT, totalSearchEngine INT DEFAULT 0, goodSearchEngine INT DEFAULT 0, warningSearchEngine INT DEFAULT 0, criticalSearchEngine INT DEFAULT 0)
			  insert into #CCSearchEngine
				SELECT
					csInfo.CCUID,
					COUNT(*) AS totalSearchEngine,
					SUM(CASE WHEN status =@strGood THEN 1 ELSE 0 END) AS goodSearchEngine,
					SUM(CASE WHEN status =@strwarning THEN 1 ELSE 0 END) AS warningSearchEngine,
					SUM(CASE WHEN status =@strCritical THEN 1 ELSE 0 END) AS criticalSearchEngine
				FROM @SearchEngineHealthNodeStatus AS csInfo
				GROUP BY csInfo.CCUID
				UPDATE CC
					SET Status =
					CASE
                       WHEN P.totalSearchEngine = 0 THEN @strInfo
                       WHEN P.criticalSearchEngine > 0 THEN @strCritical
                       WHEN P.warningSearchEngine > 0 THEN @strwarning
                       ELSE @strGood
					END,
					Result =
					CASE
					WHEN (P.totalSearchEngine > 0)
						THEN  'Search Clouds: <DELIM>'
							+ 'Total : <B>'+ CAST(totalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Good : <B>' + CAST(goodSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning : <B>' + CAST(warningSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical : <B>' + CAST(criticalSearchEngine AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'No Search Clouds are configured.<DELIM>'
					END,
					Recommendation =
					CASE
						   WHEN criticalSearchEngine > 0 THEN @criticalMessage
						   WHEN warningSearchEngine  > 0 THEN @warningMessage
						   WHEN totalSearchEngine = 0 THEN @infoMessage
						   ELSE @goodMessage
					END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCSearchEngine P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCSearchEngine') is not null DROP TABLE #CCSearchEngine
			END
            ELSE IF @queryId = 95
            BEGIN
                SET @tmpStatus = @strInfo
                SET @tmpResult = 'There is no mount path configured.<DELIM>'
				SET @tmpRecommendation = 'There is no mount path configured.<DELIM>'
				IF object_id('tempdb.dbo.#CCMountPath') is not null DROP TABLE #CCMountPath
				create table #CCMountPath(ccuid int, totalMountPaths int)
				insert into #CCMountPath
                SELECT
					L.CommServUniqueId,
                    COUNT(MP.MountPathId)
                FROM
                    cf_SurveyMountPathSummary AS MP WITH (NOLOCK)
                    INNER JOIN cf_CommservSurveyResults R WITH (NOLOCK)
                        ON MP.SurveyResultId = R.CommservSurveyResults_ID AND R.QueryId = 117 AND R.Flags = 1
					INNER JOIN #commcells CC
						ON R.CommcellIdNameMap_ID = CC.CCUID
                    INNER JOIN cf_SurveyLibrary L WITH(NOLOCK)
						ON R.CommcellIdNameMap_ID = L.CommservUniqueId AND MP.LibraryId = L.LibraryId AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
                GROUP BY L.CommServUniqueId
				UPDATE CC
					SET Status = @strInfo,
					Result =
					CASE
					WHEN (P.totalMountPaths > 0)
						THEN  'Total configured Mount Paths: '
							+ '<B>'+ CAST(totalMountPaths AS NVARCHAR(5)) + '</B><BR/>'
						ELSE 'There is no mount path configured.<DELIM>'
					END,
					Recommendation =
					CASE
						   WHEN totalMountPaths = 0 THEN @infoMessage
						   ELSE @goodMessage
					END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCMountPath P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
				SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCMountPath') is not null DROP TABLE #CCMountPath
           END
           ELSE IF @queryId = 96
            BEGIN
                SET @tmpStatus = @strUnknown
                SET @tmpResult = ''
                IF object_id('tempdb.dbo.#CCDiskLib') is not null DROP TABLE #CCDiskLib
				CREATE TABLE #CCDiskLib(CCUID INT, totalDiskLib INT DEFAULT 0, goodDiskLib INT DEFAULT 0, warningDiskLib INT DEFAULT 0, criticalDiskLib INT DEFAULT 0, InfoDiskLib INT DEFAULT 0, unknownDiskLib INT DEFAULT 0)
                --Disk space free: good:   > 25%   warning: 10 ï¿½ 25%, critical < 10%
				IF object_id('tempdb.dbo.#DiskLibDays') is not null DROP TABLE #DiskLibDays
                CREATE TABLE #DiskLibDays
                (
					CCUID INT,
                    DiskLibId BIGINT,
                    MonthlyGrowthMB FLOAT,
                    DaysToBeFull BIGINT,
                    totalFreeSpaceGB FLOAT,
                    totalReserveSpaceGB FLOAT,
                    totalSpaceGB            FLOAT,
                    LogDateUTC                  DATETIME
                )
                INSERT INTO #DiskLibDays
                SELECT
					result.CCUID,
                    csInfo.LibraryId, 0,
                    -1,
                     ISNULL(csInfo.totalFreeSpaceGB, -2), -- here -1 is Used for Cloud Library
                     ISNULL(1.0*csInfo.totalReserveSpaceMB/1024, -2),
                     ISNULL(csInfo.totalSpaceGB, -2),
                     csInfo.LogDateUTC
                FROM
                    cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
                        INNER JOIN #latestResults AS result
                            ON result.SurveyResultId = csInfo.SurveyResultId
                            AND result.QueryID = @queryId
                        INNER JOIN cf_SurveyLibrary AS L WITH (NOLOCK)
                            ON csInfo.CommservUniqueId = L.CommServUniqueId AND csInfo.LibraryId = L.LibraryId AND L.LibraryTypeId = 3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0) AND L.Enabled = 1
				IF @useStoredPrediction = 0
				BEGIN
					DELETE FROM #GrowthData
					DELETE FROM #GrowthRate
					INSERT INTO #GrowthData
					SELECT  S.CommServUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), ISNULL(S.UsedSpaceMB, -1),
							ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
					FROM    cf_SurveyDiskLibraryPeakSize S WITH (NOLOCK)
							INNER JOIN #DiskLibDays T
								ON S.CommservUniqueId = T.CCUID AND S.LibraryId = T.DiskLibId
					WHERE   S.MonthStart >= @FirstMonth AND ISNULL(S.UsedSpaceMB, -1) > 0 AND T.totalSpaceGB > 0
					EXEC GetLinearGrowthRate 0
					UPDATE	S SET MonthlyGrowthMB = T.GrowthRate
					FROM	#DiskLibDays S
							INNER JOIN #GrowthRate T ON S.CCUID = T.CommservUniqueId AND S.DiskLibId = T.EntityId
					UPDATE  #DiskLibDays
					SET     DaysToBeFull = CASE
								WHEN 30.0*1024.0*(totalFreeSpaceGB-totalReserveSpaceGB)> MonthlyGrowthMB*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
								ELSE 30.0*1024.0*(totalFreeSpaceGB-totalReserveSpaceGB)/MonthlyGrowthMB - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
					WHERE   ABS(ISNULL(MonthlyGrowthMB, 0)) > 0.001 AND (totalFreeSpaceGB - totalReserveSpaceGB) > 0
					UPDATE  #DiskLibDays SET DaysToBeFull = 0
					WHERE   (totalFreeSpaceGB - totalReserveSpaceGB) <= 0 AND totalFreeSpaceGB >= 0
				END
				ELSE
				BEGIN
					-- Use stored prediction from DiskLibraryPrediction
					UPDATE S
					SET S.DaysToBeFull = P.DaysToBeFull,
						S.MonthlyGrowthMB = P.MonthlyGrowthRate
					FROM #DiskLibDays S
					INNER JOIN (
						SELECT CommServUniqueId, LibraryId, MAX(LogDateUTC) AS LogDate
						FROM DiskLibraryPrediction
						GROUP BY CommServUniqueId, LibraryId) AS P0
						ON @i_CommServUniqueId = P0.CommServUniqueId AND S.DiskLibId = P0.LibraryId
					INNER JOIN DiskLibraryPrediction P
					ON P.CommServUniqueId = P0.CommServUniqueId AND P.LibraryId = P0.LibraryId AND P.LogDateUTC = P0.LogDate
				END
				INSERT INTO #CCDiskLib(CCUID, totalDiskLib, warningDiskLib, criticalDiskLib, InfoDiskLib, unknownDiskLib)
				SELECT
					CC.CCUID,
					COUNT(*),
					SUM( CASE WHEN totalSpaceGB > 0 AND DaysToBeFull BETWEEN @criticalThreshold AND @warningThreshold THEN 1 ELSE 0 END),
					SUM( CASE WHEN totalSpaceGB > 0 AND DaysToBeFull < @criticalThreshold AND DaysToBeFull >= 0 THEN 1 ELSE 0 END),
					SUM( CASE WHEN totalSpaceGB = -1 AND totalFreeSpaceGB = -1 THEN 1 ELSE 0 END),
					SUM( CASE WHEN totalSpaceGB <= 0 AND totalFreeSpaceGB <> -1 THEN 1 ELSE 0 END)
				FROM #DiskLibDays CC
				GROUP BY CC.CCUID
				UPDATE #CCDiskLib SET goodDiskLib = totalDiskLib -  warningDiskLib - criticalDiskLib - InfoDiskLib - unknownDiskLib
				UPDATE CC
					SET Status = CASE WHEN totalDiskLib = 0 THEN @strInfo
                        WHEN totalDiskLib = InfoDiskLib THEN @strInfo
                        WHEN totalDiskLib = unknownDiskLib THEN @strUnknown
                        WHEN criticalDiskLib > 0 THEN @strCritical
                        WHEN warningDiskLib > 0 THEN @strwarning
                        ELSE @strGood END,
					Result =
					CASE
					WHEN (P.totalDiskLib > 0)
						THEN  'Disk Library distribution by estimated days to be full: <DELIM>'
                        + 'Total : <B>'+ CAST(totalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                        + 'Good : <B>' + CAST(goodDiskLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                        + 'Warning : <B>' + CAST(warningDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                        + 'Critical : <B>' + CAST(criticalDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                        + '<DELIM>Info : <B>' + CAST(InfoDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
                        + CASE WHEN (unknownDiskLib = 0)
                            THEN ''
						    ELSE 'Not Ready : <B>' + CAST(unknownDiskLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						  END
						ELSE 'There is no disk library configured.<DELIM>'
					END,
					Recommendation =
					CASE
						   WHEN totalDiskLib = 0 THEN @infoMessage
							WHEN totalDiskLib > 0 AND totalDiskLib = unknownDiskLib THEN @infoMessage+'<VDL>'
							WHEN totalDiskLib > 0 AND criticalDiskLib = 0 AND warningDiskLib = 0 THEN @goodMessage
							ELSE @warningMessage
					END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCDiskLib P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = 'There is no disk library configured.<DELIM>',
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#DiskLibDays') is not null DROP TABLE #DiskLibDays
				IF object_id('tempdb.dbo.#CCDiskLib') is not null DROP TABLE #CCDiskLib
           END
           ELSE IF @queryId = 196
            BEGIN
				--Using query 96 for this
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(96, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				SET @tmpStatus = @strInfo
                SET @tmpResult = 'There is no cloud library configured.<DELIM>'
				SET @tmpRecommendation = 'There is no cloud library configured.<DELIM>'
                DECLARE @CloudLib TABLE
                (
					CCUID INT,
                    LibraryId INT,
                    totalDataWrittenGB FLOAT
                )
                INSERT INTO @CloudLib
                SELECT
					csInfo.CommServUniqueId,
                    csInfo.LibraryId,
                    ISNULL(csInfo.totalDataWrittenGB, 0)
                FROM
                    cf_Survey96DiskLibDetails AS csInfo WITH (NOLOCK)
                        INNER JOIN #latestResults AS result
                            ON result.SurveyResultId = csInfo.SurveyResultId
                            AND result.QueryID = 96
                        INNER JOIN cf_SurveyLibrary AS L WITH (NOLOCK)
                            ON csInfo.CommservUniqueId = L.CommServUniqueId AND csInfo.LibraryId = L.LibraryId AND L.LibraryTypeId = -3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
				IF object_id('tempdb.dbo.#CCCloudLib') is not null DROP TABLE #CCCloudLib
				create table #CCCloudLib(CCUID int, totalCloudLib int, usedCloudLib int)
				insert into #CCCloudLib
				select
					csInfo.CCUID,
					COUNT(LibraryId) AS totalCloudLib,
					SUM(CASE WHEN totalDataWrittenGB > 0 THEN 1 ELSE 0 END) AS usedCloudLib
				FROM @CloudLib AS csInfo
				GROUP BY csInfo.CCUID
				UPDATE CC
					SET Status = @strInfo,
					Result =
					CASE
					WHEN (P.totalCloudLib > 0)
						THEN  'Configured cloud Libraries: <DELIM>'
							+ 'Total : <B>'+ CAST(totalCloudLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Used  : <B>' + CAST(usedCloudLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						ELSE 'There is no cloud library configured.<DELIM>'
					END,
					Recommendation =
					CASE
							WHEN totalCloudLib > 0 THEN @goodMessage
							ELSE @infoMessage
					END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM
					ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #CCCloudLib P
					ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCCloudLib') is not null DROP TABLE #CCCloudLib
            END
           --Capacity License Usage
           ELSE IF @queryId = 1 AND @parameterName = 'Capacity License Usage'
           BEGIN
			   IF object_id('tempdb.dbo.#CCCapacityLic') is not null DROP TABLE #CCCapacityLic
			   create table #CCCapacityLic(CCUID int, CommvaultCompleteEnabled int,TotalBackupSize  BIGINT default -1, TotalLoanedBkpSize BIGINT default -1, UsedBackupSize BIGINT default 0, TotalArchiveSize BIGINT default -1, TotalLoanedArcSize BIGINT default -1, UsedArchiveSize BIGINT default 0)
			   insert #CCCapacityLic(CCUID, TotalBackupSize,TotalLoanedBkpSize,UsedBackupSize,TotalArchiveSize,TotalLoanedArcSize,UsedArchiveSize)
               SELECT
				   result.ccuid,
				   ISNULL(csInfo.TotalBackupSize, -1),
                   ISNULL(csInfo.EvalBackupSizeMB, 0),
                   ISNULL(csInfo.BackupSize, 0),
                   ISNULL(csInfo.TotalArchiveSize, -1),
                   ISNULL(csInfo.EvalArchiveSizeMB, 0),
                   ISNULL(csInfo.ArchiveSize, 0)
               FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
                   INNER JOIN #latestResults AS result
                       ON result.SurveyResultId = csInfo.SurveyResultId
                       AND result.QueryID = @queryId
                UPDATE CCC
                SET CommvaultCompleteEnabled = 1
                FROM #CCCapacityLic CCC
                INNER JOIN Lic_LicenseInfo LiA ON LiA.CommServUniqueId = CCC.CCUID AND LiA.LicType = 205
				INNER JOIN Lic_LicenseInfo A ON A.CommServUniqueId = CCC.CCUID AND A.LicType = 100002
				INNER JOIN Lic_LicenseInfo B ON B.CommServUniqueId = CCC.CCUID AND B.LicType = 100004
				WHERE   B.PermTotal = A.PermTotal AND B.EvalTotal = A.EvalTotal AND B.TermDate = A.TermDate
				UPDATE CC
					SET Status = @strInfo,
					Result = CASE WHEN ISNULL(P.CommvaultCompleteEnabled,0) = 1 THEN 'Purchased Commvault Complete Size: <b>' + CAST(CAST(TotalBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b>, '
					   + 'Loaned Commvault Complete Size : <b>' + CAST(CAST(TotalLoanedBkpSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					   + 'Used Commvault Complete Size : <b>' + CAST(CAST(UsedBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					ELSE 'Purchased Backup Size: <b>' + CAST(CAST(TotalBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b>, '
					   + 'Loaned Backup Size : <b>' + CAST(CAST(TotalLoanedBkpSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					   + 'Used Backup Size : <b>' + CAST(CAST(UsedBackupSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					   + 'Purchased Archive Size : <b>' + CAST(CAST(TotalArchiveSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20)) + ' TB</b>, '
					   + 'Loaned Archive Size : <b>' + CAST(CAST(TotalLoanedArcSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20))  + ' TB</b><DELIM>'
					   + 'Used Archive Size : <b>' + CAST(CAST(UsedArchiveSize/(1024.0*1024.0) AS DECIMAL(32,2)) AS VARCHAR(20)) + ' TB</b><DELIM>' END,
					Recommendation = @infoMessage,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCapacityLic P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC SET CC.Recommendation = Recommendation + '<VDL><VDL_CR>License%20Summary%20Worldwide&input.CommCell='+ CAST(CC.CommServUniqueId AS NVARCHAR(10)) + '&commUniId=' + CAST(CC.CommServUniqueId AS NVARCHAR(10)) + '</VDL_CR>'
				FROM #TblSurveyResult CC
				INNER JOIN cf_CommcellIdNameMap CSV
					ON CC.CommServUniqueId = CSV.ID
				CROSS APPLY dbo.SplitVersionString(CSV.CommServVersion) R
				WHERE R.Release >= 11 AND R.ServicePack >= 15
				AND CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CCCapacityLic') is not null DROP TABLE #CCCapacityLic
           END
           ELSE IF @queryId = 1 AND @parameterName = 'License Usage'
           BEGIN
				IF object_id('tempdb.dbo.#CCCapacityUsg') is not null DROP TABLE #CCCapacityUsg
				create table #CCCapacityUsg(
					ccuid int,
					VMSockets BIGINT default 0,
					ProtectedVMs BIGINT default 0,
					ArchivedMailBox BIGINT default 0,
					EndpointUsers BIGINT default 0,
					SharingUsers BIGINT default 0,
					eDiscoveryUsers BIGINT default 0)
				insert into #CCCapacityUsg
				SELECT
					result.ccuid,
					ISNULL(csInfo.VMSockets, 0),
					ISNULL(csInfo.ProtectedVMs, 0),
					ISNULL(csInfo.ArchivedMailBoxes, 0),
					ISNULL(csInfo.EndpointUsers, 0),
					ISNULL(csInfo.SharingUsers, 0),
					ISNULL(csInfo.eDiscoveryUsers, 0)
				FROM cf_SurveyCapacityLicenseUsage AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = @queryId
				UPDATE CC
					SET Status = @strInfo,
					Result = 'VM Sockets : <b>' + CAST(VMSockets AS VARCHAR(20)) + '</b>'
							+ ', VMs : <b>' + CAST(ProtectedVMs AS VARCHAR(20)) + '</b>'
							+ ', Archived MailBoxes : <b>' + CAST(ArchivedMailBox AS VARCHAR(20)) + '</b><DELIM>'
							+ 'Users : <b>' + CAST(EndpointUsers AS VARCHAR(20)) + '</b>'
							+ ', Sharing Users : <b>' + CAST(SharingUsers AS VARCHAR(20)) + '</b>'
							+ ', eDiscovery Users : <b>' + CAST(eDiscoveryUsers AS VARCHAR(20)) + '</b>',
					Recommendation = @infoMessage,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCapacityUsg P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#CCCapacityUsg') is not null DROP TABLE #CCCapacityUsg
           END
           --Snapshot Engine Usage
           ELSE IF @queryId = 4
           BEGIN
               DECLARE @snapEnginesUsed NVARCHAR(MAX)
			   IF object_id('tempdb.dbo.#snapEnginesUsed') is not null DROP TABLE #snapEnginesUsed
			   create table #snapEnginesUsed(ccuid int, snapEnginesUsed NVARCHAR(MAX))
               DECLARE  @tbl TABLE (ccuid int, name nvarchar(max))
               INSERT INTO @tbl
               SELECT distinct result.CCUID, csInfo.snapEngineName
               FROM cf_Survey4SnapInfo AS csInfo WITH (NOLOCK)
                   INNER JOIN #latestResults AS result
                       ON result.SurveyResultId = csInfo.SurveyResultId
                       AND result.QueryID = @queryId
				insert into #snapEnginesUsed
				select ccuid, name =
					STUFF((SELECT ', ' + name
						   FROM @tbl b
						   WHERE b.ccuid = a.ccuid
						  FOR XML PATH('')), 1, 2, '')
				FROM @tbl a
				GROUP BY ccuid
			    UPDATE CC
					SET Status = @strInfo,
					Result = case when ISNULL(snapEnginesUsed, '') = ''  then 'Snap Engines are not used'
						else
							'<b>Below Snap Engines are used</b><DELIM>' + snapEnginesUsed
						   end,
					Recommendation = case when ISNULL(@snapEnginesUsed, '') = '' then @criticalMessage
									else @infoMessage
									end,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #snapEnginesUsed P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @strInfo,
					Result = 'Snap Engines are not used',
					Recommendation = '<VDL>',
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#snapEnginesUsed') is not null DROP TABLE #snapEnginesUsed
           END
            --High-Risk Settings -
           ELSE IF @queryId = 124
            BEGIN
				IF object_id('tempdb.dbo.#HighRisk') is not null DROP TABLE #HighRisk
				CREATE TABLE #HighRisk(CCUID INT,settingValue INT)
				INSERT INTO #HighRisk
                SELECT ccuid, csInfo.Value
                FROM cf_surveyHighRiskSettings AS csInfo WITH (NOLOCK)
				INNER JOIN #latestResults AS result
					ON result.SurveyResultId = csInfo.SurveyResultId
					AND result.QueryID = @queryId
					AND csInfo.Name = 'Prune All Database Agent Logs Only By Days Retention Rule'
				UPDATE CC
				SET Status = CASE WHEN settingValue = 0 THEN @strGood ELSE @strCritical END,
				Result = CASE
                        WHEN settingValue = 0 THEN 'Prune all database agent logs only by days retention rule option: Disabled'
                        ELSE 'Prune all database agent logs only by days retention rule option: Enabled'
						END,
				Recommendation = CASE WHEN settingValue = 0 THEN @goodMessage ELSE @CriticalMessage END,
				LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #HighRisk P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF object_id('tempdb.dbo.#HighRisk') is not null DROP TABLE #HighRisk
            END
			--Security Assessment
			ELSE IF @queryId = 250
				BEGIN
					IF object_id('tempdb.dbo.#SecurityAssociationSummary') is not null DROP TABLE #SecurityAssociationSummary
					CREATE TABLE #SecurityAssociationSummary (ccid int,good int, warning int, critical int, info int, total int)
					--will insert into this table from GetSecurityAssociation SP
					EXEC	[dbo].[GetSecurityAssociationDetails]
						@i_CommServUniqueID = @i_CommServUniqueId,
						@blaggregate = 0,
						@i_UserId = @i_UserId,
						@i_GroupId = @i_GroupId
					UPDATE CC
						SET Status = CASE WHEN CAST(SAS.critical AS NVARCHAR(5)) != 0
													THEN @strCritical
												WHEN CAST(SAS.warning AS NVARCHAR(5)) != 0
													THEN @strwarning
												ELSE @strGood
												END,
						Result  =	'Security Settings: <DELIM>'
										+ 'Total: <B>'+ ISNULL( (SELECT CAST(SAS.total AS NVARCHAR(5)) ), '0') + '</B>&nbsp&nbsp'
										+ 'Info: <B>'+ ISNULL( (SELECT CAST(SAS.info AS NVARCHAR(5)) ), '0')+ '</B>&nbsp&nbsp'
										+ 'Good: <B>' + ISNULL( (SELECT CAST(SAS.good AS NVARCHAR(5)) ), '0') + '</B>&nbsp&nbsp'
										+ 'Warning: <B>' + ISNULL( (SELECT CAST(SAS.warning AS NVARCHAR(5)) ), '0') + '</B>&nbsp&nbsp'
										+ 'Critical: <B>' + ISNULL( (SELECT CAST(SAS.critical AS NVARCHAR(5)) ), '0') + '</B>&nbsp&nbsp<DELIM>',
						Recommendation = CASE WHEN Status = @strCritical
													THEN @criticalMessage
												WHEN Status = @strwarning
													THEN @warningMessage
												ELSE @goodMessage
												END,
						LogDate = COM.LogDate
						FROM #TblSurveyResult CC
						inner JOIN #commcells COM ON COM.CCUID = CC.CommServUniqueId
						inner join #SecurityAssociationSummary SAS ON SAS.ccid = CC.CommServUniqueId
						WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					IF object_id('tempdb.dbo.#SecurityAssociationSummary') is not null DROP TABLE #SecurityAssociationSummary
			END
            -- scale statistics
            ELSE IF @queryId = 7
            BEGIN
                DECLARE @outputParam TABLE
                (
						CCUID INT,
                        status        varchar(20),
                        outcome     varchar(1024),
                        statusINT   INT
                )
				--TODO: Result and recommendation computation will work only for single CommCell health report. Fix needed to support multicommcell health.
				set @tmpResult =  ''
				IF (@i_CommServUniqueId > 0)
				begin
					INSERT INTO @outputParam
					SELECT DISTINCT @i_CommServUniqueId, STATUS, outcome, statusINT
					FROM dbo.RptGetScaleHealthFunc(@i_UserId,@i_GroupId,1,1,@i_CommServUniqueId,null,null,'',1)
					UPDATE @outputParam SET status = (SELECT MAX(status) FROM @outputParam)
					SELECT	@tmpResult = (case WHEN statusINT =3 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
                                            WHEN statusINT =2 then COALESCE(@tmpResult + '<DELIM> ', '') +outcome
                                            ELSE outcome
                                            end),
							@tmpRecommendation = (case WHEN statusINT =3 then @criticalMessage
                                            WHEN statusINT =2 then @warningMessage
                                            WHEN statusINT =1 then @goodMessage
                                            else @goodMessage
                                            end )
											from @outputParam
				end
				IF (@i_GroupId > 0)
				BEGIN
					INSERT INTO @outputParam
					select c.CCUID, max(res.status), '', '' from #commcells c
					cross apply dbo.RptGetScaleHealthFunc(@i_UserId, @i_GroupId, 1, 1, c.CCUID, null, null, '', 1) res
					group by c.CCUID
				END
                UPDATE CC
					SET Status = ISNULL(JJ.STATUS,@strInfo),
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN @outputParam JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
            END
            --Database Index Fragmentation
            ELSE IF @queryId = 144
            BEGIN
				DECLARE @Flag INT = 0
 					DECLARE @csInstallDate DATETIME
 					SELECT @csInstallDate = sub.InstallDate from
 								(SELECT
 									resultView.CommServUniqueId AS CommServUniqueId,
 									csInfo.InstallTime  AS InstallDate,
 									ROW_NUMBER() OVER (PARTITION BY resultView.CommServUniqueId ORDER BY csInfo.ReleaseId ) AS RowId
 									FROM cf_SurveyUpgradeHistory AS csInfo WITH (NOLOCK)
 									INNER JOIN dbo.cf_SurveyResultFuncV1(38, @i_CommServUniqueId, 1, NULL, NULL, 1, 0) AS resultView
 										ON resultView.SurverResultId = csInfo.SurveyResultId
 										AND csInfo.ReleaseId > 0
 									)sub
 						where  sub.RowId = 1
 					IF (@csInstallDate+21 > GETDATE())
 					BEGIN
 							UPDATE CC
							SET Status = @strGood,
							Result = 'New installation',
							Recommendation = @warningMessage,
							LogDate = JJ.LogDate
						FROM #TblSurveyResult CC
							INNER JOIN #commcells JJ
								ON CC.CommServUniqueId = JJ.CCUID
						WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
 							SET @Flag = 1
 					END
 			IF (@Flag = 0)
 			BEGIN
                DECLARE @TblFragmentation TABLE (ccuid int, DatabaseName VARCHAR(32), OperationalIndexCount INT, WarningIndexCount INT, CriticalIndexCount INT,LastFullReindexOperation INT)
                INSERT INTO @TblFragmentation
                SELECT result.CCUID,
					csInfo.DatabaseName,
                    SUM(CASE WHEN csInfo.FragmentationPct = 102 THEN IndexCount ELSE 0 END), --102: Total operational Indexes
                    SUM(CASE WHEN csInfo.FragmentationPct >= @warningThreshold AND csInfo.FragmentationPct < @criticalThreshold THEN IndexCount ELSE 0 END),
                    SUM(CASE WHEN csInfo.FragmentationPct >= @criticalThreshold AND csInfo.FragmentationPct < 100 THEN IndexCount ELSE 0 END),MAX(LastFullReindexOperation)
                FROM cf_SurveyIndexFragmentation AS csInfo WITH (NOLOCK)
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryId = @queryId
                GROUP BY DatabaseName, result.CCUID
				IF object_id('tempdb.dbo.#TblFragmentation') is not null DROP TABLE #TblFragmentation
				create table #TblFragmentation (ccuid int, OperationalIndexCount INT, GoodIndexCount INT, WarningIndexCount INT, CriticalIndexCount INT,LastFullReindexOperation INT )
				insert into #TblFragmentation
				SELECT  ccuid,
					SUM(OperationalIndexCount),
					SUM(OperationalIndexCount - WarningIndexCount - CriticalIndexCount),
					SUM(WarningIndexCount),
					SUM(CriticalIndexCount),ISNULL(MAX(LastFullReindexOperation),0)
				FROM @TblFragmentation cc
				group by ccuid
               --v10 /v9.0
				UPDATE CC
				SET Status = CASE WHEN CriticalIndexCount > 0.25*OperationalIndexCount THEN @strCritical
								  when WarningIndexCount > 0.25*OperationalIndexCount then  @strWarning
							  ELSE @strGood END,
				Result = 'Operational Indexes: <B>' + CAST(OperationalIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp < 30% Fragmented: <B>' + CAST(GoodIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp >30% and <50% Fragmented: <B>' + CAST(WarningIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp >50% Fragmented: <B>' + CAST(CriticalIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp',
				Recommendation = CASE WHEN CriticalIndexCount > 0.25*OperationalIndexCount THEN @criticalMessage
								when WarningIndexCount > 0.25*OperationalIndexCount then @warningMessage
								else @goodMessage END,
				LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #TblFragmentation P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) 	and Com.Version<11
                --v11
				UPDATE CC
				SET Status = CASE WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) <= 7) OR (CriticalIndexCount=0 and WarningIndexCount=0) THEN  @strGood
								  WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) BETWEEN  7 AND 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN @strWarning
								  WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) > 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN @strCritical
				END,
				Result = 'Operational Indexes: <B>' + CAST(OperationalIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp < 30% Fragmented: <B>' + CAST(GoodIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp  >30% and <50% Fragmented: <B>' + CAST(WarningIndexCount AS NVARCHAR(MAX)) + '</B>&nbsp&nbsp >50% Fragmented: <B>' + CAST(CriticalIndexCount AS NVARCHAR(MAX)) + CASE WHEN LastFullReindexOperation>0 THEN '</B>&nbsp&nbsp Last DB Maintenance: <UNIX>'+ convert(nvarchar(MAX), LastFullReindexOperation) +'</UNIX>&nbsp&nbsp' ELSE '' END,
				Recommendation = CASE WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) <= 7) OR (CriticalIndexCount=0 and WarningIndexCount=0) THEN  @goodMessage
								  WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) BETWEEN  7 AND 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN @warningMessage
								  WHEN (DATEDIFF(day,dbo.GetDateTime(LastFullReindexOperation),getdate()) > 30) AND (WarningIndexCount>0 or CriticalIndexCount >0 ) THEN @criticalMessage
				END,
				LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #TblFragmentation P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) 	AND Com.Version>=11
				UPDATE CC
					SET Status = @strUnknown,
					Result = 'No data available',
					Recommendation = '',
					LogDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#TblFragmentation') is not null DROP TABLE #TblFragmentation
			END
            END
           --Disk Pruning
           ELSE IF @queryId = 156
           BEGIN
				--Using query 65 and 35
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(65, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(35, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
			   IF object_id('tempdb.dbo.#DDBTable') is not null DROP TABLE #DDBTable
			   create table #DDBTable(ccuid int, criticalNo int default 0, warningNo int default 0, totalNo int default 0)
               declare @DDBTable table
               (
				   ccuid int,
                   PrimaryRecords bigint,
                   ZeroRefCount    bigint,
                   SevenDaysOldMMDeletedAFtable bigint,
				   criticalAFVal int,
				   warningAFVal int
               )
               DECLARE @criticalAFVal int = 10000
               DECLARE @warningAFVal int  = 5000
               INSERT INTO @DDBTable
               SELECT csinfo.CommServUniqueId, PrimaryRecords, ZeroRefCount, AF.SevenDaysOldMMDeletedAFtable,
			   @criticalAFVal,
			   @warningAFVal
			   FROM cf_SurveyDDBPerformance csInfo
					INNER JOIN #latestResults AS result
						ON result.SurveyResultId = csInfo.SurveyResultId
						AND result.QueryID = 65
						AND ISNULL(PrimaryRecords,-1) > -1
						AND ISNULL(ZeroRefCount,-1) > -1
					INNER JOIN (
								SELECT CO.CCUID, DD.SIDBStoreId, DD.SevenDaysOldMMDeletedAFtable
									FROM cf_SurveyDeDupDeletedAFCount AS DD WITH (NOLOCK)
										INNER JOIN #latestResults R
											ON DD.SurveyResultId = R.SurveyResultId
											AND R.QueryId = 35
										INNER JOIN #commcells CO
											ON CO.CCUID = R.CCUID
								) AS AF
						ON RESULT.CCUID = AF.CCUID AND csInfo.SidbStoreId = AF.SIDBStoreId
					INNER JOIN #commcells cc
						ON CC.CCUID = RESULT.CCUID
				UPDATE DDB
				SET DDB.criticalAFVal = CT.attrval
				FROM  @DDBTable DDB INNER JOIN cf_SurveyCommcellThresholdInfo CT
				ON DDB.ccuid = CT.CommServUniqueId
				WHERE CT.ENTITYID =1 AND CT.attrName ='DDBPendingDeleteCriticalLimit' and CT.attrtype =10
				UPDATE DDB
				SET DDB.warningAFVal = CT.attrval
				FROM  @DDBTable DDB INNER JOIN cf_SurveyCommcellThresholdInfo CT
				ON DDB.ccuid = CT.CommServUniqueId
				WHERE CT.ENTITYID =1 AND CT.attrName ='DDBPendingDeleteWarningLimit' and CT.attrtype =10
			   INSERT INTO #DDBTable(CCUID, totalNo, warningNo, criticalNo)
				SELECT
					csInfo.CCUID,
					COUNT(*) AS totalNo,
					SUM(CASE WHEN PrimaryRecords > 0 AND ZeroRefCount >= (@warningThreshold * (ZeroRefCount + PrimaryRecords) /100.0) AND ZeroRefCount < (@criticalThreshold * (ZeroRefCount + PrimaryRecords) /100.0) OR SevenDaysOldMMDeletedAFtable BETWEEN warningAFVal AND criticalAFVal THEN 1 ELSE 0 END) AS warningNo,
					SUM(CASE WHEN PrimaryRecords > 0 AND ZeroRefCount >= (@criticalThreshold * (ZeroRefCount + PrimaryRecords) /100.0) OR SevenDaysOldMMDeletedAFtable > criticalAFVal THEN 1 ELSE 0 END) AS criticalNo
				FROM @DDBTable AS csInfo
				GROUP BY csInfo.CCUID
				UPDATE CC
					SET Status = CASE WHEN P.totalNo = 0 THEN @strInfo
								 WHEN P.criticalNo > 0 THEN @strCritical
								 WHEN P.warningNo > 0 THEN @strwarning
								ELSE @strGood END,
					Result =
						CASE
						WHEN (P.totalNo > 0)
							THEN  'Dedupe Stores: <DELIM>'
							+ 'Total: <B>'+ CAST(totalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Good: <B>' + CAST((totalNo-warningNo-criticalNo) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(warningNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(criticalNo AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							ELSE 'There are no Media Agents hosting DDB store.<DELIM>'
						END,
					Recommendation =
						CASE
						   WHEN totalNo = 0 THEN @infoMessage
						   WHEN totalNo > 0 AND criticalNo = 0 AND warningNo = 0 THEN @goodMessage
						   ELSE @warningMessage END,
					LogDate= COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #DDBTable P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @strInfo,
					Result = 'There are no Media Agents hosting DDB store.<DELIM>',
					Recommendation = '',
					LogDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#DDBTable') is not null DROP TABLE #DDBTable
           END
            ELSE IF @queryId = 181
            BEGIN
				SET @tmpStatus = @strGood
				SET @tmpRecommendation = '<VDL>'
				IF object_id('tempdb.dbo.#CCVMDetails') is not null DROP TABLE #CCVMDetails
				create table #CCVMDetails(ccuid int, totVms INT default 0,WarningVms INT default 0, CriticalVms INT default 0, GoodVms INT default 0)
                declare @liveSyncVmDetails table
                (
					ccuid int,
                    SourceVMClientName          NVARCHAR(256),
                    Status                      INT
                )
                INSERT INTO @liveSyncVmDetails
                SELECT result.CCUID,
					vmInfo.SourceVMClientName,
                CASE
                    WHEN vmInfo.Status = 6 THEN 3
					WHEN (vmInfo.Status = 5 OR DATEDIFF(d, dbo.GetDateTime(vmInfo.LastRestoreTime), SYSDATETIME()) > 7) THEN  4
                    ELSE 1
                END
                FROM cf_SurveyLiveSyncVMDetails AS vmInfo with (NOLOCK)
                INNER JOIN #latestResults AS result
                    ON result.SurveyResultId = vmInfo.SurveyResultId AND result.QueryID = @queryId
                insert into #CCVMDetails
				SELECT
					ccuid,
					COUNT(*) as totVms,
					sum (case when Status = 3 then 1 else 0 end) as WarningVms,
					sum (case when Status = 4 then 1 else 0 end) as CriticalVms,
					sum (case when Status = 1 then 1 else 0 end) as GoodVms
				from @liveSyncVmDetails
				group by ccuid
				UPDATE CC
				SET Status = CASE WHEN P.CriticalVms > 0 THEN @strCritical
							 WHEN P.WarningVms > 0 THEN @strwarning
							ELSE @strGood END,
				Result =
					'Total VM(s): <B>'+ CAST(totVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Good: <B>' + CAST((GoodVms) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Warning: <B>' + CAST(WarningVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
					+ 'Critical: <B>' + CAST(CriticalVms AS NVARCHAR(5)) + '</B>&nbsp&nbsp',
				Recommendation =
                    CASE WHEN P.CriticalVms > 0 THEN @criticalMessage
						WHEN P.WarningVms > 0 THEN @warningMessage
						ELSE @goodMessage
					END,
				LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCVMDetails P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = 'Total VM(s): <B>'+ CAST(0 AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						+ 'Good: <B>' + CAST((0) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						+ 'Warning: <B>' + CAST(0 AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
						+ 'Critical: <B>' + CAST(0 AS NVARCHAR(5)) + '</B>&nbsp&nbsp',
					Recommendation = @tmpRecommendation,
					LogDate = jj.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCVMDetails') is not null DROP TABLE #CCVMDetails
            END
            -- Tape Library Growth
            ELSE IF @queryId = 186
            BEGIN
                SET @tmpStatus = @strInfo
                SET @tmpResult = ''
				IF object_id('tempdb.dbo.#CCTapeLib') is not null DROP TABLE #CCTapeLib
				CREATE TABLE #CCTapeLib(CCUID INT, totalTapeLib INT DEFAULT 0, goodTapeLib INT DEFAULT 0, warningTapeLib INT DEFAULT 0, criticalTapeLib INT DEFAULT 0, InfoTapeLib INT DEFAULT 0)
                DECLARE @LibraryInfo TABLE
                (
					CCUID INT,
                    LibraryId       INT,
                    MonthlyGrowth   FLOAT,
                    DaysToBeFull    BIGINT,
                    UsedTapeCount   FLOAT,
                    SpareTapeCount  FLOAT,
                    TotalTapeCount  FLOAT,
                    LogDateUTC      DATETIME
                )
                INSERT INTO @LibraryInfo
                SELECT  CCUID, L.LibraryId, 0, NULL, L.UsedTapeCount, L.SpareTapeCount, (L.UsedTapeCount + L.SpareTapeCount), R.LogDateUTC
                FROM    cf_SurveyTapeUsageByLibrary AS L WITH (NOLOCK)
					INNER JOIN #latestResults AS R
						ON R.SurveyResultId = L.SurveyResultId AND R.QueryID = @queryId
                    INNER JOIN cf_SurveyLibrary LP WITH(NOLOCK)
						ON R.CCUID = LP.CommservUniqueId AND L.LibraryId = LP.LibraryId AND (@showHiddenLibraries = 1 OR LP.Hidden = 0)
				DELETE FROM #GrowthData
				DELETE FROM #GrowthRate
				INSERT INTO #GrowthData
				SELECT  S.CommServUniqueId, S.LibraryId, '', DATEDIFF(MONTH, @CurrMonth, S.MonthStart), S.UsedTapeCount,
						ROW_NUMBER() OVER (PARTITION BY S.CommservUniqueId, S.LibraryId ORDER BY S.MonthStart)
				FROM    cf_SurveyMonthlyTapeUsageByLibrary S WITH (NOLOCK)
						INNER JOIN @LibraryInfo T ON S.CommservUniqueId = T.CCUID AND S.LibraryId = T.LibraryId
				WHERE   S.MonthStart >= @FirstMonth AND S.UsedTapeCount > 0 AND T.TotalTapeCount > 0
				EXEC GetLinearGrowthRate 0
				UPDATE	S SET MonthlyGrowth = T.GrowthRate
				FROM	@LibraryInfo S
						INNER JOIN #GrowthRate T ON S.CCUID = T.CommservUniqueId AND S.LibraryId = T.EntityId
                UPDATE  @LibraryInfo
                SET     DaysToBeFull = CASE
							WHEN 30.0*SpareTapeCount > MonthlyGrowth*(DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) + 9999) THEN 10000
							ELSE 30.0*SpareTapeCount/MonthlyGrowth - DATEDIFF(DAY, LogDateUTC, GETUTCDATE()) END
                WHERE   ABS(ISNULL(MonthlyGrowth, -1)) > 0.001 AND SpareTapeCount > 0
				INSERT INTO #CCTapeLib(CCUID, totalTapeLib, InfoTapeLib, warningTapeLib, criticalTapeLib)
				SELECT
					CC.CCUID,
					COUNT(*),
					SUM(CASE WHEN TotalTapeCount <= 0 THEN 1 ELSE 0 END),
					SUM(CASE WHEN TotalTapeCount > 0 AND ISNULL(DaysToBeFull, -1) BETWEEN @criticalThreshold AND @warningThreshold THEN 1 ELSE 0 END),
					SUM(CASE WHEN TotalTapeCount > 0 AND ISNULL(DaysToBeFull, 9999) < @criticalThreshold THEN 1 ELSE 0 END)
				FROM @LibraryInfo CC
				GROUP BY CC.CCUID
				UPDATE #CCTapeLib SET goodTapeLib     =totalTapeLib - InfoTapeLib - warningTapeLib - criticalTapeLib
				UPDATE CC
					SET Status = CASE
							WHEN totalTapeLib = 0 THEN @strInfo
							WHEN totalTapeLib = InfoTapeLib THEN @strInfo
							WHEN criticalTapeLib > 0 THEN @strCritical
							WHEN warningTapeLib > 0 THEN @strwarning
							ELSE @strGood
						END,
					Result = CASE WHEN totalTapeLib > 0
						THEN 'Tape Library distribution by estimated days to be full: <DELIM>'
							+ 'Total : <B>'+ CAST(totalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Good : <B>' + CAST(goodTapeLib  AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning : <B>' + CAST(warningTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical : <B>' + CAST(criticalTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ '<DELIM>Info : <B>' + CAST(InfoTapeLib AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							ELSE 'There is no tape library configured.<DELIM>'
						END,
					Recommendation =
						CASE
							WHEN totalTapeLib = 0 THEN @infoMessage
							WHEN totalTapeLib > 0 AND criticalTapeLib = 0 AND warningTapeLib = 0 THEN @goodMessage
							ELSE @warningMessage
						END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM
					ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #CCTapeLib P
					ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @tmpStatus,
					Result = 'There is no tape library configured.<DELIM>',
					Recommendation = @tmpRecommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#TblLeastSquareData') is not null DROP TABLE #TblLeastSquareData
				IF object_id('tempdb.dbo.#CCTapeLib') is not null DROP TABLE #CCTapeLib
            END
			ELSE IF @queryId = 206 AND @parameterName = 'DDB Disk Space Utilization'
			BEGIN
				--Using query 61 for this
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(61, @i_CommServUniqueId, 1, null, null, @i_userId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				IF object_id('tempdb.dbo.#TblDDBDiskSpaceStatus') is not null
					DROP TABLE #TblDDBDiskSpaceStatus
				CREATE TABLE #TblDDBDiskSpaceStatus
				(
					CCUID INT,
					Status varchar(1024) default '',
					Result varchar(1024) default '',
					Recommendation varchar(1024) default '',
					totalDDBPath int default 0,
					warningDDBPath int default 0,
					criticalDDBPath int default 0,
					unknownDDBPath int default 0
				)
				insert into #TblDDBDiskSpaceStatus
				select distinct CCUID, '', '', '', 0,0,0,0 from #commcells
				--Disk space free: good:   > 25%   warning: 10 ?25%, critical < 10%
				DECLARE @DDBPathUsage TABLE
				(
					CCUID INT,
					idxAccessPathId INT,
					percentFree DECIMAL(20,2),
					Days BIGINT,
					status INT DEFAULT 0
				)
				DECLARE @DDBCriticalDays  bigINT =30
				DECLARE @DDBWarningDays  bigINT= 90
				-- Get prediction data
				IF @useStoredPrediction = 0 -- Use default linear regression model
				BEGIN
					-- Delete any data in Growth data tables
					delete #GrowthData
					delete #GrowthRate
					-- Fill input data
					INSERT INTO #GrowthData
						select B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks, max(B.SpaceMB),
						ROW_NUMBER() OVER (PARTITION BY B.CommservUniqueId, B.SubstoreId, B.EntityName ORDER BY B.Weeks desc)
						from
						(SELECT S.CommServUniqueId, S.SubstoreId, '' as EntityName, DATEDIFF(WEEK, S.WeekStart, @CurrWeek) as Weeks, ISNULL(S.DDBUsedDiskSpaceMB, -1) as SpaceMB
						FROM cf_SurveyDeDupStoreConfigPeakSize S
									INNER JOIN (
											select A.CommServUniqueId, A.SubstoreId, isnull(max(A.DDBDiskTotalSpaceMB),0) as TotalCapacityMBMax
											from cf_SurveyDeDupStoreConfig as A
											INNER JOIN #latestResults AS result
											ON result.SurveyResultId = A.SurveyResultId
											group by A.CommServUniqueId, A.SubstoreId
									) T ON S.CommservUniqueId = T.CommServUniqueId AND S.SubstoreId = T.SubstoreId
						WHERE   S.WeekStart >= @FirstWeek AND ISNULL(S.DDBUsedDiskSpaceMB, -1) > 0 and T.TotalCapacityMBMax > 0) as B
						group by B.CommServUniqueId, B.SubstoreId, B.EntityName, B.Weeks
					-- Run Growh rate calculation
					EXEC GetLinearGrowthRate 0
					-- Insert tmp prediction data
					DELETE FROM #PredictionData;
					INSERT INTO #PredictionData
						SELECT 	S.CommServUniqueId, S.SubstoreId, '',
								CAST(dbo.CalculateDaysToBeFull (S.DDBDiskFreeSpaceMB, R.GrowthRate/7.0, S.LogDateUTC) AS BIGINT) -- DaysToBeFull
						FROM cf_SurveyDeDupStoreConfig AS S
						INNER JOIN #latestResults AS U
						on U.SurveyResultId = S.SurveyResultId
						left join #GrowthRate R
						on S.CommServUniqueId = R.CommServUniqueId
						and S.SubstoreId = R.EntityId
				END
				ELSE -- Use prediction data from CvStatAnalysis
				BEGIN
					DELETE FROM #PredictionData;
					INSERT INTO #PredictionData
						SELECT DISTINCT
							I.CommServUniqueId, I.SubstoreId, '',
							I.DaysToBeFull
						FROM cf_SurveyDeDupStoreConfig AS S
						INNER JOIN #latestResults AS U
						ON U.SurveyResultId = S.SurveyResultId
						LEFT JOIN (
							SELECT CommServUniqueId, SubstoreId, MAX(LogDateUTC) AS LogDate
							FROM DeDupDiskPrediction
							GROUP BY CommServUniqueId, SubstoreId
						) R
						ON S.CommServUniqueId = R.CommServUniqueId AND S.SubstoreId = R.SubstoreId
						LEFT JOIN DeDupDiskPrediction I
						ON R.CommServUniqueId = I.CommServUniqueId AND R.SubstoreId = I.SubstoreId AND R.LogDate = I.LogDateUTC
				END
				INSERT INTO @DDBPathUsage
				SELECT
					csInfo.CommServUniqueId,
					csInfo.idxAccessPathId,
					CASE
						WHEN csInfo.DDBDiskTotalSpaceMB <= 0 THEN -1
						ELSE CAST((CASE WHEN ISNULL(csInfo.DDBDiskTotalSpaceMB, 0) <= 0 THEN 0 ELSE (1.0*csInfo.DDBDiskFreeSpaceMB)/(0.01*csInfo.DDBDiskTotalSpaceMB) END) AS DECIMAL(20,2))
					END AS percentFree,
					LSF.DaysToBeFull,
					0
				FROM cf_SurveyDeDupStoreConfig AS csInfo WITH (NOLOCK)
						INNER JOIN #latestResults AS result
							ON result.SurveyResultId = csInfo.SurveyResultId
							AND result.QueryID = 61
				LEFT OUTER JOIN #PredictionData LSF
				ON LSF.EntityId = csInfo.SubstoreId and LSF.CommServUniqueId = csInfo.CommservUniqueId
				update A
				set status =
				(
					case
					when percentFree = -1
					then 0 --unknown
					when (percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays )
					then 1 --critical
					when (
								(percentFree >= @criticalThreshold and percentFree <= @warningThreshold)
								or
								( Days != @NA and Days != @Never and Days>=@DDBCriticalDays and Days <= @DDBWarningDays )
							)
							and not exists (
								(select DISTINCT CCUID,idxAccessPathId FROM @DDBPathUsage where ((percentFree >= 0 and percentFree < @criticalThreshold) or ( Days != @NA and Days != @Never and Days<@DDBCriticalDays )) and idxAccessPathId = A.idxAccessPathId and CCUID = A.CCUID)
								union all
								(select DISTINCT CCUID,idxAccessPathId FROM @DDBPathUsage where percentFree = -1 and idxAccessPathId = A.idxAccessPathId and CCUID = A.CCUID)
							)
					then 2 --warning
					else 3 --good
					end
				)
				from @DDBPathUsage as A
				update DD
				set unknownDDBPath = isnull(UnknownTbl.CNT, 0),
				criticalDDBPath = isnull(CriticalTbl.CNT, 0),
				warningDDBPath = isnull(WarningTbl.CNT, 0),
				totalDDBPath = isnull(TotalTbl.CNT, 0)
				FROM #TblDDBDiskSpaceStatus DD
					left join (
						select CCUID, status, count(DISTINCT idxAccessPathId) as CNT
						from @DDBPathUsage
						where status = 0
						group by CCUID, status
					) UnknownTbl
					on UnknownTbl.CCUID = DD.CCUID
					left join (
						select CCUID, status, count(DISTINCT idxAccessPathId) as CNT
						from @DDBPathUsage
						where status = 1
						group by CCUID, status
					) CriticalTbl
					on CriticalTbl.CCUID = DD.CCUID
					left join (
						select CCUID, status, count(DISTINCT idxAccessPathId) as CNT
						from @DDBPathUsage
						where status = 2
						group by CCUID, status
					) WarningTbl
					on WarningTbl.CCUID = DD.CCUID
					left join (
						select CCUID, count(DISTINCT idxAccessPathId) as CNT
						from @DDBPathUsage
						group by CCUID
					) TotalTbl
					on TotalTbl.CCUID = DD.CCUID
				UPDATE DD
					set Status =
						CASE
							WHEN totalDDBPath = 0 THEN @strInfo
							WHEN criticalDDBPath > 0 THEN @strCritical
							WHEN warningDDBPath > 0 THEN @strwarning
							ELSE @strGood
						END,
					Result =
					case
					when (totalDDBPath > 0)
					then 'DDB path distribution by available space: <DELIM>Total : <B>'+ CAST(totalDDBPath AS NVARCHAR(5))
					+ '</B>&nbsp&nbspGood : <B>' + CAST((totalDDBPath-warningDDBPath-criticalDDBPath-unknownDDBPath) AS NVARCHAR(5))
					+ '</B>&nbsp&nbsp Warning : <B>' + CAST(warningDDBPath AS NVARCHAR(5))
					+ '</B>&nbsp&nbsp Critical : <B>' + CAST(criticalDDBPath AS NVARCHAR(5))
					+ CASE WHEN unknownDDBPath > 0 THEN '</B>&nbsp&nbsp <DELIM>Excluded : <B>' + CAST(unknownDDBPath AS NVARCHAR(5)) + '</B>&nbsp&nbsp' ELSE '' END
					ELSE 'There is no DDB path configured.<DELIM>'
					end,
					Recommendation =
					CASE
						WHEN totalDDBPath = 0 THEN @infoMessage
						WHEN totalDDBPath > 0 AND criticalDDBPath = 0 AND warningDDBPath = 0 THEN @goodMessage
						ELSE @warningMessage
					END
				FROM #TblDDBDiskSpaceStatus DD
				UPDATE CC
				SET Status = DD.Status,
					Result = DD.Result,
					Recommendation = DD.Recommendation,
					logDate = JJ.LogDate
				FROM #TblSurveyResult CC
					INNER JOIN #TblDDBDiskSpaceStatus DD
						ON CC.CommServUniqueId = DD.CCUID
					INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				drop table #TblDDBDiskSpaceStatus
			END
            --Subclients not having full backup in 60 days
            ELSE IF @queryId = 207
            BEGIN
                DECLARE @nSubclients       INT = 0
                DECLARE @nSubclients40Incr INT = 0
                DECLARE @nSubclientsNoIncr INT = 0
                DECLARE @NumOfIncrJobs     INT = 0
                DECLARE @IncrJobsAppSizeGB BIGINT = 0
				IF object_id('tempdb.dbo.#CCSubClientDetails') is not null DROP TABLE #CCSubClientDetails
				CREATE TABLE #CCSubClientDetails (ccuid int,
				nSubclients       INT default 0,
                nSubclients40Incr INT default 0,
                nSubclientsNoIncr INT default 0,
                NumOfIncrJobs     INT default 0,
                IncrJobsAppSizeGB BIGINT default 0)
				INSERT INTO #CCSubClientDetails
                SELECT  R.CCUID,
						ISNULL(COUNT(S.AppId), 0),
                        ISNULL(SUM(CASE WHEN NumOfIncrJobs >= 40 THEN 1 ELSE 0 END), 0),
                        ISNULL(SUM(CASE WHEN NumOfIncrJobs <= 0  THEN 1 ELSE 0 END), 0),
                        ISNULL(SUM(NumOfIncrJobs), 0),
                        ISNULL(SUM(IncrJobsAppSize)/1024/1024/1024, 0)
                FROM    cf_SurveySubclientsNoRecentFull S
                INNER JOIN #latestResults AS R
					ON S.SurveyResultId = R.SurveyResultId
					AND R.queryId = @queryId
                INNER JOIN cf_SurveySubclientAssociation T ON T.CommservUniqueId = R.CCUID AND T.AppId = S.AppId AND T.Deleted = 0 AND T.BackupDisabled =0
				INNER JOIN #commcells CC on CC.CCUID = T.CommservUniqueId
                INNER JOIN cf_SurveyCopyBasicRetention C ON T.CommservUniqueId  = C.CommservUniqueId AND S.ArchGrpId = C.PolicyId
                        AND C.IsDefaultCopy = 1 AND C.IsSnapCopy = 0 AND C.Deleted = 0
                                INNER JOIN cf_SurveyAgentType AT ON T.AppTypeId = AT.id
						GROUP BY R.CCUID
				UPDATE CC
					SET Status = @strInfo,
					Result = CASE WHEN nSubclients > 0 THEN
						'<B>'+ CAST(nSubclients AS NVARCHAR(10)) + '</B> subclient(s) have no full backup jobs in 60 days.<DELIM>'
						 + 'Total application size of jobs since the last full backup jobs is <B>' + dbo.FormatBytes(IncrJobsAppSizeGB, 'GB') + '</B>.<DELIM>'
						 + '<B>'+ CAST(nSubclients40Incr AS NVARCHAR(10)) + '</B> subclient(s) have 40 or more backup jobs since the last full backup jobs.<DELIM>'
						 + '<B>'+ CAST(nSubclientsNoIncr AS NVARCHAR(10)) + '</B> subclient(s) have no jobs since the last full backup jobs.<DELIM>'
						ELSE 'There is no subclient not having full backup jobs in 60 days.<DELIM>' END,
					Recommendation =
						CASE WHEN nSubclients > 0 THEN '<VDL>'
						END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCSubClientDetails P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
                SET @tmpStatus = @strInfo
                SET @tmpResult = 'There is no subclient not having full backup jobs in 60 days.<DELIM>'
                SET @tmpRecommendation = ''
 				UPDATE CC
					SET Status = @tmpStatus,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					LogDate = jj.LogDate
					FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCSubClientDetails') is not null DROP TABLE #CCSubClientDetails
            END
            --Fallen Behind Backup Copies
            ELSE IF @queryId = 209
            BEGIN
                declare @criticalBkpCopyNum int = 0
                declare @warningBkpCopyNum int = 0
                declare @totalBkpCopyNum int = 0
				IF object_id('tempdb.dbo.#CCFallenBCopies') is not null DROP TABLE #CCFallenBCopies
				CREATE TABLE #CCFallenBCopies(ccuid int, criticalBkpCopyNum int,warningBkpCopyNum int, totalBkpCopyNum int)
                DECLARE @utcTimeNow BIGINT = (SELECT dbo.getUnixTimeBig(GETUTCDATE()))
				insert into #CCFallenBCopies(ccuid,totalBkpCopyNum, warningBkpCopyNum,criticalBkpCopyNum)
                SELECT
					CC.CCUID,
                    COUNT(*) AS totalBkpCopyNum,
                    SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= @warningThreshold AND ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) <= @criticalThreshold THEN 1 ELSE 0 END) AS warningBkpCopyNum,
                    SUM (CASE WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) > @criticalThreshold THEN 1 ELSE 0 END) AS criticalBkpCopyNum
                FROM cf_SurveyFallenBehindBackupCopies AS csInfo WITH (NOLOCK)
					INNER JOIN #commcells CC
						ON CC.CCUID = csInfo.CommservUniqueId
                GROUP BY CC.CCUID
				UPDATE CC
					SET Status = CASE WHEN criticalBkpCopyNum > 0 THEN @strCritical
								 WHEN warningBkpCopyNum > 0 THEN @strwarning
								 WHEN totalBkpCopyNum > 0 THEN @strInfo
								ELSE @strGood END,
					Result = CASE WHEN totalBkpCopyNum > 0 THEN
							'Backup Copies: <DELIM>'
							+ 'Total: <B>'+ CAST(totalBkpCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Info: <B>' + CAST((totalBkpCopyNum-warningBkpCopyNum-criticalBkpCopyNum) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(warningBkpCopyNum AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(criticalBkpCopyNum AS NVARCHAR(5)) + '</B>'
						ELSE 'There are no Fallen Behind Backup Copy Jobs.<DELIM>' END,
					Recommendation =
						CASE WHEN totalBkpCopyNum = 0 THEN @goodMessage
							WHEN criticalBkpCopyNum = 0 AND warningBkpCopyNum = 0 THEN  @infoMessage
							WHEN criticalBkpCopyNum = 0 THEN @warningMessage
							ELSE @criticalMessage END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCFallenBCopies P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
 				UPDATE CC
					SET Status = @strGood,
					Result = 'There are no Fallen Behind Backup Copy Jobs.<DELIM>',
					Recommendation = 'Up-To-Date.<DELIM>',
					LogDate = jj.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
					ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCFallenBCopies') is not null DROP TABLE #CCFallenBCopies
            END
           --Recoverability SLA
           ELSE IF @queryId = 211
           BEGIN
				--Also using query 27 for this
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				UNION
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(242, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				DECLARE @nClientsTotal     INT = 0
				DECLARE @nClientsMet       INT = 0
				DECLARE @nClientsNotMet    INT = 0
				DECLARE @RecoverabilityPct INT = 0
				IF object_id('tempdb.dbo.#CCClientRecoverSLA') is not null DROP TABLE #CCClientRecoverSLA
				CREATE TABLE #CCClientRecoverSLA(ccuid int, nClientsTotal int, nClientsMet int default 0, nClientsNotMet int default 0, RecoverabilityPct INT DEFAULT 0)
				IF object_id('tempdb.dbo.#CCClientNm') is not null DROP TABLE #CCClientNm
				CREATE TABLE #CCClientNm(ccuid int, nClientsMet int)
				INSERT INTO #CCClientRecoverSLA(ccuid,nClientsTotal)
				SELECT R.CCUID, COUNT(DISTINCT S.ClientId)
				FROM cf_SurveyRecoverabilitySLA S
					INNER JOIN #latestResults AS R
						ON S.SurveyResultId = R.SurveyResultId
						AND R.QueryId = @queryId
					LEFT OUTER JOIN (
						SELECT DISTINCT R.CCUID, ClientId
						FROM cf_SurveySLADetails AS S WITH (NOLOCK)
							INNER JOIN #latestResults AS R
								ON R.SurveyResultId = S.SurveyResultId
								AND R.QueryId IN (27, 242)
								AND (S.Days = 30 OR S.Days < 0)
					) C ON R.CCUID = C.CCUID AND S.ClientId = C.ClientId
				WHERE   LastJobId > 0 OR C.ClientId IS NOT NULL
				GROUP BY R.CCUID
				INSERT INTO #CCClientNm
				SELECT R.ccuid, COUNT(DISTINCT S.ClientId)
				FROM cf_SurveyRecoverabilitySLA S
					INNER JOIN #latestResults AS R
						ON S.SurveyResultId = R.SurveyResultId
						AND R.QueryId = @queryId
					INNER JOIN #CCClientRecoverSLA CC
						ON CC.ccuid = R.CCUID
					LEFT OUTER JOIN (
						SELECT  DISTINCT R.CCUID, ClientId
						FROM cf_SurveySLADetails AS S WITH (NOLOCK)
							INNER JOIN #latestResults AS R
								ON R.SurveyResultId = S.SurveyResultId
								AND R.QueryId IN (27, 242)
								AND (S.Days = 30 OR S.Days < 0)
					) C ON R.CCUID = C.CCUID AND S.ClientId = C.ClientId
				WHERE   LastJobId > 0 AND RTAMinutes >= 0 AND RTAMinutes <= RTOMinutes AND C.ClientId IS NULL
				GROUP BY R.CCUID
			   UPDATE CC SET nClientsMet = JJ.nClientsMet
			   FROM #CCClientRecoverSLA CC
					INNER JOIN #CCClientNm JJ
						ON CC.ccuid = JJ.ccuid
			   UPDATE CC SET nClientsNotMet = nClientsTotal - nClientsMet,
			   RecoverabilityPct = CAST((CASE WHEN nClientsTotal > 0 THEN nClientsMet*100.0/nClientsTotal ELSE 0 END) AS INT)
			   FROM #CCClientRecoverSLA CC
				UPDATE CC
					SET Status =  @strInfo,
					Result = CASE WHEN nClientsTotal > 0 THEN
							'SLA is <b>'+ CAST (RecoverabilityPct AS NVARCHAR(6)) + ' %.</b><DELIM>'
							+ 'Met SLA : <b>' + CAST (nClientsMet AS NVARCHAR(10)) + '</b>, Missed SLA : <b>' + CAST (nClientsNotMet AS NVARCHAR(10)) + '</b>'
						ELSE 'No data available.<DELIM>' END,
					Recommendation =
						CASE WHEN nClientsTotal > 0 THEN '<VDL>' END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCClientRecoverSLA P
						ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @strInfo,
					Result = 'No data available.<DELIM>',
					Recommendation = '',
					LogDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCClientRecoverSLA') is not null DROP TABLE #CCClientRecoverSLA
				IF object_id('tempdb.dbo.#CCClientNm') is not null DROP TABLE #CCClientNm
           END
			--Copy Redundancy SLA
			ELSE IF @queryId = 212
			BEGIN
				--Using query 211 and 27 for this
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(211, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				INSERT INTO #latestResults(CCUID, QueryId, SurveyResultId, LogDateUTC)
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(27, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				UNION
				SELECT Res.CommServUniqueId, Res.SurveyID, Res.SurverResultId, Res.LogDateUTC FROM cf_SurveyResultFuncV1(242, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId) Res
					INNER JOIN #commcells CC
						ON CC.CCUID = Res.CommServUniqueId
				SET @nClientsTotal  = 0
				SET @nClientsMet    = 0
				SET @nClientsNotMet = 0
				DECLARE @RedundancyPct INT = 0
				IF object_id('tempdb.dbo.#CCClientRedundanySLA') is not null DROP TABLE #CCClientRedundanySLA
				CREATE TABLE #CCClientRedundanySLA(ccuid int, nClientsTotal int, nClientsMet int default 0, nClientsNotMet int default 0, RedundancyPct INT DEFAULT 0)
				IF object_id('tempdb.dbo.#CCClientRedNm') is not null DROP TABLE #CCClientRedNm
				CREATE TABLE #CCClientRedNm(ccuid int, nClientsMet int)
				INSERT INTO #CCClientRedundanySLA(ccuid,nClientsTotal)
				SELECT  R.CCUID, COUNT(DISTINCT S.ClientId)
				FROM    cf_SurveyRecoverabilitySLA S
						INNER JOIN #latestResults AS R
							ON S.SurveyResultId = R.SurveyResultId
							AND R.QueryId = 211
						LEFT OUTER JOIN (
							SELECT  DISTINCT R.CCUID, ClientId
							FROM    cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN #latestResults AS R
										ON R.SurveyResultId = S.SurveyResultId
										AND R.QueryId IN (27, 242)
										AND (S.Days = 30 OR S.Days < 0)
						) C ON R.CCUID = C.CCUID AND S.ClientId = C.ClientId
				WHERE   LastJobId > 0 OR C.ClientId IS NOT NULL
				GROUP BY R.CCUID
				INSERT INTO #CCClientRedNm
				SELECT
						R.ccuid, COUNT(DISTINCT S.ClientId)
				FROM    cf_SurveyRecoverabilitySLA S
						INNER JOIN #latestResults AS R
							ON S.SurveyResultId = R.SurveyResultId
							AND R.QueryId = 211
						LEFT OUTER JOIN (
							SELECT  DISTINCT R.CCUID, ClientId
							FROM    cf_SurveySLADetails AS S WITH (NOLOCK)
									INNER JOIN #latestResults AS R
										ON R.SurveyResultId = S.SurveyResultId
										AND R.QueryId IN (27, 242)
										AND (S.Days = 30 OR S.Days < 0)
						) C ON R.CCUID = C.CCUID AND S.ClientId = C.ClientId
				WHERE   LastJobId > 0 AND C.ClientId IS NULL AND MinRedundancy >= CopyRedundancy AND MaxBehindDays <= CopyBehindDays
				GROUP BY R.CCUID
				UPDATE CC SET nClientsMet = JJ.nClientsMet
				FROM #CCClientRedundanySLA CC
					INNER JOIN #CCClientRedNm JJ
						ON CC.ccuid = JJ.ccuid
				UPDATE CC SET nClientsNotMet = nClientsTotal - nClientsMet,
					RedundancyPct = CAST((CASE WHEN nClientsTotal > 0 THEN nClientsMet*100.0/nClientsTotal ELSE 0 END) AS INT)
					FROM #CCClientRedundanySLA CC
				UPDATE CC
					SET Status =  @strInfo,
					Result = CASE WHEN nClientsTotal > 0 THEN
							'SLA is <b>'+ CAST (RedundancyPct AS NVARCHAR(6)) + ' %.</b><DELIM>'
							+ 'Met SLA : <b>' + CAST (nClientsMet AS NVARCHAR(10)) + '</b>, Missed SLA : <b>' + CAST (nClientsNotMet AS NVARCHAR(10)) + '</b>'
						ELSE 'No data available.<DELIM>' END,
					Recommendation =
						CASE WHEN nClientsTotal > 0 THEN '<VDL>' END,
					LogDate = COM.LogDate
				FROM #TblSurveyResult CC
				inner JOIN #commcells COM
					ON COM.CCUID = CC.CommServUniqueId
				INNER JOIN #CCClientRedundanySLA P
					ON CC.CommServUniqueId = P.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				UPDATE CC
					SET Status = @strInfo,
					Result = 'No data available.<DELIM>',
					Recommendation = '',
					LogDate = JJ.LogDate
				FROM #TblSurveyResult CC
				INNER JOIN #commcells JJ
						ON CC.CommServUniqueId = JJ.CCUID
				WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName) AND CC.Status = @strUnknown
				IF object_id('tempdb.dbo.#CCClientRedundanySLA') is not null DROP TABLE #CCClientRedundanySLA
				IF object_id('tempdb.dbo.#CCClientRedNm') is not null DROP TABLE #CCClientRedNm
			END
            ELSE IF @queryId = 214
            BEGIN
				SET @tmpStatus = @strInfo
				SET @tmpResult = ''
				set @tmpRecommendation = ''
				IF @i_CommServUniqueID > 0
					BEGIN
					IF object_id('tempdb.dbo.#CCCleanupInfo') is not null DROP TABLE #CCCleanupInfo
					CREATE TABLE #CCCleanupInfo(ccuid int,
					CGCount INT default 0 ,
					CCount INT default 0,
					SCCount INT default 0,
					MACount INT default 0,
					ArrayCount INT default 0,
					AlertCount INT default 0,
					UserGroupCount  INT default 0,
					UserCount  INT default 0,
					policyCount INT default 0,
					SPCount INT default 0,
					LibCount INT default 0)
					INSERT INTO #CCCleanupInfo(ccuid)
					SELECT CC.CCUID
					FROM #commcells CC
					UPDATE #CCCleanupInfo
					SET CGCount = H.CGCount
					FROM(SELECT count(CG.ClientGroupId)	AS CGCount
					FROM #commcells CC LEFT OUTER JOIN cf_SurveyClientGroup CG WITH(NOLOCK) ON
					CC.CCUID = CG.CommservUniqueId
					LEFT OUTER JOIN cf_SurveyClientGroupAssociation CGA WITH(NOLOCK) ON CC.CCUID = CGA.CommservUniqueId AND CGA.clientGroupId = CG.clientGroupId
					WHERE   CGA.clientId IS NULL AND CG.DeletedDate IS NULL) AS H
					UPDATE #CCCleanupInfo
					SET CCount =  H.CCount
					FROM (SELECT COUNT(DISTINCT SCC.ClientId) AS CCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_217 from  dbo.cf_SurveyResultFuncV1(217,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_surveycleanupClient SCC ON SCC.SurveyResultId = SR.SurveyResultId_217) AS H
					UPDATE #CCCleanupInfo
					SET SCCount =  H.SCCount
					FROM (SELECT COUNT(DISTINCT SR.AppId) AS SCCount
					FROM #CCCleanupInfo CCI INNER JOIN cf_surveySubclientAssociation SR ON
					CCI.ccuid = SR.CommServUniqueId
					where BackupDisabled = 1 AND (SR.deleted = 0 OR SR.SubclientStatus & 4 = 0)) AS H
					UPDATE #CCCleanupInfo
					SET MACount =  H.MACount
					FROM (SELECT COUNT(DISTINCT SCC.MAID) AS MACount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyMANotUsed SCC ON SCC.SurveyResultId = SR.SurveyResultId_215) AS H
					DECLARE @tempArray TABLE (CCUID INT, ArrayId INT)
					INSERT INTO @tempArray
					select SR.ccuid, csInfo.ArrayId from cf_SurveyArrayWithoutClient csInfo
					INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON SR.SurveyResultId_215 = csInfo.SurveyResultId
					INSERT INTO @tempArray
					select SR.ccuid, csInfo.ArrayId from cf_SurveyArrayWithOrphanSnap csInfo
					INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON SR.SurveyResultId_215 = csInfo.SurveyResultId
					INSERT INTO @tempArray
					select SR.ccuid, csInfo.ArrayId from cf_SurveyDeleteFailSnapArray csInfo
					INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON SR.SurveyResultId_215 = csInfo.SurveyResultId
					UPDATE #CCCleanupInfo
					SET ArrayCount =  H.ArrayCount
					FROM (SELECT COUNT(DISTINCT SR.ArrayId) AS ArrayCount
					FROM #CCCleanupInfo CCI INNER JOIN @tempArray SR ON
					CCI.ccuid = SR.ccuid) AS H
					UPDATE #CCCleanupInfo
					SET AlertCount =  H.AlertCount
					FROM (SELECT COUNT(DISTINCT SCC.AlertId) AS AlertCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_214 from  dbo.cf_SurveyResultFuncV1(214,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyAlertsWithoutUsers SCC ON SCC.SurveyResultId = SR.SurveyResultId_214) AS H
					UPDATE #CCCleanupInfo
					SET UserCount =  H.UserCount
					FROM (SELECT COUNT(DISTINCT SCC.UserId) AS UserCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_214 from  dbo.cf_SurveyResultFuncV1(214,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyUserNotLoggedIn SCC ON SCC.SurveyResultId = SR.SurveyResultId_214) AS H
					UPDATE #CCCleanupInfo
					SET UserGroupCount =  H.UserGroupCount
					FROM (SELECT COUNT(DISTINCT SCC.UserGroupId) AS UserGroupCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_214 from  dbo.cf_SurveyResultFuncV1(214,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyCleanupUserGroup SCC ON SCC.SurveyResultId = SR.SurveyResultId_214) AS H
					UPDATE #CCCleanupInfo
					SET policyCount =  H.policyCount
					FROM (SELECT COUNT(DISTINCT SCC.PolicyId) AS policyCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_22 from  dbo.cf_SurveyResultFuncV1(22,0,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveySchedulePolicyUsage SCC ON SCC.SurveyResultId = SR.SurveyResultId_22
					where Disable = 1) AS H
					UPDATE #CCCleanupInfo
					SET LibCount =  H.LibCount
					FROM (SELECT COUNT(SCC.LibraryId) AS LibCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyCleanupLibrary SCC ON SCC.SurveyResultId = SR.SurveyResultId_215) AS H
					UPDATE #CCCleanupInfo
					SET SPCount =  H.SPCount
					FROM (SELECT COUNT(DISTINCT SCC.SPID) AS SPCount
					FROM #CCCleanupInfo CCI INNER JOIN (select CommServUniqueId AS CCUID, SurverResultId AS SurveyResultId_215 from  dbo.cf_SurveyResultFuncV1(215,@i_CommServUniqueID,1,NULL,NULL,@i_UserId,-1)) AS SR ON
					CCI.ccuid = SR.ccuid
					INNER JOIN cf_SurveyCleanupPolicy SCC ON SCC.SurveyResultId = SR.SurveyResultId_215) AS H
					UPDATE CC
						SET Status =  @strInfo,
						Result += CASE WHEN CCount > 0 THEN '<div>Clients : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Clients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(CCount AS VARCHAR(128))+'</a>, '
									   ELSE 'Client : None, '
								  END,
						LogDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN CGCount > 0 THEN 'Client Groups : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Clients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(CGCount AS VARCHAR(128))+'</a>, '
									   ELSE 'Client Group : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN MACount > 0 THEN 'MediaAgents : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Media&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(MACount AS VARCHAR(128))+'</a>, '
										ELSE 'MediaAgent : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN ArrayCount > 0 THEN ' Arrays : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Media&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(ArrayCount AS VARCHAR(128))+'</a>, '
									ELSE 'Array : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN AlertCount > 0 THEN 'Alerts : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Alerts&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(AlertCount AS VARCHAR(128))+' </a>, '
									ELSE 'Alert : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN SCCount > 0 THEN 'Subclients : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=SubClients&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(SCCount AS VARCHAR(128))+'</a>, '
									ELSE 'Subclient : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN policyCount > 0 THEN 'Policies : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Policies&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(policyCount AS VARCHAR(128))+' </a>, '
									ELSE 'Policies : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN UserGroupCount > 0 THEN 'UserGroups :  <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Security&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self">'+CAST(UserGroupCount AS VARCHAR(128))+'</a>, '
									ELSE 'UserGroup : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN UserCount > 0 THEN 'Users : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Security&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(UserCount AS VARCHAR(128))+'</a>, '
									ELSE 'User : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN LibCount > 0 THEN 'Libraries : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Storage&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(LibCount AS VARCHAR(128))+' </a>, '
								ELSE 'Libraries : None, '
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result += CASE WHEN SPCount > 0 THEN 'Storage Policies : <a href="/webconsole/reportsplus/reportViewer.jsp?reportId=MetricsCleanupReport&pageName=Storage&input.CommCell=%5B'+CAST(@i_CommServUniqueId AS VARCHAR(128))+'%5D" target="_self"> '+CAST(SPCount AS VARCHAR(128))+' </a></div>'
							ELSE 'Storage Policies : None  </div><b>'
								  END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					UPDATE CC SET
						Result = CASE WHEN CGCount + CCount + SCCount+MACount+ArrayCount+AlertCount +UserGroupCount+UserCount  +policyCount +SPCount +LibCount <= 0
									THEN 'No items to clean up.'
								  ELSE Result END,
						Recommendation += CASE WHEN CGCount + CCount + SCCount+MACount+ArrayCount+AlertCount +UserGroupCount+UserCount  +policyCount +SPCount +LibCount <= 0
											THEN 'Everything is looking good. No need to Cleanup.'
										 ELSE ' View the items in the list above to clean up your CommCell environment.<VDL><VDL_CR>MetricsCleanupReport&pageName=Details&input.CommCell='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
										END
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
					INNER JOIN #CCCleanupInfo P
						ON CC.CommServUniqueId = P.CCUID
					WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					END
				ELSE
					BEGIN
					UPDATE CC
					SET Status =  @strInfo,
					Result = @tmpResult,
					Recommendation = @tmpRecommendation,
					LogDate = COM.LogDate
					FROM #TblSurveyResult CC
					inner JOIN #commcells COM
						ON COM.CCUID = CC.CommServUniqueId
						WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
					END
			END
		   -- Data Aging Troubleshooting Information
           ELSE IF @queryId = 260
           BEGIN
				IF OBJECT_ID('tempdb.dbo.#DATroubleshootingSummary') IS NOT NULL DROP TABLE #DATroubleshootingSummary
				CREATE TABLE #DATroubleshootingSummary (CCUID INT, InfoCounts INT, WarningCounts INT, CriticalCounts int)
				INSERT	INTO #DATroubleshootingSummary
				SELECT	P.CCUID, ISNULL(P.[1], 0), ISNULL(P.[2], 0), ISNULL(P.[3], 0)
				FROM	(SELECT R.CCUID, Info.Severity, COUNT(*) AS Counts
						FROM	#LatestResults R
							INNER JOIN cf_SurveyDATroubleshootingInfo Info ON R.SurveyResultId = Info.SurveyResultId
						GROUP BY R.CCUID, Info.Severity) S
						PIVOT (
							MAX(Counts) FOR Severity IN ([1], [2], [3])
						) P
				UPDATE CC
					SET Status = CASE WHEN ISNULL(CriticalCounts,0) > 0 THEN @strCritical
							WHEN ISNULL(WarningCounts,0) > 0 THEN @strwarning
							WHEN ISNULL(InfoCounts,0) > 0 THEN @strInfo
							ELSE @strGood END,
						Result = CASE WHEN ISNULL(WarningCounts + CriticalCounts, 0) > 0 THEN
							'Total: <B>'+ CAST((WarningCounts + CriticalCounts) AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Warning: <B>' + CAST(WarningCounts AS NVARCHAR(5)) + '</B>&nbsp&nbsp'
							+ 'Critical: <B>' + CAST(CriticalCounts AS NVARCHAR(5)) + '</B>'
						ELSE 'There is no Data Aging problem.<DELIM>' END,
						Recommendation =
						CASE WHEN ISNULL(CriticalCounts,0) > 0 THEN @criticalMessage
							WHEN ISNULL(WarningCounts,0) > 0 THEN @warningMessage
							ELSE @goodMessage END,
						LogDate = JJ.LogDate
				FROM	#TblSurveyResult CC
						INNER JOIN #commcells JJ ON CC.CommServUniqueId = JJ.CCUID
						LEFT OUTER JOIN #DATroubleshootingSummary S ON CC.CommServUniqueId = S.CCUID
				WHERE	CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				IF OBJECT_ID('tempdb.dbo.#DATroubleshootingSummary') IS NOT NULL DROP TABLE #DATroubleshootingSummary
      		END
			ELSE IF @queryId = 261
            BEGIN
				SET @tmpStatus = @strInfo
				DECLARE @ErrorFlags TABLE (errorFlag INT)
				INSERT INTO @ErrorFlags
				SELECT 1 -- Quiesce Error
				UNION
				SELECT 2 -- independent disk error
				UNION
				SELECT 4 -- meta data collection failure
				UNION
				SELECT 0 -- others
				IF OBJECT_ID('tempdb..#VMCount') IS NOT NULL DROP TABLE #VMCount
				CREATE TABLE #VMCount (CCID INT,VMCount INT,ErrorFlag INT)
				INSERT INTO #VMCount
				SELECT CCUID,count(vmclientId), E.errorFlag from cf_surveyVMErrorFlag cf with (NOLOCK)
					INNER JOIN #latestResults L ON L.surveyResultId = cf.surveyResultId and L.queryId = @queryId
					INNER JOIN @ErrorFlags  E ON (E.errorFlag & cf.errorFlag > 0) and cf.errorFlag  > 0
					GROUP BY E.errorFlag,CCUID
					UNION
					SELECT CCUID,count(vmclientId), 5 from cf_surveyVMErrorFlag cf with (NOLOCK)
					INNER JOIN #latestResults L ON L.surveyResultId = cf.surveyResultId and L.queryId = @queryId
					where cf.errorFlag  = 0
					GROUP BY cf.errorFlag,CCUID
					DECLARE @totalVM INT
					SELECT @totalVM = COUNT(vmclientId)from cf_surveyVMErrorFlag cf with (NOLOCK)
					INNER JOIN #latestResults L ON L.surveyResultId = cf.surveyResultId and L.queryId = @queryId
					IF (@totalVM > 0)
					BEGIN
						SET @tmpResult = 'Total VMs need attention: '+ CAST(@totalVM AS VARCHAR(8))+', '
						SELECT @tmpResult +=
						COALESCE(
						CASE ErrorFlag
							WHEN  1	THEN
								'Guest quiesce failures: '+ CAST(VMCount AS VARCHAR(8))+' <URL>http://kb.commvault.com/article/63085</URL>, '
							WHEN 2	THEN
								'Unsupported disk: '+ CAST(VMCount AS VARCHAR(8))+' <URL>http://kb.commvault.com/article/63531</URL>, '
								WHEN  5	THEN
								'Backed up with errors: '+ CAST(VMCount AS VARCHAR(8))+' ,'
							WHEN  4	THEN
								'File details collection error: '+ CAST(VMCount AS VARCHAR(8))+' <URL>http://kb.commvault.com/article/63536</URL>, '
							END,'')
						FROM #VMCount
						ORDER BY Errorflag asc
						SET @tmpRecommendation = 'Click the chart label to get more details.
						<VDL><VDL_CR>VMsNeedAttention&input.commUniId='+CAST(@i_CommServUniqueId AS VARCHAR(128))+'</VDL_CR>'
					 END
					ELSE
						BEGIN
							SET @tmpResult = 'No VM Errors'
							SET @tmpRecommendation = ''
						END
					UPDATE CC SET
							Result += @tmpResult,
							Status = CASE WHEN ISNULL(V.VMCount,0) > 0 THEN @strwarning ELSE @strgood END,
						    Recommendation = @tmpRecommendation
								FROM #TblSurveyResult CC
								inner JOIN #commcells COM
									ON COM.CCUID = CC.CommServUniqueId
								left outer join #VMCount V ON V.ccid = COM.CCUID
								WHERE CC.MonitorId = @queryId AND (@parameterName = '' OR CC.Monitor = @parameterName)
				END
			DELETE FROM #latestResults
			FETCH NEXT FROM HealthQueryCur
			INTO @queryId, @parameterName, @warningThreshold, @criticalThreshold, @infoMessage, @goodMessage, @warningMessage, @criticalMessage
        END
		UPDATE #TblSurveyResult
		SET		ParamId = H.ParamId
		FROM	#TblSurveyResult T, cf_SurveyHealthParam H
		WHERE	T.Monitor = H.ParameterName
		CLOSE HealthQueryCur
		DEALLOCATE HealthQueryCur
		IF(@i_aggregate = 0)
		BEGIN
				SELECT *
				FROM #TblSurveyResult
				order by CommServUniqueId
		END
		IF(@i_aggregate = 1)
		BEGIN
				Select
				Status, COUNT(*) AS [Count]
				FROM #TblSurveyResult GROUP BY Status
		END
		IF(@i_aggregate = 2)
		BEGIN
				Select ST.CCUID AS 'CommServUniqueId',
				Sum(ST.InfoNum) AS 'Info',
				Sum(ST.GoodNum) AS 'Good',
				Sum(ST.WarningNum) AS 'Warning',
				Sum(ST.CriticalNum) AS 'Critical'
				FROM(SELECT
				CCUID = CommServUniqueId,
				InfoNum = case when SR.Status = '2_Info' THEN COUNT(*) ELSE 0 END,
				GoodNum = case when SR.Status = '1_Good' THEN COUNT(*) ELSE 0 END,
				WarningNum = case when SR.Status = '3_Warning' THEN COUNT(*) ELSE 0 END,
				CriticalNum = case when SR.Status = '4_Critical' THEN COUNT(*) ELSE 0 END
				FROM #TblSurveyResult SR GROUP BY Status,CommServUniqueId) ST
				GROUP BY ST.CCUID
		END
		IF(@i_aggregate = 3)
		BEGIN
			IF object_id('tempdb.dbo.#healthCardTemp') is not null DROP TABLE #healthCardTemp
			CREATE table #healthCardTemp (CommServUniqueId int,  ColumnName varchar(50), Value varchar(10));
			INSERT INTO #healthCardTemp
			SELECT ST.CCUID AS 'CommServUniqueId',
			GroupName AS 'GroupName',
			CASE WHEN Sum(ST.CriticalNum) <> 0 THEN 'Crtical'
					WHEN SUM(ST.WarningNum) <>0 THEN 'Warning'
					WHEN Sum(ST.GoodNum) <> 0 THEN 'Good'
					WHEN Sum(ST.InfoNum) <> 0 THEN 'Info'
			END	AS 'Status'
			FROM(SELECT
			CCUID = CommServUniqueId,
			GroupId = GroupId,
			GroupName = CSG.Name,
			InfoNum = case when SR.Status = '2_Info' THEN COUNT(*) ELSE 0 END,
			GoodNum = case when SR.Status = '1_Good' THEN COUNT(*) ELSE 0 END,
			WarningNum = case when SR.Status = '3_Warning' THEN COUNT(*) ELSE 0 END,
			CriticalNum = case when SR.Status = '4_Critical' THEN COUNT(*) ELSE 0 END
			FROM #TblSurveyResult SR INNER JOIN cf_CommservSurveyGroups CSG ON SR.GroupId = CSG.SurveyGroupId GROUP BY SR.Status, SR.CommServUniqueId,SR.GroupId, CSG.Name) ST
			GROUP BY ST.CCUID,ST.GroupId, st.GroupName
			DECLARE   @SQLQuery AS NVARCHAR(MAX)
			DECLARE   @PivotColumns AS NVARCHAR(MAX)
			SELECT   @PivotColumns= COALESCE(@PivotColumns + ',','') + QUOTENAME(ColumnName)
			FROM (SELECT DISTINCT ColumnName FROM #healthCardTemp) AS PivotTable
			SET   @SQLQuery =
			N'SELECT CommServUniqueId, ' +   @PivotColumns + '
			FROM #healthCardTemp
			PIVOT( max(Value)
				  FOR ColumnName IN (' + @PivotColumns + ')) AS P'
			--Execute dynamic query
			EXEC sp_executesql @SQLQuery
			IF object_id('tempdb.dbo.#healthCardTemp') is not null DROP TABLE #healthCardTemp
		END
		IF(@i_aggregate = 4)
		BEGIN
				SELECT Max(status) AS Status
				FROM #TblSurveyResult
		END
		IF(@i_aggregate = 5)
		BEGIN
				SELECT CommServUniqueId AS 'CommServe UniqueId',
				ParamId,
				GroupId,
				GroupName,
				CASE WHEN GroupName like 'Job' THEN (CASE WHEN Monitor like 'Backup Job%'  THEN GroupName+'1' WHEN Monitor like 'Restore Statistics%' THEN GroupName+'1' WHEN Monitor like 'TOP 10%' THEN GroupName+'2' ELSE GroupName END) ELSE GroupName END Name,
				Monitor AS 'Parameter',
				R.Status,
				Result AS 'Outcome',
				ExpectedResult AS 'Expected',
				Recommendation AS 'Remarks'
				FROM #TblSurveyResult R WHERE GroupName <> 'Snap'
				ORDER BY GroupSortOrder,
				MonitorSortOrder
		END
		IF(@i_aggregate = 6)
		BEGIN
				SELECT CommServUniqueId AS 'CommServe UniqueId',
				ParamId,
				GroupId,
				GroupName AS Name,
				Monitor AS 'Parameter',
				R.Status,
				Result AS 'Outcome',
				ExpectedResult AS 'Expected',
				Recommendation AS 'Remarks'
				FROM #TblSurveyResult R WHERE GroupName <> 'Snap'
				ORDER BY GroupSortOrder,
				MonitorSortOrder
		END
		IF(@i_aggregate = 7)
		BEGIN
				SELECT Monitor,
				Result,
				Status,
				MonitorId
				FROM #TblSurveyResult
				ORDER BY GroupSortOrder,
				MonitorSortOrder
		END
		IF(@i_aggregate = 8)
		BEGIN
				SELECT CommServUniqueId AS 'CommServe UniqueId',
				Monitor AS 'Parameter',
				Name,
				A.Status,
				Result AS 'Outcome',
				ExpectedResult AS 'Expected',
				Recommendation AS 'Remarks'
				FROM #TblSurveyResult
				AS A inner join cf_CommservSurveyGroups on SurveyGroupId = GroupId ORDER BY GroupSortOrder, MonitorSortOrder
		END
		IF(@i_aggregate = 10)
		BEGIN
				SELECT CommServUniqueId AS 'CommUniId',
				Monitor AS 'Parameter',
				Status,
				Result AS 'Outcome',
				Recommendation AS 'Remarks',
				MonitorId AS SurveyId,
				ParamId,
				MonitorSortOrder as 'MonitorSortOrder<DONOTSHOW>',
				GroupID as 'GroupID<DONOTSHOW>',
				GroupSortOrder AS 'GroupSortOrder<DONOTSHOW>'
				FROM #TblSurveyResult
		END
		IF (@i_aggregate = 11) --Health report worldwide/group level
		BEGIN
			SELECT P.CommServUniqueId, [SLA], [Disaster Recovery Backup], [Disk Library Growth], [Fallen Behind Secondary Copies]
			FROM (SELECT CommServUniqueId, Monitor, Status FROM #TblSurveyResult) T
			PIVOT
			(
				   MAX(Status)
				   FOR Monitor IN ([SLA], [Disaster Recovery Backup], [Fallen Behind Secondary Copies], [Disk Library Growth])
			) AS P
		END
	IF object_id('tempdb.dbo.#commcells') is not null DROP TABLE #commcells
	IF object_id('tempdb.dbo.#latestResults') IS NOT null DROP TABLE #latestResults
	IF object_id('tempdb.dbo.#TblSurveyResult') is not null DROP TABLE #TblSurveyResult
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'RptGetServerHealth')
	delete from GxQscripts where name = 'RptGetServerHealth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetServerHealth')
	delete from GXDBVersions where aliasname = 'RptGetServerHealth'
GO

insert into GXDBVersions values(2, 'RptGetServerHealth',  'v1.1.2.75.4.3', 'RptGetServerHealth', 'v1.1.2.75.4.3')
GO

