

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetCompanyTrend.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetCompanyTrend.sp,v $ $Id: RptGetCompanyTrend.sp,v 1.1.2.8 2020/12/17 02:49:11 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptGetCompanyTrend')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCompanyTrend <<<'
	drop procedure RptGetCompanyTrend
END
IF EXISTS (select * from GxQscripts where name='RptGetCompanyTrend')
	delete from GxQscripts where name = 'RptGetCompanyTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCompanyTrend')
	delete from GXDBVersions where aliasname = 'RptGetCompanyTrend'
GO
print '... Creating Procedure: RptGetCompanyTrend'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptGetCompanyTrend
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_CommServUniqueID INT = 0,
  @i_TenantName NVARCHAR(255) = NULL,
  @i_LastNDays INT = 30,
  @i_Category INT = 0,
  @i_optionFlags INT = 0,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @showDeactivated INT = 0, @showDeleted INT = 0, @i_ShowTrend INT = 0
IF @i_optionFlags & 1 = 1
	SET @i_ShowTrend = 1
IF @i_optionFlags & 2 = 2
	SET @showDeactivated = 1
IF @i_optionFlags & 4 = 4
	SET @showDeleted = 1
DECLARE @i_QueryId INT = 251
IF object_id('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult(
	SurveyResultId BIGINT,
	CommServUniqueId INT,
	CommCellID INT,
	DisplayName NVARCHAR(256)
)
INSERT  INTO #LatestResult
SELECT  SurverResultId, CommServUniqueId, CommCellID, DisplayName
FROM    dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF OBJECT_ID('tempdb.dbo.#DailyTenants') IS NOT null DROP TABLE #DailyTenants
CREATE TABLE #DailyTenants
(
	SignUpDate			Date
)
DECLARE @today DATE = (SELECT CAST(GETDATE() AS DATE))
;WITH R(N) AS
(
    SELECT 0
    UNION ALL
    SELECT N+1
    FROM R
    WHERE N < @i_LastNDays
)
INSERT INTO #DailyTenants
    SELECT   DATEADD(DAY,-N,@today) FROM R option (maxrecursion 0)
IF @i_Category = 0 --Company count per day
BEGIN
		IF @blaggregate = 0
		BEGIN
			select T.CommServUniqueId,
				   T.TenantId,
				   D.SignUpDate,
				   CASE WHEN (T.DeletedDate is NULL AND T.Flag & 16 = 16) THEN 'Deactivated'
						WHEN T.DeletedDate is not NULL THEN 'Deleted'
						ELSE 'Active' END AS Status,
				   T.DeletedDate AS [Deleted date],
				   T.DeactivatedDate AS [Deactivated date],
				   CC.CustomerName,
				   T.TenantName,
				   COUNT(DISTINCT C.ClientId) AS [Client Count]
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON D.SignUpDate = CAST(T.SignUpDate AS DATE) AND T.CommservUniqueId = CC.ID
			LEFT OUTER JOIN cf_SurveyClientGroupAssociation CGA WITH (NOLOCK) ON CGA.Commservuniqueid = T.Commservuniqueid AND T.ClientGroupId=CGA.ClientGroupId
			LEFT OUTER JOIN cf_SurveyClient C WITH (NOLOCK) ON C.Commservuniqueid = T.Commservuniqueid AND C.ClientId=CGA.ClientId
			WHERE T.CommServUniqueId is NOT NULL AND ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY T.CommServUniqueId, T.TenantId, D.SignUpDate, T.Flag, T.DeletedDate, T.DeactivatedDate, CC.CustomerName, T.TenantName
		END
		ELSE
		BEGIN
			SELECT SUM(CompanyCount) AS CompanyCount, SUM(NewCompany) AS NewCompany, SignUpDate FROM(
			select COUNT(DISTINCT T.TenantName) AS CompanyCount,
				   0 AS NewCompany,
				   D.SignUpDate
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON CAST(T.SignUpDate AS DATE) <= D.SignUpDate AND T.CommservUniqueId = CC.ID
			WHERE ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY D.SignUpDate
			UNION ALL
			select 0,
				   COUNT(DISTINCT T.TenantName) AS NewCompany,
				   D.SignUpDate
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON CAST(T.SignUpDate AS DATE) = D.SignUpDate AND T.CommservUniqueId = CC.ID
			WHERE ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY D.SignUpDate
			) F
			GROUP BY SignUpDate
		END
	RETURN
END
ELSE IF @i_Category = 1 --Server count per day
BEGIN
	IF @blaggregate = 0
		BEGIN
			select T.CommServUniqueId,
				   T.TenantId,
				   D.SignUpDate,
				   CASE WHEN T.CommServUniqueId is NULL THEN 0 ELSE COUNT(DISTINCT C.ClientId) END AS Client,
				   CC.CustomerName,
				   T.TenantName
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_surveyclient C WITH (NOLOCK) ON CAST(InstallDate AS DATE) = CAST(D.SignUpDate AS DATE) AND C.Commservuniqueid = LR.CommServUniqueId
			INNER JOIN cf_SurveyClientGroupAssociation CGA  WITH (NOLOCK) ON CGA.CommservUniqueId = C.CommservUniqueId
															AND CGA.ClientId = C.ClientId
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON T.ClientGroupId = CGA.ClientGroupID AND T.CommservUniqueId = CGA.CommservUniqueId
			WHERE T.CommServUniqueId is NOT NULL AND ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY T.CommServUniqueId, T.TenantId, D.SignUpDate, CC.CustomerName, T.TenantName
		END
		ELSE IF @i_ShowTrend = 1
		BEGIN
			select COUNT(DISTINCT C.ClientId) AS Client,
				   D.SignUpDate
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON T.CommservUniqueId = CC.ID
			INNER JOIN cf_SurveyClientGroupAssociation CGA  WITH (NOLOCK) ON CGA.CommservUniqueId = T.CommservUniqueId
															AND CGA.ClientGroupId = T.ClientGroupID
			INNER JOIN cf_surveyclient C WITH (NOLOCK) ON CAST(InstallDate AS DATE) <= D.SignUpDate AND C.Clientid = CGA.ClientId AND C.Commservuniqueid = CGA.CommServUniqueId
			WHERE ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY D.SignUpDate
		END
		ELSE
		BEGIN
			select COUNT(DISTINCT C.ClientId) AS Client,
				   D.SignUpDate
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON T.CommservUniqueId = CC.ID
			INNER JOIN cf_SurveyClientGroupAssociation CGA  WITH (NOLOCK) ON CGA.CommservUniqueId = T.CommservUniqueId
															AND CGA.ClientGroupId = T.ClientGroupID
			INNER JOIN cf_surveyclient C WITH (NOLOCK) ON CAST(InstallDate AS DATE) = D.SignUpDate AND C.Clientid = CGA.ClientId AND C.Commservuniqueid = CGA.CommServUniqueId
			WHERE ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY D.SignUpDate
		END
	RETURN
END
ELSE IF @i_Category = 2 --Backup jobs count per day
BEGIN
		IF @blaggregate = 0
			select T.CommServUniqueId,
				   T.TenantId,
				   D.SignUpDate,
				   SUM(TotalJobs)-SUM(SkippedJobs)-SUM(FailedToStartJobs) AS JobCount,
				   CC.CustomerName,
				   T.TenantName
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON LR.CommservUniqueId = T.CommservUniqueId
			LEFT OUTER JOIN cf_surveyCompanyDailyBkpJobStats JS WITH (NOLOCK) ON JS.CommservUniqueId = T.CommservUniqueId AND JS.ClientGroupID = T.clientGroupID
												AND JS.JobEndDate = D.SignUpDate
			WHERE T.CommServUniqueId is NOT NULL AND ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY T.CommServUniqueId, T.TenantId, D.SignUpDate, CC.CustomerName, T.TenantName
		ELSE
			select ISNULL(SUM(TotalJobs)-SUM(SkippedJobs)-SUM(FailedToStartJobs),0) AS JobCount,
				   D.SignUpDate
			from #DailyTenants D
			INNER JOIN #LatestResult LR ON LR.CommServUniqueId > 0
			INNER JOIN cf_commcellidNameMap CC WITH (NOLOCK) ON CC.ID = LR.Commservuniqueid
			INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON LR.CommservUniqueId = T.CommservUniqueId
			LEFT OUTER JOIN cf_surveyCompanyDailyBkpJobStats JS WITH (NOLOCK) ON JS.CommservUniqueId = T.CommservUniqueId AND JS.ClientGroupID = T.clientGroupID
												AND JS.JobEndDate = D.SignUpDate
			WHERE T.CommServUniqueId is NOT NULL AND ((@showDeactivated=0 AND T.Flag<>16) OR @showDeactivated=1) AND ((@showDeleted=0 AND T.Flag<>18) OR @showDeleted=1)
			AND ((@i_TenantName is NOT NULL AND @i_TenantName = T.TenantName) OR (@i_TenantName is NULL AND T.TenantName is NOT NULL))
			GROUP BY D.SignUpDate
	RETURN
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCompanyTrend')
	delete from GxQscripts where name = 'RptGetCompanyTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCompanyTrend')
	delete from GXDBVersions where aliasname = 'RptGetCompanyTrend'
GO

insert into GXDBVersions values(2, 'RptGetCompanyTrend',  '00010001000200080000', 'RptGetCompanyTrend', '00010001000200080000')
GO

