

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetCommCellGroupInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetCommCellGroupInfo.sp,v $ $Id: RptGetCommCellGroupInfo.sp,v 1.1.2.14 2020/10/26 06:21:44 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetCommCellGroupInfo')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCommCellGroupInfo <<<'
	drop procedure RptGetCommCellGroupInfo
END
IF EXISTS (select * from GxQscripts where name='RptGetCommCellGroupInfo')
	delete from GxQscripts where name = 'RptGetCommCellGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellGroupInfo')
	delete from GXDBVersions where aliasname = 'RptGetCommCellGroupInfo'
GO
print '... Creating Procedure: RptGetCommCellGroupInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCommCellGroupInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_Option INT = 0,
  @i_CommServUniqueID INT = 0
AS
DECLARE @UserCapability INT = -1
SET @UserCapability = (SELECT surveycapability FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId = @i_UserId)
DECLARE @UserProp xml
DECLARE @param_isProfileEnabled INT = 0
SELECT	@param_isProfileEnabled = ISNULL(cast(Value AS INT), 0) FROM cf_SurveyConfig WHERE Name = 'isProfileEnabled'
IF @i_GroupId IS NULL
	SET @i_GroupId = -1
IF @i_CommServUniqueID IS NULL
	SET @i_CommServUniqueID = -1
IF object_id('tempdb.dbo.#groupTbl') is not null DROP TABLE #groupTbl
CREATE TABLE #groupTbl (gId INT)
IF object_id('tempdb.dbo.#ccTbl') is not null DROP TABLE #ccTbl
CREATE TABLE #ccTbl (gId INT, ccuId INT, MetricsServices INT)
IF (@i_UserId = -1 OR @UserCapability = 1)
BEGIN
	INSERT INTO #groupTbl(gId)
	SELECT id FROM cf_CommcellGroup WITH (NOLOCK) WHERE (@i_GroupId <= 0 OR @i_GroupId = id) AND status & 32 = 0
	IF ISNULL(@i_GroupId, 0) > 0 --Include default created groups only if id is passed
	BEGIN
		INSERT INTO #groupTbl(gId)
		SELECT id FROM cf_CommcellGroup WITH (NOLOCK) WHERE @i_GroupId = id AND status & 32 <> 0
	END
END
ELSE IF (@i_UserId IS NOT NULL)
BEGIN
	SET @UserProp = (SELECT UserProp FROM cf_MetricsLoggedInUsers WITH (NOLOCK) WHERE UserId =@i_UserId)
	INSERT INTO #groupTbl(gId) --Non default commcell groups
	SELECT
		ccg.value('@clientGroupId', 'INT')
	From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
		CROSS apply resp.nodes('commcellGroups') AS ccg(ccg)
	IF ISNULL(@i_GroupId, 0) > 0 --Include default created groups only if id is passed
	BEGIN
		INSERT INTO #groupTbl(gId)	--Default commcell groups created for companies
		SELECT CG.id
		FROM (
				SELECT
					ccg.value('@userGroupId', 'INT') companyId
				From @UserProp.nodes('WebReport_CloudMetricsUserResp') AS resp(resp)
					CROSS apply resp.nodes('companies/company') AS ccg(ccg)
			) UG
			INNER JOIN cf_CustomerGroup G WITH(NOLOCK)
				ON G.id = UG.companyId
				AND G.clientGroupId = @i_GroupId
			INNER JOIN cf_CommcellGroup CG WITH(NOLOCK)
				ON CG.id = G.clientGroupId
				AND CG.status & 32 <> 0
	END
END
ELSE
BEGIN
	RETURN
END
--If group id is given, delete all other groups
DELETE FROM #groupTbl WHERE (@i_GroupId > 0 AND gId != @i_groupId)
IF ISNULL(@i_GroupId, 0) <= 0 --DELETE default CommCell Groups created for company
	DELETE tg FROM #groupTbl tg INNER JOIN cf_CommcellGroup g WITH(NOLOCK) ON tg.gId = g.id AND g.status & 32 <> 0
INSERT INTO #ccTbl
	SELECT DISTINCT up.gId, ISNULL(sub.CommcellIdNameMap_ID, -1), ISNULL(sub.CommCellSurveyServices, 0)
		FROM #groupTbl up
			INNER JOIN cf_CommcellGroup g WITH (NOLOCK, READUNCOMMITTED)
				ON g.id = up.gId
			LEFT OUTER JOIN
			(	SELECT  ga.commCellGroupId, ga.CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellGroupAssoc ga WITH (NOLOCK, READUNCOMMITTED)
					INNER JOIN cf_CommcellIdNameMap cc WITH (NOLOCK)
						ON cc.ID = ga.CommcellIdNameMap_ID
				UNION --Permanent CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('Permanent CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE CommCellID >= 655360
				UNION --Eval CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('Eval CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE CommCellID = -1
				UNION --NFR CommCells
				SELECT
					(SELECT id AS commCellGroupId FROM cf_CommcellGroup cg WITH (NOLOCK) WHERE name in ('NFR CommCells')) AS commCellGroupId,
					ID AS CommcellIdNameMap_ID, CommCellSurveyServices
				FROM cf_CommcellIdNameMap cc WITH (NOLOCK) WHERE (CommCellID > 0 AND CommCellID < 655360)
			) AS sub
				ON up.gId = sub.commCellGroupId
CREATE CLUSTERED INDEX ccTbl_ccuId_idx ON #ccTbl (ccuId)
--If CommServUniqueID is given, delete all other CommCells
IF @i_CommServUniqueID > 0
	DELETE FROM #ccTbl WHERE ccuId != @i_CommServUniqueID
IF object_id('tempdb.dbo.#MetricsServices') is not null DROP TABLE #MetricsServices
CREATE TABLE #MetricsServices (gId INT, nHealth INT, nActivity INT, nAudit INT, nChargeback INT)
INSERT	INTO #MetricsServices
SELECT	gId, SUM(MetricsServices&1), SUM((MetricsServices&4)/4), SUM((MetricsServices&16)/16), SUM((MetricsServices&32)/32)
FROM	#ccTbl
GROUP BY gId
IF object_id('tempdb.dbo.#CommCellCount') is not null DROP TABLE #CommCellCount
CREATE TABLE #CommCellCount (gId INT, nCommCells INT)
INSERT	INTO #CommCellCount
SELECT	gId, COUNT(DISTINCT ccuId)
FROM	cf_CommcellGroupAssoc WITH (NOLOCK)
		RIGHT OUTER JOIN #ccTbl ON gId = commCellGroupId AND ccuId = CommcellIdNameMap_ID
WHERE ccuId <> -1
GROUP BY gId
IF object_id('tempdb.dbo.#ClientCount') is not null DROP TABLE #ClientCount
CREATE TABLE #ClientCount (gId INT, nActiveClients INT)
INSERT	INTO #ClientCount
SELECT	gId, SUM(ISNULL(TotalActiveClients,0))
FROM	dbo.cf_SurveyResultFuncV1(8, 0, 3, NULL, NULL, @i_UserId, -1) AS R
		INNER JOIN cf_SurveyClientStatisticsInfo C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
		INNER JOIN #ccTbl ON ccuId = R.CommServUniqueId AND ccuId <> -1
GROUP BY gId
IF object_id('tempdb.dbo.#SLACounts') is not null DROP TABLE #SLACounts
CREATE TABLE #SLACounts (gId INT, ProtectedClients INT, NotProtectedClients INT)
INSERT	INTO #SLACounts
SELECT	gId, SUM(ISNULL(ProtectedClients,0)), SUM(ISNULL(NotProtectedClients,0))
FROM	dbo.cf_SurveyResultFuncV1(146, 0, 3, NULL, NULL, @i_UserId, -1) AS R
		INNER JOIN cf_CommcellSummary C WITH (NOLOCK) ON C.SurveyResultId = R.SurverResultId
		INNER JOIN #ccTbl ON ccuId = R.CommServUniqueId AND ccuId <> -1
GROUP BY gId
IF (ISNULL(@i_Option, 0) = 1)
BEGIN
	SELECT COUNT(DISTINCT gId) AS GroupCount FROM #ccTbl
END
ELSE IF (ISNULL(@i_Option, 0) = 2 AND @i_CommServUniqueID > 0)  --Looking for last created CommCell group for this commcell
BEGIN
	IF (@param_isProfileEnabled = 0)
		SELECT TOP 1
			g.id AS 'GroupId<DONOTSHOW>',
			g.name AS 'Group Name<CommCellGroup>',
			g.description AS 'Group Description<DONOTSHOW>',
			ISNULL(cc.nCommCells, 0) AS 'Number of CommCells',
			ISNULL(cl.nActiveClients, 0) AS 'Active Clients',
			ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0) AS 'SLA (%)',
			ms.nHealth AS 'Health<HIDDEN>',
			ms.nActivity AS 'Activity<HIDDEN>',
			ms.nAudit AS  'Audit<HIDDEN>',
			ms.nChargeback AS  'Chargeback<HIDDEN>',
			g.createdByUser AS 'Created By<HIDDEN>',
			g.modifiedByUser AS 'Modified By<HIDDEN>'
		FROM
			cf_CommCellGroup g WITH (NOLOCK)
			INNER JOIN #MetricsServices ms ON ms.gId = g.id
			LEFT OUTER JOIN #CommCellCount cc ON cc.gId = g.id
			LEFT OUTER JOIN #ClientCount cl ON cl.gId = g.id
			LEFT OUTER JOIN #SLACounts sla ON sla.gId = g.id
		ORDER BY [Number of CommCells]
	ELSE
		SELECT TOP 1
			g.id AS 'GroupId<DONOTSHOW>',
			g.name AS 'Group Name<CommCellGroup>',
			g.description AS 'Group Description<DONOTSHOW>',
			ISNULL(cc.nCommCells, 0) AS 'Number of CommCells',
			ISNULL(cl.nActiveClients, 0) AS 'Active Clients',
			ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0) AS 'SLA (%)',
			ms.nHealth AS 'Health<HIDDEN>',
			ms.nActivity AS 'Activity<HIDDEN>',
			ms.nAudit AS  'Audit<HIDDEN>',
			ms.nChargeback AS  'Chargeback<HIDDEN>',
			g.createdByUser AS 'Created By<HIDDEN>',
			g.modifiedByUser AS 'Modified By<HIDDEN>',
			CASE g.isProfileEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Profile Enabled<BOOLEAN><HIDDEN>'
		FROM
			cf_CommCellGroup g WITH (NOLOCK)
			INNER JOIN #MetricsServices ms ON ms.gId = g.id
			LEFT OUTER JOIN #CommCellCount cc ON cc.gId = g.id
			LEFT OUTER JOIN #ClientCount cl ON cl.gId = g.id
			LEFT OUTER JOIN #SLACounts sla ON sla.gId = g.id
		WHERE	g.isProfileEnabled = 1
		ORDER BY g.created DESC, [Number of CommCells]
END
ELSE
	IF (@param_isProfileEnabled = 0)
		SELECT
			g.id AS 'GroupId<DONOTSHOW>',
			g.name AS 'Group Name<CommCellGroup>',
			g.description AS 'Group Description<DONOTSHOW>',
			ISNULL(cc.nCommCells, 0) AS 'Number of CommCells',
			ISNULL(cl.nActiveClients, 0) AS 'Active Clients',
			ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0) AS 'SLA (%)',
			ms.nHealth AS 'Health<HIDDEN>',
			ms.nActivity AS 'Activity<HIDDEN>',
			ms.nAudit AS  'Audit<HIDDEN>',
			ms.nChargeback AS  'Chargeback<HIDDEN>',
			g.createdByUser AS 'Created By<HIDDEN>',
			g.modifiedByUser AS 'Modified By<HIDDEN>'
		FROM
			cf_CommCellGroup g WITH (NOLOCK)
			INNER JOIN #MetricsServices ms ON ms.gId = g.id
			LEFT OUTER JOIN #CommCellCount cc ON cc.gId = g.id
			LEFT OUTER JOIN #ClientCount cl ON cl.gId = g.id
			LEFT OUTER JOIN #SLACounts sla ON sla.gId = g.id
		ORDER BY g.name ASC
	ELSE
		SELECT
			g.id AS 'GroupId<DONOTSHOW>',
			g.name AS 'Group Name<CommCellGroup>',
			g.description AS 'Group Description<DONOTSHOW>',
			ISNULL(cc.nCommCells, 0) AS 'Number of CommCells',
			ISNULL(cl.nActiveClients, 0) AS 'Active Clients',
			ISNULL(CAST((CASE WHEN (NotProtectedClients+ProtectedClients)>0 THEN 100.0*ProtectedClients/(NotProtectedClients+ProtectedClients) ELSE 0 END) AS INT), 0) AS 'SLA (%)',
			ms.nHealth AS 'Health<HIDDEN>',
			ms.nActivity AS 'Activity<HIDDEN>',
			ms.nAudit AS  'Audit<HIDDEN>',
			ms.nChargeback AS  'Chargeback<HIDDEN>',
			g.createdByUser AS 'Created By<HIDDEN>',
			g.modifiedByUser AS 'Modified By<HIDDEN>',
			CASE g.isProfileEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Profile Enabled<BOOLEAN><HIDDEN>'
		FROM
			cf_CommCellGroup g WITH (NOLOCK)
			INNER JOIN #MetricsServices ms ON ms.gId = g.id
			LEFT OUTER JOIN #CommCellCount cc ON cc.gId = g.id
			LEFT OUTER JOIN #ClientCount cl ON cl.gId = g.id
			LEFT OUTER JOIN #SLACounts sla ON sla.gId = g.id
		ORDER BY g.name ASC
IF object_id('tempdb.dbo.#groupTbl') is not null DROP TABLE #groupTbl
IF object_id('tempdb.dbo.#ccTbl') is not null DROP TABLE #ccTbl
IF object_id('tempdb.dbo.#CommCellCount') is not null DROP TABLE #CommCellCount
IF object_id('tempdb.dbo.#ClientCount') is not null DROP TABLE #ClientCount
IF object_id('tempdb.dbo.#SLACounts') is not null DROP TABLE #SLACounts
IF object_id('tempdb.dbo.#MetricsServices') is not null DROP TABLE #MetricsServices
GO

IF EXISTS (select * from GxQscripts where name = 'RptGetCommCellGroupInfo')
	delete from GxQscripts where name = 'RptGetCommCellGroupInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellGroupInfo')
	delete from GXDBVersions where aliasname = 'RptGetCommCellGroupInfo'
GO

insert into GXDBVersions values(2, 'RptGetCommCellGroupInfo',  '00010001000200140000', 'RptGetCommCellGroupInfo', '00010001000200140000')
GO

