

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptGetCommCellAlerts.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptGetCommCellAlerts.sp,v $ $Id: RptGetCommCellAlerts.sp,v 1.1.2.4 2020/10/26 06:23:40 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptGetCommCellAlerts')
BEGIN
	print '>>> Drop Stored Procedure: RptGetCommCellAlerts <<<'
	drop procedure RptGetCommCellAlerts
END
IF EXISTS (select * from GxQscripts where name='RptGetCommCellAlerts')
	delete from GxQscripts where name = 'RptGetCommCellAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellAlerts')
	delete from GXDBVersions where aliasname = 'RptGetCommCellAlerts'
GO
print '... Creating Procedure: RptGetCommCellAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptGetCommCellAlerts
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_topNAlerts INT = 5,	--TOP Alerts to return for details
  @i_lastNDays INT = 7,
  @i_startDate DATETIME = NULL,
  @i_endDate DATETIME = NULL
AS
SET NOCOUNT ON
	DECLARE @nDaysAgo BIGINT = dbo.GetUnixTimeBig(DATEADD(DD, -@i_lastNDays, GETUTCDATE()))
	IF ISNULL(@blaggregate, 0) = 1
	BEGIN
		DECLARE @infoAlerts INT = 0
		DECLARE @warningAlerts INT = 0
		DECLARE @criticalAlerts INT = 0
		SELECT
			@criticalAlerts = SUM(CASE WHEN (EscalationLevel & 0xFFFF0000)/POWER(2,17) = 1 THEN 1 ELSE 0 END),
			@warningAlerts = SUM(CASE WHEN (EscalationLevel & 0xFFFF0000)/POWER(2,17) = 2 THEN 1 ELSE 0 END),
			@infoAlerts = SUM(CASE WHEN (EscalationLevel & 0xFFFF0000)/POWER(2,17) = 3 THEN 1 ELSE 0 END)
		FROM cf_NTLiveFeedsMessageHistory A WITH(NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)  CC
				ON A.CommservUniqueId = CC.CommServUniqueId
		WHERE A.DetectedTime >= @nDaysAgo
		SELECT ISNULL(@infoAlerts, 0) AS 'InfoAlerts', ISNULL(@warningAlerts, 0) AS 'WarningAlerts', ISNULL(@criticalAlerts, 0) AS 'CriticalAlerts'
	END
	ELSE
	BEGIN
		IF @i_topNAlerts > 0
			SELECT TOP (@i_topNAlerts)
				CC.CommServUniqueId AS 'CommServUniqueId',
				cc.DisplayName AS 'CommCell Name',
				dbo.ConvertBigIntToHexStr(cc.CommCellID) AS 'CommCellID',
				(EscalationLevel & 0xFFFF0000)/POWER(2,17) AS 'Severity',
				CASE (EscalationLevel & 0xFFFF0000)/POWER(2,17)
					WHEN 1 THEN 'Critical'
					WHEN 2 THEN 'Warning'
					WHEN 3 THEN 'Info'
				END AS 'SeverityText',
				A.ClientName AS 'Client',
				A.JobId AS 'JobId',
				A.AlertName AS 'AlertName',
				A.AlertType AS 'AlertType',
				A.AlertCriteria AS 'AlertCriteria',
				dbo.GetDateTime(A.DetectedTime) AS 'DetectedTime',
				A.Description AS 'Description'
			FROM cf_NTLiveFeedsMessageHistory A WITH(NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)  CC
					ON A.CommservUniqueId = CC.CommServUniqueId
			WHERE A.DetectedTime >= @nDaysAgo
			ORDER BY EscalationLevel, DetectedTime DESC
		ELSE
			SELECT
				CC.CommServUniqueId AS 'CommServUniqueId',
				cc.DisplayName AS 'CommCell Name',
				dbo.ConvertBigIntToHexStr(cc.CommCellID) AS 'CommCellID',
				(EscalationLevel & 0xFFFF0000)/POWER(2,17) AS 'Severity',
				CASE (EscalationLevel & 0xFFFF0000)/POWER(2,17)
					WHEN 1 THEN 'Critical'
					WHEN 2 THEN 'Warning'
					WHEN 3 THEN 'Info'
				END AS 'SeverityText',
				A.ClientName AS 'Client',
				A.JobId AS 'JobId',
				A.AlertName AS 'AlertName',
				A.AlertType AS 'AlertType',
				A.AlertCriteria AS 'AlertCriteria',
				dbo.GetDateTime(A.DetectedTime) AS 'DetectedTime',
				A.Description AS 'Description'
			FROM cf_NTLiveFeedsMessageHistory A WITH(NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(2, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)  CC
					ON A.CommservUniqueId = CC.CommServUniqueId
			WHERE A.DetectedTime >= @nDaysAgo
			ORDER BY EscalationLevel, DetectedTime DESC
	END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @i_CommServUniqueID INT		= 0   --11065
  DECLARE @i_topNAlerts INT = 5	--TOP Alerts to return for details
  DECLARE @i_lastNDays INT = 28
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptGetCommCellAlerts @i_UserId, @i_GroupId, @blaggregate,  @i_CommServUniqueID, @i_topNAlerts, @i_lastNDays, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptGetCommCellAlerts')
	delete from GxQscripts where name = 'RptGetCommCellAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptGetCommCellAlerts')
	delete from GXDBVersions where aliasname = 'RptGetCommCellAlerts'
GO

insert into GXDBVersions values(2, 'RptGetCommCellAlerts',  '00010001000200040000', 'RptGetCommCellAlerts', '00010001000200040000')
GO

