

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptFallenBehindBackupCopies.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptFallenBehindBackupCopies.sp,v $ $Id: RptFallenBehindBackupCopies.sp,v 1.1.2.6 2020/10/16 14:43:05 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptFallenBehindBackupCopies')
BEGIN
	print '>>> Drop Stored Procedure: RptFallenBehindBackupCopies <<<'
	drop procedure RptFallenBehindBackupCopies
END
IF EXISTS (select * from GxQscripts where name='RptFallenBehindBackupCopies')
	delete from GxQscripts where name = 'RptFallenBehindBackupCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFallenBehindBackupCopies')
	delete from GXDBVersions where aliasname = 'RptFallenBehindBackupCopies'
GO
print '... Creating Procedure: RptFallenBehindBackupCopies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptFallenBehindBackupCopies
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 209
DECLARE @strGood VARCHAR(10) = '1_Good'
DECLARE @strInfo VARCHAR(10) = '2_Info'
DECLARE @strwarning VARCHAR(10) = '3_Warning'
DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @criticalVal int
DECLARE @warningVal int
SELECT  @warningVal = WarningThreshold,
        @criticalVal =CriticalThreshold
FROM    cf_SurveyHealthParam WITH(NOLOCK) where queryId = @i_QueryId
DECLARE @utcTimeNow BIGINT = (SELECT dbo.getUnixTimeBig(GETUTCDATE()))
IF @i_CommServUniqueID = 0
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.DisplayName AS 'CommCell Name',
		csinfo.JobId AS 'Job Id',
		ISNULL(CL.clientDisplayName, sub.ClientName) AS 'Client',
		sub.AgentName AS 'Agent',
		sub.SubclientName AS 'Subclient',
		copy.PolicyName AS 'Storage Policy',
		copy.CopyName AS 'Source Snap Copy',
		(@utcTimeNow - csInfo.JobEndDateUTC) / 86400 AS 'Fallen Behind Days',
		CASE
				WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) > @criticalVal THEN @strCritical
				WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= @warningVal THEN @strWarning
				ELSE @strInfo
		END as 'Status<HEALTH_STATUS>'
	FROM cf_SurveyFallenBehindBackupCopies csinfo WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS resultView
					ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		INNER JOIN cf_SurveySubclientAssociation sub WITH(NOLOCK) ON csInfo.CommServUniqueId = sub.CommServUniqueId AND csInfo.SubclientId = sub.AppId
		INNER JOIN cf_SurveyCopyBasicRetention copy WITH(NOLOCK) ON csInfo.CommServUniqueId = copy.CommServUniqueId AND csInfo.CopyId = copy.CopyId
		INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = sub.CommServUniqueId AND CL.ClientId = sub.ClientId AND CL.InstallStatus NOT IN (1,2)
	ORDER BY resultView.DisplayName ASC, 'Fallen Behind Days' DESC
END
ELSE
BEGIN
	SELECT
		csinfo.JobId AS 'Job Id',
		ISNULL(CL.clientDisplayName, sub.ClientName) AS 'Client',
		sub.AgentName AS 'Agent',
		sub.SubclientName AS 'Subclient',
		copy.PolicyName AS 'Storage Policy',
		copy.CopyName AS 'Source Snap Copy',
		(@utcTimeNow - csInfo.JobEndDateUTC) / 86400 AS 'Fallen Behind Days',
		CASE
				WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) > @criticalVal THEN @strCritical
				WHEN ((@utcTimeNow - csInfo.JobEndDateUTC) / 86400) >= @warningVal THEN @strWarning
				ELSE @strInfo
		END as 'Status<HEALTH_STATUS>'
	FROM cf_SurveyFallenBehindBackupCopies csinfo WITH(NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId) AS resultView
					ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		INNER JOIN cf_SurveySubclientAssociation sub WITH(NOLOCK) ON csInfo.CommServUniqueId = sub.CommServUniqueId AND csInfo.SubclientId = sub.AppId
		INNER JOIN cf_SurveyCopyBasicRetention copy WITH(NOLOCK) ON csInfo.CommServUniqueId = copy.CommServUniqueId AND csInfo.CopyId = copy.CopyId
		INNER JOIN cf_SurveyClient CL WITH (NOLOCK) ON CL.CommServUniqueId = sub.CommServUniqueId AND CL.ClientId = sub.ClientId AND CL.InstallStatus NOT IN (1,2)
	ORDER BY 'Fallen Behind Days' DESC
END
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
  DECLARE @i_UserId INT					= 1
  DECLARE @i_GroupId INT				= NULL
  DECLARE @blaggregate INT				= 0
  DECLARE @blLatestSurvey INT			= 1
  DECLARE @i_CommServUniqueID INT		= 11065
  DECLARE @i_LogDateEND DATETIME		= 	NULL    -- getDate()
  DECLARE @i_LogDateStart DATETIME		= NULL   --DateAdd(Month, -36, @i_LogDateEND)
exec RptFallenBehindBackupCopies @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND
*/

IF EXISTS (select * from GxQscripts where name = 'RptFallenBehindBackupCopies')
	delete from GxQscripts where name = 'RptFallenBehindBackupCopies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFallenBehindBackupCopies')
	delete from GXDBVersions where aliasname = 'RptFallenBehindBackupCopies'
GO

insert into GXDBVersions values(2, 'RptFallenBehindBackupCopies',  '00010001000200060000', 'RptFallenBehindBackupCopies', '00010001000200060000')
GO

