

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptFailingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptFailingClients.sp,v $ $Id: RptFailingClients.sp,v 1.19.2.37 2020/12/17 02:47:02 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptFailingClients')
BEGIN
	print '>>> Drop Stored Procedure: RptFailingClients <<<'
	drop procedure RptFailingClients
END
IF EXISTS (select * from GxQscripts where name='RptFailingClients')
	delete from GxQscripts where name = 'RptFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFailingClients')
	delete from GXDBVersions where aliasname = 'RptFailingClients'
GO
print '... Creating Procedure: RptFailingClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptFailingClients
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll ,
  @i_AppGroupFlags INT = 0, -- 0 for All, 1 for File System, 2 for Database, 3 for Exchange, 4 for Lotus Notes, 5 for SharePoint, 6 for Virtual Server
  @i_BackupType VARCHAR(32) = '', -- '' for all, 'Full' or 'NonFull'
  @i_MonthlyStrikes INT = 0,
  @i_ccGroupIdList NVARCHAR(MAX) = NULL,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @isPrivate INT
SELECT  @isPrivate = ISNULL(CAST(value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'isPrivate'
IF object_id('tempdb.dbo.#TenantClients') IS NOT NULL DROP TABLE #TenantClients
CREATE TABLE #TenantClients (CommServUniqueId INT, TenantName NVARCHAR(255), ClientId INT)
exec GetTenantEntities @i_UserId, @i_GroupId, @blaggregate, @blLatestSurvey, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
SET @i_BackupType = '' --Not separating Full and NonFull any more
DECLARE @i_QueryId BIGINT = 25
DECLARE @AppTypeTbl TABLE (appTypeId INT)
SET @i_AppGroupFlags = ISNULL(@i_AppGroupFlags, 0)
IF  @i_AppGroupFlags > 0
BEGIN
	INSERT	INTO @AppTypeTbl
	SELECT	appTypeId FROM dbo.GetAppTypesByAppGroupFlags(@i_AppGroupFlags)
END
IF object_id('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult (SurveyResultId BIGINT, CommServUniqueId INT, CommCellID INT, DisplayName NVARCHAR(256))
IF (@i_MonthlyStrikes = 1)
BEGIN
	INSERT	INTO #LatestResult
	SELECT	SurverResultId, CommServUniqueId, CommCellID, DisplayName
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
	DECLARE @ThisMonth  DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE())-1,0)
	DECLARE @STARTDATE  DATE = @ThisMonth
	DECLARE @ENDDATE    DATE = DATEADD(MONTH, 1, @STARTDATE)
	DECLARE @lastNMonths INT = 12
	IF OBJECT_ID('tempdb.dbo.#CCGrpAssoc') IS NOT NULL DROP TABLE #CCGrpAssoc
	DECLARE @inputGroups TABLE (groupId INT)
	--INSERT INTO @inputGroups SELECT CAST(Data AS INT) FROM dbo.Split(@i_ccGroupIdList, ',')
	WHILE (CHARINDEX(' ',@i_ccGroupIdList)>0)
	BEGIN
		INSERT INTO @inputGroups (groupId)
		SELECT LTRIM(RTRIM(SUBSTRING(@i_ccGroupIdList,1,CHARINDEX(' ',@i_ccGroupIdList)-1)))
		SET @i_ccGroupIdList = SUBSTRING(@i_ccGroupIdList,CHARINDEX(' ',@i_ccGroupIdList)+1,LEN(@i_ccGroupIdList))
	End
	IF(@i_ccGroupIdList IS NOT NULL AND LEN(@i_ccGroupIdList) > 0)
	BEGIN
		INSERT INTO @inputGroups (groupId)
		SELECT LTRIM(RTRIM(@i_ccGroupIdList))
	END
	SELECT CG.GroupId AS Id, CG.GroupName AS Name, GA.commcellIdNameMap_ID AS CommServUniqueId
	INTO #CCGrpAssoc
	FROM RptGetCommCellGroups(@i_UserId) CG
		INNER JOIN cf_CommCellGroupAssoc GA WITH (NOLOCK)
			ON GA.CommCellGroupId = CG.GroupId
	IF EXISTS (SELECT * FROM @inputGroups WHERE groupId IS NOT NULL)
	BEGIN
		DELETE #CCGrpAssoc
		FROM #CCGrpAssoc CG LEFT OUTER JOIN @inputGroups IG ON CG.Id = IG.groupId
		WHERE IG.GroupId IS NULL
	END
	;WITH MONTHS(Cnt, STARTDATE , ENDDATE ) AS
	(
		SELECT 1,@STARTDATE, @ENDDATE
		UNION ALL
		SELECT Cnt+1,DATEADD(MONTH, -1, STARTDATE),STARTDATE
		FROM MONTHS WHERE Cnt < @lastNMonths
	)
	SELECT RIGHT(CONVERT(VARCHAR(20),CAST(M.STARTDATE AS DATE),6),6) Month,
			SUM(ISNULL(Strike0, 0)) AS [0 Strike],
			SUM(ISNULL(Strike1, 0)) AS [1 Strike],
			SUM(ISNULL(Strike2, 0)) AS [2 Strike],
			SUM(ISNULL(Strike3, 0)) AS [3 Strike]
	FROM cf_SurveyMonthlyStrikes AS csInfo WITH (NOLOCK)
			INNER JOIN #CCGrpAssoc CG ON CG.CommServUniqueId = csInfo.CommServUniqueId
            INNER JOIN #LatestResult AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
			RIGHT OUTER JOIN MONTHS M
				ON csInfo.MonthStart = M.STARTDATE
		GROUP BY M.STARTDATE
		ORDER BY M.STARTDATE
END
ELSE IF (@blaggregate = 1)
BEGIN
	INSERT	INTO #LatestResult
	SELECT	SurverResultId, CommServUniqueId, CommCellID, DisplayName
	FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
	IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
    CREATE TABLE #StrikeEntities (clientId INT, appId INT, appTypeId INT, backupType INT, isVM INT, strikeCount INT)
	INSERT INTO #StrikeEntities
	SELECT  csInfo.ClientId, csInfo.AppId, SA.appTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END, 0, MAX(csInfo.StrikeCounts)
	FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS result
			ON result.SurveyResultId = csInfo.SurveyResultId
			AND csInfo.StrikeCounts > 0
			AND csInfo.LastJobStartTime >= ISNULL(@i_LogDateStart, '01/01/1970')
 		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
			ON SA.CommServUniqueId = result.CommServUniqueId AND csInfo.ClientId = SA.ClientId
			AND csInfo.AppId = SA.AppId AND SA.AppTypeId <> 106 AND SA.Deleted = 0
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON SA.CommServUniqueId = TC.CommServUniqueId AND SA.ClientId = TC.ClientId
	WHERE (@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL
	GROUP BY csInfo.ClientId, csInfo.AppId, SA.appTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END
	INSERT INTO #StrikeEntities
	SELECT  csInfo.ClientId, csInfo.AppId, SA.appTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END, 1, MAX(csInfo.StrikeCounts)
	FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS result
			ON result.SurveyResultId = csInfo.SurveyResultId
			AND csInfo.StrikeCounts > 0
			AND csInfo.LastJobStartTime >= ISNULL(@i_LogDateStart, '01/01/1970')
 		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
			ON SA.CommServUniqueId = result.CommServUniqueId
			AND csInfo.AppId = SA.AppId AND SA.AppTypeId = 106 AND SA.Deleted = 0
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON SA.CommServUniqueId = TC.CommServUniqueId AND SA.ClientId = TC.ClientId
	WHERE (@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL
	GROUP BY csInfo.ClientId, csInfo.AppId, SA.appTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END
	IF @i_AppGroupFlags > 0
		DELETE	S
		FROM	#StrikeEntities S
				LEFT OUTER JOIN @AppTypeTbl AT ON S.appTypeId = AT.appTypeId
		WHERE	AT.appTypeId IS NULL
    DECLARE @scStrikes TABLE (strikeCount INT, scCount INT)
    DECLARE @clStrikes TABLE (strikeCount INT, clCount INT)
    DECLARE @vmStrikes TABLE (strikeCount INT, vmCount INT)
    INSERT INTO @scStrikes
	SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT appId)
	FROM	#StrikeEntities
	WHERE	isVM = 0
	GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
    INSERT INTO @clStrikes
	SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
	FROM	(
		SELECT	clientId, MAX(strikeCount) AS strikeCount
		FROM	#StrikeEntities
		WHERE	isVM = 0
		GROUP BY clientId
		) S
	GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
    INSERT INTO @vmStrikes
	SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
	FROM	#StrikeEntities
	WHERE	isVM = 1
	GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
	DECLARE	@strikeType TABLE (strikeCount INT, backupType INT, strikes INT)
	INSERT INTO @strikeType
	SELECT	CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, BackupType, COUNT(*)
	FROM	#StrikeEntities
	GROUP BY CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, BackupType
	IF object_id('tempdb.dbo.#StrikeEntities') is not null DROP TABLE #StrikeEntities
	SELECT
        3 as 'Strikes<strikeCount>' ,
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 3 AND BackupType =  1), 0) as 'Full<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 3 AND BackupType <> 1), 0) as 'Incremental<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(scCount) FROM @scStrikes  WHERE strikeCount = 3), 0) as 'Subclients<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(clCount) FROM @clStrikes  WHERE strikeCount = 3), 0) as 'Servers<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(vmCount) FROM @vmStrikes  WHERE strikeCount = 3), 0) as 'VMs<FORMATNUMBERNA>'
    UNION
	SELECT
        2 as 'Strikes<strikeCount>' ,
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 2 AND BackupType =  1), 0) as 'Full<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 2 AND BackupType <> 1), 0) as 'Incremental<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(scCount) FROM @scStrikes  WHERE strikeCount = 2), 0) as 'Subclients<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(clCount) FROM @clStrikes  WHERE strikeCount = 2), 0) as 'Servers<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(vmCount) FROM @vmStrikes  WHERE strikeCount = 2), 0) as 'VMs<FORMATNUMBERNA>'
    UNION
	SELECT
        1 as 'Strikes<strikeCount>' ,
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 1 AND BackupType =  1), 0) as 'Full<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(strikes) FROM @strikeType WHERE strikeCount = 1 AND BackupType <> 1), 0) as 'Incremental<FORMATNUMBERNA>',
		ISNULL((SELECT SUM(scCount) FROM @scStrikes  WHERE strikeCount = 1), 0) as 'Subclients<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(clCount) FROM @clStrikes  WHERE strikeCount = 1), 0) as 'Servers<FORMATNUMBERNA>',
        ISNULL((SELECT SUM(vmCount) FROM @vmStrikes  WHERE strikeCount = 1), 0) as 'VMs<FORMATNUMBERNA>'
    RETURN
END
ELSE
IF @i_CommServUniqueID = 0
BEGIN
	IF @i_TenantName IS NOT NULL
	BEGIN
		INSERT	INTO #LatestResult
		SELECT	SurverResultId, CommServUniqueId, CommCellID, DisplayName
		FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
		IF object_id('tempdb.dbo.#TenantStrikeEntities') is not null DROP TABLE #TenantStrikeEntities
		CREATE TABLE #TenantStrikeEntities (CommServUniqueId INT, TenantName NVARCHAR(255), clientId INT, appId INT, appTypeId INT, backupType INT, isVM INT, strikeCount INT)
		INSERT INTO #TenantStrikeEntities
		SELECT  result.CommServUniqueId , TC.TenantName, csInfo.ClientId, csInfo.AppId, SA.AppTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END, 0, MAX(csInfo.StrikeCounts)
		FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND csInfo.StrikeCounts > 0
				AND csInfo.LastJobStartTime >= ISNULL(@i_LogDateStart, '01/01/1970')
 			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
				ON SA.CommServUniqueId = result.CommServUniqueId AND csInfo.ClientId = SA.ClientId
				AND csInfo.AppId = SA.AppId AND SA.AppTypeId <> 106 AND SA.Deleted = 0
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
						 ON SA.CommServUniqueId = TC.CommServUniqueId AND SA.ClientId = TC.ClientId
		WHERE (@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL
		GROUP BY result.CommServUniqueId, TC.TenantName, csInfo.ClientId, csInfo.AppId, SA.AppTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END
		INSERT INTO #TenantStrikeEntities
		SELECT  result.CommServUniqueId, TC.TenantName, csInfo.ClientId, csInfo.AppId, SA.AppTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END, 1, MAX(csInfo.StrikeCounts)
		FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND csInfo.StrikeCounts > 0
				AND csInfo.LastJobStartTime >= ISNULL(@i_LogDateStart, '01/01/1970')
 			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
				ON SA.CommServUniqueId = result.CommServUniqueId
				AND csInfo.AppId = SA.AppId AND SA.AppTypeId = 106 AND SA.Deleted = 0
			LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
						 ON SA.CommServUniqueId = TC.CommServUniqueId AND SA.ClientId = TC.ClientId
		WHERE (@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL
		GROUP BY result.CommServUniqueId, TC.TenantName, csInfo.ClientId, csInfo.AppId, SA.AppTypeId, CASE WHEN csInfo.BackupType = 'Full' THEN 1 ELSE 2 END
		IF @i_AppGroupFlags > 0
			DELETE	S
			FROM	#TenantStrikeEntities S
					LEFT OUTER JOIN @AppTypeTbl AT ON S.appTypeId = AT.appTypeId
			WHERE	AT.appTypeId IS NULL
		DECLARE @TenantscStrikes TABLE (CommServUniqueId INT, TenantName NVARCHAR(255), strikeCount INT, scCount INT)
		DECLARE @TenantclStrikes TABLE (CommServUniqueId INT, TenantName NVARCHAR(255), strikeCount INT, clCount INT)
		DECLARE @TenantvmStrikes TABLE (CommServUniqueId INT, TenantName NVARCHAR(255), strikeCount INT, vmCount INT)
		INSERT INTO @TenantscStrikes
		SELECT CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT appId)
		FROM	#TenantStrikeEntities
		WHERE	isVM = 0
		GROUP BY CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
		INSERT INTO @TenantclStrikes
		SELECT	CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
		FROM	(
			SELECT	CommServUniqueId, TenantName, clientId, MAX(strikeCount) AS strikeCount
			FROM	#TenantStrikeEntities
			WHERE	isVM = 0
			GROUP BY CommServUniqueId, TenantName, clientId
			) S
		GROUP BY CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
		INSERT INTO @TenantvmStrikes
		SELECT	CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, COUNT(DISTINCT clientId)
		FROM	#TenantStrikeEntities
		WHERE	isVM = 1
		GROUP BY CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END
		DECLARE	@TenantstrikeType TABLE (CommServUniqueId INT, TenantName NVARCHAR(255), strikeCount INT, backupType INT, strikes INT)
		INSERT INTO @TenantstrikeType
		SELECT	CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, backupType, COUNT(*)
		FROM	#TenantStrikeEntities
		GROUP BY CommServUniqueId, TenantName, CASE WHEN strikeCount > 3 THEN 3 ELSE strikeCount END, backupType
		IF object_id('tempdb.dbo.#TenantStrikeEntities') is not null DROP TABLE #TenantStrikeEntities
		DECLARE @TenantCommCellLevelStrike TABLE (
				CommServUniqueId INT,
				TenantName NVARCHAR(255),
				FullStrike1 INT,
				FullStrike2 INT,
				FullStrike3 INT,
				Strike1SubClients INT,
				Strike2SubClients INT,
				Strike3SubClients INT,
				Strike1Clients INT,
				Strike2Clients INT,
				Strike3Clients INT,
				Strike1VMs INT,
				Strike2VMs INT,
				Strike3VMs INT
			)
		INSERT INTO @TenantCommCellLevelStrike
		SELECT CommServUniqueId,
				TenantName,
				SUM(FullStrike1),
				SUM(FullStrike2),
				SUM(FullStrike3),
				SUM(scStrike1),
				SUM(scStrike2),
				SUM(scStrike3),
				SUM(clStrike1),
				SUM(clStrike2),
				SUM(clStrike3),
				SUM(vmStrike1),
				SUM(vmStrike2),
				SUM(vmStrike3)
		FROM (
			select CommServUniqueId,
				   TenantName,
				   ISNULL(SUM(strikes),0) AS FullStrike1,
				   0 AS FullStrike2,
				   0 AS FullStrike3,
				   0 AS scStrike1,
				   0 AS scStrike2,
				   0 AS scStrike3,
				   0 AS clStrike1,
				   0 AS clStrike2,
				   0 AS clStrike3,
				   0 AS vmStrike1,
				   0 AS vmStrike2,
				   0 AS vmStrike3
			from @TenantstrikeType
			WHERE strikeCount = 1 AND BackupType =  1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, ISNULL(SUM(strikes),0), 0,0,0,0,0,0,0,0,0,0 from @TenantstrikeType
			WHERE strikeCount = 2 AND BackupType =  1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, ISNULL(SUM(strikes),0),0,0,0,0,0,0,0,0,0 from @TenantstrikeType
			WHERE strikeCount = 3 AND BackupType =  1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, ISNULL(SUM(scCount),0),0,0,0,0,0,0,0,0 from @TenantscStrikes
			WHERE strikeCount = 1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, ISNULL(SUM(scCount),0),0,0,0,0,0,0,0 from @TenantscStrikes
			WHERE strikeCount = 2
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, ISNULL(SUM(scCount),0),0,0,0,0,0,0 from @TenantscStrikes
			WHERE strikeCount = 3
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, ISNULL(SUM(clCount),0),0,0,0,0,0 from @TenantclStrikes
			WHERE strikeCount = 1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, 0, ISNULL(SUM(clCount),0),0,0,0,0 from @TenantclStrikes
			WHERE strikeCount = 2
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, 0, 0, ISNULL(SUM(clCount),0),0,0,0 from @TenantclStrikes
			WHERE strikeCount = 3
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, 0, 0, 0, ISNULL(SUM(vmCount),0),0,0 from @TenantvmStrikes
			WHERE strikeCount = 1
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ISNULL(SUM(vmCount),0),0 from @TenantvmStrikes
			WHERE strikeCount = 2
			GROUP BY CommServUniqueId, TenantName
			UNION
			select CommServUniqueId, TenantName, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ISNULL(SUM(vmCount),0) from @TenantvmStrikes
			WHERE strikeCount = 3
			GROUP BY CommServUniqueId, TenantName ) F
		GROUP BY CommServUniqueId, TenantName
		SELECT
				resultView.CommServUniqueId  AS 'CommServ UniqueId',
				resultView.CommCellID AS 'CommCell ID',
				resultView.DisplayName AS 'CommCell Name',
				csInfo.TenantName AS 'Company',
				resultView.DisplayName AS 'CommCell Alias Name<DONOTSHOW>',
				csInfo.TenantName AS 'Company Alias<DONOTSHOW>',
				ISNULL(Strike1Clients,0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(Strike1VMs,0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(Strike1SubClients,0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike1,0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(Strike2Clients,0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(Strike2VMs,0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(Strike2SubClients,0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike2,0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(Strike3Clients,0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(Strike3VMs,0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(Strike3SubClients,0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike3,0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM
				@TenantCommCellLevelStrike AS csInfo
				INNER JOIN #LatestResult AS resultView ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		UNION
		SELECT
				-10  AS 'CommServ UniqueId',
				-10 AS 'CommCell ID',
     			'All CommCells' AS 'CommCell Name',
				'All Companies' AS 'Company',
				' ' AS 'CommCell Alias Name<DONOTSHOW>',
				' ' AS 'Company Alias<DONOTSHOW>',
				ISNULL(SUM(ISNULL(Strike1Clients,0)),0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1VMs,0)),0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1SubClients,0)),0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike1,0)),0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2Clients,0)),0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2VMs,0)),0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2SubClients,0)),0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike2,0)),0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3Clients,0)),0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3VMs,0)),0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3SubClients,0)),0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
 				ISNULL(SUM(ISNULL(FullStrike3,0)),0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM
				@TenantCommCellLevelStrike AS csInfo
				INNER JOIN #LatestResult AS resultView ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		ORDER BY 'CommCell Alias Name<DONOTSHOW>'
	END
	ELSE
	IF  @isPrivate = 1 AND @i_AppGroupFlags > 0
	BEGIN
		INSERT	INTO #LatestResult
		SELECT	SurverResultId, CommServUniqueId, CommCellID, DisplayName
		FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
		IF object_id('tempdb.dbo.#CommCellStrikes') is not null DROP TABLE #CommCellStrikes
		CREATE TABLE #CommCellStrikes (CommServUniqueId INT, ClientId INT, AppId INT, BackupType NVARCHAR(25), IsVM INT, StrikeCount INT)
		INSERT INTO #CommCellStrikes
		SELECT  result.CommServUniqueId, csInfo.ClientId, csInfo.AppId, csInfo.BackupType, CASE WHEN SA.AppTypeId = 106 THEN 1 ELSE 0 END,
				CASE WHEN MAX(csInfo.StrikeCounts) >= 3 THEN 3 ELSE MAX(csInfo.StrikeCounts) END
		FROM    cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS result
				ON result.SurveyResultId = csInfo.SurveyResultId
				AND csInfo.StrikeCounts > 0
				AND csInfo.LastJobStartTime >= ISNULL(@i_LogDateStart, '01/01/1970')
 			INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK)
				ON SA.CommServUniqueId = result.CommServUniqueId AND csInfo.ClientId = SA.ClientId
				AND csInfo.AppId = SA.AppId AND SA.AppTypeId <> 106 AND SA.Deleted = 0
			INNER JOIN @AppTypeTbl AT ON SA.appTypeId = AT.appTypeId
		GROUP BY result.CommServUniqueId, csInfo.ClientId, csInfo.AppId, csInfo.BackupType, SA.AppTypeId
		CREATE INDEX CommCellStrikes_CommServUniqueId_StrikeCount_IsVM_idx ON #CommCellStrikes (CommServUniqueId, StrikeCount, IsVM)
		IF object_id('tempdb.dbo.#CommCellStrikeSummary') is not null DROP TABLE #CommCellStrikeSummary
		CREATE TABLE #CommcellStrikeSummary (CommServUniqueId INT,
				Strike1Servers INT, Strike1VMs INT, Strike1Subclients INT, FullStrike1 INT,
				Strike2Servers INT, Strike2VMs INT, Strike2Subclients INT, FullStrike2 INT,
				Strike3Servers INT, Strike3VMs INT, Strike3Subclients INT, FullStrike3 INT)
		INSERT	INTO #CommcellStrikeSummary
		SELECT	S.CommServUniqueId,
				SUM(ISNULL((CASE WHEN StrikeCount = 1 AND IsVM = 0 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 1 AND IsVM = 1 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 1 THEN StrikeSubclients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 1 THEN FullStrikeSubclients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 2 AND IsVM = 0 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 2 AND IsVM = 1 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 2 THEN StrikeSubclients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 2 THEN FullStrikeSubclients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 3 AND IsVM = 0 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 3 AND IsVM = 1 THEN StrikeClients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 3 THEN StrikeSubclients ELSE 0 END), 0)),
				SUM(ISNULL((CASE WHEN StrikeCount = 3 THEN FullStrikeSubclients ELSE 0 END), 0))
		FROM	(SELECT	CommServUniqueId, StrikeCount, IsVM,
						COUNT(DISTINCT clientId) AS StrikeClients,
						COUNT(appId) AS StrikeSubclients,
						SUM(CASE WHEN BackupType = 'Full' THEN 1 ELSE 0 END) AS FullStrikeSubclients
				FROM	#CommCellStrikes
				GROUP BY CommServUniqueId, StrikeCount, IsVM) S
		GROUP BY S.CommServUniqueId
		SELECT	R.CommServUniqueId  AS 'CommServ UniqueId',
				R.CommCellID AS 'CommCell ID',
				R.DisplayName AS 'CommCell Name',
				R.DisplayName AS 'CommCell Alias Name<DONOTSHOW>',
				ISNULL(Strike1Servers,0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(Strike1VMs,0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(Strike1SubClients,0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike1,0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(Strike2Servers,0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(Strike2VMs,0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(Strike2SubClients,0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike2,0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(Strike3Servers,0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(Strike3VMs,0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(Strike3SubClients,0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike3,0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM	#LatestResult R
				LEFT OUTER JOIN #CommcellStrikeSummary S ON R.CommServUniqueId = S.CommServUniqueId
		UNION
		SELECT	-10  AS 'CommServ UniqueId',
				-10 AS 'CommCell ID',
 				'All CommCells' AS 'CommCell Name',
 				' ' AS 'CommCell Alias Name<DONOTSHOW>',
				ISNULL(SUM(ISNULL(Strike1Servers,0)),0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1VMs,0)),0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1SubClients,0)),0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike1,0)),0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2Servers,0)),0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2VMs,0)),0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2SubClients,0)),0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike2,0)),0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3Servers,0)),0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3VMs,0)),0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3SubClients,0)),0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike3,0)),0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM	#LatestResult R
				LEFT OUTER JOIN #CommcellStrikeSummary S ON R.CommServUniqueId = S.CommServUniqueId
		ORDER BY  'CommCell Alias Name<DONOTSHOW>'
	END
	ELSE
	BEGIN
		SET @i_QueryId  = 146
		INSERT	INTO #LatestResult
		SELECT	SurverResultId, CommServUniqueId, CommCellID, DisplayName
		FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
		SELECT
				resultView.CommServUniqueId  AS 'CommServ UniqueId',
				resultView.CommCellID AS 'CommCell ID',
				resultView.DisplayName AS 'CommCell Name',
				resultView.DisplayName AS 'CommCell Alias Name<DONOTSHOW>',
				ISNULL(Strike1Clients,0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(Strike1VMs,0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(Strike1SubClients,0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike1,0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(Strike2Clients,0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(Strike2VMs,0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(Strike2SubClients,0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike2,0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(Strike3Clients,0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(Strike3VMs,0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(Strike3SubClients,0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
				ISNULL(FullStrike3,0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM
				cf_CommcellSummary AS csInfo WITH (NOLOCK)
				INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
		UNION
		SELECT
				-10  AS 'CommServ UniqueId',
				-10 AS 'CommCell ID',
     			'All CommCells' AS 'CommCell Name',
     			' ' AS 'CommCell Alias Name<DONOTSHOW>',
				ISNULL(SUM(ISNULL(Strike1Clients,0)),0) AS 'Strike1 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1VMs,0)),0) AS 'Strike1 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike1SubClients,0)),0) AS 'Strike1 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike1,0)),0) AS 'Strike1 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2Clients,0)),0) AS 'Strike2 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2VMs,0)),0) AS 'Strike2 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike2SubClients,0)),0) AS 'Strike2 Subclients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(FullStrike2,0)),0) AS 'Strike2 Full<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3Clients,0)),0) AS 'Strike3 Clients<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3VMs,0)),0) AS 'Strike3 VMs<FORMATNUMBERNA>',
				ISNULL(SUM(ISNULL(Strike3SubClients,0)),0) AS 'Strike3 Subclients<FORMATNUMBERNA>',
 				ISNULL(SUM(ISNULL(FullStrike3,0)),0) AS 'Strike3 Full<FORMATNUMBERNA>'
		FROM
				cf_CommcellSummary AS csInfo WITH (NOLOCK)
				INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
		ORDER BY 'CommCell Alias Name<DONOTSHOW>'
    END
	RETURN
END
ELSE
BEGIN
	CREATE TABLE #ClientGroupsString (CommservUniqueId INT, ClientId INT, ClientGroups NVARCHAR(MAX))
	EXEC GetClientGroupsString @i_CommServUniqueID
	IF @isPrivate = 1
	BEGIN
	SELECT
		resultView.DisplayName AS 'CommCell Name<HIDDEN>',
		CASE WHEN csInfo.StrikeCounts > 3 THEN 3 ELSE csInfo.StrikeCounts END  AS 'Strikes<strikeCount>',
		resultView.CommServUniqueId AS 'CommServ UniqueId<HIDDEN>',
		CL.ClientId AS 'ClientId<DONOTSHOW>',
		ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client<activityJobDetails>',
		ISNULL(CL.PhysicalClientName, CL.ClientName) AS 'PhysicalClientName<HIDDEN>',
		ISNULL(CGS.ClientGroups, '') AS 'Client Group',
		SA.AppTypeId AS 'AppTypeId<DONOTSHOW>',
		SA.AgentName + CASE WHEN SA.AppTypeId = 106 AND SA.ClientName <> CL.ClientName THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
		SA.InstanceId AS 'InstanceId<DONOTSHOW>',
		SA.InstanceName AS 'Instance<HIDDEN>',
		SA.BackupsetId AS 'BackupsetId<DONOTSHOW>',
		SA.BackupsetName AS 'Backupset',
		SA.AppId AS 'AppId<DONOTSHOW>',
		SA.SubclientName AS 'Subclient',
		csInfo.BackupType AS 'Backup Type',
		CASE WHEN csInfo.LastJobStartTime IS NULL THEN -6
			ELSE datediff(second, '01/01/1970', csInfo.FailedFrom)
			END AS 'Strikes Since<MMMDDYYYY>',
		CASE WHEN csInfo.LastJobStartTime IS NULL THEN -50
			ELSE datediff(second, '01/01/1970', csInfo.LastJobStartTime)
			END AS 'Last Failure Time<MMMDDYYYY>',
		CASE
			WHEN RIGHT(RTRIM(csInfo.FailureMsgIds),1) = ';' then SUBSTRING(RTRIM(csInfo.FailureMsgIds ),1,LEN(RTRIM(csInfo.FailureMsgIds ))-1)
			ELSE csInfo.FailureMsgIds END
		AS 'Error Code<HIDDEN>',
		REPLACE(csInfo.FailureReason, ';', '\n\n') AS 'Last Job Failure Reason',
		CASE WHEN csInfo.FailedJobIds IS NOT NULL THEN csInfo.FailedJobIds ELSE CAST(csInfo.LastJobId AS VARCHAR(64)) END AS 'Last Failed Job Id',
		csInfo.LastJobStatus AS 'Last Job Status<HIDDEN>',
		CS.TotalClientsCount AS 'Total Client Counts<HIDDEN>',
		CS.TotalVMsCount AS 'Total VM Counts<HIDDEN>',
		CS.TotalSubclientCounts AS 'Total Subclient Counts<HIDDEN>'
		,case when csInfo.LastSJobId IS NULL or csInfo.LastSJobId =0 THEN -1 else csInfo.LastSJobId end  AS 'Last Successful Job Id<HIDDEN><NumberNA>'
		,CASE WHEN csInfo.lastSJobEndTime IS NULL THEN -50
			ELSE datediff(second, '01/01/1970', csInfo.lastSJobEndTime)
			END AS 'Last Successful Job End Time<MMMDDYYYY><HIDDEN>',
		CASE WHEN ISNULL(CS.StrikeDays,0) <= 0 THEN -50 ELSE CS.StrikeDays END AS 'Exclude Strikes Before<MMMDDYYYY><HIDDEN>'
	FROM cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.StrikeCounts >= 0
		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON resultView.CommServUniqueId = SA.CommServUniqueId AND csInfo.AppId = SA.AppId AND SA.Deleted = 0
		LEFT OUTER JOIN @AppTypeTbl AT ON SA.appTypeId = AT.appTypeId
		LEFT OUTER JOIN cf_SurveyClient CL WITH (NOLOCK) ON resultView.CommServUniqueId = CL.CommServUniqueId AND csInfo.ClientId = CL.ClientId AND CL.Deleted = 0
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON CL.CommServUniqueId = TC.CommServUniqueId AND CL.ClientId = TC.ClientId
		LEFT OUTER JOIN #ClientGroupsString CGS ON resultView.CommServUniqueId = CGS.CommServUniqueId AND csInfo.ClientId = CGS.ClientId
		INNER JOIN (
			SELECT	resultView.CommServUniqueId,
					(Strike1Clients+Strike2Clients+Strike3Clients) TotalClientsCount,
					(Strike1VMs+Strike2VMs+Strike3VMs) TotalVMsCount,
					(Strike1SubClients+Strike2SubClients+Strike3SubClients) TotalSubclientCounts,
					ISNULL(StrikeDays, -1) StrikeDays
			FROM	cf_CommcellSummary AS csInfo WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
			) CS ON CS.CommServUniqueId = resultView.CommServUniqueId
	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND (@i_BackupType = '' OR csInfo.BackupType = @i_BackupType)
		AND (@i_LogDateStart IS NULL OR datediff(second, '01/01/1970', csInfo.LastJobStartTime) >= @i_LogDateStart)
		AND (@i_AppGroupFlags = 0 OR AT.appTypeId IS NOT NULL)
	ORDER BY CASE WHEN csInfo.StrikeCounts > 3 THEN 3 ELSE csInfo.StrikeCounts END DESC
	END
	ELSE
	BEGIN
	SELECT
		resultView.DisplayName AS 'CommCell Name<HIDDEN>',
		CASE WHEN csInfo.StrikeCounts > 3 THEN 3 ELSE csInfo.StrikeCounts END  AS 'Strikes<strikeCount>',
		resultView.CommServUniqueId AS 'CommServ UniqueId<HIDDEN>',
		CL.ClientId AS 'ClientId<DONOTSHOW>',
		ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client',
		ISNULL(CL.PhysicalClientName, CL.ClientName) AS 'PhysicalClientName<HIDDEN>',
		ISNULL(CGS.ClientGroups, '') AS 'Client Group',
		SA.AppTypeId AS 'AppTypeId<DONOTSHOW>',
		SA.AgentName + CASE WHEN SA.AppTypeId = 106 AND SA.ClientName <> CL.ClientName THEN ' in ' + SA.ClientName ELSE '' END AS 'Agent',
		SA.InstanceId AS 'InstanceId<DONOTSHOW>',
		SA.InstanceName AS 'Instance<HIDDEN>',
		SA.BackupsetId AS 'BackupsetId<DONOTSHOW>',
		SA.BackupsetName AS 'Backupset',
		SA.AppId AS 'AppId<DONOTSHOW>',
		SA.SubclientName AS 'Subclient',
		csInfo.BackupType AS 'Backup Type',
		CASE WHEN csInfo.LastJobStartTime IS NULL THEN -6
			ELSE datediff(second, '01/01/1970', csInfo.FailedFrom)
			END AS 'Strikes Since<MMMDDYYYY>',
		CASE WHEN csInfo.LastJobStartTime IS NULL THEN -50
			ELSE datediff(second, '01/01/1970', csInfo.LastJobStartTime)
			END AS 'Last Failure Time<MMMDDYYYY>',
		CASE
			WHEN RIGHT(RTRIM(csInfo.FailureMsgIds),1) = ';' then SUBSTRING(RTRIM(csInfo.FailureMsgIds ),1,LEN(RTRIM(csInfo.FailureMsgIds ))-1)
			ELSE csInfo.FailureMsgIds END
		AS 'Error Code<HIDDEN>',
		REPLACE(csInfo.FailureReason, ';', '\n\n') AS 'Last Job Failure Reason',
		CASE WHEN csInfo.FailedJobIds IS NOT NULL THEN csInfo.FailedJobIds ELSE CAST(csInfo.LastJobId AS VARCHAR(64)) END AS 'Last Failed Job Id',
		csInfo.LastJobStatus AS 'Last Job Status<HIDDEN>',
		CS.TotalClientsCount AS 'Total Client Counts<HIDDEN>',
		CS.TotalVMsCount AS 'Total VM Counts<HIDDEN>',
		CS.TotalSubclientCounts AS 'Total Subclient Counts<HIDDEN>'
		,case when csInfo.LastSJobId IS NULL or csInfo.LastSJobId =0 THEN -1 else csInfo.LastSJobId end  AS 'Last Successful Job Id<HIDDEN><NumberNA>'
		,CASE WHEN csInfo.lastSJobEndTime IS NULL THEN -50
			ELSE datediff(second, '01/01/1970', csInfo.lastSJobEndTime)
			END AS 'Last Successful Job End Time<MMMDDYYYY><HIDDEN>',
		CASE WHEN ISNULL(CS.StrikeDays,0) <= 0 THEN -50 ELSE CS.StrikeDays END AS 'Exclude Strikes Before<MMMDDYYYY><HIDDEN>'
	FROM cf_SurveyStrikeDetails AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND csInfo.StrikeCounts >= 0
		INNER JOIN cf_SurveySubclientAssociation SA WITH (NOLOCK) ON resultView.CommServUniqueId = SA.CommServUniqueId AND csInfo.AppId = SA.AppId AND SA.Deleted = 0
		LEFT OUTER JOIN @AppTypeTbl AT ON SA.appTypeId = AT.appTypeId
		LEFT OUTER JOIN cf_SurveyClient CL WITH (NOLOCK) ON resultView.CommServUniqueId = CL.CommServUniqueId AND csInfo.ClientId = CL.ClientId AND CL.Deleted = 0
		LEFT OUTER JOIN #TenantClients TC WITH (NOLOCK)
                     ON CL.CommServUniqueId = TC.CommServUniqueId AND CL.ClientId = TC.ClientId
		LEFT OUTER JOIN #ClientGroupsString CGS ON resultView.CommServUniqueId = CGS.CommServUniqueId AND csInfo.ClientId = CGS.ClientId
		INNER JOIN (
			SELECT	resultView.CommServUniqueId,
					(Strike1Clients+Strike2Clients+Strike3Clients) TotalClientsCount,
					(Strike1VMs+Strike2VMs+Strike3VMs) TotalVMsCount,
					(Strike1SubClients+Strike2SubClients+Strike3SubClients) TotalSubclientCounts,
					ISNULL(StrikeDays, -1) StrikeDays
			FROM	cf_CommcellSummary AS csInfo WITH (NOLOCK)
					INNER JOIN dbo.cf_SurveyResultFuncV1(146, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.SurverResultId = csInfo.SurveyResultId
			) CS ON CS.CommServUniqueId = resultView.CommServUniqueId
	WHERE ((@i_TenantName is NOT NULL AND TC.TenantName is NOT NULL) OR @i_TenantName is NULL) AND (@i_BackupType = '' OR csInfo.BackupType = @i_BackupType)
		AND (@i_LogDateStart IS NULL OR datediff(second, '01/01/1970', csInfo.LastJobStartTime) >= @i_LogDateStart)
		AND (@i_AppGroupFlags = 0 OR AT.appTypeId IS NOT NULL)
	ORDER BY CASE WHEN csInfo.StrikeCounts > 3 THEN 3 ELSE csInfo.StrikeCounts END DESC
	END
	DROP TABLE #ClientGroupsString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptFailingClients')
	delete from GxQscripts where name = 'RptFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptFailingClients')
	delete from GXDBVersions where aliasname = 'RptFailingClients'
GO

insert into GXDBVersions values(2, 'RptFailingClients',  '00010019000200370000', 'RptFailingClients', '00010019000200370000')
GO

