

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDataGrowthTrend.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDataGrowthTrend.sp,v $ $Id: RptDataGrowthTrend.sp,v 1.6.2.29 2020/12/17 02:52:14 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptDataGrowthTrend')
BEGIN
	print '>>> Drop Stored Procedure: RptDataGrowthTrend <<<'
	drop procedure RptDataGrowthTrend
END
IF EXISTS (select * from GxQscripts where name='RptDataGrowthTrend')
	delete from GxQscripts where name = 'RptDataGrowthTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDataGrowthTrend')
	delete from GXDBVersions where aliasname = 'RptDataGrowthTrend'
GO
print '... Creating Procedure: RptDataGrowthTrend'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptDataGrowthTrend
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_IsGraph INT = 0,
  @i_TopN INT = -1,
  @i_CommServUniqueID INT = 0,
  @i_EntityType VARCHAR(64) = 'Agent Type', 
-- 'Agent Type' or 'Client Group' or 'CommCell' or 'Disk Library' or 'Cloud Library' or 'Tape Library'
-- or 'Capacity License Usage' or 'Capacity License Usage by Application' or 'Capacity Usage by License'
  @i_EntityName NVARCHAR(256) = NULL, -- NULL for trending chart of total
  @i_GrowthType INT = 0, -- 0 for Media Size, 1 for App Size, 2 for Backup Capacity Usage, 3 for Archive Capacity Usage
  @i_Aggregate INT = 0  -- 1 for Total Aggregate, 3 for drilldown from Agent
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @isPrivate	INT = 0
SELECT  @isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig (NOLOCK) WHERE Name = 'isPrivate'
DECLARE	@now INT = dbo.GetUnixTimeBig(GETDATE())
DECLARE	@LSQuotaType INT = (CASE @i_GrowthType WHEN 2 THEN 100002 ELSE 100004 END)
DECLARE	@QuotaLimitMB BIGINT = NULL
DECLARE @i_QueryId INT = 129 -- Agent Type and CommCell
IF  @i_EntityType IN ('Disk Library', 'Cloud Library')
	SET @i_QueryId = 96
ELSE
IF  @i_EntityType = 'Tape Library'
	SET @i_QueryId = 186
ELSE
IF  @i_EntityType = 'Capacity License Usage'
	SET @i_QueryId = 1
ELSE
IF  @i_EntityType IN ('Capacity License Usage by Application', 'Capacity Usage by License')
	SET @i_QueryId = 3
DECLARE @showHiddenLibraries INT = 0
IF EXISTS (SELECT TOP 1 1 FROM cf_SurveyConfig WHERE name = 'showHiddenLibraries' AND value = '1')
	SET @showHiddenLibraries = 1
CREATE TABLE #MonthTbl (MonthStart DATE)
DECLARE @FirstMonth DATE
DECLARE @CurrMonth DATE = DATEADD(MONTH, DATEDIFF(MONTH, 0, GETDATE()), 0)
DECLARE @PrevMonth DATE = DATEADD(MONTH, -1, @CurrMonth)
DECLARE @Pre2Month DATE = DATEADD(MONTH, -2, @CurrMonth)
DECLARE	@i INT = 0
DECLARE	@MaxNumOfMonthsforGrowthRate INT = 6
WHILE @i <= 12
BEGIN
	INSERT	INTO #MonthTbl
	SELECT	DATEADD(MONTH, -@i, @CurrMonth)
	SET @i += 1
END
SET @FirstMonth = (SELECT MIN(MonthStart) FROM #MonthTbl)
CREATE TABLE #Results (ResultId BIGINT, CommservUniqueId INT, CommCellID VARCHAR(32), CommServName NVARCHAR(288), MonthStart DATE)
INSERT	INTO #Results
SELECT	SurverResultId, CommservUniqueId, CommCellID,
		DisplayName + CASE WHEN @i_CommServUniqueID > 0 THEN '' WHEN CommCellID = -1 THEN ' - FFFFFFFF' ELSE ' - ' + dbo.ConvertBigIntToHexStr(CommCellID) END,
		DATEADD(MONTH, DATEDIFF(MONTH, 0, LogDate), 0)
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
DELETE #Results WHERE MonthStart < @FirstMonth
CREATE TABLE #MountPathResults (SurveyResultId BIGINT, CommServUniqueId INT)
CREATE TABLE #LicenseServerChild (CommServUniqueId INT)
CREATE TABLE #EntitySize (
		CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(300), MonthStart DATE, AppSizeMB BIGINT, MediaSizeMB BIGINT, UpperLimitMB BIGINT)
CREATE TABLE #Summary (
		CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(300), LastMonth DATE, AppSizeMB BIGINT, MediaSizeMB BIGINT, UpperLimitMB BIGINT,
		PrevMonthSizeMB BIGINT, Pre2MonthSizeMB BIGINT, MonthlyGrowthMB BIGINT, Size6Month BIGINT, Size12Month BIGINT, Size18Month BIGINT, IsTotal INT)
CREATE TABLE #EntityLastMonth (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(300), MonthStart DATE)
IF	@i_EntityType = 'Capacity License Usage'
BEGIN
 	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, R.CommservUniqueId, R.CommServName, U.MonthStart, ISNULL(ArchiveSize, 0), ISNULL(BackupSize, 0), -1
	FROM	cf_SurveyCapacityLicensePeakUsage U
			INNER JOIN #Results R ON U.CommservUniqueId = R.CommservUniqueId AND U.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = R.CommServName
	INSERT INTO #EntityLastMonth
	SELECT CommservUniqueId, CommservUniqueId, EntityName, MAX(MonthStart) FROM #EntitySize GROUP BY CommservUniqueId, EntityName
	INSERT	INTO #EntitySize
	SELECT	S.CommservUniqueId, S.CommservUniqueId, S.EntityName, L.LastMonthStart, -1, -1, -1
	FROM	#EntityLastMonth S
			INNER JOIN (SELECT MAX(MonthStart) AS LastMonthStart FROM #EntitySize) L ON S.MonthStart < L.LastMonthStart
	WHERE	S.MonthStart < (SELECT MAX(MonthStart) FROM #EntitySize)
	UPDATE	#EntitySize SET UpperLimitMB = (CASE @i_GrowthType WHEN 2 THEN ISNULL(L.TotalBackupSize, 0) ELSE ISNULL(L.TotalArchiveSize, 0) END)
	FROM	#EntitySize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
			INNER JOIN cf_SurveyCapacityLicenseUsage L ON L.SurveyResultId = R.ResultId
	WHERE	(CASE @i_GrowthType WHEN 2 THEN ISNULL(L.TotalBackupSize, 0) ELSE ISNULL(L.TotalArchiveSize, 0) END) >= 0
END
ELSE
IF	@i_EntityType = 'Capacity License Usage by Application'
BEGIN
 	INSERT	INTO #EntitySize
	SELECT	CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END, 0,
			CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName WHEN U.TypeId = 38 THEN U.TypeName ELSE A.shortName END,
			U.MonthStart, SUM(ISNULL(ArchiveSize, 0))/1024/1024, SUM(ISNULL(BackupSize, 0))/1024/1024, -1
	FROM	cf_SurveyAgentCapacityPeakUsage U
			INNER JOIN cf_SurveyAgentType A WITH (NOLOCK) ON U.TypeId = A.id AND U.TypeId > 0
			INNER JOIN #Results R ON U.CommservUniqueId = R.CommservUniqueId AND U.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = ''
		 OR @i_EntityName = (CASE WHEN U.TypeId = 38 THEN U.TypeName ELSE A.shortName END)
	GROUP BY (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END),
			 (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName WHEN U.TypeId = 38 THEN U.TypeName ELSE A.shortName END), U.MonthStart
END
ELSE
IF	@i_EntityType = 'Capacity Usage by License'
BEGIN
 	INSERT	INTO #EntitySize
	SELECT	CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END, 0, CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName ELSE L.name END,
			PU.MonthStart, SUM(ISNULL(PU.ArchiveSize, 0))/1024/1024, SUM(ISNULL(PU.BackupSize, 0))/1024/1024, -1
	FROM	cf_SurveyAgentCapacityPeakUsage PU
			INNER JOIN #Results R ON PU.CommservUniqueId = R.CommservUniqueId AND PU.MonthStart >= @FirstMonth
			INNER JOIN cf_SurveyAgentCapacityUsage U ON U.SurveyResultId = R.ResultId AND U.TypeId = PU.TypeId AND U.LicType = PU.LicType
			INNER JOIN cf_SurveyLicType L WITH (NOLOCK) ON U.LicType = L.id
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = L.name
	GROUP BY (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END), (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName ELSE L.name END), PU.MonthStart
END
ELSE
IF	@i_EntityType = 'Disk Library'
BEGIN
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, L.LibraryId, L.LibraryName, S.MonthStart, SUM(ISNULL(FreeSpaceMB, -1)), SUM(ISNULL(UsedSpaceMB, -1)), -1
	FROM	cf_SurveyDiskLibraryPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
			INNER JOIN cf_Survey96DiskLibDetails D ON D.SurveyResultId = R.ResultId AND D.LibraryId = S.LibraryId
			INNER JOIN cf_SurveyLibrary L ON S.CommservUniqueId = L.CommservUniqueId AND S.LibraryId = L.LibraryId AND L.LibraryTypeId = 3 AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
	GROUP BY R.CommservUniqueId, L.LibraryId, L.LibraryName, S.MonthStart
	INSERT INTO #EntityLastMonth
	SELECT CommservUniqueId, EntityId, EntityName, MAX(MonthStart) FROM #EntitySize GROUP BY CommservUniqueId, EntityId, EntityName
	INSERT	INTO #EntitySize
	SELECT	S.CommservUniqueId, S.EntityId, S.EntityName, L.LastMonthStart, -1, -1, -1
	FROM	#EntityLastMonth S
			INNER JOIN (SELECT MAX(MonthStart) AS LastMonthStart FROM #EntitySize) L ON S.MonthStart < L.LastMonthStart
	WHERE	S.MonthStart < (SELECT MAX(MonthStart) FROM #EntitySize)
	UPDATE	#EntitySize SET UpperLimitMB = totalSpaceGB*1024
	FROM	#EntitySize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
			INNER JOIN cf_Survey96DiskLibDetails L ON L.SurveyResultId = R.ResultId AND L.LibraryId = S.EntityId
	WHERE	ISNULL(totalSpaceGB, -1) >= 0
	IF  @i_CommServUniqueID = 0
		UPDATE	#EntitySize SET EntityName += (' - ' + CASE WHEN CommCellID = -1 THEN 'FFFFFFFF' ELSE dbo.ConvertBigIntToHexStr(CommCellID) END)
		FROM	#EntitySize S
				INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
	IF  ISNULL(@i_EntityName, '') <> ''
		DELETE #EntitySize WHERE EntityName <> @i_EntityName
	IF	@i_IsGraph = 0
		INSERT	INTO #MountPathResults
		SELECT	SurverResultId, CommservUniqueId
		FROM	dbo.cf_SurveyResultFuncV1(117, @i_CommServUniqueID, 1, NULL, NULL, @i_UserId, @i_GroupId)
END
ELSE
IF	@i_EntityType = 'Cloud Library'
BEGIN
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, L.LibraryId, L.LibraryName, S.MonthStart, SUM(ISNULL(AppSizeMB, -1)), SUM(ISNULL(DataWrittenMB, -1)), -1
	FROM	cf_SurveyDiskLibraryPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
			INNER JOIN cf_Survey96DiskLibDetails D ON D.SurveyResultId = R.ResultId AND D.LibraryId = S.LibraryId
			INNER JOIN cf_SurveyLibrary L ON S.CommservUniqueId = L.CommservUniqueId AND S.LibraryId = L.LibraryId AND L.LibraryTypeId = -3  AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
	GROUP BY R.CommservUniqueId, L.LibraryId, L.LibraryName, S.MonthStart
	INSERT INTO #EntityLastMonth
	SELECT CommservUniqueId, EntityId, EntityName, MAX(MonthStart) FROM #EntitySize GROUP BY CommservUniqueId, EntityId, EntityName
	INSERT	INTO #EntitySize
	SELECT	S.CommservUniqueId, S.EntityId, S.EntityName, L.LastMonthStart, -1, -1, -1
	FROM	#EntityLastMonth S
			INNER JOIN (SELECT MAX(MonthStart) AS LastMonthStart FROM #EntitySize) L ON S.MonthStart < L.LastMonthStart
	WHERE	S.MonthStart < (SELECT MAX(MonthStart) FROM #EntitySize)
	UPDATE	#EntitySize SET UpperLimitMB = totalSpaceGB*1024
	FROM	#EntitySize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
			INNER JOIN cf_Survey96DiskLibDetails L ON L.SurveyResultId = R.ResultId AND L.LibraryId = S.EntityId
	WHERE	ISNULL(totalSpaceGB, -1) >= 0
	IF  @i_CommServUniqueID = 0
		UPDATE	#EntitySize SET EntityName += (' - ' + CASE WHEN CommCellID = -1 THEN 'FFFFFFFF' ELSE dbo.ConvertBigIntToHexStr(CommCellID) END)
		FROM	#EntitySize S
				INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
	IF  ISNULL(@i_EntityName, '') <> ''
		DELETE #EntitySize WHERE EntityName <> @i_EntityName
END
ELSE
IF	@i_EntityType = 'Tape Library'
BEGIN
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, L.LibraryId, L.LibraryName, S.MonthStart, S.SpareTapeCount, S.UsedTapeCount, U.UsedTapeCount + U.SpareTapeCount
	FROM	cf_SurveyMonthlyTapeUsageByLibrary S
			INNER JOIN cf_SurveyLibrary L ON S.CommservUniqueId = L.CommservUniqueId AND S.LibraryId = L.LibraryId AND L.Deleted = 0  AND (@showHiddenLibraries = 1 OR L.Hidden = 0)
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
			INNER JOIN cf_SurveyTapeUsageByLibrary U ON U.SurveyResultId = R.ResultId AND U.LibraryId = S.LibraryId
	INSERT INTO #EntityLastMonth
	SELECT CommservUniqueId, EntityId, EntityName, MAX(MonthStart) FROM #EntitySize GROUP BY CommservUniqueId, EntityId, EntityName
	INSERT	INTO #EntitySize
	SELECT	S.CommservUniqueId, S.EntityId, S.EntityName, L.LastMonthStart, -1, -1, -1
	FROM	#EntityLastMonth S
			INNER JOIN (SELECT MAX(MonthStart) AS LastMonthStart FROM #EntitySize) L ON S.MonthStart < L.LastMonthStart
	WHERE	S.MonthStart < (SELECT MAX(MonthStart) FROM #EntitySize)
	IF  @i_CommServUniqueID = 0
		UPDATE	#EntitySize SET EntityName += (' - ' + CASE WHEN CommCellID = -1 THEN 'FFFFFFFF' ELSE dbo.ConvertBigIntToHexStr(CommCellID) END)
		FROM	#EntitySize S
				INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId
	IF  ISNULL(@i_EntityName, '') <> ''
		DELETE #EntitySize WHERE EntityName <> @i_EntityName
END
ELSE
IF	@i_EntityType = 'Agent Type'
	INSERT	INTO #EntitySize
	SELECT	CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END, 0,
			CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName WHEN S.AppTypeId = 38 THEN S.AgentName ELSE A.shortName END,
			S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1
	FROM	cf_SurveyAgentPeakSize S
			INNER JOIN cf_SurveyAgentType A WITH (NOLOCK) ON S.AppTypeId = A.id
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth AND S.AppTypeId > 0
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = (CASE WHEN S.AppTypeId = 38 THEN S.AgentName ELSE A.shortName END)
	GROUP BY (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommservUniqueId ELSE 0 END),
			 (CASE WHEN ISNULL(@i_Aggregate, 0) = 3 THEN R.CommServName WHEN S.AppTypeId = 38 THEN S.AgentName ELSE A.shortName END), S.MonthStart
ELSE
IF  @i_EntityType = 'Client Group'
	INSERT	INTO #EntitySize
	SELECT	0, 0, CG.ClientGroupName, S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1
	FROM	cf_SurveyClientGroupPeakSize S
			INNER JOIN cf_SurveyClientGroup CG ON S.CommservUniqueId = CG.CommservUniqueId AND S.ClientGroupId = CG.ClientGroupId
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = CG.ClientGroupName
	GROUP BY CG.ClientGroupName, S.MonthStart
ELSE
IF  @i_EntityType = 'CommCell'
	INSERT	INTO #EntitySize
	SELECT	R.CommservUniqueId, R.CommservUniqueId, R.CommServName, S.MonthStart, SUM(AppSizeMB), SUM(SizeOnMediaMB), -1
	FROM	cf_SurveyAgentPeakSize S
			INNER JOIN #Results R ON S.CommservUniqueId = R.CommservUniqueId AND S.MonthStart >= @FirstMonth AND S.AppTypeId = 0
	WHERE	ISNULL(@i_EntityName, '') = '' OR @i_EntityName = R.CommServName
	GROUP BY R.CommservUniqueId, R.CommServName, S.MonthStart
INSERT	INTO #Summary
SELECT	T.CommservUniqueId, T.EntityId, T.EntityName, T.MonthStart, T.AppSizeMB, T.MediaSizeMB, T.UpperLimitMB, NULL, NULL, NULL, 0, 0, 0, 0
FROM	(SELECT	CommservUniqueId, EntityId, EntityName, MonthStart, AppSizeMB, MediaSizeMB, UpperLimitMB,
			ROW_NUMBER() OVER (PARTITION BY CommservUniqueId, EntityName ORDER BY MonthStart DESC) AS RowId
		FROM	#EntitySize
		WHERE	AppSizeMB > -1 AND MediaSizeMB > -1
		) T
WHERE	T.RowId = 1
IF @i_TopN > 0
BEGIN
	DELETE	#Summary
	FROM	#Summary S LEFT OUTER JOIN
			(SELECT TOP (@i_TopN) CommservUniqueId, EntityName
			FROM	#Summary
			ORDER BY (CASE WHEN @i_GrowthType IN (0,2) THEN MediaSizeMB ELSE AppSizeMB END) DESC
		) T ON S.CommservUniqueId = T.CommservUniqueId AND S.EntityName = T.EntityName
	WHERE	T.EntityName IS NULL
	DELETE	#EntitySize
	FROM	#EntitySize LEFT OUTER JOIN #Summary T
			ON #EntitySize.CommservUniqueId = T.CommservUniqueId AND #EntitySize.EntityName = T.EntityName
	WHERE	T.EntityName IS NULL
END
IF	@i_EntityType = 'Capacity License Usage'
	AND @isPrivate = 1 AND EXISTS (SELECT * FROM cf_SurveyClientGroupQuotaUsage WITH (NOLOCK) WHERE ClientGroupName = 'CommCell Inherited Capacity' AND QuotaEnabled = 7)
BEGIN
	SELECT	@QuotaLimitMB = (CASE WHEN QuotaLimitGB > 0 THEN QuotaLimitGB*1024 ELSE -1 END)
	FROM	cf_SurveyClientGroupQuotaUsage WITH (NOLOCK)
	WHERE	ClientGroupName = 'CommCell Inherited Capacity' AND QuotaEnabled = 7 AND QuotaType = @LSQuotaType
		AND (ExpiryTime = 0 OR ExpiryTime > @now)
	INSERT	INTO #LicenseServerChild
	SELECT	DISTINCT CommcellIdNameMap_ID
	FROM	cf_CommservSurveyResults
	WHERE	CommservSurveyResults_ID IN (
			SELECT	DISTINCT SurveyResultId
			FROM	cf_SurveyClientGroupQuotaUsage WITH (NOLOCK)
			WHERE	ClientGroupName = 'CommCell Inherited Capacity' AND QuotaEnabled&1 = 1)
	END
IF	@i_IsGraph = 1
BEGIN
	IF	@i_EntityType = 'Capacity License Usage'
	BEGIN
		IF	EXISTS (SELECT * FROM #LicenseServerChild)
		BEGIN
			UPDATE	E SET UpperLimitMB = 0
			FROM	#EntitySize E INNER JOIN #LicenseServerChild LS ON E.CommservUniqueId = LS.CommservUniqueId
			IF  @i_Aggregate <> 1
				UPDATE	TOP (1) #EntitySize SET UpperLimitMB = @QuotaLimitMB
				FROM	#EntitySize E INNER JOIN #LicenseServerChild LS ON E.CommservUniqueId = LS.CommservUniqueId
		END
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					SUM(CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END) AS 'Used Capacity<SIZEMB>',
					SUM(ISNULL(S.UpperLimitMB, -1)) + @QuotaLimitMB AS 'Purchased Capacity<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart
			GROUP BY M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>',
					ISNULL(S.UpperLimitMB, -1) AS 'Purchased Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT CommservUniqueId, EntityName, MAX(CASE @i_GrowthType WHEN 2 THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #Summary GROUP BY CommservUniqueId, EntityName) E
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart AND S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
	END
	ELSE
	IF	@i_EntityType IN ('Capacity License Usage by Application', 'Capacity Usage by License')
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					SUM(CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END) AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN #EntitySize S ON S.MonthStart = M.MonthStart
			GROUP BY M.MonthStart
			ORDER BY 'Month'
		ELSE
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'CommCell Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT EntityName, MAX(CASE @i_GrowthType WHEN 2 THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #Summary GROUP BY EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(AppSizeMB) AS AppSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'CommCell Name', 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(S.MediaSizeMB, -1) ELSE ISNULL(S.AppSizeMB, -1) END AS 'Used Capacity<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT EntityName, MAX(CASE @i_GrowthType WHEN 2 THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #Summary GROUP BY EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(AppSizeMB) AS AppSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
	END
	ELSE
	IF	@i_EntityType = 'Disk Library'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.MediaSizeMB, -1) AS 'Consumed Space<SIZEMB>',
					ISNULL(S.UpperLimitMB, -1) AS 'Total Space<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(MediaSizeMB) AS MediaSizeMB, SUM(UpperLimitMB) AS UpperLimitMB
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.MediaSizeMB, -1) AS 'Consumed Space<SIZEMB>',
					ISNULL(T.UpperLimitMB/T.nLibraries, -1) AS 'Total Space<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT CommservUniqueId, EntityName, MAX(MediaSizeMB) AS MaxSizeMB FROM #Summary GROUP BY CommservUniqueId, EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, CommservUniqueId, EntityName, SUM(MediaSizeMB) AS MediaSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, CommservUniqueId, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
					LEFT OUTER JOIN (
					SELECT	MonthStart, CommservUniqueId, MAX(UpperLimitMB) AS UpperLimitMB, COUNT(*) AS nLibraries
					FROM	#EntitySize
					GROUP BY MonthStart, CommservUniqueId
					) T ON T.MonthStart = M.MonthStart AND T.CommservUniqueId = E.CommservUniqueId
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
	END
	ELSE
	IF	@i_EntityType = 'Cloud Library'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.DataWrittenMB, -1) AS 'Data Written<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(MediaSizeMB) AS DataWrittenMB
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.DataWrittenMB, -1) AS 'Data Written<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT CommservUniqueId, EntityName, MAX(MediaSizeMB) AS MaxSizeMB FROM #Summary GROUP BY CommservUniqueId, EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, CommservUniqueId, EntityName, SUM(MediaSizeMB) AS DataWrittenMB
					FROM	#EntitySize
					GROUP BY MonthStart, CommservUniqueId, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
	END
	ELSE
	IF	@i_EntityType = 'Tape Library'
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.MediaSizeMB, -1) AS 'Used Tapes',
					ISNULL(S.UpperLimitMB, -1) AS 'Total Tapes'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(MediaSizeMB) AS MediaSizeMB, SUM(UpperLimitMB) AS UpperLimitMB
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.MediaSizeMB, -1) AS 'Used Tapes',
					ISNULL(S.UpperLimitMB, -1) AS 'Total Tapes'
			FROM	#MonthTbl M CROSS JOIN (SELECT CommservUniqueId, EntityName, MAX(MediaSizeMB) AS MaxSizeMB FROM #Summary GROUP BY CommservUniqueId, EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, CommservUniqueId, EntityName, SUM(MediaSizeMB) AS MediaSizeMB, SUM(UpperLimitMB) AS UpperLimitMB
					FROM	#EntitySize
					GROUP BY MonthStart, CommservUniqueId, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
	END
	ELSE
	IF  @i_EntityType IN ('Agent Type', 'Client Group', 'CommCell')
	BEGIN
		IF  @i_Aggregate = 1
			SELECT	M.MonthStart AS 'Month',
					ISNULL(S.AppSizeMB, -1) AS 'Protected App Size <SIZEMB>',
					ISNULL(S.MediaSizeMB, -1) AS 'Size on Media<SIZEMB>'
			FROM	#MonthTbl M
					LEFT OUTER JOIN (
					SELECT	MonthStart, SUM(AppSizeMB) AS AppSizeMB, SUM(MediaSizeMB) AS MediaSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart
					) S ON S.MonthStart = M.MonthStart
			ORDER BY 'Month'
		ELSE
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'CommCell Name',
					ISNULL(S.AppSizeMB, -1) AS 'Protected App Size <SIZEMB>',
					ISNULL(S.MediaSizeMB, -1) AS 'Size on Media<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT EntityName, MAX(CASE WHEN @i_GrowthType IN (0,2) THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #Summary GROUP BY EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(AppSizeMB) AS AppSizeMB, SUM(MediaSizeMB) AS MediaSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'CommCell Name', 'Month'
		ELSE
			SELECT	M.MonthStart AS 'Month',
					E.EntityName AS 'Entity Name',
					ISNULL(S.AppSizeMB, -1) AS 'Protected App Size <SIZEMB>',
					ISNULL(S.MediaSizeMB, -1) AS 'Size on Media<SIZEMB>'
			FROM	#MonthTbl M CROSS JOIN (SELECT EntityName, MAX(CASE WHEN @i_GrowthType IN (0,2) THEN MediaSizeMB ELSE AppSizeMB END) AS MaxSizeMB FROM #Summary GROUP BY EntityName) E
					LEFT OUTER JOIN (
					SELECT	MonthStart, EntityName, SUM(AppSizeMB) AS AppSizeMB, SUM(MediaSizeMB) AS MediaSizeMB
					FROM	#EntitySize
					GROUP BY MonthStart, EntityName
					) S ON S.MonthStart = M.MonthStart AND S.EntityName = E.EntityName
			ORDER BY MaxSizeMB DESC, 'Entity Name', 'Month'
		END
END
ELSE
--IF  @i_IsGraph = 0
BEGIN
	CREATE TABLE #GrowthData (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), X INT, Y FLOAT, SeqId INT) -- for input
	CREATE TABLE #GrowthRate (CommservUniqueId INT, EntityId INT, EntityName NVARCHAR(MAX), GrowthRate FLOAT, GrowthStDev FLOAT) -- for output
	INSERT INTO #GrowthData
	SELECT	CommservUniqueId, 0, EntityName, DATEDIFF(MONTH, @CurrMonth, MonthStart),
			CASE WHEN @i_GrowthType IN (1, 3) THEN AppSizeMB ELSE MediaSizeMB END,
			ROW_NUMBER() OVER (PARTITION BY CommservUniqueId, EntityName ORDER BY MonthStart)
	FROM	#EntitySize
	WHERE	(DATEDIFF(MONTH, MonthStart, @CurrMonth) BETWEEN 0 AND @MaxNumOfMonthsforGrowthRate)
		AND (CASE WHEN @i_GrowthType IN (1, 3) THEN AppSizeMB ELSE MediaSizeMB END) > 0
	EXEC GetLinearGrowthRate 0
	UPDATE	S SET MonthlyGrowthMB = T.GrowthRate
	FROM	#Summary S
			INNER JOIN #GrowthRate T ON S.CommservUniqueId = T.CommservUniqueId AND S.EntityName = T.EntityName
	DROP TABLE #GrowthData
	DROP TABLE #GrowthRate
	IF @i_GrowthType IN (1, 3)
		UPDATE	#Summary
		SET		Size6Month  = CASE WHEN (AppSizeMB + MonthlyGrowthMB*6) > 0 THEN AppSizeMB + MonthlyGrowthMB*6  ELSE 0 END,
				Size12Month = CASE WHEN (AppSizeMB + MonthlyGrowthMB*12)> 0 THEN AppSizeMB + MonthlyGrowthMB*12 ELSE 0 END,
				Size18Month = CASE WHEN (AppSizeMB + MonthlyGrowthMB*18)> 0 THEN AppSizeMB + MonthlyGrowthMB*18 ELSE 0 END
	ELSE
		UPDATE	#Summary
		SET		Size6Month  = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*6) > 0 THEN MediaSizeMB + MonthlyGrowthMB*6  ELSE 0 END,
				Size12Month = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*12)> 0 THEN MediaSizeMB + MonthlyGrowthMB*12 ELSE 0 END,
				Size18Month = CASE WHEN (MediaSizeMB + MonthlyGrowthMB*18)> 0 THEN MediaSizeMB + MonthlyGrowthMB*18 ELSE 0 END
	UPDATE	S SET PrevMonthSizeMB = CASE WHEN @i_GrowthType IN (1, 3) THEN E.AppSizeMB ELSE E.MediaSizeMB END
	FROM	#Summary S INNER JOIN #EntitySize E ON S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
		AND S.LastMonth = @CurrMonth AND E.MonthStart = @PrevMonth
	UPDATE	S SET Pre2MonthSizeMB = CASE WHEN @i_GrowthType IN (1, 3) THEN E.AppSizeMB ELSE E.MediaSizeMB END
	FROM	#Summary S INNER JOIN #EntitySize E ON S.CommservUniqueId = E.CommservUniqueId AND S.EntityName = E.EntityName
		AND S.PrevMonthSizeMB IS NOT NULL AND E.MonthStart = @Pre2Month
	-- Add a row for Total
	IF  @i_EntityType <> 'Client Group' AND EXISTS (SELECT * FROM #Summary)
	BEGIN
		IF	@i_EntityType = 'Capacity License Usage' AND EXISTS (SELECT * FROM #LicenseServerChild)
			INSERT	INTO #Summary
			SELECT	0, 0, 'Total', MAX(LastMonth), SUM(AppSizeMB), SUM(MediaSizeMB), @QuotaLimitMB + SUM(CASE WHEN LS.CommservUniqueId IS NULL THEN UpperLimitMB ELSE 0 END),
					SUM(ISNULL(PrevMonthSizeMB,0)), SUM(ISNULL(Pre2MonthSizeMB,0)), SUM(ISNULL(MonthlyGrowthMB,0)),
					SUM(Size6Month), SUM(Size12Month), SUM(Size18Month), 1
			FROM	#Summary S LEFT OUTER JOIN #LicenseServerChild LS ON S.CommservUniqueId = LS.CommservUniqueId
		ELSE
			INSERT	INTO #Summary
			SELECT	0, 0, 'Total', MAX(LastMonth), SUM(AppSizeMB), SUM(MediaSizeMB), SUM(UpperLimitMB),
					SUM(ISNULL(PrevMonthSizeMB,0)), SUM(ISNULL(Pre2MonthSizeMB,0)), SUM(ISNULL(MonthlyGrowthMB,0)),
					SUM(Size6Month), SUM(Size12Month), SUM(Size18Month), 1
		FROM	#Summary
	END
	IF	@i_EntityType = 'Capacity License Usage'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'CommCell',
				LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
				UpperLimitMB AS 'Purchased Capacity<LicenseSizeMB>',
				CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<LicenseSizeMB>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
				END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
					 ELSE (MediaSizeMB-PrevMonthSizeMB)
				END AS 'Current Month Change<DifferenceMB>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Current Month Change (%)<DifferenceNA>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<LicenseSizeMB><HIDDEN>',
				Size12Month AS 'Size After 12 Months<LicenseSizeMB><HIDDEN>',
				Size18Month AS 'Size After 18 Months<LicenseSizeMB><HIDDEN>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Purchase After 6 Months<LicenseSizeMB><HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 12 Months<LicenseSizeMB><HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 18 Months<LicenseSizeMB><HIDDEN>'
		FROM	#Summary
		ORDER BY IsTotal DESC, 'Used Capacity<LicenseSizeMB>' DESC, EntityName
	ELSE
	IF	@i_EntityType = 'Capacity License Usage by Application'
	BEGIN
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'CommCell Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Used Capacity<SIZEMB>' DESC, EntityName
		ELSE
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'Agent Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Used Capacity<SIZEMB>' DESC, EntityName
	END
	ELSE
	IF	@i_EntityType = 'Capacity Usage by License'
	BEGIN
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'CommCell Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Used Capacity<SIZEMB>' DESC, EntityName
		ELSE
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'License Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					CASE @i_GrowthType WHEN 2 THEN ISNULL(MediaSizeMB, 0) ELSE ISNULL(AppSizeMB, 0) END AS 'Used Capacity<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Used Capacity<SIZEMB>' DESC, EntityName
	END
	ELSE
	IF	@i_EntityType = 'Disk Library'
		SELECT	S.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(R.CommServName, '') AS 'CommCell Name',
				EntityName  AS 'Library Name',
				CASE SM.HardDriveShared WHEN -1 THEN 'N/A' WHEN 0 THEN 'No' ELSE 'Yes' END
							AS 'MountPath/HardDrive Shared<HIDDEN>',
				LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
				UpperLimitMB AS 'Total Space<SIZEMB>',
				MediaSizeMB AS 'Consumed Space<SIZEMB>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
				END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE (MediaSizeMB-PrevMonthSizeMB)
				END AS 'Current Month Change<DifferenceMB>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Current Month Change (%)<DifferenceNA>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
				Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
				Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Purchase After 6 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 12 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 18 Months<SIZEMB><HIDDEN>'
		FROM	#Summary S
				LEFT OUTER JOIN (SELECT DISTINCT CommservUniqueId, CommServName FROM #Results) R ON S.CommservUniqueId = R.CommservUniqueId
				LEFT OUTER JOIN (
					SELECT	MPR.CommServUniqueId, MP.LibraryId, MAX(MP.HardDriveShared) AS HardDriveShared
					FROM	cf_SurveyMountPathSummary MP
							INNER JOIN #MountPathResults MPR ON MP.SurveyResultId = MPR.SurveyResultId
					GROUP BY MPR.CommServUniqueId, MP.LibraryId
					) SM ON S.CommServUniqueId = SM.CommServUniqueId AND S.EntityId = SM.LibraryId
		ORDER BY IsTotal DESC, 'Consumed Space<SIZEMB>' DESC, EntityName
	ELSE
	IF	@i_EntityType = 'Cloud Library'
		SELECT	S.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(R.CommServName, '') AS 'CommCell Name',
				EntityName  AS 'Library Name',
				LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
				AppSizeMB AS 'App Size<SIZEMB>',
				MediaSizeMB AS 'Data Written<SIZEMB>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
				END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE (MediaSizeMB-PrevMonthSizeMB)
				END AS 'Current Month Change<DifferenceMB>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Current Month Change (%)<DifferenceNA>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
				Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
				Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Purchase After 6 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 12 Months<SIZEMB><HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Purchase After 18 Months<SIZEMB><HIDDEN>'
		FROM	#Summary S LEFT OUTER JOIN (SELECT DISTINCT CommservUniqueId, CommServName FROM #Results) R ON S.CommservUniqueId = R.CommservUniqueId
		ORDER BY IsTotal DESC, 'Data Written<SIZEMB>' DESC, EntityName
	ELSE
	IF	@i_EntityType = 'Tape Library'
		SELECT	S.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				ISNULL(R.CommServName, '') AS 'CommCell Name',
				EntityName  AS 'Library Name',
				LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
				UpperLimitMB AS 'Number of Tapes',
				MediaSizeMB AS 'Used Tapes',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
				END AS 'Previous Month Change<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
					 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE (MediaSizeMB-PrevMonthSizeMB)
				END AS 'Current Month Change<DifferenceNA>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
					 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Current Month Change (%)<DifferenceNA>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0) AS DECIMAL(32, 3)) AS 'Growth Rate (Tapes/Month)',
				Size6Month  AS 'Size After 6 Months<HIDDEN>',
				Size12Month AS 'Size After 12 Months<HIDDEN>',
				Size18Month AS 'Size After 18 Months<HIDDEN>',
				CASE WHEN (Size6Month -UpperLimitMB) > 0 THEN (Size6Month -UpperLimitMB) ELSE 0 END AS 'Import After 6 Months<HIDDEN>',
				CASE WHEN (Size12Month-UpperLimitMB) > 0 THEN (Size12Month-UpperLimitMB) ELSE 0 END AS 'Import After 12 Months<HIDDEN>',
				CASE WHEN (Size18Month-UpperLimitMB) > 0 THEN (Size18Month-UpperLimitMB) ELSE 0 END AS 'Import After 18 Months<HIDDEN>'
		FROM	#Summary S LEFT OUTER JOIN (SELECT DISTINCT CommservUniqueId, CommServName FROM #Results) R ON S.CommservUniqueId = R.CommservUniqueId
		ORDER BY IsTotal DESC, 'Used Tapes' DESC, EntityName
	ELSE
	IF	@i_EntityType = 'Agent Type'
	BEGIN
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'CommCell Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					AppSizeMB AS 'Protected App Size<SIZEMB>',
					MediaSizeMB AS 'Size on Media<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Size on Media<SIZEMB>' DESC, EntityName
		ELSE
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'Agent Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					AppSizeMB AS 'Protected App Size<SIZEMB>',
					MediaSizeMB AS 'Size on Media<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Size on Media<SIZEMB>' DESC, EntityName
	END
	ELSE
	IF  @i_EntityType = 'Client Group'
	BEGIN
		IF	ISNULL(@i_Aggregate, 0) = 3
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'CommCell Name',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					AppSizeMB AS 'Protected App Size<SIZEMB>',
					MediaSizeMB AS 'Size on Media<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Size on Media<SIZEMB>' DESC, EntityName
		ELSE
			SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					EntityName  AS 'Client Group',
					LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
					AppSizeMB AS 'Protected App Size<SIZEMB>',
					MediaSizeMB AS 'Size on Media<SIZEMB>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
					END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
					CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						 ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						 ELSE (MediaSizeMB-PrevMonthSizeMB)
					END AS 'Current Month Change<DifferenceMB>',
					CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						 WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						 ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
					END AS 'Current Month Change (%)<DifferenceNA>',
					CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
					Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
					Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
					Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
			FROM	#Summary
			ORDER BY IsTotal DESC, 'Size on Media<SIZEMB>' DESC, EntityName
	END
	ELSE
	IF  @i_EntityType = 'CommCell'
		SELECT	CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
				EntityName  AS 'CommCell',
				LEFT(DATENAME(MONTH, LastMonth), 3) + ', ' + DATENAME(YEAR, LastMonth) AS 'Latest Month',
				AppSizeMB AS 'Protected App Size<SIZEMB>',
				MediaSizeMB AS 'Size on Media<SIZEMB>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						ELSE (PrevMonthSizeMB-Pre2MonthSizeMB)
				END AS 'Previous Month Change<DifferenceMB><HIDDEN>',
				CASE WHEN ISNULL(Pre2MonthSizeMB, 0) = 0 OR ISNULL(PrevMonthSizeMB, 0) = 0 THEN NULL
						ELSE CAST(1.0*(PrevMonthSizeMB-Pre2MonthSizeMB)/(0.01*Pre2MonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Previous Month Change (%)<DifferenceNA><HIDDEN>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						WHEN @i_GrowthType IN (1, 3) THEN (AppSizeMB-PrevMonthSizeMB)
						ELSE (MediaSizeMB-PrevMonthSizeMB)
				END AS 'Current Month Change<DifferenceMB>',
				CASE WHEN ISNULL(PrevMonthSizeMB, 0) = 0 OR LastMonth <> @CurrMonth THEN NULL
						WHEN @i_GrowthType IN (1, 3) THEN CAST(1.0*(AppSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
						ELSE CAST(1.0*(MediaSizeMB-PrevMonthSizeMB)/(0.01*PrevMonthSizeMB) AS DECIMAL(30, 2))
				END AS 'Current Month Change (%)<DifferenceNA>',
				CAST(1.0*ISNULL(MonthlyGrowthMB, 0)/1024/1024 AS DECIMAL(32, 3)) AS 'Growth Rate (TB/Month)',
				Size6Month  AS 'Size After 6 Months<SIZEMB><HIDDEN>',
				Size12Month AS 'Size After 12 Months<SIZEMB><HIDDEN>',
				Size18Month AS 'Size After 18 Months<SIZEMB><HIDDEN>'
		FROM	#Summary
		ORDER BY IsTotal DESC, 'Size on Media<SIZEMB>' DESC, EntityName
END
DROP TABLE #Results
DROP TABLE #Summary
DROP TABLE #MonthTbl
DROP TABLE #EntitySize
DROP TABLE #EntityLastMonth
DROP TABLE #LicenseServerChild
DROP TABLE #MountPathResults
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDataGrowthTrend')
	delete from GxQscripts where name = 'RptDataGrowthTrend'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDataGrowthTrend')
	delete from GXDBVersions where aliasname = 'RptDataGrowthTrend'
GO

insert into GXDBVersions values(2, 'RptDataGrowthTrend',  '00010006000200290000', 'RptDataGrowthTrend', '00010006000200290000')
GO

