

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptDRBkpConfiguration.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptDRBkpConfiguration.sp,v $ $Id: RptDRBkpConfiguration.sp,v 1.9.2.5 2020/05/11 17:59:10 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptDRBkpConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: RptDRBkpConfiguration <<<'
	drop procedure RptDRBkpConfiguration
END
IF EXISTS (select * from GxQscripts where name='RptDRBkpConfiguration')
	delete from GxQscripts where name = 'RptDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'RptDRBkpConfiguration'
GO
print '... Creating Procedure: RptDRBkpConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptDRBkpConfiguration
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 31
IF @i_CommServUniqueID = 0
BEGIN
	IF (@blaggregate = 1)
	BEGIN
		SELECT
			resultView.CommServUniqueId  AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			resultView.DisplayName AS 'CommCell Name',
			ISNULL(csInfo.ScheduleName,'') As 'Schedule Name',
			csInfo.Schedule As 'Schedule Type<HIDDEN>',
			csInfo.FullJobsToRetain AS 'Full Jobs to Retain',
			ISNULL(sub.DRBkpLocation, '') AS 'DR Backup Metadata Location',
			CASE WHEN csInfo.IsUingNetworkPath = 'true' THEN 'Yes' ELSE 'No' END AS 'Upload to Network Path',
			CASE WHEN ISNULL(csInfo.UseCommvaultCloud, 0) = 1 THEN 'Yes' ELSE 'No' END AS 'Upload to Commvault Cloud',
			CASE WHEN ISNULL(csInfo.UseThirdpartyCloud, 0) = 0 THEN 'None' ELSE dbo.RptGetCloudVendorName(csInfo.CloudDeviceTypeId) END AS 'Upload to Cloud Library',
			ISNULL(csInfo.LogFilesToBackup, 'None') AS 'Log Files to Backup',
			csInfo.WritingToTape As 'Writing to Tape<HIDDEN>',
			csInfo.LastJobId AS 'Last Successful Job ID<HIDDEN>',
			CASE WHEN sub.LastSuccessfulDRTime = 0 THEN -3
				ELSE sub.LastSuccessfulDRTime END
				AS 'Last Successful DR Backup Time<MMMDDYYYY><HIDDEN>'
		FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			INNER JOIN (
				SELECT  ci.CommServUniqueId, ci.DRBkpLocation, ci.LastSuccessfulDRTime FROM cf_SurveyDRStats ci
					INNER JOIN 	dbo.cf_SurveyResultFuncV1(19, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
						ON resultView.SurverResultId = ci.SurveyResultId
				) as sub
				on sub.CommServUniqueId = csInfo.CommServUniqueId
		ORDER BY 'CommCell Name' ASC, csInfo.Schedule DESC
	END
	ELSE
	BEGIN
		SELECT
			csInfo.CommServUniqueId AS 'CommServ UniqueId',
			resultView.CommCellID AS 'CommCell ID',
			resultView.DisplayName AS 'CommCell Name',
			csInfo.JobId AS 'Job ID',
			CASE csInfo.Status
					WHEN 0 THEN 'Running'
					WHEN 1 THEN 'Completed'
					WHEN 2 THEN 'Failed'
					WHEN 3 THEN 'Completed with errors'
					WHEN 4 THEN 'Killed'
					WHEN 5 THEN 'Suspended'
					WHEN 6 THEN 'Interrupted'
					WHEN 7 THEN 'Any Status'
					WHEN 8 THEN 'Skipped'
					WHEN 9 THEN CASE WHEN csInfo.FailureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
					WHEN 10 THEN 'Synchronized'
					WHEN 11 THEN 'Not Synchronized'
					WHEN 12 THEN 'Not Attempted'
					WHEN 13 THEN 'Started'
					WHEN 14 THEN 'Completed with warnings'
					WHEN 15 THEN 'System Failed'
					WHEN 16 THEN 'Committed'
					ELSE 'Unknown'
			END AS 'Job Status',
			dbo.GetDateTime(csInfo.StartDate) AS 'Start Time',
			dbo.GetDateTime(csInfo.EndDate) AS 'End Time<HIDDEN>',
			csInfo.ErrorCode AS 'Error Code<HIDDEN>',
			csInfo.FailureReason AS 'Failure Reason<HIDDEN>',
			csInfo.StoragePolicy AS 'Storage Policy',
			csInfo.StoragePolicyCopy AS 'Storage Policy Copy',
			csInfo.Library AS 'Library',
			csInfo.Barcode AS 'Barcode',
			csInfo.LocationType AS 'Location Type',
			csInfo.LocationName AS 'Location Name'
		FROM cf_SurveyDRJobDetails AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(19, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY csInfo.JobId DESC
	END
END
ELSE
BEGIN
	IF (@blaggregate = 1)
	BEGIN
		SELECT
			csInfo.CommServUniqueId AS 'CommServ UniqueId',
			ISNULL(csInfo.ScheduleName,'') As 'Schedule Name',
			csInfo.Schedule As 'Schedule Type<HIDDEN>',
			csInfo.FullJobsToRetain AS 'Full Jobs to Retain',
			ISNULL(sub.DRBkpLocation, '') AS 'DR Backup Metadata Location',
			CASE WHEN csInfo.IsUingNetworkPath = 'true' THEN 'Yes' ELSE 'No' END AS 'Upload to Network Path',
			CASE WHEN ISNULL(csInfo.UseCommvaultCloud, 0) = 1 THEN 'Yes' ELSE 'No' END AS 'Upload to Commvault Cloud',
			CASE WHEN ISNULL(csInfo.UseThirdpartyCloud, 0) = 0 THEN 'None' ELSE dbo.RptGetCloudVendorName(csInfo.CloudDeviceTypeId) END AS 'Upload to Cloud Library',
			ISNULL(csInfo.LogFilesToBackup, 'None') AS 'Log Files to Backup',
			csInfo.WritingToTape As 'Writing to Tape<HIDDEN>',
			csInfo.LastJobId AS 'Last Successful Job ID<HIDDEN>',
			CASE WHEN sub.LastSuccessfulDRTime = 0 THEN -3
				ELSE sub.LastSuccessfulDRTime END
				AS 'Last Successful DR Backup Time<MMMDDYYYY><HIDDEN>'
		FROM cf_SurveyDRBkpConfiguration AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
			INNER JOIN (
				SELECT  ci.CommServUniqueId, ci.DRBkpLocation, ci.LastSuccessfulDRTime FROM cf_SurveyDRStats ci
					INNER JOIN 	dbo.cf_SurveyResultFuncV1(19, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
						ON resultView.SurverResultId = ci.SurveyResultId
				) as sub
				on sub.CommServUniqueId = csInfo.CommServUniqueId
		ORDER BY csInfo.Schedule DESC
	END
	ELSE
	BEGIN
		SELECT
			csInfo.CommServUniqueId AS 'CommServ UniqueId',
			csInfo.JobId AS 'Job ID',
			CASE csInfo.Status
					WHEN 0 THEN 'Running'
					WHEN 1 THEN 'Completed'
					WHEN 2 THEN 'Failed'
					WHEN 3 THEN 'Completed with errors'
					WHEN 4 THEN 'Killed'
					WHEN 5 THEN 'Suspended'
					WHEN 6 THEN 'Interrupted'
					WHEN 7 THEN 'Any Status'
					WHEN 8 THEN 'Skipped'
					WHEN 9 THEN CASE WHEN csInfo.FailureErrorCode NOT IN (8)  THEN 'Skipped' ELSE 'Failed To Start' END
					WHEN 10 THEN 'Synchronized'
					WHEN 11 THEN 'Not Synchronized'
					WHEN 12 THEN 'Not Attempted'
					WHEN 13 THEN 'Started'
					WHEN 14 THEN 'Completed with warnings'
					WHEN 15 THEN 'System Failed'
					WHEN 16 THEN 'Committed'
					ELSE 'Unknown'
			END AS 'Job Status',
			dbo.GetDateTime(csInfo.StartDate) AS 'Start Time',
			dbo.GetDateTime(csInfo.EndDate) AS 'End Time<HIDDEN>',
			csInfo.ErrorCode AS 'Error Code<HIDDEN>',
			csInfo.FailureReason AS 'Failure Reason<HIDDEN>',
			csInfo.StoragePolicy AS 'Storage Policy',
			csInfo.StoragePolicyCopy AS 'Storage Policy Copy',
			csInfo.Library AS 'Library',
			csInfo.Barcode AS 'Barcode',
			csInfo.LocationType AS 'Location Type',
			csInfo.LocationName AS 'Location Name'
		FROM cf_SurveyDRJobDetails AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(19, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY csInfo.JobId DESC
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptDRBkpConfiguration')
	delete from GxQscripts where name = 'RptDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'RptDRBkpConfiguration'
GO

insert into GXDBVersions values(2, 'RptDRBkpConfiguration',  '00010009000200050000', 'RptDRBkpConfiguration', '00010009000200050000')
GO

