

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommcellSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommcellSummary.sp,v $ $Id: RptCommcellSummary.sp,v 1.5.2.13 2020/07/28 18:55:58 nbirru Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCommCellSummary')
BEGIN
	print '>>> Drop Stored Procedure: RptCommCellSummary <<<'
	drop procedure RptCommCellSummary
END
IF EXISTS (select * from GxQscripts where name='RptCommCellSummary')
	delete from GxQscripts where name = 'RptCommCellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommCellSummary')
	delete from GXDBVersions where aliasname = 'RptCommCellSummary'
GO
print '... Creating Procedure: RptCommCellSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommCellSummary
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @i_type INT =1,
  @i_LatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_SLADays INT = 30,
  @i_TenantName NVARCHAR(255) = NULL
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 146
DECLARE @resultID int
IF(@i_type=1)
BEGIN
  IF @i_SLADays = 30
	SELECT
		SUM(ProtectedClients) as ProtectedClients,
		SUM(NotProtectedClients) as NotProtectedClients,
		SUM(ExcludedClients) as ExcludedClients
	FROM
		cf_CommcellSummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
  ELSE
	SELECT
		SUM(ProtectedClients) as ProtectedClients,
		SUM(NotProtectedClients) as NotProtectedClients,
		SUM(ExcludedClients) as ExcludedClients
	FROM
		cf_SurveySLASummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId AND csInfo.Days = @i_SLADays
	RETURN
END
ELSE IF ( @i_type =2 )
BEGIN
      SELECT
            3 as StrikeCount ,
            SUM(Strike3Clients) as Clients,
            sum(Strike3SubClients) as SubClients,
            sum(ISNULL(Strike3VMs,0)) as VMs
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            2 as StrikeCount,
            sum(Strike2Clients) as Clients,
            sum(Strike2SubClients) as SubClients,
            sum(ISNULL(Strike2VMs,0)) as VMs
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      UNION
      SELECT
            1 as StrikeCount,
            sum(Strike1Clients) as Clients,
            sum(Strike1SubClients) as SubClients,
            sum(ISNULL(Strike1VMs,0)) as VMs
      FROM
            cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      RETURN
END
ELSE IF ( @i_type =3 )
BEGIN
      SELECT
            CAST(CAST(case when sum(TotalJobs) =0 then 0 else
                  sum(SuccessfulJobs)*100.0/sum(TotalJobs) END AS DECIMAL(7, 1)) AS VARCHAR(MAX))  AS 'Success Rate'
            FROM cf_CommcellSummary AS csInfo WITH (NOLOCK)
            INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
            ON resultView.SurverResultId = csInfo.SurveyResultId
      RETURN
END
ELSE IF @i_type IN (4,5) -- For Last 12 Months SLA Trend
BEGIN
	IF object_id('tempdb.dbo.#TenantClientGroups') IS NOT NULL DROP TABLE #TenantClientGroups
	CREATE TABLE #TenantClientGroups (CommServUniqueId INT, TenantName NVARCHAR(255), ClientGroupId INT)
	exec GetTenantEntities @i_UserId, @i_GroupId, 1, 1, @i_CommServUniqueID, @i_LogDateStart, @i_LogDateEND, @i_TenantName
	CREATE TABLE #SLATrend (CommServUniqueId INT, CommCellName NVARCHAR(1024), MonthBegin DATETIME, nClientsMet INT, nClientsMissed INT, slaPct INT)
	IF @i_type = 4 AND @i_CommServUniqueID <= 0 AND @i_GroupId <= 0 -- For worldwide SLA trend chart
		INSERT INTO #SLATrend (MonthBegin, nClientsMet, nClientsMissed, slaPct)
		SELECT	MonthBegin,
				SUM(nClientsMet),
				SUM(nClientsMissed),
				CASE WHEN (SUM(nClientsMet) + SUM(nClientsMissed)) <= 0 THEN 0 ELSE (100*SUM(nClientsMet))/(SUM(nClientsMet) + SUM(nClientsMissed)) END
		FROM cf_SurveySLAHistory AS csInfo WITH (NOLOCK)
			INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
				ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		GROUP BY MonthBegin
	ELSE
	BEGIN
		IF @i_TenantName is NULL
		BEGIN
			INSERT INTO #SLATrend
			SELECT  resultView.CommServUniqueId,
					resultView.DisplayName,
					MonthBegin,
					nClientsMet,
					nClientsMissed,
					CASE WHEN (nClientsMet + nClientsMissed) <= 0 THEN 0 ELSE (100*nClientsMet)/(nClientsMet + nClientsMissed) END
			FROM cf_SurveySLAHistory AS csInfo WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
					ON resultView.CommServUniqueId = csInfo.CommServUniqueId
		END
		BEGIN
			IF object_id('tempdb.dbo.#AsOfDates') IS NOT NULL DROP TABLE #AsOfDates
			CREATE TABLE #AsOfDates (CommServUniqueId INT, clientGroupId INT, Months DATETIME, AsOfDate DATETIME)
			INSERT INTO #AsOfDates
				SELECT TCG.CommServUniqueId, TCG.clientGroupId, DATEADD(MONTH, DATEDIFF(MONTH, 0, AsOfDate), 0) AS m, MAX(AsOfDate) AS d
				FROM cf_SurveyClientGroupSLAHistory CGS WITH (NOLOCK)
				INNER JOIN #TenantClientGroups TCG ON TCG.CommServUniqueId = CGS.CommServUniqueId AND TCG.clientGroupId = CGS.clientGroupId
					WHERE AsOfDate <= GETDATE()
				GROUP BY TCG.CommServUniqueId, TCG.clientGroupId, DATEADD(MONTH, DATEDIFF(MONTH, 0, AsOfDate), 0)
			IF @i_type = 5
			BEGIN
				INSERT INTO #SLATrend
				SELECT TCG.CommservUniqueId,
							  T.TenantName,
							  M.Months,
							  SUM(H.MetBackupSLAClients),
							  SUM(H.TotalClients) - SUM(H.MetBackupSLAClients),
							  CASE WHEN SUM(H.TotalClients) <= 0 THEN 0 ELSE (100*SUM(H.MetBackupSLAClients))/(SUM(H.TotalClients)) END
				FROM cf_SurveyClientGroupSLAHistory  H WITH (NOLOCK)
				INNER JOIN #AsOfDates M ON M.CommServUniqueId = H.CommServUniqueId AND H.AsOfDate = M.AsOfDate AND M.clientGroupId = H.ClientGroupId
				RIGHT OUTER JOIN #TenantClientGroups TCG ON TCG.CommServUniqueId = H.CommServUniqueId AND TCG.clientGroupId = H.clientGroupId
				INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON T.CommServUniqueId = TCG.CommServUniqueId AND TCG.clientGroupId = T.clientGroupId
				GROUP BY TCG.CommservUniqueId, T.TenantName, M.Months
				ORDER BY M.Months DESC
			END
			ELSE
			BEGIN
				INSERT INTO #SLATrend
				SELECT H.CommservUniqueId,
							  resultView.DisplayName,
							  M.Months,
							  SUM(H.MetBackupSLAClients),
							  SUM(H.TotalClients) - SUM(H.MetBackupSLAClients),
							  CASE WHEN (SUM(H.MetBackupSLAClients) + (SUM(H.TotalClients) - SUM(H.MetBackupSLAClients))) <= 0 THEN 0 ELSE (100*SUM(H.MetBackupSLAClients))/(SUM(H.MetBackupSLAClients) + (SUM(H.TotalClients) - SUM(H.MetBackupSLAClients))) END
				FROM cf_SurveyClientGroupSLAHistory  H WITH (NOLOCK)
				INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
						ON resultView.CommServUniqueId = H.CommServUniqueId
				INNER JOIN #AsOfDates M ON H.CommServUniqueId = M.CommServUniqueId AND H.AsOfDate = M.AsOfDate
				INNER JOIN #TenantClientGroups TCG ON TCG.CommServUniqueId = H.CommServUniqueId AND TCG.clientGroupId = H.clientGroupId
				INNER JOIN cf_SurveyTenants T WITH (NOLOCK) ON T.CommServUniqueId = TCG.CommServUniqueId AND TCG.clientGroupId = T.clientGroupId
				GROUP BY H.CommservUniqueId, resultView.DisplayName, M.Months
				ORDER BY M.Months DESC
			END
		END
	END
	DECLARE @maxMonth DATETIME = (SELECT MAX(MonthBegin) FROM #SLATrend)
	DECLARE @numMonth INT = 12
	CREATE TABLE #MonthTbl (MonthBegin DATETIME, MonthName VARCHAR(32))
	WHILE	@numMonth > 0
	BEGIN
		SET @numMonth -= 1
		INSERT INTO #MonthTbl
		SELECT DATEADD(MONTH, -@numMonth, @maxMonth), NULL
	END
	IF @i_type = 4 -- For chart
	BEGIN
		IF @i_CommServUniqueID > 0 OR @i_GroupId > 0
			SELECT	C.CommServUniqueId AS 'CommServ UniqueId<DONOTSHOW>',
					C.CommCellName AS 'CommCell Name<commcellName><DONOTSHOW>',
					dbo.GetUnixTimeBig(M.MonthBegin) AS 'Month<MMMYYYY>',
					ISNULL(T.nClientsMet, 0) AS 'Met SLA',
					ISNULL(T.nClientsMissed, 0) AS 'Missed SLA',
					ISNULL(T.slaPct, 0) AS 'SLA (%)'
			FROM	#MonthTbl M CROSS JOIN (SELECT DISTINCT CommServUniqueId, CommCellName FROM #SLATrend) AS C
					LEFT OUTER JOIN #SLATrend T ON T.CommServUniqueId = C.CommServUniqueId AND T.MonthBegin = M.MonthBegin
			ORDER BY C.CommServUniqueId, M.MonthBegin
		ELSE
			SELECT	dbo.GetUnixTimeBig(M.MonthBegin) AS 'Month<MMMYYYY>',
					ISNULL(T.nClientsMet, 0) AS 'Met SLA',
					ISNULL(T.nClientsMissed, 0) AS 'Missed SLA',
					ISNULL(T.slaPct, 0) AS 'SLA (%)'
			FROM	#MonthTbl M
					LEFT OUTER JOIN #SLATrend T ON T.MonthBegin = M.MonthBegin
			ORDER BY M.MonthBegin
		DROP TABLE #MonthTbl
		DROP TABLE #SLATrend
		RETURN
	END
	-- For table (@i_type = 5)
	UPDATE	#MonthTbl
	SET		MonthName = SUBSTRING(DATENAME(MONTH, MonthBegin), 1, 3) + ' ' + CAST(YEAR(MonthBegin) AS VARCHAR(4)) + '<NumberNA>'
	DECLARE	@LastDate DATETIME = (SELECT MAX(MonthBegin) FROM #MonthTbl)
	DECLARE	@PrevDate DATETIME = (SELECT MAX(MonthBegin) FROM #MonthTbl WHERE MonthBegin < @LastDate)
	CREATE TABLE #SLAChange (CommServUniqueId INT, CommCellName NVARCHAR(1024), LastSLAPctChange INT)
	INSERT INTO #SLAChange
	SELECT	L.CommServUniqueId, L.CommCellName, (L.slaPct - P.slaPct)
	FROM	(SELECT CommServUniqueId, CommCellName, slaPct FROM #SLATrend WHERE MonthBegin = @LastDate) AS L
			INNER JOIN
			(SELECT CommServUniqueId, CommCellName, slaPct FROM #SLATrend WHERE MonthBegin = @PrevDate) AS P
		ON L.CommServUniqueId = P.CommServUniqueId AND L.CommCellName = P.CommCellName
	INSERT INTO #SLAChange
	SELECT	C.CommServUniqueId, C.CommCellName, NULL
	FROM	(SELECT DISTINCT CommServUniqueId, CommCellName FROM #SLATrend) AS C
		LEFT OUTER JOIN #SLAChange T ON C.CommservUniqueId = T.CommservUniqueId AND T.CommCellName = C.CommCellName
	WHERE	T.CommservUniqueId IS NULL
	INSERT	INTO #SLATrend
	SELECT	C.CommservUniqueId, C.CommCellName, M.MonthBegin, -1, -1, -1
	FROM	#MonthTbl M CROSS JOIN #SLAChange C
		LEFT OUTER JOIN #SLATrend H ON M.MonthBegin = H.MonthBegin AND C.CommservUniqueId = H.CommservUniqueId AND H.CommCellName = C.CommCellName
	WHERE	H.MonthBegin IS NULL
	DECLARE @QueryStr NVARCHAR(MAX)
	DECLARE @Columns  VARCHAR(MAX)
	SELECT	@Columns = ISNULL(@Columns + ', ', '') + QUOTENAME(MonthName)
	FROM	#MonthTbl
	ORDER BY MonthBegin
  IF @i_CommServUniqueID > 0
  BEGIN
	IF @i_TenantName is NULL
	BEGIN
		SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommCellName AS [CommCell Name<DONOTSHOW>],
			ISNULL(LastSLAPctChange, 0) AS [Latest SLA (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.CommservUniqueId, T.CommCellName, C.LastSLAPctChange, M.MonthName, T.slaPct
			FROM	#SLATrend T
				INNER JOIN #SLAChange C ON T.CommservUniqueId = C.CommservUniqueId
				INNER JOIN #MonthTbl M ON T.MonthBegin = M.MonthBegin
		) X
		PIVOT
		(
			MAX(slaPct)
			FOR MonthName IN (' + @Columns + N')
		) P
		ORDER BY CommCellName'
	END
	ELSE
	BEGIN
		SET @QueryStr =
		N'SELECT
			CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommCellName AS [Company],
			ISNULL(LastSLAPctChange, 0) AS [Latest SLA (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
		'FROM
		(
			SELECT	T.CommservUniqueId, T.CommCellName, C.LastSLAPctChange, M.MonthName, T.slaPct
			FROM	#SLATrend T
				INNER JOIN #SLAChange C ON T.CommservUniqueId = C.CommservUniqueId AND T.CommCellName = C.CommCellName
				INNER JOIN #MonthTbl M ON T.MonthBegin = M.MonthBegin
		) X
		PIVOT
		(
			MAX(slaPct)
			FOR MonthName IN (' + @Columns + N')
		) P
		ORDER BY CommCellName'
	END
  END
  ELSE
  BEGIN
		IF @i_TenantName is NULL
		BEGIN
			SET @QueryStr =
				N'SELECT
					CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommCellName AS [CommCell Name],
					LastSLAPctChange AS [Latest SLA (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
				'FROM
				(
					SELECT  T.CommservUniqueId, T.CommCellName, C.LastSLAPctChange, M.MonthName, T.slaPct
					FROM    #SLATrend T
						INNER JOIN #SLAChange C ON T.CommservUniqueId = C.CommservUniqueId
						INNER JOIN #MonthTbl M ON T.MonthBegin = M.MonthBegin
				) X
				PIVOT
				(
					MAX(slaPct)
					FOR MonthName IN (' + @Columns + N')
				) P
				ORDER BY CommCellName'
		END
		ELSE
		BEGIN
			SET @QueryStr =
			N'SELECT
				CommservUniqueId AS [CommservUniqueId<DONOTSHOW>], CommServName AS [CommCell Name], CommCellName AS [Company],
				ISNULL(LastSLAPctChange, 0) AS [Latest SLA (%) Change<DifferenceNA><HIDDEN>], ' + @Columns +
			'FROM
			(
				SELECT  T.CommservUniqueId, CC.CommServName, T.CommCellName, C.LastSLAPctChange, M.MonthName, T.slaPct
				FROM    #SLATrend T
					INNER JOIN #SLAChange C ON T.CommservUniqueId = C.CommservUniqueId AND T.CommCellName = C.CommCellName
					INNER JOIN #MonthTbl M ON T.MonthBegin = M.MonthBegin
					INNER JOIN cf_CommCellIdNameMap CC WITH (NOLOCK) ON T.CommservUniqueId = CC.ID
			) X
			PIVOT
			(
				MAX(slaPct)
				FOR MonthName IN (' + @Columns + N')
			) P
			ORDER BY CommCellName'
		END
	END
	EXEC sp_executesql @QueryStr
	DROP TABLE #MonthTbl
	DROP TABLE #SLATrend
	DROP TABLE #SLAChange
	RETURN
END
ELSE IF @i_type = 6 -- For SLA Summary table
BEGIN
	DECLARE	@ProtectedClients    INT = 0
	DECLARE	@NotProtectedClients INT = 0
	DECLARE	@ExcludedClients     INT = 0
	DECLARE	@ProtectedServers    INT = 0
	DECLARE	@NotProtectedServers INT = 0
	DECLARE	@ExcludedServers     INT = 0
	DECLARE	@ProtectedLaptops    INT = 0
	DECLARE	@NotProtectedLaptops INT = 0
	DECLARE	@ExcludedLaptops     INT = 0
	DECLARE	@ProtectedVMs        INT = 0
	DECLARE	@NotProtectedVMs     INT = 0
	DECLARE	@ExcludedVMs         INT = 0
	SELECT	@ProtectedClients    = SUM(ProtectedClients),
			@NotProtectedClients = SUM(NotProtectedClients),
			@ExcludedClients     = SUM(ExcludedClients),
			@ProtectedLaptops    = SUM(ProtectedLaptops),
			@NotProtectedClients = SUM(NotProtectedLaptops),
			@ExcludedLaptops     = SUM(ExcludedLaptops),
			@ProtectedVMs        = SUM(ProtectedVMs),
			@NotProtectedVMs     = SUM(NotProtectedVMs),
			@ExcludedVMs         = SUM(ExcludedVMs)
	FROM
		cf_CommcellSummary AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @i_LatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
	SET @ProtectedServers    = @ProtectedClients - @ProtectedLaptops - @ProtectedVMs
	SET @NotProtectedServers = @NotProtectedClients - @NotProtectedLaptops - @NotProtectedVMs
	SET @ExcludedServers     = @ExcludedClients - @ExcludedLaptops - @ExcludedVMs
	DECLARE	@SummaryTbl TABLE (Entity VARCHAR(32), SLAPct INT, MetSLA INT, MissedSLA INT, Excluded INT)
	INSERT	INTO @SummaryTbl
	SELECT	'All Clients', CASE WHEN (@ProtectedClients+@NotProtectedClients) > 0 THEN 100*@ProtectedClients/(@ProtectedClients+@NotProtectedClients) ELSE 0 END,
			@ProtectedClients, @NotProtectedClients, @ExcludedClients
	UNION ALL
	SELECT	'Servers',     CASE WHEN (@ProtectedServers+@NotProtectedServers) > 0 THEN 100*@ProtectedServers/(@ProtectedServers+@NotProtectedServers) ELSE 0 END,
			@ProtectedServers, @NotProtectedServers, @ExcludedServers
	UNION ALL
	SELECT	'Laptops',     CASE WHEN (@ProtectedLaptops+@NotProtectedLaptops) > 0 THEN 100*@ProtectedLaptops/(@ProtectedLaptops+@NotProtectedLaptops) ELSE 0 END,
			@ProtectedLaptops, @NotProtectedLaptops, @ExcludedLaptops
	UNION ALL
	SELECT	'VMs',         CASE WHEN (@ProtectedVMs+@NotProtectedVMs) > 0 THEN 100*@ProtectedVMs/(@ProtectedVMs+@NotProtectedVMs) ELSE 0 END,
			@ProtectedVMs,     @NotProtectedVMs,     @ExcludedVMs
	SELECT	Entity AS 'Entity', SLAPct AS 'SLA (%)<percentNA>', MetSLA AS 'Met SLA<NumberNA>', MissedSLA AS 'Missed SLA<NumberNA>', Excluded AS 'Excluded<NumberNA>'
	FROM	@SummaryTbl
	RETURN
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommcellSummary')
	delete from GxQscripts where name = 'RptCommcellSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommcellSummary')
	delete from GXDBVersions where aliasname = 'RptCommcellSummary'
GO

insert into GXDBVersions values(2, 'RptCommcellSummary',  '00010005000200130000', 'RptCommcellSummary', '00010005000200130000')
GO

