

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCommcellScalability.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCommcellScalability.sp,v $ $Id: RptCommcellScalability.sp,v 1.1.2.1 2017/07/02 05:03:24 aryas Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptCommcellScalability <<<'

IF EXISTS (select * from sysobjects where name='RptCommcellScalability')
	drop procedure RptCommcellScalability
IF EXISTS (select * from GxQscripts where name='RptCommcellScalability')
	delete from GxQscripts where name = 'RptCommcellScalability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommcellScalability')
	delete from GXDBVersions where aliasname = 'RptCommcellScalability'
GO
print '... Creating Procedure: RptCommcellScalability'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCommcellScalability
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 0,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NULL
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1
SET @blaggregate = 0
DECLARE @strGood		VARCHAR(10) = '1_Good'
DECLARE @strwarning		VARCHAR(10) = '3_Warning'
DECLARE @strCritical	VARCHAR(10) = '4_Critical'
DECLARE @tblHealthQueryIds TABLE(HealthQueryId INT, SortOrder INT IDENTITY(1, 1))
DECLARE @tblScaleParamIds TABLE(ScaleParamId INT, SortOrder INT IDENTITY(1000, 1))
INSERT INTO @tblHealthQueryIds
SELECT QueryId FROM dbo.RptGetMetricsQueryFlags(0) WHERE QueryEnabled = 1 AND (QueryFlags & 4) != 0 AND QueryId IN (27, 16, 17, 24, 64, 96, 65, 156)
INSERT INTO @tblScaleParamIds
SELECT ParamId FROM cf_SurveyHealthParam WITH(NOLOCK) WHERE QueryId = 7 AND ParamId IN (726, 701, 703, 723, 724)
DECLARE @tblParameters TABLE (ParameterName NVARCHAR(MAX), HealthResult NVARCHAR(MAX), HealthStatus NVARCHAR(MAX), ParamId INT)
INSERT INTO @tblParameters
SELECT Monitor, Result, Status, MonitorId
FROM dbo.RptGetServerHealthFunc(@i_CommservUniqueId, @i_UserId, @i_GroupId, default) HF
INNER JOIN @tblHealthQueryIds Q ON Q.HealthQueryId = HF.MonitorId
ORDER BY HF.GroupSortOrder, HF.MonitorSortOrder
INSERT INTO @tblParameters
SELECT ParameterName,
	CASE WHEN LastHour IS NULL THEN outcome ELSE  CAST(LastHour  as VARCHAR(15)) + ' ' + unit END,
	Status, ParamId
FROM dbo.RptGetScaleHealthFunc(@i_UserId, @i_GroupId, @blAggregate, @blLatestSurvey, @i_CommservUniqueId, @i_LogDateStart, @i_LogDateEnd, 'HourlyFormat', 0) SF
INNER JOIN @tblScaleParamIds P ON P.ScaleParamId = SF.ParamId
ORDER BY SF.Id
INSERT INTO @tblParameters
SELECT ParameterName,
	CASE WHEN LastHour IS NULL THEN outcome ELSE CAST( LastHour as VARCHAR(15) ) + ' ' + unit END,
	Status, ParamId
FROM dbo.RptGetScaleHealthFunc(@i_UserId, @i_GroupId, @blAggregate, @blLatestSurvey, @i_CommservUniqueId, @i_LogDateStart, @i_LogDateEnd, 'DatabaseFormat', 0) SF
INNER JOIN @tblScaleParamIds P ON P.ScaleParamId = SF.ParamId
WHERE (SF.ParamId != 723 OR SF.ParameterName = 'Commserv Database Size')
ORDER BY SF.Id
--As far as scalability is concerned, info = good.
UPDATE @tblParameters
SET HealthStatus = @strGood
WHERE HealthStatus NOT IN (@strCritical, @strWarning, @strGood)
SELECT ParameterName AS Parameter,
	HealthResult as Result,
	HealthStatus as 'Status<HEALTH_STATUS>'
FROM @tblParameters
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCommcellScalability')
	delete from GxQscripts where name = 'RptCommcellScalability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCommcellScalability')
	delete from GXDBVersions where aliasname = 'RptCommcellScalability'
GO

insert into GXDBVersions values(2, 'RptCommcellScalability',  '00010001000200010000', 'RptCommcellScalability', '00010001000200010000')
GO

