

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptCloudNodeInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptCloudNodeInfo.sp,v $ $Id: RptCloudNodeInfo.sp,v 1.11.14.10 2019/06/20 17:46:13 dnavaneethan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptCloudNodeInfo')
BEGIN
	print '>>> Drop Stored Procedure: RptCloudNodeInfo <<<'
	drop procedure RptCloudNodeInfo
END
IF EXISTS (select * from GxQscripts where name='RptCloudNodeInfo')
	delete from GxQscripts where name = 'RptCloudNodeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCloudNodeInfo')
	delete from GXDBVersions where aliasname = 'RptCloudNodeInfo'
GO
print '... Creating Procedure: RptCloudNodeInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptCloudNodeInfo
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
SET @blLatestSurvey = 1 --Always pickup the latest
DECLARE @i_QueryId BIGINT = 161
DECLARE @strGood VARCHAR(10) = '1_Good'
	DECLARE @strInfo VARCHAR(10) = '2_Info'
	DECLARE @strwarning VARCHAR(10) = '3_Warning'
	DECLARE @strCritical VARCHAR(10) = '4_Critical'
DECLARE @segCountCritical INT  =512
DECLARE @segCountWarning INT  = 256
DECLARE @tiiFileSizeLimit INT  = 600
DECLARE @successfulObjectCritical INT  = 40
DECLARE @successfulObjectWarning INT  = 20
DECLARE @tiiFileSizeCritical INT  = 600
DECLARE @driveFreeSpaceCritical INT  = 35
DECLARE @driveFreeSpaceWarning INT  = 50
DECLARE @isSearchOnly INT  = 1
IF(@i_CommServUniqueID = 0)
IF(@blaggregate = 0 )
BEGIN
	SELECT
		resultView.CommServUniqueId  AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID<HIDDEN>',
		resultView.DisplayName AS 'CommCell Name'
		, csInfo.CloudName  AS 'Cloud Name'
		, csInfo.NodeName  AS 'Node Name'
		, csInfo.SegmentCount  AS 'Fragmentation Count<FORMATNUMBERNA>'
		, csInfo.TermIndexFileSizeMB  AS 'Search Engine File Size<SIZEMB>'
		, csInfo.DocumentCount  AS 'Document Count<FORMATNUMBERNA>'
		, csInfo.FreeSpaceMB  AS 'Free Disk Space<SIZEMB>'
		, csInfo.PruneDataCount  AS 'Prune Data Count<FORMATNUMBERNA>'
		,CASE WHEN (	ISNULL(csInfo.isSearchOnly, 0)  = @isSearchOnly
					 )
				THEN @strGood
			WHEN (	 csInfo.SegmentCount							 >	 @segCountCritical
						 OR  (csInfo.TermIndexFileSizeMB             >   @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) > @successfulObjectCritical )
						 OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >	 csInfo.FreeSpaceMB
						 OR  csInfo.FreeSpaceMB = 0
						 )
					THEN @strCritical
			 WHEN (	 csInfo.SegmentCount								 >=	 @segCountWarning
				     OR  (csInfo.TermIndexFileSizeMB                     >=  @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) >= @successfulObjectWarning)
					 OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    >	csInfo.FreeSpaceMB
					 )
				THEN @strwarning
			  ELSE @strGood
		END as 'Status<HEALTH_STATUS>'
		FROM cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY [Status<HEALTH_STATUS>] DESC,'CommCell Name' , csInfo.CloudName,  csInfo.NodeName
END
ELSE
BEGIN
		SELECT
		csInfo.CloudName  AS 'Search Engine Name'
		,max(csInfo.PruneDataCount)  AS 'Prune Data Count<FORMATNUMBERNA>'
		FROM cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		GROUP BY csInfo.CloudName
		ORDER BY csInfo.CloudName
END
ELSE
BEGIN
IF(@blaggregate = 0 )
BEGIN
	SELECT
		csInfo.CloudName  AS 'Cloud Name'
		, csInfo.NodeName  AS 'Node Name'
		, csInfo.SegmentCount  AS 'Fragmentation Count<FORMATNUMBERNA>'
		, csInfo.TermIndexFileSizeMB  AS 'Search Engine File Size<SIZEMB>'
		, csInfo.DocumentCount  AS 'Document Count<FORMATNUMBERNA>'
		, csInfo.FreeSpaceMB  AS 'Free Disk Space<SIZEMB>'
		, csInfo.PruneDataCount  AS 'Prune Data Count<FORMATNUMBERNA>'
		,CASE WHEN (	ISNULL(csInfo.isSearchOnly, 0)  = @isSearchOnly
					 )
				THEN @strGood
				WHEN (	 csInfo.SegmentCount							 >	 @segCountCritical
							 OR  (csInfo.TermIndexFileSizeMB             >   @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) > @successfulObjectCritical )
							 OR  (csInfo.IndexSizeMB*@driveFreeSpaceCritical)/100.0    >	 csInfo.FreeSpaceMB
							 OR  csInfo.FreeSpaceMB = 0
							 )
				THEN @strCritical
			 WHEN (	 csInfo.SegmentCount								 >=	 @segCountWarning
				     OR  (csInfo.TermIndexFileSizeMB                     >=  @tiiFileSizeLimit AND (csInfo.TermIndexFileSizeMB*1000000/NULLIF(csInfo.DocumentCount,0)) >= @successfulObjectWarning)
					 OR  (csInfo.IndexSizeMB*@driveFreeSpaceWarning)/100.0    >	csInfo.FreeSpaceMB
					 )
				THEN @strwarning
			  ELSE @strGood
		END as 'Status<HEALTH_STATUS>'
		FROM cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		ORDER BY [Status<HEALTH_STATUS>] DESC,csInfo.CloudName ,  csInfo.NodeName
END
ELSE
BEGIN
	SELECT
		csInfo.CloudName  AS 'Search Engine Name'
		,max(csInfo.PruneDataCount)  AS 'Prune Data Count<FORMATNUMBERNA>'
		FROM cf_SurveyCloudNodeInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
		ON resultView.SurverResultId = csInfo.SurveyResultId
		GROUP BY csInfo.CloudName
		ORDER BY csInfo.CloudName desc
END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptCloudNodeInfo')
	delete from GxQscripts where name = 'RptCloudNodeInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptCloudNodeInfo')
	delete from GXDBVersions where aliasname = 'RptCloudNodeInfo'
GO

insert into GXDBVersions values(2, 'RptCloudNodeInfo',  '00010011001400100000', 'RptCloudNodeInfo', '00010011001400100000')
GO

