

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptClientStatisticsSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptClientStatisticsSurvey.sp,v $ $Id: RptClientStatisticsSurvey.sp,v 1.11.56.5 2019/06/29 15:35:40 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptClientStatisticsSurvey')
BEGIN
	print '>>> Drop Stored Procedure: RptClientStatisticsSurvey <<<'
	drop procedure RptClientStatisticsSurvey
END
IF EXISTS (select * from GxQscripts where name='RptClientStatisticsSurvey')
	delete from GxQscripts where name = 'RptClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'RptClientStatisticsSurvey'
GO
print '... Creating Procedure: RptClientStatisticsSurvey'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptClientStatisticsSurvey
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 8
IF @blaggregate = 1
BEGIN
	DECLARE @nonlaptopClients INTEGER = 0
	DECLARE @laptopclients INTEGER = 0
	DECLARE @discoveredVMs INTEGER = 0
	SELECT
		@nonlaptopClients  = ISNULL(SUM(csInfo.TotalActiveClients-csInfo.TotalLaptops-csInfo.TotalActiveVMs), 0),
		@laptopclients = ISNULL(SUM(csInfo.TotalLaptops), 0),
		@discoveredVMs = ISNULL(SUM(csInfo.TotalActiveVMs), 0)
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
			AND resultView.LogDateUTC = csInfo.LogDateUTC
			AND resultView.CommServUniqueId = csInfo.CommServUniqueId
	SELECT 'Active Laptops' AS [Clients], @laptopclients AS [Count]
	UNION
	SELECT 'Active Servers' AS [Clients], @nonlaptopClients AS [Count]
	UNION
	SELECT 'Active VMs' AS [Clients], @discoveredVMs AS [Count]
END
ELSE
BEGIN
IF @i_CommServUniqueID = 0
BEGIN
	SELECT
		resultView.CommServUniqueId AS 'CommServ UniqueId',
		resultView.CommCellID AS 'CommCell ID',
		resultView.CommServIP AS 'CommServe IP<HIDDEN>',
		resultView.DisplayName AS 'CommCell Name',
		ISNULL(csInfo.TotalActiveClients, 0) - ISNULL(csInfo.TotalLaptops, 0) - ISNULL(csInfo.TotalActiveVMs, 0) AS 'Active Servers',
		ISNULL(csInfo.TotalLaptops, 0) AS 'Active Laptop Clients',
		ISNULL(csInfo.TotalActiveVMs, 0) AS 'Active VMs',
		ISNULL(csInfo.TotalDeconfiguredClients, 0) + ISNULL(csInfo.TotalUninstalledClients, 0) AS 'Deconfigured Clients<HIDDEN>',
		ISNULL(csInfo.RestoreonlyClients, 0) AS 'Deconfigured Restoreonly Clients<HIDDEN>',
		ISNULL(csInfo.TotalClients, 0) AS 'Total Clients<HIDDEN>',
		ISNULL(csInfo.UninstalledVirtualServerDiscoveredClients, 0) AS 'Total VMs<HIDDEN>'
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY 'CommCell Name' ASC
END
ELSE
	SELECT
		csInfo.CommServUniqueId AS 'CommServ UniqueId',
		DATEDIFF(s, '1970-01-01 00:00:00', ISNULL(csInfo.LogDate, '1970-01-01 00:00:00')) AS 'Collection Time<DATETIME>',
		CASE
			WHEN resultView.RunningTime = -1 THEN 'N/A'
			ELSE CAST(resultView.RunningTime AS VARCHAR(MAX))
		END AS 'Running Time in Seconds',
		ISNULL(csInfo.TotalActiveClients, 0) - ISNULL(csInfo.TotalLaptops, 0) - ISNULL(csInfo.TotalActiveVMs, 0) AS 'Active Servers',
		ISNULL(csInfo.TotalLaptops, 0) AS 'Active Laptops',
		ISNULL(csInfo.TotalActiveVMs, 0) AS 'Active VMs',
		ISNULL(csInfo.TotalDeconfiguredClients, 0) + ISNULL(csInfo.TotalUninstalledClients, 0) AS 'Deconfigured Clients<HIDDEN>',
		ISNULL(csInfo.RestoreonlyClients, 0) AS 'Deconfigured Restoreonly Clients<HIDDEN>',
		ISNULL(csInfo.TotalClients, 0) AS 'Total Clients<HIDDEN>',
		ISNULL(csInfo.UninstalledVirtualServerDiscoveredClients, 0) AS 'Total VMs<HIDDEN>'
	FROM cf_SurveyClientStatisticsInfo AS csInfo WITH (NOLOCK)
		INNER JOIN dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId,@i_GroupId) AS resultView
			ON resultView.SurverResultId = csInfo.SurveyResultId
	ORDER BY csInfo.LogDateUTC DESC
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptClientStatisticsSurvey')
	delete from GxQscripts where name = 'RptClientStatisticsSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptClientStatisticsSurvey')
	delete from GXDBVersions where aliasname = 'RptClientStatisticsSurvey'
GO

insert into GXDBVersions values(2, 'RptClientStatisticsSurvey',  '00010011005600050000', 'RptClientStatisticsSurvey', '00010011005600050000')
GO

