

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBkpDataRetention.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBkpDataRetention.sp,v $ $Id: RptBkpDataRetention.sp,v 1.3.56.8 2020/12/17 02:50:23 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptBkpDataRetention')
BEGIN
	print '>>> Drop Stored Procedure: RptBkpDataRetention <<<'
	drop procedure RptBkpDataRetention
END
IF EXISTS (select * from GxQscripts where name='RptBkpDataRetention')
	delete from GxQscripts where name = 'RptBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpDataRetention')
	delete from GXDBVersions where aliasname = 'RptBkpDataRetention'
GO
print '... Creating Procedure: RptBkpDataRetention'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptBkpDataRetention
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll
AS
SET NOCOUNT ON
DECLARE @i_QueryId BIGINT = 141
SET @blLatestSurvey = 1
IF object_id('tempdb.dbo.#LatestResult') IS NOT NULL DROP TABLE #LatestResult
CREATE TABLE #LatestResult (SurveyResultId BIGINT, CommServUniqueId INT, DisplayName NVARCHAR(256))
INSERT	INTO #LatestResult
SELECT	SurverResultId, CommServUniqueId, DisplayName
FROM	dbo.cf_SurveyResultFuncV1(@i_QueryId, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND, @i_UserId, @i_GroupId)
IF (@blaggregate = -1)
BEGIN
	IF object_id('tempdb.dbo.#SourceCopy') IS NOT NULL DROP TABLE #SourceCopy
	CREATE TABLE #SourceCopy (CommServUniqueId INT, PolicyId INT, CopyId INT, IsSnapCopy INT, IsSelectiveCopy INT,
			SourceCopyId INT, SourceCopyName NVARCHAR(64))
	INSERT	INTO #SourceCopy
	SELECT	C.CommServUniqueId, C.PolicyId, C.CopyId, C.IsSnapCopy, 0, C.SourceCopyId, 'N/A'
	FROM	cf_SurveyCopyBasicRetention C WITH (NOLOCK)
			INNER JOIN #LatestResult AS R ON R.CommServUniqueId = C.CommServUniqueId
	WHERE	C.IsDefaultCopy = 0
	UPDATE	S SET SourceCopyName = C.CopyName
	FROM	#SourceCopy S
			INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK)
				ON S.CommServUniqueId = C.CommServUniqueId AND S.PolicyId = C.PolicyId AND S.IsSnapCopy = C.IsSnapCopy
				AND (S.SourceCopyId = C.CopyId OR S.SourceCopyId <= 0 AND C.IsDefaultCopy = 1)
	UPDATE	S SET IsSelectiveCopy = 1
	FROM	#SourceCopy S
			INNER JOIN cf_SurveyArchSelectiveCopy C WITH (NOLOCK)
				ON S.CommServUniqueId = C.CommServUniqueId AND S.CopyId = C.CopyId
	IF @i_CommServUniqueID > 0
		SELECT
			C.PolicyName					AS 'Storage Policy',
			C.CopyName						AS 'Copy',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Primary' WHEN ISNULL(S.IsSelectiveCopy, 0) = 1 THEN 'Selective Copy'
				ELSE 'Synchronous Copy' END	AS 'Copy Type',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'N/A' ELSE ISNULL(S.SourceCopyName, '') END
											AS 'Source Copy',
			csInfo.AgeIn30DaysMB + csInfo.AgeIn30To90DaysMB + csInfo.AgeIn90To365DaysMB + csInfo.AgeAfter365DaysMB
											AS 'Total Size On Media<SIZEMB>',
			csInfo.AgeIn30DaysMB			AS '30 Days<SIZEMB>',
			csInfo.AgeIn30To90DaysMB		AS '30 To 90 Days<SIZEMB>',
			csInfo.AgeIn90To365DaysMB		AS '90 To 365 Days<SIZEMB>',
			csInfo.AgeAfter365DaysMB		AS 'Above 365 Days<SIZEMB>',
			C.RetentionDays					AS 'Basic Retention Days',
			CASE WHEN C.ExtRretentionRules > 0 THEN 'Yes' ELSE 'No' END
											AS 'Extended Retention',
			CASE WHEN C.DedupeFlags > 0 THEN 'Yes' ELSE 'No' END
											AS 'Deduplication',
			L.LibraryName					AS 'Library',
			CASE L.LibraryTypeId WHEN 3 THEN 'Disk' WHEN -3 THEN 'Cloud' ELSE 'Tape' END
											AS  'Library Type'
		FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
			INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK) ON resultView.CommServUniqueId = C.CommServUniqueId AND csInfo.CopyId = C.CopyId
			INNER JOIN cf_SurveyLibrary L WITH (NOLOCK) ON C.CommServUniqueId = L.CommServUniqueId AND C.DefaultLibraryID = L.LibraryId
			LEFT OUTER JOIN #SourceCopy S ON C.CommServUniqueId = S.CommServUniqueId AND C.CopyId = S.CopyId
		WHERE csInfo.CopyId > 0
		ORDER BY 'Storage Policy', 'Copy Type'
	ELSE
		SELECT
			resultView.CommServUniqueId		AS 'CommServ UniqueId<DONOTSHOW>',
			resultView.DisplayName			AS 'CommCell Name',
			C.PolicyName					AS 'Storage Policy',
			C.CopyName						AS 'Copy',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'Primary' WHEN ISNULL(S.IsSelectiveCopy, 0) = 1 THEN 'Selective Copy'
				ELSE 'Synchronous Copy' END	AS 'Copy Type',
			CASE WHEN C.IsDefaultCopy = 1 THEN 'N/A' ELSE ISNULL(S.SourceCopyName, '') END
											AS 'Source Copy',
			csInfo.AgeIn30DaysMB + csInfo.AgeIn30To90DaysMB + csInfo.AgeIn90To365DaysMB + csInfo.AgeAfter365DaysMB
											AS 'Total Size On Media<SIZEMB>',
			csInfo.AgeIn30DaysMB			AS '30 Days<SIZEMB>',
			csInfo.AgeIn30To90DaysMB		AS '30 To 90 Days<SIZEMB>',
			csInfo.AgeIn90To365DaysMB		AS '90 To 365 Days<SIZEMB>',
			csInfo.AgeAfter365DaysMB		AS 'Above 365 Days<SIZEMB>',
			C.RetentionDays					AS 'Basic Retention Days',
			CASE WHEN C.ExtRretentionRules > 0 THEN 'Yes' ELSE 'No' END
											AS 'Extended Retention',
			CASE WHEN C.DedupeFlags > 0 THEN 'Yes' ELSE 'No' END
											AS 'Deduplication',
			L.LibraryName					AS 'Library',
			CASE L.LibraryTypeId WHEN 3 THEN 'Disk' WHEN -3 THEN 'Cloud' ELSE 'Tape' END
											AS  'Library Type'
		FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
			INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
			INNER JOIN cf_SurveyCopyBasicRetention C WITH (NOLOCK) ON resultView.CommServUniqueId = C.CommServUniqueId AND csInfo.CopyId = C.CopyId
			INNER JOIN cf_SurveyLibrary L WITH (NOLOCK) ON C.CommServUniqueId = L.CommServUniqueId AND C.DefaultLibraryID = L.LibraryId
			LEFT OUTER JOIN #SourceCopy S ON C.CommServUniqueId = S.CommServUniqueId AND C.CopyId = S.CopyId
		WHERE csInfo.CopyId > 0
		ORDER BY 'CommCell Name', 'Storage Policy', 'Copy Type'
END
ELSE
IF(@blaggregate=1)
BEGIN
	SELECT
	(SUM(csInfo.AgeIn30DaysMB))				AS '30 Days<SIZEMB>',
	(SUM(csInfo.AgeIn30To90DaysMB))			AS '30 To 90 Days<SIZEMB>',
	(SUM(csInfo.AgeIn90To365DaysMB))		AS '90 To 365 Days<SIZEMB>',
	(SUM(csInfo.AgeAfter365DaysMB))			AS 'Above 365 Days<SIZEMB>'
	FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE csInfo.CopyId = 0
END
ELSE
BEGIN
	SELECT
	resultView.CommServUniqueId			AS 'CommServ UniqueId<DONOTSHOW>',
	resultView.DisplayName				AS 'CommCell Name',
	csInfo.AgeIn30DaysMB 				AS '30 Days<SIZEMB>',
	csInfo.AgeIn30To90DaysMB 			AS '30 To 90 Days<SIZEMB>',
	csInfo.AgeIn90To365DaysMB 			AS '90 To 365 Days<SIZEMB>',
	csInfo.AgeAfter365DaysMB 			AS 'Above 365 Days<SIZEMB>'
	FROM cf_SurveyBkpDataRetention AS csInfo WITH (NOLOCK)
		INNER JOIN #LatestResult AS resultView ON resultView.SurveyResultId = csInfo.SurveyResultId
	WHERE csInfo.CopyId = 0
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBkpDataRetention')
	delete from GxQscripts where name = 'RptBkpDataRetention'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBkpDataRetention')
	delete from GXDBVersions where aliasname = 'RptBkpDataRetention'
GO

insert into GXDBVersions values(2, 'RptBkpDataRetention',  '00010003005600080000', 'RptBkpDataRetention', '00010003005600080000')
GO

