

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBillingAssociation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBillingAssociation.sp,v $ $Id: RptBillingAssociation.sp,v 1.11.2.5 2020/12/02 16:52:17 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='RptBillingAssociation')
BEGIN
	print '>>> Drop Stored Procedure: RptBillingAssociation <<<'
	drop procedure RptBillingAssociation
END
IF EXISTS (select * from GxQscripts where name='RptBillingAssociation')
	delete from GxQscripts where name = 'RptBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingAssociation')
	delete from GXDBVersions where aliasname = 'RptBillingAssociation'
GO
print '... Creating Procedure: RptBillingAssociation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure RptBillingAssociation
  @i_UserId INT = -1,
  @i_EntityId INT,
  @i_AllAssociated INT = 1,
  @i_CellUniqueId INT = 0,
  @i_ClientGroupId INT = 0,
  @i_ClientId INT = 0,
  @i_AppTypeId INT = 0,
  @i_InstanceId INT = 0,
  @i_BackupsetId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_AllAssociated = 1
BEGIN
	CREATE TABLE #CommCell (CommServUniqueId INT)
	CREATE TABLE #Client (CommServUniqueId INT, ClientId INT, ClientName NVARCHAR(256), ClientDisplayName NVARCHAR(256))
	CREATE TABLE #Agent (CommServUniqueId INT, AppTypeId INT, AgentName NVARCHAR(256), ArchiveEnabled INT)
	CREATE TABLE #Instance (CommServUniqueId INT, ClientId INT, AppTypeId INT, InstanceId INT, InstanceName NVARCHAR(256))
	CREATE TABLE #Backupset (CommServUniqueId INT, BackupsetId INT, BackupsetName NVARCHAR(256))
	CREATE TABLE #Subclient (CommServUniqueId INT, AppId INT, SubclientName NVARCHAR(256), OnePassEnabled INT)
	INSERT	INTO  #CommCell
	SELECT	CommServUniqueId
	FROM	dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId, -1)
	INSERT	INTO #Client
	SELECT	U.CommServUniqueId, U.ClientId, U.ClientName, ISNULL (CL.ClientDisplayName, U.clientName)
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.ClientId = M.ClientId AND M.ClientId > 0 AND @i_EntityId IN (0, M.EntityID)
			LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
		   ON CL.CommServUniqueId = U.CommServUniqueId  AND CL.clientId = U.clientId
	GROUP BY U.CommServUniqueId, U.ClientId, U.ClientName, ISNULL (CL.ClientDisplayName, U.clientName)
	INSERT	INTO #Agent
	SELECT	U.CommServUniqueId, U.AppTypeId, U.AgentName, MAX(U.Archive1PassFlags&1)
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.AppTypeId = M.AppTypeId AND M.AppTypeId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.AppTypeId, U.AgentName
	INSERT	INTO #Instance
	SELECT	U.CommServUniqueId, U.ClientId, U.AppTypeId, U.InstanceId, U.InstanceName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.ClientId = M.ClientId AND U.AppTypeId = M.AppTypeId AND U.InstanceId = M.InstanceId
				AND M.ClientId > 0 AND M.AppTypeId > 0 AND M.InstanceId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.ClientId, U.AppTypeId, U.InstanceId, U.InstanceName
	INSERT	INTO #Backupset
	SELECT	U.CommServUniqueId, U.BackupsetId, U.BackupsetName
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.ClientId = M.ClientId AND U.AppTypeId = M.AppTypeId
				AND U.InstanceId = M.InstanceId AND U.BackupsetId = M.BackupsetId
				AND M.BackupsetId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.BackupsetId, U.BackupsetName
	INSERT	INTO #Subclient
	SELECT	U.CommServUniqueId, U.AppId, U.SubclientName, MAX(U.Archive1PassFlags&2)
	FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveySubclientAssociation U
				ON U.CommServUniqueId = M.CommServUniqueId AND U.AppId = M.AppId AND M.AppId > 0 AND @i_EntityId IN (0, M.EntityID)
	GROUP BY U.CommServUniqueId, U.AppId, U.SubclientName
	IF @i_EntityId > 0
		SELECT	CC.ID AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			M.ClientGroupId AS 'Client Group ID<DONOTSHOW>',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			M.ClientId AS 'Client ID<DONOTSHOW>',
			ISNULL(CL.ClientName, '') AS 'Client',
			M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
			ISNULL(A.AgentName, '') AS 'Agent',
			M.InstanceId AS 'InstanceId ID<DONOTSHOW>',
			ISNULL(I.InstanceName, '') AS 'Instance',
			M.BackupsetId AS 'Backupset ID<DONOTSHOW>',
			ISNULL(B.BackupsetName, '') AS 'Backupset',
			M.AppId AS 'App ID<DONOTSHOW>',
			ISNULL(S.SubclientName, '') AS 'Subclient',
			CASE A.ArchiveEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE S.OnePassEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled'
		FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_CommcellIdNameMap CC ON M.CommServUniqueId = CC.ID AND M.EntityID = @i_EntityId
			LEFT OUTER JOIN cf_SurveyClientGroup CG ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #Client CL ON M.CommServUniqueId = CL.CommServUniqueId AND M.ClientId = CL.ClientId
			LEFT OUTER JOIN #Agent A ON M.CommServUniqueId = A.CommServUniqueId AND M.AppTypeId = A.AppTypeId
			LEFT OUTER JOIN #Instance I ON M.CommServUniqueId = I.CommServUniqueId AND M.ClientId = I.ClientId AND M.AppTypeId = I.AppTypeId AND M.InstanceId = I.InstanceId
			LEFT OUTER JOIN #Backupset B ON M.CommServUniqueId = B.CommServUniqueId AND M.BackupsetId = B.BackupsetId
			LEFT OUTER JOIN #Subclient S ON M.CommServUniqueId = S.CommServUniqueId AND M.AppId = S.AppId
		WHERE	M.AppTypeId = 0 OR M.ClientId > 0
		ORDER BY CC.CommServName, 'Client Group', 'Client', 'Agent','Instance','Backupset','Subclient'
	ELSE
		SELECT	E.ID AS 'Tag ID<DONOTSHOW>',
			E.Name AS 'Tag Name',
			CC.ID AS 'CommServ UniqueId<DONOTSHOW>',
			CC.CommServName AS 'CommCell Name',
			M.ClientGroupId AS 'Client Group ID<DONOTSHOW>',
			ISNULL(CG.ClientGroupName, '') AS 'Client Group',
			M.ClientId AS 'Client ID<DONOTSHOW>',
			ISNULL(CL.ClientDisplayName, '') AS 'Client',
			ISNULL(CL.ClientName, '') AS 'Client(classic)<HIDDEN>',
			M.AppTypeId AS 'Agent Type ID<DONOTSHOW>',
			ISNULL(A.AgentName, '') AS 'Agent',
			M.InstanceId AS 'InstanceId ID<DONOTSHOW>',
			ISNULL(I.InstanceName, '') AS 'Instance',
			M.BackupsetId AS 'Backupset ID<DONOTSHOW>',
			ISNULL(B.BackupsetName, '') AS 'Backupset',
			M.AppId AS 'App ID<DONOTSHOW>',
			ISNULL(S.SubclientName, '') AS 'Subclient',
			CASE A.ArchiveEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE S.OnePassEnabled WHEN 1 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled'
		FROM	cf_SurveyBillingEntityMember M
			INNER JOIN #CommCell C ON M.CommServUniqueId = C.CommServUniqueId
			INNER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
			INNER JOIN cf_CommcellIdNameMap CC ON M.CommServUniqueId = CC.ID
			LEFT OUTER JOIN cf_SurveyClientGroup CG ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN #Client CL ON M.CommServUniqueId = CL.CommServUniqueId AND M.ClientId = CL.ClientId
			LEFT OUTER JOIN #Agent A ON M.CommServUniqueId = A.CommServUniqueId AND M.AppTypeId = A.AppTypeId
			LEFT OUTER JOIN #Instance I ON M.CommServUniqueId = I.CommServUniqueId AND M.ClientId = I.ClientId AND M.AppTypeId = I.AppTypeId AND M.InstanceId = I.InstanceId
			LEFT OUTER JOIN #Backupset B ON M.CommServUniqueId = B.CommServUniqueId AND M.BackupsetId = B.BackupsetId
			LEFT OUTER JOIN #Subclient S ON M.CommServUniqueId = S.CommServUniqueId AND M.AppId = S.AppId
		WHERE	M.AppTypeId = 0 OR M.ClientId > 0
		ORDER BY E.Name, CC.CommServName, 'Client Group', 'Client', 'Agent','Instance','Backupset','Subclient'
	DROP TABLE #CommCell
	DROP TABLE #Client
	DROP TABLE #Agent
	DROP TABLE #Instance
	DROP TABLE #Backupset
	DROP TABLE #Subclient
END
ELSE
IF @i_CellUniqueId = 0
	SELECT	C.ID AS 'CommServ UniqueId',
			C.CommServName AS 'CommCell Name',
			CASE WHEN M.CommServUniqueId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_CommcellIdNameMap C
			INNER JOIN dbo.cf_SurveyResultFuncV1(2, 0, 1, NULL, NULL, @i_UserId,-1) R ON R.CommServUniqueId = C.ID
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId FROM cf_SurveyBillingEntityMember
			WHERE ClientGroupId = 0 AND ClientId = 0
			) M ON M.CommServUniqueId = C.ID
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	(C.CommCellSurveyServices&32) = 32
	ORDER BY C.CommServName
ELSE
IF @i_ClientGroupId = 0
	SELECT	-1 AS 'Client Group ID',
			'All Clients' AS 'Client Group Name',
			0 AS 'Associated',
			0 AS 'Tag ID',
			'' AS 'Tag Name'
	UNION
	SELECT	CG.ClientGroupId AS 'Client Group ID',
			CG.ClientGroupName AS 'Client Group Name',
			CASE WHEN M.ClientGroupId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyClientGroup CG
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId, ClientGroupId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientGroupId > 0 AND ClientId = 0
			) M ON M.CommServUniqueId = CG.CommServUniqueId AND M.ClientGroupId = CG.ClientGroupId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	CG.CommservUniqueId = @i_CellUniqueId AND CG.DeletedDate IS NULL
	ORDER BY 'Client Group Name'
ELSE
IF @i_ClientGroupId = -1 AND @i_ClientId = 0
	SELECT	CL.ClientId AS 'Client ID',
			ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client Name',
			CL.ClientName  AS 'Client(classic)<HIDDEN>',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyClient CL WITH (NOLOCK)
			LEFT OUTER JOIN
			(SELECT EntityID, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.ClientId = CL.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	CL.CommServUniqueId = @i_CellUniqueId AND CL.Deleted = 0
	ORDER BY 'Client Name'
ELSE
IF @i_ClientGroupId > 0 AND @i_ClientId = 0
	SELECT	CL.ClientId AS 'Client ID',
			ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client Name',
			CL.ClientName AS 'Client(classic)<HIDDEN>',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyClient CL WITH (NOLOCK)
			INNER JOIN cf_SurveyClientGroupAssociation CGA
				ON CGA.CommServUniqueId = @i_CellUniqueId AND CGA.ClientGroupId = @i_ClientGroupId AND CGA.ClientId = CL.ClientId
			LEFT OUTER JOIN
			(SELECT EntityID, CommServUniqueId, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientGroupId = @i_ClientGroupId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.CommServUniqueId = CGA.CommServUniqueId AND M.ClientId = CGA.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	CL.CommServUniqueId = @i_CellUniqueId AND CL.Deleted = 0
	ORDER BY 'Client Name'
ELSE
IF @i_ClientGroupId = -1 AND @i_ClientId = 0
	SELECT	CL.ClientId AS 'Client ID',
			ISNULL(CL.ClientDisplayName, CL.ClientName) AS 'Client Name',
			CL.ClientName AS 'Client(classic)<HIDDEN>',
			CASE WHEN M.ClientId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	cf_SurveyClient CL
			LEFT OUTER JOIN
			(SELECT EntityID, ClientId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId > 0 AND AppTypeId = 0
			) M ON M.ClientId = CL.ClientId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	WHERE	CL.CommServUniqueId = @i_CellUniqueId AND CL.Deleted = 0
	ORDER BY 'Client Name'
ELSE
IF @i_ClientId > 0 AND @i_AppTypeId = 0
	SELECT	U.AppTypeId AS 'AppType ID',
			U.AgentName AS 'Agent Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.AppTypeId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT AppTypeId, AgentName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND Deleted = 0
			GROUP BY AppTypeId, AgentName) U
			LEFT OUTER JOIN
			(SELECT EntityID, AppTypeId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId
				AND AppTypeId > 0 AND InstanceId = 0
			) M ON M.AppTypeId = U.AppTypeId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.AgentName
ELSE
IF @i_AppTypeId > 0 AND @i_InstanceId = 0
	SELECT	U.InstanceId AS 'Instance ID',
			U.InstanceName AS 'Instance Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.InstanceId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, 'N/A') AS 'Tag Name'
	FROM	(SELECT DISTINCT InstanceId, InstanceName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId AND Deleted = 0
			GROUP BY InstanceId, InstanceName) U
			LEFT OUTER JOIN
			(SELECT EntityID, InstanceId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId > 0 AND BackupsetId = 0 AND AppId = 0
			) M ON M.InstanceId = U.InstanceId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.InstanceName
ELSE
IF @i_InstanceId > 0 AND @i_BackupsetId = 0
	SELECT	U.BackupsetId AS 'Backupset ID',
			U.BackupsetName AS 'Backupset Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			'N/A' AS 'OnePass Enabled',
			CASE WHEN M.BackupsetId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, 'N/A') AS 'Tag Name'
	FROM	(SELECT DISTINCT BackupsetId, BackupsetName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND Deleted = 0
			GROUP BY BackupsetId, BackupsetName) U
			LEFT OUTER JOIN
			(SELECT EntityID, BackupsetId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId > 0 AND AppId = 0
			) M ON M.BackupsetId = U.BackupsetId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.BackupsetName
ELSE
IF @i_BackupsetId > 0
	SELECT	U.AppId AS 'Backupset ID',
			U.SubclientName AS 'Subclient Name',
			CASE U.Archive1PassFlags&1 WHEN 1 THEN 'Yes' ELSE 'No' END AS 'Archive Enabled',
			CASE U.Archive1PassFlags&2 WHEN 2 THEN 'Yes' ELSE 'No' END AS 'OnePass Enabled',
			CASE WHEN M.AppId IS NULL THEN 0 ELSE 1 END AS 'Associated',
			ISNULL(E.ID, 0) AS 'Tag ID',
			ISNULL(E.Name, '') AS 'Tag Name'
	FROM	(SELECT AppId, SubclientName, MAX(Archive1PassFlags) AS Archive1PassFlags FROM cf_SurveySubclientAssociation
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId AND Deleted = 0
			GROUP BY AppId, SubclientName) U
			LEFT OUTER JOIN
			(SELECT EntityID, AppId FROM cf_SurveyBillingEntityMember
			WHERE CommServUniqueId = @i_CellUniqueId AND ClientId = @i_ClientId AND AppTypeId = @i_AppTypeId
				AND InstanceId = @i_InstanceId AND BackupsetId = @i_BackupsetId AND AppId > 0
			) M ON M.AppId = U.AppId
			LEFT OUTER JOIN cf_SurveyBillingEntity E ON M.EntityID = E.ID
	ORDER BY U.SubclientName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'RptBillingAssociation')
	delete from GxQscripts where name = 'RptBillingAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBillingAssociation')
	delete from GXDBVersions where aliasname = 'RptBillingAssociation'
GO

insert into GXDBVersions values(2, 'RptBillingAssociation',  '00010011000200050000', 'RptBillingAssociation', '00010011000200050000')
GO

