

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptBackupOperations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptBackupOperations.sp,v $ $Id: RptBackupOperations.sp,v 1.7.2.1 2018/08/16 11:32:35 skatz Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: RptBackupOperations <<<'

IF EXISTS (select * from sysobjects where name='RptBackupOperations')
	drop procedure RptBackupOperations
IF EXISTS (select * from GxQscripts where name='RptBackupOperations')
	delete from GxQscripts where name = 'RptBackupOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupOperations')
	delete from GXDBVersions where aliasname = 'RptBackupOperations'
GO
print '... Creating Procedure: RptBackupOperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptBackupOperations
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#SubclientTable') IS NOT NULL DROP TABLE #SubclientTable
IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
CREATE TABLE #SubclientTable (
	CommservUniqueId INT,
	CommCellID INT,
	CommServName NVARCHAR(256),
	ClientID INT,
	ClientName NVARCHAR(256),
	PhysicalClientName NVARCHAR(256),
	AgentID INT,
	AgentName VARCHAR(256),
	InstanceID INT,
	InstanceName NVARCHAR(512),
	BackupsetID INT,
	BackupsetName NVARCHAR(128),
	SubclientID INT,
	SubclientName NVARCHAR(128),
	DailySchRetentionDays INT,
	WeeklySchRetentionDays INT,
	MonthlySchRetentionDays INT,
	PolicyId INT,
	OnHoliday INT
	)
INSERT INTO #SubclientTable
SELECT
	C.ID,
    CAST(C.CommCellID AS INT),
    C.CommServName,
    S.ClientId,
    S.ClientName,
    PhysicalClientName,
    S.AppTypeId,
    S.AgentName,
    S.InstanceId,
    S.InstanceName,
    S.BackupsetId,
    S.BackupsetName,
    S.AppId,
    S.SubclientName,
	0, 	0, 	0,
	S.DataPolicyId,
	0
FROM
    cf_SurveySubclientAssociation AS S WITH (NOLOCK)
    INNER JOIN cf_CommcellIdNameMap AS C WITH (NOLOCK)
        ON C.ID = S.CommservUniqueId AND (S.SubclientStatus & (2|4)) = 0
		AND S.Deleted = 0
--Daily backups => Daily or Weekly incremental schedules
UPDATE #SubclientTable
SET DailySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Incremental' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Daily backups => Weekly full schedules scheduled for more than one day
UPDATE #SubclientTable
SET DailySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Weekly' AND CHARINDEX(' ', RTRIM(SchedBackupDay)) > 0 AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Weekly and Monthly backups => Weekly full schedules
UPDATE #SubclientTable
SET WeeklySchRetentionDays = 1, MonthlySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Weekly' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
--Daily and Weekly backups for Exch 2010 => Monthly Full and Monthly Pre-Selected Backup Type
DECLARE @Exch2010Sch TABLE(CCID INT, CId INT, SCId INT, IsMonFullSet INT, IsMonIncrSet INT)
INSERT INTO @Exch2010Sch
SELECT DISTINCT	CommCellID, ClientID, SubclientID, 1, 0 FROM BackupSchedules WHERE AgentID = 53 AND SchedBackupType = 'Full' AND SchedPattern = 'Monthly' AND IsScheduleDisabled = 0
UPDATE @Exch2010Sch
SET IsMonIncrSet = 1
FROM @Exch2010Sch AS sub1
	INNER JOIN BackupSchedules AS sub2
		ON sub1.CCID = sub2.CommCellID
			AND sub1.CId = sub2.ClientID
			AND sub1.SCId = sub2.SubclientID
			AND sub2.AgentID = 53
			AND sub2.SchedBackupType = 'Pre-Selected Backup Type'
			AND sub2.SchedPattern = 'Monthly'
UPDATE #SubclientTable
SET DailySchRetentionDays = 1, WeeklySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN @Exch2010Sch AS sub2
ON sub1.CommCellID = sub2.CCID AND sub1.ClientID = sub2.CId AND sub1.SubclientID = sub2.SCId AND sub2.IsMonFullSet = 1 AND sub2.IsMonIncrSet = 1
--Monthly backups
UPDATE #SubclientTable
SET MonthlySchRetentionDays = 1
FROM #SubclientTable AS sub1
INNER JOIN
(
	SELECT CommCellID, ClientID, SubclientID FROM BackupSchedules WHERE SchedBackupType = 'Full' AND SchedPattern = 'Monthly' AND SchedInterval = 'Every 1' AND IsScheduleDisabled = 0
) AS sub2
ON sub1.CommCellID = sub2.CommCellID AND sub1.ClientID = sub2.ClientID AND sub1.SubclientID = sub2.SubclientID
-- Clients with holiday set for more than 3 months are in permanent holiday.
UPDATE #SubclientTable
SET OnHoliday = 1
FROM cf_SurveyClientGroupAssociation CGA
	INNER JOIN (
		SELECT	DISTINCT CommservUniqueId, ClientGroupId
		FROM	cf_SurveyHoliday
		WHERE	ClientGroupId > 0 AND ClientId <= 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	) T ON CGA.CommservUniqueId = T.CommservUniqueId AND CGA.ClientGroupId = T.ClientGroupId
WHERE #SubclientTable.ClientID = CGA.ClientID
UPDATE #SubclientTable
SET OnHoliday = 1
FROM (
		SELECT	DISTINCT CommservUniqueId, ClientId
		FROM	cf_SurveyHoliday
		WHERE	ClientId > 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	) T
WHERE #SubclientTable.CommservUniqueId = T.CommservUniqueId AND #SubclientTable.ClientID = T.ClientID
UPDATE #SubclientTable
SET OnHoliday = 1
WHERE CommservUniqueId IN (
		SELECT	DISTINCT CommservUniqueId
		FROM	cf_SurveyHoliday
		WHERE	ClientGroupId <= 0 AND ClientId <= 0
			AND (EndYear - StartYear)*365 + (EndMonth - StartMonth)*30 + (EndDay - StartDay) > 90
	)
CREATE TABLE #SPInfo (
	CommservUniqueId INT,
	PolicyId INT,
	PolicyName NVARCHAR(144),
	PrimRetentionDays INT,
	PrimExtWeekRetDays INT,
	SyncRetentionDays INT,
	SelWeekRetentionDays INT,
	SelMonRetentionDays INT
	)
--Primary Copies
INSERT INTO #SPInfo
SELECT
	CommservUniqueId,
	PolicyId,
	PolicyName,
	RetentionDays,
	CASE WHEN (ExtRretentionRules & 4) = 4 THEN 1 ELSE 0 END,
	0, 0, 0
FROM cf_SurveyCopyBasicRetention WITH (NOLOCK)
WHERE IsSnapCopy = 0 AND IsDefaultCopy = 1
--Synchronous Copies
UPDATE #SPInfo
SET SyncRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	CommservUniqueId,
	PolicyId,
	RetentionDays,
	ArchiverRetDays
FROM cf_SurveyCopyBasicRetention
WHERE IsSnapCopy = 0 AND IsDefaultCopy = 0 AND CopyType = 1 AND RetentionDays > 60) AS sub2
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
--Selective Copies Weekly
UPDATE #SPInfo
SET SelWeekRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	C.CommservUniqueId,
	C.PolicyId,
	C.RetentionDays,
	C.ArchiverRetDays
FROM cf_SurveyCopyBasicRetention AS C
	INNER JOIN cf_SurveyArchSelectiveCopy AS SC
		ON C.CopyId = SC.CopyId
		AND C.IsSnapCopy = 0
		AND C.IsDefaultCopy = 0
		AND C.CopyType = 2
		AND SC.type = 2 ) AS sub2 --Weekly Fulls
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
--Selective Copies Monthly
UPDATE #SPInfo
SET SelMonRetentionDays = sub2.RetentionDays
FROM #SPInfo AS sub1
INNER JOIN
(SELECT
	C.CommservUniqueId,
	C.PolicyId,
	C.RetentionDays,
	C.ArchiverRetDays
FROM cf_SurveyCopyBasicRetention AS C
	INNER JOIN cf_SurveyArchSelectiveCopy AS SC
		ON C.CopyId = SC.CopyId
		AND C.IsSnapCopy = 0
		AND C.IsDefaultCopy = 0
		AND C.CopyType = 2
		AND SC.type = 4 ) AS sub2 --Monthly Fulls
ON sub1.CommservUniqueId = sub2.CommservUniqueId AND sub1.PolicyId = sub2.PolicyId
SELECT
	SC.CommCellID,
	SC.CommServName,
	ISNULL (CL.ClientDisplayName, SC.clientName) AS 'ClientName',
	SC.clientName  AS 'Client(classic)<HIDDEN>',
	ISNULL(SC.PhysicalClientName,SC.clientName) AS PhysicalClientName,
	SC.AgentName,
	SC.InstanceName,
	SC.BackupsetName,
	SC.SubclientName,
	P.PolicyName,
	CASE
		WHEN SC.DailySchRetentionDays = 0 THEN 0
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		ELSE P.PrimRetentionDays
	END AS DailySchRetentionDays,
	CASE
		WHEN SC.WeeklySchRetentionDays = 0 THEN 0
		WHEN P.PrimExtWeekRetDays > 0 AND SC.AgentID = 53 THEN 28 --TODO: get proper retention days from CommServer
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		WHEN P.SelWeekRetentionDays > 0 THEN P.SelWeekRetentionDays
		ELSE P.PrimRetentionDays
	END AS WeeklySchRetentionDays,
	CASE
		WHEN SC.MonthlySchRetentionDays = 0 THEN 0
		WHEN P.SyncRetentionDays > 0 THEN P.SyncRetentionDays
		WHEN P.SelWeekRetentionDays > 0 THEN P.SelWeekRetentionDays
		WHEN P.SelMonRetentionDays > 0 THEN P.SelMonRetentionDays
		ELSE P.PrimRetentionDays
	END AS MonthlySchRetentionDays,
	CASE
		WHEN OnHoliday = 1 THEN 'Yes'
		ELSE 'No'
	END AS OnHoliday
FROM #SubclientTable AS SC
	INNER JOIN #SPInfo AS P
		ON SC.PolicyId = P.PolicyId
		AND SC.CommservUniqueId = P.CommservUniqueId
	LEFT JOIN cf_SurveyClient CL WITH (NOLOCK)
	   ON CL.CommServUniqueId = SC.CommServUniqueId  AND CL.clientId = SC.clientId
IF OBJECT_ID('tempdb.dbo.#SubclientTable') IS NOT NULL DROP TABLE #SubclientTable
IF OBJECT_ID('tempdb.dbo.#SPInfo') IS NOT NULL DROP TABLE #SPInfo
SET NOCOUNT OFF
GO
/*
-- FOR STANDALONE TESTING:
exec RptBackupOperations
*/

IF EXISTS (select * from GxQscripts where name = 'RptBackupOperations')
	delete from GxQscripts where name = 'RptBackupOperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptBackupOperations')
	delete from GXDBVersions where aliasname = 'RptBackupOperations'
GO

insert into GXDBVersions values(2, 'RptBackupOperations',  '00010007000200010000', 'RptBackupOperations', '00010007000200010000')
GO

