

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/RptAnomalyData.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/RptAnomalyData.sp,v $ $Id: RptAnomalyData.sp,v 1.1.2.2 2019/06/29 15:17:51 vmishra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='RptAnomalyData')
BEGIN
	print '>>> Drop Stored Procedure: RptAnomalyData <<<'
	drop procedure RptAnomalyData
END
IF EXISTS (select * from GxQscripts where name='RptAnomalyData')
	delete from GxQscripts where name = 'RptAnomalyData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAnomalyData')
	delete from GXDBVersions where aliasname = 'RptAnomalyData'
GO
print '... Creating Procedure: RptAnomalyData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure RptAnomalyData
  @i_UserId INT = NULL,
  @i_GroupId INT = NULL,
  @blaggregate INT = 1,
  @blLatestSurvey INT = 1,
  @i_CommServUniqueID INT = 0,
  @i_LogDateStart DATETIME = NULL,
  @i_LogDateEND DATETIME = NUll,
  @i_topN INT = 3
AS
SET NOCOUNT ON
DECLARE @t TABLE (num INT, englishTranslation varchar(32))
DECLARE @clients TABLE (clientName nvarchar(128))
DECLARE @clientsStr nvarchar(max)
INSERT INTO @t values(1,'First,'),(2,'Second,'),(3,'Third,'),(4,'Fourth,')
INSERT INTO @clients
SELECT TOP (@i_topN) C.clientName
FROM cf_SurveyFileAnomaly F
	INNER JOIN dbo.cf_SurveyResultFuncV1(248, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId, @i_GroupId) AS S
		ON F.SurveyResultId = S.SurverResultId
	INNER JOIN cf_SurveyClient C
		ON F.clientId = C.ClientId AND S.CommServUniqueId = C.CommServUniqueId
	GROUP BY C.clientName
IF (SELECT count(*) FROM @clients) > 1
BEGIN
	SET @clientsStr = (SELECT clientName + ', '
					FROM @clients
					FOR XML PATH(''))
	SET @clientsStr = SUBSTRING(@clientsStr, 1, LEN(@clientsStr)-2)
	SET @clientsStr = STUFF(@clientsStr, LEN(@clientsStr) + 1 - CHARINDEX(',',REVERSE(@clientsStr),3),1,' and')
	SET @clientsStr = 'Unusual file activity was observed on clients ' + @clientsStr + '.'
END
ELSE
BEGIN
	SET @clientsStr = (SELECT clientName FROM @clients)
	SET @clientsStr = 'Unusual file activity was observed on client ' + @clientsStr + '.'
END
DECLARE @jobStr nvarchar(max) = (
				SELECT englishTranslation + ' '+ errorDescription
				FROM (SELECT TOP (@i_topN) M.errorDescription, ROW_NUMBER() OVER (ORDER BY M.errorDescription DESC) AS ID
					FROM cf_SurveyJobsAnomaly J
						INNER JOIN dbo.cf_SurveyResultFuncV1(247, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId, @i_GroupId) AS S
							ON J.SurveyResultId = S.SurverResultId
						LEFT JOIN cf_SurveyJobsErrorCodeDescriptionMap M
							ON J.errorCode = M.errorCode
						WHERE M.errorDescription IS NOT NULL
						GROUP BY M.errorDescription	) S
					INNER JOIN @t
						ON num = ID
					FOR XML PATH('')
				)
SET @jobStr = 'Following are the few reasons for unusal job activity: ' + @jobStr
IF @blaggregate = 1
BEGIN
	SELECT  'Jobs' AS AnomalyType, @jobStr AS Description
	WHERE @jobStr IS NOT NULL
	UNION ALL
	SELECT 'File system activity' AS AnomalyType, @clientsStr AS Description
		WHERE @clientsStr IS NOT NULL
	UNION ALL
	SELECT 'DDB Pruning' AS AnomalyType,
		  'There ' + (CASE COUNT(*) WHEN 1 THEN 'is' ELSE 'are' END) + ' '+ RTRIM(CAST(count(*) AS VARCHAR(3))) + ' DDB with pruning issues.' AS Description
	FROM cf_SurveyDDBAnomaly F
		INNER JOIN dbo.cf_SurveyResultFuncV1(249, @i_CommServUniqueID, @blLatestSurvey, @i_LogDateStart, @i_LogDateEND,@i_UserId, @i_GroupId) AS S
			ON F.SurveyResultId = S.SurverResultId
		GROUP BY F.SurveyResultId
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'RptAnomalyData')
	delete from GxQscripts where name = 'RptAnomalyData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='RptAnomalyData')
	delete from GXDBVersions where aliasname = 'RptAnomalyData'
GO

insert into GXDBVersions values(2, 'RptAnomalyData',  '00010001000200020000', 'RptAnomalyData', '00010001000200020000')
GO

