

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParsebrNTFormatLiveFeedsNotifications.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParsebrNTFormatLiveFeedsNotifications.sp,v $ $Id: ParsebrNTFormatLiveFeedsNotifications.sp,v 1.1.2.4 2018/12/27 18:51:08 vikashkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ParsebrNTFormatLiveFeedsNotifications')
BEGIN
	print '>>> Drop Stored Procedure: ParsebrNTFormatLiveFeedsNotifications <<<'
	drop procedure ParsebrNTFormatLiveFeedsNotifications
END
IF EXISTS (select * from GxQscripts where name='ParsebrNTFormatLiveFeedsNotifications')
	delete from GxQscripts where name = 'ParsebrNTFormatLiveFeedsNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParsebrNTFormatLiveFeedsNotifications')
	delete from GXDBVersions where aliasname = 'ParsebrNTFormatLiveFeedsNotifications'
GO
print '... Creating Procedure: ParsebrNTFormatLiveFeedsNotifications'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ParsebrNTFormatLiveFeedsNotifications
  @commservUniqueId integer ,
  @xmlLiveFeedsList XML
AS
Set transaction isolation level read uncommitted
  DECLARE @returnCode integer
SET NOCOUNT ON
DECLARE @NTnotificationID INT
DECLARE @alertName NVARCHAR(256)
DECLARE @escalationLevel INT
DECLARE @severity INT
DECLARE @clientName NVARCHAR(255)
DECLARE @jobId INT
DECLARE @messageFormatType INT
DECLARE @alertType NVARCHAR(1024)
DECLARE @alertcriteria NVARCHAR(1024)
DECLARE @description NVARCHAR(max)
DECLARE @detectedTime INT
SELECT
@NTnotificationID = Tbl.Col.value('@ntNotificationId', 'int'),
@alertName = Tbl.Col.value('@alertName', 'nvarchar(256)'),
@escalationLevel = Tbl.Col.value('@escalationLevel', 'int'),
@severity = Tbl.Col.value('@severity', 'int'),
@clientName = IsNull(Tbl.Col.value('client[1]/@clientName', 'nvarchar(255)'),''),
@jobId = IsNull(Tbl.Col.value('@jobId', 'int'),0),
@messageFormatType = Tbl.Col.value('@messageFormatType', 'int'),
@alertType = Tbl.Col.value('@alertType', 'nvarchar(1024)'),
@alertcriteria = Tbl.Col.value('@alertcriteria', 'nvarchar(1024)'),
@description = Tbl.Col.value('@description', 'nvarchar(max)'),
@detectedTime = dbo.GetUnixTimeBig(CONVERT(datetime,SUBSTRING(Tbl.Col.value('detectedTime[1]/@timeValue', 'nvarchar(128)'), 5, 124)))
FROM @xmlLiveFeedsList.nodes('/App_LiveFeedListResp/feedsList')  Tbl(Col)
IF NOT EXISTS (SELECT * FROM cf_NTLiveFeedsMessageHistory WHERE CommservUniqueId = @commservUniqueId AND NTnotificationID = @NTnotificationID AND DetectedTime = @detectedTime)
BEGIN
	INSERT INTO cf_NTLiveFeedsMessageHistory(
		CommservUniqueId, NTnotificationID, AlertName, escalationLevel, ClientName,
		JobId, messageFormatType, AlertType, AlertCriteria, Description, DetectedTime, created)
	SELECT
		@commservUniqueId, @ntNotificationId, @alertName, @escalationLevel + (@severity * POWER(2,16)), @clientName,
		@jobId, @messageFormatType, @alertType, @alertcriteria, @description, @detectedTime, dbo.GetUnixTimeBig(GetUTCDate())
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParsebrNTFormatLiveFeedsNotifications')
	delete from GxQscripts where name = 'ParsebrNTFormatLiveFeedsNotifications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParsebrNTFormatLiveFeedsNotifications')
	delete from GXDBVersions where aliasname = 'ParsebrNTFormatLiveFeedsNotifications'
GO

insert into GXDBVersions values(2, 'ParsebrNTFormatLiveFeedsNotifications',  '00010001000200040000', 'ParsebrNTFormatLiveFeedsNotifications', '00010001000200040000')
GO

