

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/Parse_57CommservInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/Parse_57CommservInfo.sp,v $ $Id: Parse_57CommservInfo.sp,v 1.5.14.6 2020/12/17 02:50:14 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='Parse_57CommservInfo')
BEGIN
	print '>>> Drop Stored Procedure: Parse_57CommservInfo <<<'
	drop procedure Parse_57CommservInfo
END
IF EXISTS (select * from GxQscripts where name='Parse_57CommservInfo')
	delete from GxQscripts where name = 'Parse_57CommservInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_57CommservInfo')
	delete from GXDBVersions where aliasname = 'Parse_57CommservInfo'
GO
print '... Creating Procedure: Parse_57CommservInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure Parse_57CommservInfo
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseCommservInfoTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#majorSPRestrict_CommCellid') is not null DROP TABLE #majorSPRestrict_CommCellid
CREATE TABLE #majorSPRestrict_CommCellid (IdNamemapIDStr NVARCHAR(MAX) , IdNamemapID INT)
IF object_id('tempdb.dbo.#majorSP4Releases') is not null DROP TABLE #majorSP4Releases
CREATE TABLE #majorSP4Releases (version INT , majorSPNum INT, csReleaseId INT)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @searchStr NVARCHAR(MAX)='IdNamemapID='
	DECLARE @searchStrlen INT=LEN(@searchStr)
	INSERT INTO #majorSPRestrict_CommCellid(IdNamemapIDStr)
	SELECT SUBSTRING (VALUE,CHARINDEX(@searchStr,Value)+ @searchStrlen,LEN(VALUE)-CHARINDEX(@searchStr,Value)+ @searchStrlen) FROM cf_SurveyConfig (NOLOCK)  WHERE NAME LIKE '%Restrict_CommCellid%'
	AND VALUE LIKE '%'+ @searchStr +'%'
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE #majorSPRestrict_CommCellid
	SET IdNamemapID=
		(
			CASE WHEN PATINDEX('%[^0-9]%',IdNamemapIDStr)>0
			THEN
				SUBSTRING(IdNamemapIDStr,0,PATINDEX('%[^0-9]%',IdNamemapIDStr))
			ELSE
				IdNamemapIDStr
			END
			)
	FROM #majorSPRestrict_CommCellid
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #majorSP4Releases (version , majorSPNum, csReleaseId )
	SELECT  10,	SPInfoFTP.value('@majorSP', 'INT'), SPInfoFTP.value('@csReleaseId', 'INT')
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('CommServInfo') AS CommServInfo(CommServInfo)
		CROSS apply CommServInfo.nodes('SPInfoFTP') AS SPInfoFTP(SPInfoFTP)
	WHERE
		CommservSurveyResults_ID = @ResultId
		AND SPInfoFTP.value('@majorSP', 'INT')<100
		and results.CommcellIdNameMap_ID not in (SELECT distinct IdNamemapID FROM #majorSPRestrict_CommCellid WHERE IdNamemapID>0 AND IdNamemapID IS NOT NULL )
	UNION
	SELECT  9,	V9SPInfoCommserv.value('@majorSP', 'INT'), 14
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('CommServInfo') AS CommServInfo(CommServInfo)
		CROSS apply CommServInfo.nodes('V9SPInfoCommserv') AS V9SPInfoCommserv(V9SPInfoCommserv)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @maxV9New INT =0,@maxV10New INT =0,@maxV11New INT =0
	Select @maxV9New = MAX(majorSPNum) FROM #majorSP4Releases WHERE Version  = 9
	Select @maxV10New = MAX(majorSPNum) FROM #majorSP4Releases WHERE csReleaseId = 15
	Select @maxV11New = MAX(majorSPNum) FROM #majorSP4Releases WHERE csReleaseId = 16
	DECLARE @maxV9Old INT =0,@maxV10Old INT =0,@maxV11Old INT =0
	Select @maxV9Old =  CAST(Value AS INT)  FROM cf_SurveyConfig  WHERE Name = '9_0_LatestSPMajorNo'
	Select @maxV10Old = CAST(Value AS INT) FROM cf_SurveyConfig WHERE Name = '10_0_LatestSPMajorNo'
	Select @maxV11Old = CAST(Value AS INT) FROM cf_SurveyConfig WHERE Name = '11_0_LatestSPMajorNo'
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND (@maxV11New>@maxV11Old)
BEGIN
	IF EXISTS(Select *  FROM cf_SurveyConfig  WHERE Name = '11_0_LatestSPMajorNo')
		UPDATE cf_SurveyConfig SET Value = @maxV11New, LogDateUTC = GETUTCDATE() WHERE Name = '11_0_LatestSPMajorNo'
	ELSE
		INSERT INTO cf_SurveyConfig (Name, Value) values ('11_0_LatestSPMajorNo', @maxV11New)
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND (@maxV10New>@maxV10Old)
BEGIN
	IF EXISTS(Select *  FROM cf_SurveyConfig  WHERE Name = '10_0_LatestSPMajorNo')
		UPDATE cf_SurveyConfig SET Value = @maxV10New, LogDateUTC = GETUTCDATE() WHERE Name = '10_0_LatestSPMajorNo'
	ELSE
		INSERT INTO cf_SurveyConfig (Name, Value) values ('10_0_LatestSPMajorNo', @maxV10New)
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND (@maxV9New>@maxV9Old)
BEGIN
	IF EXISTS(Select *  FROM cf_SurveyConfig  WHERE Name = '9_0_LatestSPMajorNo')
		UPDATE cf_SurveyConfig SET Value = @maxV9New, LogDateUTC = GETUTCDATE() WHERE Name = '9_0_LatestSPMajorNo'
	ELSE
		INSERT INTO cf_SurveyConfig (Name, Value) values ('9_0_LatestSPMajorNo', @maxV9New)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseCommservInfoTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'Parse_57CommservInfo')
	delete from GxQscripts where name = 'Parse_57CommservInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='Parse_57CommservInfo')
	delete from GXDBVersions where aliasname = 'Parse_57CommservInfo'
GO

insert into GXDBVersions values(2, 'Parse_57CommservInfo',  '00010005001400060000', 'Parse_57CommservInfo', '00010005001400060000')
GO

