

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseVersionAndServicePack.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseVersionAndServicePack.sp,v $ $Id: ParseVersionAndServicePack.sp,v 1.1.2.9.4.1 2021/03/30 22:11:05 junlu Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseVersionAndServicePack')
BEGIN
	print '>>> Drop Stored Procedure: ParseVersionAndServicePack <<<'
	drop procedure ParseVersionAndServicePack
END
IF EXISTS (select * from GxQscripts where name='ParseVersionAndServicePack')
	delete from GxQscripts where name = 'ParseVersionAndServicePack'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseVersionAndServicePack')
	delete from GXDBVersions where aliasname = 'ParseVersionAndServicePack'
GO
print '... Creating Procedure: ParseVersionAndServicePack'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseVersionAndServicePack
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseVersionAndServicePackTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#UpdatesTable') is not null DROP TABLE #UpdatesTable
CREATE TABLE #UpdatesTable(
	ClientId INT,
	ClientType INT,
	ClientVersion INT,
	ClientServicePack INT,
	UpdateName    NVARCHAR(30),
	Installed     INT,
	Type		INT, -- 1 - PreRelease, 2 - Hotfix, 3 - HPK
	LastUpdateTime DATETIME
)
IF object_id('tempdb.dbo.#VersionTable') is not null DROP TABLE #VersionTable
CREATE TABLE #VersionTable (
	ClientId INT,
	ClientType INT,
	ClientVersion INT,
	ClientServicePack INT,
	AdditionalUpdates NVARCHAR(MAX),
	MissingUpdates NVARCHAR(MAX),
	UPNumber INT,
	LastUpdateTime DATETIME
)
DECLARE @updateLevel INT
SELECT  @updateLevel = ISNULL((SELECT CAST(value AS INT) FROM cf_SurveyConfig WITH (NOLOCK) WHERE name LIKE 'IndiUpdateLevel'),0)
DECLARE @FileName NVARCHAR(1024)
SELECT @FileName = CAST(CollectedResults AS NVARCHAR(1024))
FROM cf_CommservSurveyResults WITH (NOLOCK)
WHERE CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
DECLARE @sql NVARCHAR(2000)
DECLARE @columnCount INT = 8
IF  @ErrorCode = 0
BEGIN
	IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL DROP TABLE #ColumnCheck
	CREATE TABLE #ColumnCheck (rowValue NVARCHAR(MAX))
	--first check how many columns are in the csv coming from CS
	SET @sql = 'BULK INSERT #ColumnCheck FROM ''' + @FileName + ''' WITH ( ROWTERMINATOR =''\n'', KEEPNULLS, LASTROW = 1 )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
	IF  @ErrorCode = 0
		SELECT @columnCount = (LEN(rowValue) - LEN(REPLACE(rowValue, ',', '')) + 1) FROM #ColumnCheck
	SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0
BEGIN
	--1) if uploaded using query older than SP23, it will have 7 columns
	--2) if uploaded using SP23 query, it will have 8 columns
	IF @columnCount = 8
	BEGIN
		SET @sql = 'BULK INSERT #UpdatesTable  FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
	END
	ELSE
	BEGIN
		ALTER TABLE #UpdatesTable DROP COLUMN LastUpdateTime
		SET @sql = 'BULK INSERT #UpdatesTable  FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
		EXEC(@sql);
		SELECT @ErrorCode = @@ERROR
		ALTER TABLE #UpdatesTable ADD LastUpdateTime DATETIME NULL
	END
END
CREATE CLUSTERED INDEX UpdatesTable_ClientId_idx ON #UpdatesTable (ClientId)
DECLARE @CSRelease INT
DECLARE @CSSP INT
SELECT @CSRelease = ClientVersion, @CSSP = ClientServicePack FROM #UpdatesTable WHERE ClientId = 2
IF  @ErrorCode = 0
BEGIN
	INSERT INTO #VersionTable (ClientId, ClientType, ClientVersion, ClientServicePack, AdditionalUpdates, MissingUpdates, UPNumber, LastUpdateTime)
	SELECT	ClientId, ISNULL(ClientType, 0), ClientVersion, ClientServicePack, '', '', CAST(UpdateName AS INT),LastUpdateTime
	FROM	#UpdatesTable
	WHERE Type = 3 --HPK
    SELECT @ErrorCode = @@ERROR
END
CREATE CLUSTERED INDEX VersionTable_ClientId_idx ON #VersionTable (ClientId)
IF  @ErrorCode = 0
BEGIN
	UPDATE T SET AdditionalUpdates = ISNULL(
			STUFF((SELECT ',' + UpdateName FROM #UpdatesTable T2 WHERE T.ClientId = T2.ClientId AND T2.Installed = 1 AND T2.Type IN (1, 2) FOR XML PATH('')), 1, 1, ''),
			'')
	FROM	#VersionTable T
    SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0 AND (@CSRelease < 11 OR (@CSRelease = 11 AND @CSSP <= 13))
BEGIN
	UPDATE T SET MissingUpdates = ISNULL(
			STUFF((SELECT ',' + UpdateName FROM #UpdatesTable T2 WHERE T.ClientId = T2.ClientId AND T2.Installed = 0 FOR XML PATH('')), 1, 1, ''),
			'')
	FROM	#VersionTable T
    SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0
BEGIN
	-- First delete old version information for the given commserv
	IF (@CSRelease < 11 OR (@CSRelease = 11 AND @CSSP <= 13)) --No HPK till SP13
		DELETE SP FROM cf_SurveyVersionAndServicePack SP INNER JOIN #VersionTable V
			ON SP.CommservUniqueId = @CSUniqueId AND SP.ClientID = V.ClientID
	ELSE
		DELETE SP FROM cf_SurveyVersionAndServicePack SP WHERE SP.CommservUniqueId = @CSUniqueId
    SELECT @ErrorCode = @@ERROR
END
IF  @ErrorCode = 0
BEGIN
	-- Execute insert statement here
	INSERT INTO cf_SurveyVersionAndServicePack(CommservUniqueId, ClientId, ClientType, Version, ServicePack, AdditionalUpdates, MissingUpdates, UPNumber, LastUpdateTime)
	SELECT @CSUniqueId,
		T.ClientId,
		T.ClientType,
		T.ClientVersion,
		T.ClientServicePack,
		AdditionalUpdates,
		MissingUpdates,
		UPNumber,
		LastUpdateTime
	FROM  #VersionTable T
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND @updateLevel > 0
BEGIN
	DELETE SP FROM cf_SurveyClientUpdates SP INNER JOIN #VersionTable V
		ON SP.CommservUniqueId = @CSUniqueId AND SP.ClientID = V.ClientID
	SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0 AND @updateLevel > 0
BEGIN
	INSERT INTO cf_SurveyClientUpdates
	SELECT	@CSUniqueId,
			T.ClientId,
			T.UpdateName,
			T.Type
	FROM #UpdatesTable T
	WHERE T.Type & @updateLevel <> 0
	SELECT @ErrorCode = @@ERROR
END
IF object_id('tempdb.dbo.#UpdatesTable') is not null DROP TABLE #UpdatesTable
IF object_id('tempdb.dbo.#VersionTable') is not null DROP TABLE #VersionTable
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseVersionAndServicePackTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseVersionAndServicePack')
	delete from GxQscripts where name = 'ParseVersionAndServicePack'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseVersionAndServicePack')
	delete from GXDBVersions where aliasname = 'ParseVersionAndServicePack'
GO

insert into GXDBVersions values(2, 'ParseVersionAndServicePack',  'v1.1.2.9.4.1', 'ParseVersionAndServicePack', 'v1.1.2.9.4.1')
GO

