

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUpgradeIndexRestoreStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUpgradeIndexRestoreStats.sp,v $ $Id: ParseUpgradeIndexRestoreStats.sp,v 1.3.60.5 2020/12/17 02:53:26 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseUpgradeIndexRestoreStats')
BEGIN
	print '>>> Drop Stored Procedure: ParseUpgradeIndexRestoreStats <<<'
	drop procedure ParseUpgradeIndexRestoreStats
END
IF EXISTS (select * from GxQscripts where name='ParseUpgradeIndexRestoreStats')
	delete from GxQscripts where name = 'ParseUpgradeIndexRestoreStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeIndexRestoreStats')
	delete from GXDBVersions where aliasname = 'ParseUpgradeIndexRestoreStats'
GO
print '... Creating Procedure: ParseUpgradeIndexRestoreStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseUpgradeIndexRestoreStats
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseUpgradeIdxRestoreStatsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		3
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre3Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		7
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre7Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		1,
		21
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPre21Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		3
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost3Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		7
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost7Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		2,
		21
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForPost21Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		3
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest3Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		7
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest7Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyUpgradeIndexRestoreStats
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MaName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@IndexRestoreJobCount', 'BIGINT'),
		csInfo.n.value('@TotalCapacityMB', 'BIGINT'),
		csInfo.n.value('@DiskUsageMB', 'BIGINT'),
		csInfo.n.value('@FreeDiskSpaceMB', 'BIGINT'),
		3,
		21
	FROM
		cf_CommservSurveyResults AS results
		CROSS apply results.CollectedResults.nodes('/IndexRestoreInfo/IndexRestoreStatsForLatest21Days/IndexRestoreStats') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseUpgradeIdxRestoreStatsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUpgradeIndexRestoreStats')
	delete from GxQscripts where name = 'ParseUpgradeIndexRestoreStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUpgradeIndexRestoreStats')
	delete from GXDBVersions where aliasname = 'ParseUpgradeIndexRestoreStats'
GO

insert into GXDBVersions values(2, 'ParseUpgradeIndexRestoreStats',  '00010003006000050000', 'ParseUpgradeIndexRestoreStats', '00010003006000050000')
GO

