

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseUnprotectedClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseUnprotectedClients.sp,v $ $Id: ParseUnprotectedClients.sp,v 1.7.2.16 2020/12/17 02:48:44 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseUnprotectedClients')
BEGIN
	print '>>> Drop Stored Procedure: ParseUnprotectedClients <<<'
	drop procedure ParseUnprotectedClients
END
IF EXISTS (select * from GxQscripts where name='ParseUnprotectedClients')
	delete from GxQscripts where name = 'ParseUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnprotectedClients')
	delete from GXDBVersions where aliasname = 'ParseUnprotectedClients'
GO
print '... Creating Procedure: ParseUnprotectedClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseUnprotectedClients
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseUnprotectedClientsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @SLAEndDate DATETIME
IF OBJECT_ID('tempdb..#SLADetails') IS NOT NULL
	DROP TABLE #SLADetails
CREATE TABLE #SLADetails
(
	Days					int,
	ClientId				int,
	AppId					int,
	Reason					nvarchar(256),
	LastBackupJobId			int,
	LastJobStatus			nvarchar(64),
	LastJobStartTime		datetime,
	ClientOwners			nvarchar(max),
	LastProtectedTime		datetime NULL
)
IF 	@ErrorCode = 0
BEGIN
	SELECT @SLAEndDate = ISNULL(csInfo.n.value('@SLAEndDate', 'DATETIME'), LogDate)
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/NotProtectedClients') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySLASummary (
			SurveyResultId, Days, ProtectedClients, NotProtectedClients, ExcludedClients, AsOfDate
			)
	SELECT
		@ResultId,
		csInfo.n.value('@days', 'INTEGER'),
		ISNULL(csInfo.n.value('@nProtectedClients', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@nNotProtectedClients', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@nExcludedClients', 'INTEGER'), 0),
		@SLAEndDate
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/NotProtectedClients/summary') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAppTypeSLASummary (
			SurveyResultId, appTypeId, ProtectedClients, NotProtectedClients, AsOfDate
			)
	SELECT
		@ResultId,
		csInfo.n.value('@appTypeId', 'INTEGER'),
		csInfo.n.value('@nProtectedClients', 'INTEGER'),
		csInfo.n.value('@nNotProtectedClients', 'INTEGER'),
		@SLAEndDate
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/NotProtectedClients/appType') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyClientGroupSLASummary (
			SurveyResultId, ClientGroupId, Days, ProtectedClients, NotProtectedClients, ExcludedClients, AsOfDate
			)
	SELECT
		@ResultId,
		csInfo.n.value('@id', 'INTEGER'),
		csInfo.n.value('@d', 'INTEGER'),
		csInfo.n.value('@p', 'INTEGER'),
		csInfo.n.value('@n', 'INTEGER'),
		csInfo.n.value('@e', 'INTEGER'),
		@SLAEndDate
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/NotProtectedClients/cg') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SLADetails (
			Days, ClientId, AppId, Reason, LastBackupJobId, LastJobStatus, LastJobStartTime, ClientOwners, LastProtectedTime
			)
	SELECT
		csInfo.n.value('@d1', 'INTEGER'),
		csInfo.n.value('@d2', 'INTEGER'),
		csInfo.n.value('@d3', 'INTEGER'),
		csInfo.n.value('@d4', 'NVARCHAR(256)'),
		csInfo.n.value('@d5', 'INTEGER'),
		csInfo.n.value('@d6', 'NVARCHAR(64)'),
		csInfo.n.value('@d7', 'DATETIME'),
		csInfo.n.value('@d8', 'NVARCHAR(MAX)'),
		csInfo.n.value('@d9', 'DATETIME')
	FROM
		cf_CommservSurveyResults
		CROSS apply CollectedResults.nodes('/NotProtectedClients/d') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT TOP 1 0 FROM #SLADetails)
BEGIN
	INSERT INTO cf_SurveySLADetails (
			SurveyResultId, ClientId, AppId, Days, Reason, LastBackupJobId, LastJobStatus, LastJobStartTime, ClientOwners, LastProtectedTime
			)
	SELECT	@ResultId, ClientId, AppId, Days, Reason, LastBackupJobId, LastJobStatus, LastJobStartTime, ClientOwners, LastProtectedTime
	FROM	#SLADetails
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseUnprotectedClientsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseUnprotectedClients')
	delete from GxQscripts where name = 'ParseUnprotectedClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseUnprotectedClients')
	delete from GXDBVersions where aliasname = 'ParseUnprotectedClients'
GO

insert into GXDBVersions values(2, 'ParseUnprotectedClients',  '00010007000200160000', 'ParseUnprotectedClients', '00010007000200160000')
GO

