

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTenants.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTenants.sp,v $ $Id: ParseTenants.sp,v 1.1.2.8.4.1 2021/02/17 03:01:22 echen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseTenants')
BEGIN
	print '>>> Drop Stored Procedure: ParseTenants <<<'
	drop procedure ParseTenants
END
IF EXISTS (select * from GxQscripts where name='ParseTenants')
	delete from GxQscripts where name = 'ParseTenants'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTenants')
	delete from GXDBVersions where aliasname = 'ParseTenants'
GO
print '... Creating Procedure: ParseTenants'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseTenants
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseTenantsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @CSTimeDiff BIGINT = (SELECT DATEDIFF(S, GETUTCDATE(), dbo.UTCToLocalDateTimeConversion(GETUTCDATE(), C.CommServTZ)) FROM cf_CommcellIdNameMap C WITH (NOLOCK) WHERE ID = @CSUniqueId)
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#SurveyTenants') IS NOT NULL
    DROP TABLE #SurveyTenants
CREATE TABLE #SurveyTenants (TenantID INT, TenantGUID UNIQUEIDENTIFIER, TenantName NVARCHAR(288), Flag INT, SignUpDate BIGINT, DeactivatedDate BIGINT, DeletedDate BIGINT, ClientGroupId INT, LastLogInTime BIGINT)
IF OBJECT_ID('tempdb..#DeletedTenants') IS NOT NULL
    DROP TABLE #DeletedTenants
CREATE TABLE #DeletedTenants (TenantID INT, TenantGUID UNIQUEIDENTIFIER, TenantName NVARCHAR(255), Flag INT, SignUpDate BIGINT, DeactivatedDate BIGINT, DeletedDate BIGINT, ClientGroupId INT, LastLogInTime BIGINT)
IF OBJECT_ID('tempdb..#ColumnCheck') IS NOT NULL
    DROP TABLE #ColumnCheck
CREATE TABLE #ColumnCheck (rowValue NVARCHAR(MAX))
DECLARE @sql NVARCHAR(256) = ''
DECLARE @columnCount INT = 0
IF  @ErrorCode = 0
BEGIN
    --first check how many columns are in the csv coming from CS
    --1) if uploaded using SP20 query, it will have 3 columns
    --2) if uploaded using SP21 query, it will have 8 columns
	--3) if uploaded using SP25 query, it will have 9 columns
    SET @sql = 'BULK INSERT #ColumnCheck FROM ''' + @FileName + ''' WITH ( ROWTERMINATOR =''\n'', KEEPNULLS, LASTROW = 1 )';
    EXEC(@sql);
    SELECT @columnCount=count(_ID) FROM dbo.SplitStringByDelimiter((select rowValue from #ColumnCheck),',')
    SELECT @ErrorCode = @@ERROR
END
IF @ErrorCode = 0
BEGIN
	IF @columnCount = 3
	BEGIN
		ALTER TABLE #SurveyTenants
		DROP COLUMN TenantID, SignUpDate, DeletedDate, DeactivatedDate, ClientGroupId,LastLogInTime
	END
	IF @columnCount = 8
	BEGIN
		ALTER TABLE #SurveyTenants
		DROP COLUMN LastLogInTime
	END
END
IF 	@ErrorCode = 0
BEGIN
	SET @sql = 'BULK INSERT #SurveyTenants FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
---add back dropped columns ------
IF @ErrorCode = 0
BEGIN
	IF @columnCount = 3
	BEGIN
		ALTER TABLE #SurveyTenants
		ADD TenantID INT, SignUpDate BIGINT, DeletedDate BIGINT, DeactivatedDate BIGINT, ClientGroupId INT,LastLogInTime BIGINT
	END
	IF @columnCount = 8
	BEGIN
		ALTER TABLE #SurveyTenants
		ADD LastLogInTime BIGINT
	END
END
-----------------------------------------------------------------------------------
IF EXISTS (SELECT 1 FROM #SurveyTenants)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		UPDATE #SurveyTenants
		SET TenantName = Replace (TenantName,'<COMMA>',',')
		WHERE TenantName IS NOT NULL AND CHARINDEX('<COMMA>', TenantName)>0
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		IF @columnCount > 3
		BEGIN
				INSERT INTO #DeletedTenants
SELECT T.TenantID, T.TenantGUID, T.TenantName, T.flag | 0x0010 | 0x0002, dbo.GetUnixTimeBig(T.SignUpDate), dbo.GetUnixTimeBig(T.DeactivatedDate), dbo.getunixTimeBig(getutcdate())+ @CSTimeDiff, T.ClientGroupId ,T.LastLogInTime
				FROM cf_surveyTenants T WITH (NOLOCK) WHERE T.CommServUniqueId = @CSUniqueId AND TenantID <> 0 AND TenantID not in (SELECT TenantID FROM #SurveyTenants)
			INSERT INTO #SurveyTenants
			SELECT * FROM #DeletedTenants
		END
	END
	IF @ErrorCode = 0
	BEGIN
		IF @columnCount > 3
		BEGIN
			DELETE FROM cf_SurveyTenants
			Where CommservUniqueId = @CSUniqueId AND (TenantId = 0 OR ClientGroupId = 0 OR SignUpDate is NULL)
			MERGE cf_SurveyTenants AS T
				USING (SELECT DISTINCT @CSUniqueId CommServUniqueId, TenantID, TenantGUID, TenantName, Flag, SignUpDate, DeactivatedDate, DeletedDate, ClientGroupId,LastLogInTime FROM #SurveyTenants) AS S
			ON T.TenantID = S.TenantID AND T.ClientGroupId = S.ClientGroupId AND T.TenantGUID = S.TenantGUID AND T.CommServUniqueId = @CSUniqueId
			WHEN MATCHED
					THEN UPDATE SET T.TenantName=S.TenantName, T.Flag=S.Flag, T.DeactivatedDate = CASE WHEN S.DeactivatedDate = 0 THEN NULL ELSE dbo.getDateTime(S.DeactivatedDate + @CSTimeDiff) END, T.DeletedDate = CASE WHEN S.DeletedDate = 0 THEN NULL ELSE dbo.getDateTime(S.DeletedDate + @CSTimeDiff) END,T.LastLogInTime = S.LastLogInTime
			WHEN NOT MATCHED BY TARGET
						THEN INSERT (CommservUniqueId, TenantID, TenantGUID, TenantName, Flag, SignUpDate, DeactivatedDate, DeletedDate, ClientGroupId,LastLogInTime)
						VALUES(@CSUniqueId, TenantID, TenantGUID, TenantName, Flag, dbo.getDateTime(SignUpDate + @CSTimeDiff), CASE WHEN S.DeactivatedDate = 0 THEN NULL ELSE dbo.getDateTime(DeactivatedDate + @CSTimeDiff) END, CASE WHEN DeletedDate = 0 THEN NULL ELSE dbo.getDateTime(DeletedDate + @CSTimeDiff) END, ClientGroupId,LastLogInTime);
				END
		ELSE
		BEGIN
			MERGE cf_SurveyTenants AS T
	        USING (SELECT DISTINCT @CSUniqueId CommServUniqueId, TenantGUID, TenantName, Flag FROM #SurveyTenants) AS S
	        ON T.TenantGUID = S.TenantGUID AND T.CommServUniqueId = @CSUniqueId
	        WHEN MATCHED
	            THEN UPDATE SET T.TenantName=S.TenantName, T.Flag=S.Flag
	        WHEN NOT MATCHED BY TARGET
	            THEN INSERT (CommservUniqueId, TenantGUID, TenantName, Flag)
	            VALUES(@CSUniqueId, TenantGUID, TenantName, Flag);
		END
		SELECT @ErrorCode = @@ERROR
	END
END
IF OBJECT_ID('tempdb..#SurveyTenants') IS NOT NULL DROP TABLE #SurveyTenants
IF OBJECT_ID('tempdb..#DeletedTenants') IS NOT NULL DROP TABLE #DeletedTenants
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseTenantsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTenants')
	delete from GxQscripts where name = 'ParseTenants'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTenants')
	delete from GXDBVersions where aliasname = 'ParseTenants'
GO

insert into GXDBVersions values(2, 'ParseTenants',  'v1.1.2.8.4.1', 'ParseTenants', 'v1.1.2.8.4.1')
GO

