

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseTapeMediaHistory.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseTapeMediaHistory.sp,v $ $Id: ParseTapeMediaHistory.sp,v 1.1.4.7 2020/12/17 02:46:35 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseTapeMediaHistory')
BEGIN
	print '>>> Drop Stored Procedure: ParseTapeMediaHistory <<<'
	drop procedure ParseTapeMediaHistory
END
IF EXISTS (select * from GxQscripts where name='ParseTapeMediaHistory')
	delete from GxQscripts where name = 'ParseTapeMediaHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaHistory')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaHistory'
GO
print '... Creating Procedure: ParseTapeMediaHistory'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseTapeMediaHistory
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseTapeMediaHistoryTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
IF object_id('tempdb.dbo.#SurveyTapeMediaHistory') is not null DROP TABLE #SurveyTapeMediaHistory
CREATE TABLE #SurveyTapeMediaHistory (
	CommServUniqueId INT NOT NULL,
	HistoryId INT NOT NULL,
	MediaId INT NOT NULL,
	BarCode VARCHAR(256) NOT NULL,
	LibraryId INT NOT NULL,
	LibraryName VARCHAR(128) NOT NULL,
	MediaLocation VARCHAR(32) NOT NULL,
	MarkedForExport INT NOT NULL,
	SlotId INT NULL,
	SlotName VARCHAR(32) NULL,
	DriveId INT NULL,
	DriveName VARCHAR(1024) NULL,
	ContainerId integer NULL,
	ContainerName NVARCHAR(256) NOT NULL,
	ExportLocationId INT NULL,
	ExportLocation NVARCHAR(64) NOT NULL,
	ExportTime INT NULL,
	ImportTime INT NULL,
	UpdateTime INT NOT NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyTapeMediaHistory (
			CommServUniqueId,
			HistoryId,
			MediaId,
			BarCode,
			LibraryId,
			LibraryName,
			MediaLocation,
			MarkedForExport,
			SlotId,
			SlotName,
			DriveId,
			DriveName,
			ContainerId,
			ContainerName,
			ExportLocationId,
			ExportLocation,
			ExportTime,
			ImportTime,
			UpdateTime
		)
	SELECT DISTINCT
		CommcellIdNameMap_ID,
		csInfo.n.value('@HistoryId', 'INT'),
		csInfo.n.value('@MediaId', 'INT'),
		csInfo.n.value('@BarCode', 'VARCHAR(256)'),
		csInfo.n.value('@LibraryId', 'INT'),
		csInfo.n.value('@LibraryName', 'VARCHAR(128)'),
		csInfo.n.value('@MediaLocation', 'VARCHAR(32)'),
		csInfo.n.value('@MarkedForExport', 'INT'),
		csInfo.n.value('@SlotId', 'INT'),
		csInfo.n.value('@SlotName', 'VARCHAR(32)'),
		csInfo.n.value('@DriveId', 'INT'),
		csInfo.n.value('@DriveName', 'VARCHAR(1024)'),
		csInfo.n.value('@ContainerId', 'INT'),
		csInfo.n.value('@ContainerName', 'NVARCHAR(256)'),
		csInfo.n.value('@ExportLocationId', 'INT'),
		csInfo.n.value('@ExportLocation', 'NVARCHAR(64)'),
		csInfo.n.value('@ExportTime', 'INT'),
		csInfo.n.value('@ImportTime', 'INT'),
		csInfo.n.value('@UpdateTime', 'INT')
	FROM
		cf_CommservSurveyResults
			CROSS apply CollectedResults.nodes('/TapeMediaHistory') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE  #SurveyTapeMediaHistory
	FROM	cf_SurveyTapeMediaHistory S
	WHERE	#SurveyTapeMediaHistory.CommservUniqueId = S.CommservUniqueId AND #SurveyTapeMediaHistory.HistoryId = S.HistoryId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyTapeMediaHistory (
				CommServUniqueId,
				HistoryId,
				MediaId,
				BarCode,
				LibraryId,
				LibraryName,
				MediaLocation,
				MarkedForExport,
				SlotId,
				SlotName,
				DriveId,
				DriveName,
				ContainerId,
				ContainerName,
				ExportLocationId,
				ExportLocation,
				ExportTime,
				ImportTime,
				UpdateTime
			)
	 SELECT	CommServUniqueId,
			HistoryId,
			MediaId,
			BarCode,
			LibraryId,
			LibraryName,
			MediaLocation,
			MarkedForExport,
			SlotId,
			SlotName,
			DriveId,
			DriveName,
			ContainerId,
			ContainerName,
			ExportLocationId,
			ExportLocation,
			ExportTime,
			ImportTime,
			UpdateTime
	 FROM	#SurveyTapeMediaHistory
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseTapeMediaHistoryTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseTapeMediaHistory')
	delete from GxQscripts where name = 'ParseTapeMediaHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseTapeMediaHistory')
	delete from GXDBVersions where aliasname = 'ParseTapeMediaHistory'
GO

insert into GXDBVersions values(2, 'ParseTapeMediaHistory',  '00010001000400070000', 'ParseTapeMediaHistory', '00010001000400070000')
GO

