

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseSubclientConfig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseSubclientConfig.sp,v $ $Id: ParseSubclientConfig.sp,v 1.9.2.11 2020/12/17 02:55:29 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseSubclientConfig')
BEGIN
	print '>>> Drop Stored Procedure: ParseSubclientConfig <<<'
	drop procedure ParseSubclientConfig
END
IF EXISTS (select * from GxQscripts where name='ParseSubclientConfig')
	delete from GxQscripts where name = 'ParseSubclientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientConfig')
	delete from GXDBVersions where aliasname = 'ParseSubclientConfig'
GO
print '... Creating Procedure: ParseSubclientConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseSubclientConfig
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseSubclientConfigTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
CREATE TABLE #SubclientAssociation
(
	ClientId			INT,
	ClientName			NVARCHAR(256),
	AppTypeId			INT,
	AgentName			VARCHAR(256),
	InstanceId			INT,
	InstanceName		NVARCHAR(512),
	BackupsetId			INT,
	BackupsetName		NVARCHAR(128),
	AppId				INT,
	SubclientName		NVARCHAR(128),
	SubclientStatus		INT,
	DataPolicyId		INT,
	LogPolicyId			INT,
	SubclientPolicyAppId INT,
	PhysicalClientName  NVARCHAR(256),
	BackupDisabled		INT,
	FilterFlags			INT,
	Archive1PassFlags	INT,
	CreationTime		DATETIME,
	DeconfiguredTime	DATETIME,
	RestoreDisabled		INT,
	ReaderInfo			VARCHAR(10),
	EncryptionInfo		VARCHAR(25),
	GlobalFilter		INT,
	SpecialTypeFlags	INT
)
CREATE TABLE #NeedToUpdateNames
(
	ClientId			INT,
	AppId				INT,
	ClientName			NVARCHAR(256),
	InstanceName		NVARCHAR(512),
	BackupsetName		NVARCHAR(128)
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SubclientAssociation (
		ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
		SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, PhysicalClientName,
		BackupDisabled, FilterFlags, Archive1PassFlags, CreationTime, DeconfiguredTime,
		RestoreDisabled, ReaderInfo, EncryptionInfo, GlobalFilter, SpecialTypeFlags)
	SELECT
		csInfo.n.value('@clientId','INT'),
		csInfo.n.value('@clientName','NVARCHAR(256)'),
		csInfo.n.value('@appTypeId','INT'),
		csInfo.n.value('@agentName','VARCHAR(256)'),
		ISNULL(csInfo.n.value('@instanceId','INT'), 0),
		ISNULL(csInfo.n.value('@instanceName','NVARCHAR(512)'), ''),
		ISNULL(csInfo.n.value('@backupsetId','INT'), 0),
		ISNULL(csInfo.n.value('@backupsetName','NVARCHAR(128)'), ''),
		ISNULL(csInfo.n.value('@appId','INT'), 0),
		ISNULL(csInfo.n.value('@subclientName','NVARCHAR(128)'), ''),
		ISNULL(csInfo.n.value('@subclientStatus','INT'), 0),
		ISNULL(csInfo.n.value('@dataPolicyId','INT'), 0),
		ISNULL(csInfo.n.value('@logPolicyId','INT'), 0),
		ISNULL(csInfo.n.value('@subclientPolicyAppId','INT'), 0),
		csInfo.n.value('@physicalClientName','NVARCHAR(256)'),
		ISNULL(csInfo.n.value('@backupDisabled','INT'), 0),
		ISNULL(csInfo.n.value('@filterFlags','INT'), 0),
		ISNULL(csInfo.n.value('@archive1PassFlags','INT'), 0),
		csInfo.n.value('@creationTime','DATETIME'),
		csInfo.n.value('@deconfiguredTime','DATETIME'),
		ISNULL(csInfo.n.value('@restoredisabled','INT'), 0),
		ISNULL(csInfo.n.value('@readerInfo','VARCHAR(10)'), ''),
		ISNULL(csInfo.n.value('@encryptionInfo','VARCHAR(25)'), ''),
		ISNULL(csInfo.n.value('@globalfilter','INT'), 0),
		ISNULL(csInfo.n.value('@systemstateval','INT'), 0)
	FROM
		cf_CommservSurveyResults
		CROSS APPLY CollectedResults.nodes('Subclient') AS csInfo(n)
	WHERE
		CommservSurveyResults_ID = @ResultId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	S
	FROM	cf_SurveySubclientAssociation S WITH (PAGLOCK) INNER JOIN #SubclientAssociation T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #NeedToUpdateNames
	SELECT	S.ClientId, S.AppId, T.ClientName, T.InstanceName, T.BackupsetName
	FROM	cf_SurveySubclientAssociation S INNER JOIN #SubclientAssociation T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId
		AND (S.ClientName <> T.ClientName OR
				S.AppTypeId = T.AppTypeId AND S.InstanceId = T.InstanceId
				AND (S.InstanceName <> T.InstanceName OR
						S.BackupsetId = T.BackupsetId AND S.BackupsetName <> T.BackupsetName
					)
			)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	S SET ClientName = T.ClientName, InstanceName = T.InstanceName, BackupsetName = T.BackupsetName
	FROM	cf_SurveySubclientAssociation S INNER JOIN #NeedToUpdateNames T
			ON S.CommservUniqueId = @CSUniqueId AND S.ClientId = T.ClientId AND S.AppId = T.AppId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	cf_SurveySubclientAssociation SET Deleted = 1
	WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveySubclientAssociation (
			CommservUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
			SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, Deleted, PhysicalClientName,
			BackupDisabled, FilterFlags, Archive1PassFlags, CreationTime, DeconfiguredTime,
			RestoreDisabled, ReaderInfo, EncryptionInfo, GlobalFilter, SpecialTypeFlags)
	SELECT	@CSUniqueId, ClientId, ClientName, AppTypeId, AgentName, InstanceId, InstanceName, BackupsetId, BackupsetName, AppId, SubclientName,
			SubclientStatus, DataPolicyId, LogPolicyId, SubclientPolicyAppId, 0, PhysicalClientName,
			BackupDisabled, FilterFlags, Archive1PassFlags, CreationTime, DeconfiguredTime,
			RestoreDisabled, ReaderInfo, EncryptionInfo, GlobalFilter, SpecialTypeFlags
	FROM	#SubclientAssociation
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseSubclientConfigTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseSubclientConfig')
	delete from GxQscripts where name = 'ParseSubclientConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseSubclientConfig')
	delete from GXDBVersions where aliasname = 'ParseSubclientConfig'
GO

insert into GXDBVersions values(2, 'ParseSubclientConfig',  '00010009000200110000', 'ParseSubclientConfig', '00010009000200110000')
GO

