

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseScalereportCommcellStatusSurvey.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseScalereportCommcellStatusSurvey.sp,v $ $Id: ParseScalereportCommcellStatusSurvey.sp,v 1.2.60.8 2020/12/17 02:47:05 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseScalereportCommcellStatusSurvey')
BEGIN
	print '>>> Drop Stored Procedure: ParseScalereportCommcellStatusSurvey <<<'
	drop procedure ParseScalereportCommcellStatusSurvey
END
IF EXISTS (select * from GxQscripts where name='ParseScalereportCommcellStatusSurvey')
	delete from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScalereportCommcellStatusSurvey')
	delete from GXDBVersions where aliasname = 'ParseScalereportCommcellStatusSurvey'
GO
print '... Creating Procedure: ParseScalereportCommcellStatusSurvey'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseScalereportCommcellStatusSurvey
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseScaleRptCommcellStatusTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #ScaleReportInfo (
	Property    VARCHAR(MAX),
	LastHour    FLOAT,
	Last24Hours FLOAT,
	Unit        VARCHAR(MAX)
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #ScaleReportInfo
	SELECT
		csInfo.n.value('@Query', 'VARCHAR(MAX)'),
		csInfo.n.value('@LastHour', 'FLOAT'),
		csInfo.n.value('@Last24Hours', 'FLOAT'),
		csInfo.n.value('@Unit', 'VARCHAR(MAX)')
	FROM
		@ResultXml.nodes('/ScaleReport/ScaleReportCommcellStatusXML') AS csInfo(n)
	SELECT @ErrorCode = 0
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyScaleReportInfo
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		Property,
		LastHour,
		Last24Hours,
		Unit
	FROM #ScaleReportInfo
	SELECT @ErrorCode = 0
END
--Collecting Daily Database Size Stats
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDatabaseSizeHistory (CommservUniqueId, LogDate, DatabaseName, SizeMB)
	SELECT
		@CSUniqueId,
		@LogDate,
		CASE
			WHEN SC.Property = 'TempDB Size' THEN 'TempDB'
			WHEN SC.Property = 'TempDB Log Size' THEN 'TempDB Log'
			WHEN SC.Property = 'Commserv Database Size' THEN 'Commserv'
			WHEN SC.Property = 'CVCloud Database Size' THEN 'CVCloud'
			WHEN SC.Property = 'DM2 Database Size' THEN 'DM2'
			WHEN SC.Property = 'WFEngine Database Size' THEN 'WFEngine'
			WHEN SC.Property = 'History Database Size' THEN 'HistoryDB'
			WHEN SC.Property = 'Audit Database Size' THEN 'AuditDB'
			WHEN SC.Property = 'Cache Database Size' THEN 'CacheDB'
			WHEN SC.Property = 'ResourceMgr Database Size' THEN 'ResourceMgrDB'
			WHEN SC.Property = 'Template Database Size' THEN 'TemplateDB'
			WHEN SC.Property = 'TroubleShooting Database Size' THEN 'TroubleShootingDB'
		END,
		ROUND(SC.LastHour * 1024,0)
	FROM #ScaleReportInfo SC
	WHERE SC.Property IN ('TempDB Size', 'TempDB Log Size', 'Commserv Database Size', 'CVCloud Database Size', 'DM2 Database Size', 'WFEngine Database Size','HistoryDB Database Size','Audit Database Size','Cache Database Size','ResourceMgr Database Size','Template Database Size','TroubleShooting Database Size')
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseScaleRptCommcellStatusTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey')
	delete from GxQscripts where name = 'ParseScalereportCommcellStatusSurvey'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseScalereportCommcellStatusSurvey')
	delete from GXDBVersions where aliasname = 'ParseScalereportCommcellStatusSurvey'
GO

insert into GXDBVersions values(2, 'ParseScalereportCommcellStatusSurvey',  '00010002006000080000', 'ParseScalereportCommcellStatusSurvey', '00010002006000080000')
GO

