

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMostFrequentErrors.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMostFrequentErrors.sp,v $ $Id: ParseMostFrequentErrors.sp,v 1.2.60.11 2020/12/17 02:51:38 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseMostFrequentErrors')
BEGIN
	print '>>> Drop Stored Procedure: ParseMostFrequentErrors <<<'
	drop procedure ParseMostFrequentErrors
END
IF EXISTS (select * from GxQscripts where name='ParseMostFrequentErrors')
	delete from GxQscripts where name = 'ParseMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'ParseMostFrequentErrors'
GO
print '... Creating Procedure: ParseMostFrequentErrors'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseMostFrequentErrors
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseMostFrequentErrorsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF OBJECT_ID('tempdb..#MonthlyTop10Errors') IS NOT NULL DROP TABLE #MonthlyTop10Errors
CREATE TABLE #MonthlyTop10Errors (MonthIntv DATE, errorCode nvarchar(50), errorDescription nvarchar(max), numberOfJobsAffected INT)
IF OBJECT_ID('tempdb..#MostFrequentErrors') IS NOT NULL DROP TABLE #MostFrequentErrors
CREATE TABLE #MostFrequentErrors (errorCode NVARCHAR(50), errorDescription NVARCHAR(MAX), numberOfJobsAffected INT, messageId BIGINT)
IF OBJECT_ID('tempdb..#MostFrequentErrorAdvices') IS NOT NULL DROP TABLE #MostFrequentErrorAdvices
CREATE TABLE #MostFrequentErrorAdvices (errorCode NVARCHAR(50), ErrorAdvice NVARCHAR(1024), numberOfJobsAffected INT, messageId BIGINT)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MostFrequentErrors
	SELECT
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM
		@ResultXml.nodes('/JobManager_TopMostJobErrorsResp/waitingErrorList') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MostFrequentErrors
	SELECT
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM
		@ResultXml.nodes('/JobManager_TopMostJobErrorsResp/pendingErrorList') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MostFrequentErrors
	SELECT
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@errorDescription', 'NVARCHAR(MAX)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM
		@ResultXml.nodes('/JobManager_TopMostJobErrorsResp/failedErrorList') AS csInfo(n)
	INSERT INTO #MostFrequentErrorAdvices
	SELECT
		csInfo.n.value('@errorCode', 'NVARCHAR(50)'),
		csInfo.n.value('@AdviceDescription', 'NVARCHAR(1024)'),
		csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),
		csInfo.n.value('@messageId', 'BIGINT')
	FROM
		@ResultXml.nodes('/JobManager_TopMostJobErrorsResp/failedErrorAdviceList') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MonthlyTop10Errors
	SELECT
		csInfo.n.value('@MonthStart', 'DATE'),
		ISNULL(csInfo.n.value('@errorCode', 'nvarchar(50)'),0),
		ISNULL(csInfo.n.value('@errorDescription', 'nvarchar(max)'),0),
		ISNULL(csInfo.n.value('@numberOfJobsAffected', 'INTEGER'),0)
	FROM
		@ResultXml.nodes('/JobManager_TopMostJobErrorsResp/MonthlyFailedErrorList') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMostFrequentErrors
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		errorCode,
		errorDescription,
		numberOfJobsAffected,
		messageId
	FROM #MostFrequentErrors
	INSERT INTO cf_SurveyMostFrequentErrorAdvices
	SELECT
		@CSUniqueId,
		@ResultId,
		errorCode,
		ErrorAdvice,
		numberOfJobsAffected,
		messageId
	FROM #MostFrequentErrorAdvices
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DECLARE @LastUpdatedMonth DATE = (SELECT MAX(MonthStart) FROM cf_SurveyMonthlyErrorSummary WHERE CommServUniqueId = @CSUniqueId)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyMonthlyErrorSummary S
	USING #MonthlyTop10Errors T
		ON S.CommServUniqueId = @CSUniqueId AND S.MonthStart = T.MonthIntv AND S.errorCode = T.errorCode
	WHEN MATCHED AND  T.MonthIntv = @LastUpdatedMonth THEN
		UPDATE SET numberOfJobsAffected = T.numberOfJobsAffected
	WHEN NOT MATCHED AND T.MonthIntv IS NOT NULL THEN
		INSERT (CommServUniqueId, MonthStart, errorCode, errorDescription, numberOfJobsAffected)
		VALUES (@CSUniqueId, T.MonthIntv, T.errorCode, T.errorDescription, T.numberOfJobsAffected);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseMostFrequentErrorsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMostFrequentErrors')
	delete from GxQscripts where name = 'ParseMostFrequentErrors'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMostFrequentErrors')
	delete from GXDBVersions where aliasname = 'ParseMostFrequentErrors'
GO

insert into GXDBVersions values(2, 'ParseMostFrequentErrors',  '00010002006000110000', 'ParseMostFrequentErrors', '00010002006000110000')
GO

