

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMediaManagementSummary.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMediaManagementSummary.sp,v $ $Id: ParseMediaManagementSummary.sp,v 1.3.60.17.4.1 2021/04/20 22:37:13 aselvanayagam Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseMediaManagementSummary')
BEGIN
	print '>>> Drop Stored Procedure: ParseMediaManagementSummary <<<'
	drop procedure ParseMediaManagementSummary
END
IF EXISTS (select * from GxQscripts where name='ParseMediaManagementSummary')
	delete from GxQscripts where name = 'ParseMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'ParseMediaManagementSummary'
GO
print '... Creating Procedure: ParseMediaManagementSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseMediaManagementSummary
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseMediaManagementSummaryTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #MediaAgentSummary
(
	SurveyResultId			BIGINT NOT NULL,
	MAClientId				INT NOT NULL,
	MediaAgentName			NVARCHAR(256) NOT NULL,
	Offline					INT NOT NULL,
	OfflineReason			INT NOT NULL,
	OfflineTimeStamp		INT NOT NULL,
	OSName					VARCHAR(256) NOT NULL,
	ReleaseVersion			VARCHAR(32) NOT NULL,
	DataWrittenLastWeek		BIGINT NOT NULL,
	ApplianceType			INT NULL,
	NumOfDisks              INT NULL
)
CREATE TABLE #LibrarySummary
(
	SurveyResultId				BIGINT NOT NULL,
	LibraryId					INT NOT NULL,
	LibraryName					NVARCHAR(128) NOT NULL,
	LibraryTypeId				INT NOT NULL,
	Offline						INT NOT NULL,
	OfflineReason				INT NOT NULL,
	OfflineTimeStamp			INT NOT NULL,
	DataWrittenLastWeek			BIGINT NOT NULL,
	FreeSpaceMB					BIGINT NOT NULL,
	LowWaterMark				INT NOT NULL,
	ScratchPoolsBelowLWM		INT NOT NULL,
	SpareInLibrary				INT NOT NULL,
	SpareTotal					INT NOT NULL,
	Manufacturer				VARCHAR(16) NOT NULL,
	Model						VARCHAR(32) NOT NULL,
	SerialNumber				VARCHAR(32) NOT NULL,
	FirmwareRevision			VARCHAR(32) NOT NULL,
	Slots						INT NOT NULL,
	EmptySlots					INT NOT NULL,
	Hidden						INT NOT NULL,
	Enabled						INT NOT NULL,
	LibraryInstallTime			INT NULL,
	NumMediaAgents				INT NULL,
	MediaAgents					NVARCHAR(1024) NULL,
	TotalSpaceMB				BIGINT NULL,
	DataWrittenMB				BIGINT NULL
)
CREATE TABLE #LibraryControllerSummary
(
	SurveyResultId				BIGINT NOT NULL,
	MAClientId					INT NOT NULL,
	LibraryId					INT NOT NULL,
	ControllerId				INT NOT NULL,
	ControllerName				VARCHAR(144) NOT NULL,
	Active						INT NOT NULL,
	Enabled						INT NOT NULL,
	SCSIAddress					VARCHAR(32) NOT NULL
)
CREATE TABLE #MountPathSummary
(
	SurveyResultId				BIGINT NOT NULL,
	LibraryId					INT NOT NULL,
	MountPathId					INT NOT NULL,
	MountPathName				NVARCHAR(1024),
	Offline						INT NOT NULL,
	OfflineReason				INT NOT NULL,
	OfflineTimeStamp			INT NOT NULL,
	CostCategory				NVARCHAR(256),
	TotalSpaceMB				BIGINT NULL,
	FreeSpaceMB					BIGINT NULL,
	ReservedSpaceMB				BIGINT NULL,
	DataWrittenMB				BIGINT NULL,
	Enabled						INT NULL,
	MaxConcurrentWriters		INT NULL,
	HardDrive					NVARCHAR(1024) NULL,
	HardDriveShared				INT NULL,
	BaseFolder					NVARCHAR(1024),
	DeviceName					NVARCHAR(128)
)
CREATE TABLE #DriveControllerSummary
(
	SurveyResultId				BIGINT NOT NULL,
	MAClientId					INT NOT NULL,
	DriveId						INT NOT NULL,
	ControllerId				INT NOT NULL,
	ControllerName				VARCHAR(144) NOT NULL,
	Active						INT NOT NULL,
	Enabled						INT NOT NULL,
	DriveAccessible				INT NOT NULL,
	OfflineTimeStamp			INT NOT NULL,
	SCSIAddress					VARCHAR(32) NOT NULL
)
CREATE TABLE #StoragePoolSummary
(
	SurveyResultId				BIGINT NOT NULL,
	StoragePoolId				INT NOT NULL,
	StoragePoolName				NVARCHAR(256) NOT NULL,
	StoragePoolType				INT NOT NULL,
	LibraryIds					VARCHAR(1024) NOT NULL,
	LibraryType					INT NOT NULL,
	ApplianceType				INT NOT NULL,
	TotalControllers			INT NOT NULL,
	ActiveControllers			INT NOT NULL,
	LibOfflineReason			INT NOT NULL,
	MPOfflineReason				INT NOT NULL,
	MAOfflineReason				INT NOT NULL,
	NumMediaAgents				INT NOT NULL,
	MediaAgents					NVARCHAR(1024) NOT NULL,
	DeviceTypeId				INT,
)
CREATE TABLE #HyperScaleStoragePools
(
	CommServUniqueId			INT NOT NULL,
	StoragePoolId				INT NOT NULL,
	StoragePoolName				NVARCHAR(256) NOT NULL
)
CREATE TABLE #HyperScaleUsageHistory
(
	CommServUniqueId	INT NOT NULL,
	LogDateUTC			DATETIME NOT NULL,
	ApplianceType		INT NOT NULL,
	NumStoragePools		INT NOT NULL,
	NumMediaAgents		INT NOT NULL,
	TotalSpaceMB		BIGINT NOT NULL,
	FreeSpaceMB			BIGINT NOT NULL,
	DataWrittenMB		BIGINT NOT NULL,
	NumClients			INT NOT NULL,
	NumVMs				INT NOT NULL,
	NumMAs1To12Disks	INT NOT NULL,
	NumMAs13To24Disks	INT NOT NULL,
	HyperScaleVersion	INT NOT NULL
)
CREATE TABLE #MetallicStoragePools
(
	CommServUniqueId			INT NOT NULL,
	StoragePoolId				INT NOT NULL,
	StoragePoolName				NVARCHAR(256) NOT NULL
)
CREATE TABLE #MetallicContainers
(
	CommServUniqueId			INT NOT NULL,
	ContainerId					INT NOT NULL,
	ContainerName				VARCHAR(64) NOT NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MediaAgentSummary (
			SurveyResultId, MAClientId, MediaAgentName, Offline, OfflineReason, OfflineTimeStamp, OSName, ReleaseVersion, DataWrittenLastWeek, ApplianceType, NumOfDisks)
	SELECT DISTINCT
			@ResultId,
			csInfo.n.value('@MAClientId', 'INT'),
			csInfo.n.value('@MediaAgentName', 'NVARCHAR(256)'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@OSName', 'VARCHAR(256)'),
			csInfo.n.value('@ReleaseVersion', 'VARCHAR(32)'),
			csInfo.n.value('@DataWrittenLastWeek', 'BIGINT'),
			csInfo.n.value('@ApplianceType', 'INT'),
			csInfo.n.value('@NumOfDisks', 'INT')
	FROM	@ResultXml.nodes('/MediaManagementSummary/MediaAgent') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #LibrarySummary (
			SurveyResultId, LibraryId, LibraryName, LibraryTypeId, Offline, OfflineReason, OfflineTimeStamp,
			DataWrittenLastWeek, FreeSpaceMB, LowWaterMark, ScratchPoolsBelowLWM, SpareInLibrary, SpareTotal,
			Manufacturer, Model, SerialNumber, FirmwareRevision, Slots, EmptySlots, Hidden, Enabled,
			LibraryInstallTime, NumMediaAgents, MediaAgents, TotalSpaceMB, DataWrittenMB)
	SELECT DISTINCT
			@ResultId,
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@LibraryName', 'NVARCHAR(128)'),
			csInfo.n.value('@LibraryTypeId', 'INT'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@DataWrittenLastWeek', 'BIGINT'),
			ISNULL(csInfo.n.value('@FreeSpaceMB', 'BIGINT'), -1),
			csInfo.n.value('@LowWaterMark', 'BIGINT'),
			csInfo.n.value('@ScratchPoolsBelowLWM', 'INT'),
			csInfo.n.value('@SpareInLibrary', 'INT'),
			csInfo.n.value('@SpareTotal', 'INT'),
			csInfo.n.value('@Manufacturer', 'VARCHAR(16)'),
			csInfo.n.value('@Model', 'VARCHAR(32)'),
			csInfo.n.value('@SerialNumber', 'VARCHAR(32)'),
			csInfo.n.value('@FirmwareRevision', 'VARCHAR(32)'),
			csInfo.n.value('@Slots', 'INT'),
			csInfo.n.value('@EmptySlots', 'INT'),
			ISNULL(csInfo.n.value('@Hidden', 'INT'),0),
			ISNULL(csInfo.n.value('@Enabled','INT'),1),
			csInfo.n.value('@LibraryInstallTime', 'INT'),
			csInfo.n.value('@NumMediaAgents', 'INT'),
			csInfo.n.value('@MediaAgents', 'NVARCHAR(1024)'),
			csInfo.n.value('@TotalSpaceMB', 'BIGINT'),
			csInfo.n.value('@DataWrittenMB', 'BIGINT')
	FROM	@ResultXml.nodes('/MediaManagementSummary/Library') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #LibraryControllerSummary (
			SurveyResultId, MAClientId, LibraryId, ControllerId, ControllerName, Active, Enabled, SCSIAddress)
	SELECT DISTINCT
			@ResultId,
			csInfo.n.value('@MAClientId', 'INT'),
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@ControllerId', 'INT'),
			csInfo.n.value('@ControllerName', 'VARCHAR(144)'),
			csInfo.n.value('@Active', 'INT'),
			csInfo.n.value('@Enabled', 'INT'),
			csInfo.n.value('@SCSIAddress', 'VARCHAR(32)')
	FROM	@ResultXml.nodes('/MediaManagementSummary/LibraryController') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MountPathSummary (
			SurveyResultId, LibraryId, MountPathId, MountPathName, Offline, OfflineReason, OfflineTimeStamp, CostCategory,
			TotalSpaceMB, FreeSpaceMB, ReservedSpaceMB, DataWrittenMB, Enabled, MaxConcurrentWriters, HardDrive, HardDriveShared,
			BaseFolder, DeviceName)
	SELECT DISTINCT
			@ResultId,
			csInfo.n.value('@LibraryId', 'INT'),
			csInfo.n.value('@MountPathId', 'INT'),
			csInfo.n.value('@MountPathName', 'NVARCHAR(1024)'),
			csInfo.n.value('@Offline', 'INT'),
			csInfo.n.value('@OfflineReason', 'INT'),
			csInfo.n.value('@OfflineTimeStamp', 'INT'),
			csInfo.n.value('@CostCategory', 'NVARCHAR(256)'),
			csInfo.n.value('@TotalSpaceMB',    'BIGINT'),
			csInfo.n.value('@FreeSpaceMB',     'BIGINT'),
			csInfo.n.value('@ReservedSpaceMB', 'BIGINT'),
			csInfo.n.value('@DataWrittenMB',   'BIGINT'),
			csInfo.n.value('@Enabled', 'INT'),
			csInfo.n.value('@MaxConcurrentWriters', 'INT'),
			csInfo.n.value('@HardDrive', 'NVARCHAR(1024)'),
			ISNULL(csInfo.n.value('@HardDriveShared', 'INT'), -1),
			csInfo.n.value('@BaseFolder', 'NVARCHAR(1024)'),
			csInfo.n.value('@DeviceName', 'NVARCHAR(128)')
	FROM	@ResultXml.nodes('/MediaManagementSummary/MountPath') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #DriveControllerSummary (
			SurveyResultId, MAClientId, DriveId, ControllerId, ControllerName,
			Active, Enabled, DriveAccessible, OfflineTimeStamp, SCSIAddress)
	SELECT DISTINCT
			@ResultId,
			ISNULL(csInfo.n.value('@MAClientId', 'INT'), 0),
			csInfo.n.value('@DriveId', 'INT'),
			csInfo.n.value('@ControllerId', 'INT'),
			ISNULL(csInfo.n.value('@ControllerName', 'VARCHAR(144)'), ''),
			ISNULL(csInfo.n.value('@Active', 'INT'), 0),
			ISNULL(csInfo.n.value('@Enabled', 'INT'), 0),
			ISNULL(csInfo.n.value('@DriveAccessible', 'INT'), 0),
			ISNULL(csInfo.n.value('@OfflineTimeStamp', 'INT'), 0),
			ISNULL(csInfo.n.value('@SCSIAddress', 'VARCHAR(32)'), '')
	FROM	@ResultXml.nodes('/MediaManagementSummary/DriveController') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #StoragePoolSummary (
			SurveyResultId, StoragePoolId, StoragePoolName, StoragePoolType,
			LibraryIds, LibraryType, ApplianceType, TotalControllers, ActiveControllers,
			LibOfflineReason, MPOfflineReason, MAOfflineReason, NumMediaAgents, MediaAgents, DeviceTypeId)
	SELECT DISTINCT
			@ResultId,
			csInfo.n.value('@StoragePoolId', 'INT'),
			csInfo.n.value('@StoragePoolName', 'NVARCHAR(256)'),
			csInfo.n.value('@StoragePoolType', 'INT'),
			csInfo.n.value('@LibraryIds', 'VARCHAR(1024)'),
			csInfo.n.value('@LibraryType', 'INT'),
			csInfo.n.value('@ApplianceType', 'INT'),
			csInfo.n.value('@TotalControllers', 'INT'),
			csInfo.n.value('@ActiveControllers', 'INT'),
			csInfo.n.value('@LibOfflineReason', 'INT'),
			csInfo.n.value('@MPOfflineReason', 'INT'),
			csInfo.n.value('@MAOfflineReason', 'INT'),
			csInfo.n.value('@NumMediaAgents', 'INT'),
			ISNULL(csInfo.n.value('@MediaAgents', 'NVARCHAR(1024)'), ''),
			csInfo.n.value('@DeviceTypeId', 'INT')
	FROM	@ResultXml.nodes('/MediaManagementSummary/StoragePool') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #HyperScaleStoragePools
	SELECT	S.CommServUniqueId, S.StoragePoolId, S.StoragePoolName
	FROM	(SELECT DISTINCT @CSUniqueId AS CommServUniqueId, StoragePoolId, StoragePoolName
			FROM #StoragePoolSummary
			WHERE StoragePoolType = 4) AS S
			LEFT OUTER JOIN cf_SurveyHyperScaleStoragePools AS T
				ON S.CommServUniqueId = T.CommServUniqueId AND S.StoragePoolId = T.StoragePoolId AND S.StoragePoolName = T.StoragePoolName
	WHERE	T.StoragePoolId IS NULL
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #HyperScaleUsageHistory (
			CommServUniqueId, LogDateUTC, ApplianceType, NumStoragePools, NumMediaAgents, TotalSpaceMB, FreeSpaceMB, DataWrittenMB, NumClients, NumVMs, NumMAs1To12Disks, NumMAs13To24Disks, HyperScaleVersion)
	SELECT DISTINCT
			@CSUniqueId,
			@LogDateUTC,
			csInfo.n.value('@ApplianceType', 'INT'),
			csInfo.n.value('@NumStoragePools', 'INT'),
			csInfo.n.value('@NumMediaAgents', 'INT'),
			csInfo.n.value('@TotalSpaceMB', 'BIGINT'),
			csInfo.n.value('@FreeSpaceMB', 'BIGINT'),
			csInfo.n.value('@DataWrittenMB', 'BIGINT'),
			csInfo.n.value('@NumClients', 'INT'),
			csInfo.n.value('@NumVMs', 'INT'),
			ISNULL(csInfo.n.value('@NumMAs1To12Disks', 'INT'), 0),
			ISNULL(csInfo.n.value('@NumMAs13To24Disks', 'INT'), 0),
			ISNULL(csInfo.n.value('@HyperScaleVersion', 'INT'), 0)
	FROM	@ResultXml.nodes('/MediaManagementSummary/HyperScaleUsage') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT	INTO #MetallicStoragePools
	SELECT	S.CommServUniqueId, S.StoragePoolId, S.StoragePoolName
	FROM	(SELECT DISTINCT @CSUniqueId AS CommServUniqueId, StoragePoolId, StoragePoolName
			FROM #StoragePoolSummary
			WHERE DeviceTypeId = 400) AS S
			LEFT OUTER JOIN cf_SurveyMetallicStoragePools AS T
				ON S.CommServUniqueId = T.CommServUniqueId AND S.StoragePoolId = T.StoragePoolId AND S.StoragePoolName = T.StoragePoolName
	WHERE	T.StoragePoolId IS NULL
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #MetallicContainers (
			CommServUniqueId, ContainerId, ContainerName)
	SELECT DISTINCT
			@CSUniqueId,
			csInfo.n.value('@ContainerId', 'INT'),
			csInfo.n.value('@ContainerName', 'VARCHAR(64)')
	FROM	@ResultXml.nodes('/MediaManagementSummary/MetallicContainer') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMediaAgentSummary (
			SurveyResultId, MAClientId, MediaAgentName, Offline, OfflineReason, OfflineTimeStamp, OSName, ReleaseVersion, DataWrittenLastWeek, ApplianceType, NumOfDisks)
	SELECT 	SurveyResultId, MAClientId, MediaAgentName, Offline, OfflineReason, OfflineTimeStamp, OSName, ReleaseVersion, DataWrittenLastWeek, ApplianceType, NumOfDisks
	FROM	#MediaAgentSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyLibrarySummary (
			SurveyResultId, LibraryId, LibraryName, LibraryTypeId, Offline, OfflineReason, OfflineTimeStamp,
			DataWrittenLastWeek, FreeSpaceMB, LowWaterMark, ScratchPoolsBelowLWM, SpareInLibrary, SpareTotal,
			Manufacturer, Model, SerialNumber, FirmwareRevision, Slots, EmptySlots, LibraryInstallTime,
			NumMediaAgents, MediaAgents, TotalSpaceMB, DataWrittenMB)
	SELECT	SurveyResultId, LibraryId, LibraryName, LibraryTypeId, Offline, OfflineReason, OfflineTimeStamp,
			DataWrittenLastWeek, FreeSpaceMB, LowWaterMark, ScratchPoolsBelowLWM, SpareInLibrary, SpareTotal,
			Manufacturer, Model, SerialNumber, FirmwareRevision, Slots, EmptySlots, LibraryInstallTime,
			NumMediaAgents, MediaAgents, TotalSpaceMB, DataWrittenMB
	FROM	#LibrarySummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	DELETE	cf_SurveyLibrary
	FROM	cf_SurveyLibrary L INNER JOIN #LibrarySummary S
			ON L.CommservUniqueId = @CSUniqueId AND L.LibraryId = S.LibraryId
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	cf_SurveyLibrary SET Deleted = 1
	WHERE	CommservUniqueId = @CSUniqueId AND Deleted = 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyLibrary (
			CommservUniqueId, LibraryId, LibraryName, LibraryTypeId, Deleted, Hidden, Enabled)
	SELECT	@CSUniqueId, LibraryId, LibraryName, LibraryTypeId, 0, Hidden, Enabled
	FROM	#LibrarySummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyLibraryControllerSummary (
			SurveyResultId, MAClientId, LibraryId, ControllerId, ControllerName, Active, Enabled, SCSIAddress)
	SELECT	SurveyResultId, MAClientId, LibraryId, ControllerId, ControllerName, Active, Enabled, SCSIAddress
	FROM	#LibraryControllerSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMountPathSummary (
			SurveyResultId, LibraryId, MountPathId, MountPathName, Offline, OfflineReason, OfflineTimeStamp, CostCategory,
			TotalSpaceMB, FreeSpaceMB, ReservedSpaceMB, DataWrittenMB, Enabled, MaxConcurrentWriters, HardDrive, HardDriveShared,
			BaseFolder, DeviceName)
	SELECT	SurveyResultId, LibraryId, MountPathId, MountPathName, Offline, OfflineReason, OfflineTimeStamp, CostCategory,
			TotalSpaceMB, FreeSpaceMB, ReservedSpaceMB, DataWrittenMB, Enabled, MaxConcurrentWriters, HardDrive, HardDriveShared,
			BaseFolder, DeviceName
	FROM	#MountPathSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDriveControllerSummary (
			SurveyResultId, MAClientId, DriveId, ControllerId, ControllerName,
			Active, Enabled, DriveAccessible, OfflineTimeStamp, SCSIAddress)
	SELECT	SurveyResultId, MAClientId, DriveId, ControllerId, ControllerName,
			Active, Enabled, DriveAccessible, OfflineTimeStamp, SCSIAddress
	FROM	#DriveControllerSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyStoragePoolSummary (
			SurveyResultId, StoragePoolId, StoragePoolName, StoragePoolType,
			LibraryIds, LibraryType, ApplianceType, TotalControllers, ActiveControllers,
			LibOfflineReason, MPOfflineReason, MAOfflineReason, NumMediaAgents, MediaAgents)
	SELECT	SurveyResultId, StoragePoolId, StoragePoolName, StoragePoolType,
			LibraryIds, LibraryType, ApplianceType, TotalControllers, ActiveControllers,
			LibOfflineReason, MPOfflineReason, MAOfflineReason, NumMediaAgents, MediaAgents
	FROM	#StoragePoolSummary
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT 1 FROM #HyperScaleStoragePools)
BEGIN
	MERGE	cf_SurveyHyperScaleStoragePools AS T
	USING	(SELECT CommServUniqueId, StoragePoolId, StoragePoolName FROM #HyperScaleStoragePools
			) AS S ON T.CommServUniqueId = S.CommServUniqueId AND T.StoragePoolId = S.StoragePoolId
			WHEN MATCHED
				THEN UPDATE SET T.StoragePoolName = S.StoragePoolName
			WHEN NOT MATCHED BY TARGET
				THEN INSERT (CommServUniqueId, StoragePoolId, StoragePoolName)
				VALUES(S.CommServUniqueId, S.StoragePoolId, S.StoragePoolName);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
AND NOT EXISTS (SELECT 1 FROM cf_SurveyHyperScaleUsageHistory WHERE CommServUniqueId = @CSUniqueId AND LogDateUTC = @LogDateUTC)
BEGIN
	INSERT INTO cf_SurveyHyperScaleUsageHistory (
			CommServUniqueId, LogDateUTC, ApplianceType, NumStoragePools, NumMediaAgents, TotalSpaceMB, FreeSpaceMB, DataWrittenMB, NumClients, NumVMs, NumMAs1To12Disks, NumMAs13To24Disks, HyperScaleVersion)
	SELECT	CommServUniqueId, LogDateUTC, ApplianceType, NumStoragePools, NumMediaAgents, TotalSpaceMB, FreeSpaceMB, DataWrittenMB, NumClients, NumVMs, NumMAs1To12Disks, NumMAs13To24Disks, HyperScaleVersion
	FROM	#HyperScaleUsageHistory
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT 1 FROM #MetallicStoragePools)
BEGIN
	MERGE	cf_SurveyMetallicStoragePools AS T
	USING	(SELECT CommServUniqueId, StoragePoolId, StoragePoolName FROM #MetallicStoragePools
			) AS S ON T.CommServUniqueId = S.CommServUniqueId AND T.StoragePoolId = S.StoragePoolId
			WHEN MATCHED
				THEN UPDATE SET T.StoragePoolName = S.StoragePoolName
			WHEN NOT MATCHED BY TARGET
				THEN INSERT (CommServUniqueId, StoragePoolId, StoragePoolName)
				VALUES(S.CommServUniqueId, S.StoragePoolId, S.StoragePoolName);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0 AND EXISTS (SELECT 1 FROM #MetallicContainers WHERE CommServUniqueId = @CSUniqueId)
BEGIN
	MERGE	cf_SurveyMetallicContainers AS T
	USING	(SELECT CommServUniqueId, ContainerId, ContainerName FROM #MetallicContainers
			) AS S ON T.CommServUniqueId = S.CommServUniqueId AND T.ContainerId = S.ContainerId
			WHEN MATCHED
				THEN UPDATE SET T.ContainerName = S.ContainerName
			WHEN NOT MATCHED BY TARGET
				THEN INSERT (CommServUniqueId, ContainerId, ContainerName)
				VALUES(S.CommServUniqueId, S.ContainerId, S.ContainerName);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseMediaManagementSummaryTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMediaManagementSummary')
	delete from GxQscripts where name = 'ParseMediaManagementSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaManagementSummary')
	delete from GXDBVersions where aliasname = 'ParseMediaManagementSummary'
GO

insert into GXDBVersions values(2, 'ParseMediaManagementSummary',  'v1.3.60.17.4.1', 'ParseMediaManagementSummary', 'v1.3.60.17.4.1')
GO

