

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseMediaAgentProp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseMediaAgentProp.sp,v $ $Id: ParseMediaAgentProp.sp,v 1.4.60.6 2020/12/17 02:53:32 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseMediaAgentProp')
BEGIN
	print '>>> Drop Stored Procedure: ParseMediaAgentProp <<<'
	drop procedure ParseMediaAgentProp
END
IF EXISTS (select * from GxQscripts where name='ParseMediaAgentProp')
	delete from GxQscripts where name = 'ParseMediaAgentProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaAgentProp')
	delete from GXDBVersions where aliasname = 'ParseMediaAgentProp'
GO
print '... Creating Procedure: ParseMediaAgentProp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseMediaAgentProp
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseMediaAgentPropTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyMediaAgentProp
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		csInfo.n.value('@MAClientID', 'INT'),
		csInfo.n.value('@MediaAgentName', 'NVARCHAR(256)'),
		csInfo.n.value('@MAReleaseVersion', 'VARCHAR(8)'),
		csInfo.n.value('@MAEnabled', 'INT'),
		csInfo.n.value('@MAAttribute', 'INT'),
		csInfo.n.value('@ScanIntervalInSec', 'INT'),
		csInfo.n.value('@MaxReservations', 'INT'),
		csInfo.n.value('@NwErrorRetryFlag', 'INT'),
		csInfo.n.value('@NwErrorRetryFrequency', 'INT'),
		csInfo.n.value('@NwErrorRetryCount', 'INT'),
		csInfo.n.value('@AccessPathEnabled', 'INT'),
		csInfo.n.value('@UseNetworkShare', 'INT'),
		csInfo.n.value('@AccessPathFlags', 'INT'),
		csInfo.n.value('@IdxCleanupPct', 'INT'),
		csInfo.n.value('@IdxCacheServerClientId', 'INT'),
		csInfo.n.value('@IdxMinFreeSpaceMB', 'INT'),
		csInfo.n.value('@IdxFreeSpaceWarningMB', 'INT'),
		csInfo.n.value('@IdxCacheFlags', 'INT'),
		csInfo.n.value('@IdxPoolIsShared', 'INT'),
		csInfo.n.value('@IdxRetentionDays', 'INT'),
		csInfo.n.value('@FirewallSettings', 'INT'),
		csInfo.n.value('@FwNetworkWithCS', 'INT'),
		csInfo.n.value('@FwConnectionWithCS', 'INT'),
		csInfo.n.value('@FwUseRemoteProxyCS', 'INT'),
		csInfo.n.value('@FwNetworkWithMA', 'INT'),
		csInfo.n.value('@FwConnectionWithMA', 'INT'),
		csInfo.n.value('@FwUseRemoteProxyMA', 'INT'),
		csInfo.n.value('@FwKeepAliveSeconds', 'INT'),
		csInfo.n.value('@FwTunnelInitSeconds', 'INT'),
		csInfo.n.value('@FwForeceSSL', 'INT'),
		csInfo.n.value('@FwLockDown', 'INT'),
		csInfo.n.value('@FwBindOpenPortsOnly', 'INT'),
		csInfo.n.value('@FwIsDMZ', 'INT'),
		csInfo.n.value('@FwIsRoamingClient', 'INT'),
		ISNULL(csInfo.n.value('@FwDefOutgoingProtocol', 'INT'), 0),
		csInfo.n.value('@NwThrottlingEnabled', 'INT'),
		csInfo.n.value('@NwShareBandwidth', 'INT'),
		csInfo.n.value('@NwDaysOfWeek', 'INT'),
		csInfo.n.value('@NwStartTime', 'INT'),
		csInfo.n.value('@NwEndTime', 'INT'),
		csInfo.n.value('@NwIsAbsolute', 'INT'),
		csInfo.n.value('@NwSendEnabled', 'INT'),
		csInfo.n.value('@NwSendRate', 'INT'),
		csInfo.n.value('@NwSendRatePct', 'INT'),
		csInfo.n.value('@NwRecvEnabled', 'INT'),
		csInfo.n.value('@NwRecvRate', 'INT'),
		csInfo.n.value('@NwRecvRatePct', 'INT')
	FROM
		@ResultXml.nodes('/MediaAgentProp') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseMediaAgentPropTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseMediaAgentProp')
	delete from GxQscripts where name = 'ParseMediaAgentProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseMediaAgentProp')
	delete from GXDBVersions where aliasname = 'ParseMediaAgentProp'
GO

insert into GXDBVersions values(2, 'ParseMediaAgentProp',  '00010004006000060000', 'ParseMediaAgentProp', '00010004006000060000')
GO

