

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLongRunningJobs.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLongRunningJobs.sp,v $ $Id: ParseLongRunningJobs.sp,v 1.5.32.9 2020/12/17 02:48:38 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLongRunningJobs')
BEGIN
	print '>>> Drop Stored Procedure: ParseLongRunningJobs <<<'
	drop procedure ParseLongRunningJobs
END
IF EXISTS (select * from GxQscripts where name='ParseLongRunningJobs')
	delete from GxQscripts where name = 'ParseLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLongRunningJobs')
	delete from GXDBVersions where aliasname = 'ParseLongRunningJobs'
GO
print '... Creating Procedure: ParseLongRunningJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLongRunningJobs
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLongRunningJobsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #LongRunningJobs (
	jobId BIGINT, clientId BIGINT, clientName NVARCHAR(MAX), agentName NVARCHAR(MAX), backupType NVARCHAR(25),
	durationHr DECIMAL(8, 2), appSizeGB FLOAT
)
CREATE TABLE #LongRunningFSFullJobs (
	jobId BIGINT, clientId BIGINT, clientName NVARCHAR(MAX), agentTypeId INT, agentName NVARCHAR(MAX), backupType NVARCHAR(25),
	durationHr DECIMAL(8, 2), actualBKPDurationHr DECIMAL(8, 2), appSizeGB FLOAT, status NVARCHAR(MAX),
	isDeDupEnabled INT, isSourceDeDupEnabled INT, isDASHEnabled INT
)
CREATE TABLE #LongRunningVSAFullJobs (
	jobId BIGINT, clientId BIGINT, clientName NVARCHAR(MAX), agentTypeId INT, agentName NVARCHAR(MAX), backupType NVARCHAR(25),
	durationHr DECIMAL(8, 2), actualBKPDurationHr DECIMAL(8, 2), appSizeGB FLOAT, status NVARCHAR(MAX),
	isDeDupEnabled INT, isSourceDeDupEnabled INT, isDASHEnabled INT, hypervisorType NVARCHAR(25),
	isSPEnabled INT, transportMode NVARCHAR(MAX), startTime DATETIME, endTime DATETIME
)
CREATE TABLE #LongRunningFullJobs (
	jobId BIGINT, clientId BIGINT, clientName NVARCHAR(MAX), agentTypeId INT, agentName NVARCHAR(MAX), backupType NVARCHAR(25),
	durationHr DECIMAL(8, 2), actualBKPDurationHr DECIMAL(8, 2), appSizeGB FLOAT, status NVARCHAR(MAX),
	isDeDupEnabled INT, isSourceDeDupEnabled INT, isDASHEnabled INT, isSPEnabled INT
)
DECLARE @ClientGroups NVARCHAR(MAX)
DECLARE @TopN INT
DECLARE @LongRunningJobs INT
DECLARE @LongRunningFSFullJobs INT
DECLARE @TotalFSSCCount INT
DECLARE @LongRunningFSSCCount INT
DECLARE @LongRunningOtherFullJobs INT
DECLARE @TotalOtherSCCount INT
DECLARE @LongRunningOtherSCCount INT
DECLARE @LongRunningVSAFullJobs INT
DECLARE @TotalVSASCCount INT
DECLARE @LongRunningVSASCCount INT
IF 	@ErrorCode = 0
BEGIN
	SELECT
		@ClientGroups = csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		@TopN = csInfo.n.value('@TopN', 'INTEGER'),
		@LongRunningJobs = ISNULL(csInfo.n.value('@LongRunningJobs', 'INTEGER'), 0),
		@LongRunningFSFullJobs = ISNULL(csInfo.n.value('@LongRunningFSFullJobs', 'INTEGER'), 0),
		@TotalFSSCCount = ISNULL(csInfo.n.value('@TotalFSSCCount', 'INTEGER'), 0),
		@LongRunningFSSCCount = ISNULL(csInfo.n.value('@LongRunningFSSCCount', 'INTEGER'), 0),
		@LongRunningOtherFullJobs = ISNULL(csInfo.n.value('@LongRunningOtherFullJobs', 'INTEGER'), 0),
		@TotalOtherSCCount = ISNULL(csInfo.n.value('@TotalOtherSCCount', 'INTEGER'), 0),
		@LongRunningOtherSCCount = ISNULL(csInfo.n.value('@LongRunningOtherSCCount', 'INTEGER'), 0),
		@LongRunningVSAFullJobs = ISNULL(csInfo.n.value('@LongRunningVSAFullJobs', 'INTEGER'), 0),
		@TotalVSASCCount = ISNULL(csInfo.n.value('@TotalOtherSCCount', 'INTEGER'), 0),
		@LongRunningVSASCCount = ISNULL(csInfo.n.value('@LongRunningOtherSCCount', 'INTEGER'), 0)
	FROM
		@ResultXml.nodes('/LongRunJobs') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process all Long Running Jobs
	INSERT INTO #LongRunningJobs
	SELECT
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT')
	FROM
		@ResultXml.nodes('/LongRunJobs/Job') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #LongRunningFSFullJobs
	SELECT
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER')
	FROM
		@ResultXml.nodes('/LongRunJobs/FSFulljobs') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #LongRunningVSAFullJobs
	SELECT
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER'),
		csInfo.n.value('@hypervisorType', 'NVARCHAR(25)'),
		csInfo.n.value('@isSPEnabled', 'INTEGER'),
		csInfo.n.value('@transportMode', 'NVARCHAR(MAX)'),
		ISNULL(csInfo.n.value('@startTime','DATETIME'),'1970-01-01 00:00:00.000'),
		ISNULL(csInfo.n.value('@endTime','DATETIME'),'1970-01-01 00:00:00.000')
	FROM
		@ResultXml.nodes('/LongRunJobs/VSAjobs') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #LongRunningFullJobs
	SELECT
		csInfo.n.value('@jobId', 'BIGINT'),
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@agentTypeId', 'BIGINT'),
		csInfo.n.value('@agentName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@durationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@actualBKPDurationHr', 'DECIMAL(8, 2)'),
		csInfo.n.value('@appSizeGB', 'FLOAT'),
		csInfo.n.value('@status', 'NVARCHAR(MAX)'),
		csInfo.n.value('@isDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isSourceDeDupEnabled', 'INTEGER'),
		csInfo.n.value('@isDASHEnabled', 'INTEGER'),
		csInfo.n.value('@isSPEnabled', 'INTEGER')
	FROM
		@ResultXml.nodes('/LongRunJobs/Appjobs') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process all Long Running Jobs
	INSERT INTO cf_SurveyLongRunningJobs
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		jobId,
		clientId,
		clientName,
		agentName,
		backupType,
		durationHr,
		appSizeGB,
		@TopN,
		@LongRunningJobs
	FROM #LongRunningJobs
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process FS Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningFSFullJobs
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningFSFullJobs,
		@TotalFSSCCount,
		@LongRunningFSSCCount,
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningFSFullJobs,
		@TotalFSSCCount,
		@LongRunningFSSCCount,
		jobId,
		clientId,
		clientName,
		agentTypeId,
		agentName,
		backupType,
		durationHr,
		actualBKPDurationHr,
		appSizeGB,
		status,
		isDeDupEnabled,
		isSourceDeDupEnabled,
		isDASHEnabled
	FROM #LongRunningFSFullJobs
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process VSA Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningVSAFullJobs
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningVSAFullJobs,
		@TotalVSASCCount,
		@LongRunningVSASCCount,
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0, '', 0, '','1970-01-01 00:00:00.000','1970-01-01 00:00:00.000'
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningVSAFullJobs,
		@TotalVSASCCount,
		@LongRunningVSASCCount,
		jobId,
		clientId,
		clientName,
		agentTypeId,
		agentName,
		backupType,
		durationHr,
		actualBKPDurationHr,
		appSizeGB,
		status,
		isDeDupEnabled,
		isSourceDeDupEnabled,
		isDASHEnabled,
		hypervisorType,
		isSPEnabled,
		transportMode,
		startTime,
		endTime
	FROM #LongRunningVSAFullJobs
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process Other Application Full Long Running Jobs
	INSERT INTO cf_SurveyLongRunningFullJobs
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningOtherFullJobs,
		@TotalOtherSCCount,
		@LongRunningOtherSCCount,
		0, 0, '', 0, '', '', 0, 0, 0, '', 0, 0, 0, 0
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@TopN,
		@LongRunningOtherFullJobs,
		@TotalOtherSCCount,
		@LongRunningOtherSCCount,
		jobId,
		clientId,
		clientName,
		agentTypeId,
		agentName,
		backupType,
		durationHr,
		actualBKPDurationHr,
		appSizeGB,
		status,
		isDeDupEnabled,
		isSourceDeDupEnabled,
		isDASHEnabled,
		isSPEnabled
	FROM #LongRunningFullJobs
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLongRunningJobsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLongRunningJobs')
	delete from GxQscripts where name = 'ParseLongRunningJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLongRunningJobs')
	delete from GXDBVersions where aliasname = 'ParseLongRunningJobs'
GO

insert into GXDBVersions values(2, 'ParseLongRunningJobs',  '00010005003200090000', 'ParseLongRunningJobs', '00010005003200090000')
GO

