

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseLargestClientsByBKPSize.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseLargestClientsByBKPSize.sp,v $ $Id: ParseLargestClientsByBKPSize.sp,v 1.5.48.7 2020/12/17 02:53:50 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseLargestClientsByBKPSize')
BEGIN
	print '>>> Drop Stored Procedure: ParseLargestClientsByBKPSize <<<'
	drop procedure ParseLargestClientsByBKPSize
END
IF EXISTS (select * from GxQscripts where name='ParseLargestClientsByBKPSize')
	delete from GxQscripts where name = 'ParseLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'ParseLargestClientsByBKPSize'
GO
print '... Creating Procedure: ParseLargestClientsByBKPSize'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseLargestClientsByBKPSize
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseLargestClientsByBKPSizeTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @ClientGroups NVARCHAR(MAX)
DECLARE @LargestFSClients INT
DECLARE @LargestNoArchiveFSClients INT
DECLARE @LargestAppClients INT
DECLARE @LargestNoSnapAppClients INT
DECLARE @LargestEmailClients INT
DECLARE @LargestNoArchiveEmailClients INT
DECLARE @AvgRestoreThroughputGBPerHR FLOAT
DECLARE @TopN INT
IF 	@ErrorCode = 0
BEGIN
	--Process Largest Other Clients
	SELECT
		@ClientGroups = csInfo.n.value('@clientGroups', 'NVARCHAR(MAX)'),
		@LargestFSClients = csInfo.n.value('@LargestFSClients', 'INTEGER'),
		@LargestNoArchiveFSClients = csInfo.n.value('@LargestNoArchiveFSClients', 'INTEGER'),
		@LargestAppClients = csInfo.n.value('@LargestAppClients', 'INTEGER'),
		@LargestNoSnapAppClients = csInfo.n.value('@LargestNoSnapAppClients', 'INTEGER'),
		@LargestEmailClients = csInfo.n.value('@LargestEmailClients', 'INTEGER'),
		@LargestNoArchiveEmailClients = csInfo.n.value('@LargestNoArchiveEmailClients', 'INTEGER'),
		@AvgRestoreThroughputGBPerHR = csInfo.n.value('@AvgRestoreThroughputGBPerHR', 'FLOAT'),
		@TopN = csInfo.n.value('@TopN', 'INTEGER')
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyLargestClientsByBKPSize
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		csInfo.n.value('@clientId', 'BIGINT'),
		csInfo.n.value('@clientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@applicationSizeGB', 'FLOAT'),
		csInfo.n.value('@ShareOfTotal', 'FLOAT'),
		csInfo.n.value('@TotalSizeGB', 'FLOAT'),
		ISNULL(csInfo.n.value('@appTypeId', 'INT'), 0)
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML/Client') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process Largest FS Clients
	INSERT INTO cf_SurveyLargestNoArchiveFSClients
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestFSClients,
		@LargestNoArchiveFSClients,
		@TopN,
		0, '', 0, '', 0
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestFSClients,
		@LargestNoArchiveFSClients,
		@TopN,
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT')
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML/NoArchiveClients') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process Largest Other Clients
	INSERT INTO cf_SurveyLargestNoSnapClients
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestAppClients,
		@LargestNoSnapAppClients,
		@AvgRestoreThroughputGBPerHR,
		@TopN,
		0, '', 0, '', 0, 0, 0
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestAppClients,
		@LargestNoSnapAppClients,
		@AvgRestoreThroughputGBPerHR,
		@TopN,
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT'),
		csInfo.n.value('@LastRestoreThroughputGBPerHR', 'FLOAT'),
		csInfo.n.value('@RecoverDurationTimeInSeconds', 'INT')
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML/NoSnapClients') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process Largest Email Clients
	INSERT INTO cf_SurveyLargestNoArcEmailClients
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestEmailClients,
		@LargestNoArchiveEmailClients,
		@TopN,
		0, '', 0, '', 0, 0
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@ClientGroups,
		@LargestEmailClients,
		@LargestNoArchiveEmailClients,
		@TopN,
		csInfo.n.value('@ClientId', 'BIGINT'),
		csInfo.n.value('@ClientName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppTypeId', 'BIGINT'),
		csInfo.n.value('@AppTypeName', 'NVARCHAR(MAX)'),
		csInfo.n.value('@AppSizeTB', 'FLOAT'),
		csInfo.n.value('@TotalWriteTimeHR', 'FLOAT')
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML/NoArchiveEmailClients') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Process CountsBySize
	INSERT INTO cf_SurveyClientCountBySize
	SELECT
		@ResultId,
		csInfo.n.value('@LowerLimitGB', 'BIGINT'),
		csInfo.n.value('@UpperLimitGB', 'BIGINT'),
		csInfo.n.value('@Range', 'VARCHAR(256)'),
		ISNULL(csInfo.n.value('@ClientCount', 'INTEGER'), 0),
		ISNULL(csInfo.n.value('@TotalSizeGB', 'BIGINT'), 0),
		ISNULL(csInfo.n.value('@AverageSizeGB', 'BIGINT'), 0)
	FROM
		@ResultXml.nodes('/LargestClientStatisticsXML/CountsBySize') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseLargestClientsByBKPSizeTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseLargestClientsByBKPSize')
	delete from GxQscripts where name = 'ParseLargestClientsByBKPSize'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseLargestClientsByBKPSize')
	delete from GXDBVersions where aliasname = 'ParseLargestClientsByBKPSize'
GO

insert into GXDBVersions values(2, 'ParseLargestClientsByBKPSize',  '00010005004800070000', 'ParseLargestClientsByBKPSize', '00010005004800070000')
GO

