

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseIndexFragmentation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseIndexFragmentation.sp,v $ $Id: ParseIndexFragmentation.sp,v 1.3.60.12 2020/12/17 02:51:08 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseIndexFragmentation')
BEGIN
	print '>>> Drop Stored Procedure: ParseIndexFragmentation <<<'
	drop procedure ParseIndexFragmentation
END
IF EXISTS (select * from GxQscripts where name='ParseIndexFragmentation')
	delete from GxQscripts where name = 'ParseIndexFragmentation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexFragmentation')
	delete from GXDBVersions where aliasname = 'ParseIndexFragmentation'
GO
print '... Creating Procedure: ParseIndexFragmentation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseIndexFragmentation
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseIndexFragmentationTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #IndexFragmentation (
	DatabaseName	VARCHAR(32),
	FragmentationPct INT,
	IndexCount		INT,
	ServerName		NVARCHAR(MAX),
	DbId			INT
)
CREATE TABLE #IndexFragmentationDetails (
	DatabaseName	VARCHAR(32),
	TableName		VARCHAR(MAX),
	IndexName		VARCHAR(MAX),
	IndexType		INT,
	AvgFragPercent	FLOAT(2),
	TableId			INT,
	IndexId			INT,
	RowsCount		INT,
	IndexFillFactor	INT,
	PageCount		INT,
	AvgFragSizePageCount	INT,
	PageSplitForIndex		INT,
	PageAllocByPageSplit	INT
)
DECLARE @LastFullReindexOperation INT
DECLARE @LastProactiveReindex INT
IF 	@ErrorCode = 0
BEGIN
	SELECT
		@LastFullReindexOperation =	ISNULL(overview.db.value('(@LastFullReindexOperation)[1]', 'INT'), 0),
		@LastProactiveReindex = ISNULL(overview.db.value('(@LastProactiveReindex)[1]', 'INT'), 0)
	FROM
		@ResultXml.nodes('/IndexFragmentation/FragmentationOverview') AS overview(db)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Inserting index count in each fragmentation window
	INSERT INTO #IndexFragmentation (DatabaseName, FragmentationPct, IndexCount, ServerName, DbId)
	SELECT
		indexfrag.db.value('@name', 'VARCHAR(32)'),
		indexfrag.db.value('@fragmentationPct', 'INT'),
		indexfrag.db.value('@indexCount', 'INT'),
		ISNULL(indexfrag.db.value('@serverName', 'NVARCHAR(MAX)'),''),
		ISNULL(indexfrag.db.value('@dbid', 'INT'), 0)
	FROM
		@ResultXml.nodes('/IndexFragmentation/Fragmentation') AS indexfrag(db)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Inserting details of all indexes
	INSERT INTO #IndexFragmentationDetails (DatabaseName, TableName, IndexName, IndexType, AvgFragPercent,
			TableId, IndexId, RowsCount, IndexFillFactor, PageCount, AvgFragSizePageCount, PageSplitForIndex, PageAllocByPageSplit)
	SELECT
		indexFrag.frag.value('@dbname', 'VARCHAR(32)'),
		indexFrag.frag.value('@tablename', 'VARCHAR(MAX)'),
		indexFrag.frag.value('@indexname', 'VARCHAR(MAX)'),
		indexFrag.frag.value('@indextype', 'INT'),
		indexFrag.frag.value('@avgFragPercent', 'FLOAT(2)'),
		ISNULL(indexFrag.frag.value('@tableid', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@indexid', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@rowCount', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@fillFactor', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@pageCount', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@avgFragSizePageCount', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@pageSplitForIndex', 'INT'), 0),
		ISNULL(indexFrag.frag.value('@pageAllocByPageSplit', 'INT'), 0)
	FROM
		@ResultXml.nodes('/IndexFragmentation/FragmentedIndex') AS indexFrag(frag)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Inserting index count in each fragmentation window
	INSERT INTO cf_SurveyIndexFragmentation (SurveyResultId, DatabaseName, FragmentationPct, IndexCount, ServerName, DbId,
			LastFullReindexOperation, LastProactiveReindexOperation)
	SELECT	@ResultId, DatabaseName, FragmentationPct, IndexCount, ServerName, DbId,
			@LastFullReindexOperation, @LastProactiveReindex
	FROM	#IndexFragmentation
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	--Inserting details of all indexes
	INSERT INTO cf_SurveyIndexFragmentationDetails (SurveyResultId, DatabaseName, TableName, IndexName, IndexType, AvgFragPercent,
			TableId, IndexId, RowsCount, IndexFillFactor, PageCount, AvgFragSizePageCount, PageSplitForIndex, PageAllocByPageSplit)
	SELECT	@ResultId, DatabaseName, TableName, IndexName, IndexType, AvgFragPercent,
			TableId, IndexId, RowsCount, IndexFillFactor, PageCount, AvgFragSizePageCount, PageSplitForIndex, PageAllocByPageSplit
	FROM	#IndexFragmentationDetails
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseIndexFragmentationTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseIndexFragmentation')
	delete from GxQscripts where name = 'ParseIndexFragmentation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseIndexFragmentation')
	delete from GXDBVersions where aliasname = 'ParseIndexFragmentation'
GO

insert into GXDBVersions values(2, 'ParseIndexFragmentation',  '00010003006000120000', 'ParseIndexFragmentation', '00010003006000120000')
GO

