

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseGrowingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseGrowingClients.sp,v $ $Id: ParseGrowingClients.sp,v 1.1.2.8 2020/12/17 02:48:29 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseGrowingClients')
BEGIN
	print '>>> Drop Stored Procedure: ParseGrowingClients <<<'
	drop procedure ParseGrowingClients
END
IF EXISTS (select * from GxQscripts where name='ParseGrowingClients')
	delete from GxQscripts where name = 'ParseGrowingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseGrowingClients')
	delete from GXDBVersions where aliasname = 'ParseGrowingClients'
GO
print '... Creating Procedure: ParseGrowingClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseGrowingClients
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseGrowingClientsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
CREATE TABLE #SurveyAgentGrowth
(
	SurveyResultId		bigint NOT NULL,
	nDaysAgo			int NOT NULL,
	appTypeId			int NOT NULL,
	appSizeMB			bigint NOT NULL,
	growthMB			bigint NOT NULL
)
CREATE TABLE #SurveyClientGrowthBucket
(
	SurveyResultId		bigint NOT NULL,
	nDaysAgo			int NOT NULL,
	rangeGB				varchar(16) NOT NULL,
	fromMB				bigint NOT NULL,
	toMB				bigint NOT NULL,
	nClients			int NOT NULL
)
CREATE TABLE #SurveyGrowingClients
(
	SurveyResultId		bigint NOT NULL,
	nDaysAgo			int NOT NULL,
	clientId			int NOT NULL,
	appId				int NOT NULL,
	appSizeMB			bigint NOT NULL,
	growthMB			bigint NOT NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyAgentGrowth
		(SurveyResultId,
		nDaysAgo,
		appTypeId,
		appSizeMB,
		growthMB)
	SELECT
		@ResultId,
		csInfo.n.value('@nDaysAgo', 'INTEGER'),
		csInfo.n.value('@appTypeId', 'INTEGER'),
		csInfo.n.value('@appSizeMB', 'BIGINT'),
		csInfo.n.value('@growthMB', 'BIGINT')
	FROM
		@ResultXml.nodes('/AgentGrowth') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyClientGrowthBucket
		(SurveyResultId,
		nDaysAgo,
		rangeGB,
		fromMB,
		toMB,
		nClients)
	SELECT
		@ResultId,
		csInfo.n.value('@nDaysAgo', 'INTEGER'),
		csInfo.n.value('@rangeGB', 'VARCHAR(16)'),
		csInfo.n.value('@fromMB', 'BIGINT'),
		csInfo.n.value('@toMB', 'BIGINT'),
		csInfo.n.value('@nClients', 'INTEGER')
	FROM
		@ResultXml.nodes('/ClientGrowthBucket') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #SurveyGrowingClients
		(SurveyResultId,
		nDaysAgo,
		clientId,
		appId,
		appSizeMB,
		growthMB)
	SELECT
		@ResultId,
		csInfo.n.value('@nDaysAgo', 'INTEGER'),
		csInfo.n.value('@clientId', 'INTEGER'),
		csInfo.n.value('@appId', 'INTEGER'),
		csInfo.n.value('@appSizeMB', 'BIGINT'),
		csInfo.n.value('@growthMB', 'BIGINT')
	FROM
		@ResultXml.nodes('/TopGrowingClients') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyAgentGrowth
			(SurveyResultId,
			nDaysAgo,
			appTypeId,
			appSizeMB,
			growthMB)
	SELECT	SurveyResultId,
			nDaysAgo,
			appTypeId,
			appSizeMB,
			growthMB
	FROM	#SurveyAgentGrowth
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyClientGrowthBucket
			(SurveyResultId,
			nDaysAgo,
			rangeGB,
			fromMB,
			toMB,
			nClients)
	SELECT	SurveyResultId,
			nDaysAgo,
			rangeGB,
			fromMB,
			toMB,
			nClients
	FROM	#SurveyClientGrowthBucket
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyGrowingClients
			(SurveyResultId,
			nDaysAgo,
			clientId,
			appId,
			appSizeMB,
			growthMB)
	SELECT	SurveyResultId,
			nDaysAgo,
			clientId,
			appId,
			appSizeMB,
			growthMB
	FROM	#SurveyGrowingClients
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseGrowingClientsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseGrowingClients')
	delete from GxQscripts where name = 'ParseGrowingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseGrowingClients')
	delete from GXDBVersions where aliasname = 'ParseGrowingClients'
GO

insert into GXDBVersions values(2, 'ParseGrowingClients',  '00010001000200080000', 'ParseGrowingClients', '00010001000200080000')
GO

