

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseFailingClients.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseFailingClients.sp,v $ $Id: ParseFailingClients.sp,v 1.5.42.13 2020/12/18 18:57:36 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseFailingClients')
BEGIN
	print '>>> Drop Stored Procedure: ParseFailingClients <<<'
	drop procedure ParseFailingClients
END
IF EXISTS (select * from GxQscripts where name='ParseFailingClients')
	delete from GxQscripts where name = 'ParseFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFailingClients')
	delete from GXDBVersions where aliasname = 'ParseFailingClients'
GO
print '... Creating Procedure: ParseFailingClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseFailingClients
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseFailingClientsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF OBJECT_ID('tempdb..#StrikeDetails') IS NOT NULL
	DROP TABLE #StrikeDetails
CREATE TABLE #StrikeDetails
(
	StrikeCounts		int NULL,
	ClientId			int NULL,
	AppId				int NULL,
	BackupType			nvarchar(25) NULL,
	FailedFrom			datetime NULL,
	FailedDays			int NULL,
	LastJobId			int NULL,
	LastJobStartTime	datetime NULL,
	LastJobEndTime		datetime NULL,
	LastJobStatus		nvarchar(32) NULL,
	FailureMsgIds		nvarchar(max) NULL,
	FailureReason		nvarchar(max) NULL,
	LastSJobId			int NULL,
	lastSJobStartTime	datetime NULL,
	lastSJobEndTime		datetime NULL,
	FailedJobIds		varchar(64) NULL
)
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #StrikeDetails (
			ClientId, AppId, StrikeCounts, BackupType, FailedFrom, FailedDays,
			LastJobId, LastJobStartTime, LastJobEndTime, LastJobStatus, FailureMsgIds, FailureReason,
			LastSJobId, LastSJobStartTime, LastSJobEndTime, FailedJobIds
			)
	SELECT
		csInfo.n.value('@clientId', 'INTEGER'),
		csInfo.n.value('@SubclientId', 'INTEGER'),
		csInfo.n.value('@StrikeCounts', 'INTEGER'),
		csInfo.n.value('@backupType', 'NVARCHAR(25)'),
		csInfo.n.value('@FailedFrom', 'DATETIME'),
		csInfo.n.value('@FailedDays', 'INTEGER'),
		csInfo.n.value('@lasJobId', 'INTEGER'),
		csInfo.n.value('@lastJobStartTime', 'DATETIME'),
		csInfo.n.value('@lastJobEndTime', 'DATETIME'),
		csInfo.n.value('@lastJobStatus', 'NVARCHAR(32)'),
		csInfo.n.value('@errorCode', 'NVARCHAR(MAX)'),
		csInfo.n.value('@FailureReason', 'NVARCHAR(MAX)'),
		csInfo.n.value('@LastSJobId', 'INTEGER'),
		csInfo.n.value('@lastSJobStartTime', 'DATETIME'),
		csInfo.n.value('@lastSJobEndTime', 'DATETIME'),
		csInfo.n.value('@failedJobIds', 'VARCHAR(64)')
	FROM
		@ResultXml.nodes('/ContinuousFailedClients/Client') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	UPDATE	#StrikeDetails SET FailedJobIds = LEFT(FailedJobIds, LEN(FailedJobIds)-1)
	WHERE	FailedJobIds IS NOT NULL AND RIGHT(FailedJobIds,2) = ', '
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	declare @prevResId INT = (select MAX(SurveyResultId) FROM cf_SurveyStrikeDetails)
	update S
	set S.FailureMsgIds = SD.FailureMsgIds
	from #StrikeDetails S
	INNER JOIN cf_SurveyStrikeDetails SD with (nolock) ON S.LastJobId = SD.LastJobId
	where S.FailureMsgIds = '' and SD.SurveyResultId = @prevResId
	INSERT INTO cf_SurveyStrikeDetails (
			SurveyResultId, ClientId, AppId, StrikeCounts, BackupType, FailedFrom, FailedDays,
			LastJobId, LastJobStartTime, LastJobEndTime, LastJobStatus, FailureMsgIds, FailureReason,
			LastSJobId, lastSJobStartTime, lastSJobEndTime, FailedJobIds
			)
	SELECT	@ResultId, ClientId, AppId, StrikeCounts, BackupType, FailedFrom, FailedDays,
			LastJobId, LastJobStartTime, LastJobEndTime, LastJobStatus, FailureMsgIds, FailureReason,
			LastSJobId, lastSJobStartTime, lastSJobEndTime, FailedJobIds
	FROM	#StrikeDetails
	WHERE	AppId > 0
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	create table #tmpstrikes (strikes INT, ErrorCode nvarchar(max))
	INSERT INTO #tmpstrikes
	SELECT (CASE WHEN StrikeCounts=1 THEN 1 WHEN StrikeCounts=2 THEN 2 WHEN StrikeCounts>=3 THEN 3 ELSE 0 END),
	 case
		when FailureMsgIds =  '' then FailureMsgIds
		when charindex(';',left(FailureMsgIds,len(FailureMsgIds)-1)) =  0 then left(FailureMsgIds,len(FailureMsgIds)-1)
		else reverse(left(reverse(LEFT(FailureMsgIds,len(FailureMsgIds)-1)),charindex(';', reverse(LEFT(FailureMsgIds,len(FailureMsgIds)-1)))-1)) end
	FROM #StrikeDetails
	WHERE AppId > 0
	declare @today date = (select convert(date,GETDATE()))
	DECLARE @lastModifiedDate DATE = (SELECT MAX(DayStart) from cf_SurveyDailyStrikes where CommServUniqueId = @CSUniqueId)
	if @lastModifiedDate IS NOT NULL AND @today = @lastModifiedDate
	BEGIN
		DELETE A
		FROM cf_SurveyDailyStrikes A
		WHERE CommServUniqueId = @CSUniqueId and DayStart = @today
	END
	insert into cf_SurveyDailyStrikes
	select @CSUniqueId,@today, ErrorCode,
		ISNULL(SUM(case when strikes=3 then 1 else 0 end),0),
		ISNULL(SUM(case when strikes=2 then 1 else 0 end),0),
		ISNULL(SUM(case when strikes=1 then 1 else 0 end),0)
	from #tmpstrikes
	group by ErrorCode
	HAVING ErrorCode NOT IN ('19:1253','19:666','19:583','19:1131','19:1132','19:861','19:757')
	--sum of strikes for a day
	insert into cf_SurveyDailyStrikes
	select @CSUniqueId,@today, '-1',
		ISNULL(SUM(Strike3),0),
		ISNULL(SUM(Strike2),0),
		ISNULL(SUM(Strike1),0)
	from cf_SurveyDailyStrikes
	where CommServUniqueId = @CSUniqueId and DayStart = @today
	DECLARE @FirstDayofMonth DATE = CONVERT(DATE, DATEADD(mm, DATEDIFF(mm,0,GETDATE()), 0))
	delete
	from cf_SurveyMonthlyStrikes
	where MonthStart = @FirstDayofMonth and CommServUniqueId = @CSUniqueId
	insert into cf_SurveyMonthlyStrikes(CommServUniqueId, MonthStart, Strike0, Strike1, Strike2, Strike3, ClientsProtected, VMClientsProtected)
	select @CSUniqueId, @FirstDayofMonth, 0, ISNULL(sum(Strike1),0), ISNULL(sum(Strike2),0), ISNULL(sum(Strike3),0), 0, 0
	from cf_SurveyDailyStrikes
	where ErrorCode = '-1' and CommServUniqueId = @CSUniqueId and DayStart>=@FirstDayofMonth
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseFailingClientsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseFailingClients')
	delete from GxQscripts where name = 'ParseFailingClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseFailingClients')
	delete from GXDBVersions where aliasname = 'ParseFailingClients'
GO

insert into GXDBVersions values(2, 'ParseFailingClients',  '00010005004200130000', 'ParseFailingClients', '00010005004200130000')
GO

