

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseEndusers.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseEndusers.sp,v $ $Id: ParseEndusers.sp,v 1.1.2.2 2020/12/17 02:54:17 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseEndusers')
BEGIN
	print '>>> Drop Stored Procedure: ParseEndusers <<<'
	drop procedure ParseEndusers
END
IF EXISTS (select * from GxQscripts where name='ParseEndusers')
	delete from GxQscripts where name = 'ParseEndusers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseEndusers')
	delete from GXDBVersions where aliasname = 'ParseEndusers'
GO
print '... Creating Procedure: ParseEndusers'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseEndusers
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseEndusersTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @FileName NVARCHAR(1024)
SELECT  @FileName = CAST(CollectedResults as NVARCHAR(1024))
FROM    cf_CommservSurveyResults WITH(NOLOCK)
WHERE   CommservSurveyResults_ID = @ResultId
SELECT @ErrorCode = @@ERROR
IF OBJECT_ID('tempdb..#SurveyEndusers') IS NOT NULL
    DROP TABLE #SurveyEndusers
CREATE TABLE #SurveyEndusers (UserId INT, UserName NVARCHAR(1024), UserLogin NVARCHAR(1024), UserEmail NVARCHAR(1024), UserType INT, Associations NVARCHAR(1024))
IF 	@ErrorCode = 0
BEGIN
	DECLARE @sql NVARCHAR(256) = 'BULK INSERT #SurveyEndusers FROM ''' + @FileName + ''' WITH ( FIELDTERMINATOR ='','', ROWTERMINATOR =''\n'' )';
	EXEC(@sql);
	SELECT @ErrorCode = @@ERROR
END
IF EXISTS (SELECT 1 FROM #SurveyEndusers)
BEGIN
	IF 	@ErrorCode = 0
	BEGIN
		--handle comma in the column values
		UPDATE #SurveyEndusers SET
		UserName = CASE WHEN UserName IS NOT NULL AND CHARINDEX('<COMMA>', UserName) > 0 THEN REPLACE (UserName,'<COMMA>',',')
                        ELSE UserName
                   END,
		UserLogin = CASE WHEN UserLogin IS NOT NULL AND CHARINDEX('<COMMA>', UserLogin) > 0 THEN REPLACE (UserLogin,'<COMMA>',',')
                        ELSE UserLogin
                   END,
		UserEmail = CASE WHEN UserEmail IS NOT NULL AND CHARINDEX('<COMMA>', UserEmail) > 0 THEN REPLACE (UserEmail,'<COMMA>',',')
                        ELSE UserEmail
                   END,
		Associations = CASE WHEN Associations IS NOT NULL AND CHARINDEX('<COMMA>', Associations) > 0 THEN REPLACE (Associations,'<COMMA>',',')
                        ELSE Associations
                   END
		SELECT @ErrorCode = @@ERROR
	END
	IF 	@ErrorCode = 0
	BEGIN
		MERGE cf_SurveyEndusers AS T
		USING (SELECT DISTINCT UserId, UserName, UserLogin, UserEmail, UserType, Associations FROM #SurveyEndusers) AS S
		ON T.UserId = S.UserId AND T.UserType = S.UserType AND T.CommServUniqueId = @CSUniqueId
		WHEN MATCHED
			THEN UPDATE SET T.UserName=S.UserName, T.UserLogin=S.UserLogin, T.UserEmail=S.UserEmail, T.Associations=S.Associations, T.ModifiedTime=GETUTCDATE()
		WHEN NOT MATCHED BY TARGET
			THEN INSERT (CommservUniqueId, UserId, UserName, UserLogin, UserEmail, UserType, Associations, ModifiedTime)
			VALUES(@CSUniqueId, UserId, UserName, UserLogin, UserEmail, UserType, Associations, GETUTCDATE())
		;
		SELECT @ErrorCode = @@ERROR
	END
END
IF OBJECT_ID('tempdb..#SurveyEndusers') IS NOT NULL DROP TABLE #SurveyEndusers
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseEndusersTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseEndusers')
	delete from GxQscripts where name = 'ParseEndusers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseEndusers')
	delete from GXDBVersions where aliasname = 'ParseEndusers'
GO

insert into GXDBVersions values(2, 'ParseEndusers',  '00010001000200020000', 'ParseEndusers', '00010001000200020000')
GO

