

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDeDupRatioBySPCopy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDeDupRatioBySPCopy.sp,v $ $Id: ParseDeDupRatioBySPCopy.sp,v 1.3.60.9 2020/12/17 02:51:05 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDeDupRatioBySPCopy')
BEGIN
	print '>>> Drop Stored Procedure: ParseDeDupRatioBySPCopy <<<'
	drop procedure ParseDeDupRatioBySPCopy
END
IF EXISTS (select * from GxQscripts where name='ParseDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'ParseDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'ParseDeDupRatioBySPCopy'
GO
print '... Creating Procedure: ParseDeDupRatioBySPCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDeDupRatioBySPCopy
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDeDupRatioBySPCopyTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
DECLARE @LastNDays			INT
DECLARE @PrimCopies			INT
DECLARE @DeDupPrimCopies	INT
DECLARE @TotalAppSizeGB		FLOAT
DECLARE @TotalSizeOnMediaGB	FLOAT
IF 	@ErrorCode = 0
BEGIN
	SELECT
		@LastNDays			= csInfo.n.value('@LastNDays', 'INTEGER'),
		@PrimCopies			= csInfo.n.value('@PrimCopies', 'INTEGER'),
		@DeDupPrimCopies	= csInfo.n.value('@DeDupPrimCopies', 'INTEGER'),
		@TotalAppSizeGB		= csInfo.n.value('@TotalAppSizeGB', 'FLOAT'),
		@TotalSizeOnMediaGB	= csInfo.n.value('@TotalSizeOnMediaGB', 'FLOAT')
	FROM
		@ResultXml.nodes('/DedupeRatioByCopy') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO cf_SurveyDDBRatioBySPCopy
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@LastNDays,
		'',
		'',
		'',
		0,
		0,
		0,
		0,
		0,
		@PrimCopies,
		@DeDupPrimCopies,
		@TotalAppSizeGB,
		@TotalSizeOnMediaGB
	UNION ALL
	SELECT
		@CSUniqueId,
		@ResultId,
		@LogDateUTC,
		@LogDate,
		@LastNDays,
		csInfo.n.value('@storagePolicy', 'NVARCHAR(256)'),
		csInfo.n.value('@copy', 'NVARCHAR(256)'),
		csInfo.n.value('@weekStartDate', 'DATETIME'),
		csInfo.n.value('@appSizeGB', 'DECIMAL(20,2)'),
		csInfo.n.value('@sizeOnMediaGB', 'DECIMAL(20,2)'),
		csInfo.n.value('@dedupeRatio', 'DECIMAL(20,2)'),
		csInfo.n.value('@jobs', 'INTEGER'),
		csInfo.n.value('@clients', 'INTEGER'),
		@PrimCopies,
		@DeDupPrimCopies,
		@TotalAppSizeGB,
		@TotalSizeOnMediaGB
	FROM
		@ResultXml.nodes('/DedupeRatioByCopy/Copy') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
DECLARE @isPrivate 			INT = 0
SELECT	@isPrivate = ISNULL(CAST(Value AS INT), 0) FROM cf_SurveyConfig WITH (NOLOCK) WHERE Name = 'isPrivate'
IF(@isPrivate = 0)
BEGIN
    DECLARE @LastDate DATETIME
	IF @ErrorCode = 0
	BEGIN
		SET @LastDate = ISNULL((SELECT CAST(MAX(EndDate) AS DATETIME) FROM cf_SurveyDailyDDBRatioByCommCell WITH (NOLOCK) WHERE CommServUniqueId = @CSUniqueId), 0)
		SELECT @ErrorCode = @@ERROR
	END
	IF object_id('tempdb.dbo.#tmpAggregateDDBRatio') IS NOT null DROP TABLE #tmpAggregateDDBRatio
	CREATE TABLE #tmpAggregateDDBRatio (
        CommservUniqueId INT,
		EndDate DATE,
		TotalAppSizeGB FLOAT,
		TotalSizeOnMediaGB FLOAT,
		DedupeRatio DECIMAL(10,2))
	IF  @ErrorCode = 0
	    BEGIN
			INSERT INTO #tmpAggregateDDBRatio
			SELECT DISTINCT B.CommServUniqueId,
				   CAST(B.LogDate AS DATE) AS EndDate,
				   B.TotalAppSize,
				   B.TotalSizeOnMedia,
				   CAST(((TotalSizeOnMedia*100.0)/ (CASE WHEN TotalAppSize=0 THEN 1 ELSE TotalAppSize END)) AS DECIMAL(10,2)) AS DedupeRatio
			FROM cf_SurveyDDBRatioBySPCopy B WITH (NOLOCK)
			INNER JOIN (SELECT  CommServUniqueId,CAST(LogDate AS DATE)AS LogDate  ,max(SurveyResultId) AS SurveyResultId from cf_SurveyDDBRatioBySPCopy (nolock)
                  WHERE LogDate >= @LastDate AND CommServUniqueId = @CSUniqueId GROUP BY CommServUniqueId, CAST(LogDate AS DATE)   ) SUB
			ON B.SurveyResultId = SUB.SurveyResultId AND B.CommServUniqueId = SUB.CommServUniqueId
			SELECT @ErrorCode = @@ERROR
		END
	IF  @ErrorCode = 0
	    BEGIN
			MERGE cf_SurveyDailyDDBRatioByCommCell AS T
			USING #tmpAggregateDDBRatio S
	            ON T.CommServUniqueId = S.CommServUniqueId AND T.EndDate = S.EndDate
			WHEN MATCHED THEN
				UPDATE SET appSizeGB = S.TotalAppSizeGB, sizeOnMediaGB = S.TotalSizeOnMediaGB , DedupeRatio = S.DedupeRatio
			WHEN NOT MATCHED THEN
	            INSERT (CommServUniqueId, EndDate, appSizeGB, sizeOnMediaGB, DedupeRatio)
				VALUES (S.CommServUniqueId, S.EndDate, S.TotalAppSizeGB, S.TotalSizeOnMediaGB, S.DedupeRatio);
			SELECT @ErrorCode = @@ERROR
		END
	DROP TABLE #tmpAggregateDDBRatio
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDeDupRatioBySPCopyTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDeDupRatioBySPCopy')
	delete from GxQscripts where name = 'ParseDeDupRatioBySPCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDeDupRatioBySPCopy')
	delete from GXDBVersions where aliasname = 'ParseDeDupRatioBySPCopy'
GO

insert into GXDBVersions values(2, 'ParseDeDupRatioBySPCopy',  '00010003006000090000', 'ParseDeDupRatioBySPCopy', '00010003006000090000')
GO

