

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDailyDataRetentionStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDailyDataRetentionStats.sp,v $ $Id: ParseDailyDataRetentionStats.sp,v 1.1.2.8 2020/12/17 02:54:11 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDailyDataRetentionStats')
BEGIN
	print '>>> Drop Stored Procedure: ParseDailyDataRetentionStats <<<'
	drop procedure ParseDailyDataRetentionStats
END
IF EXISTS (select * from GxQscripts where name='ParseDailyDataRetentionStats')
	delete from GxQscripts where name = 'ParseDailyDataRetentionStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDailyDataRetentionStats')
	delete from GXDBVersions where aliasname = 'ParseDailyDataRetentionStats'
GO
print '... Creating Procedure: ParseDailyDataRetentionStats'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDailyDataRetentionStats
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDailyDataRetentionStatsTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF object_id('tempdb.dbo.#tmpDailyJobs') IS NOT null DROP TABLE #tmpDailyJobs
CREATE TABLE #tmpDailyJobs
(
	CommServUniqueId INT,
	JobEndDate DATETIME,
	ShortTermRetJobsCount BIGINT,
	LongTermRetJobsCount BIGINT,
	ShortRetBackupSize BIGINT,
	LongRetBackupSize BIGINT
)
IF object_id('tempdb.dbo.#tmpAggregateJobs') IS NOT null DROP TABLE #tmpAggregateJobs
CREATE TABLE #tmpAggregateJobs
(
	CommServUniqueId INT,
	MonthStart DATETIME,
	ShortTermRetJobsCount BIGINT,
	LongTermRetJobsCount BIGINT,
	ShortRetBackupSize BIGINT,
	LongRetBackupSize BIGINT
)
DECLARE @LastDate DATETIME
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #tmpDailyJobs
	SELECT
		@CSUniqueId,
		csInfo.n.value('@JobEndDate', 'DATE'),
		csInfo.n.value('@ShortTermRetJobsCount', 'BIGINT'),
		csInfo.n.value('@LongTermRetJobsCount', 'BIGINT'),
		csInfo.n.value('@ShortTermRetSize', 'BIGINT'),
		csInfo.n.value('@LongTermRetSize', 'BIGINT')
	FROM
		@ResultXml.nodes('/DailyBackupRetention/DataStats') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	SET @LastDate = (SELECT MAX(JobEndDate) FROM cf_SurveyDailyDataRetentionStats WHERE CommServUniqueId = @CSUniqueId)
	DELETE	#tmpDailyJobs WHERE JobEndDate < @LastDate
	MERGE cf_SurveyDailyDataRetentionStats AS T
	USING #tmpDailyJobs S
		ON T.CommServUniqueId = S.CommServUniqueId AND T.JobEndDate = S.JobEndDate
	WHEN MATCHED THEN
		UPDATE SET ShortTermRetJobsCount += S.ShortTermRetJobsCount, LongTermRetJobsCount += S.LongTermRetJobsCount, ShortRetBackupSize += S.ShortRetBackupSize, LongRetBackupSize += S.LongRetBackupSize
	WHEN NOT MATCHED THEN
		INSERT (CommServUniqueId, JobEndDate, ShortTermRetJobsCount, LongTermRetJobsCount, ShortRetBackupSize, LongRetBackupSize)
		VALUES (S.CommServUniqueId, S.JobEndDate, S.ShortTermRetJobsCount, S.LongTermRetJobsCount, S.ShortRetBackupSize, LongRetBackupSize);
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	INSERT INTO #tmpAggregateJobs
	SELECT	CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0),
			SUM(ShortTermRetJobsCount), SUM(LongTermRetJobsCount), SUM(ShortRetBackupSize), SUM(LongRetBackupSize)
	FROM	#tmpDailyJobs
	GROUP BY CommServUniqueId, DATEADD(MONTH, DATEDIFF(MONTH, 0, JobEndDate), 0)
	SELECT @ErrorCode = @@ERROR
END
IF 	@ErrorCode = 0
BEGIN
	MERGE cf_SurveyMonthlyDataRetentionStats AS T
	USING #tmpAggregateJobs S
		ON T.CommServUniqueId = S. CommServUniqueId AND T.MonthStart = S.MonthStart
	WHEN MATCHED THEN
		UPDATE SET ShortTermRetJobsCount += S.ShortTermRetJobsCount, LongTermRetJobsCount += S.LongTermRetJobsCount, ShortRetBackupSize += S.ShortRetBackupSize, LongRetBackupSize += S.LongRetBackupSize
	WHEN NOT MATCHED THEN
		INSERT (CommServUniqueId, MonthStart, ShortTermRetJobsCount, LongTermRetJobsCount, ShortRetBackupSize, LongRetBackupSize)
		VALUES (S.CommServUniqueId, S.MonthStart, S.ShortTermRetJobsCount, S.LongTermRetJobsCount, S.ShortRetBackupSize, LongRetBackupSize);
	SELECT @ErrorCode = @@ERROR
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDailyDataRetentionStatsTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDailyDataRetentionStats')
	delete from GxQscripts where name = 'ParseDailyDataRetentionStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDailyDataRetentionStats')
	delete from GXDBVersions where aliasname = 'ParseDailyDataRetentionStats'
GO

insert into GXDBVersions values(2, 'ParseDailyDataRetentionStats',  '00010001000200080000', 'ParseDailyDataRetentionStats', '00010001000200080000')
GO

