

--  ------------  Generated from [../../../Source/CommServer/CloudDB/Sp/ParseDRBkpConfiguration.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/CloudDB/Sp/ParseDRBkpConfiguration.sp,v $ $Id: ParseDRBkpConfiguration.sp,v 1.4.60.11 2020/12/17 02:54:32 dkraplanee Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='ParseDRBkpConfiguration')
BEGIN
	print '>>> Drop Stored Procedure: ParseDRBkpConfiguration <<<'
	drop procedure ParseDRBkpConfiguration
END
IF EXISTS (select * from GxQscripts where name='ParseDRBkpConfiguration')
	delete from GxQscripts where name = 'ParseDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'ParseDRBkpConfiguration'
GO
print '... Creating Procedure: ParseDRBkpConfiguration'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure ParseDRBkpConfiguration
  @QueryId INTEGER,
  @ResultId BIGINT,
  @CSUniqueId INTEGER,
  @LogDateUTC DATETIME,
  @LogDate DATETIME,
  @LogLevel INTEGER = 0
AS
SET NOCOUNT ON 
  DECLARE @StartDate DATETIME = GETUTCDATE() 
  DECLARE @TempDate  DATETIME 
  DECLARE @Duration  INTEGER = 0 
  DECLARE @SkipOnErr INTEGER = 1 
  DECLARE @ErrorCode INTEGER = 0 
  DECLARE @ErrorMsg  NVARCHAR(MAX) 
  DECLARE @LogString NVARCHAR(MAX) 
  IF @LogLevel > 1 
  BEGIN 
  	SELECT @LogString = 'Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ') - started' 
  	INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET @LogString = '' 
  BEGIN TRY 
  	BEGIN TRANSACTION ParseDRBkpConfigurationTran 
  	SELECT @ErrorCode = @@ERROR
--  QUERY SPECIFIC CODE BEGIN --
DECLARE @ResultXml XML = (SELECT CollectedResults FROM cf_CommservSurveyResults WITH (NOLOCK) WHERE CommservSurveyResults_ID = @ResultId)
IF 	@ErrorCode = 0
BEGIN
	DECLARE @fullJobsToRetain	INTEGER
	DECLARE @usingNetworkPath	NVARCHAR(20)
	DECLARE @logFilesToBackup	NVARCHAR(MAX)
	DECLARE @writingToTape		NVARCHAR(20)
	DECLARE @useCommvaultCloud	INTEGER
	DECLARE @useThirdpartyCloud INTEGER
	DECLARE @cloudDeviceTypeId	INTEGER
	SELECT
		@fullJobsToRetain	= csInfo.n.value('@fullJobsToRetain', 'INTEGER'),
		@usingNetworkPath	= csInfo.n.value('@usingNetworkPath', 'NVARCHAR(20)'),
		@logFilesToBackup	= csInfo.n.value('@logFilesToBackup', 'NVARCHAR(MAX)'),
		@writingToTape		= csInfo.n.value('@writingToTape', 'NVARCHAR(20)'),
		@useCommvaultCloud	= csInfo.n.value('@useCommvaultCloud', 'INTEGER'),
		@useThirdpartyCloud = csInfo.n.value('@useThirdpartyCloud', 'INTEGER'),
		@cloudDeviceTypeId	= csInfo.n.value('@thirdpartyCloudDeviceTypeId', 'INTEGER')
	FROM
		@ResultXml.nodes('DRBackupConfigurationInfo') AS csInfo(n)
	SELECT @ErrorCode = @@ERROR
	IF 	@ErrorCode = 0
	BEGIN
		CREATE TABLE #Schedule (Schedule NVARCHAR(20), LastJobId INTEGER, ScheduleName NVARCHAR(MAX))
		INSERT INTO #Schedule (Schedule, LastJobId, ScheduleName)
		SELECT
			csInfo.n.value('@scheduleName', 'NVARCHAR(20)'),
			ISNULL(csInfo.n.value('@lastJobId', 'INTEGER'),-1),
			ISNULL(csInfo.n.value('@scheduleFullName', 'NVARCHAR(MAX)'),'')
		FROM
			@ResultXml.nodes('DRBackupConfigurationInfo/schInfo/Schedule') AS csInfo(n)
		WHERE
			csInfo.n.value('@scheduleName', 'NVARCHAR(20)') IS NOT NULL
		SELECT @ErrorCode = @@ERROR
		IF 	@ErrorCode = 0
		BEGIN
			IF EXISTS (SELECT 1 FROM #Schedule)
				INSERT INTO cf_SurveyDRBkpConfiguration(
					CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
					FullJobsToRetain,
					IsUingNetworkPath,
					LogFilesToBackup,
					WritingToTape,
					Schedule,
					LastJobId,
					ScheduleName,
					UseCommvaultCloud,
					UseThirdpartyCloud,
					CloudDeviceTypeId)
				SELECT
					@CSUniqueId, @ResultId, @LogDateUTC, @LogDate,
					@fullJobsToRetain,
					@usingNetworkPath,
					@logFilesToBackup,
					@writingToTape,
					ISNULL(Schedule,''),
					ISNULL(LastJobId,-1),
					ISNULL(ScheduleName,''),
					@useCommvaultCloud,
					@useThirdpartyCloud,
					@cloudDeviceTypeId
				FROM #Schedule
			ELSE
				INSERT INTO cf_SurveyDRBkpConfiguration(
					CommServUniqueId, SurveyResultId, LogDateUTC, LogDate,
					FullJobsToRetain,
					IsUingNetworkPath,
					LogFilesToBackup,
					WritingToTape,
					Schedule,
					LastJobId,
					ScheduleName,
					UseCommvaultCloud,
					UseThirdpartyCloud,
					CloudDeviceTypeId)
				SELECT
					@CSUniqueId, @ResultId, @LogDateUTC, @LogDate,
					@fullJobsToRetain,
					@usingNetworkPath,
					@logFilesToBackup,
					@writingToTape,
					'',
					-1,
					'',
					@useCommvaultCloud,
					@useThirdpartyCloud,
					@cloudDeviceTypeId
		END
		SELECT @ErrorCode = @@ERROR
	END
END
--  QUERY SPECIFIC CODE END --
IF @ErrorCode = 0 
  	BEGIN 
  		DECLARE	@ResultFlagsTbl TABLE (ResultId BIGINT, Flags INT) 
  		DECLARE	@LatestParsedResultId BIGINT = 0 
  		SELECT	@LatestParsedResultId = CommservSurveyResults_ID 
  		FROM	cf_CommservSurveyResults 
  		WHERE	QueryId = @QueryId AND CommcellIdNameMap_ID = @CSUniqueId AND Flags = 1 
  		SELECT @ErrorCode = @@ERROR 
  		IF @ErrorCode = 0 
  		BEGIN 
  			IF @LatestParsedResultId = 0 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 
  			ELSE IF @LatestParsedResultId < @ResultId 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 1 UNION SELECT @LatestParsedResultId, 0 
  			ELSE 
  				INSERT INTO @ResultFlagsTbl SELECT @ResultId, 0 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  		IF @ErrorCode = 0 
  		BEGIN 
  			UPDATE	R SET ShredStatus = 2, Flags = F.Flags, CollectedResults = NULL 
  			FROM	cf_CommservSurveyResults R 
  					INNER JOIN @ResultFlagsTbl F ON R.CommservSurveyResults_ID = F.ResultId 
  			SELECT @ErrorCode = @@ERROR 
  		END 
  	END 
  	IF @ErrorCode = 0 AND XACT_STATE() = 1 
  	BEGIN 
  		COMMIT TRANSACTION ParseDRBkpConfigurationTran 
  		SELECT @ErrorCode = @@ERROR 
  	END 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	IF @ErrorCode = 0 AND @LogLevel > 1 
  		SET @LogString += ' - Completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  	ELSE IF @ErrorCode <> 0 AND @SkipOnErr = 0 
  		SET @LogString += ' - Failed to update status after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  	ELSE IF @ErrorCode <> 0 
  		SET @LogString += ' - Failed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20)) 
  END TRY 
  BEGIN CATCH 
  	SELECT @ErrorCode = ERROR_NUMBER(), @ErrorMsg = ERROR_MESSAGE() 
  	SET	@Duration = DATEDIFF(SS, @StartDate, GETUTCDATE()) 
  	SET @LogString += ' - Exception in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec). ERROR CODE: ' + CAST(@ErrorCode AS VARCHAR(20))+ ' ERROR MESSAGE: ' + ISNULL(@ErrorMsg, '') 
  END CATCH 
  IF @@TRANCOUNT > 0 
  BEGIN 
      SET @LogString += ' - Rollback uncommitted transaction after ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
      SET @TempDate = GETUTCDATE() 
      ROLLBACK TRANSACTION 
      SET	@Duration = DATEDIFF(SS, @TempDate, GETUTCDATE()) 
      SET @LogString += ' - Rollback completed in ' + CAST(@Duration AS VARCHAR(10)) + ' (sec).' 
  END 
  IF @ErrorCode <> 0 AND @SkipOnErr > 0 
      UPDATE cf_CommservSurveyResults SET ShredStatus = 3 WHERE CommservSurveyResults_ID = @ResultId 
  IF @LogString <> '' 
  BEGIN 
      SET @LogString = ('Parsing result ' + CAST(@ResultId AS VARCHAR(20)) + ' (QueryId: ' + CAST(@QueryId AS VARCHAR(20)) + ', CSUniqueId: ' + CAST(@CSUniqueId AS VARCHAR(20)) + ')' + @LogString) 
      INSERT INTO cf_SurveyLogger(Message) VALUES(@LogString) 
  END 
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ParseDRBkpConfiguration')
	delete from GxQscripts where name = 'ParseDRBkpConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ParseDRBkpConfiguration')
	delete from GXDBVersions where aliasname = 'ParseDRBkpConfiguration'
GO

insert into GXDBVersions values(2, 'ParseDRBkpConfiguration',  '00010004006000110000', 'ParseDRBkpConfiguration', '00010004006000110000')
GO

